/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.AbstractOutput;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;

public class ModelOutPut
extends AbstractOutput {
    private static final String all_dims = "all_dims";
    private static final String default_number = "default_number";
    private static final String back_number = "back_number";
    private static final String all_dims_idnumber = "all_dims_idnumber";
    private static final String single_Dim_Mapping = "singleDimMapping";
    private static final String InterCompany = "InterCompany";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(ModelOutPut.class);

    public ModelOutPut(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected void handleGroupResult(MappedGroup group, Map<MappedRow, ValueList> resultSet) {
    }

    @Override
    protected void doOutput() {
        Map<MappedRow, ValueList> resultSet = this._ctx.getResult();
        try {
            log.info(String.format("Debug Info - saveResult:\n%s", JSONUtils.toString(resultSet)));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{measure});
        String[] allDims = this.getAllDims();
        HashMap<String, Integer> dimLocation = new HashMap<String, Integer>(allDims.length);
        for (int i = 0; i < allDims.length; ++i) {
            dimLocation.put(allDims[i], i);
        }
        Map<Object, DimMappedRelation.DimAndDefValRela> targetDefaultValsMap = this._ctx.getTargetDefaultValsMap();
        Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap = targetDefaultValsMap.values().stream().collect(Collectors.toMap(v -> v.getDimItem().getNumber(), v -> v));
        if (resultSet != null) {
            this.preHandle(resultSet, allDims);
            Map<String, Object> olapSaveData = this.generateOlapData(allDims, tarNumbDefaultValueMap, resultSet, dimLocation);
            info.setDimensions(allDims);
            OlapCommandUtil.addSourceMeasure((String)((String)this._ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
            CellSet cellSets = new CellSet(allDims, new String[]{measure});
            Recorder existData = new Recorder((Object)false);
            olapSaveData.forEach((k, v) -> {
                String[] saveDimNums = k.split("&");
                String lockDim = (String)this._ctx.getCustomParam("lockDim");
                Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                boolean islock = IntegrationUtil.checkLock(info, Arrays.asList(allDims), saveDimNums, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                if (!islock) {
                    cellSets.set(saveDimNums, measure, v);
                    existData.setRecord((Object)true);
                }
            });
            int insertOlapCount = 0;
            try (TXHandle tx = TX.required();){
                try {
                    if (((Boolean)existData.getRecord()).booleanValue()) {
                        insertOlapCount = cellSets.getCount();
                        OlapServiceHelper.saveData(info, cellSets, (String)this._ctx.getModel().p2, true, false);
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.error("error" + e.getMessage());
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
            }
            try {
                log.info(String.format("Debug Info - cellSets:\n%s", cellSets.toString()));
                this._ctx.putCustomParam("InsertOlapCount", insertOlapCount);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.systemError, new Object[]{e});
            }
            this._ctx.putCustomParam(all_dims, null);
            this._ctx.putCustomParam(default_number, null);
            this._ctx.putCustomParam(back_number, null);
            this._ctx.putCustomParam(all_dims_idnumber, null);
            this._ctx.putCustomParam(single_Dim_Mapping, null);
        }
    }

    private Map<String, Object> generateOlapData(String[] allDims, Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap, Map<MappedRow, ValueList> resultSet, Map<String, Integer> dimLocation) {
        ArrayListMultimap finalResult = ArrayListMultimap.create();
        resultSet.forEach((k, v) -> {
            String[] result = new String[allDims.length];
            this.commonHandleData(allDims, (MappedRow)k, result);
            Map<List<String>, Object> tempMap = this.backHandleData((MappedRow)k, (ValueList)v, result, dimLocation);
            this.handleMyCompany((MappedRow)k, tempMap, dimLocation);
            this.defaultHandleData(tarNumbDefaultValueMap, (ArrayListMultimap<String, BigDecimal>)finalResult, tempMap);
        });
        HashMap<String, Object> _finalResult = new HashMap<String, Object>(16);
        finalResult.asMap().forEach((k, v) -> _finalResult.put((String)k, v.stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
        return _finalResult;
    }

    private void handleMyCompany(MappedRow k, Map<List<String>, Object> tempMap, Map<String, Integer> dimLocation) {
        MappedTargetItem mappedTargetItem = k.getTargMapped().get("MyCompany");
        if (mappedTargetItem != null && "MyCompany".equals(mappedTargetItem.getNumber())) {
            tempMap.forEach((tk, tv) -> tk.set((Integer)dimLocation.get("MyCompany"), this._ctx.getOrg().p2));
        }
    }

    private void defaultHandleData(Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap, ArrayListMultimap<String, BigDecimal> finalResult, Map<List<String>, Object> tempMap) {
        tempMap.forEach((tk, tv) -> {
            Map defaultNumber = (Map)this._ctx.getCustomParam(default_number);
            ArrayList<List> lResult = new ArrayList<List>(10);
            lResult.add((List)tk);
            defaultNumber.forEach((dk, dv) -> {
                DimMappedRelation.DimAndDefValRela dimAndDefValRela = (DimMappedRelation.DimAndDefValRela)tarNumbDefaultValueMap.get(dv);
                if (dimAndDefValRela == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f3a\u7701\u503c\u4e0d\u5b58\u5728\uff1a %s\u3002", (String)"MiddleLibOutPut_4", (String)"fi-bcm-business", (Object[])new Object[0]), dv));
                }
                ArrayList<List<String>> temp = new ArrayList<List<String>>(10);
                List<MappedDefaultVal> defVals = dimAndDefValRela.getDefVals();
                if ((defVals = IntegrationUtil.getDefValue(defVals, dv, true, this._ctx)).size() == 1) {
                    for (List tr : lResult) {
                        tr.set((int)dk, defVals.get(0).getNumber());
                    }
                    return;
                }
                for (MappedDefaultVal defVal : defVals) {
                    for (List tr : lResult) {
                        List<String> copyOf = Arrays.asList(tr.toArray(new String[0]));
                        copyOf.set((int)dk, defVal.getNumber());
                        temp.add(copyOf);
                    }
                }
                lResult.clear();
                lResult.addAll(temp);
            });
            lResult.forEach(lv -> finalResult.put((Object)String.join((CharSequence)"&", lv), (Object)((BigDecimal)tv)));
        });
    }

    private Map<List<String>, Object> backHandleData(MappedRow k, ValueList v, String[] result, Map<String, Integer> dimLocation) {
        HashMap<List<String>, Object> tempMap = new HashMap<List<String>, Object>(16);
        v.getValueList().forEach(vItem -> {
            List<String> copyOf = Arrays.asList(result);
            boolean[] flag = new boolean[]{true};
            k.srcMappediterator().forEachRemaining(srcDimEntry -> {
                MappedSourceItem srcDimItemp = (MappedSourceItem)srcDimEntry.getValue();
                if (flag[0] && srcDimItemp.isFollowValue()) {
                    DimMappedRelation.SingleDimRelationPair singleDimRelationPair = k.getDimRelationBySrcDim(srcDimItemp.getMappedDim());
                    String dimNumber = singleDimRelationPair.getTargetDimItem().getDimItem().getNumber();
                    String backNumber = this.getTargMembNumbBySourceItem(singleDimRelationPair.getDimMappedId(), vItem.getMembByMappedDimItem(srcDimItemp.getMappedDim()));
                    if (backNumber == null) {
                        flag[0] = false;
                    } else {
                        Map numberParentMapping;
                        MappedTargetItem mappedTargetItem = k.getTargMapped().get(dimNumber);
                        if (mappedTargetItem != null && ("ICEntity".equals(mappedTargetItem.getNumber()) || "ICOEntity".equals(mappedTargetItem.getNumber())) && (numberParentMapping = (Map)this._ctx.getCustomParam(InterCompany)) != null) {
                            flag[0] = ((String)numberParentMapping.get(backNumber)).equals(mappedTargetItem.getNumber());
                        }
                        copyOf.set((Integer)dimLocation.get(dimNumber), backNumber);
                    }
                }
            });
            k.targMappediterator().forEachRemaining(e -> {
                MappedTargetItem tarDimItemp = (MappedTargetItem)e.getValue();
                String dimNumber = tarDimItemp.getMappedDim().getNumber();
                if (vItem.getProperty(dimNumber) != null) {
                    copyOf.set((Integer)dimLocation.get(dimNumber), (String)vItem.getProperty(dimNumber));
                }
            });
            ArrayList newList = new ArrayList(10);
            CollectionUtils.addAll(newList, (Object[])new Object[copyOf.size()]);
            Collections.copy(newList, copyOf);
            if (flag[0]) {
                if (tempMap.get(newList) != null) {
                    tempMap.put(newList, ((BigDecimal)tempMap.get(newList)).add((BigDecimal)vItem.getValue()));
                } else {
                    tempMap.put(newList, vItem.getValue());
                }
            }
        });
        return tempMap;
    }

    private void commonHandleData(String[] allDims, MappedRow k, String[] result) {
        Map<String, MappedTargetItem> targMapped = k.getTargMapped();
        for (int i = 0; i < allDims.length; ++i) {
            String dim = allDims[i];
            if (SysDimensionEnum.Entity.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getOrg().p2;
                continue;
            }
            if (SysDimensionEnum.Currency.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getCurrency().p2;
                continue;
            }
            if (SysDimensionEnum.Period.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getPeriod().p2;
                continue;
            }
            if (SysDimensionEnum.Year.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getFy().p2;
                continue;
            }
            MappedTargetItem mappedTargetItem = targMapped.get(dim);
            if (mappedTargetItem == null) continue;
            result[i] = mappedTargetItem.getNumber();
        }
    }

    private void preHandle(Map<MappedRow, ValueList> resultSet, String[] allDims) {
        ArrayListMultimap targetDim = ArrayListMultimap.create();
        HashMap defaultNumber = new HashMap(16);
        HashBasedTable interCompany = HashBasedTable.create();
        resultSet.forEach((arg_0, arg_1) -> this.lambda$preHandle$15(targetDim, (Table)interCompany, defaultNumber, allDims, arg_0, arg_1));
        Collection companys = interCompany.values();
        if (companys != null && companys.size() > 0) {
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.integrationnew.output.OlapOutput.preHandle(Map<MappedRow, ValueList>, String[])", (String)SysDimensionEnum.InternalCompany.getMemberTreefrom(), (String)"id, number, parent.number", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this._ctx.getModel().p1}).and(new QFilter("number", "in", (Object)companys)).toArray(), null);
            HashMap numberParentMapping = new HashMap(16);
            queryDataSet.forEach(row -> numberParentMapping.put(row.getString("number"), row.getString("parent.number")));
            this._ctx.putCustomParam(InterCompany, numberParentMapping);
        }
        this._ctx.putCustomParam(default_number, defaultNumber);
    }

    private String[] getAllDims() {
        String[] allDims = (String[])this._ctx.getCustomParam(all_dims);
        if (allDims == null) {
            QFilter modelFilter = new QFilter("model", "=", this._ctx.getModel().p1);
            DynamicObjectCollection userDefines = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, name, fieldmapped", (QFilter[])modelFilter.toArray());
            Map<String, Long> temp = userDefines.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v.getLong("id")));
            allDims = temp.keySet().toArray(new String[0]);
            this._ctx.putCustomParam(all_dims, allDims);
            this._ctx.putCustomParam(all_dims_idnumber, temp);
        }
        return allDims;
    }

    private /* synthetic */ void lambda$preHandle$15(ArrayListMultimap targetDim, Table interCompany, Map defaultNumber, String[] allDims, MappedRow k, ValueList v) {
        Map<String, MappedTargetItem> targMapped = k.getTargMapped();
        v.getValueList().forEach(vl -> {
            k.srcMappediterator().forEachRemaining(ks -> {
                MappedDimItem mappedDimTemp = ((MappedSourceItem)ks.getValue()).getMappedDim();
                String membByMappedDimItem = vl.getMembByMappedDimItem(mappedDimTemp);
                if (((MappedSourceItem)ks.getValue()).isFollowValue()) {
                    String backNumber;
                    MappedTargetItem mappedTargetItem;
                    String targetNumber;
                    targetDim.put((Object)mappedDimTemp, (Object)membByMappedDimItem);
                    DimMappedRelation.SingleDimRelationPair singleDimRelationPair = k.getDimRelationBySrcDim(mappedDimTemp);
                    DimMappedRelation.DimAndDefValRela targetDimItem = singleDimRelationPair.getTargetDimItem();
                    String dimNumber = targetDimItem.getDimItem().getNumber();
                    if ("InternalCompany".equals(dimNumber) && ("ICEntity".equals(targetNumber = (mappedTargetItem = (MappedTargetItem)targMapped.get(dimNumber)).getNumber()) || "ICOEntity".equals(targetNumber)) && (backNumber = this.getTargMembNumbBySourceItem(singleDimRelationPair.getDimMappedId(), membByMappedDimItem)) != null) {
                        interCompany.put((Object)targetNumber, (Object)membByMappedDimItem, (Object)backNumber);
                    }
                }
            });
            if (defaultNumber.size() <= 0) {
                for (int i = 0; i < allDims.length; ++i) {
                    String defaultDim;
                    boolean isContains;
                    String dim = allDims[i];
                    boolean bl = isContains = SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Currency.getNumber().equals(dim) || SysDimensionEnum.Period.getNumber().equals(dim) || SysDimensionEnum.Year.getNumber().equals(dim) || targMapped.get(dim) != null || targetDim.keySet().stream().anyMatch(targDim -> dim.equalsIgnoreCase(targDim.getNumber()));
                    if (isContains || (defaultDim = (String)defaultNumber.get(i)) != null) continue;
                    defaultNumber.put(i, dim);
                }
            }
        });
    }
}

