/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.AbstractOutput;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class XExtendOutPut
extends AbstractOutput {
    private String extendDataEntity = "bcm_extenddata";
    private ExtendsModel extendsModel;
    private String modelNumber;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(XExtendOutPut.class);

    public XExtendOutPut(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected void beforeOutput() {
        super.beforeOutput();
        Long extendModelId = (Long)this._ctx.getCustomParam("extendModelId");
        this.extendsModel = new ExtendsModel(extendModelId);
        if (ExtendDimGroupType.TRANSACTION.getIndex().equals(this.extendsModel.getExtendsGroupType())) {
            this.extendDataEntity = "bcm_extenddata_bus";
        }
        this.modelNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getModel().p1, (String)"bcm_model", (String)"shownumber").getString("shownumber");
    }

    @Override
    protected void handleGroupResult(MappedGroup group, Map<MappedRow, ValueList> resultSet) {
    }

    @Override
    protected void doOutput() {
        StringBuilder errMsg;
        block18: {
            Map<MappedRow, ValueList> resultSet = this._ctx.getResult();
            log.info(String.format("XExtendOutPut-[%s] result size:%s", this._ctx.getSchema().p2, resultSet == null ? "null" : Integer.valueOf(resultSet.size())));
            errMsg = new StringBuilder();
            try (TXHandle tx = TX.required();){
                try {
                    if (resultSet != null && resultSet.size() > 0) {
                        this.saveData(resultSet);
                        break block18;
                    }
                    this.clearData();
                }
                catch (Exception e) {
                    tx.markRollback();
                    if (e instanceof KDBizException) {
                        errMsg.append(e.getMessage());
                    } else {
                        errMsg.append(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)10));
                    }
                    log.error(String.format("XExtendOutPut-[%s] error:", this._ctx.getSchema().p2), (Throwable)e);
                }
            }
        }
        if (errMsg.length() > 0) {
            throw new KDBizException(errMsg.toString());
        }
    }

    private void clearData() {
        boolean isMerge = this.checkMerge();
        if (isMerge) {
            return;
        }
        Map<String, String> trgDefValues = this.getTrgDefValues();
        HashMap<String, Boolean> field2IsNecessary = new HashMap<String, Boolean>(2);
        HashSet<String> uniqueKeySet = new HashSet<String>();
        Boolean isUnique = this.checkUnique(field2IsNecessary, uniqueKeySet);
        Map<String, String> userDefDim2Mapped = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(this._ctx.getModel().p1, false);
        Map<String, String> extField2Mapped = this.extendsModel.getExtFieldEntry().stream().collect(Collectors.toMap(e -> e.getExtField().getNumber(), v -> v.getExtField().getMapped()));
        Set<String> retainSet = this.getRetainSet((Map)this._ctx.getCustomParam("exAttrMap"));
        EDSaveComInfo eci = new EDSaveComInfo(this.modelNumber, this.extendsModel.getExtendsGroupNumber(), this.extendsModel.getNumber());
        List<Map<String, Map<String, Object>>> oldValue = this.removeOldData(isUnique, uniqueKeySet, retainSet, trgDefValues, userDefDim2Mapped, extField2Mapped, new ArrayList<Map<String, Object>>(16));
        if (CollectionUtil.isEmpty(oldValue)) {
            return;
        }
        HashMap<String, String> fixDim = new HashMap<String, String>(8);
        trgDefValues.forEach((key, value) -> fixDim.put((String)key, (String)value));
        fixDim.put("Entity", (String)this._ctx.getOrg().p2);
        fixDim.put("Year", (String)this._ctx.getFy().p2);
        fixDim.put("Period", (String)this._ctx.getPeriod().p2);
        fixDim.put("Currency", (String)this._ctx.getCurrency().p2);
        fixDim.put("Process", "IRpt");
        eci.setFixDim(fixDim);
        String[] cols = new String[extField2Mapped.size()];
        int i = 0;
        for (String key2 : extField2Mapped.keySet()) {
            cols[i++] = key2;
        }
        eci.setCols(cols);
        ArrayList<String> dimList = new ArrayList<String>();
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        for (String key3 : singleDimMap.keySet()) {
            if (fixDim.containsKey(key3) || extField2Mapped.containsKey(key3)) continue;
            dimList.add(key3);
        }
        String[] dims = dimList.toArray(new String[0]);
        eci.setDims(dims);
        Object[] objs = null;
        Map<String, Object> keyMap = null;
        Map<String, Object> valueMap = null;
        for (Map<String, Map<String, Object>> data : oldValue) {
            String realKey;
            keyMap = data.get("keyMap");
            valueMap = data.get("valueMap");
            if (valueMap == null || valueMap.size() == 0) continue;
            objs = new Object[cols.length + dims.length];
            i = 0;
            for (String key4 : cols) {
                realKey = (String)singleDimMap.get(key4);
                objs[i++] = valueMap.get(realKey) == null ? keyMap.get(realKey) : valueMap.get(realKey);
            }
            for (String key4 : dims) {
                realKey = (String)singleDimMap.get(key4);
                objs[i++] = valueMap.get(realKey) == null ? keyMap.get(realKey) : valueMap.get(realKey);
            }
            Pair<Object[], String[]> resPair = this.getResPair(objs, cols.length, dims.length);
            Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
            String lockDim = (String)this._ctx.getCustomParam("lockDim");
            boolean islock = IntegrationUtil.checkLock(eci.getDims(), (String[])resPair.p2, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
            if (islock) continue;
            eci.addValue((Object[])resPair.p1, (String[])resPair.p2);
        }
        ExtDataServiceHelper.saveData(eci);
    }

    private Map<String, String> getTrgDefValues() {
        HashMap<String, String> trgDefValues = new HashMap<String, String>(3);
        this._ctx.getTargetDefaultValsMap().values().forEach(t -> {
            String dimNumber = t.getDimItem().getNumber();
            if ("AuditTrail".equals(dimNumber) || "Scenario".equals(dimNumber)) {
                trgDefValues.put(dimNumber, t.getDefVals().get(0).getNumber());
            }
        });
        return trgDefValues;
    }

    private void saveData(Map<MappedRow, ValueList> resultSet) {
        Map<String, String> trgDefValues = this.getTrgDefValues();
        HashMap<String, Boolean> field2IsNecessary = new HashMap<String, Boolean>(2);
        HashSet<String> uniqueKeySet = new HashSet<String>();
        Boolean isUnique = this.checkUnique(field2IsNecessary, uniqueKeySet);
        Set<String> isNumericalValue = this.getIsNumericalValue();
        Collection<Map<String, Object>> datas = this.getFilerDatas(resultSet, field2IsNecessary, isNumericalValue);
        log.info(String.format("XExtendOutPut-[%s] processed data size:%s", this._ctx.getSchema().p2, datas.size()));
        if (isUnique.booleanValue()) {
            datas = this.getUniQueDatas(datas, isNumericalValue);
        }
        log.info(String.format("XExtendOutPut-[%s] isUnique processed data size:%s", this._ctx.getSchema().p2, datas.size()));
        Map<String, String> userDefDim2Mapped = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(this._ctx.getModel().p1, false);
        Map<String, String> extField2Mapped = this.extendsModel.getExtFieldEntry().stream().collect(Collectors.toMap(e -> e.getExtField().getNumber(), v -> v.getExtField().getMapped()));
        Set<String> retainSet = this.getRetainSet((Map)this._ctx.getCustomParam("exAttrMap"));
        EDSaveComInfo eci = new EDSaveComInfo(this.modelNumber, this.extendsModel.getExtendsGroupNumber(), this.extendsModel.getNumber());
        eci.setIgnoreuniquevalue(true);
        try (TXHandle tx = TX.requiresNew();){
            List<Map<String, Map<String, Object>>> oldValue = this.removeOldData(isUnique, uniqueKeySet, retainSet, trgDefValues, userDefDim2Mapped, extField2Mapped, datas);
            HashMap<String, String> fixDim = new HashMap<String, String>(8);
            trgDefValues.forEach((key, value) -> fixDim.put((String)key, (String)value));
            fixDim.put("Entity", (String)this._ctx.getOrg().p2);
            fixDim.put("Year", (String)this._ctx.getFy().p2);
            fixDim.put("Period", (String)this._ctx.getPeriod().p2);
            fixDim.put("Currency", (String)this._ctx.getCurrency().p2);
            fixDim.put("Process", "IRpt");
            eci.setFixDim(fixDim);
            String[] cols = new String[extField2Mapped.size()];
            int i = 0;
            for (String key2 : extField2Mapped.keySet()) {
                cols[i++] = key2;
            }
            eci.setCols(cols);
            ArrayList<String> dimList = new ArrayList<String>();
            Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
            for (String key3 : singleDimMap.keySet()) {
                if (fixDim.containsKey(key3) || extField2Mapped.containsKey(key3)) continue;
                dimList.add(key3);
            }
            String[] dims = dimList.toArray(new String[0]);
            eci.setDims(dims);
            Map<String, Integer> seqMap = this.getSeqMap(cols, dims);
            Object[] objs = null;
            for (Map<String, Object> data : datas) {
                objs = new Object[cols.length + dims.length];
                i = 0;
                for (String key4 : cols) {
                    objs[i++] = data.get(singleDimMap.get(key4));
                }
                for (String key4 : dims) {
                    objs[i++] = data.get(singleDimMap.get(key4));
                }
                this.handRetainData(oldValue, seqMap, objs);
                Pair<Object[], String[]> resPair = this.getResPair(objs, cols.length, dims.length);
                Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                String lockDim = (String)this._ctx.getCustomParam("lockDim");
                boolean islock = IntegrationUtil.checkLock(eci.getDims(), (String[])resPair.p2, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                if (islock) continue;
                eci.addValue((Object[])resPair.p1, (String[])resPair.p2);
            }
            ExtDataServiceHelper.saveData(eci);
            this._ctx.putCustomParam("InsertOlapCount", eci.getValue().size());
        }
        if (eci.getErrorvalues().size() > 0) {
            this._ctx.putCustomParam("complete", "complete");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f\uff0c\u4f46\u5b58\u5728\u9519\u8bef\u6570\u636e\uff1a%s\u3002", (String)"FormulaOutPut_1", (String)"fi-bcm-business", (Object[])new Object[0]), JSONObject.toJSONString(eci.getErrorvalues())));
        }
    }

    private Pair<Object[], String[]> getResPair(Object[] objs, int colLength, int dimLength) {
        Object[] objsCol = new Object[colLength];
        String[] objsDim = new String[dimLength];
        int colIndex = 0;
        int dimIndex = 0;
        for (int i = 0; i < objs.length; ++i) {
            if (i < colLength) {
                objsCol[colIndex++] = objs[i];
                continue;
            }
            objsDim[dimIndex++] = objs[i] == null ? null : objs[i].toString();
        }
        return Pair.onePair((Object)objsCol, (Object)objsDim);
    }

    private void handRetainData(List<Map<String, Map<String, Object>>> oldValue, Map<String, Integer> seqMap, Object[] objs) {
        Map<String, Object> keyMap = null;
        Map<String, Object> valueMap = null;
        for (Map<String, Map<String, Object>> map : oldValue) {
            keyMap = map.get("keyMap");
            boolean isThis = true;
            for (Map.Entry<String, Object> map2 : keyMap.entrySet()) {
                Object valueObj = objs[seqMap.get(map2.getKey())];
                Object mapValue = map2.getValue();
                if (mapValue instanceof Date && valueObj instanceof Date) {
                    Long time2;
                    Long time1 = ((Date)mapValue).getTime();
                    if (time1.equals(time2 = Long.valueOf(((Date)valueObj).getTime()))) continue;
                    isThis = false;
                    break;
                }
                if (mapValue instanceof BigDecimal && valueObj instanceof BigDecimal) {
                    BigDecimal decimal1 = (BigDecimal)mapValue;
                    BigDecimal decimal2 = (BigDecimal)valueObj;
                    if (decimal1.equals(decimal2)) continue;
                    isThis = false;
                    break;
                }
                if (mapValue.toString().equals(valueObj == null ? "" : valueObj.toString())) continue;
                isThis = false;
                break;
            }
            if (!isThis) continue;
            valueMap = map.get("valueMap");
            break;
        }
        if (valueMap != null) {
            for (Map.Entry entry : valueMap.entrySet()) {
                objs[seqMap.get(entry.getKey()).intValue()] = entry.getValue();
            }
        }
    }

    private Map<String, Integer> getSeqMap(String[] cols, String[] dims) {
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        int seq = 0;
        HashMap<String, Integer> seqMap = new HashMap<String, Integer>(16);
        for (String str : cols) {
            seqMap.put((String)singleDimMap.get(str), seq++);
        }
        for (String str : dims) {
            seqMap.put((String)singleDimMap.get(str), seq++);
        }
        return seqMap;
    }

    private Boolean checkUnique(Map<String, Boolean> field2IsNecessary, Set<String> uniqueKeySet) {
        Boolean isUnique = Boolean.FALSE;
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        for (FieldEntry entry : this.extendsModel.getFieldEntry()) {
            field2IsNecessary.put(entry.getNumber(), entry.getIsNecessary());
            if (!entry.getUniqueCheck()) continue;
            isUnique = Boolean.TRUE;
            String number = (String)singleDimMap.get(entry.getNumber());
            if (number == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u552f\u4e00\u5b57\u6bb5\u6ca1\u6709\u8bbe\u7f6e\u7ef4\u5ea6\u6620\u5c04\uff1a%s\u3002", (String)"FormulaOutPut_2", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getNumber()));
            }
            uniqueKeySet.add(number);
        }
        return isUnique;
    }

    private Collection<Map<String, Object>> getFilerDatas(Map<MappedRow, ValueList> resultSet, Map<String, Boolean> field2IsNecessary, Set<String> isNumericalValue) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(8);
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        for (ValueList valueList : resultSet.values()) {
            log.info(String.format("XExtendOutPut-[%s] valueList size:%s", this._ctx.getSchema().p2, resultSet.size()));
            for (IValueItem valueItem : valueList.getValueList()) {
                HashMap<String, BigDecimal> value = new HashMap<String, BigDecimal>();
                boolean pass = true;
                for (Map.Entry<String, Boolean> entry : field2IsNecessary.entrySet()) {
                    String fieldNumber = (String)singleDimMap.get(entry.getKey());
                    if (fieldNumber == null) continue;
                    Object fieldVaule = valueItem.getProperty(fieldNumber);
                    if (entry.getValue().booleanValue() && (fieldVaule == null || StringUtils.isBlank((CharSequence)fieldVaule.toString()))) {
                        pass = false;
                        break;
                    }
                    if (isNumericalValue.contains(fieldNumber)) {
                        if (fieldVaule == null) {
                            value.put(fieldNumber, BigDecimal.ZERO);
                            continue;
                        }
                        try {
                            value.put(fieldNumber, new BigDecimal(fieldVaule.toString()));
                            continue;
                        }
                        catch (Exception e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6e90\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u4e0d\u662f\u6570\u503c\u7c7b\u578b\uff0c\u8bf7\u4e0e\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u4fdd\u6301\u4e00\u81f4\uff0c\u6216\u4fee\u6539\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"XExtendOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]), fieldNumber));
                        }
                    }
                    value.put(fieldNumber, (BigDecimal)fieldVaule);
                }
                if (!pass) continue;
                datas.add(value);
            }
        }
        return datas;
    }

    private Collection<Map<String, Object>> getUniQueDatas(Collection<Map<String, Object>> datas, Set<String> isNumericalValue) {
        HashMap<String, Map<String, Object>> uniqueKey2Value = new HashMap<String, Map<String, Object>>(4);
        for (Map<String, Object> data : datas) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (isNumericalValue.contains(entry.getKey())) continue;
                sb.append(entry.getValue()).append("|");
            }
            String uniqueKey = sb.toString();
            if (uniqueKey2Value.containsKey(uniqueKey)) {
                Map existValue = (Map)uniqueKey2Value.get(uniqueKey);
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    if (!isNumericalValue.contains(entry.getKey())) continue;
                    existValue.put(entry.getKey(), ((BigDecimal)existValue.get(entry.getKey())).add((BigDecimal)entry.getValue()));
                }
                continue;
            }
            uniqueKey2Value.put(uniqueKey, data);
        }
        return uniqueKey2Value.values();
    }

    private Set<String> getRetainSet(Map<Long, Map<String, Object>> customParam) {
        HashSet<String> retainSet = new HashSet<String>();
        for (Map<String, Object> map : customParam.values()) {
            if (!"1".equals((String)map.get("reservedfield"))) continue;
            retainSet.add((String)map.get("filternumber"));
        }
        return retainSet;
    }

    private Set<String> getIsNumericalValue() {
        HashMap<String, String> fieldNumber2DataType = new HashMap<String, String>(4);
        this.extendsModel.getExtFieldEntry().forEach(e -> fieldNumber2DataType.put(e.getExtField().getNumber(), e.getExtField().getDataType()));
        ArrayList enumFields = new ArrayList(4);
        for (Map.Entry entry : fieldNumber2DataType.entrySet()) {
            if (!((String)entry.getValue()).equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            enumFields.add(entry.getKey());
        }
        if (!enumFields.isEmpty()) {
            QFilter qf_enumFieldDataType = new QFilter("model", "=", this._ctx.getModel().p1);
            qf_enumFieldDataType.and("number", "in", enumFields);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"number, enumitem", (QFilter[])qf_enumFieldDataType.toArray()).values().forEach(e -> {
                DynamicObject enumitem = e.getDynamicObject("enumitem");
                String field = e.getString("number");
                if (enumitem != null) {
                    fieldNumber2DataType.put(field, enumitem.getString("datatype"));
                } else {
                    fieldNumber2DataType.put(field, DataTypeEnum.TXT.getOIndex());
                }
            });
        }
        HashSet<String> isNumericalValue = new HashSet<String>(4);
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        fieldNumber2DataType.forEach((k, v) -> {
            if (v.equals(DataTypeEnum.CURRENCY.getOIndex()) || v.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || v.equals(DataTypeEnum.PROPORTION.getOIndex()) || v.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                isNumericalValue.add((String)singleDimMap.get(k));
            }
        });
        return isNumericalValue;
    }

    private List<Map<String, Map<String, Object>>> removeOldData(Boolean isUnique, Set<String> uniqueKeySet, Set<String> retainSet, Map<String, String> trgDefValues, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped, Collection<Map<String, Object>> datas) {
        QFBuilder qf = new QFBuilder();
        qf.add("modelnumber", "=", (Object)this.modelNumber);
        qf.add("datamodel", "=", (Object)this.extendsModel.getNumber());
        qf.add("org", "=", this._ctx.getOrg().p2);
        qf.add("entity", "=", this._ctx.getOrg().p2);
        qf.add("year", "=", this._ctx.getFy().p2);
        qf.add("period", "=", this._ctx.getPeriod().p2);
        qf.add("currency", "=", this._ctx.getCurrency().p2);
        qf.add("process", "=", (Object)"IRpt");
        trgDefValues.forEach((k, v) -> qf.add(k.toLowerCase(), "=", v));
        Pair<List<Map<String, Map<String, Object>>>, List<Long>> oldValuePair = this.getOldValue(isUnique, uniqueKeySet, retainSet, qf, userDefDim2Mapped, extField2Mapped);
        List oldValue = (List)oldValuePair.p1;
        boolean isMerge = this.checkMerge();
        if (isMerge) {
            Map<String, List<Object>> uniqueAttrMap = this.getUniqueAttrMap(uniqueKeySet, datas);
            uniqueAttrMap.forEach((k, v) -> qf.add(this.turnAttr((String)k, userDefDim2Mapped, extField2Mapped), "in", v));
        }
        if (!CollectionUtil.isEmpty((Collection)((Collection)oldValuePair.p2))) {
            qf.add("id", "not in", oldValuePair.p2);
        }
        DeleteServiceHelper.delete((String)this.extendDataEntity, (QFilter[])qf.toArray());
        return oldValue;
    }

    private String turnAttr(String str, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped) {
        if (userDefDim2Mapped.containsKey(str = this.getKeyByValue(str))) {
            return userDefDim2Mapped.get(str);
        }
        if (extField2Mapped.containsKey(str)) {
            return extField2Mapped.get(str);
        }
        return str.toLowerCase(Locale.ENGLISH);
    }

    private String getKeyByValue(String str) {
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        for (Map.Entry map : singleDimMap.entrySet()) {
            if (!str.equals(map.getValue())) continue;
            return (String)map.getKey();
        }
        return str;
    }

    private Map<String, List<Object>> getUniqueAttrMap(Set<String> uniqueKeySet, Collection<Map<String, Object>> datas) {
        HashMap<String, List<Object>> uniqueAttrMap = new HashMap<String, List<Object>>();
        for (Map<String, Object> map : datas) {
            for (String unique : uniqueKeySet) {
                List attrList = uniqueAttrMap.computeIfAbsent(unique, e -> new ArrayList());
                attrList.add(map.get(unique));
            }
        }
        return uniqueAttrMap;
    }

    private boolean checkMerge() {
        QFilter qf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        qf.and("importmode", "=", (Object)ISImpModeEnum.MERGEIMPORT.getCode());
        DynamicObject importModeObj = QueryServiceHelper.queryOne((String)"bcm_isimportmode", (String)"id", (QFilter[])qf.toArray());
        return importModeObj != null;
    }

    private Pair<List<Map<String, Map<String, Object>>>, List<Long>> getOldValue(boolean isUnique, Set<String> uniqueKeySet, Set<String> retainSet, QFBuilder qf, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped) {
        ArrayList oldValue = new ArrayList(16);
        ArrayList<Long> cantDeleteIds = new ArrayList<Long>(16);
        if (!isUnique || uniqueKeySet.isEmpty()) {
            return Pair.onePair(oldValue, cantDeleteIds);
        }
        Map<String, String> uniqueKeyMap = this.turnKey(uniqueKeySet, userDefDim2Mapped, extField2Mapped);
        Map<String, String> retainMap = this.turnKey(retainSet, userDefDim2Mapped, extField2Mapped);
        String lockDim = (String)this._ctx.getCustomParam("lockDim");
        Pair<String, String> addField = this.getAddField(lockDim, userDefDim2Mapped);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.extendDataEntity, (String)((String)addField.p1 + String.join((CharSequence)",", uniqueKeyMap.values()) + "," + String.join((CharSequence)",", retainMap.values())), (QFilter[])qf.toArray());
        HashMap<String, HashMap<String, Object>> oldMap = null;
        HashMap<String, Object> keyMap = null;
        HashMap<String, Object> valueMap = null;
        for (DynamicObject dynamicObject : load) {
            keyMap = new HashMap<String, Object>(16);
            for (Map.Entry<String, String> map : uniqueKeyMap.entrySet()) {
                Object value = dynamicObject.get(map.getValue());
                keyMap.put(map.getKey(), value == null ? "" : value);
            }
            valueMap = new HashMap<String, Object>(16);
            for (Map.Entry<String, String> map : retainMap.entrySet()) {
                valueMap.put(map.getKey(), dynamicObject.get(map.getValue()));
            }
            oldMap = new HashMap<String, HashMap<String, Object>>(16);
            oldMap.put("keyMap", keyMap);
            oldMap.put("valueMap", valueMap);
            oldValue.add(oldMap);
            this.getCantDeleteIds(lockDim, cantDeleteIds, dynamicObject, (String)addField.p2);
        }
        return Pair.onePair(oldValue, cantDeleteIds);
    }

    private void getCantDeleteIds(String lockDim, List<Long> cantDeleteIds, DynamicObject dynamicObject, String tableField) {
        Map<String, String> warnRpt;
        String lockDimNum;
        boolean isLock;
        if (lockDim != null && (isLock = IntegrationUtil.checkLock(lockDim, lockDimNum = dynamicObject.getString(tableField), warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx), (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2))) {
            cantDeleteIds.add(dynamicObject.getLong("id"));
        }
    }

    private Pair<String, String> getAddField(String lockDim, Map<String, String> userDefDim2Mapped) {
        String addField = "";
        String tableField = "";
        if (lockDim != null) {
            tableField = userDefDim2Mapped.get(lockDim) == null ? lockDim.toLowerCase() : userDefDim2Mapped.get(lockDim);
            addField = tableField + ",id,";
        }
        return Pair.onePair((Object)addField, (Object)tableField);
    }

    private Map<String, String> turnKey(Set<String> keySet, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped) {
        HashMap<String, String> newMap = new HashMap<String, String>(16);
        for (String str : keySet) {
            newMap.put(str, this.turnAttr(str, userDefDim2Mapped, extField2Mapped));
        }
        return newMap;
    }
}

