/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.eas2my;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.IntegrationServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedMembItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.EASGlDimTypesEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

public abstract class AbstractGLBalanceDataProvider
extends AbstractDataProvider {
    public static final String SYSTEM_VERSION = "SYSTEM_VERSION";
    public static final String SYSTEM_SSID = "SYSTEM_SSID";
    public static final String BAL_TYPE = "BalType";
    public static final String TYPE_FILTER = "1";
    public static final String TYPE_NUMBER_FILTER = "2";
    public static final String AMOUNT = "amount";
    public static final String ACCOUNTREF_ = "accountRef_";
    public static final String ALL = "*";
    public static final String ACCOUNTEMPTY = "accountEmpty";
    public static final String ACCESSTYPEEMPTY = "accessTypeEmpty";
    protected static WatchLogger log;
    protected Map<String, DimensionScope> dimensionScopeMap;

    public AbstractGLBalanceDataProvider(IIntegrateContext ctx) {
        super(ctx);
        log = BcmLogFactory.getWatchLogInstance(IntegrationServiceHelper.class);
    }

    @Override
    protected void beforeLoadData() {
        super.beforeLoadData();
        this.dimensionScopeMap = new HashMap<String, DimensionScope>();
        this.initDimensionScope();
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        List<MappedGroup> mappedGroup = this.getMappedGroup();
        if (mappedGroup.size() == 0) {
            return new StdMdDataSet();
        }
        try {
            List<DataSet> queryAccountDataSets = this.queryDataSet();
            StdMdDataSet stdMdDataSet = this.trans2DataSet(queryAccountDataSets);
            return stdMdDataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.dimensionScopeMap = null;
        }
    }

    protected Set<String> turnFsrcchangettypes(Set<String> srcchangettypes) {
        HashSet<String> newSrcchangettypes = new HashSet<String>();
        for (String str : srcchangettypes) {
            if ("YearCreditRpt".equals(str)) {
                newSrcchangettypes.add("fYearCreditRpt as YearCreditRpt");
                continue;
            }
            newSrcchangettypes.add(str);
        }
        return newSrcchangettypes;
    }

    private StdMdDataSet trans2DataSet(List<DataSet> queryDataSets) {
        StdMdDataSet dataSet = this.getDataSet(queryDataSets);
        Pair<List<IRow>, Map<String, BigDecimal>> dcPair = this.getDcMap(dataSet);
        Set<String> accessTypes = this.dimensionScopeMap.get((Object)"ds_changetype").result;
        Set<String> keySet = null;
        String account = null;
        DimensionScope dimScope = this.dimensionScopeMap.get("ds_account");
        Set<String> dcKey = this.getDcKey();
        StdMdDataSet dataSetRes = new StdMdDataSet();
        StdMdRow mdRow = null;
        for (IRow row : (List)dcPair.p1) {
            mdRow = new StdMdRow();
            account = (String)row.get(dimScope.field);
            keySet = row.getKeySet();
            for (String key : keySet) {
                if (accessTypes.contains(key)) {
                    mdRow.put(key, this.getAmount(row.get(key), (Map)dcPair.p2, account, dcKey.contains(key)));
                    continue;
                }
                mdRow.put(key, row.get(key));
            }
            dataSetRes.addRow(mdRow);
        }
        return dataSetRes;
    }

    private Set<String> getDcKey() {
        HashSet<String> dcKey = new HashSet<String>();
        dcKey.add("EndBalanceFor");
        dcKey.add("EndBalanceLocal");
        dcKey.add("EndBalanceRpt");
        return dcKey;
    }

    private StdMdDataSet getDataSet(List<DataSet> queryDataSets) {
        StdMdDataSet dataSet = new StdMdDataSet();
        for (DataSet queryDataSet : queryDataSets) {
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                StdMdRow mdRow = new StdMdRow();
                for (Field field : queryDataSet.getRowMeta().getFields()) {
                    String k = field.getName();
                    Object v = row.get(field.getName());
                    if (ObjectUtils.isEmpty((Object)v.toString())) continue;
                    if (k.equals("assistgrpid")) {
                        this.turn2Std(mdRow, v);
                        continue;
                    }
                    mdRow.put(field.getName(), v);
                }
                dataSet.addRow(mdRow);
            }
        }
        return dataSet;
    }

    private Pair<List<IRow>, Map<String, BigDecimal>> getDcMap(StdMdDataSet dataSet) {
        DynamicObject[] accounts;
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme");
        String usedc = scheme.getString("usedc");
        ArrayList<IRow> rows = new ArrayList<IRow>();
        DimensionScope dimScope = this.dimensionScopeMap.get("ds_account");
        IRow next2 = null;
        HashSet<String> accountSet = new HashSet<String>();
        for (IRow next2 : dataSet) {
            rows.add(next2);
            accountSet.add((String)next2.get(dimScope.field));
        }
        HashMap<String, BigDecimal> dcMap = new HashMap<String, BigDecimal>();
        if ("true".equals(usedc)) {
            return Pair.onePair(rows, dcMap);
        }
        QFilter ssidQf = new QFilter("ssid", "=", this._ctx.getCustomParam(SYSTEM_SSID));
        QFilter numberQf = new QFilter("number", "in", accountSet);
        for (DynamicObject account : accounts = BusinessDataServiceHelper.load((String)"ds_account", (String)"number, dc", (QFilter[])new QFilter[]{ssidQf, numberQf})) {
            dcMap.put(account.getString("number"), new BigDecimal(StringUtils.isEmpty((String)account.getString("dc")) ? TYPE_FILTER : account.getString("dc")));
        }
        return Pair.onePair(rows, dcMap);
    }

    private Object getAmount(Object amount, Map<String, BigDecimal> dcMap, Object number, boolean needMul) {
        if (dcMap == null || !needMul) {
            if (amount instanceof Integer) {
                amount = new BigDecimal((Integer)amount);
            }
            return amount;
        }
        return new BigDecimal(amount.toString()).multiply(dcMap.get(number) == null ? new BigDecimal(1) : dcMap.get(number));
    }

    private void turn2Std(StdMdRow mdRow, Object v) {
        String valueAsst = (String)v;
        if (!StringUtils.isEmpty((String)valueAsst) && valueAsst.contains("_!")) {
            String[] split;
            if (valueAsst.endsWith(";")) {
                valueAsst = valueAsst.substring(0, valueAsst.length() - 1);
            }
            for (String e : split = valueAsst.split(";")) {
                String[] pairs = e.split(":");
                mdRow.put(pairs[0].split("_!")[0], pairs[1].split("_!")[0]);
            }
        }
    }

    protected void checkIfNull(Object o, String value) {
        if (Objects.isNull(o)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u4e2d\u672a\u6620\u5c04%s\u3002", (String)"AbstractGLBalanceDataProvider_0", (String)"fi-bcm-business", (Object[])new Object[0]), value));
        }
    }

    protected DimensionScope addFilterByCode(QFBuilder builder, String entityCode, String type) {
        DimensionScope dimScope = this.dimensionScopeMap.get(entityCode);
        if (this._ctx.getCustomParam(ACCOUNTREF_ + entityCode) != null && ((Boolean)this._ctx.getCustomParam(ACCOUNTREF_ + entityCode)).booleanValue()) {
            return dimScope;
        }
        this.checkIfNull(dimScope, entityCode);
        switch (type) {
            case "1": {
                if (dimScope.idResult.size() <= 0) break;
                builder.add(dimScope.getQFilter());
                break;
            }
            case "2": {
                if (dimScope.result.size() <= 0) break;
                builder.add(dimScope.getNumberQFilter());
                break;
            }
        }
        return dimScope;
    }

    private void initDimensionScope() {
        List<MappedGroup> mappedGroup = this.getMappedGroup();
        if (mappedGroup.size() == 0) {
            return;
        }
        this.initHeadScope();
        HashMap<String, Boolean> isHaveEmpty = new HashMap<String, Boolean>();
        for (MappedGroup group : mappedGroup) {
            group.forEach(v -> this.handleCommon((MappedRow)v, (Map<String, Boolean>)isHaveEmpty));
        }
        this.fillAccount(isHaveEmpty);
        this.fillAccessType(isHaveEmpty);
        this.dimensionScopeMap.values().forEach(v -> v.getQFilter());
    }

    private void fillAccessType(Map<String, Boolean> isHaveEmpty) {
        Pair<Long, DimMappedRelation.SingleDimRelationPair> accessTypeRef = this.getAccountRef(2, EASGlDimTypesEnum.ACCESSTYPE.getNumber());
        this.addAccountScope(accessTypeRef, isHaveEmpty.get(ACCESSTYPEEMPTY) == null ? Boolean.FALSE.booleanValue() : isHaveEmpty.get(ACCESSTYPEEMPTY).booleanValue(), 2);
    }

    private void fillAccount(Map<String, Boolean> isHaveEmpty) {
        Pair<Long, DimMappedRelation.SingleDimRelationPair> accountRef = this.getAccountRef(1, DimTypesEnum.ACCOUNT.getNumber());
        this.addAccountScope(accountRef, isHaveEmpty.get(ACCOUNTEMPTY) == null ? Boolean.FALSE.booleanValue() : isHaveEmpty.get(ACCOUNTEMPTY).booleanValue(), 1);
    }

    private void addAccountScope(Pair<Long, DimMappedRelation.SingleDimRelationPair> accountRef, boolean isHaveEmpty, Integer type) {
        if (isHaveEmpty) {
            DimensionScope dimensionScope = new DimensionScope();
            this.dimensionScopeMap.put(((DimMappedRelation.SingleDimRelationPair)accountRef.p2).getSourceDimItem().getDimItem().getEntityNumb(), dimensionScope);
            dimensionScope.setEntityName(((DimMappedRelation.SingleDimRelationPair)accountRef.p2).getSourceDimItem().getDimItem().getEntityNumb());
            dimensionScope.setField(((DimMappedRelation.SingleDimRelationPair)accountRef.p2).getSourceDimItem().getDimItem().getNumber());
            this.setDimensionScopeBySingle(accountRef, dimensionScope, type);
        }
    }

    private void setDimensionScopeBySingle(Pair<Long, DimMappedRelation.SingleDimRelationPair> accountRef, DimensionScope dimensionScope, Integer type) {
        Map singleMap = (Map)this._ctx.getCustomParam("singleMap");
        List needObj = (List)singleMap.get(accountRef.p1);
        for (DynamicObject dynamicObject : needObj) {
            int scope = dynamicObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : dynamicObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    if (2 != type) continue;
                    this.handAccessTypeAll(sourceItem);
                    continue;
                }
                MappedSourceItem sourceMapped = this.buildSourceMapped(srcDyn, scope);
                if (2 == type) {
                    this.handAccessTypeAll(sourceMapped);
                }
                sourceItem.mergeSourceItem(sourceMapped);
            }
            dimensionScope.addFilterNumber(sourceItem);
        }
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        int scope = mainscope;
        MappedSourceItem item = new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, scope, false, false);
        return item;
    }

    protected List<MappedGroup> getMappedGroup() {
        return this._ctx.getCombineMappedGroup();
    }

    private void initHeadScope() {
        Long orgId = (Long)this._ctx.getOrg().p1;
        Long currencyId = (Long)this._ctx.getCurrency().p1;
        Long scemeId = (Long)this._ctx.getSchema().p1;
        long baseorgid = TreeStructureServiceHelper.getEntityBaseMemberId(orgId);
        Pair orgPair = Pair.onePair((Object)baseorgid, (Object)this._ctx.getOrg().p2);
        Map<Long, Set<String>> idNumbers = IntegrationUtil.queryCommonMemMapping(scemeId, (Pair<Long, String>)orgPair, this._ctx.getCurrency(), this._ctx.getFy(), this._ctx.getPeriod());
        this.addHeadMem(baseorgid, idNumbers, "orgunit", "ds_orgunit");
        this.addHeadMem(currencyId, idNumbers, "currency", "ds_currency");
        this.handleHeadPeriod(idNumbers);
    }

    private void handleHeadPeriod(Map<Long, Set<String>> idNumbers) {
        DimensionScope dimensionScope = this.dimensionScopeMap.get("ds_period");
        Set<String> fyNumbers = idNumbers.get(this._ctx.getFy().p1);
        Set<String> periodNumbers = idNumbers.get(this._ctx.getPeriod().p1);
        if (periodNumbers != null && fyNumbers != null) {
            String periodNum;
            if (dimensionScope == null) {
                dimensionScope = new DimensionScope();
                this.dimensionScopeMap.put("ds_period", dimensionScope);
                dimensionScope.setEntityName("ds_period");
                dimensionScope.setField("period");
            }
            periodNum = (periodNum = periodNumbers.toArray(new String[0])[0]).length() == 1 ? "0" + periodNum : periodNum;
            dimensionScope.equalSet.add(fyNumbers.toArray()[0] + "" + periodNum);
        }
    }

    private void addHeadMem(Long orgId, Map<Long, Set<String>> idNumbers, String field, String entityNumb) {
        Set<String> orgNumbers = idNumbers.get(orgId);
        if (orgNumbers != null) {
            DimensionScope dimensionScope = this.dimensionScopeMap.get(entityNumb);
            if (dimensionScope == null) {
                dimensionScope = new DimensionScope();
                this.dimensionScopeMap.put(entityNumb, dimensionScope);
                dimensionScope.setEntityName(entityNumb);
                dimensionScope.setField(field);
            }
            dimensionScope.equalSet.addAll(orgNumbers);
        }
    }

    private void handleCommon(MappedRow v, Map<String, Boolean> isHaveEmpty) {
        Pair<Long, DimMappedRelation.SingleDimRelationPair> accountRef = this.getAccountRef(1, DimTypesEnum.ACCOUNT.getNumber());
        Pair<Long, DimMappedRelation.SingleDimRelationPair> accessTypeRef = this.getAccountRef(2, EASGlDimTypesEnum.ACCESSTYPE.getNumber());
        Iterator<Map.Entry<String, MappedSourceItem>> srcMappediterator = v.srcMappediterator();
        boolean ishaveAll = false;
        boolean ishaveAccount = false;
        boolean ishaveAccessType = false;
        while (srcMappediterator.hasNext()) {
            Map.Entry<String, MappedSourceItem> next = srcMappediterator.next();
            MappedSourceItem sourceItem = next.getValue();
            if (((DimMappedRelation.SingleDimRelationPair)accountRef.p2).getSourceDimItem().getDimItem().getNumber().equals(sourceItem.getMappedDim().getNumber())) {
                if (ALL.equals(sourceItem.getNumber())) {
                    ishaveAll = true;
                }
                ishaveAccount = true;
            } else if (accessTypeRef.p2 == null || accessTypeRef.p2 != null && ((DimMappedRelation.SingleDimRelationPair)accessTypeRef.p2).getSourceDimItem().getDimItem().getNumber().equals(sourceItem.getMappedDim().getNumber())) {
                ishaveAccessType = true;
            }
            MappedDimItem mappedDim = sourceItem.getMappedDim();
            String entityNumb = mappedDim.getEntityNumb();
            DimensionScope dimensionScope = this.dimensionScopeMap.get(entityNumb);
            if (dimensionScope == null) {
                dimensionScope = new DimensionScope();
                this.dimensionScopeMap.put(entityNumb, dimensionScope);
                dimensionScope.setEntityName(entityNumb);
                dimensionScope.setField(mappedDim.getMappedKey());
            }
            if (EASGlDimTypesEnum.ACCESSTYPE.getNumber().equals(sourceItem.getMappedDim().getNumber())) {
                this.handAccessTypeAll(sourceItem);
            }
            dimensionScope.addFilterNumber(sourceItem);
        }
        if (ishaveAll) {
            this._ctx.putCustomParam(ACCOUNTREF_ + ((DimMappedRelation.SingleDimRelationPair)accountRef.p2).getSourceDimItem().getDimItem().getEntityNumb(), true);
        }
        if (!ishaveAccount) {
            isHaveEmpty.put(ACCOUNTEMPTY, true);
        }
        if (!ishaveAccessType) {
            isHaveEmpty.put(ACCESSTYPEEMPTY, true);
        }
    }

    protected Set<String> getFinalChangeType(Set<String> srcchangettypes, Long ssId) {
        HashSet<String> newChangeType = new HashSet<String>();
        if (srcchangettypes.contains(ALL)) {
            DynamicObject[] load;
            QFilter qFilter = new QFilter("ssid", "=", (Object)ssId);
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"ds_changetype", (String)"id,number", (QFilter[])new QFilter[]{qFilter})) {
                if (ALL.equals(dynamicObject.getString("number"))) continue;
                newChangeType.add(dynamicObject.getString("number"));
            }
        } else {
            return srcchangettypes;
        }
        return newChangeType;
    }

    private void handAccessTypeAll(MappedSourceItem sourceItem) {
        String number = sourceItem.getNumber();
        if (!ALL.equals(number)) {
            return;
        }
        sourceItem.setScope(4);
        QFilter qFilter = new QFilter("ssid", "=", this._ctx.getCustomParam(SYSTEM_SSID));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ds_changetype", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        int i = 1;
        for (DynamicObject dynamicObject : load) {
            if (ALL.equals(dynamicObject.getString("number"))) continue;
            MappedSourceItem scopeSourceItem = new MappedSourceItem(dynamicObject.getLong("id"), dynamicObject.getString("number"), null, i++, 4, false, false);
            sourceItem.mergeSourceItem(scopeSourceItem);
        }
    }

    private Pair<Long, DimMappedRelation.SingleDimRelationPair> getAccountRef(int type, String number) {
        DimMappedRelation mappedRelation = this._ctx.getMappedRelation();
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> singleMappedRelationPair = mappedRelation.getSingleMappedRelationPair();
        for (DimMappedRelation.SingleDimRelationPair cell : singleMappedRelationPair.values()) {
            String compareNumber = cell.getTargetDimItem().getDimItem().getNumber();
            if (type == 2) {
                compareNumber = cell.getSourceDimItem().getDimItem().getNumber();
            }
            if (!number.equals(compareNumber)) continue;
            return Pair.onePair((Object)cell.getDimMappedId(), (Object)cell);
        }
        return Pair.onePair((Object)0L, null);
    }

    protected String getAlgoKey() {
        return this.getClass().getName();
    }

    protected abstract List<DataSet> queryDataSet();

    protected class DimensionScope {
        protected Set<String> equalSet = new HashSet<String>();
        protected Set<String> inSet = new HashSet<String>();
        protected Set<String> betweenSet = new HashSet<String>();
        protected Set<String> likeSet = new HashSet<String>();
        protected String entityName = "";
        protected String field = "";
        protected QFilter filter;
        protected QFilter numberFilter;
        protected Set<String> idResult = new HashSet<String>();
        protected Set<String> result = new HashSet<String>();

        public QFilter getNumberQFilter() {
            return this.numberFilter;
        }

        public QFilter getQFilter() {
            if (this.filter == null) {
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add("ssid", "=", AbstractGLBalanceDataProvider.this._ctx.getCustomParam(AbstractGLBalanceDataProvider.SYSTEM_SSID));
                QFilter betweenFilter = QFilter.of((String)"1<>1", (Object[])new Object[0]);
                this.inSet.addAll(this.equalSet);
                if (this.inSet.size() > 0) {
                    betweenFilter.or(new QFilter("number", "in", this.inSet));
                }
                String small = null;
                String big = null;
                String tmp = null;
                for (String s : this.betweenSet) {
                    String[] arr = s.split(String.valueOf(':'));
                    small = arr[0];
                    if (small.compareTo(big = arr[1]) > 0) {
                        tmp = small;
                        small = big;
                        big = tmp;
                    }
                    betweenFilter.or(new QFilter("number", ">=", (Object)small).and("number", "<=", (Object)big));
                }
                for (String s : this.likeSet) {
                    betweenFilter.or("number", "like", (Object)(s + "%"));
                }
                qfBuilder.add(betweenFilter);
                try (DataSet query = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityName, (String)"soid, number", (QFilter[])qfBuilder.toArray(), null);){
                    query.forEach(dataRow -> this.handleQueryResult((Row)dataRow, this.result, this.idResult, this.inSet, this.betweenSet, this.likeSet));
                }
                this.filter = new QFilter(this.field, "in", this.idResult);
                this.numberFilter = new QFilter(this.field, "in", this.result);
            }
            return this.filter;
        }

        private void handleQueryResult(Row e, Set<String> result, Set<String> idResult, Set<String> inSet, Set<String> betweenSet, Set<String> likeSet) {
            String number = e.getString("number");
            if (betweenSet.size() <= 0) {
                idResult.add(e.getString("soid"));
                result.add(number);
                return;
            }
            if (inSet.contains(number)) {
                idResult.add(e.getString("soid"));
                result.add(number);
                return;
            }
            for (String temp : likeSet) {
                if (!number.contains(temp)) continue;
                idResult.add(e.getString("soid"));
                result.add(number);
                return;
            }
            String sl = null;
            String bg = null;
            String tmp1 = null;
            for (String temp : betweenSet) {
                String[] arr = temp.split(String.valueOf(':'));
                sl = arr[0];
                if (sl.compareTo(bg = arr[1]) > 0) {
                    tmp1 = sl;
                    sl = bg;
                    bg = tmp1;
                }
                if (sl.compareTo(number) > 0 || bg.compareTo(number) < 0 || sl.split("\\.").length != number.split("\\.").length) continue;
                idResult.add(e.getString("soid"));
                result.add(number);
            }
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void addFilterNumber(MappedSourceItem sourceItem) {
            MapScopeEnum sc = MapScopeEnum.getEnumByindex((int)sourceItem.getScope());
            switch (sc) {
                case EQUALS: {
                    this.equalSet.add(sourceItem.getNumber());
                    break;
                }
                case RANGE: {
                    SortedSet<MappedSourceItem> scopeItems = sourceItem.getScopeSourceItems();
                    this.betweenSet.add(scopeItems.first().getNumber() + ':' + scopeItems.last().getNumber());
                    break;
                }
                case INCLUDE: {
                    this.inSet.addAll(sourceItem.getScopeSourceItems().stream().map(MappedMembItem::getNumber).collect(Collectors.toSet()));
                    break;
                }
                case LIKE: {
                    this.likeSet.add(sourceItem.getNumber());
                    break;
                }
            }
        }
    }
}

