/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.eas2my;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.provider.eas2my.AbstractGLBalanceDataProvider;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class GLAcctBalanceDataProvider
extends AbstractGLBalanceDataProvider {
    private static final String ASST_TYPE = "asst";
    private static final String ACCT_TYPE = "acct";

    public GLAcctBalanceDataProvider(IIntegrateContext ctx) {
        super(ctx);
    }

    private String getAccountBalance() {
        if ("800".equals(this._ctx.getCustomParam("SYSTEM_VERSION"))) {
            return "ds_accountbalance";
        }
        return "ds_accountbalance_5l";
    }

    private String getAsstBalance() {
        if ("800".equals(this._ctx.getCustomParam("SYSTEM_VERSION"))) {
            return "ds_assistbalance";
        }
        return "ds_assistbalance_5f";
    }

    @Override
    protected List<DataSet> queryDataSet() {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("ssid", "=", this._ctx.getCustomParam("SYSTEM_SSID")));
        builder.add(new QFilter("baltype", "=", (Object)this._ctx.getCustomParam("BalType").toString()));
        AbstractGLBalanceDataProvider.DimensionScope dimOrgScope = this.addFilterByCode(builder, "ds_orgunit", "1");
        AbstractGLBalanceDataProvider.DimensionScope dimPeriodScope = this.addFilterByCode(builder, "ds_period", "2");
        AbstractGLBalanceDataProvider.DimensionScope dimCurrencyScope = this.addFilterByCode(builder, "ds_currency", "1");
        AbstractGLBalanceDataProvider.DimensionScope dimAccountScope = this.addFilterByCode(builder, "ds_account", "2");
        List<String> selectors = this.getBalanceSelect(ASST_TYPE);
        Set<String> srcchangettypes = this.getSrcChangeTypes();
        selectors.addAll(srcchangettypes);
        IntegrationUtil.debugSql(log, this.getAsstBalance(), builder, selectors);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)this.getAsstBalance(), (String)String.join((CharSequence)",", selectors), (QFilter[])builder.toArray(), null);
        try {
            log.info("GLAcctBalanceDataProvider--1--" + JSON.toJSONString((Object)builder.toArray()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataSet currencyDs = this.getCurrencyDs(dimCurrencyScope);
        DataSet orgunitDs = this.getOrgunitDs(dimOrgScope);
        List<String> actCnySelectors = this.getActCnySelectors(ASST_TYPE, srcchangettypes);
        List<String> allSelectors = this.getAllSelectors(ASST_TYPE, srcchangettypes, dimCurrencyScope, dimOrgScope, dimAccountScope, dimPeriodScope);
        DataSet resultDs = ds.join(currencyDs).on("currencyid", "currencySoid").select(actCnySelectors.toArray(new String[0])).finish().join(orgunitDs).on("orgunitid", "orgunitSoid").select(allSelectors.toArray(new String[0])).finish();
        selectors = this.getBalanceSelect(ACCT_TYPE);
        Set<String> newSrcchangettypes = this.turnFsrcchangettypes(srcchangettypes);
        selectors.addAll(newSrcchangettypes);
        boolean haveThirdDim = this.isHaveThirdDim();
        if (haveThirdDim) {
            this.addAccountFilter(builder);
        }
        IntegrationUtil.debugSql(log, this.getAccountBalance(), builder, selectors);
        DataSet dsAcct = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)this.getAccountBalance(), (String)String.join((CharSequence)",", selectors), (QFilter[])builder.toArray(), null);
        try {
            log.info("GLAcctBalanceDataProvider--2--" + JSON.toJSONString((Object)builder.toArray()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        actCnySelectors = this.getActCnySelectors(ACCT_TYPE, srcchangettypes);
        allSelectors = this.getAllSelectors(ACCT_TYPE, srcchangettypes, dimCurrencyScope, dimOrgScope, dimAccountScope, dimPeriodScope);
        DataSet resultDsAcct = dsAcct.join(currencyDs).on("currencyid", "currencySoid").select(actCnySelectors.toArray(new String[0])).finish().join(orgunitDs).on("orgunitid", "orgunitSoid").select(allSelectors.toArray(new String[0])).finish();
        ArrayList<DataSet> results = new ArrayList<DataSet>();
        results.add(resultDs);
        results.add(resultDsAcct);
        return results;
    }

    private List<String> getAllSelectors(String type, Set<String> srcchangettypes, AbstractGLBalanceDataProvider.DimensionScope dimCurrencyScope, AbstractGLBalanceDataProvider.DimensionScope dimOrgScope, AbstractGLBalanceDataProvider.DimensionScope dimAccountScope, AbstractGLBalanceDataProvider.DimensionScope dimPeriodScope) {
        ArrayList<String> allSelectors = new ArrayList<String>();
        allSelectors.add("currencyNum as " + dimCurrencyScope.field);
        allSelectors.add("orgunitNum as " + dimOrgScope.field);
        allSelectors.add("account as " + dimAccountScope.field);
        allSelectors.add("period as " + dimPeriodScope.field);
        if (ASST_TYPE.equals(type)) {
            allSelectors.add("assistgrpid");
        }
        allSelectors.addAll(srcchangettypes);
        return allSelectors;
    }

    private List<String> getActCnySelectors(String type, Set<String> srcchangettypes) {
        ArrayList<String> actCnySelectors = new ArrayList<String>();
        actCnySelectors.add("account");
        actCnySelectors.add("currencyid");
        actCnySelectors.add("orgunitid");
        actCnySelectors.add("period");
        if (ASST_TYPE.equals(type)) {
            actCnySelectors.add("assistgrpid");
        }
        actCnySelectors.add("currencySoid");
        actCnySelectors.add("currencyNum");
        actCnySelectors.addAll(srcchangettypes);
        return actCnySelectors;
    }

    private DataSet getOrgunitDs(AbstractGLBalanceDataProvider.DimensionScope dimOrgScope) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("ssid", "=", this._ctx.getCustomParam("SYSTEM_SSID")));
        builder.add("number", "in", dimOrgScope.result);
        ArrayList<String> orgunitSelectors = new ArrayList<String>();
        orgunitSelectors.add("soid as orgunitSoid");
        orgunitSelectors.add("number as orgunitNum");
        DataSet orgunitDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)"ds_orgunit", (String)String.join((CharSequence)",", orgunitSelectors), (QFilter[])builder.toArray(), null);
        return orgunitDs;
    }

    private DataSet getCurrencyDs(AbstractGLBalanceDataProvider.DimensionScope dimCurrencyScope) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("ssid", "=", this._ctx.getCustomParam("SYSTEM_SSID")));
        builder.add("number", "in", dimCurrencyScope.result);
        ArrayList<String> currencySelectors = new ArrayList<String>();
        currencySelectors.add("soid as currencySoid");
        currencySelectors.add("number as currencyNum");
        DataSet currencyDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)"ds_currency", (String)String.join((CharSequence)",", currencySelectors), (QFilter[])builder.toArray(), null);
        return currencyDs;
    }

    private Set<String> getSrcChangeTypes() {
        AbstractGLBalanceDataProvider.DimensionScope dimChangeTypeScope = (AbstractGLBalanceDataProvider.DimensionScope)this.dimensionScopeMap.get("ds_changetype");
        Set<String> srcchangettypes = null;
        srcchangettypes = dimChangeTypeScope != null ? dimChangeTypeScope.result : new HashSet<String>();
        return this.getFinalChangeType(srcchangettypes, (Long)this._ctx.getCustomParam("SYSTEM_SSID"));
    }

    private List<String> getBalanceSelect(String type) {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("account");
        selectors.add("currency as currencyid");
        selectors.add("orgunit as orgunitid");
        selectors.add("period");
        if (ASST_TYPE.equals(type)) {
            selectors.add("assistgrpid");
        }
        return selectors;
    }

    private void addAccountFilter(QFBuilder builder) {
        ArrayList<String> selectorsAsst = new ArrayList<String>();
        selectorsAsst.add("account");
        DataSet asstds = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)this.getAsstBalance(), (String)String.join((CharSequence)",", selectorsAsst), (QFilter[])builder.toArray(), null);
        Iterator iterator = asstds.iterator();
        HashSet<String> accountSet = new HashSet<String>();
        while (iterator.hasNext()) {
            accountSet.add(((Row)iterator.next()).getString("account"));
        }
        if (accountSet.size() > 0) {
            QFilter qf = new QFilter("account", "not in", accountSet);
            builder.add(qf);
        }
    }

    private boolean isHaveThirdDim() {
        return this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().size() > 2;
    }
}

