/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.eas2my;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.model.BalanceQueryParamApi;
import kd.fi.bcm.business.model.GlServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class GLBalanceDataProvider
extends AbstractDataProvider {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(GLBalanceDataProvider.class);
    private static final String ORGID = "orgid";
    private static final String ORGNUMBER = "orgnumber";
    private static final String COMASSIST = "comassist";
    private static final String SRC_CURRENCY = "Currency";
    private static final String ALL = "*";
    private static final String SPLIT = "|";
    private Set<String> fetchTypeSet;
    private Set<String> calcFetchType;
    private Set<String> bookTypeSet;
    private Map<String, Set<String>> accountNumMap;
    private Map<String, Integer> accountDcMap;
    private SingleMapModel singleMapModel;
    private Pair<Set<String>, Set<String>> singleDim;
    private Pair<Set<String>, Set<String>> defDim;
    private StdMdDataSet dataSet;
    private boolean multiCurrency = false;

    public GLBalanceDataProvider(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected void beforeLoadData() {
        this.buildSingleMapModel();
        this.dealCurrency2OtherMap();
        this.buildSrcInfoSet();
        this.singleDim = IntegrationUtil.getAsstInSingle(this._ctx);
        this.defDim = IntegrationUtil.getAsstInSrcDef(this._ctx);
        this.dataSet = new StdMdDataSet();
    }

    private void buildSingleMapModel() {
        DimensionMsgCache dimCache = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.PERIOD.getNumber()));
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        filter.and("number", "=", (Object)SRC_CURRENCY);
        DynamicObject srcCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isbaseentlist", (String)"id,number", (QFilter[])new QFilter[]{filter});
        this.singleMapModel.buildSrc(srcCurrency.getLong("id"));
    }

    private void dealCurrency2OtherMap() {
        Long currencyMapId = IntegrationUtil.getDefinedToCurrencyMap(this._ctx);
        if (currencyMapId != 0L) {
            this.multiCurrency = true;
        }
    }

    private void buildSrcInfoSet() {
        this.fetchTypeSet = new HashSet<String>(16);
        this.bookTypeSet = new HashSet<String>(16);
        this.calcFetchType = new HashSet<String>(16);
        this._ctx.getCombineMappedGroup().forEach(e -> e.forEach(mappedRow -> {
            String fetchType = mappedRow.getSrcMapped().get("ChangeType").getNumber().toLowerCase(Locale.ENGLISH);
            if (fetchType.contains(SPLIT)) {
                fetchType = fetchType.split("\\|")[0];
            }
            switch (fetchType) {
                case "fs": 
                case "sy": {
                    this.fetchTypeSet.add("debitlocal");
                    this.fetchTypeSet.add("creditlocal");
                    this.calcFetchType.add(fetchType);
                    break;
                }
                case "lj": 
                case "sl": {
                    this.fetchTypeSet.add("yeardebitlocal");
                    this.fetchTypeSet.add("yearcreditlocal");
                    this.calcFetchType.add(fetchType);
                    break;
                }
                case "cy": {
                    this.fetchTypeSet.add("yeardebitlocal");
                    this.fetchTypeSet.add("yearcreditlocal");
                    this.fetchTypeSet.add("endlocal");
                    this.calcFetchType.add(fetchType);
                    break;
                }
                default: {
                    if (fetchType.endsWith("all")) {
                        this.fetchTypeSet.add(fetchType.replace("all", "local"));
                        this.fetchTypeSet.add(fetchType.replace("all", "for"));
                        break;
                    }
                    this.fetchTypeSet.add(fetchType);
                }
            }
            MappedSourceItem bookType = mappedRow.getSrcMapped().get("AccountBookType");
            if (bookType != null) {
                this.bookTypeSet.add(bookType.getNumber());
            }
        }));
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        Map<String, Object> srcOrgMap = IntegrationUtil.getSrcOrgProfitCenter(this._ctx, this.singleMapModel);
        Pair srcOrg = Pair.onePair((Object)((Long)srcOrgMap.get(ORGID)), (Object)((String)srcOrgMap.get(ORGNUMBER)));
        String GLPeriod = this.getGLPeriodNum();
        this.checkAccountBookClose((String)srcOrg.p2, this.bookTypeSet, GLPeriod.substring(0, 4), GLPeriod.substring(4));
        String srcCurrency = this.getSrcCurrency();
        this.setMessage2ctx((Pair<Long, String>)srcOrg, GLPeriod, srcCurrency);
        for (String bookType : this.bookTypeSet) {
            Tuple<Long, String, Long> bookInfo = this.getAccountBookInfo((Pair<Long, String>)srcOrg, bookType, GLPeriod);
            this.buildAccountMap((Long)srcOrg.p1, (Long)bookInfo.p1, (Long)bookInfo.p3, GLPeriod);
            BalanceQueryParamApi noSubParam = this.buildQueryParam(false, bookType, (String)srcOrg.p2, srcCurrency, GLPeriod, (String)bookInfo.p2);
            BalanceQueryParamApi subParam = this.buildQueryParam(true, bookType, (String)srcOrg.p2, srcCurrency, GLPeriod, (String)bookInfo.p2);
            HashSet<String> comassist = new HashSet<String>(16);
            comassist.addAll((Collection)this.singleDim.p2);
            comassist.addAll((Collection)this.defDim.p2);
            this._ctx.getCombineMappedGroup().forEach(e -> e.forEach(mappedRow -> {
                if (!bookType.equals(mappedRow.getSrcMapped().get("AccountBookType").getNumber())) {
                    return;
                }
                String fetchType = mappedRow.getSrcMapped().get("ChangeType").getNumber();
                boolean needSub = "SY".equalsIgnoreCase(fetchType) || "SL".equalsIgnoreCase(fetchType);
                MappedSourceItem srcAccount = mappedRow.getSrcMapped().get("AccountView");
                Set<String> queryAccount = this.getQueryAccount(srcAccount);
                for (String account : queryAccount) {
                    Set<String> asstNumSet = this.accountNumMap.get(account);
                    Pair<Set<String>, Set<String>> comboDim = IntegrationUtil.getAsstInCombo(mappedRow, this._ctx);
                    Set<String> allAsst = IntegrationUtil.getAsstInAll((Set)comboDim.p1, (Set)this.singleDim.p1, (Set)this.defDim.p1);
                    comassist.addAll((Collection)comboDim.p2);
                    allAsst.retainAll(asstNumSet);
                    HashMap<String, String> assGroup = new HashMap<String, String>();
                    allAsst.forEach(num -> {
                        String cfr_ignored_0 = assGroup.put((String)num, (String)null);
                    });
                    if (needSub) {
                        subParam.addAccountAssgrp(account, assGroup);
                        assGroup.keySet().forEach(subParam::addGroupBy);
                        continue;
                    }
                    noSubParam.addAccountAssgrp(account, assGroup);
                    assGroup.keySet().forEach(noSubParam::addGroupBy);
                }
            }));
            HashMap<Tuple<String, Map<String, Map<String, String>>, Map<String, Map<String, String>>>, StdMdRow> rowMap = new HashMap<Tuple<String, Map<String, Map<String, String>>, Map<String, Map<String, String>>>, StdMdRow>(16);
            if (!noSubParam.getAccountAssgrp().isEmpty()) {
                this.addComassist(noSubParam, comassist, srcOrgMap);
                Map<String, Object> noSubResult = this._ctx.getModel().p2 != null && ((String)this._ctx.getModel().p2).contains("930UnitTest12") ? IntegrationUtil.getGLReturn() : GlServiceHelper.getBalance(noSubParam, this._ctx);
                this.collectData(noSubResult, false, bookType, rowMap);
            }
            if (!subParam.getAccountAssgrp().isEmpty()) {
                this.addComassist(subParam, comassist, srcOrgMap);
                Map<String, Object> subResult = GlServiceHelper.getBalance(subParam, this._ctx);
                this.collectData(subResult, true, bookType, rowMap);
            }
            if (rowMap.isEmpty()) continue;
            rowMap.values().forEach(r -> this.dataSet.addRow((StdMdRow)r));
        }
        this.clearZeroRow();
        return this.dataSet;
    }

    private void checkAccountBookClose(String orgNumber, Set<String> bookTypes, String yearNum, String periodNum) {
        for (String bookType : this.bookTypeSet) {
            boolean bookClose = GlServiceHelper.isAccountBookClose(this._ctx, orgNumber, bookType, yearNum, periodNum);
            if (bookClose) continue;
            String errorInfo = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed3\u8d26\uff0c\u518d\u8fdb\u884c\u53d6\u6570\u3002\u6216\u8005\u8c03\u6574\u540e\u53f0\u53c2\u6570\uff0c\u5141\u8bb8\u5728\u603b\u8d26\u7ed3\u8d26\u524d\u53d6\u6570\u3002\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\uff0c\u5e74\u4efd\uff1a%3$s\uff0c\u671f\u95f4\uff1a%4$s\u3002", (String)"GLBalanceDataProvider_7", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumber, bookType, yearNum, periodNum);
            throw new KDBizException(errorInfo);
        }
    }

    private void setMessage2ctx(Pair<Long, String> srcOrg, String GLPeriod, String srcCurrency) {
        this._ctx.setMapOrg(srcOrg);
        this._ctx.setMapPeriod((Pair<Long, String>)Pair.onePair((Object)0L, (Object)GLPeriod));
        this._ctx.setMapCurrency((Pair<Long, String>)Pair.onePair((Object)0L, (Object)srcCurrency));
    }

    private Tuple<Long, String, Long> getAccountBookInfo(Pair<Long, String> srcOrg, String bookType, String glPeriod) {
        String accountBookEntity = IntergrationUtil.getAccountBookMetadataNumber();
        QFilter orgFilter = new QFilter("org.number", "=", srcOrg.p2);
        QFilter bookFilter = new QFilter("bookstype.number", "=", (Object)bookType);
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)accountBookEntity, (String)"accounttable.number,accounttable.id,periodType.number,periodType.id", (QFilter[])new QFilter[]{orgFilter, bookFilter});
        if (book == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\u5bf9\u5e94\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"GLBalanceDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), srcOrg.p2, bookType));
        }
        Long periodType = book.getLong("periodType.id");
        try {
            Class<?> clz = Class.forName("kd.bos.ext.fi.accountref.AccountRefUtils");
            Method method = clz.getMethod("getCurPeriodAccountTableId", Long.TYPE, Long.TYPE, Long.TYPE);
            QFilter filter = new QFilter("number", "=", (Object)bookType);
            long bookTypeId = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
            filter = new QFilter("number", "=", (Object)glPeriod);
            filter.and("periodtype", "=", (Object)periodType);
            long periodId = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
            long accountTable = (Long)method.invoke(null, srcOrg.p1, bookTypeId, periodId);
            filter = new QFilter("id", "=", (Object)accountTable);
            String accountTableNum = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"id,number", (QFilter[])new QFilter[]{filter}).getString("number");
            return Tuple.create((Object)accountTable, (Object)accountTableNum, (Object)periodType);
        }
        catch (Exception e) {
            return Tuple.create((Object)book.getLong("accounttable.id"), (Object)book.getString("accounttable.number"), (Object)periodType);
        }
    }

    private BalanceQueryParamApi buildQueryParam(boolean isSub, String bookType, String org, String currency, String period, String accountTable) {
        BalanceQueryParamApi param = new BalanceQueryParamApi();
        param.setBookTypeNumber(bookType);
        param.addGroupBy("account.number account");
        param.setOrgNumber(org);
        param.setCurrencyNumber(currency);
        param.setPeriodNumber(period);
        param.setAccountTableNumber(accountTable);
        this.fetchTypeSet.forEach(param::addSelector);
        param.setSubstractPL(isSub);
        if (this.multiCurrency) {
            param.setCurrencyNumber("");
            param.addGroupBy("currency.number currency");
        }
        return param;
    }

    private void addComassist(BalanceQueryParamApi param, Set<String> comassist, Map<String, Object> srcOrgMap) {
        if (srcOrgMap.get(COMASSIST) != null) {
            param.setComassist((Map)srcOrgMap.get(COMASSIST));
        } else if (!comassist.isEmpty()) {
            HashMap<String, List<String>> comassistMap = new HashMap<String, List<String>>();
            comassist.forEach(e -> {
                param.addGroupBy((String)e);
                comassistMap.put((String)e, (List<String>)null);
            });
            param.setComassist(comassistMap);
        }
    }

    private Set<String> getQueryAccount(MappedSourceItem srcAccount) {
        if (ALL.equals(srcAccount.getNumber())) {
            return this.accountNumMap.keySet();
        }
        HashSet<String> result = new HashSet<String>();
        IFilter<String> filter = FilterFactory.getFilter(srcAccount, this._ctx);
        this.accountNumMap.keySet().forEach(e -> {
            if (filter.isMatched(srcAccount, (String)e, this._ctx)) {
                result.add((String)e);
            }
        });
        return result;
    }

    private void collectData(Map<String, Object> result, boolean isSub, String bookType, Map<Tuple<String, Map<String, Map<String, String>>, Map<String, Map<String, String>>>, StdMdRow> rowMap) {
        List dataList;
        String glData;
        if (!((Boolean)result.get("getSuccess")).booleanValue()) {
            String errMsg = (String)this._ctx.getCustomParam("mappingErrMsg");
            if (errMsg == null) {
                errMsg = "";
            }
            errMsg = errMsg + result.get("getMessage");
            this._ctx.putCustomParam("mappingErrMsg", errMsg);
        }
        if ((glData = (String)result.get("getData")) == null) {
            return;
        }
        try {
            dataList = (List)JSONUtils.cast((String)glData, List.class);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        for (Map data : dataList) {
            String s;
            Tuple key;
            StdMdRow row;
            data.put("booktype", bookType);
            String accountNum = data.get("account").toString();
            String currency = data.get("currency") == null ? "null" : data.get("currency").toString();
            Map assgrp = (Map)data.get("assgrp");
            Map comassist = (Map)data.get(COMASSIST);
            if (assgrp != null && assgrp.isEmpty()) {
                assgrp = null;
            }
            if (comassist != null && comassist.isEmpty()) {
                comassist = null;
            }
            if ((row = rowMap.get(key = Tuple.create((Object)(s = accountNum + SPLIT + currency), (Object)assgrp, (Object)comassist))) == null) {
                row = new StdMdRow(data);
                rowMap.put((Tuple<String, Map<String, Map<String, String>>, Map<String, Map<String, String>>>)key, row);
            }
            this.dealCalcFetchType(data, isSub, row);
        }
    }

    private void dealCalcFetchType(Map<String, Object> data, boolean isSub, StdMdRow row) {
        String accountNum = data.get("account").toString();
        BigDecimal dc = new BigDecimal(this.accountDcMap.get(accountNum));
        if (isSub) {
            if (this.calcFetchType.contains("sy")) {
                BigDecimal debitLocal = new BigDecimal(data.get("debitlocal").toString());
                BigDecimal creditLocal = new BigDecimal(data.get("creditlocal").toString());
                BigDecimal sy = debitLocal.subtract(creditLocal).multiply(dc);
                row.put("sy", sy);
            }
            if (this.calcFetchType.contains("sl")) {
                BigDecimal yearDebitLocal = new BigDecimal(data.get("yeardebitlocal").toString());
                BigDecimal yearCreditLocal = new BigDecimal(data.get("yearcreditlocal").toString());
                BigDecimal sl = yearDebitLocal.subtract(yearCreditLocal).multiply(dc);
                row.put("sl", sl);
            }
        } else {
            BigDecimal yearCreditLocal;
            BigDecimal yearDebitLocal;
            if (this.calcFetchType.contains("fs")) {
                BigDecimal debitLocal = new BigDecimal(data.get("debitlocal").toString());
                BigDecimal creditLocal = new BigDecimal(data.get("creditlocal").toString());
                BigDecimal sy = debitLocal.subtract(creditLocal).multiply(dc);
                row.put("fs", sy);
            }
            if (this.calcFetchType.contains("lj")) {
                yearDebitLocal = new BigDecimal(data.get("yeardebitlocal").toString());
                yearCreditLocal = new BigDecimal(data.get("yearcreditlocal").toString());
                BigDecimal sl = yearDebitLocal.subtract(yearCreditLocal).multiply(dc);
                row.put("lj", sl);
            }
            if (this.calcFetchType.contains("cy")) {
                BigDecimal endLocal = new BigDecimal(data.get("endlocal").toString());
                yearDebitLocal = new BigDecimal(data.get("yeardebitlocal").toString());
                yearCreditLocal = new BigDecimal(data.get("yearcreditlocal").toString());
                BigDecimal sl = yearDebitLocal.subtract(yearCreditLocal).multiply(dc);
                BigDecimal cy = endLocal.subtract(sl);
                row.put("cy", cy);
            }
        }
    }

    private String getGLPeriodNum() {
        String srcPeriod;
        String srcYear;
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        if (fyPair == null) {
            if (this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), ALL) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u8d22\u5e74\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLBalanceDataProvider_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getFy().p2));
            }
            srcYear = ((String)this._ctx.getFy().p2).substring(2);
        } else {
            srcYear = ((String)fyPair.p2).substring(0, 4);
        }
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        try {
            if (periodPair == null) {
                if (this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), ALL) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u671f\u95f4\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLBalanceDataProvider_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getPeriod().p2));
                }
                srcPeriod = ((String)this._ctx.getPeriod().p2).substring(3);
            } else {
                srcPeriod = ((String)periodPair.p2).substring(4);
            }
        }
        catch (Exception e) {
            log.error("periodPair is error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u683c\u5f0f\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"GLFormulaDataProvider_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return srcYear + srcPeriod;
    }

    private String getSrcCurrency() {
        Pair<Long, String> currencyPair = this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2);
        String srcCurrency = currencyPair == null ? (this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), ALL) == null ? "" : (String)this._ctx.getCurrency().p2) : (String)currencyPair.p2;
        return srcCurrency;
    }

    private void buildAccountMap(Long orgId, Long accountTableId, long periodType, String GLPeriod) {
        QFilter periodf1 = new QFilter("periodtype", "=", (Object)periodType);
        QFilter periodf2 = new QFilter("number", "=", (Object)GLPeriod);
        DynamicObject truePeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{periodf1, periodf2});
        if (truePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u201c%1$s\u201d\u4e0b\u7684\u6e90\u671f\u95f4\u201c%2$s\u201d\u3002", (String)"GLBalanceDataProvider_4", (String)"fi-bcm-business", (Object[])new Object[0]), periodType, GLPeriod));
        }
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        qfilter.and("accounttable", "=", (Object)accountTableId);
        qfilter.and(new QFilter("startdate", "<=", (Object)truePeriod.getDate("enddate")));
        qfilter.and(new QFilter("enddate", ">=", (Object)truePeriod.getDate("enddate")));
        DynamicObject[] accountColl = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"number,dc,checkitementry, checkitementry.asstactitem, checkitementry.asstactitem.number", (QFilter[])new QFilter[]{qfilter});
        this.accountNumMap = new HashMap<String, Set<String>>(16);
        this.accountDcMap = new HashMap<String, Integer>(16);
        for (DynamicObject account : accountColl) {
            String number = account.getString("number");
            HashSet asstNumSet = new HashSet();
            account.getDynamicObjectCollection("checkitementry").forEach(e -> asstNumSet.add(e.getString("asstactitem.number")));
            this.accountNumMap.put(number, asstNumSet);
            this.accountDcMap.put(number, account.getInt("dc"));
        }
    }

    private void clearZeroRow() {
        Iterator<IRow> iterator = this.dataSet.iterator();
        while (iterator.hasNext()) {
            Object value;
            IRow row = iterator.next();
            boolean allZero = true;
            for (String fetchType : this.fetchTypeSet) {
                value = row.get(fetchType);
                if (!(value instanceof Number) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) continue;
                allZero = false;
                break;
            }
            for (String fetchType : this.calcFetchType) {
                value = row.get(fetchType);
                if (!(value instanceof Number) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) continue;
                allZero = false;
                break;
            }
            if (!allZero) continue;
            iterator.remove();
        }
    }
}

