/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.formula;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedMembItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaDataSet;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaRow;
import kd.fi.bcm.business.integrationnew.provider.formula.model.CalcParam;
import kd.fi.bcm.business.integrationnew.provider.formula.model.SheetFormula;
import kd.fi.bcm.business.integrationnew.provider.formula.ws.WebServiceClient;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;

public class FormulaDataProvider
extends AbstractDataProvider {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, FormulaDataProvider.class);
    private DimensionMsgCache dim;
    private SingleMapModel singleMapModel;
    private static final String ALL = "*";
    private static final String ENTITY = "Entity";
    private static final String CURRENCY = "Currency";
    private static final String YEAR = "Year";
    private static final String PERIOD = "Period";

    public FormulaDataProvider(IIntegrateContext ctx) {
        super(ctx);
        this.dim = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        log.info("FormulaDataProvider.doLoadData.start");
        FormulaDataSet ds = new FormulaDataSet();
        ArrayList<String> error = new ArrayList<String>();
        List<Map<String, Object>> batchresult = this.getAmont();
        if (batchresult == null || batchresult.size() == 0) {
            return ds;
        }
        for (Map<String, Object> result : batchresult) {
            Object[] amountresult;
            if (result == null || result.size() == 0) continue;
            if (result.get("error") != null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff1a%s\u3002", (String)"FormulaDataProvider_0", (String)"fi-bcm-business", (Object[])new Object[0]), result.get("error")));
            }
            for (Object bookformulasObj : amountresult = (Object[])result.get("calcparams")) {
                Map bookformulas = (Map)bookformulasObj;
                if (bookformulas.get("error") != null) {
                    error.add(bookformulas.get("error").toString());
                    continue;
                }
                Map sheets = (Map)bookformulas.get("bookformulas");
                for (Map.Entry sheet : sheets.entrySet()) {
                    Map sheetmsg = (Map)sheet.getValue();
                    Map formulas = (Map)sheetmsg.get("formulas");
                    for (Map.Entry formula : formulas.entrySet()) {
                        FormulaRow row = new FormulaRow((String)formula.getKey(), formula.getValue());
                        ds.addRow(row);
                    }
                }
            }
        }
        log.info("FormulaDataProvider.doLoadData.end ds size :" + ds.getSize());
        return ds;
    }

    private List<Map<String, Object>> buildParam() {
        Table<String, String, String> formula = this.getFormulaTable();
        ArrayList<Map<String, Object>> calcParams = new ArrayList<Map<String, Object>>(formula.size());
        for (String rpnum : formula.rowKeySet()) {
            CalcParam c = this.getComCalcParam();
            c.setPeriodtype(rpnum);
            SheetFormula sf = new SheetFormula((Long)this._ctx.getSchema().p1);
            for (Map.Entry f : formula.row((Object)rpnum).entrySet()) {
                sf.addFormula((String)f.getKey(), (String)f.getValue());
            }
            c.addSheetFormula("sheet1", sf);
            calcParams.add(c.toMap());
        }
        return calcParams;
    }

    private List<Map<String, Object>> batchCalcParam(int size) {
        ArrayList<Map<String, Object>> calcParams = new ArrayList<Map<String, Object>>();
        Table<String, String, String> formula = this.getFormulaTable();
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isformulasetting", (String)"includeposted,includeleaf,includeleafaccount,includesub,includesubaccount,includeallassistitems", (QFilter[])new QFilter[]{QFilter.of((String)"scheme = ?", (Object[])new Object[]{this._ctx.getSchema().p1})});
        for (String rpnum : formula.rowKeySet()) {
            int i = 0;
            SheetFormula sf = new SheetFormula(scheme);
            for (Map.Entry f : formula.row((Object)rpnum).entrySet()) {
                if (i == size) {
                    i = 0;
                    CalcParam c = this.getComCalcParam();
                    c.setPeriodtype(rpnum);
                    c.addSheetFormula("sheet1", sf);
                    calcParams.add(c.toMap());
                    sf = new SheetFormula(scheme);
                }
                sf.addFormula((String)f.getKey(), (String)f.getValue());
                ++i;
            }
            CalcParam c = this.getComCalcParam();
            c.setPeriodtype(rpnum);
            c.addSheetFormula("sheet1", sf);
            calcParams.add(c.toMap());
        }
        return calcParams;
    }

    private Table<String, String, String> getFormulaTable() {
        HashBasedTable formula = HashBasedTable.create();
        if (this._ctx.getFormulaMappedGroup() == null || this._ctx.getFormulaMappedGroup().size() == 0) {
            return formula;
        }
        Map<String, List<String>> numbers = this.getNumbersByFormula();
        for (MappedGroup mg : this._ctx.getFormulaMappedGroup()) {
            for (MappedRow row : mg) {
                Map<String, String> map = this.analysisFormula(row, numbers);
                if (map == null) {
                    formula.put((Object)"MONTHLY", (Object)row.getUuid(), (Object)row.getExpression());
                    continue;
                }
                for (Map.Entry<String, String> fomu : map.entrySet()) {
                    formula.put((Object)"MONTHLY", (Object)(row.getUuid() + "|" + fomu.getKey()), (Object)fomu.getValue());
                }
            }
        }
        return formula;
    }

    private Map<String, List<String>> getNumbersByFormula() {
        HashMap<String, List<String>> formulaToNumber = new HashMap<String, List<String>>();
        try {
            Object[] accts;
            Map<String, Object> filter = this.getFormulaFilter();
            log.startWatch();
            log.info("FormulaDataProvider.getNumbersByFormula filter:" + JSON.toJSONString(filter));
            Long startTime = System.currentTimeMillis();
            Map result = (Map)WebServiceClient.getInstance().callGetDynItemData((Long)this._ctx.getSchema().p1, filter);
            IntegrationUtil.addTimeUse(this._ctx, startTime, "callGetDynItemData");
            log.info(String.format("scheme %s org %s FormulaDataProvider.callGetDynItemData cost", this._ctx.getSchema().p2, this._ctx.getOrg().p2));
            for (Object acct : accts = (Object[])result.get("acct")) {
                Map map = (Map)acct;
                Object[] numbers = (Object[])map.get("asst");
                ArrayList<String> nums = new ArrayList<String>(numbers.length);
                for (Object n : numbers) {
                    nums.add(n.toString());
                }
                formulaToNumber.put(map.get("formulaid").toString(), nums);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        return formulaToNumber;
    }

    private Map<String, Object> getFormulaFilter() {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        this.restoreAll();
        if (this.singleMapModel.getSrc(DimTypesEnum.ENTITY.getNumber(), (String)this._ctx.getOrg().p2) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6620\u5c04\u7ec4\u7ec7\u3002", (String)"FormulaDataProvider_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6620\u5c04\u5e01\u79cd\u3002", (String)"FormulaDataProvider_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6620\u5c04\u7684\u8d22\u5e74\u3002", (String)"FormulaDataProvider_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6620\u5c04\u671f\u95f4\u3002", (String)"FormulaDataProvider_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String org = (String)this.singleMapModel.getSrc((String)DimTypesEnum.ENTITY.getNumber(), (String)((String)this._ctx.getOrg().p2)).p2;
        String cur = (String)this.singleMapModel.getSrc((String)DimTypesEnum.CURRENCY.getNumber(), (String)((String)this._ctx.getCurrency().p2)).p2;
        String fy = (String)this.singleMapModel.getSrc((String)DimTypesEnum.YEAR.getNumber(), (String)((String)this._ctx.getFy().p2)).p2;
        String per = (String)this.singleMapModel.getSrc((String)DimTypesEnum.PERIOD.getNumber(), (String)((String)this._ctx.getPeriod().p2)).p2;
        filter.put("org", org);
        filter.put("currency", cur);
        filter.put("year", fy);
        filter.put("period", per);
        filter.put("periodType", "MONTHLY");
        ArrayList acctlist = new ArrayList();
        HashMap asstRef = new HashMap();
        for (MappedGroup mg : this._ctx.getFormulaMappedGroup()) {
            for (MappedRow row : mg) {
                String formula = row.getExpression();
                String dimNum = null;
                String pattern = "\\|(.+?)\\|@";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(formula);
                if (m.find()) {
                    dimNum = m.group(1);
                }
                if (dimNum == null) continue;
                List<String> mydims = this.getMyDimByEasDim(dimNum);
                String mydim = null;
                String mydimmemnumber = null;
                String leafmydimmemnumber = null;
                for (MappedMembItem mappedMembItem : row.getTargMapped().values()) {
                    if (!mydims.contains(mappedMembItem.getMappedDim().getNumber())) continue;
                    if (this._ctx.isNonLeafMemb(mappedMembItem)) {
                        mydimmemnumber = mappedMembItem.getNumber();
                        mydim = mappedMembItem.getMappedDim().getNumber();
                        break;
                    }
                    leafmydimmemnumber = mappedMembItem.getNumber();
                }
                if (mydims.size() == 1) {
                    mydim = mydims.get(0);
                    if (leafmydimmemnumber != null) {
                        mydimmemnumber = leafmydimmemnumber;
                    }
                }
                if (mydim == null) {
                    return null;
                }
                this.singleMapModel.buildSrc(this._ctx.getMappedRelation().getSingleDimRelaBySrcAndTargDim(dimNum, mydim));
                Map<String, Pair<Long, String>> numberMap = this.singleMapModel.getMapBySor(dimNum);
                this._ctx.getMemsCache().setNeedLongNumber(true);
                Object mdlm = this._ctx.getMemsCache().getMsg(mydim, mydimmemnumber, "longnumber");
                String mydimmemlongnumber = mdlm == null ? "" : mdlm.toString();
                String key = dimNum + mydimmemnumber;
                ArrayList<String> asst = (ArrayList<String>)asstRef.get(key);
                if (asst == null) {
                    asst = new ArrayList<String>();
                    for (Map.Entry<String, Pair<Long, String>> tarnumber : numberMap.entrySet()) {
                        if (leafmydimmemnumber != null) {
                            asst.add(tarnumber.getKey());
                            break;
                        }
                        Object longnumber = this._ctx.getMemsCache().getMsg(mydim, (String)tarnumber.getValue().p2, "longnumber");
                        Object number = this._ctx.getMemsCache().getMsg(mydim, (String)tarnumber.getValue().p2, "number");
                        if (longnumber == null || !longnumber.toString().contains(mydimmemlongnumber + '!')) continue;
                        asst.add(tarnumber.getKey());
                    }
                    asstRef.put(key, asst);
                }
                this._ctx.getMemsCache().setNeedLongNumber(false);
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                newMap.put("formulaid", row.getUuid());
                newMap.put("formula", this.transFormula(formula));
                newMap.put("asstRef", key);
                newMap.put("asst", new ArrayList());
                acctlist.add(newMap);
            }
        }
        filter.put("acct", acctlist);
        filter.put("asstRef", asstRef);
        return filter;
    }

    private void restoreAll() {
        Table<String, String, Pair<Long, String>> tarMapsrcMemb = this.singleMapModel.getTarMapsrcMemb();
        Table<String, String, Pair<Long, String>> tarMapsrcMembCopy = this.getTarMapsrcMembCopy(tarMapsrcMemb);
        for (Table.Cell cell : tarMapsrcMembCopy.cellSet()) {
            switch ((String)cell.getRowKey()) {
                case "Entity": {
                    if (!ALL.equals(cell.getColumnKey()) || tarMapsrcMemb.get((Object)ENTITY, this._ctx.getOrg().p2) != null) break;
                    tarMapsrcMemb.remove((Object)ENTITY, (Object)ALL);
                    tarMapsrcMemb.put((Object)ENTITY, this._ctx.getOrg().p2, (Object)Pair.onePair((Object)0L, (Object)this._ctx.getOrg().p2));
                    break;
                }
                case "Currency": {
                    if (!ALL.equals(cell.getColumnKey()) || tarMapsrcMemb.get((Object)CURRENCY, this._ctx.getCurrency().p2) != null) break;
                    tarMapsrcMemb.remove((Object)CURRENCY, (Object)ALL);
                    tarMapsrcMemb.put((Object)CURRENCY, this._ctx.getCurrency().p2, (Object)Pair.onePair((Object)0L, (Object)this._ctx.getCurrency().p2));
                    break;
                }
                case "Year": {
                    if (!ALL.equals(cell.getColumnKey()) || tarMapsrcMemb.get((Object)YEAR, this._ctx.getFy().p2) != null) break;
                    tarMapsrcMemb.remove((Object)YEAR, (Object)ALL);
                    tarMapsrcMemb.put((Object)YEAR, this._ctx.getFy().p2, (Object)Pair.onePair((Object)0L, (Object)this._ctx.getFy().p2));
                    break;
                }
                case "Period": {
                    if (!ALL.equals(cell.getColumnKey()) || tarMapsrcMemb.get((Object)PERIOD, this._ctx.getPeriod().p2) != null) break;
                    tarMapsrcMemb.remove((Object)PERIOD, (Object)ALL);
                    tarMapsrcMemb.put((Object)PERIOD, this._ctx.getPeriod().p2, (Object)Pair.onePair((Object)0L, (Object)this._ctx.getPeriod().p2));
                    break;
                }
            }
        }
    }

    private Table<String, String, Pair<Long, String>> getTarMapsrcMembCopy(Table<String, String, Pair<Long, String>> tarMapsrcMemb) {
        HashBasedTable tarMapsrcMembCopy = HashBasedTable.create();
        for (Table.Cell cell : tarMapsrcMemb.cellSet()) {
            tarMapsrcMembCopy.put(cell.getRowKey(), cell.getColumnKey(), (Object)Pair.onePair((Object)((Pair)cell.getValue()).p1, (Object)((Pair)cell.getValue()).p2));
        }
        return tarMapsrcMembCopy;
    }

    private String transFormula(String formula) {
        String newformula = formula;
        String pattern = "\"([^\"]+?)@";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(formula);
        if (m.find()) {
            newformula = m.group();
            newformula = "if(ACCT(\"\"," + newformula + "\",\"\",0,0,0,0,\"\",\"\")>0," + formula + ",0)";
        }
        return newformula;
    }

    private Map<String, String> analysisFormula(MappedRow row, Map<String, List<String>> numbwes) {
        String formula = row.getExpression();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!formula.contains("@")) {
            return null;
        }
        String dimNum = null;
        String pattern = "\\|(.+?)\\|@";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(formula);
        if (m.find()) {
            dimNum = m.group(1);
        }
        if (dimNum != null) {
            List<String> mydims = this.getMyDimByEasDim(dimNum);
            String mydim = null;
            String mydimmemnumber = null;
            String leafmydimmemnumber = null;
            for (MappedMembItem mappedMembItem : row.getTargMapped().values()) {
                if (!mydims.contains(mappedMembItem.getMappedDim().getNumber())) continue;
                if (this._ctx.isNonLeafMemb(mappedMembItem)) {
                    mydimmemnumber = mappedMembItem.getNumber();
                    mydim = mappedMembItem.getMappedDim().getNumber();
                    break;
                }
                leafmydimmemnumber = mappedMembItem.getNumber();
            }
            if (mydims.size() == 1) {
                mydim = mydims.get(0);
            }
            if (mydim == null) {
                return null;
            }
            this.singleMapModel.buildSrc(this._ctx.getMappedRelation().getSingleDimRelaBySrcAndTargDim(dimNum, mydim));
            Map<String, Pair<Long, String>> numberMap = this.singleMapModel.getMapBySor(dimNum);
            if (numberMap == null || numberMap.size() == 0) {
                return map;
            }
            List<String> eashasvalueNumbers = numbwes.get(row.getUuid());
            for (String eashasvaluenumber : eashasvalueNumbers) {
                Pair<Long, String> p = numberMap.get(eashasvaluenumber);
                String string = formula.replaceAll("@", eashasvaluenumber);
                map.put(mydim + "|" + (String)p.p2, string);
            }
        }
        return map;
    }

    private List<String> getMyDimByEasDim(String easNumber) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> dims = this.dim.getAllDimension();
        for (String dimNum : dims) {
            DimMappedRelation.SingleDimRelationPair sp = this._ctx.getMappedRelation().getSingleDimRelaBySrcAndTargDim(easNumber, dimNum);
            if (sp == null) continue;
            result.add(dimNum);
        }
        if (result.size() > 0) {
            return result;
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801%s\u3002", (String)"FormulaDataProvider_4", (String)"fi-bcm-business", (Object[])new Object[0]), easNumber));
    }

    private List<Map<String, Object>> getAmont() {
        List<Map<String, Object>> batchparms = this.batchCalcParam(2000);
        Vector<Map<String, Object>> batchresult = new Vector<Map<String, Object>>();
        if (batchparms.size() == 0) {
            return batchresult;
        }
        log.startWatch();
        Long startTime = System.currentTimeMillis();
        ArrayList exceptionList = new ArrayList(16);
        try {
            CountDownLatch latch = new CountDownLatch(batchparms.size());
            log.info(String.format("scheme %s org %s FormulaDataProvider.calcFormulaValues start", this._ctx.getSchema().p2, this._ctx.getOrg().p2));
            log.info("FormulaDataProvider.getAmont batchparms size:" + batchparms.size());
            for (Map<String, Object> singleparm : batchparms) {
                ThreadPoolService.runInThread(() -> {
                    try {
                        ArrayList<Map<String, Object>> parms = new ArrayList<Map<String, Object>>();
                        parms.add(singleparm);
                        Map result = (Map)WebServiceClient.getInstance().calcFormulaValues((Long)this._ctx.getSchema().p1, parms);
                        batchresult.add(result);
                    }
                    catch (Exception e) {
                        exceptionList.add(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            latch.await();
            if (exceptionList.size() > 0) {
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)((Throwable)exceptionList.get(0)), (int)30));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
        IntegrationUtil.addTimeUse(this._ctx, startTime, "calcFormulaValues");
        log.info(String.format("scheme %s org %s FormulaDataProvider.calcFormulaValues cost", this._ctx.getSchema().p2, this._ctx.getOrg().p2));
        return batchresult;
    }

    private String getConfigPage() {
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"isscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", this._ctx.getSchema().p1)});
        DynamicObject sys_conn_config = QueryServiceHelper.queryOne((String)"ds_srcsys", (String)"sys_conn_config", (QFilter[])new QFilter[]{new QFilter("id", "=", scheme.get("isscheme"))});
        if (sys_conn_config == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u672a\u627e\u5230\u7cfb\u7edf\u8fde\u63a5\u914d\u7f6e\u4fe1\u606f\u3002", (String)"FormulaDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject cfgpageid = QueryServiceHelper.queryOne((String)"bas_externalsys", (String)"cfgpageid", (QFilter[])new QFilter[]{new QFilter("id", "=", sys_conn_config.get("sys_conn_config"))});
        if (cfgpageid == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u516c\u5f0f\u53d6\u6570\u7684\u914d\u7f6e\u9875\u9762\u3002", (String)"FormulaDataProvider_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return cfgpageid.getString("cfgpageid");
    }

    private CalcParam getComCalcParam() {
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        String org = (String)this.singleMapModel.getSrc((String)DimTypesEnum.ENTITY.getNumber(), (String)((String)this._ctx.getOrg().p2)).p2;
        String cur = (String)this.singleMapModel.getSrc((String)DimTypesEnum.CURRENCY.getNumber(), (String)((String)this._ctx.getCurrency().p2)).p2;
        String fy = (String)this.singleMapModel.getSrc((String)DimTypesEnum.YEAR.getNumber(), (String)((String)this._ctx.getFy().p2)).p2;
        String per = (String)this.singleMapModel.getSrc((String)DimTypesEnum.PERIOD.getNumber(), (String)((String)this._ctx.getPeriod().p2)).p2;
        CalcParam c = new CalcParam(org, cur, fy, per);
        return c;
    }
}

