/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;

public class FormulaRow
implements IRow {
    private String formulaKey;
    private Object formulaValue;
    private boolean isNumber;
    private List<String> fitNumber;
    private List<String> fitDim;
    private String error;
    private DataTraceFrom dataTraceFrom;

    public FormulaRow(String formulaKey, Object formulaValue) {
        String[] keys = formulaKey.split("\\|");
        if (keys.length == 1) {
            this.formulaKey = formulaKey;
        } else {
            this.formulaKey = keys[0];
            this.fitDim = new ArrayList<String>(10);
            this.fitNumber = new ArrayList<String>(10);
            for (int i = 1; i < keys.length; ++i) {
                if (i % 2 == 1) {
                    this.fitDim.add(keys[i]);
                    continue;
                }
                this.fitNumber.add(keys[i]);
            }
        }
        if (formulaValue instanceof Map) {
            Object value = ((Map)formulaValue).get("1");
            if (value != null) {
                this.isNumber = true;
                this.formulaValue = value;
            } else {
                value = ((Map)formulaValue).get("2");
                if (value != null) {
                    this.formulaValue = value;
                } else {
                    value = ((Map)formulaValue).get("-1");
                    this.error = value.toString();
                }
            }
        } else if (formulaValue instanceof BigDecimal) {
            this.isNumber = true;
            this.formulaValue = formulaValue;
        }
    }

    public Object getFormulaValue() {
        return this.formulaValue;
    }

    public String getFormulaKey() {
        return this.formulaKey;
    }

    @Override
    public <T> T get(String mappedKey) {
        if ("formulaKey".equals(mappedKey)) {
            return (T)this.formulaKey;
        }
        if ("formulaValue".equals(mappedKey)) {
            return (T)this.formulaValue;
        }
        return null;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public List<String> getFitDim() {
        return this.fitDim;
    }

    public List<String> getFitNumber() {
        return this.fitNumber;
    }

    public String getError() {
        return this.error;
    }

    public DataTraceFrom getDataTraceFrom() {
        return this.dataTraceFrom;
    }

    public void setDataTraceFrom(DataTraceFrom dataTraceFrom) {
        this.dataTraceFrom = dataTraceFrom;
    }

    public String toString() {
        return "FormulaRow{formulaKey='" + this.formulaKey + '\'' + ", formulaValue=" + this.formulaValue + ", isNumber=" + this.isNumber + ", fitNumber='" + this.fitNumber + '\'' + ", fitDim='" + this.fitDim + '\'' + ", error='" + this.error + '\'' + '}';
    }

    @Override
    public Set<String> getKeySet() {
        return null;
    }
}

