/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.formula;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.CollectCalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.express.FormulaAnalyze;
import kd.fi.bcm.business.formula.model.key.IPackKey;
import kd.fi.bcm.business.formula.model.key.PackKey;
import kd.fi.bcm.business.formula.model.value.ICollectResultHandle;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedMembItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaDataSet;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.CashflowCommonParam;
import kd.fi.bcm.business.model.CashflowQueryParamApi;
import kd.fi.bcm.business.model.GlServiceHelper;
import kd.fi.bcm.business.model.formula.AcctFormulaModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.datacollect.model.RefParamResult;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import kd.fi.bcm.spread.util.CollectCalculateHelp;

public class GLFormulaDataProvider
extends AbstractDataProvider {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(GLFormulaDataProvider.class);
    private final Map<Long, String> baseEntMap = new HashMap<Long, String>(16);
    private final Map<String, String> glDimToBcmDim = new HashMap<String, String>(16);
    private final Map<Long, Pair<String, String>> singleDimMap = new HashMap<Long, Pair<String, String>>(16);
    private final Map<String, List<DynamicObject>> singleMemberMap = new HashMap<String, List<DynamicObject>>(16);
    private final Map<String, Set<String>> allAsstMember = new HashMap<String, Set<String>>(16);
    private final Set<String> allSrcEntity = new HashSet<String>(16);
    private Table<String, String, String> table = HashBasedTable.create();
    private final FormulaDataSet ds = new FormulaDataSet();
    private Pair<Set<String>, Set<String>> asstAndComassist;
    private SingleMapModel singleMapModel;
    private DimensionMsgCache dim;
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private static final String NONE = "None";
    private static final String SPLIT = "|";
    private final boolean isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
    private final boolean openBatchCal;
    private final boolean errorLogLevel;
    private final boolean isDistinguish0AndNull;
    private String srcProduct;
    private static final String ORGID = "orgid";
    private static final String ORGNUMBER = "orgnumber";
    private static final String COMASSIST = "comassist";
    private final boolean isNotUseFormulaResFilter;

    public GLFormulaDataProvider(IIntegrateContext ctx) {
        super(ctx);
        this.errorLogLevel = ConfigServiceHelper.getBoolParam((String)this._ctx.getModel().p2, "calErrorLogLevel");
        this.openBatchCal = ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, ConfigEnum.IS_OPEN_BATCH_CAL.getNumber());
        this.isDistinguish0AndNull = ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, "isDistinguish0AndNull");
        this.isNotUseFormulaResFilter = ConfigServiceHelper.getGlobalBoolParam("IsNotUseFormulaResFilter");
        this.preData();
    }

    private void preData() {
        this.dim = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])new QFilter[]{new QFilter("id", "=", this._ctx.getSchema().p1)});
        this.srcProduct = scheme.getString("issrc.number");
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        DynamicObjectCollection baseents = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject ent : baseents) {
            this.baseEntMap.put(ent.getLong("id"), ent.getString("number"));
        }
        this.asstAndComassist = IntegrationUtil.getBaseEntity(this._ctx);
        this.initSrcTargetMap();
        filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        Map<Long, Map<String, Object>> pubMap = IntegrationUtil.getPubMap((Long)this._ctx.getSchema().p1, null);
        if (pubMap.size() > 0) {
            filter.or(new QFilter("pubmappingid", "in", pubMap.keySet()));
        }
        DynamicObject[] singles = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"scope,pubmappingid,dimmapid,srcmembnumber,targmembnumber,targmembid,issinglemapentry,issinglemapentry.srcdim,issinglemapentry.srcmemnumber,issinglemapentry.srcmembid,issinglemapentry.seq", (QFilter[])new QFilter[]{filter});
        List<DynamicObject> allSingleMapList = IntegrationUtil.addPubMapping(singles, pubMap);
        for (DynamicObject dot : allSingleMapList) {
            Long dimmapId = dot.getLong("dimmapid");
            String key = this.getSrcAndTargetKey((String)this.singleDimMap.get((Object)dimmapId).p1, (String)this.singleDimMap.get((Object)dimmapId).p2);
            this.singleMemberMap.computeIfAbsent(key, k -> new ArrayList(10));
            List<DynamicObject> list = this.singleMemberMap.get(key);
            list.add(dot);
        }
        this.initAllSrcMember();
    }

    private String getSrcAndTargetKey(String srcDim, String targetDim) {
        return srcDim + SPLIT + targetDim;
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        this.initAllSrcEntity();
        Map<String, Object> srcOrgMap = IntegrationUtil.getSrcOrgProfitCenter(this._ctx, this.singleMapModel);
        Pair srcOrg = Pair.onePair((Object)((Long)srcOrgMap.get(ORGID)), (Object)((String)srcOrgMap.get(ORGNUMBER)));
        String[] glPeriod = this.getGLPeriodNum();
        String srcFy = glPeriod[0];
        String srcPeriod = glPeriod[1];
        this.checkAccountBookClose((String)srcOrg.p2, srcFy, srcPeriod);
        ICalContext ctx = this.buildCalContext((Pair<Long, String>)srcOrg);
        if (srcOrgMap.get(COMASSIST) != null) {
            this.setComassist2Ctx(ctx, (Map)srcOrgMap.get(COMASSIST));
        }
        CalculateService service = new CalculateService(ctx);
        service.setOpenTrace(this.isOpenTrace);
        PairList resultKey = new PairList();
        Recorder count = new Recorder((Object)0);
        HashMap<String, String> floatAcctcf = new HashMap<String, String>(16);
        HashBasedTable floatIct = HashBasedTable.create();
        HashBasedTable floatAcct = HashBasedTable.create();
        HashMap isBatIctMap = new HashMap(16);
        this._ctx.getFormulaMappedGroup().forEach(arg_0 -> this.lambda$doLoadData$6(ctx, srcFy, srcPeriod, service, resultKey, count, floatAcctcf, (Table)floatAcct, (Table)floatIct, isBatIctMap, arg_0));
        if (this.openBatchCal) {
            this.queryFloatAcctFormula((Pair<Long, String>)srcOrg, (Table<List<String>, String, AbstractFormula>)floatAcct);
        }
        if (!"false".equals(isBatIctMap.get("isBatIct"))) {
            this.queryFloatIctFormula((Pair<Long, String>)srcOrg, (Table<List<String>, String, AbstractFormula>)floatIct);
        }
        Table<String, String, List<String>> acctcfFromula = this.queryFloatAcctcfFormula(floatAcctcf, ctx.getOrg(), srcFy, srcPeriod);
        acctcfFromula.cellSet().forEach(row -> {
            String formulaKey;
            String uuid = (String)row.getRowKey();
            ArrayList<String> comassistMember = new ArrayList<String>(10);
            if (uuid.contains(SPLIT)) {
                int index = uuid.indexOf(SPLIT);
                String comassist = uuid.substring(index + 1);
                String[] temp = comassist.split("\\|");
                for (int j = 0; j < temp.length; j += 2) {
                    comassistMember.add(temp[j] + SPLIT + temp[j + 1]);
                }
                uuid = uuid.substring(0, index);
            }
            if ((formulaKey = this.getFormulaKey(uuid, (List)row.getValue(), comassistMember)) == null) {
                return;
            }
            this.addFormula2Service(service, (String)row.getColumnKey(), formulaKey, (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
        });
        if ((Integer)count.getRecord() > 0) {
            this.packedResultMap(service, this.ds, (PairList<String, ExpressStatus>)resultKey);
        }
        return this.ds;
    }

    private List<String> getAsstFormula(List<String> list) {
        ArrayList<String> asstInFormula = new ArrayList<String>(list.size());
        for (String s : list) {
            if (!((Set)this.asstAndComassist.p1).contains(s)) continue;
            asstInFormula.add(s);
        }
        return asstInFormula;
    }

    private void queryFloatIctFormula(Pair<Long, String> srcOrg, Table<List<String>, String, AbstractFormula> floatIctTable) {
        log.startWatch();
        int num = 1;
        for (List asst : floatIctTable.rowKeySet()) {
            Map floatAcct = floatIctTable.row((Object)asst);
            ArrayList<ExpressStatus> statusList = new ArrayList<ExpressStatus>();
            ArrayList failFormula = Lists.newArrayList();
            ArrayList<AbstractFormula> batchCalFormula = new ArrayList<AbstractFormula>();
            ArrayList batchCalList = Lists.newArrayList(floatAcct.values());
            RefParamResult refParamResult = this.packRefParamIct(batchCalList, this.glDimToBcmDim);
            CollectCalculateService service = this.getCollectCalculateService(srcOrg, refParamResult);
            this.addFormula2Service(batchCalList, service, statusList, batchCalFormula, failFormula);
            Long startTime = System.currentTimeMillis();
            service.calculateCollect();
            IntegrationUtil.addTimeUse(this._ctx, startTime, "FloatAcctFormula");
            Map<String, Object> collectResultSet = service.getCollectResultSet();
            ICollectResultHandle handle = this.getiCollectResultHandle(this.glDimToBcmDim, refParamResult);
            List<IPackKey> packKeys = CollectCalculateHelp.batchPackKeys(statusList, batchCalFormula, collectResultSet, (Long)this._ctx.getModel().p1, refParamResult.getGlMem2BcmMems(), failFormula, null, null);
            log.info("get packKeys size is:" + (packKeys == null ? "null" : Integer.valueOf(packKeys.size())));
            HashMap<Integer, Object> index2formulaGlDim = new HashMap<Integer, Object>(10);
            for (int i = 0; i < batchCalFormula.size(); ++i) {
                Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(((AbstractFormula)batchCalFormula.get(i)).getFormulaStr());
                index2formulaGlDim.put(i, pair);
            }
            PairList resultKey = new PairList();
            if (packKeys == null) continue;
            for (IPackKey iPackKey : packKeys) {
                statusList.clear();
                resultKey.clear();
                service.reset();
                floatAcct.forEach((k, v) -> {
                    ExpressStatus status = service.addCollectCalculateExpress(v.getFormulaStr());
                    resultKey.addPair(k, (Object)status);
                });
                for (int i = 0; i < resultKey.size(); ++i) {
                    String uuid = (String)resultKey.getPair((int)i).p1;
                    ExpressStatus status = (ExpressStatus)resultKey.getPair((int)i).p2;
                    Object value = service.evalExpress(status, iPackKey, handle);
                    String formulaKey = uuid;
                    if (formulaKey == null) continue;
                    StringBuilder sb = new StringBuilder(formulaKey);
                    List<String> bcmDims = ((PackKey)iPackKey).getBcmDims();
                    List<String> bcmMembers = ((PackKey)iPackKey).getBcmMems();
                    for (int j = 0; j < ((PackKey)iPackKey).getBcmDims().size(); ++j) {
                        sb.append('|').append(bcmDims.get(j)).append('|').append(bcmMembers.get(j));
                    }
                    DataTraceFrom dc = null;
                    if (!(value instanceof Exception)) {
                        String[] rowcols = ((AbstractFormula)batchCalFormula.get(i)).getRowcols();
                        String[] rowcolMemNum = ((AbstractFormula)batchCalFormula.get(i)).getRowcolMemNum();
                        String[] dimMems = this.fillDimMems(rowcolMemNum, (PackKey)iPackKey);
                        dc = service.get_cs().getCollectFormulaForTrace(status, Arrays.asList(rowcols), Arrays.asList(dimMems), (Pair<Map<String, List<String>>, List<String>>)((Pair)index2formulaGlDim.get(i)), this.glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), true, null);
                    }
                    this.packedResultMap(sb.toString(), value, dc);
                }
            }
            if (refParamResult.getRefParam() != null) {
                refParamResult.getRefParam().clear();
                refParamResult.getGlDimBcmMem2GlMems().clear();
                refParamResult.getGlMem2BcmMems().clear();
            }
            StringBuilder errMsg = new StringBuilder();
            for (AbstractFormula f : failFormula) {
                errMsg.append(f.getFormulaStr()).append(":").append(f.getMsg()).append(";");
            }
            if (errMsg.length() > 0) {
                String string = this._ctx.getCustomParam("errMsg") == null ? "" : (String)this._ctx.getCustomParam("errMsg");
                errMsg.append(string);
                this._ctx.putCustomParam("errMsg", errMsg.toString());
            }
            log.info(String.format("\u96c6\u6210\u603b\u8d26\u7b2c[%1$d]\u6b21acct\u6d6e\u52a8\u516c\u5f0f\u67e5\u8be2\u8017\u65f6\uff0c\u67e5\u8be2\u516c\u5f0f\u4e2a\u6570\uff1a%2$d", num++, batchCalList.size()));
        }
        log.infoEnd("\u96c6\u6210\u603b\u8d26acct\u6d6e\u52a8\u516c\u5f0f\u67e5\u8be2\u603b\u8017\u65f6");
    }

    private RefParamResult packRefParamIct(List<AbstractFormula> batchCalList, Map<String, String> glDimToBcmDim) {
        RefParamResult refParamResult = new RefParamResult();
        for (AbstractFormula formula : batchCalList) {
            Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(formula.getFormulaStr());
            List srcDims = (List)pair.p2;
            if (srcDims.isEmpty()) {
                formula.setMsg("not support formula format.");
                continue;
            }
            String[] rowcols = new String[srcDims.size()];
            String[] rowcolMemNum = new String[srcDims.size()];
            HashMap refParam = Maps.newHashMap();
            HashMultimap glMem2BcmMems = HashMultimap.create();
            HashMultimap glDimBcmMem2GlMems = HashMultimap.create();
            for (int i = 0; i < srcDims.size(); ++i) {
                String targetDim;
                String srcDim = (String)srcDims.get(i);
                String gl2BcmDim = this.getSrcAndTargetKey(srcDim, targetDim = glDimToBcmDim.get(srcDim));
                if (this.allAsstMember.get(gl2BcmDim) != null) {
                    refParam.computeIfAbsent(srcDim, s -> new HashSet(16));
                    Set members = (Set)refParam.get(srcDim);
                    members.addAll((Collection)this.allAsstMember.get(gl2BcmDim));
                    List<DynamicObject> memberMapping = this.singleMemberMap.get(gl2BcmDim);
                    for (String srcMember : members) {
                        String targetMember = this.getTargetMember(srcMember, memberMapping, targetDim);
                        if (StringUtils.isEmpty((CharSequence)targetMember)) continue;
                        glMem2BcmMems.put((Object)(srcDim + "-" + srcMember), (Object)(targetDim + "-" + targetMember));
                        glDimBcmMem2GlMems.put((Object)(srcDim + "_-" + targetMember), (Object)srcMember);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\uff1a%1$s\uff0c\u6e90\u7ef4\u5ea6[%2$s]\u672a\u914d\u7f6e\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLFormulaDataProvider_8", (String)"fi-bcm-business", (Object[])new Object[0]), formula, srcDim));
                }
                rowcols[i] = targetDim;
                rowcolMemNum[i] = "@";
            }
            refParamResult.setRefParam(refParam);
            refParamResult.setGlMem2BcmMems((HashMultimap<String, String>)glMem2BcmMems);
            refParamResult.setGlDimBcmMem2GlMems((HashMultimap<String, String>)glDimBcmMem2GlMems);
            formula.setRowcols(rowcols);
            formula.setRowcolMemNum(rowcolMemNum);
        }
        return refParamResult;
    }

    private void checkAccountBookClose(String orgNumber, String yearNum, String periodNum) {
        if (IntegrateProductEnum.NGACC_CProduct.getNumber().equals(this.srcProduct)) {
            return;
        }
        boolean bookClose = GlServiceHelper.isAccountBookClose(this._ctx, orgNumber, null, yearNum, periodNum);
        if (!bookClose) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed3\u8d26\uff0c\u518d\u8fdb\u884c\u53d6\u6570\u3002\u6216\u8005\u8c03\u6574\u540e\u53f0\u53c2\u6570\uff0c\u5141\u8bb8\u5728\u603b\u8d26\u7ed3\u8d26\u524d\u53d6\u6570\u3002\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\uff1a%2$s\uff0c\u5e74\u4efd\uff1a%3$s\uff0c\u671f\u95f4\uff1a%4$s\u3002", (String)"GLBalanceDataProvider_7", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumber, null, yearNum, periodNum);
            throw new KDBizException(errorInfo);
        }
    }

    @Override
    protected void afterLoadData() {
        super.afterLoadData();
        this.baseEntMap.clear();
        this.glDimToBcmDim.clear();
        this.singleDimMap.clear();
        this.singleMemberMap.clear();
        this.allAsstMember.clear();
        this.table.clear();
    }

    private void addFormula2Service(CalculateService service, String formula, String uuid, PairList<String, ExpressStatus> resultKey, Recorder<Integer> count) {
        ExpressStatus status = service.addCalculateExpress(formula);
        resultKey.add(Pair.onePair((Object)uuid, (Object)status));
        count.setRecord((Object)((Integer)count.getRecord() + 1));
        if ((Integer)count.getRecord() >= 2000) {
            this.packedResultMap(service, this.ds, resultKey);
            count.setRecord((Object)0);
        }
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        return new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, mainscope, false, false);
    }

    private ICalContext buildCalContext(Pair<Long, String> org) {
        String srcOrg = (String)org.p2;
        String[] glPeriod = this.getGLPeriodNum();
        String srcFy = "FY" + glPeriod[0];
        String srcPeriod = glPeriod[1];
        if (srcPeriod.contains("T") && NumberUtils.isNumber((String)(srcPeriod = srcPeriod.replace("T", "")))) {
            int period = Integer.parseInt(srcPeriod);
            srcPeriod = period > 12 ? period + "" : period + "T";
        }
        srcPeriod = "M_M" + srcPeriod;
        CalContext ctx = new CalContext((String)this._ctx.getModel().p2, srcOrg, srcFy, srcPeriod, this.getScenario(), (String)this._ctx.getCurrency().p2);
        ctx.setProperty("calErrorLogLevel", this.errorLogLevel);
        ctx.setProperty("isDistinguish0AndNull", this.isDistinguish0AndNull);
        return ctx;
    }

    private void setComassist2Ctx(ICalContext ctx, Map<String, List<String>> comassist) {
        StringBuilder sb = new StringBuilder();
        comassist.forEach((k, v) -> {
            if (v != null && !v.isEmpty()) {
                sb.append((String)k).append(SPLIT).append(org.apache.commons.lang3.StringUtils.join((Iterable)v, (String)",")).append(SPLIT);
            }
        });
        String comAssistString = sb.toString();
        if (sb.length() > 0) {
            comAssistString = sb.substring(0, sb.length() - 1);
        }
        if (StringUtils.isNotEmpty((CharSequence)comAssistString)) {
            ctx.setCommonDimension(comAssistString);
        }
    }

    private void packedResultMap(CalculateService service, FormulaDataSet ds, PairList<String, ExpressStatus> resultKey) {
        Long startTime = System.currentTimeMillis();
        service.batchCalculate();
        IntegrationUtil.addTimeUse(this._ctx, startTime, "GLFormulaDataProvider:packedResultMap");
        for (Pair key : resultKey) {
            FormulaRow row;
            Object value = service.evalExpress((ExpressStatus)key.p2);
            if (value instanceof BigDecimal) {
                if (!this.isDistinguish0AndNull && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) continue;
                row = new FormulaRow((String)key.p1, value);
                ds.addRow(row);
                DataTraceFrom dc = service.getFormulaForTrace((ExpressStatus)key.p2);
                if (dc == null) continue;
                row.setDataTraceFrom(dc);
                continue;
            }
            if (value == null) continue;
            HashMap map = new HashMap();
            map.put("-1", value);
            row = new FormulaRow((String)key.p1, map);
            ds.addRow(row);
        }
        service.clear();
        resultKey.clear();
    }

    private List<Pair<String, List<String>>> generateFloatComassist(String formula, Pair<List<String>, List<String>> pair, List<List<String>> dimValue) {
        ArrayList<String> bcmDimSeq = new ArrayList<String>();
        HashMap gldim2DimIndex = Maps.newHashMap();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>(10);
        for (int i = 0; i < ((List)pair.p2).size(); ++i) {
            String key = (String)((List)pair.p2).get(i);
            if (!this.glDimToBcmDim.containsKey(key)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u201c%1$s\u201d\uff0c\u6e90\u7ef4\u5ea6\u201c%2$s\u201d\u672a\u51fa\u73b0\u5728\u5355\u7ef4\u5ea6\u6620\u5c04\u4e2d\u3002", (String)"GLFormulaDataProvider_7", (String)"fi-bcm-business", (Object[])new Object[0]), formula, key));
            }
            if (((Set)this.asstAndComassist.p2).contains(key)) {
                String targetDim = this.glDimToBcmDim.get(key);
                String gl2BcmDim = this.getSrcAndTargetKey(key, targetDim);
                if (this.allAsstMember.get(gl2BcmDim) != null) {
                    ArrayList arrayList = new ArrayList(this.allAsstMember.get(gl2BcmDim));
                    if (!bcmDimSeq.contains(targetDim)) {
                        bcmDimSeq.add(targetDim);
                        dimValue.add(arrayList);
                        continue;
                    }
                    gldim2DimIndex.put(key, bcmDimSeq.indexOf(targetDim));
                    continue;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\uff1a%1$s\uff0c\u6e90\u7ef4\u5ea6[%2$s]\u672a\u914d\u7f6e\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLFormulaDataProvider_8", (String)"fi-bcm-business", (Object[])new Object[0]), formula, key));
            }
            removeIndex.add(i);
        }
        Collections.reverse(removeIndex);
        Iterator i = removeIndex.iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            ((List)pair.p1).remove(index);
            ((List)pair.p2).remove(index);
        }
        ArrayList<Pair<String, List<String>>> formulas = new ArrayList<Pair<String, List<String>>>(10);
        if (dimValue.isEmpty()) {
            formulas.add(Pair.onePair((Object)formula, new ArrayList()));
            return formulas;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        AnalysisFormulaUtil.descartes(dimValue, result, 0, new ArrayList<String>());
        ArrayList replaces = Lists.newArrayListWithExpectedSize((int)10);
        for (List list : result) {
            HashMultimap group = HashMultimap.create();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                group.put(((List)pair.p1).get(i2), (Object)String.join((CharSequence)SPLIT, (CharSequence)((List)pair.p2).get(i2), (CharSequence)list.get(i2), (CharSequence)list.get(i2)));
            }
            for (Map.Entry entry : gldim2DimIndex.entrySet()) {
                for (int i3 = 0; i3 < ((List)pair.p2).size(); ++i3) {
                    if (!((String)((List)pair.p2).get(i3)).equals(entry.getKey())) continue;
                    String s = (String)list.get((Integer)entry.getValue());
                    group.put(((List)pair.p1).get(i3), (Object)String.join((CharSequence)SPLIT, (CharSequence)((List)pair.p2).get(i3), s, s));
                }
            }
            replaces.add(group);
        }
        for (HashMultimap hashMultimap : replaces) {
            String realFormula = formula;
            ArrayList<String> replaceMember = new ArrayList<String>(10);
            for (Map.Entry entry : hashMultimap.entries()) {
                String[] params = ((String)entry.getValue()).split("\\|");
                String member = String.join((CharSequence)SPLIT, params[0], params[1]);
                realFormula = realFormula.replace((CharSequence)entry.getKey(), member);
                replaceMember.add(member);
            }
            formulas.add((Pair<String, List<String>>)Pair.onePair((Object)realFormula, replaceMember));
        }
        return formulas;
    }

    private List<Pair<String, List<String>>> generateFloatAcctDy(Map<String, String> glDimToBcmDim, String acct, Map<String, Set<String>> dimToMembs, List<List<String>> dimValue) {
        Pair pair = Pair.onePair((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        AnalysisFormulaUtil.generateFloatAcctDy(acct, (Pair<List<String>, List<String>>)pair);
        ArrayList<String> bcmDimSeq = new ArrayList<String>();
        HashMap gldim2DimIndex = Maps.newHashMap();
        for (String key : (List)pair.p2) {
            String targetDim;
            String gl2BcmDim = this.getSrcAndTargetKey(key, targetDim = glDimToBcmDim.get(key));
            if (dimToMembs.get(gl2BcmDim) != null) {
                ArrayList arrayList = new ArrayList(dimToMembs.get(gl2BcmDim));
                if (!bcmDimSeq.contains(targetDim)) {
                    bcmDimSeq.add(targetDim);
                    dimValue.add(arrayList);
                    continue;
                }
                gldim2DimIndex.put(key, bcmDimSeq.indexOf(targetDim));
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\uff1a%1$s\uff0c\u6e90\u7ef4\u5ea6[%2$s]\u672a\u914d\u7f6e\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLFormulaDataProvider_8", (String)"fi-bcm-business", (Object[])new Object[0]), acct, key));
        }
        if (dimValue.isEmpty()) {
            return null;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        AnalysisFormulaUtil.descartes(dimValue, result, 0, new ArrayList<String>());
        ArrayList replaces = Lists.newArrayListWithExpectedSize((int)10);
        HashMap<String, Set> assgrpToDimvalueMap = new HashMap<String, Set>();
        for (List list : result) {
            for (int i = 0; i < list.size(); ++i) {
                assgrpToDimvalueMap.computeIfAbsent((String)((List)pair.p2).get(i), k -> new HashSet()).add(list.get(i));
            }
            for (Map.Entry entry : gldim2DimIndex.entrySet()) {
                for (int i = 0; i < ((List)pair.p2).size(); ++i) {
                    if (!((String)((List)pair.p2).get(i)).equals(entry.getKey())) continue;
                    assgrpToDimvalueMap.computeIfAbsent((String)((List)pair.p2).get(i), k -> new HashSet()).add(list.get((Integer)entry.getValue()));
                }
            }
        }
        HashSet glDims = new HashSet(10);
        ArrayList<Pair<String, List<String>>> arrayList = new ArrayList<Pair<String, List<String>>>(10);
        for (List list : result) {
            HashMultimap group = HashMultimap.create();
            for (int i = 0; i < list.size(); ++i) {
                group.put(((List)pair.p1).get(i), (Object)String.join((CharSequence)SPLIT, (CharSequence)((List)pair.p2).get(i), (CharSequence)list.get(i), (CharSequence)list.get(i)));
                glDims.add(((List)pair.p1).get(i));
            }
            for (Map.Entry entry : gldim2DimIndex.entrySet()) {
                for (int i = 0; i < ((List)pair.p2).size(); ++i) {
                    if (!((String)((List)pair.p2).get(i)).equals(entry.getKey())) continue;
                    String s = (String)list.get((Integer)entry.getValue());
                    group.put(((List)pair.p1).get(i), (Object)String.join((CharSequence)SPLIT, (CharSequence)((List)pair.p2).get(i), s, s));
                    glDims.add(((List)pair.p1).get(i));
                }
            }
            replaces.add(group);
        }
        if (((List)pair.p1).size() == glDims.size()) {
            for (String string : (List)pair.p1) {
                if (glDims.contains(string)) continue;
                return null;
            }
        } else {
            return null;
        }
        for (HashMultimap hashMultimap : replaces) {
            String realFormula = acct;
            ArrayList<String> replaceMember = new ArrayList<String>(10);
            for (Map.Entry entry : hashMultimap.entries()) {
                String[] params = ((String)entry.getValue()).split("\\|");
                String member = String.join((CharSequence)SPLIT, params[0], params[1]);
                realFormula = realFormula.replace((CharSequence)entry.getKey(), member);
                replaceMember.add(member);
            }
            arrayList.add((Pair<String, List<String>>)Pair.onePair((Object)realFormula, replaceMember));
        }
        return arrayList;
    }

    private PairList<String, String> generateFloatIctFormula(String ictFormula) {
        PairList result = new PairList();
        for (String s : this.allSrcEntity) {
            String realFormula = ictFormula;
            realFormula = realFormula.replaceFirst("@", s);
            result.addPair((Object)realFormula, (Object)s);
        }
        return result;
    }

    private String getFormulaKey(String uuid, List<String> asstMember, List<String> comassistMember) {
        asstMember.addAll(comassistMember);
        StringBuilder sb = new StringBuilder(uuid);
        for (String s : asstMember) {
            String targetDim;
            String srcDim;
            String key;
            List<DynamicObject> memberMapping;
            String[] srcInfo = s.split("\\|");
            String srcMember = srcInfo[1];
            String targetMember = this.getTargetMember(srcMember, memberMapping = this.singleMemberMap.get(key = this.getSrcAndTargetKey(srcDim = srcInfo[0], targetDim = this.glDimToBcmDim.get(srcDim))), targetDim);
            if (targetMember == null) {
                return null;
            }
            sb.append('|').append(targetDim).append('|').append(targetMember);
        }
        return sb.toString();
    }

    private String getFormulaKey(String uuid, String srcMember) {
        StringBuilder sb = new StringBuilder(uuid);
        String srcDim = "Entity";
        String targetDim = this.glDimToBcmDim.get(srcDim);
        String key = this.getSrcAndTargetKey(srcDim, targetDim);
        List<DynamicObject> memberMapping = this.singleMemberMap.get(key);
        String targetMember = this.getTargetMember(srcMember, memberMapping, targetDim);
        if (targetMember == null) {
            return null;
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(targetDim)) {
            targetDim = DimTypesEnum.INTERCOMPANY.getNumber();
        }
        if (MemberReader.findMemberByNumber((String)((String)this._ctx.getModel().p2), (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)targetMember) == IDNumberTreeNode.NotFoundTreeNode) {
            return null;
        }
        sb.append('|').append(targetDim).append('|').append(targetMember);
        return sb.toString();
    }

    private void initSrcTargetMap() {
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        filter.and("mappedtype", "=", (Object)"1");
        DynamicObjectCollection dimMap = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,sequence,isdimmapsrcentry.srcdimension, isdimmaptargentry.tagdimension", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dot : dimMap) {
            long dimmapId = dot.getLong("id");
            long srcDimId = dot.getLong("isdimmapsrcentry.srcdimension");
            String srcDimNum = this.baseEntMap.get(srcDimId);
            if (srcDimNum == null) continue;
            long targetDimId = dot.getLong("isdimmaptargentry.tagdimension");
            String targetDimNum = MemberReader.getDimensionNumById((long)targetDimId);
            this.glDimToBcmDim.put(srcDimNum, targetDimNum);
            this.singleDimMap.put(dimmapId, (Pair<String, String>)Pair.onePair((Object)srcDimNum, (Object)targetDimNum));
        }
    }

    private void initAllSrcMember() {
        this.glDimToBcmDim.forEach((k, v) -> {
            String key = this.getSrcAndTargetKey((String)k, (String)v);
            if ((((Set)this.asstAndComassist.p1).contains(k) || ((Set)this.asstAndComassist.p2).contains(k)) && this.singleMemberMap.get(key) != null) {
                Set<String> allMember = this.getAllSrcMember(this.singleMemberMap.get(key), (String)v);
                this.allAsstMember.put(key, allMember);
            }
        });
    }

    private void initAllSrcEntity() {
        Recorder existFloatIct = new Recorder((Object)false);
        this._ctx.getFormulaMappedGroup().forEach(e -> e.forEach(row -> {
            String formula = row.getExpression().toLowerCase(Locale.ENGLISH);
            if (formula.contains("@") && (formula.startsWith("ict") || formula.startsWith("-ict"))) {
                existFloatIct.setRecord((Object)true);
            }
        }));
        if (((Boolean)existFloatIct.getRecord()).booleanValue()) {
            Map<String, Pair<Long, String>> map = this.singleMapModel.getAllSrc(DimTypesEnum.ENTITY.getNumber());
            Recorder existStar = new Recorder((Object)false);
            map.values().forEach(p -> {
                if (ALL.equals(p.p2)) {
                    existStar.setRecord((Object)true);
                } else if (!this.allSrcEntity.add((String)p.p2)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6d6e\u52a8\u5b57\u6bb5\u7684\u5bf9\u65b9\u7ec4\u7ec7\u5728\u7ec4\u7ec7\u6620\u5c04\u4e2d\u5b58\u5728\u91cd\u590d\u6210\u5458\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u4fee\u6b63\u4e4b\u540e\u518d\u6b21\u96c6\u6210\u3002", (String)"GLFormulaDataProvider_9", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            });
            if (((Boolean)existStar.getRecord()).booleanValue()) {
                QFilter qFilter = new QFilter("model", "=", this._ctx.getModel().p1);
                QFilter[] filters = new QFilter[]{qFilter};
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number", (QFilter[])filters);
                col.forEach(obj -> this.allSrcEntity.add(obj.getString("number")));
            }
        }
    }

    private String[] getGLPeriodNum() {
        String srcPeriod;
        String srcYear;
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        if (fyPair == null) {
            if (this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), ALL) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u8d22\u5e74\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLFormulaDataProvider_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getFy().p2));
            }
            srcYear = ((String)this._ctx.getFy().p2).substring(2);
        } else {
            srcYear = ((String)fyPair.p2).substring(0, 4);
        }
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        try {
            if (periodPair == null) {
                if (this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), ALL) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u671f\u95f4\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLFormulaDataProvider_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getPeriod().p2));
                }
                srcPeriod = ((String)this._ctx.getPeriod().p2).substring(3);
            } else {
                srcPeriod = ((String)periodPair.p2).substring(4);
            }
        }
        catch (Exception e) {
            log.error("periodPair is error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u683c\u5f0f\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"GLFormulaDataProvider_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return new String[]{srcYear, srcPeriod};
    }

    private String getScenario() {
        Recorder scenario = new Recorder(((Pair)this._ctx.getCustomParam((String)"scene")).p2);
        this._ctx.getTargetDefaultValsMap().forEach((key, value) -> {
            String dimNum = value.getDimItem().getNumber();
            if ("Scenario".equals(dimNum)) {
                scenario.setRecord((Object)value.getDefVals().get(0).getNumber());
            }
        });
        return (String)scenario.getRecord();
    }

    private Table<String, String, List<String>> queryFloatAcctcfFormula(Map<String, String> floatAcctcf, String orgNum, String yearNum, String periodNum) {
        String schemeAndOrg = (String)this._ctx.getSchema().p2 + SPLIT + (String)this._ctx.getOrg().p2;
        HashBasedTable result = HashBasedTable.create();
        HashMap<CashflowCommonParam, Pair> queryParam = new HashMap<CashflowCommonParam, Pair>();
        String defaultBookType = FormulaAnalyze.setBookTypeDefaultValue().getValue();
        for (Map.Entry<String, String> entry : floatAcctcf.entrySet()) {
            String formula = entry.getValue();
            List<FunctionExpr> exprs = FormulaAnalyze.analyticFun(formula);
            if (exprs.isEmpty()) continue;
            for (FunctionExpr expr : exprs) {
                String bookType;
                List parameters = expr.getParameters();
                String account = parameters.get(2).toString().replaceAll("\"", "");
                if (!account.contains("@")) continue;
                String org = parameters.get(0).toString().replaceAll("\"", "");
                if (StringUtils.isEmpty((CharSequence)org)) {
                    org = orgNum;
                }
                if (StringUtils.isEmpty((CharSequence)(bookType = parameters.get(1).toString().replaceAll("\"", "")))) {
                    bookType = defaultBookType;
                }
                String currency = parameters.get(6).toString().replaceAll("\"", "");
                String year = parameters.get(4).toString().replaceAll("\"", "");
                if (StringUtils.isEmpty((CharSequence)year) || "0".equals(year)) {
                    year = yearNum;
                }
                String period = parameters.get(5).toString().replaceAll("\"", "");
                String glPeriod = year;
                if (StringUtils.isEmpty((CharSequence)period) || "0".equals(period)) {
                    glPeriod = glPeriod + periodNum;
                } else {
                    if (period.length() == 1) {
                        glPeriod = glPeriod + "0";
                    }
                    glPeriod = glPeriod + period;
                }
                HashSet<String> asstSet = new HashSet<String>(16);
                String[] subjectValues = account.split("\\|");
                for (int i = 1; i < subjectValues.length; i += 2) {
                    asstSet.add(subjectValues[i]);
                }
                CashflowCommonParam param = new CashflowCommonParam(org, bookType, glPeriod, currency, asstSet);
                queryParam.computeIfAbsent(param, p -> Pair.onePair(new HashSet(), (Object)new PairList()));
                Pair accountAndFormula = (Pair)queryParam.get(param);
                ((Set)accountAndFormula.p1).add(subjectValues[0]);
                ((PairList)accountAndFormula.p2).addPair((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        queryParam.forEach((arg_0, arg_1) -> this.lambda$queryFloatAcctcfFormula$23(schemeAndOrg, orgNum, yearNum, periodNum, (Table)result, arg_0, arg_1));
        return result;
    }

    private void queryFloatAcctFormula(Pair<Long, String> org, Table<List<String>, String, AbstractFormula> floatAcctTable) {
        log.startWatch();
        int num = 1;
        for (List asst : floatAcctTable.rowKeySet()) {
            Map floatAcct = floatAcctTable.row((Object)asst);
            ArrayList<ExpressStatus> statusList = new ArrayList<ExpressStatus>();
            ArrayList failFormula = Lists.newArrayList();
            ArrayList<AbstractFormula> batchCalFormula = new ArrayList<AbstractFormula>();
            ArrayList batchCalList = Lists.newArrayList(floatAcct.values());
            RefParamResult refParamResult = this.packRefParam(batchCalList, this.glDimToBcmDim);
            CollectCalculateService service = this.getCollectCalculateService(org, refParamResult);
            this.addFormula2Service(batchCalList, service, statusList, batchCalFormula, failFormula);
            Long startTime = System.currentTimeMillis();
            service.calculateCollect();
            IntegrationUtil.addTimeUse(this._ctx, startTime, "FloatAcctFormula");
            Map<String, Object> collectResultSet = service.getCollectResultSet();
            ICollectResultHandle handle = this.getiCollectResultHandle(this.glDimToBcmDim, refParamResult);
            List<IPackKey> packKeys = CollectCalculateHelp.batchPackKeys(statusList, batchCalFormula, collectResultSet, (Long)this._ctx.getModel().p1, refParamResult.getGlMem2BcmMems(), failFormula, null, null);
            log.info("get packKeys size is:" + (packKeys == null ? "null" : Integer.valueOf(packKeys.size())));
            HashMap<Integer, Object> index2formulaGlDim = new HashMap<Integer, Object>(10);
            for (int i = 0; i < batchCalFormula.size(); ++i) {
                Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(((AbstractFormula)batchCalFormula.get(i)).getFormulaStr());
                index2formulaGlDim.put(i, pair);
            }
            PairList resultKey = new PairList();
            if (packKeys == null) continue;
            for (IPackKey key : packKeys) {
                statusList.clear();
                resultKey.clear();
                service.reset();
                floatAcct.forEach((k, v) -> {
                    ExpressStatus status = service.addCollectCalculateExpress(v.getFormulaStr());
                    resultKey.addPair(k, (Object)status);
                });
                for (int i = 0; i < resultKey.size(); ++i) {
                    String formulaKey;
                    String uuid = (String)resultKey.getPair((int)i).p1;
                    ExpressStatus status = (ExpressStatus)resultKey.getPair((int)i).p2;
                    Object value = service.evalExpress(status, key, handle);
                    ArrayList<String> comassistMember = new ArrayList<String>(10);
                    if (uuid.contains(SPLIT)) {
                        int index = uuid.indexOf(SPLIT);
                        String comassist = uuid.substring(index + 1);
                        String[] temp = comassist.split("\\|");
                        for (int j = 0; j < temp.length; j += 2) {
                            comassistMember.add(temp[j] + SPLIT + temp[j + 1]);
                        }
                        uuid = uuid.substring(0, index);
                    }
                    if ((formulaKey = this.getFormulaKey(uuid, new ArrayList<String>(), comassistMember)) == null) continue;
                    StringBuilder sb = new StringBuilder(formulaKey);
                    List<String> bcmDims = ((PackKey)key).getBcmDims();
                    List<String> bcmMembers = ((PackKey)key).getBcmMems();
                    for (int j = 0; j < ((PackKey)key).getBcmDims().size(); ++j) {
                        sb.append('|').append(bcmDims.get(j)).append('|').append(bcmMembers.get(j));
                    }
                    DataTraceFrom dc = null;
                    if (!(value instanceof Exception)) {
                        String[] rowcols = ((AbstractFormula)batchCalFormula.get(i)).getRowcols();
                        String[] rowcolMemNum = ((AbstractFormula)batchCalFormula.get(i)).getRowcolMemNum();
                        String[] dimMems = this.fillDimMems(rowcolMemNum, (PackKey)key);
                        dc = service.get_cs().getCollectFormulaForTrace(status, Arrays.asList(rowcols), Arrays.asList(dimMems), (Pair<Map<String, List<String>>, List<String>>)((Pair)index2formulaGlDim.get(i)), this.glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), true, null);
                    }
                    this.packedResultMap(sb.toString(), value, dc);
                }
            }
            if (refParamResult.getRefParam() != null) {
                refParamResult.getRefParam().clear();
                refParamResult.getGlDimBcmMem2GlMems().clear();
                refParamResult.getGlMem2BcmMems().clear();
            }
            StringBuilder errMsg = new StringBuilder();
            for (AbstractFormula f : failFormula) {
                errMsg.append(f.getFormulaStr()).append(":").append(f.getMsg()).append(";");
            }
            if (errMsg.length() > 0) {
                this._ctx.putCustomParam("errMsg", errMsg.toString());
            }
            log.info(String.format("\u96c6\u6210\u603b\u8d26\u7b2c[%1$d]\u6b21acct\u6d6e\u52a8\u516c\u5f0f\u67e5\u8be2\u8017\u65f6\uff0c\u67e5\u8be2\u516c\u5f0f\u4e2a\u6570\uff1a%2$d", num++, batchCalList.size()));
        }
        log.infoEnd("\u96c6\u6210\u603b\u8d26acct\u6d6e\u52a8\u516c\u5f0f\u67e5\u8be2\u603b\u8017\u65f6");
    }

    private RefParamResult packRefParam(List<AbstractFormula> batchCalList, Map<String, String> glDimToBcmDim) {
        RefParamResult refParamResult = new RefParamResult();
        for (AbstractFormula formula : batchCalList) {
            Pair<List<String>, List<String>> pair = CollectCalculateHelp.getFormulaDimPair(formula.getFormulaStr());
            List srcDims = (List)pair.p2;
            if (srcDims.isEmpty()) {
                formula.setMsg("not support formula format.");
                continue;
            }
            String[] rowcols = new String[srcDims.size()];
            String[] rowcolMemNum = new String[srcDims.size()];
            HashMap refParam = Maps.newHashMap();
            HashMultimap glMem2BcmMems = HashMultimap.create();
            HashMultimap glDimBcmMem2GlMems = HashMultimap.create();
            for (int i = 0; i < srcDims.size(); ++i) {
                String targetDim;
                String srcDim = (String)srcDims.get(i);
                String gl2BcmDim = this.getSrcAndTargetKey(srcDim, targetDim = glDimToBcmDim.get(srcDim));
                if (this.allAsstMember.get(gl2BcmDim) != null) {
                    refParam.computeIfAbsent(srcDim, s -> new HashSet(16));
                    Set members = (Set)refParam.get(srcDim);
                    members.addAll((Collection)this.allAsstMember.get(gl2BcmDim));
                    List<DynamicObject> memberMapping = this.singleMemberMap.get(gl2BcmDim);
                    for (String srcMember : members) {
                        String targetMember = this.getTargetMember(srcMember, memberMapping, targetDim);
                        if (StringUtils.isEmpty((CharSequence)targetMember)) continue;
                        glMem2BcmMems.put((Object)(srcDim + "-" + srcMember), (Object)(targetDim + "-" + targetMember));
                        glDimBcmMem2GlMems.put((Object)(srcDim + "_-" + targetMember), (Object)srcMember);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\uff1a%1$s\uff0c\u6e90\u7ef4\u5ea6[%2$s]\u672a\u914d\u7f6e\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLFormulaDataProvider_8", (String)"fi-bcm-business", (Object[])new Object[0]), formula, srcDim));
                }
                rowcols[i] = targetDim;
                rowcolMemNum[i] = "@";
            }
            refParamResult.setRefParam(refParam);
            refParamResult.setGlMem2BcmMems((HashMultimap<String, String>)glMem2BcmMems);
            refParamResult.setGlDimBcmMem2GlMems((HashMultimap<String, String>)glDimBcmMem2GlMems);
            formula.setRowcols(rowcols);
            formula.setRowcolMemNum(rowcolMemNum);
        }
        return refParamResult;
    }

    private CollectCalculateService getCollectCalculateService(Pair<Long, String> org, RefParamResult refParamResult) {
        ICalContext ctx = this.buildCalContext(org);
        ctx.setProperty("is_calc_collect_ref_param", refParamResult.getRefParam());
        CollectCalculateService collectCalculateService = new CollectCalculateService(ctx);
        collectCalculateService.get_cs().setOpenTrace(this.isOpenTrace);
        return collectCalculateService;
    }

    private void addFormula2Service(List<AbstractFormula> batchCalList, CollectCalculateService collectCalculateService, List<ExpressStatus> statusList, List<AbstractFormula> batchCalFromula, List<AbstractFormula> failFormula) {
        for (AbstractFormula formula : batchCalList) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)formula.getMsg())) {
                failFormula.add(formula);
                continue;
            }
            ExpressStatus expressStatus = collectCalculateService.addCollectCalculateExpress(formula.getFormulaStr());
            if (expressStatus.hasException()) {
                formula.setMsg(expressStatus.getException().getMessage());
                failFormula.add(formula);
                continue;
            }
            statusList.add(expressStatus);
            batchCalFromula.add(formula);
        }
    }

    private ICollectResultHandle getiCollectResultHandle(Map<String, String> glDimToBcmDim, RefParamResult refParamResult) {
        ICollectResultHandle handle = (collects, dynaKey, formula, ctx) -> {
            if (collects instanceof Map) {
                List<Object> keys = new ArrayList(16);
                keys = this.isNotUseFormulaResFilter ? dynaKey.getKey(formula, glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), null) : dynaKey.getKeyByRes(formula, glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), collects);
                BigDecimal value = BigDecimal.ZERO;
                if (keys.size() > 1) {
                    String msg = String.format(ResManager.loadKDString((String)"%1s \u6620\u5c04\u591a\u4e2a\u6838\u7b97\u7ef4\u5ea6\u6210\u5458 %2s\u3002", (String)"OrgDataCollectService_12", (String)"fi-bcm-business", (Object[])new Object[0]), ((PackKey)dynaKey).getBcmMems(), String.join((CharSequence)",", keys));
                    formula.setTipLogMsg(msg);
                    for (String string : keys) {
                        try {
                            Object v = ((Map)collects).get(string);
                            if (v == null) continue;
                            BigDecimal bigDecimal = NumberUtil.toBigDecimal(v);
                            value = value.add(bigDecimal);
                        }
                        catch (Exception e) {
                            formula.setException(e);
                        }
                    }
                    formula.setValue(value);
                } else {
                    formula.setValue(((Map)collects).get(keys.get(0)));
                }
            }
        };
        return handle;
    }

    private String[] fillDimMems(String[] rowcolMemNum, PackKey key) {
        String[] cloneMems = (String[])rowcolMemNum.clone();
        block0: for (String bcmMem : key.getBcmMems()) {
            for (int j = 0; j < cloneMems.length; ++j) {
                if (!cloneMems[j].equals("@")) continue;
                cloneMems[j] = bcmMem;
                continue block0;
            }
        }
        return cloneMems;
    }

    private void packedResultMap(String key, Object value, DataTraceFrom dc) {
        if (value instanceof Exception) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("-1", DataCollectUtil.getErrorMsg((Exception)value));
            FormulaRow row = new FormulaRow(key, map);
            this.ds.addRow(row);
        } else if (value instanceof BigDecimal) {
            if (!this.isDistinguish0AndNull && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                return;
            }
            FormulaRow row = new FormulaRow(key, value);
            if (dc != null) {
                row.setDataTraceFrom(dc);
            }
            this.ds.addRow(row);
        }
    }

    private String getTargetMember(String srcMember, List<DynamicObject> isSingleMap, String targetDim) {
        String targetNumber;
        if (StringUtils.isEmpty((CharSequence)srcMember)) {
            return null;
        }
        if (this.table.contains((Object)srcMember, (Object)targetDim)) {
            return (String)this.table.get((Object)srcMember, (Object)targetDim);
        }
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        for (DynamicObject isObject : isSingleMap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && ALL.equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null || sourceItem != null && !ALL.equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, srcMember, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
                continue;
            }
            if (ALL.equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)targetDim, (String)srcMember);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        String result = null;
        if (tempTargetMap.size() > 0 && !"".equals(targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue()) && !IGNORE.equals(targetNumber)) {
            result = targetNumber;
            this.table.put((Object)srcMember, (Object)targetDim, (Object)result);
        }
        return result;
    }

    private Set<String> getAllSrcMember(List<DynamicObject> members, String targetDim) {
        HashSet<String> allMembers = new HashSet<String>(10);
        Collection allNode = MemberReader.getAllNodeByDimNum((String)targetDim, (String)((String)this._ctx.getModel().p2));
        for (DynamicObject isObject : members) {
            int scope = isObject.getInt("scope");
            MappedMembItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                ((MappedSourceItem)sourceItem).mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            if (sourceItem == null) continue;
            String number = sourceItem.getNumber();
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                if (ALL.equals(sourceItem.getNumber())) {
                    allNode.forEach(node -> allMembers.add(node.getNumber()));
                    continue;
                }
                allMembers.add(number);
                continue;
            }
            for (IDNumberTreeNode node2 : allNode) {
                if (!FilterFactory.getFilter((MappedSourceItem)sourceItem, this._ctx).isMatched((MappedSourceItem)sourceItem, node2.getNumber(), this._ctx)) continue;
                allMembers.add(node2.getNumber());
            }
        }
        return allMembers;
    }

    private /* synthetic */ void lambda$queryFloatAcctcfFormula$23(String schemeAndOrg, String orgNum, String yearNum, String periodNum, Table result, CashflowCommonParam k, Pair v) {
        CashflowQueryParamApi param = new CashflowQueryParamApi();
        param.setOrgNumber(k.getOrgNumber());
        param.setPeriodNumber(k.getPeriodNumber());
        param.addSelector("yearamount");
        param.addSelector("amount");
        param.setBookTypeNumber(k.getBookTypeNumber());
        param.setCurrencyNumber(k.getCurrencyNumber());
        k.getAsstSet().forEach(asst -> {
            param.setAssgrp((String)asst, null);
            param.addGroupBy((String)asst);
        });
        param.setCfitemNumbers(((Set)v.p1).toArray(new String[0]));
        param.addGroupBy("cfitem.number");
        log.info(String.format("\u96c6\u6210\u603b\u8d26[%1$s]\u516c\u5f0f\u9884\u67e5\u8be2\u53c2\u6570\uff1a[%2$s]", schemeAndOrg, param));
        Map<String, Object> amounts = GlServiceHelper.getCashFlowAmount(param, this._ctx);
        log.info(String.format("\u96c6\u6210\u603b\u8d26[%1$s]\u516c\u5f0f\u9884\u67e5\u8be2\u7ed3\u679c\uff1a[%2$s]", schemeAndOrg, amounts));
        if (((Boolean)amounts.get("getSuccess")).booleanValue()) {
            String getData = amounts.get("getData").toString();
            try {
                List queryData = (List)JSONUtils.cast((String)getData, List.class);
                HashSet existDataMembers = new HashSet(16);
                for (Map data : queryData) {
                    Map assgrp = (Map)data.get("assgrp");
                    if (assgrp == null) continue;
                    HashMap asstValue = new HashMap(16);
                    assgrp.forEach((dim, value) -> {
                        String key = this.getSrcAndTargetKey((String)dim, this.glDimToBcmDim.get(dim));
                        if (this.allAsstMember.get(key) == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6[%s]\u672a\u914d\u7f6e\u5355\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"GLFormulaDataProvider_10", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
                        }
                        String number = value == null ? NONE : (String)value.get("number");
                        if (this.allAsstMember.get(key).contains(number)) {
                            asstValue.put(dim, number);
                        }
                    });
                    if (asstValue.size() != param.getAssgrp().size()) continue;
                    existDataMembers.add(asstValue);
                }
                for (Pair pair : (PairList)v.p2) {
                    String uuid = (String)pair.p1;
                    String formula = FormulaAnalyze.fillAcctTypeParam((String)pair.p2, orgNum, yearNum, periodNum);
                    existDataMembers.forEach(map -> {
                        String realFormula = formula;
                        ArrayList<String> replaceMember = new ArrayList<String>(10);
                        for (Map.Entry entry : map.entrySet()) {
                            String member = String.join((CharSequence)SPLIT, (CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                            String regex = String.join((CharSequence)SPLIT, (CharSequence)entry.getKey(), "@");
                            realFormula = realFormula.replace(regex, member);
                            replaceMember.add(member);
                        }
                        result.put((Object)uuid, (Object)realFormula, replaceMember);
                    });
                }
            }
            catch (IOException exception) {
                throw new KDBizException(String.format("cast [%s] to Map error", getData));
            }
        }
    }

    private /* synthetic */ void lambda$doLoadData$6(ICalContext ctx, String srcFy, String srcPeriod, CalculateService service, PairList resultKey, Recorder count, Map floatAcctcf, Table floatAcct, Table floatIct, Map isBatIctMap, MappedGroup e) {
        e.forEach(row -> {
            String formula = row.getExpression();
            if (formula.contains("@")) {
                String lowerFormula = formula.toLowerCase(Locale.ENGLISH);
                if (lowerFormula.startsWith("acct") || lowerFormula.startsWith("-acct")) {
                    Pair pair = Pair.onePair((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
                    AnalysisFormulaUtil.generateFloatAcctDy(formula, (Pair<List<String>, List<String>>)pair);
                    ArrayList<String> asstInFormula = new ArrayList<String>(10);
                    for (String s : (List)pair.p2) {
                        if (!((Set)this.asstAndComassist.p1).contains(s)) continue;
                        asstInFormula.add(s);
                    }
                    List<Pair<String, List<String>>> detailComassistFormula = this.generateFloatComassist(formula, (Pair<List<String>, List<String>>)pair, new ArrayList<List<String>>(10));
                    if (asstInFormula.isEmpty()) {
                        detailComassistFormula.forEach(p -> {
                            String f = FormulaAnalyze.fillAcctTypeParam((String)p.p1, ctx.getOrg(), srcFy, srcPeriod);
                            String key = this.getFormulaKey(row.getUuid(), new ArrayList<String>(), (List)p.p2);
                            if (key == null) {
                                return;
                            }
                            this.addFormula2Service(service, f, key, (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
                        });
                    } else {
                        for (Pair<String, List<String>> floatAsstFormula : detailComassistFormula) {
                            StringBuilder key;
                            formula = (String)floatAsstFormula.p1;
                            if (lowerFormula.contains("acctcf") && !IntegrateProductEnum.NGACC_CProduct.getNumber().equals(this.srcProduct)) {
                                key = new StringBuilder(row.getUuid());
                                for (String s : (List)floatAsstFormula.p2) {
                                    key.append(SPLIT);
                                    key.append(s);
                                }
                                floatAcctcf.put(key.toString(), formula);
                                continue;
                            }
                            formula = FormulaAnalyze.fillAcctTypeParam(formula, ctx.getOrg(), srcFy, srcPeriod);
                            if (this.openBatchCal && !lowerFormula.contains("acctcf")) {
                                key = new StringBuilder(row.getUuid());
                                for (String s : (List)floatAsstFormula.p2) {
                                    key.append(SPLIT);
                                    key.append(s);
                                }
                                floatAcct.put(asstInFormula, (Object)key.toString(), (Object)new AcctFormulaModel(formula));
                                continue;
                            }
                            ArrayList<List<String>> dimValue = new ArrayList<List<String>>(10);
                            List<Pair<String, List<String>>> formulas = this.generateFloatAcctDy(this.glDimToBcmDim, formula, this.allAsstMember, dimValue);
                            if (formulas == null || formulas.isEmpty()) continue;
                            formulas.forEach(p -> {
                                String key = this.getFormulaKey(row.getUuid(), (List)p.p2, (List)floatAsstFormula.p2);
                                if (key == null) {
                                    return;
                                }
                                this.addFormula2Service(service, (String)p.p1, key, (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
                            });
                        }
                    }
                } else if (lowerFormula.startsWith("ict") || lowerFormula.startsWith("-ict")) {
                    formula = FormulaAnalyze.fillAcctTypeParam(formula, ctx.getOrg(), srcFy, srcPeriod);
                    Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(formula);
                    if (pair.p1 != null && ((Map)pair.p1).size() > 0) {
                        PairList<String, String> formulas = this.generateFloatIctFormula(formula);
                        if (formulas.size() == 0) {
                            return;
                        }
                        List<String> asstInFormula = this.getAsstFormula((List)pair.p2);
                        formulas.forEach(p -> {
                            String key = this.getFormulaKey(row.getUuid(), (String)p.p2);
                            if (key == null) {
                                return;
                            }
                            if (pair.p2 == null || ((List)pair.p2).size() == 0) {
                                this.addFormula2Service(service, (String)p.p1, key, (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
                            } else {
                                floatIct.put((Object)asstInFormula, (Object)key, (Object)new AcctFormulaModel((String)p.p1));
                            }
                        });
                    } else if ((pair.p1 == null || ((Map)pair.p1).size() == 0) && pair.p2 != null && ((List)pair.p2).size() > 0) {
                        List<String> asstInFormula = this.getAsstFormula((List)pair.p2);
                        String key = row.getUuid();
                        floatIct.put(asstInFormula, (Object)key, (Object)new AcctFormulaModel(formula));
                    } else if (!(pair.p1 != null && ((Map)pair.p1).size() != 0 || pair.p2 != null && ((List)pair.p2).size() != 0)) {
                        isBatIctMap.put("isBatIct", "false");
                        PairList<String, String> formulas = this.generateFloatIctFormula(formula);
                        if (formulas.size() == 0) {
                            return;
                        }
                        formulas.forEach(p -> {
                            String key = this.getFormulaKey(row.getUuid(), (String)p.p2);
                            if (key == null) {
                                return;
                            }
                            this.addFormula2Service(service, (String)p.p1, key, (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
                        });
                    }
                }
            } else {
                formula = FormulaAnalyze.fillAcctTypeParam(formula, ctx.getOrg(), srcFy, srcPeriod);
                this.addFormula2Service(service, formula, row.getUuid(), (PairList<String, ExpressStatus>)resultKey, (Recorder<Integer>)count);
            }
        });
    }
}

