/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.formula.ws;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.integrationnew.util.DesCrypto;

public class WebServiceClient {
    private static final Log log = LogFactory.getLog(WebServiceClient.class);

    public static WebServiceClient getInstance() {
        return new WebServiceClient();
    }

    public <T> T callGetDynItemData(Long schemeid, Map<String, Object> bizParam) throws Exception {
        Map<String, Object> loginParam = this.getEASLoginParam(schemeid);
        return (T)this.callMethodForWebService(loginParam.get("http_protocal").toString(), loginParam.get("ip").toString(), loginParam.get("port").toString(), loginParam.get("loginParam"), bizParam, "getDynItemData");
    }

    public <T> T calcFormulaValues(Long schemeid, List<Map<String, Object>> bizParam) throws Exception {
        Map<String, Object> loginParam = this.getEASLoginParam(schemeid);
        return (T)this.callMethodForWebService(loginParam.get("http_protocal").toString(), loginParam.get("ip").toString(), loginParam.get("port").toString(), loginParam.get("loginParam"), bizParam, "calcFormulaValues");
    }

    public <T> T getRptDataList(Long schemeid, Object param) throws Exception {
        Map<String, Object> loginParam = this.getEASLoginParam(schemeid);
        return (T)this.callMethodForWebService(loginParam.get("http_protocal").toString(), loginParam.get("ip").toString(), loginParam.get("port").toString(), loginParam.get("loginParam"), param, "getRptDataList");
    }

    private Object callMethodForWebService(String http_protocal, String ip, String port, Object loginParam, Object bizParam, String methodName) throws Exception {
        Class<?> clazzService = Class.forName("org.apache.axis.client.Service");
        Class<?> clazz = Class.forName("org.apache.axis.client.Call");
        Object obj = clazz.getConstructor(clazzService).newInstance(clazzService.newInstance());
        Method setOperationName = clazz.getMethod("setOperationName", QName.class);
        setOperationName.invoke(obj, new QName("http://webservice.rptintegration.gr.fi.eas.kingdee.com", methodName));
        Method setTargetEndpointAddress = clazz.getMethod("setTargetEndpointAddress", String.class);
        log.info("setTargetEndpointAddress:" + http_protocal + ":" + ip + ":" + port);
        setTargetEndpointAddress.invoke(obj, http_protocal + "://" + ip + ":" + port + "/ormrpc/services/RptIntegrationWebServiceFacade");
        Method setTimeout = clazz.getMethod("setTimeout", Integer.class);
        Long timeOut = ParamSettingServiceHelper.getInt((long)0L, (String)"EASInterfaceTime");
        if (timeOut == null || timeOut == 0L) {
            timeOut = 180000L;
        }
        setTimeout.invoke(obj, timeOut.intValue());
        Method invoke = clazz.getMethod("invoke", Object[].class);
        Object[] param = new Object[]{loginParam, bizParam};
        Object result = invoke.invoke(obj, new Object[]{param});
        return result;
    }

    private Map<String, Object> getEASLoginParam(Long schemeid) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"isscheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeid)});
        DynamicObject database = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"http_protocal,server_ip,server_port,icid,data_center,user,newpwd", (QFilter[])new QFilter[]{new QFilter("source_system", "=", scheme.get("isscheme"))});
        HashMap<String, String> loginParam = new HashMap<String, String>();
        loginParam.put("username", database.getString("user"));
        loginParam.put("password", new DesCrypto().encrypt(database.getString("user"), database.getString("newpwd")));
        loginParam.put("dcname", database.getString("data_center"));
        if (StringUtils.isNotEmpty((String)database.getString("icid").trim())) {
            loginParam.put("language", database.getString("icid"));
        }
        param.put("ip", database.getString("server_ip"));
        param.put("port", database.getString("server_port"));
        param.put("http_protocal", database.getString("http_protocal"));
        param.put("loginParam", loginParam);
        return param;
    }
}

