/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.gl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.gl.GLDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.model.BalanceReClassNumberParam;
import kd.fi.bcm.business.model.GlServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class GLDataProvider
extends AbstractDataProvider {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(GLDataProvider.class);
    private static final String ORGID = "orgid";
    private static final String ORGNUMBER = "orgnumber";
    private static final String COMASSIST = "comassist";
    private static final String SPLIT = "@";
    private static final String NULL = "null";
    private static final String ALL = "*";
    private Map<String, MappedGroup> comboGroupMap;
    private Set<String> bookTypeSet;
    private Map<String, Map<String, Set<String>>> accountMap;
    private SingleMapModel singleMapModel;
    private GLDataSet dataSet;
    private Set<String> asstInSingle;
    private Set<String> asstInDef;

    public GLDataProvider(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected void beforeLoadData() {
        super.beforeLoadData();
        this.buildSingleMapModel();
        this.groupComboMappedRow();
        this.asstInSingle = (Set)IntegrationUtil.getAsstInSingle((IIntegrateContext)this._ctx).p1;
        this.asstInDef = (Set)IntegrationUtil.getAsstInSrcDef((IIntegrateContext)this._ctx).p1;
        this.accountMap = new HashMap<String, Map<String, Set<String>>>(16);
        this.dataSet = new GLDataSet();
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        Map<String, Object> srcOrgMap = IntegrationUtil.getSrcOrgProfitCenter(this._ctx, this.singleMapModel);
        Pair srcOrg = Pair.onePair((Object)((Long)srcOrgMap.get(ORGID)), (Object)((String)srcOrgMap.get(ORGNUMBER)));
        Map comassist = (Map)srcOrgMap.get(COMASSIST);
        String GLPeriod = this.getGLPeriodNum();
        String srcCurrency = this.getSrcCurrency();
        for (String bookType : this.bookTypeSet) {
            DynamicObject book = this.getAccountBook((String)srcOrg.p2, bookType);
            Map<String, Set<String>> map = this.buildAccountMap((Long)srcOrg.p1, book.getLong("accounttable.id"), book.getString("periodType.number"), GLPeriod);
            this.accountMap.put(bookType, map);
        }
        this.comboGroupMap.forEach((k, group) -> {
            String[] keys = k.split(SPLIT);
            String bookType = NULL.equals(keys[0]) ? null : keys[0];
            String accountTable = NULL.equals(keys[1]) ? null : keys[1];
            String orgView = NULL.equals(keys[2]) ? null : keys[2];
            int reClass = NULL.equals(keys[3]) ? 1 : Integer.parseInt(keys[3]);
            BalanceReClassNumberParam param = this.buildQueryParam((String)srcOrg.p2, orgView, bookType, accountTable, GLPeriod, srcCurrency, reClass, comassist);
            Map<String, Set<String>> accountNumMap = this.accountMap.get(bookType);
            group.forEach(mappedRow -> {
                MappedSourceItem srcAccount = mappedRow.getSrcMapped().get("AccountView");
                String fetchType = mappedRow.getSrcMapped().get("ChangeType").getNumber();
                param.addFetchType(fetchType);
                Set<String> queryAccount = this.getQueryAccount(srcAccount, accountNumMap);
                for (String account : queryAccount) {
                    Set asstNumSet = (Set)accountNumMap.get(account);
                    Set asstInCombo = (Set)IntegrationUtil.getAsstInCombo((MappedRow)mappedRow, (IIntegrateContext)this._ctx).p1;
                    Set<String> allAsst = IntegrationUtil.getAsstInAll(asstInCombo, this.asstInSingle, this.asstInDef);
                    allAsst.retainAll(asstNumSet);
                    HashMap<String, String> assGroup = new HashMap<String, String>();
                    allAsst.forEach(num -> {
                        String cfr_ignored_0 = assGroup.put((String)num, (String)null);
                    });
                    assGroup.keySet().forEach(param::addGroupBy);
                    param.addAccountAssgrp(account, assGroup);
                }
            });
            String glData = GlServiceHelper.getBalance(param, this._ctx);
            this.collectData(glData, (String)k);
        });
        this.dataSet.clearRepeatNum();
        return this.dataSet;
    }

    private void buildSingleMapModel() {
        DimensionMsgCache dimCache = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(dimCache.getDimId(DimTypesEnum.PERIOD.getNumber()));
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        DynamicObject srcCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isbaseentlist", (String)"id,number", (QFilter[])new QFilter[]{filter});
        this.singleMapModel.buildSrc(srcCurrency.getLong("id"));
    }

    private void groupComboMappedRow() {
        this.comboGroupMap = new HashMap<String, MappedGroup>(16);
        this.bookTypeSet = new HashSet<String>(16);
        this._ctx.getCombineMappedGroup().forEach(e -> e.forEach(mappedRow -> {
            String key = IntegrationUtil.getMappedKey(mappedRow);
            String bookType = key.split(SPLIT)[0];
            this.bookTypeSet.add(bookType);
            this.comboGroupMap.computeIfAbsent(key, g -> new MappedGroup());
            MappedGroup group = this.comboGroupMap.get(key);
            group.addMappedRow((MappedRow)mappedRow);
        }));
    }

    private String getGLPeriodNum() {
        String srcPeriod;
        String srcYear;
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        if (fyPair == null) {
            if (this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), ALL) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u8d22\u5e74\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLBalanceDataProvider_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getFy().p2));
            }
            srcYear = ((String)this._ctx.getFy().p2).substring(2);
        } else {
            srcYear = ((String)fyPair.p2).substring(0, 4);
        }
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        try {
            if (periodPair == null) {
                if (this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), ALL) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u671f\u95f4\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLBalanceDataProvider_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getPeriod().p2));
                }
                srcPeriod = ((String)this._ctx.getPeriod().p2).substring(3);
            } else {
                srcPeriod = ((String)periodPair.p2).substring(4);
            }
        }
        catch (Exception e) {
            log.error("periodPair is error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u683c\u5f0f\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"GLFormulaDataProvider_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return srcYear + srcPeriod;
    }

    private String getSrcCurrency() {
        Pair<Long, String> currencyPair = this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2);
        String srcCurrency = currencyPair == null ? (this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), ALL) == null ? "" : (String)this._ctx.getCurrency().p2) : (String)currencyPair.p2;
        return srcCurrency;
    }

    private BalanceReClassNumberParam buildQueryParam(String org, String orgView, String bookType, String accountTable, String period, String currency, int reClass, Map<String, List<String>> comassist) {
        BalanceReClassNumberParam param = new BalanceReClassNumberParam();
        param.setOrgNumber(org);
        param.setOrgViewNumber(orgView);
        param.setBookTypeNumber(bookType);
        param.setAccountTableNumber(accountTable);
        param.setPeriodNumber(period);
        param.setCurrencyNumber(currency);
        reClass = reClass <= 0 ? 1 : reClass;
        param.setAcctReClass(reClass);
        if (comassist != null) {
            param.setComassist(comassist);
        }
        return param;
    }

    private DynamicObject getAccountBook(String org, String bookType) {
        QFilter orgFilter = new QFilter("org.number", "=", (Object)org);
        QFilter bookFilter = new QFilter("bookstype.number", "=", (Object)bookType);
        String accountBookEntity = IntergrationUtil.getAccountBookMetadataNumber();
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)accountBookEntity, (String)"accounttable.number,accounttable.id,periodType.number", (QFilter[])new QFilter[]{orgFilter, bookFilter});
        if (book == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u8d26\u7c3f\u7c7b\u578b\u201c%2$s\u201d\u5bf9\u5e94\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"GLBalanceDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), org, bookType));
        }
        return book;
    }

    private Map<String, Set<String>> buildAccountMap(Long orgId, Long accountTableId, String periodType, String GLPeriod) {
        DynamicObject[] accountColl;
        HashMap<String, Set<String>> accountNumMap = new HashMap<String, Set<String>>(16);
        QFilter periodf1 = new QFilter("periodtype.number", "=", (Object)periodType);
        QFilter periodf2 = new QFilter("number", "=", (Object)GLPeriod);
        DynamicObject truePeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{periodf1, periodf2});
        if (truePeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u201c%1$s\u201d\u4e0b\u7684\u6e90\u671f\u95f4\u201c%2$s\u201d\u3002", (String)"GLBalanceDataProvider_4", (String)"fi-bcm-business", (Object[])new Object[0]), periodType, GLPeriod));
        }
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        qfilter.and("accounttable", "=", (Object)accountTableId);
        qfilter.and(new QFilter("startdate", "<=", (Object)truePeriod.getDate("enddate")));
        qfilter.and(new QFilter("enddate", ">=", (Object)truePeriod.getDate("enddate")));
        for (DynamicObject account : accountColl = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"number,dc,checkitementry, checkitementry.asstactitem, checkitementry.asstactitem.number", (QFilter[])new QFilter[]{qfilter})) {
            String number = account.getString("number");
            HashSet asstNumSet = new HashSet();
            account.getDynamicObjectCollection("checkitementry").forEach(e -> asstNumSet.add(e.getString("asstactitem.number")));
            accountNumMap.put(number, asstNumSet);
        }
        return accountNumMap;
    }

    private Set<String> getQueryAccount(MappedSourceItem srcAccount, Map<String, Set<String>> accountNumMap) {
        if (ALL.equals(srcAccount.getNumber())) {
            return accountNumMap.keySet();
        }
        HashSet<String> result = new HashSet<String>();
        IFilter<String> filter = FilterFactory.getFilter(srcAccount, this._ctx);
        accountNumMap.keySet().forEach(e -> {
            if (filter.isMatched(srcAccount, (String)e, this._ctx)) {
                result.add((String)e);
            }
        });
        return result;
    }

    private void collectData(String glData, String key) {
        List dataList;
        if (glData == null) {
            return;
        }
        try {
            dataList = (List)JSONUtils.cast((String)glData, List.class);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        for (Map data : dataList) {
            data.put("key", key);
            StdMdRow row = new StdMdRow(data);
            this.dataSet.addRow(row);
        }
    }
}

