/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.gl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;

public class GLDataSet
implements IDataSet<IRow> {
    private List<IRow> rows = new ArrayList<IRow>();

    public void addRow(StdMdRow row) {
        String account = (String)row.get("number");
        String key = (String)row.get("key");
        HashMap assgrp = (HashMap)row.get("assgrp");
        if (assgrp == null) {
            assgrp = new HashMap(16);
            row.put("assgrp", assgrp);
        }
        boolean isExist = false;
        for (IRow r : this.rows) {
            if (!account.equals(r.get("number")) || !key.equals(r.get("key")) || !assgrp.equals(r.get("assgrp"))) continue;
            for (String s : row.getKeySet()) {
                if ("number".equals(s) || "key".equals(s) || "assgrp".equals(s)) continue;
                if (r.get(s) != null) {
                    BigDecimal old = new BigDecimal(r.get(s).toString());
                    BigDecimal newValue = old.add(new BigDecimal(row.get(s).toString()));
                    ((StdMdRow)r).put(s, newValue);
                    continue;
                }
                ((StdMdRow)r).put(s, row.get(s));
            }
            isExist = true;
            break;
        }
        if (!isExist) {
            this.rows.add(row);
        }
    }

    public void clearRepeatNum() {
        HashMap<String, Integer> rowNumMap = new HashMap<String, Integer>(16);
        for (IRow row : this.rows) {
            String key = row.get("number") + "|" + row.get("key");
            rowNumMap.putIfAbsent(key, 0);
            rowNumMap.put(key, (Integer)rowNumMap.get(key) + 1);
        }
        rowNumMap.forEach((? super K k, ? super V v) -> {
            if (v == 1) {
                return;
            }
            Iterator<IRow> iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                IRow row = iterator.next();
                String key = row.get("number") + "|" + row.get("key");
                Map assgrp = (Map)row.get("assgrp");
                if (!k.equals(key) || !assgrp.isEmpty()) continue;
                iterator.remove();
            }
        });
    }

    public void addAll(List<IRow> datas) {
        this.rows.addAll(datas);
    }

    @Override
    public Iterator<IRow> iterator() {
        return this.rows.iterator();
    }

    public int getSize() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public List<IRow> getRows() {
        return this.rows;
    }
}

