/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.my2eas;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.my2eas.BCMDataSet;
import kd.fi.bcm.business.integrationnew.provider.my2eas.BCMRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.sql.MDColumn;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class OlapDataBulider {
    protected IIntegrateContext _ctx;
    private Map<String, Long> numberAndId;
    private Table<String, String, Pair<Long, String>> srcMapTargMemb;

    public Table<String, String, Pair<Long, String>> getSrcMapTargMemb() {
        return this.srcMapTargMemb;
    }

    public OlapDataBulider(IIntegrateContext _ctx) {
        this._ctx = _ctx;
        this.srcMapTargMemb = HashBasedTable.create();
    }

    public SQLBuilder getOlapSql(boolean isFloat) {
        SQLBuilder sql = new SQLBuilder((String)this._ctx.getModel().p2);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        HashMultimap map = HashMultimap.create();
        ArrayList<String> floatDim = new ArrayList<String>();
        if (!this.getGroupFilter(isFloat, (Multimap<String, String>)map, floatDim)) {
            return null;
        }
        this._ctx.getSourceDefaultValsMap().values().forEach(arg_0 -> OlapDataBulider.lambda$getOlapSql$1((Multimap)map, isFloat, floatDim, arg_0));
        this.fixSrcMapTargMemb();
        this.getSrcMapTargMemb().rowKeySet().forEach(arg_0 -> this.lambda$getOlapSql$2((Multimap)map, arg_0));
        if (this.checkCommFilter((Multimap<String, String>)map)) {
            return null;
        }
        for (String dimNum : map.keySet()) {
            sql.addFilter(dimNum, map.get((Object)dimNum).toArray(new String[0]));
        }
        sql.addSelectField(this.getDimensionNums((Long)this._ctx.getModel().p1));
        return sql;
    }

    private boolean checkCommFilter(Multimap<String, String> map) {
        HashMap<String, Object> commmap = new HashMap<String, Object>();
        commmap.put(DimTypesEnum.ENTITY.getNumber(), this._ctx.getOrg().p2);
        commmap.put(DimTypesEnum.YEAR.getNumber(), this._ctx.getFy().p2);
        commmap.put(DimTypesEnum.PERIOD.getNumber(), this._ctx.getPeriod().p2);
        commmap.put(DimTypesEnum.CURRENCY.getNumber(), this._ctx.getCurrency().p2);
        for (Map.Entry value : commmap.entrySet()) {
            if (map.containsKey(value.getKey()) && map.get(value.getKey()).contains(value.getValue())) {
                map.removeAll(value.getKey());
                map.put(value.getKey(), value.getValue());
                continue;
            }
            return true;
        }
        return false;
    }

    private boolean getGroupFilter(boolean isFloat, Multimap<String, String> map, List<String> floatDim) {
        int size = 0;
        for (MappedGroup group : this._ctx.getCombineMappedGroup()) {
            for (MappedRow row : group) {
                if (row.isFloat() == isFloat) {
                    this.getNumbersFromMapRow(map, row);
                    ++size;
                }
                if (!row.isFloat()) continue;
                row.getSrcMapped().values().forEach(s -> {
                    if (s.isFloatDim() || s.isFloatTxt()) {
                        floatDim.add(s.getMappedDim().getNumber());
                    }
                });
            }
        }
        return size != 0;
    }

    private void getNumbersFromMapRow(Multimap<String, String> map, MappedRow row) {
        Iterator<Map.Entry<String, MappedSourceItem>> iterator = row.srcMappediterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MappedSourceItem> next = iterator.next();
            if (next.getValue().isFloatTxt() || next.getValue().isFloatDim()) continue;
            Set<String> numbers = OlapDataBulider.getNumbersByInnerInfo(next.getValue(), (Long)this._ctx.getModel().p1);
            map.putAll((Object)next.getKey(), numbers);
        }
    }

    public String[] getDimensionNums(long modelId) {
        if (this.numberAndId == null) {
            this.numberAndId = new HashMap<String, Long>();
            QFilter qf = new QFilter("model.id", "=", (Object)modelId);
            QFilter[] qfs = new QFilter[]{qf};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)"id,number", (QFilter[])qfs, null);
            dcs.forEach(p -> this.numberAndId.put(p.getString("number"), p.getLong("id")));
        }
        return this.numberAndId.keySet().toArray(new String[0]);
    }

    public Long[] getDimensionIds(long modelId) {
        if (this.numberAndId == null) {
            this.numberAndId = new HashMap<String, Long>();
            QFilter qf = new QFilter("model.id", "=", (Object)modelId);
            QFilter[] qfs = new QFilter[]{qf};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)"bcm_dimension", (String)"id,number", (QFilter[])qfs, null);
            dcs.forEach(p -> this.numberAndId.put(p.getString("number"), p.getLong("id")));
        }
        return this.numberAndId.values().toArray(new Long[0]);
    }

    private static Set<String> getNumbersByInnerInfo(MappedSourceItem scopeitem, long modelid) {
        if (ThreadCache.exists((Object)scopeitem.hashCode())) {
            return (Set)ThreadCache.get((Object)scopeitem.hashCode());
        }
        MapScopeEnum sc = MapScopeEnum.getEnumByindex((int)scopeitem.getScope());
        HashSet<String> numbers = new HashSet<String>();
        if (sc == null) {
            ArrayList<MappedSourceItem> scopes = new ArrayList<MappedSourceItem>();
            if (scopeitem.getScopeSourceItems() != null) {
                scopes.addAll(scopeitem.getScopeSourceItems());
            } else {
                scopes.add(scopeitem);
            }
            for (MappedSourceItem scinfo : scopes) {
                new MembRangeItem(scinfo.getMappedDim().getEntityNumb(), (Long)scinfo.getId(), scinfo.getNumber(), RangeEnum.getRangeByVal((int)scinfo.getScope()), scinfo.isCustom(), (Object)modelid).matchItems(c -> numbers.add(c.number));
            }
            return numbers;
        }
        switch (sc) {
            case EQUALS: {
                numbers.add(scopeitem.getNumber());
                break;
            }
            case LIKE: {
                DynamicObjectCollection docs = QueryServiceHelper.query((String)scopeitem.getMappedDim().getEntityNumb(), (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelid), new QFilter("number", "like", (Object)scopeitem.getNumber())});
                if (docs == null || docs.size() <= 0) break;
                docs.forEach(d -> numbers.add(d.getString("number")));
                break;
            }
            case RANGE: {
                String startNum = scopeitem.getScopeSourceItems().first().getNumber();
                String endNum = scopeitem.getScopeSourceItems().last().getNumber();
                if (startNum.compareTo(endNum) > 0) {
                    String tmp = endNum;
                    endNum = startNum;
                    startNum = tmp;
                }
                QFilter qf = new QFilter("number", ">=", (Object)startNum).and(new QFilter("number", "<=", (Object)endNum));
                DynamicObjectCollection docs = QueryServiceHelper.query((String)scopeitem.getMappedDim().getEntityNumb(), (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelid), qf});
                if (docs == null || docs.size() <= 0) break;
                docs.forEach(d -> numbers.add(d.getString("number")));
                break;
            }
            case INCLUDE: {
                break;
            }
        }
        ThreadCache.put((Object)scopeitem.hashCode(), numbers);
        return numbers;
    }

    public boolean checkCtx() {
        Long[] dimids = this.getDimensionIds((Long)this._ctx.getModel().p1);
        HashSet<Long> disappids = new HashSet<Long>();
        this._ctx.getSourceDefaultValsMap().keySet().forEach(k -> disappids.add((Long)k));
        disappids.addAll(this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().keySet());
        Long[] longArray = dimids;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long id = longArray[i];
            if (disappids.contains(id)) continue;
            QFBuilder qf = new QFBuilder();
            qf.add("dimmapid", "=", (Object)this._ctx.getMappedRelation().getSingeDimRelationByDimId(id).getDimMappedId());
            try (DataSet ds = IntegrationUtil.queryMemberMapped(qf, null);){
                if (!ds.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                this.buildSingleMap(this._ctx.getMappedDimItemById(id), ds);
                continue;
            }
        }
        return true;
    }

    public void fixSrcMapTargMemb() {
        Long[] dimids;
        Long[] longArray = dimids = this.getDimensionIds((Long)this._ctx.getModel().p1);
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long id = longArray[i];
            MappedDimItem dimitem = this._ctx.getMappedDimItemById(id);
            if (this.getSrcMapTargMemb().rowKeySet().contains(dimitem.getNumber())) continue;
            QFBuilder qf = new QFBuilder();
            DimMappedRelation.SingleDimRelationPair sdp = this._ctx.getMappedRelation().getSingeDimRelationByDimId(id);
            if (sdp == null || sdp.getDimMappedId() == 0L) continue;
            qf.add("dimmapid", "=", (Object)sdp.getDimMappedId());
            try (DataSet ds = IntegrationUtil.queryMemberMapped(qf, null);){
                this.buildSingleMap(dimitem, ds);
                continue;
            }
        }
    }

    private void buildSingleMap(MappedDimItem dimitem, DataSet ds) {
        while (ds.hasNext()) {
            Row r = ds.next();
            this.getSrcMapTargMemb().put((Object)dimitem.getNumber(), (Object)r.getString("issinglemapentry.srcmemnumber"), (Object)Pair.onePair((Object)r.getLong("targmembid"), (Object)r.getString("targmembnumber")));
        }
    }

    public BCMDataSet transToBcmDataSet(MDResultSet olpdataSet) {
        BCMDataSet dataSet = new BCMDataSet();
        List<MDColumn> cols = olpdataSet.getMetaData().getMetaDatas();
        while (olpdataSet.next()) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>(cols.size());
            kd.fi.bcm.business.sql.Row row = olpdataSet.getRow();
            for (MDColumn col : cols) {
                fieldValues.put(col.getMdName(), row.getOriginalValue(col.getMdName()));
            }
            BCMRow bcmRow = new BCMRow(fieldValues);
            dataSet.addRow(bcmRow);
        }
        return dataSet;
    }

    private /* synthetic */ void lambda$getOlapSql$2(Multimap map, String r) {
        if (!map.containsKey((Object)r)) {
            map.putAll((Object)r, this.getSrcMapTargMemb().row((Object)r).keySet());
        }
    }

    private static /* synthetic */ void lambda$getOlapSql$1(Multimap map, boolean isFloat, List floatDim, DimMappedRelation.DimAndDefValRela sd) {
        sd.getDefVals().forEach(sdv -> {
            if (!(map.containsKey((Object)sdv.getMappedDim().getNumber()) || isFloat && floatDim.contains(sdv.getMappedDim().getNumber()))) {
                map.put((Object)sdv.getMappedDim().getNumber(), (Object)sdv.getNumber());
            }
        });
    }
}

