/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.standard2my;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.disclosure.DatasetServiceHelper;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.EBApiResult;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.map.MultiKeyMap;

public class ModelDataProvider
extends AbstractDataProvider {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(ModelDataProvider.class);
    private SingleMapModel singleMapModel;
    private DimensionMsgCache dim;
    private static final String ALL = "*";
    private Map<String, String> mapkey;
    private static final String IGNORE = "IGNORE";
    private boolean isCslOrRptModel;
    private static final int HTTP_CONN_TIMEOUT = 30000;
    private static final int HTTP_READ_TIMEOUT = 600000;
    private static final String DIMENSION = "dimension";
    private static final String DATA = "data";
    public static final List<String> notNeedReturnDims = Arrays.asList(PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.CURRENCY_DIM);

    public ModelDataProvider(IIntegrateContext ctx) {
        super(ctx);
        this.dim = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
        this.mapkey = new HashMap<String, String>(16);
        ctx.getMappedRelation().getSingleMappedRelationPair().values().forEach(v -> {
            if (v.getMappedType() == 1) {
                this.mapkey.put(v.getSourceDimItem().getDimItem().getNumber(), v.getTargetDimItem().getDimItem().getNumber());
            }
        });
        this.isCslOrRptModel = this.initModelType();
    }

    public final boolean initModelType() {
        String productNum = this.getScrProductNum(this._ctx.getSchema());
        if (IntegrateProductEnum.NGBGMODELProduct.getNumber().equals(productNum)) {
            return false;
        }
        if (IntegrateProductEnum.NGCMMODELProduct.getNumber().equals(productNum) || IntegrateProductEnum.NGFRMODELProduct.getNumber().equals(productNum)) {
            return true;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u4f53\u7cfb\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"ModelDataProvider_1", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        Pair<Long, String> orgPair = this.singleMapModel.getSrc(DimTypesEnum.ENTITY.getNumber(), (String)this._ctx.getOrg().p2);
        Pair<Long, String> curPair = this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2);
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        orgPair = this.validateAndSetPair(DimTypesEnum.ENTITY, orgPair, (String)this._ctx.getOrg().p2);
        curPair = this.validateAndSetPair(DimTypesEnum.CURRENCY, curPair, (String)this._ctx.getCurrency().p2);
        fyPair = this.validateAndSetPair(DimTypesEnum.YEAR, fyPair, (String)this._ctx.getFy().p2);
        periodPair = this.validateAndSetPair(DimTypesEnum.PERIOD, periodPair, (String)this._ctx.getPeriod().p2);
        String org = (String)orgPair.p2;
        String currency = (String)curPair.p2;
        String fy = (String)fyPair.p2;
        String period = (String)periodPair.p2;
        return this.isCslOrRptModel ? this.buildModelResultSet(org, fy, period, currency) : this.buildBGModelResultSet(org, fy, period, currency);
    }

    private Pair<Long, String> validateAndSetPair(DimTypesEnum dim, Pair<Long, String> pair, String member) {
        if (pair == null) {
            Pair<Long, String> pair2 = pair = this.singleMapModel.getSrc(dim.getNumber(), ALL) != null ? Pair.onePair((Object)0L, (Object)member) : null;
            if (pair == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684%1$s[%2$s]\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"StandardMultiDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), member));
            }
        }
        return pair;
    }

    private String getScrProductNum(Pair<Long, String> scheme) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)scheme.p1, (String)"bcm_isscheme");
        return dyn.getDynamicObject("issrc").getString("number");
    }

    private IDataSet<IRow> buildBGModelResultSet(String org, String fy, String period, String currency) {
        List<Map<String, Object>> resList = this.getResList(org, fy, period, currency);
        StdMdDataSet rowSet = this.getRowSet4BG(resList);
        return rowSet;
    }

    private List<Map<String, Object>> getResList(String org, String fy, String period, String currency) {
        Set<String> hasSet = this.getFixDim();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        this.setBGSrcPrePara(paraMap, org, fy, period, currency);
        this.setSrcDefaultPara(paraMap);
        this.setGroupPara(paraMap, hasSet);
        this.setOtherPara(paraMap, hasSet);
        if (paraMap.get("Account") == null) {
            paraMap.put("Account", "Account");
        }
        this.transSet2List(paraMap);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme");
        long issrcmodelId = scheme.getDynamicObject("issrcmodel").getLong("id");
        DynamicObject ngmodel = BusinessDataServiceHelper.loadSingle((Object)issrcmodelId, (String)"bcm_isngmodel");
        String userType = ngmodel.getString("userType");
        String dataSource = ngmodel.getString("datasource");
        List<Map<String, Object>> res = null;
        res = "1".equals(userType) && RequestContext.get().getAccountId().equals(dataSource) ? ModelDataProvider.getResBySameUserSameSource(paraMap, this._ctx) : ModelDataProvider.getOtherSourceBGCMOlapData(ngmodel, paraMap, this._ctx);
        if (res == null || res.size() == 0) {
            log.error("doCustomService is error" + JSON.toJSONString(paraMap));
        }
        return res;
    }

    public static List<Map<String, Object>> getResBySameUserSameSource(Map<String, Object> dataMap, IIntegrateContext _ctx) {
        Long startTime = System.currentTimeMillis();
        Object apiResObj = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"TPBudgetMemberOlapApiService", (String)"queryOlapSpecificSymbol", (Object[])new Object[]{dataMap});
        IntegrationUtil.addTimeUse(_ctx, startTime, "TPBudgetMemberOlapApiService:queryOlapSpecificSymbol");
        String apiResStr = JSONObject.toJSONString((Object)apiResObj);
        EBApiResult apiRes = (EBApiResult)JSONObject.parseObject((String)apiResStr, EBApiResult.class);
        if (!apiRes.getSuccess()) {
            throw new KDBizException(apiRes.getMessage());
        }
        if (apiRes.getData() == null) {
            log.error("TPBudgetMemberOlapApiService:queryOlapSpecificSymbol:" + apiRes.getMessage());
            return new ArrayList<Map<String, Object>>();
        }
        List responseList = (List)JSONObject.parseObject((String)apiRes.getData().toString(), List.class);
        if (responseList.size() == 0) {
            log.error("TPBudgetMemberOlapApiService:queryOlapSpecificSymbol:" + apiRes.getMessage());
        }
        return responseList;
    }

    public static List<Map<String, Object>> getOtherSourceBGCMOlapData(DynamicObject ngModel, Map<String, Object> dataMap, IIntegrateContext _ctx) {
        String phoneNumber = ngModel.getString("phonenumber");
        String passWord = ngModel.getString("password");
        KAESEncrypter ken = new KAESEncrypter();
        String pw = ken.decode(passWord);
        String response = null;
        try {
            Long tdpdatacenterId = null;
            Object tdpdatacenterObj = ngModel.get("tdpdatacenterid");
            if (tdpdatacenterObj instanceof DynamicObject) {
                tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
            } else if (tdpdatacenterObj instanceof Long) {
                tdpdatacenterId = (Long)tdpdatacenterObj;
            }
            DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
            String userUrl = tdpdatacenter.getString("address");
            String loginToken = DimMappingHelper.getLoginTokenWithPass(phoneNumber, pw, tdpdatacenter);
            HashMap<String, String> requestHeader = new HashMap<String, String>(2);
            requestHeader.put("accessToken", loginToken);
            String fullUrl = userUrl + "/kapi/app/eb/BudgetMemberOlapNewApi";
            String paramStr = JSON.toJSONString(dataMap);
            log.info("ModelDataProvider queryOlap fullUrl:" + fullUrl + ", begin:");
            Long startTime = System.currentTimeMillis();
            response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)30000, (int)600000);
            IntegrationUtil.addTimeUse(_ctx, startTime, fullUrl + " queryOlap");
            ApiResult res = (ApiResult)JSONUtils.cast((String)response, ApiResult.class, (boolean)true);
            if (!res.getSuccess()) {
                log.error("ModelDataProvider queryOlap error:" + response);
                throw new KDBizException(res.getMessage());
            }
            log.info("ModelDataProvider olap fullUrl:" + fullUrl + ", response:" + response);
            ArrayList responseList = (ArrayList)res.getData();
            if (responseList == null || responseList.size() == 0) {
                log.error("TPBudgetMemberOlapApiService:queryOlapSpecificSymbol api:" + res.getMessage());
                return new ArrayList<Map<String, Object>>();
            }
            return responseList;
        }
        catch (Exception e) {
            log.error("ModelDataProvider queryOlap error:" + response);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)});
        }
    }

    private void transSet2List(Map<String, Object> paraMap) {
        String key = null;
        Object value = null;
        ArrayList<String> list = null;
        for (Map.Entry<String, Object> map : paraMap.entrySet()) {
            key = map.getKey();
            value = map.getValue();
            if (!(value instanceof Set)) continue;
            list = new ArrayList<String>(((Set)value).size());
            for (String innerStr : (Set)value) {
                list.add(innerStr);
            }
            paraMap.put(key, list);
        }
    }

    private void setGroupPara(Map<String, Object> paraMap, Set<String> hasSet) {
        List<MappedGroup> combineMappedGroup = this._ctx.getCombineMappedGroup();
        Iterator<MappedRow> iterator = null;
        String number = null;
        int scope = 0;
        String key = null;
        MappedSourceItem value = null;
        Set<Object> paraValue = null;
        for (MappedGroup mappedGroup : combineMappedGroup) {
            for (MappedRow next : mappedGroup) {
                Map<String, MappedSourceItem> sourceMapped = next.getSrcMapped();
                for (Map.Entry<String, MappedSourceItem> map : sourceMapped.entrySet()) {
                    key = map.getKey();
                    if (hasSet.contains(this.mapkey.get(key))) continue;
                    value = map.getValue();
                    number = value.getNumber();
                    scope = value.getScope();
                    if (scope == 1) {
                        if (ALL.equals(number)) {
                            paraValue = new HashSet();
                            paraValue.add(ALL);
                            this.getMargeParaValue(paraMap, paraValue, key);
                            continue;
                        }
                        paraValue = new HashSet();
                        paraValue.add(number);
                        this.getMargeParaValue(paraMap, paraValue, key);
                        continue;
                    }
                    if (scope == 4) {
                        paraValue = this.getNgDimMemberBySourceItems(value.getScopeSourceItems());
                        this.getMargeParaValue(paraMap, paraValue, key);
                        continue;
                    }
                    if (scope != 2 && scope != 3) continue;
                    paraValue = new HashSet();
                    paraValue.add(ALL);
                    this.getMargeParaValue(paraMap, paraValue, key);
                }
            }
        }
    }

    private Set<String> getNgDimMemberBySourceItems(SortedSet<MappedSourceItem> sortedSet) {
        HashSet<String> paraValue = new HashSet<String>(16);
        for (MappedSourceItem mappedSourceItem : sortedSet) {
            paraValue.add(mappedSourceItem.getNumber());
        }
        return paraValue;
    }

    private void getMargeParaValue(Map<String, Object> paraMap, Set<String> paraValue, String key) {
        Set preParaValue = (Set)paraMap.get(key);
        if (preParaValue == null) {
            paraMap.put(key, paraValue);
        } else {
            preParaValue.addAll(paraValue);
            paraMap.put(key, preParaValue);
        }
    }

    private void setBGSrcPrePara(Map<String, Object> paraMap, String org, String fy, String period, String currency) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme");
        long issrcmodelId = scheme.getDynamicObject("issrcmodel").getLong("id");
        DynamicObject ngmodel = BusinessDataServiceHelper.loadSingle((Object)issrcmodelId, (String)"bcm_isngmodel");
        String userType = ngmodel.getString("userType");
        String dataSource = ngmodel.getString("datasource");
        if ("1".equals(userType) && RequestContext.get().getAccountId().equals(dataSource)) {
            long modelsourceId = ngmodel.getDynamicObject("modelsource").getLong("id");
            DynamicObject dataSet = BusinessDataServiceHelper.loadSingle((Object)modelsourceId, (String)"eb_dataset");
            String dataSetNumber = dataSet.getString("number");
            long epmModelId = dataSet.getDynamicObject("model").getLong("id");
            DynamicObject epmModel = BusinessDataServiceHelper.loadSingle((Object)epmModelId, (String)"epm_model");
            paraMap.put("model", epmModel.getString("shownumber"));
            paraMap.put("dataSetNumber", dataSetNumber);
        } else {
            paraMap.put("model", ngmodel.getString("modelsourcenum"));
            paraMap.put("dataSetNumber", ngmodel.getString("number"));
        }
        paraMap.put("power", true);
        paraMap.put("SpecificSymbol", true);
        paraMap.put("checkMember", true);
        HashSet<String> orgSet = new HashSet<String>();
        orgSet.add(org);
        paraMap.put("Entity", orgSet);
        String budgetPeriod = this.getBudgetPeriod(fy, period);
        HashSet<String> budgetPeriodSet = new HashSet<String>();
        budgetPeriodSet.add(budgetPeriod);
        paraMap.put("BudgetPeriod", budgetPeriodSet);
        paraMap.put("Currency", currency);
    }

    private void setOtherPara(Map<String, Object> paraMap, Set<String> hasSet) {
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> singleMappedRelationPair = this._ctx.getMappedRelation().getSingleMappedRelationPair();
        Map singleMap = (Map)this._ctx.getCustomParam("singleMap");
        List singleDimRelaItemList = null;
        String targetNumber = null;
        String srcNumber = null;
        long dimMappedId = 0L;
        HashSet<String> paraValueSet = null;
        String srcMembNumber = null;
        String scope = null;
        for (DimMappedRelation.SingleDimRelationPair singleDimRela : singleMappedRelationPair.values()) {
            if (singleDimRela.getMappedType() != 1 || hasSet.contains(targetNumber = singleDimRela.getTargetDimItem().getDimItem().getNumber()) || !singleMap.containsKey(dimMappedId = singleDimRela.getDimMappedId())) continue;
            singleDimRelaItemList = (List)singleMap.get(dimMappedId);
            paraValueSet = new HashSet<String>();
            for (DynamicObject dynamicObject : singleDimRelaItemList) {
                srcMembNumber = dynamicObject.getString("srcmembnumber");
                scope = dynamicObject.getString("scope");
                if (MapScopeEnum.EQUALS.getIndex().equals(scope)) {
                    if (ALL.equals(srcMembNumber)) {
                        paraValueSet.add(ALL);
                        continue;
                    }
                    paraValueSet.add(srcMembNumber);
                    continue;
                }
                if (MapScopeEnum.LIKE.getIndex().equals(scope)) {
                    paraValueSet.add(ALL);
                    continue;
                }
                if (MapScopeEnum.RANGE.getIndex().equals(scope)) {
                    paraValueSet.add(ALL);
                    continue;
                }
                if (!MapScopeEnum.INCLUDE.getIndex().equals(scope)) continue;
                this.setParaValueSetByIn(paraValueSet, dynamicObject);
            }
            srcNumber = singleDimRela.getSourceDimItem().getDimItem().getNumber();
            this.getMargeParaValue(paraMap, paraValueSet, srcNumber);
        }
    }

    private void setParaValueSetByIn(Set<String> paraValueSet, DynamicObject dynamicObject) {
        DynamicObjectCollection issinglemapentry = dynamicObject.getDynamicObjectCollection("issinglemapentry");
        for (DynamicObject singleItem : issinglemapentry) {
            paraValueSet.add(singleItem.getString("srcmemnumber"));
        }
    }

    private static void getParaValueSetByNum(Set<String> paraValueSet, String modelNumber, String dimNumber, boolean onlyLeaf) {
        Collection allNodeByDimNum = MemberReader.getAllNodeByDimNum((String)dimNumber, (String)modelNumber);
        for (IDNumberTreeNode treeNode : allNodeByDimNum) {
            if (onlyLeaf) {
                if (!treeNode.isLeaf()) continue;
                paraValueSet.add(treeNode.getNumber());
                continue;
            }
            paraValueSet.add(treeNode.getNumber());
        }
    }

    private void setSrcDefaultPara(Map<String, Object> paraMap) {
        Map<Object, DimMappedRelation.DimAndDefValRela> sourceDefaultValsMap = this._ctx.getSourceDefaultValsMap();
        String number = null;
        List<MappedDefaultVal> defVals = null;
        HashSet<String> paraValue = null;
        for (Map.Entry<Object, DimMappedRelation.DimAndDefValRela> map : sourceDefaultValsMap.entrySet()) {
            number = map.getValue().getDimItem().getNumber();
            defVals = map.getValue().getDefVals();
            paraValue = new HashSet<String>(defVals.size());
            for (MappedDefaultVal mappedDefaultVal : defVals) {
                paraValue.add(mappedDefaultVal.getNumber());
            }
            paraMap.put(number, paraValue);
        }
    }

    private StdMdDataSet getRowSet(Map<String, Object> olapResult) {
        StdMdDataSet rowSet = new StdMdDataSet();
        List needDims = (List)olapResult.get(DIMENSION);
        List olapData = (List)olapResult.get(DATA);
        for (List list : olapData) {
            Object v = list.get(needDims.size());
            if (v == null || v instanceof String) continue;
            StdMdRow mdRow = new StdMdRow();
            for (int i = 0; i < needDims.size(); ++i) {
                mdRow.put((String)needDims.get(i), list.get(i));
            }
            mdRow.put("amount", v);
            rowSet.addRow(mdRow);
        }
        return rowSet;
    }

    private StdMdDataSet getRowSet4BG(List<Map<String, Object>> resList) {
        StdMdDataSet rowSet = new StdMdDataSet();
        for (Map<String, Object> map : resList) {
            if (map.get("amount") == null || map.get("amount") instanceof String) continue;
            StdMdRow mdRow = new StdMdRow();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().equals("amount")) {
                    mdRow.put(entry.getKey(), entry.getValue());
                    continue;
                }
                mdRow.put(entry.getKey(), ((Map)entry.getValue()).get("number") == null ? ((Map)entry.getValue()).get("numuber") : ((Map)entry.getValue()).get("number"));
            }
            rowSet.addRow(mdRow);
        }
        return rowSet;
    }

    private String getBudgetPeriod(String fy, String period) {
        if (fy != null && period != null) {
            String[] split = period.split("\\.");
            return fy.split("\\.")[0] + "." + (split.length > 1 ? split[1] : period);
        }
        return null;
    }

    private IDataSet<IRow> buildModelResultSet(String org, String fy, String period, String currency) {
        Map<String, Object> olapResult;
        Set<String> hasSet = this.getFixDim();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        this.setSrcPrePara(filter, org, fy, period, currency);
        this.setSrcDefaultPara(filter);
        this.setGroupPara(filter, hasSet);
        this.setOtherPara(filter, hasSet);
        if (filter.get("Account") == null) {
            filter.put("Account", "Account");
        }
        if (filter.get(DimTypesEnum.SCENARIO.getNumber()) == null || ((Set)filter.get(DimTypesEnum.SCENARIO.getNumber())).size() > 1) {
            this.setScenarioFilter(this._ctx, filter);
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme");
        Long isSrcModelId = scheme.getDynamicObject("issrcmodel").getLong("id");
        DynamicObject ngModel = BusinessDataServiceHelper.loadSingle((Object)isSrcModelId, (String)"bcm_isngmodel");
        String dataSource = ngModel.getString("datasource");
        this.resetFilter(filter);
        log.info(String.format("Filter of ModelDataProvider is %s", JSON.toJSON(filter)));
        String userType = ngModel.getString("userType");
        if ("1".equals(userType) && RequestContext.get().getAccountId().equals(dataSource)) {
            Long srcModelId = ngModel.getDynamicObject("modelsource").getLong("id");
            DynamicObject srcModel = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcModelId)});
            log.info(String.format("SrcModel of ModelDataProvider is %s", srcModelId + "  " + srcModel.getString("number")));
            List<String> allSrcDims = DimensionServiceHelper.getDimensionNumListByModel(srcModelId);
            olapResult = ModelDataProvider.queryOlap(srcModel.getString("number"), allSrcDims, filter, "");
        } else {
            olapResult = this.getOtherSourceOlapData(ngModel, filter);
        }
        StdMdDataSet dataSet = this.getRowSet(olapResult);
        log.info(String.format("dataSet size of ModelDataProvider is %d", dataSet.getSize()));
        return dataSet;
    }

    private void setScenarioFilter(IIntegrateContext ctx, Map<String, Object> filter) {
        Pair scene = (Pair)ctx.getCustomParam("scene");
        HashSet result = new HashSet();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", ctx.getSchema().p1);
        qfb.add("targmembnumber", "=", scene.p2);
        DynamicObject[] singMaps = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"srcmembnumber", (QFilter[])qfb.toArray());
        Arrays.stream(singMaps).forEach(item -> result.add(item.getString("srcmembnumber")));
        filter.put(DimTypesEnum.SCENARIO.getNumber(), result);
    }

    private Map<String, Object> getOtherSourceOlapData(DynamicObject ngModel, Map<String, Object> filter) {
        String phoneNumber = ngModel.getString("phonenumber");
        String passWord = ngModel.getString("password");
        KAESEncrypter ken = new KAESEncrypter();
        String pw = ken.decode(passWord);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("modelShowNumber", ngModel.getString("number"));
        params.put("modelName", ngModel.getString("name"));
        params.put("filter", filter);
        try {
            Long tdpdatacenterId = null;
            Object tdpdatacenterObj = ngModel.get("tdpdatacenterid");
            if (tdpdatacenterObj instanceof DynamicObject) {
                tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
            } else if (tdpdatacenterObj instanceof Long) {
                tdpdatacenterId = (Long)tdpdatacenterObj;
            }
            DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
            String userUrl = tdpdatacenter.getString("address");
            String loginToken = DimMappingHelper.getLoginTokenWithPass(phoneNumber, pw, tdpdatacenter);
            HashMap<String, String> requestHeader = new HashMap<String, String>(2);
            requestHeader.put("accessToken", loginToken);
            String fullUrl = userUrl + "/kapi/app/cm/olapData";
            String paramStr = JSON.toJSONString(params);
            log.info("ModelDataProvider queryOlap fullUrl:" + fullUrl + ", begin:");
            Long startTime = System.currentTimeMillis();
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)30000, (int)600000);
            IntegrationUtil.addTimeUse(this._ctx, startTime, fullUrl + " queryOlap");
            ApiResult res = (ApiResult)JSON.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                throw new Exception(res.getMessage());
            }
            log.info("ModelDataProvider olap fullUrl:" + fullUrl + ", begin:");
            return (Map)((Map)res.getData()).get("dataList");
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)});
        }
    }

    private void resetFilter(Map<String, Object> filter) {
        filter.entrySet().removeIf(entry -> ObjectUtils.isEmpty(entry.getValue()));
    }

    private Set<String> getFixDim() {
        HashSet<String> fixDims = new HashSet<String>();
        fixDims.add(DimEntityNumEnum.ENTITY.getNumber());
        fixDims.add(DimEntityNumEnum.YEAR.getNumber());
        fixDims.add(DimEntityNumEnum.PERIOD.getNumber());
        fixDims.add(DimEntityNumEnum.CURRENCY.getNumber());
        return fixDims;
    }

    private void setSrcPrePara(Map<String, Object> paraMap, final String org, final String fy, final String period, final String currency) {
        paraMap.put(PresetConstant.ENTITY_DIM, new HashSet<String>(){
            {
                this.add(org);
            }
        });
        paraMap.put(PresetConstant.FY_DIM, new HashSet<String>(){
            {
                this.add(fy);
            }
        });
        paraMap.put(PresetConstant.PERIOD_DIM, new HashSet<String>(){
            {
                this.add(period);
            }
        });
        paraMap.put(PresetConstant.CURRENCY_DIM, new HashSet<String>(){
            {
                this.add(currency);
            }
        });
    }

    public static Map<String, Object> queryOlap(String modelNum, List<String> allDims, Map<String, Object> filter, String isWithName) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        Object needAllDims = filter.get("needAllDims");
        if (needAllDims != null && "needAllDims".equals(needAllDims)) {
            filter.remove("needAllDims");
        } else {
            allDims.removeAll(notNeedReturnDims);
        }
        sql.addSelectField(allDims.toArray(new String[0]));
        filter.forEach((k, v) -> {
            HashSet<String> set = new HashSet<String>();
            if (v instanceof String) {
                if (ALL.equals(v)) {
                    ModelDataProvider.getParaValueSetByNum(set, modelNum, k, true);
                }
                set.add((String)v);
            } else if (v instanceof Collection) {
                if (((Collection)v).contains(ALL)) {
                    ModelDataProvider.getParaValueSetByNum(set, modelNum, k, true);
                }
                set.addAll((Collection)v);
            }
            set.remove(ALL);
            if (set.size() > 0) {
                sql.addFilter((String)k, set.toArray(new String[0]));
            }
        });
        MDResultSet resultSet = OlapServiceHelper.queryData(sql);
        HashMultimap dim2MembMap = HashMultimap.create();
        ArrayList rowList = new ArrayList(resultSet.getFetchSize());
        MultiKeyMap map = new MultiKeyMap();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>(allDims.size() + 4);
            if (Objects.equals("1", isWithName)) {
                for (String d : allDims) {
                    dim2MembMap.put((Object)d, (Object)resultSet.getString(d));
                }
                map = DatasetServiceHelper.getmenberNameMap((HashMultimap<String, String>)dim2MembMap, modelNum);
                for (String d : allDims) {
                    row.add(resultSet.getString(d) + ";" + map.get((Object)d, (Object)resultSet.getString(d)));
                }
            } else {
                for (String d : allDims) {
                    row.add(resultSet.getString(d));
                }
            }
            row.add(resultSet.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            rowList.add(row);
        }
        if (rowList.size() == 0) {
            log.info("The source has no qualified data.");
        }
        HashMap<String, Object> olapResult = new HashMap<String, Object>(3);
        olapResult.put(DIMENSION, allDims);
        olapResult.put(DATA, rowList);
        return olapResult;
    }
}

