/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.standard2my;

import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class StandardMultiDataProvider
extends AbstractDataProvider {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(StandardMultiDataProvider.class);
    private String entity_number = this._ctx.getCustomParam("middlelib") != null ? (String)this._ctx.getCustomParam("middlelib") : this.multidata_entity_number;
    private SingleMapModel singleMapModel;
    private DimensionMsgCache dim;
    private String multidata_entity_number = "bcm_dsmddata";
    private static final String ALL = "*";
    private boolean multiCurrency = false;

    public StandardMultiDataProvider(IIntegrateContext ctx) {
        super(ctx);
        log.info("dataprovider--middlelib:" + this.entity_number);
        this.dim = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.singleMapModel = new SingleMapModel(this._ctx);
    }

    private void initMultiCurrency() {
        Long schemeId = (Long)this._ctx.getSchema().p1;
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"multicurrency", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
        this.multiCurrency = "true".equals(scheme.getString("multicurrency"));
        if (this.multiCurrency && !ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, "CM031")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u5f00\u542f\u7cfb\u7edf\u53c2\u6570\u201cCM031|\u662f\u5426\u542f\u7528\u539f\u5e01\u201d\uff0c\u65e0\u6cd5\u96c6\u6210\u539f\u5e01\u6570\u636e\u3002", (String)"GLBalanceIntegrateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this._ctx.putCustomParam("openMultiCurrency", this.multiCurrency);
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        this.initMultiCurrency();
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        Pair<Long, String> orgPair = this.singleMapModel.getSrc(DimTypesEnum.ENTITY.getNumber(), (String)this._ctx.getOrg().p2);
        Pair<Long, String> curPair = this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2);
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        orgPair = this.validateAndSetPair(DimTypesEnum.ENTITY, orgPair, (String)this._ctx.getOrg().p2);
        curPair = this.validateAndSetPair(DimTypesEnum.CURRENCY, curPair, (String)this._ctx.getCurrency().p2);
        fyPair = this.validateAndSetPair(DimTypesEnum.YEAR, fyPair, (String)this._ctx.getFy().p2);
        periodPair = this.validateAndSetPair(DimTypesEnum.PERIOD, periodPair, (String)this._ctx.getPeriod().p2);
        String org = (String)orgPair.p2;
        String currency = (String)curPair.p2;
        String fy = (String)fyPair.p2;
        String period = (String)periodPair.p2;
        QFBuilder qf = this.getQfBuilder(org, fy, period, currency);
        return this.buildResultSet(qf);
    }

    private Pair<Long, String> validateAndSetPair(DimTypesEnum dim, Pair<Long, String> pair, String member) {
        if (pair == null) {
            Pair<Long, String> pair2 = pair = this.singleMapModel.getSrc(dim.getNumber(), ALL) != null ? Pair.onePair((Object)0L, (Object)member) : null;
            if (pair == null && DimTypesEnum.CURRENCY == dim) {
                Pair<Long, String> pair3 = pair = this.singleMapModel.getSrc(dim.getNumber(), "EC") != null ? Pair.onePair((Object)0L, (Object)member) : null;
            }
            if (pair == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684%1$s[%2$s]\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"StandardMultiDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), member));
            }
        }
        return pair;
    }

    protected String getSelector() {
        if (this.entity_number.equals(this.multidata_entity_number)) {
            return "id,amount,entity,fy,period,scenario,multigaap,currency,account,changetype,audittrail,process,datasort,internalcompany,mycompany,dim1,dim2,dim3,dim4,dim5,dim6,text";
        }
        StringBuilder selector = new StringBuilder();
        EntityMetadataCache.getDataEntityType((String)this.entity_number).getAllFields().forEach((k, v) -> selector.append((String)k).append(","));
        return "id," + selector.substring(0, selector.length() - 1);
    }

    protected String getEntityNumber() {
        return this.entity_number;
    }

    protected QFBuilder getQfBuilder(String org, String fy, String period, String currency) {
        QFBuilder qf = new QFBuilder();
        if ("bcm_dslgmddata".equals(this.entity_number)) {
            qf.add("companycode", "=", (Object)org);
            qf.add("year", "=", (Object)fy);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme");
            String location = scheme.getString("location");
            if (StringUtils.isEmpty((String)location)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848location\u4e3a\u7a7a\u3002", (String)"StandardMultiDataProvider_9", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            qf.add("location", "like", (Object)("%" + location + "%"));
            qf.add("currency", "=", (Object)currency);
        } else {
            qf.add("entity", "=", (Object)org);
            qf.add("fy", "=", (Object)fy);
            if (this._ctx.getCustomParam("batchname") != null) {
                qf.add("batchname", "in", this._ctx.getCustomParam("batchname"));
            }
            if (this.multiCurrency) {
                qf.add("currency", "in", (Object)new String[]{currency, "OC"});
            } else {
                qf.add("currency", "=", (Object)currency);
            }
        }
        qf.add("period", "=", (Object)period);
        qf.add("ssid", "=", this._ctx.getCustomParam("ssid"));
        log.info("dataprovider:" + qf.toString());
        return qf;
    }

    protected String getOrderBy(String entityNumber) {
        return null;
    }

    protected StdMdDataSet buildResultSet(QFBuilder qf) {
        StdMdDataSet rowSet = new StdMdDataSet();
        this._ctx.putCustomParam("noTemplate", true);
        String orderBy = this.getOrderBy(this.getEntityNumber());
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)StandardMultiDataProvider.class.getName(), (String)this.getEntityNumber(), (String)this.getSelector(), (QFilter[])qf.toArray(), (String)orderBy);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                StdMdRow mdRow = new StdMdRow();
                DataTraceFromItem trace = new DataTraceFromItem();
                StringBuilder sb = new StringBuilder();
                String amount = null;
                String text = null;
                for (Field field : dataset.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    if (v != null && StringUtils.isNotEmpty((String)v.toString())) {
                        mdRow.put(field.getName(), v);
                        if (!("id".equals(field.getName()) || "amount".equals(field.getName()) || "text".equals(field.getName()))) {
                            sb.append(v).append(",");
                        }
                        if ("amount".equals(field.getName())) {
                            amount = v.toString();
                        }
                        if (!"text".equals(field.getName())) continue;
                        text = v.toString();
                        continue;
                    }
                    sb.append("null").append(",");
                }
                trace.setV(ObjectSerialUtil.toByteSerialized((Object)Pair.onePair(amount, text)));
                trace.setD(sb.substring(0, sb.length() - 1));
                boolean isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
                if (isOpenTrace) {
                    mdRow.setTraceFromItem(trace);
                }
                rowSet.addRow(mdRow);
            }
        }
        return rowSet;
    }
}

