/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.provider.standard2my;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.enums.ExFilterEnum;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.provider.AbstractDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class XExtendDataProvider
extends AbstractDataProvider {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(XExtendDataProvider.class);
    private String table_number;

    public XExtendDataProvider(IIntegrateContext ctx) {
        super(ctx);
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme", (String)"extendstable");
        this.table_number = schemeDy.getString("extendstable");
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        List inputs = (List)this._ctx.getCustomParam("inputs4Serviceflow");
        String sql = this.getSql((String)inputs.get(0), (String)inputs.get(1), (String)inputs.get(2), (String)inputs.get(3));
        log.info(String.format("XExtendDataProvider-[%s] sql:%s", this._ctx.getSchema().p2, sql));
        return this.buildResultSet(sql);
    }

    private String getSql(String org, String fy, String period, String currency) {
        Map<String, String> singleDimMap = this.setSingleDimMap();
        Set<String> attrSet = this.getAttrSet();
        Map baseentlist = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter("scheme", "=", this._ctx.getSchema().p1).toArray());
        StringBuilder selector = new StringBuilder();
        selector.append(this.turnTheAttr(attrSet, "fid")).append(", ");
        baseentlist.values().forEach(entry -> selector.append(this.turnTheAttr(attrSet, entry.getString("number"))).append(","));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(selector.substring(0, selector.length() - 1)).append(" FROM ").append(this.table_number);
        sql.append(" WHERE ").append(this.turnTheAttr(attrSet, singleDimMap.get("Entity"))).append(" = '").append(org).append("'");
        sql.append(" AND ").append(this.turnTheAttr(attrSet, singleDimMap.get("Year"))).append(" = '").append(fy).append("'");
        sql.append(" AND ").append(this.turnTheAttr(attrSet, singleDimMap.get("Period"))).append(" = '").append(period).append("'");
        sql.append(" AND ").append(this.turnTheAttr(attrSet, singleDimMap.get("Currency"))).append(" = '").append(currency).append("'");
        this.addExAttrFilter(sql, (Map)this._ctx.getCustomParam("exAttrMap"), attrSet);
        sql.append(";");
        return sql.toString();
    }

    private String turnTheAttr(Set<String> attrSet, String attr) {
        if (attrSet.contains(attr.toLowerCase())) {
            return attr;
        }
        return "f" + attr;
    }

    private Set<String> getAttrSet() {
        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)this.table_number);
        HashSet<String> attrSet = new HashSet<String>();
        columnNames.forEach(e -> attrSet.add(e.toLowerCase()));
        return attrSet;
    }

    private Map<String, String> setSingleDimMap() {
        DynamicObject[] load;
        HashMap<String, String> singleDimMap = new HashMap<String, String>(16);
        QFilter schemeQf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        QFilter mappedtypeQf = new QFilter("mappedtype", "=", (Object)"1");
        for (DynamicObject obj : load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_isdimmap").getAllFields().keySet()), (QFilter[])new QFilter[]{schemeQf, mappedtypeQf})) {
            singleDimMap.put(((DynamicObject)obj.getDynamicObjectCollection("isdimmaptargentry").get(0)).getDynamicObject("tagdimension").getString("number"), ((DynamicObject)obj.getDynamicObjectCollection("isdimmapsrcentry").get(0)).getDynamicObject("srcdimension").getString("number"));
        }
        this._ctx.putCustomParam("singleDimMap", singleDimMap);
        return singleDimMap;
    }

    private void addExAttrFilter(StringBuilder sql, Map<Long, Map<String, Object>> customParam, Set<String> attrSet) {
        if (customParam == null) {
            return;
        }
        for (Map<String, Object> map : customParam.values()) {
            String datafiltercondition = (String)map.get("datafiltercondition");
            String filtervalue = (String)map.get("filtervalue");
            String filternumber = (String)map.get("filternumber");
            filternumber = filternumber == null ? "" : filternumber.toLowerCase();
            filternumber = this.turnTheAttr(attrSet, filternumber);
            if (ExFilterEnum.CONTAIN.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" like '%").append(filtervalue).append("%'");
                continue;
            }
            if (ExFilterEnum.NOT_CONTAIN.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" not like '%").append(filtervalue).append("%'");
                continue;
            }
            if (ExFilterEnum.EQUAL.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" = '").append(filtervalue).append("'");
                continue;
            }
            if (ExFilterEnum.NOT_EQUAL.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" <> '").append(filtervalue).append("'");
                continue;
            }
            if (ExFilterEnum.STARTWITH.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" like '").append(filtervalue).append("%'");
                continue;
            }
            if (ExFilterEnum.ENDWITH.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" like '%").append(filtervalue).append("'");
                continue;
            }
            if (ExFilterEnum.NULL.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" is null");
                continue;
            }
            if (ExFilterEnum.NOT_NULL.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" is not null");
                continue;
            }
            if (ExFilterEnum.GREATER_THAN.getCode().equals(datafiltercondition)) {
                sql.append(" AND ").append(filternumber).append(" > ").append(filtervalue);
                continue;
            }
            if (!ExFilterEnum.LESS_THAN.getCode().equals(datafiltercondition)) continue;
            sql.append(" AND ").append(filternumber).append(" < ").append(filtervalue);
        }
    }

    private StdMdDataSet buildResultSet(String sql) {
        Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
        StdMdDataSet rowSet = new StdMdDataSet();
        try (DataSet dataSet = DB.queryDataSet((String)this.table_number, (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                StdMdRow mdRow = new StdMdRow();
                for (Field field : dataSet.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    if (v == null || !StringUtils.isNotEmpty((String)v.toString())) continue;
                    mdRow.put(singleDimMap.values().contains(field.getName()) ? field.getName() : field.getName().substring(1), v);
                }
                rowSet.addRow(mdRow);
            }
        }
        log.info(String.format("XExtendDataProvider-[%s] loadData size:%s", this._ctx.getSchema().p2, rowSet.getSize()));
        return rowSet;
    }
}

