/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.EasOutPut;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;

public abstract class AbstractBcmToEasIntegrateService
extends AbstractIntegrateService {
    public AbstractBcmToEasIntegrateService(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        return this._ctx.getCombineMappedGroup();
    }

    @Override
    protected IOutput getOutput() {
        return new EasOutPut(this._ctx, this.isFloat());
    }

    protected abstract boolean isFloat();

    @Override
    public void match(IRow resultRow, MappedRow mappedRow) {
        AtomicBoolean ismatch = new AtomicBoolean(true);
        mappedRow.srcMappediterator().forEachRemaining(s -> {
            String val;
            MappedSourceItem value = (MappedSourceItem)s.getValue();
            if (ismatch.get() && !value.isFloatDim() && !value.isFloatTxt() && !StringUtils.isEmpty((String)(val = (String)resultRow.get(value.getMappedDim().getNumber())))) {
                IFilter<String> filter = FilterFactory.getFilter(value, this._ctx);
                ismatch.set(filter.isMatched(value, val, this._ctx));
            }
        });
        if (ismatch.get()) {
            Map<MappedRow, ValueList> result = this._ctx.getResult();
            ValueList valueList = result.get(mappedRow);
            if (valueList == null) {
                valueList = new ValueList();
                result.put(mappedRow, valueList);
            }
            ValueItem valueItem = new ValueItem();
            valueList.addValue(valueItem);
            Object value = resultRow.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (value instanceof Number) {
                BigDecimal temp2 = new BigDecimal(value.toString());
                if (mappedRow.isNegate()) {
                    valueItem.setValue(temp2.multiply(new BigDecimal(-1)));
                } else {
                    valueItem.setValue(temp2);
                }
            } else {
                valueItem.setValue(value);
            }
            mappedRow.getSrcMapped().values().forEach(s -> {
                if (s.isFloatTxt()) {
                    valueItem.setProperty("text", resultRow.get(s.getMappedDim().getNumber()));
                    valueItem.setProperty("textDim", s.getMappedDim().getNumber());
                    this._ctx.getMemsCache().setFilter(s.getMappedDim().getNumber(), "number", resultRow.get(s.getMappedDim().getNumber()));
                }
                if (s.isFloatDim()) {
                    valueItem.setProperty("float", resultRow.get(s.getMappedDim().getNumber()));
                    valueItem.setProperty("floatDim", s.getMappedDim().getNumber());
                    this._ctx.getMemsCache().setFilter(s.getMappedDim().getNumber(), "number", resultRow.get(s.getMappedDim().getNumber()));
                }
            });
        }
    }
}

