/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.MappedModelBuilder;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.MiddleLibOutPut;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.service.AbstractFlowIntergrateService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class AbstractEasGLBalanceIntegrateService
extends AbstractFlowIntergrateService {
    private Map<Long, List<DynamicObject>> singleMap;
    private List<String> dimNumber = new ArrayList<String>(10);
    private Set<String> preNumber = new HashSet<String>(10);
    private static final String MATCHED = "matched";
    private static final String IGNORE = "IGNORE";
    private List<String> allSourceKey = new ArrayList<String>();
    private Multimap<String, MappedRow> accountHighPriority = ArrayListMultimap.create();
    private List<MappedRow> notHighPriorityMappedRows = new ArrayList<MappedRow>();
    private static final String selectField = "dseq,dimmapid,scope,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.seq,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber";
    private DynamicObjectCollection userdefinedDims;

    public AbstractEasGLBalanceIntegrateService(IIntegrateContext ctx) {
        super(ctx);
        this.initPreNumber();
        this.initSingleMap();
        this.userdefinedDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,fieldmapped,membermodel,number,dseq", (QFilter[])new QFBuilder().add("model", "=", this._ctx.getModel().p1).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        this.initDimNumber();
        this.initAllSourceKey();
    }

    private void initPreNumber() {
        this.preNumber.add(DimEntityNumEnum.ENTITY.getNumber());
        this.preNumber.add(DimEntityNumEnum.YEAR.getNumber());
        this.preNumber.add(DimEntityNumEnum.PERIOD.getNumber());
        this.preNumber.add(DimEntityNumEnum.CURRENCY.getNumber());
    }

    private void initDimNumber() {
        if (this.dimNumber.isEmpty()) {
            this.dimNumber = this.userdefinedDims.stream().map(d -> d.getString("number")).collect(Collectors.toList());
            this.dimNumber.add(DimEntityNumEnum.INTERCOMPANY.getNumber());
            this.dimNumber.add(DimEntityNumEnum.CHANGETYPE.getNumber());
            this.dimNumber.add(DimEntityNumEnum.ACCOUNT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.PROCESS.getNumber());
            this.dimNumber.add(DimEntityNumEnum.AUDITTRIAL.getNumber());
            this.dimNumber.add(DimEntityNumEnum.DATASORT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.SCENARIO.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MULTIGAAP.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MYCOMPANY.getNumber());
        }
    }

    private void initAllSourceKey() {
        Map<Long, MappedDimItem> sourceDimMap = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap();
        HashSet<String> hasNumber = new HashSet<String>(16);
        for (Map.Entry<Long, MappedDimItem> map : sourceDimMap.entrySet()) {
            hasNumber.add(map.getValue().getNumber());
        }
        Collection values = this._ctx.getMappedRelation().getSingleMappedRelationPair().values();
        QFilter schemeQf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            String srcNumber = singleDimRelationPair.getSourceDimItem().getDimItem().getNumber();
            if (singleDimRelationPair.getMappedType() != 1 || hasNumber.contains(srcNumber) || this.preNumber.contains(srcNumber)) continue;
            QFilter numberQf = new QFilter("number", "=", (Object)srcNumber);
            Map baseMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{schemeQf, numberQf});
            for (Map.Entry map : baseMap.entrySet()) {
                Long baseId = (Long)map.getKey();
                DynamicObject baseDy = (DynamicObject)map.getValue();
                MappedDimItem mdi = new MappedDimItem(baseId, srcNumber, srcNumber, baseDy.getString("entitynumber"));
                sourceDimMap.put(baseId, mdi);
            }
        }
        for (Map.Entry entry : sourceDimMap.entrySet()) {
            this.allSourceKey.add(((MappedDimItem)entry.getValue()).getMappedKey());
        }
    }

    private void initSingleMap() {
        if (this.singleMap == null) {
            MappedModelBuilder builder = new MappedModelBuilder(this._ctx);
            this.singleMap = builder.buildSingleMap();
        }
        this._ctx.putCustomParam("singleMap", this.singleMap);
    }

    @Override
    public void execute() {
        log.startWatch();
        StringBuilder spendTimeMessage = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        this.callServiceflow(sw, spendTimeMessage);
        this.beforeExecute();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", (String)"MiddleLibIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"MiddleLibIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        IDataSet ds = (IDataSet)this._provider.loadData();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%1$s]\u67e5\u8be2\u6570\u636e\u8017\u65f6,\u6e90\u6570\u636e\u6761\u6570\u4e3a%2$s", (String)"MiddleLibIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2, ((StdMdDataSet)ds).getSize()));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"MiddleLibIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        ds.forEach(row -> {
            this._ctx.putCustomParam(MATCHED, false);
            this._ctx.putCustomParam("priority", null);
            Collection accountHigh = this.accountHighPriority.get(row.get("Account"));
            if (accountHigh != null && accountHigh.size() > 0) {
                for (MappedRow maprow : accountHigh) {
                    this.match((IRow)row, maprow);
                }
            }
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                for (MappedRow mrow : this.notHighPriorityMappedRows) {
                    this.match((IRow)row, mrow);
                    if (this._ctx.getCustomParam("break") == null) continue;
                    this._ctx.putCustomParam("break", null);
                    break;
                }
            }
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                this.countNotMatchNum();
            }
        });
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", (String)"MiddleLibIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"MiddleLibIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u6821\u9a8c\u68c0\u67e5\u8fc7\u7a0b\u8017\u65f6", (String)"MiddleLibIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this._output.output();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51faolap\u8017\u65f6", (String)"MiddleLibIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u6821\u9a8c\u68c0\u67e5\u8fc7\u7a0b\u53ca\u8f93\u51faolap\u8017\u65f6:", (String)"MiddleLibIntegrationService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.afterExecute();
        sw.stop();
        this._ctx.putCustomParam("spendTimeMessage", spendTimeMessage.toString());
    }

    private void countNotMatchNum() {
        this._ctx.putCustomParam("check_countNotMatchNum", this._ctx.getCustomParam("check_countNotMatchNum") == null ? 1 : (Integer)this._ctx.getCustomParam("check_countNotMatchNum") + 1);
    }

    @Override
    public void match(IRow r, MappedRow mappedRow) {
        Recorder value;
        ValueItem valueItem = new ValueItem();
        Recorder priority = new Recorder((Object)-2);
        if (!this.handleMappedRowSrc(mappedRow, r, valueItem, (Recorder<Integer>)priority, (Recorder<BigDecimal>)(value = new Recorder(null)))) {
            return;
        }
        int allSourceSize = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().size();
        if (allSourceSize > mappedRow.getSrcMapped().size()) {
            ArrayList<String> mappedRowKey = new ArrayList<String>(10);
            for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
                mappedRowKey.add(src.getMappedDim().getMappedKey());
            }
            Collection c = CollectionUtils.disjunction(this.allSourceKey, mappedRowKey);
            HashSet<String> goSingleTarDimNums = new HashSet<String>(c.size());
            HashMap<String, Object> tarNumberMapFromMappedRow = new HashMap<String, Object>(valueItem.getProperties());
            block1: for (Object key : c) {
                for (Map.Entry rowKey : this._ctx.getMappedRelation().getSingleMappedRelationPair().rowMap().entrySet()) {
                    if (!key.equals(((MappedDimItem)rowKey.getKey()).getMappedKey())) continue;
                    for (Map.Entry dim : ((Map)rowKey.getValue()).entrySet()) {
                        List<DynamicObject> issinglemap;
                        String tarDimNum = ((MappedDimItem)dim.getKey()).getNumber();
                        goSingleTarDimNums.add(tarDimNum);
                        if (tarNumberMapFromMappedRow.get(tarDimNum) != null) continue block1;
                        if (!this.dimNumber.contains(tarDimNum)) continue;
                        String srcDimNum = ((DimMappedRelation.SingleDimRelationPair)dim.getValue()).getSourceDimItem().getDimItem().getNumber();
                        String srcMember = (String)r.get(srcDimNum);
                        if (StringUtils.isEmpty((CharSequence)srcMember)) {
                            srcMember = "*";
                        }
                        if (null == (issinglemap = this.singleMap.get(((DimMappedRelation.SingleDimRelationPair)dim.getValue()).getDimMappedId()))) {
                            QFilter qf1 = new QFilter("schemeid", "=", this._ctx.getSchema().p1).and(new QFilter("dimmapid", "in", (Object)((DimMappedRelation.SingleDimRelationPair)dim.getValue()).getDimMappedId()));
                            DynamicObject[] temp = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)selectField, (QFilter[])new QFilter[]{qf1}, (String)"issinglemapentry.seq");
                            issinglemap = new ArrayList<DynamicObject>(temp.length);
                            Collections.addAll(issinglemap, temp);
                            this.singleMap.put(((DimMappedRelation.SingleDimRelationPair)dim.getValue()).getDimMappedId(), issinglemap);
                        }
                        this.matchSingleMemMap(srcMember, issinglemap, valueItem, tarDimNum);
                    }
                }
            }
            for (String tarDim : goSingleTarDimNums) {
                if (valueItem.getProperty(tarDim) != null) continue;
                return;
            }
        }
        this._ctx.putCustomParam(MATCHED, true);
        if (this._ctx.getCustomParam("priority") != null && ((Integer)priority.getRecord()).intValue() != ((Integer)this._ctx.getCustomParam("priority")).intValue()) {
            this._ctx.putCustomParam("break", true);
            return;
        }
        this._ctx.putCustomParam("priority", priority.getRecord());
        ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
        BigDecimal amount = (BigDecimal)value.getRecord();
        String text = (String)r.get("text");
        if (mappedRow.isNegate()) {
            valueItem.setValue(Pair.onePair((Object)amount.negate(), (Object)text));
        } else {
            valueItem.setValue(Pair.onePair((Object)amount, (Object)text));
        }
        boolean isIgnore = valueItem.getProperties().values().stream().anyMatch(s -> IGNORE.equalsIgnoreCase(s.toString()));
        boolean targetMemberExist = valueItem.getProperties().values().stream().anyMatch(s -> StringUtils.isEmpty((CharSequence)s.toString()));
        if (!isIgnore && !targetMemberExist) {
            vl.addValue(valueItem);
        }
    }

    private boolean handleMappedRowSrc(MappedRow mappedRow, IRow r, ValueItem valueItem, Recorder<Integer> priority, Recorder<BigDecimal> value) {
        for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
            String tarDimNum = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId()).getTargetDimItem().getDimItem().getNumber();
            String srcDimNum = src.getMappedDim().getNumber();
            if ("Account".equals(srcDimNum)) {
                priority.setRecord((Object)src.getPriority());
            }
            if ("AccessType".equals(srcDimNum)) {
                if (r.get(src.getNumber()) == null) {
                    return false;
                }
                value.setRecord(r.get(src.getNumber()));
                continue;
            }
            String v = (String)r.get(srcDimNum);
            if (StringUtils.isEmpty((CharSequence)v)) {
                v = "*";
            }
            if (!"*".equals(src.getNumber()) && !"*".equals(v) ? !FilterFactory.getFilter(src, this._ctx).isMatched(src, v, this._ctx) : !"*".equals(src.getNumber()) && "*".equals(v)) {
                return false;
            }
            MappedTargetItem mappedTargetItem = mappedRow.getTargMapped().get(tarDimNum);
            if (mappedTargetItem == null) continue;
            String targetMemNum = mappedTargetItem.getNumber();
            if ("*".equals(targetMemNum)) {
                if ("*".equals(v)) {
                    return false;
                }
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)tarDimNum, (String)v);
                valueItem.setProperty(tarDimNum, m == null ? "" : m.getNumber());
                continue;
            }
            valueItem.setProperty(tarDimNum, targetMemNum);
        }
        return true;
    }

    private void matchSingleMemMap(String srcMember, List<DynamicObject> issinglemap, ValueItem valueItem, String tarDimNum) {
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        for (DynamicObject isObject : issinglemap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            if (sourceItem == null) {
                throw new KDBizException("no issinglemapentry:" + tarDimNum + ":" + srcMember);
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = "*".equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null || ("*".equals(sourceItem.getNumber()) || "*".equals(srcMember) ? !"*".equals(sourceItem.getNumber()) && "*".equals(srcMember) : !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, srcMember, this._ctx))) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if ("*".equals(targetMemNum)) {
                if ("*".equals(srcMember)) continue;
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)tarDimNum, (String)srcMember);
                tempTargetMap.put(isPriority, m == null ? "" : m.getNumber());
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            Map.Entry tarEntry = tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get();
            if (valueItem.getProperty(tarDimNum) != null && ValueItemPriorityEnum.LOW.getValue() == ((Integer)tarEntry.getKey()).intValue()) {
                return;
            }
            String targetNumber = (String)tarEntry.getValue();
            valueItem.setProperty(tarDimNum, targetNumber);
        }
    }

    @Override
    protected void afterExecute() {
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainScope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        return new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, mainScope, false, false);
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return null;
    }

    @Override
    protected IOutput getOutput() {
        return new MiddleLibOutPut(this._ctx);
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        return this._ctx.getCombineMappedGroup();
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        List<MappedGroup> serviceMappedGroup = this.getServiceMappedGroup();
        ArrayList srcIsEmpty = new ArrayList();
        serviceMappedGroup.forEach(g -> g.forEach(row -> {
            boolean accountHigh = false;
            for (MappedSourceItem src : row.getSrcMapped().values()) {
                String upperKey = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId()).getTargetDimItem().getDimItem().getNumber();
                if (!DimEntityNumEnum.ACCOUNT.getNumber().equals(upperKey) || MapScopeEnum.EQUALS != MapScopeEnum.getEnumByindex((int)src.getScope()) || src.getPriority() != 999) continue;
                this.accountHighPriority.put((Object)src.getNumber(), row);
                accountHigh = true;
                break;
            }
            if (!accountHigh) {
                if (row.getSrcMapped().size() == 0) {
                    srcIsEmpty.add(row);
                } else {
                    this.notHighPriorityMappedRows.add((MappedRow)row);
                }
            }
        }));
        this.notHighPriorityMappedRows.addAll(srcIsEmpty);
    }
}

