/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.service.MiddleLibIntegrationService;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.lang3.time.StopWatch;

public abstract class AbstractFlowIntergrateService
extends AbstractIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, MiddleLibIntegrationService.class);
    protected DynamicObject serviceflow;
    protected SingleMapModel singleMapModel;
    protected DimensionMsgCache dim;
    protected static final String ALL = "*";

    public AbstractFlowIntergrateService(IIntegrateContext ctx) {
        super(ctx);
        this.singleMapModel = new SingleMapModel(this._ctx);
        this.dim = new DimensionMsgCache((Long)this._ctx.getModel().p1);
    }

    protected void callServiceflow(StopWatch sw, StringBuilder spendTimeMessage) {
        DynamicObject isScheme = BusinessDataServiceHelper.loadSingle((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme", (String)"serviceflow");
        this.serviceflow = isScheme.getDynamicObject("serviceflow");
        this.initProviderParams();
        if (this.serviceflow != null) {
            String serviceflowName = this.serviceflow.getString("name");
            if (!this.serviceflow.getBoolean("enable")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%s]\u672a\u542f\u7528", (String)"XExtendIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[]{serviceflowName}));
            }
            List inputs = (List)this._ctx.getCustomParam("inputs4Serviceflow");
            Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{this.serviceflow.getString("number"), inputs});
            if (result != null) {
                spendTimeMessage.append(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%s]\u8fd4\u56de\u7ed3\u679c\uff1a", (String)"XExtendIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[]{serviceflowName})).append(result).append(',');
                this.appendSpendTimeMessage(sw, spendTimeMessage, String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%s]\u5904\u7406\u8017\u65f6", (String)"XExtendIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]), serviceflowName));
            }
        }
    }

    protected void appendSpendTimeMessage(StopWatch sw, StringBuilder sb, String message) {
        sw.split();
        sb.append(message).append(sw.toSplitString()).append(';');
        sw.reset();
        sw.start();
    }

    protected Pair<Long, String> validateAndSetPair(DimTypesEnum dim, Pair<Long, String> pair, String member) {
        if (pair == null) {
            Pair<Long, String> pair2 = pair = this.singleMapModel.getSrc(dim.getNumber(), ALL) != null ? Pair.onePair((Object)0L, (Object)member) : null;
            if (pair == null && DimTypesEnum.CURRENCY == dim) {
                Pair<Long, String> pair3 = pair = this.singleMapModel.getSrc(dim.getNumber(), "EC") != null ? Pair.onePair((Object)0L, (Object)member) : null;
            }
            if (pair == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684%1$s[%2$s]\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"StandardMultiDataProvider_5", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), member));
            }
        }
        return pair;
    }

    protected void initProviderParams() {
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.ENTITY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.CURRENCY.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.YEAR.getNumber()));
        this.singleMapModel.buildTar(this.dim.getDimId(DimTypesEnum.PERIOD.getNumber()));
        Pair<Long, String> orgPair = this.singleMapModel.getSrc(DimTypesEnum.ENTITY.getNumber(), (String)this._ctx.getOrg().p2);
        Pair<Long, String> curPair = this.singleMapModel.getSrc(DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2);
        Pair<Long, String> fyPair = this.singleMapModel.getSrc(DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2);
        Pair<Long, String> periodPair = this.singleMapModel.getSrc(DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2);
        orgPair = this.validateAndSetPair(DimTypesEnum.ENTITY, orgPair, (String)this._ctx.getOrg().p2);
        curPair = this.validateAndSetPair(DimTypesEnum.CURRENCY, curPair, (String)this._ctx.getCurrency().p2);
        fyPair = this.validateAndSetPair(DimTypesEnum.YEAR, fyPair, (String)this._ctx.getFy().p2);
        periodPair = this.validateAndSetPair(DimTypesEnum.PERIOD, periodPair, (String)this._ctx.getPeriod().p2);
        ArrayList<Object> inputs4Serviceflow = new ArrayList<Object>(4);
        inputs4Serviceflow.add(orgPair.p2);
        inputs4Serviceflow.add(fyPair.p2);
        inputs4Serviceflow.add(periodPair.p2);
        inputs4Serviceflow.add(curPair.p2);
        this._ctx.putCustomParam("inputs4Serviceflow", inputs4Serviceflow);
        log.info(String.format("[%s]-[%s] inputs4Serviceflow :%s", this.getClass().getName(), this._ctx.getSchema().p2, inputs4Serviceflow));
    }
}

