/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.exception.InValidateParamIntegrateException;
import kd.fi.bcm.business.integrationnew.filter.IMatcher;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.service.IIntegrateService;
import kd.fi.bcm.business.integrationnew.service.IServiceMappedGroupSupplier;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;

public abstract class AbstractIntegrateService
implements IIntegrateService<IDataSet<IRow>>,
IMatcher,
IServiceMappedGroupSupplier {
    protected IDataProvider<IDataSet<IRow>> _provider;
    protected IOutput _output;
    protected IIntegrateContext _ctx;
    protected boolean isOpenTrace;
    protected boolean isDataTransUseDimMapOrder;

    public AbstractIntegrateService(IIntegrateContext ctx) {
        this._ctx = ctx;
        this._ctx.setServiceMappedGroupSupplier(this);
        this._provider = this.getDataProvider();
        this._output = this.getOutput();
        this.isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
        this.isDataTransUseDimMapOrder = ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, ConfigEnum.IS_DATATRANS_USEDIMMAPORDER.getNumber());
    }

    protected void beforeExecute() {
        this.check();
    }

    @Override
    public void execute() {
        this.beforeExecute();
        IDataSet<IRow> ds = this._provider.loadData();
        ds.forEach(row -> this.getServiceMappedGroup().forEach(g -> g.forEach(mrow -> this.match((IRow)row, (MappedRow)mrow))));
        this._output.output();
        this.afterExecute();
    }

    protected void afterExecute() {
    }

    public AbstractIntegrateService setDataProvider(IDataProvider<IDataSet<IRow>> provider) {
        this._provider = provider;
        return this;
    }

    public AbstractIntegrateService setOutput(IOutput output) {
        this._output = output;
        return this;
    }

    protected abstract IDataProvider<IDataSet<IRow>> getDataProvider();

    protected abstract IOutput getOutput();

    protected void check() {
        if (this._provider == null) {
            throw new InValidateParamIntegrateException("integrate provider is null");
        }
        if (this._output == null) {
            throw new InValidateParamIntegrateException("integrate output is null");
        }
    }
}

