/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.integrationnew.model.DataTraceInfo;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataFormulaVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang.SerializationUtils;

public class DataTrace2FromService {
    private static final int dataLength = 1000;
    private int save_size = 10000;
    private static final LinkedList<String> preDimensionList = new LinkedList();
    private static final LinkedList<String> userDimensionList = new LinkedList();
    private Map<String, DataTraceInfo> dataFromMap = new HashMap<String, DataTraceInfo>();
    private Long modelId = 0L;
    private final Long saveId;
    private Pair<Set<String>, Map<String, String>> pair;
    private static final Log log;

    public DataTrace2FromService(Long modelId, Long saveId) {
        this.modelId = modelId;
        this.saveId = saveId;
        this.pair = this.getDimensionPair(modelId);
        if (StringUtils.isNotEmpty((CharSequence)ConfigServiceHelper.getStringParam(modelId, "DataTraceSaveSize"))) {
            this.save_size = Integer.parseInt(ConfigServiceHelper.getStringParam(modelId, "DataTraceSaveSize"));
        }
    }

    public boolean saveCellDataTemp(Map<String, String> dimension, DataTraceFrom dataFrom, int type) {
        if (this.pair == null) {
            this.pair = this.getDimensionPair(this.modelId);
        }
        this.dealDataFormFormula(dimension, dataFrom);
        Pair<String, Pair<String, String>> searchKeyPair = this.getSearchKey(this.pair, dimension);
        DataTraceInfo dti = null;
        if (type == 1) {
            dti = this.getNewDataTraceInfo(searchKeyPair, dataFrom);
        } else if (type == 2) {
            dti = this.getMergeDataTraceInfo(searchKeyPair, dataFrom);
        }
        if (dti != null) {
            dti.setSaveId(this.saveId);
            this.dataFromMap.put((String)searchKeyPair.p1, dti);
        }
        if (this.getDataTraceMapSize() >= this.save_size) {
            this.saveCellDataPremanent();
        }
        return true;
    }

    private void dealDataFormFormula(Map<String, String> dimension, DataTraceFrom dataFrom) {
        if (dataFrom != null && dataFrom.getDf() != null) {
            dataFrom.getDf().forEach(df -> {
                String formula = df.getD();
                if (StringUtils.isNotEmpty((CharSequence)formula) && formula.toLowerCase().startsWith("v_data")) {
                    VDataFormulaVo formulaVo = VDataFormulaUtils.parseFormula(formula);
                    for (VDataRowVo columnVo : formulaVo.getColumnVos()) {
                        String dimNum;
                        MultiF7Result multiF7Result;
                        if (!(columnVo instanceof VDataDimNodeVo) || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList() == null || ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().size() != 1 || (multiF7Result = ((VDataDimNodeVo)columnVo).getMultiF7Results().getList().get(0)) == null || multiF7Result.getScope() != 10 || !"$Cur".equals(multiF7Result.getNumber()) || !dimension.containsKey(dimNum = columnVo.getDimNum())) continue;
                        multiF7Result.setNumber((String)dimension.get(dimNum));
                        columnVo.setCondition((String)dimension.get(dimNum));
                    }
                    df.setD(formulaVo.toExcelFormula());
                }
            });
        }
    }

    private DataTraceInfo getMergeDataTraceInfo(Pair<String, Pair<String, String>> searchKeyPair, DataTraceFrom dataFrom) {
        DataTraceInfo dti = this.dataFromMap.get(searchKeyPair.p1);
        if (StringUtils.isNotEmpty((CharSequence)dataFrom.getD())) {
            dataFrom.setD("[" + dataFrom.getD() + "]");
        }
        if (dti == null) {
            return this.getNewDataTraceInfo(searchKeyPair, dataFrom);
        }
        DataTraceFrom dtf = dti.getDtf();
        String mOld = dtf.getM();
        String mNew = dataFrom.getM();
        try {
            BigDecimal bigMOld = new BigDecimal(mOld);
            BigDecimal bigMNew = new BigDecimal(mNew);
            dtf.setM(bigMOld.add(bigMNew).toPlainString());
        }
        catch (NumberFormatException e) {
            dtf.setM(dtf.getM() + ComputeOprtEnum.PLUS.getSymbol() + dataFrom.getM());
        }
        String symbol = dataFrom.getSymbol();
        if (StringUtils.isEmpty((CharSequence)symbol)) {
            symbol = ComputeOprtEnum.PLUS.getSymbol();
        }
        if (StringUtils.isNotEmpty((CharSequence)dtf.getD()) && StringUtils.isNotEmpty((CharSequence)dataFrom.getD())) {
            dtf.setD(dtf.getD() + symbol + dataFrom.getD());
        }
        List<DataTraceFromItem> df = dtf.getDf();
        int maxSeq = this.getMaxSeq(df);
        for (DataTraceFromItem dataTraceFromItem : dataFrom.getDf()) {
            dataTraceFromItem.setS(dataTraceFromItem.getS() + maxSeq);
            df.add(dataTraceFromItem);
        }
        return dti;
    }

    private int getMaxSeq(List<DataTraceFromItem> df) {
        int maxSeq = 0;
        for (DataTraceFromItem dataTraceFromItem : df) {
            Integer curSeq = dataTraceFromItem.getS();
            if (curSeq <= maxSeq) continue;
            maxSeq = curSeq;
        }
        return maxSeq;
    }

    private DataTraceInfo getNewDataTraceInfo(Pair<String, Pair<String, String>> searchKeyPair, DataTraceFrom dataFrom) {
        DataTraceInfo dti = new DataTraceInfo();
        dti.setModelId(this.modelId);
        dti.setSearchKey((String)searchKeyPair.p1);
        dti.setYear((String)((Pair)searchKeyPair.p2).p1);
        dti.setPeriod((String)((Pair)searchKeyPair.p2).p2);
        dti.setUpdateDate(new Date());
        long userId = RequestContext.get().getCurrUserId();
        dti.setModifierId(userId);
        if (StringUtils.isNotEmpty((CharSequence)dataFrom.getD())) {
            String symbol = dataFrom.getSymbol();
            if (ComputeOprtEnum.SUBTRACT.getSymbol().equals(symbol)) {
                dataFrom.setD(symbol + dataFrom.getD());
            }
        }
        dti.setDtf((DataTraceFrom)SerializationUtils.clone((Serializable)dataFrom));
        return dti;
    }

    private Pair<String, Pair<String, String>> getSearchKey(Pair<Set<String>, Map<String, String>> pair, Map<String, String> dimension) {
        StringBuilder sb = new StringBuilder();
        Pair<String, String> yearPeriod = this.getPreSb(sb, pair, dimension);
        this.getUserSb(sb, pair, dimension);
        String searchKey = this.getSearchKeyByStr(sb.toString());
        return Pair.onePair((Object)searchKey, yearPeriod);
    }

    private String getSearchKeyByStr(String searchKey) {
        return searchKey.hashCode() + StringUtils.stringToMD5((String)searchKey);
    }

    public boolean saveCellDataPremanent() {
        log.info("DataTrace2FromService saveCellData: " + this.modelId + " size: " + this.dataFromMap.size());
        BatchProcessHelper.batchConsume(new ArrayList<DataTraceInfo>(this.dataFromMap.values()), (int)1000, dataFromTempList -> MQCommonPublisher.publishDataTraceInfo((String)JSON.toJSONString((Object)dataFromTempList), (Long)this.modelId));
        this.dataFromMap.clear();
        return true;
    }

    public DataTraceFrom queryDataTraceFrom(Map<String, String> dimension) {
        if (this.pair == null) {
            this.pair = this.getDimensionPair(this.modelId);
        }
        Pair<String, Pair<String, String>> searchKeyPair = this.getSearchKey(this.pair, dimension);
        QFBuilder builder = new QFBuilder("model", "=", (Object)this.modelId);
        builder.add("searchkey", "=", searchKeyPair.p1);
        builder.add("yearnumber", "=", (Object)dimension.get("Year"));
        builder.add("periodnumber", "=", (Object)dimension.get("Period"));
        log.info("DataTrace2FromService query dimension: " + dimension.toString() + " filter: " + builder.toString());
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_isdatatrace_from", (String)"datafrom", (QFilter[])builder.toArray());
        if (data != null && !data.isEmpty()) {
            return this.collectDataTraceFrom(data);
        }
        String process = dimension.get("Process");
        if ("IRpt".equals(process)) {
            dimension.put("Process", "EIRpt");
        } else if ("EIRpt".equals(process)) {
            dimension.put("Process", "IRpt");
        } else {
            return null;
        }
        searchKeyPair = this.getSearchKey(this.pair, dimension);
        builder = new QFBuilder("model", "=", (Object)this.modelId);
        builder.add("searchkey", "=", searchKeyPair.p1);
        log.info("DataTrace2FromService query dimension: " + dimension.toString() + " filter: " + builder.toString());
        data = QueryServiceHelper.query((String)"bcm_isdatatrace_from", (String)"datafrom", (QFilter[])builder.toArray());
        if (data != null && !data.isEmpty()) {
            return this.collectDataTraceFrom(data);
        }
        return null;
    }

    private DataTraceFrom collectDataTraceFrom(DynamicObjectCollection data) {
        DataTraceFrom result = null;
        for (DynamicObject d : data) {
            DataTraceFrom temp = (DataTraceFrom)JacksonUtils.fromJson((String)d.getString("datafrom"), DataTraceFrom.class);
            if (result == null) {
                result = temp;
                continue;
            }
            String mOld = result.getM();
            String mNew = temp.getM();
            try {
                BigDecimal bigMOld = new BigDecimal(mOld);
                BigDecimal bigMNew = new BigDecimal(mNew);
                result.setM(bigMOld.add(bigMNew).toPlainString());
            }
            catch (NumberFormatException e) {
                result.setM(result.getM() + ComputeOprtEnum.PLUS.getSymbol() + temp.getM());
            }
            List<DataTraceFromItem> df = result.getDf();
            df.addAll(temp.getDf());
        }
        return result;
    }

    private void getUserSb(StringBuilder sb, Pair<Set<String>, Map<String, String>> pair, Map<String, String> dimension) {
        String dim = null;
        String number = null;
        for (int i = 0; i < userDimensionList.size(); ++i) {
            dim = userDimensionList.get(i);
            number = (String)((Map)pair.p2).get(dim);
            if (number == null) continue;
            if (((Set)pair.p1).contains(number) && !dimension.containsKey(number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u7f3a\u5931\u53c2\u6570\u3002", (String)"DataTrace2FromService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
            }
            if ("dim1".equals(dim) && "c1None".equals(number)) continue;
            sb.append(dimension.get(number));
        }
    }

    private Pair<String, String> getPreSb(StringBuilder sb, Pair<Set<String>, Map<String, String>> pair, Map<String, String> dimension) {
        String number = null;
        String year = null;
        String period = null;
        for (int i = 0; i < preDimensionList.size(); ++i) {
            number = preDimensionList.get(i);
            if (((Set)pair.p1).contains(number) && !dimension.containsKey(number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u7f3a\u5931\u53c2\u6570\u3002", (String)"DataTrace2FromService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
            }
            sb.append(dimension.get(number));
            if (SysDimensionEnum.Year.getNumber().equals(number)) {
                year = dimension.get(number);
            }
            if (!SysDimensionEnum.Period.getNumber().equals(number)) continue;
            period = dimension.get(number);
        }
        return Pair.onePair(year, period);
    }

    private Pair<Set<String>, Map<String, String>> getDimensionPair(long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        Map dimension = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,fieldmapped", (QFilter[])new QFilter[]{qf});
        String number = null;
        String dim = null;
        HashSet<String> numberSet = new HashSet<String>(dimension.size());
        HashMap<String, String> dimMap = new HashMap<String, String>(dimension.size());
        for (Map.Entry Map2 : dimension.entrySet()) {
            number = ((DynamicObject)Map2.getValue()).getString("number");
            numberSet.add(number);
            dim = ((DynamicObject)Map2.getValue()).getString("fieldmapped");
            dimMap.put(dim, number);
        }
        return Pair.onePair(numberSet, dimMap);
    }

    public int getDataTraceMapSize() {
        int sum = 0;
        for (DataTraceInfo value : this.dataFromMap.values()) {
            sum += value.getSize();
        }
        return sum;
    }

    static {
        preDimensionList.add(SysDimensionEnum.Entity.getNumber());
        preDimensionList.add(SysDimensionEnum.Account.getNumber());
        preDimensionList.add(SysDimensionEnum.Scenario.getNumber());
        preDimensionList.add(SysDimensionEnum.Year.getNumber());
        preDimensionList.add(SysDimensionEnum.Period.getNumber());
        preDimensionList.add(SysDimensionEnum.Process.getNumber());
        preDimensionList.add(SysDimensionEnum.Currency.getNumber());
        preDimensionList.add(SysDimensionEnum.AuditTrail.getNumber());
        preDimensionList.add(SysDimensionEnum.ChangeType.getNumber());
        preDimensionList.add(SysDimensionEnum.MyCompany.getNumber());
        preDimensionList.add(SysDimensionEnum.InternalCompany.getNumber());
        preDimensionList.add(SysDimensionEnum.MultiGAAP.getNumber());
        preDimensionList.add(SysDimensionEnum.DataSort.getNumber());
        userDimensionList.add("dim1");
        userDimensionList.add("dim2");
        userDimensionList.add("dim3");
        userDimensionList.add("dim4");
        userDimensionList.add("dim5");
        userDimensionList.add("dim6");
        log = LogFactory.getLog(DataTrace2FromService.class);
    }
}

