/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.FormulaOutPut;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaDataProvider;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaRow;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;

public class FormulaIntegrateService
extends AbstractIntegrateService {
    public FormulaIntegrateService(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        return this._ctx.getFormulaMappedGroup();
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new FormulaDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new FormulaOutPut(this._ctx);
    }

    @Override
    public void match(IRow resultRow, MappedRow mappedRow) {
        FormulaRow row = (FormulaRow)resultRow;
        Map<MappedRow, ValueList> result = this._ctx.getResult();
        if (mappedRow.getUuid().equals(row.getFormulaKey())) {
            ValueList valueList = result.get(mappedRow);
            if (valueList == null) {
                valueList = new ValueList();
                result.put(mappedRow, valueList);
            }
            ValueItem valueItem = new ValueItem();
            valueList.addValue(valueItem);
            valueItem.setValue(row.getFormulaValue());
            valueItem.setProperty("isNumber", row.isNumber());
            valueItem.setProperty("fitNumber", row.getFitNumber());
            valueItem.setProperty("fitDim", row.getFitDim());
            valueItem.setProperty("error", row.getError());
        }
    }
}

