/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.EqualsFilter;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.OlapOutput;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.eas2my.GLBalanceDataProvider;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GLBalanceIntegrateService
extends AbstractIntegrateService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(GLBalanceIntegrateService.class);
    private final Map<String, String> srcNumNameMap = new HashMap<String, String>(16);
    private final Map<String, String> targetDimMemberMap = new HashMap<String, String>(16);
    private Map<String, DynamicObjectCollection> singleMap;
    private Map<String, Map<String, Map<Object, Set<Long>>>> indexMap = new HashMap<String, Map<String, Map<Object, Set<Long>>>>(16);
    private Map<String, Map<Object, Set<Long>>> combineIndexMap = new HashMap<String, Map<Object, Set<Long>>>(16);
    private final List<String> allSourceKey = new ArrayList<String>();
    private Map<String, String> singleDimMap;
    private Map<String, Integer> srcDimIndex;
    private Map<String, String> lastSrc;
    private Map<String, List<String>> srcDefaultMap;
    private Pair<Set<String>, Set<String>> asstAndComassist;
    private Map<String, String> commonSrcInfo;
    private final Multimap<String, MappedRow> accountHighPriority = ArrayListMultimap.create();
    private final List<MappedRow> notHighPriorityMappedRows = new ArrayList<MappedRow>();
    private static final String MATCHED = "matched";
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private static final String NONE = "None";
    private static final int srcAccountNotExist_priority = -2;
    private static final String ALL_SUFFIX = "all";
    private static final String LOCAL_SUFFIX = "local";
    private static final String FOR_SUFFIX = "for";
    private boolean multiCurrency = false;
    private Long currencyMapId = 0L;
    private boolean isNotUseIndex = ConfigServiceHelper.getGlobalBoolParam("IntegrationIsNotUseIndex");

    public GLBalanceIntegrateService(IIntegrateContext ctx) {
        super(ctx);
    }

    private void dealFetchType() {
        List<MappedGroup> groups = this._ctx.getCombineMappedGroup();
        groups.forEach(g -> g.forEach(row -> {
            MappedSourceItem fetchType = row.getSrcMapped().get("ChangeType");
            String number = fetchType.getNumber().split("\\|")[0].toLowerCase(Locale.ENGLISH);
            fetchType.setNumber(number);
        }));
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        return this._ctx.getCombineMappedGroup();
    }

    @Override
    protected void beforeExecute() {
        this.currencyMapId = IntegrationUtil.getDefinedToCurrencyMap(this._ctx);
        this.multiCurrency = this.currencyMapId != 0L;
        super.beforeExecute();
        this.initSrcInfo();
        this.initSrcDefaultMap();
        this.initTargetDimMemberMap();
        this.initAllSourceKey();
        this.dealFetchType();
    }

    @Override
    protected void check() {
        super.check();
        if (this.multiCurrency && !ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, "CM031")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u5f00\u542f\u7cfb\u7edf\u53c2\u6570\u201cCM031|\u662f\u5426\u542f\u7528\u539f\u5e01\u201d\uff0c\u65e0\u6cd5\u96c6\u6210\u539f\u5e01\u6570\u636e\u3002", (String)"GLBalanceIntegrateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void execute() {
        if (this._ctx.getCombineMappedGroup() == null || this._ctx.getCombineMappedGroup().size() == 0) {
            return;
        }
        log.startWatch();
        this.beforeExecute();
        String schemeAndOrg = (String)this._ctx.getSchema().p2 + "|" + (String)this._ctx.getOrg().p2;
        log.info(String.format("\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", schemeAndOrg));
        IDataSet ds = (IDataSet)this._provider.loadData();
        this.initCommonSrcInfo();
        this.initPriorityList(ds);
        log.info(String.format("\u96c6\u6210\u65b9\u6848[%s]\u67e5\u8be2\u603b\u8d26\u6570\u636e\u8017\u65f6", schemeAndOrg));
        ds.forEach(row -> {
            this._ctx.putCustomParam(MATCHED, false);
            this._ctx.putCustomParam("priority", null);
            Set<Long> idSet = this.isNotUseIndex ? null : this.getIdSet((String)row.get("account"), this.combineIndexMap);
            Collection accountHigh = this.accountHighPriority.values();
            if (accountHigh.size() > 0) {
                for (MappedRow maprow : accountHigh) {
                    if (!this.isNotUseIndex && (idSet == null || !idSet.contains(maprow.getId()))) continue;
                    this.match((IRow)row, maprow);
                }
            }
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                for (MappedRow mrow : this.notHighPriorityMappedRows) {
                    if (!this.isNotUseIndex && (idSet == null || !idSet.contains(mrow.getId()))) continue;
                    this.match((IRow)row, mrow);
                    if (this._ctx.getCustomParam("break") == null) continue;
                    this._ctx.putCustomParam("break", null);
                    break;
                }
            }
        });
        log.info(String.format("\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", schemeAndOrg));
        this._output.output();
        log.info(String.format("\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51fa\u8017\u65f6", schemeAndOrg));
        this.afterExecute();
    }

    private void initCommonSrcInfo() {
        this.commonSrcInfo = new HashMap<String, String>();
        this.commonSrcInfo.put("Entity", (String)this._ctx.getMapOrg().p2);
        this.commonSrcInfo.put("Period", (String)this._ctx.getMapPeriod().p2);
        this.commonSrcInfo.put("Currency", StringUtils.isEmpty((CharSequence)((CharSequence)this._ctx.getMapCurrency().p2)) ? ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"GLBalanceIntegrateService_0", (String)"fi-bcm-business", (Object[])new Object[0]) : (String)this._ctx.getMapCurrency().p2);
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new GLBalanceDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new OlapOutput(this._ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void match(IRow realRow, MappedRow mappedRow) {
        String targetDimension;
        Object value;
        String fetchType = null;
        Map assgrp = (Map)realRow.get("assgrp");
        Map comassist = (Map)realRow.get("comassist");
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(3);
        flagMap.put("isIgnore", false);
        flagMap.put("targetMemberExist", true);
        ValueItem valueItem = new ValueItem();
        int priority = -2;
        HashMap<String, String> srcInfo = new HashMap<String, String>(this.commonSrcInfo);
        for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
            String string = src.getMappedDim().getMappedKey();
            String srcNumber = src.getNumber();
            value = null;
            Object linkValue = null;
            if ("AccountBookType".equalsIgnoreCase(string)) {
                linkValue = value = (String)realRow.get("booktype");
            } else if ("Currency".equalsIgnoreCase(string)) {
                linkValue = value = (String)realRow.get("currency");
            } else if ("ChangeType".equalsIgnoreCase(string)) {
                fetchType = srcNumber;
                if (!fetchType.endsWith(ALL_SUFFIX) && realRow.get(fetchType) == null) {
                    return;
                }
                linkValue = value = fetchType;
            } else if ("AccountView".equals(string)) {
                linkValue = value = (String)realRow.get("account");
                priority = src.getPriority();
            } else {
                boolean isComassist;
                boolean bl = isComassist = string.equals("comassist1") || string.equals("comassist2");
                if (isComassist) {
                    if (comassist != null && comassist.containsKey(string)) {
                        if (comassist.get(string) == null) {
                            if (!ALL.equals(srcNumber)) {
                                return;
                            }
                            linkValue = NONE;
                        } else {
                            linkValue = value = (String)((Map)comassist.get(string)).get("number");
                        }
                    }
                } else if (assgrp != null && assgrp.containsKey(string)) {
                    if (assgrp.get(string) == null) {
                        if (!ALL.equals(srcNumber)) {
                            return;
                        }
                        linkValue = NONE;
                    } else {
                        linkValue = value = (String)((Map)assgrp.get(string)).get("number");
                    }
                }
            }
            if (value != null && !ALL.equals(srcNumber) && !FilterFactory.getFilter(src, this._ctx).isMatched(src, (String)value, this._ctx)) {
                return;
            }
            srcInfo.put(string, (String)linkValue);
            DimMappedRelation.SingleDimRelationPair singlePair = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId());
            if (singlePair == null) continue;
            targetDimension = singlePair.getTargetDimItem().getDimItem().getNumber();
            String targetMember = mappedRow.getTargMapped().get(targetDimension).getNumber();
            if (IGNORE.equalsIgnoreCase(targetMember)) {
                flagMap.put("isIgnore", true);
                continue;
            }
            if (ALL.equals(targetMember)) {
                if (value == null) {
                    flagMap.put("targetMemberExist", false);
                    continue;
                }
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)targetDimension, (String)value);
                if (m == null) {
                    flagMap.put("targetMemberExist", false);
                }
                valueItem.setProperty(targetDimension, m == null ? value : m.getNumber());
                continue;
            }
            valueItem.setProperty(targetDimension, targetMember);
        }
        int allSourceSize = this.allSourceKey.size();
        if (allSourceSize > mappedRow.getSrcMapped().size()) {
            ArrayList mappedRowKey = new ArrayList(10);
            for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
                mappedRowKey.add(src.getMappedDim().getMappedKey());
            }
            if (this.isDataTransUseDimMapOrder) {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(16);
                ArrayList emptySrc = new ArrayList(CollectionUtils.disjunction(this.allSourceKey, (Collection)mappedRowKey));
                emptySrc.sort(Comparator.comparingInt(o -> this.srcDimIndex.getOrDefault(o, 9999)));
                value = emptySrc.iterator();
                while (value.hasNext()) {
                    String srcDim = (String)value.next();
                    String srcMember = null;
                    String linkValue = null;
                    String targetDimension2 = this.singleDimMap.get(srcDim);
                    boolean existTarget = this.singleDimMap.containsKey(srcDim);
                    if (hashMap.getOrDefault(targetDimension2, false).booleanValue()) continue;
                    if ("Currency".equals(srcDim)) {
                        linkValue = srcMember = (String)realRow.get("currency");
                    } else {
                        boolean isComassist;
                        boolean bl = isComassist = srcDim.equals("comassist1") || srcDim.equals("comassist2");
                        if (isComassist) {
                            if (comassist == null || !comassist.containsKey(srcDim)) {
                                if (existTarget && valueItem.getProperty(targetDimension2) == null) {
                                    valueItem.setProperty(targetDimension2, this.targetDimMemberMap.get(targetDimension2));
                                }
                            } else if (comassist.get(srcDim) != null) {
                                linkValue = srcMember = (String)((Map)comassist.get(srcDim)).get("number");
                            } else {
                                if (existTarget && valueItem.getProperty(targetDimension2) == null) {
                                    valueItem.setProperty(targetDimension2, this.targetDimMemberMap.get(targetDimension2));
                                }
                                linkValue = NONE;
                            }
                        } else if (assgrp == null || !assgrp.containsKey(srcDim)) {
                            if (existTarget && valueItem.getProperty(targetDimension2) == null) {
                                valueItem.setProperty(targetDimension2, this.targetDimMemberMap.get(targetDimension2));
                            }
                        } else if (assgrp.get(srcDim) != null) {
                            linkValue = srcMember = (String)((Map)assgrp.get(srcDim)).get("number");
                        } else {
                            if (existTarget && valueItem.getProperty(targetDimension2) == null) {
                                valueItem.setProperty(targetDimension2, this.targetDimMemberMap.get(targetDimension2));
                            }
                            linkValue = NONE;
                        }
                    }
                    if (srcMember == null) {
                        if (StringUtils.isEmpty((CharSequence)linkValue)) continue;
                        srcInfo.put(srcDim, linkValue);
                        continue;
                    }
                    if (existTarget) {
                        DynamicObjectCollection col = this.singleMap.get(srcDim);
                        if (this.matchSingleMemMap(srcMember, srcDim, (List<DynamicObject>)col, valueItem, targetDimension2, flagMap)) {
                            hashMap.put(targetDimension2, true);
                        } else if (srcDim.equals(this.lastSrc.get(targetDimension2))) {
                            return;
                        }
                    }
                    srcInfo.put(srcDim, linkValue);
                }
            } else {
                Collection collection = CollectionUtils.disjunction(this.allSourceKey, (Collection)mappedRowKey);
                for (String srcDim : collection) {
                    String srcMember = null;
                    String linkValue = null;
                    targetDimension = this.singleDimMap.get(srcDim);
                    boolean existTarget = this.singleDimMap.containsKey(srcDim);
                    if ("Currency".equals(srcDim)) {
                        linkValue = srcMember = (String)realRow.get("currency");
                    } else {
                        boolean isComassist;
                        boolean bl = isComassist = srcDim.equals("comassist1") || srcDim.equals("comassist2");
                        if (isComassist) {
                            if (comassist == null || !comassist.containsKey(srcDim)) {
                                if (existTarget && valueItem.getProperty(targetDimension) == null) {
                                    valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                                }
                            } else if (comassist.get(srcDim) != null) {
                                linkValue = srcMember = (String)((Map)comassist.get(srcDim)).get("number");
                            } else {
                                if (existTarget && valueItem.getProperty(targetDimension) == null) {
                                    valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                                }
                                linkValue = NONE;
                            }
                        } else if (assgrp == null || !assgrp.containsKey(srcDim)) {
                            if (existTarget && valueItem.getProperty(targetDimension) == null) {
                                valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                            }
                        } else if (assgrp.get(srcDim) != null) {
                            linkValue = srcMember = (String)((Map)assgrp.get(srcDim)).get("number");
                        } else {
                            if (existTarget && valueItem.getProperty(targetDimension) == null) {
                                valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                            }
                            linkValue = NONE;
                        }
                    }
                    if (srcMember == null) {
                        if (StringUtils.isEmpty((CharSequence)linkValue)) continue;
                        srcInfo.put(srcDim, linkValue);
                        continue;
                    }
                    DynamicObjectCollection col = this.singleMap.get(srcDim);
                    if (col == null) {
                        return;
                    }
                    if (existTarget && !this.matchSingleMemMap(srcMember, srcDim, (List<DynamicObject>)col, valueItem, targetDimension, flagMap)) {
                        return;
                    }
                    srcInfo.put(srcDim, linkValue);
                }
            }
        }
        for (Map.Entry entry : this.srcDefaultMap.entrySet()) {
            String srcMember;
            boolean isComassist;
            String key = (String)entry.getKey();
            if (srcInfo.containsKey(key)) continue;
            boolean bl = isComassist = key.equals("comassist1") || key.equals("comassist2");
            if (isComassist) {
                if (comassist == null || !comassist.containsKey(key)) continue;
                if (comassist.get(key) == null) return;
                srcMember = (String)((Map)comassist.get(key)).get("number");
            } else {
                if (assgrp == null || !assgrp.containsKey(key)) continue;
                if (assgrp.get(key) == null) return;
                srcMember = (String)((Map)assgrp.get(key)).get("number");
            }
            if (!((List)entry.getValue()).contains(srcMember)) {
                return;
            }
            if (!StringUtils.isNotEmpty((CharSequence)srcMember)) continue;
            srcInfo.put(key, srcMember);
        }
        this._ctx.putCustomParam(MATCHED, true);
        if (this._ctx.getCustomParam("priority") != null && priority != (Integer)this._ctx.getCustomParam("priority")) {
            this._ctx.putCustomParam("break", true);
            return;
        }
        this._ctx.putCustomParam("priority", priority);
        ValueItem newItem = null;
        boolean isNegate = mappedRow.isNegate();
        if (fetchType == null) {
            return;
        }
        if (fetchType.endsWith(ALL_SUFFIX)) {
            String fetchLocal = fetchType.replace(ALL_SUFFIX, LOCAL_SUFFIX);
            BigDecimal bigDecimal = new BigDecimal(realRow.get(fetchLocal).toString());
            valueItem.setValue(isNegate ? bigDecimal.negate() : bigDecimal);
            valueItem.setProperty("Currency", this._ctx.getCurrency().p2);
            srcInfo.put("ChangeType", fetchLocal);
            this.buildDataTrace(valueItem, isNegate, bigDecimal, srcInfo);
            String fetchFor = fetchType.replace(ALL_SUFFIX, FOR_SUFFIX);
            newItem = new ValueItem(valueItem);
            BigDecimal bigDecimal2 = new BigDecimal(realRow.get(fetchFor).toString());
            newItem.setValue(isNegate ? bigDecimal2.negate() : bigDecimal2);
            newItem.setProperty("Currency", "OC");
            srcInfo.put("ChangeType", fetchFor);
            this.buildDataTrace(newItem, isNegate, bigDecimal2, srcInfo);
        } else {
            BigDecimal bigDecimal = new BigDecimal(realRow.get(fetchType).toString());
            valueItem.setValue(isNegate ? bigDecimal.negate() : bigDecimal);
            if (fetchType.endsWith(FOR_SUFFIX)) {
                valueItem.setProperty("Currency", "OC");
            } else {
                valueItem.setProperty("Currency", this._ctx.getCurrency().p2);
            }
            this.buildDataTrace(valueItem, isNegate, bigDecimal, srcInfo);
        }
        if (((Boolean)flagMap.get("isIgnore")).booleanValue() || !((Boolean)flagMap.get("targetMemberExist")).booleanValue()) return;
        ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
        vl.addValue(valueItem);
        if (newItem == null) return;
        vl.addValue(newItem);
    }

    private void buildDataTrace(ValueItem item, boolean isNegate, BigDecimal amount, Map<String, String> srcInfo) {
        if (!this.isOpenTrace || BigDecimal.ZERO.compareTo(amount) == 0) {
            return;
        }
        String detail = this.getDataTraceDetail(srcInfo);
        DataTraceFrom dataTraceFrom = new DataTraceFrom();
        String m = item.getValue() instanceof BigDecimal ? ((BigDecimal)item.getValue()).toPlainString() : item.getValue().toString();
        dataTraceFrom.setM(m);
        String symbol = isNegate ? ComputeOprtEnum.SUBTRACT.getSymbol() : ComputeOprtEnum.PLUS.getSymbol();
        dataTraceFrom.setSymbol(symbol);
        ArrayList<DataTraceFromItem> ld = new ArrayList<DataTraceFromItem>();
        dataTraceFrom.setDf(ld);
        DataTraceFromItem dci = new DataTraceFromItem();
        dci.setS(1);
        dci.setD(detail);
        dci.setV(amount.toPlainString());
        dci.setOprt(symbol);
        ld.add(dci);
        item.setDataTraceFrom(dataTraceFrom);
    }

    private String getDataTraceDetail(Map<String, String> srcInfo) {
        StringBuilder sb = new StringBuilder();
        srcInfo.forEach((k, v) -> {
            if (v == null) {
                return;
            }
            if (((Set)this.asstAndComassist.p1).contains(k)) {
                sb.append("asst/");
            } else if (((Set)this.asstAndComassist.p2).contains(k)) {
                sb.append("comassist/");
            }
            sb.append((String)k).append("|").append(this.srcNumNameMap.get(k)).append("\uff1a").append((String)v);
            sb.append("\uff0c");
        });
        if (sb.length() != 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private boolean matchSingleMemMap(String srcMember, String srcDim, List<DynamicObject> issinglemap, ValueItem valueItem, String targetDim, Map<String, Boolean> flagMap) {
        boolean matchSingle = false;
        if (issinglemap == null) {
            return false;
        }
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        Set<Long> idSet = this.isNotUseIndex ? null : this.getIdSet(srcMember, srcDim);
        for (DynamicObject isObject : issinglemap) {
            if (!this.isNotUseIndex && (idSet == null || !idSet.contains(isObject.getLong("id")))) continue;
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && ALL.equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null) continue;
            if (StringUtils.isEmpty((CharSequence)srcMember)) {
                return false;
            }
            if (sourceItem != null && !ALL.equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, srcMember, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
                continue;
            }
            if (ALL.equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)targetDim, (String)srcMember);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            String targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue();
            if ("".equals(targetNumber)) {
                flagMap.put("targetMemberExist", false);
            } else if (IGNORE.equals(targetNumber)) {
                flagMap.put("isIgnore", true);
            }
            valueItem.setProperty(targetDim, targetNumber);
            matchSingle = true;
        }
        return matchSingle;
    }

    private Set<Long> getIdSet(String srcMember, String srcDim) {
        HashSet<Long> idSet = new HashSet<Long>();
        Map<String, Map<Object, Set<Long>>> scopeMap = this.indexMap.get(srcDim);
        if (scopeMap == null) {
            return idSet;
        }
        return this.getIdSet(srcMember, scopeMap);
    }

    private Set<Long> getIdSet(String srcMember, Map<String, Map<Object, Set<Long>>> scopeMap) {
        HashSet<Long> idSet = new HashSet<Long>();
        for (Map.Entry<String, Map<Object, Set<Long>>> mapEntry : scopeMap.entrySet()) {
            String key = mapEntry.getKey();
            Map<Object, Set<Long>> value = mapEntry.getValue();
            if ("1".equals(key)) {
                Set<Long> ids2;
                Set<Long> ids1 = value.get(srcMember);
                if (ids1 != null) {
                    idSet.addAll(ids1);
                }
                if ((ids2 = value.get(ALL)) == null) continue;
                idSet.addAll(ids2);
                continue;
            }
            if ("2".equals(key)) {
                for (Map.Entry<Object, Set<Long>> valueEntry : value.entrySet()) {
                    boolean isInIndexBetween = this.checkIsInIndexBetween((String)valueEntry.getKey(), srcMember);
                    if (!isInIndexBetween) continue;
                    idSet.addAll((Collection<Long>)valueEntry.getValue());
                }
                continue;
            }
            if ("3".equals(key)) {
                for (Map.Entry<Object, Set<Long>> valueEntry : value.entrySet()) {
                    boolean isInIndexLike = this.checkIsInIndexLike((String)valueEntry.getKey(), srcMember);
                    if (!isInIndexLike) continue;
                    idSet.addAll((Collection<Long>)valueEntry.getValue());
                }
                continue;
            }
            if (!"4".equals(key)) continue;
            for (Map.Entry<Object, Set<Long>> valueEntry : value.entrySet()) {
                Set indexSet = (Set)valueEntry.getKey();
                if (!indexSet.contains(srcMember)) continue;
                idSet.addAll((Collection<Long>)valueEntry.getValue());
            }
        }
        return idSet;
    }

    private boolean checkIsInIndexLike(String key, String compare) {
        return compare.startsWith(key = key.replace("%", "")) || compare.endsWith(key);
    }

    private boolean checkIsInIndexBetween(String key, String compare) {
        String small;
        String[] split = key.split(",");
        String big = split[0];
        if (big.compareTo(small = split[1]) < 0) {
            String temp = small;
            small = big;
            big = temp;
        }
        return big.compareTo(compare) >= 0 && small.compareTo(compare) <= 0;
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        return new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, mainscope, false, false);
    }

    private void initSrcInfo() {
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        DynamicObjectCollection baseents = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> baseentMap = new HashMap<Long, String>(16);
        for (Object ent : baseents) {
            baseentMap.put(ent.getLong("id"), ent.getString("number"));
            this.srcNumNameMap.put(ent.getString("number"), ent.getString("name"));
        }
        this.asstAndComassist = IntegrationUtil.getBaseEntity(this._ctx);
        DynamicObjectCollection dimMap = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"sequence,mappedtype,isdimmapsrcentry.srcdimension, isdimmaptargentry.tagdimension", (QFilter[])new QFilter[]{filter}, (String)"sequence");
        this.singleDimMap = new HashMap<String, String>();
        this.srcDimIndex = new HashMap<String, Integer>(16);
        this.lastSrc = new HashMap<String, String>(16);
        for (DynamicObject dot : dimMap) {
            if (dot.getInt("mappedtype") != 1) continue;
            long targetId = dot.getLong("isdimmaptargentry.tagdimension");
            long srcId = dot.getLong("isdimmapsrcentry.srcdimension");
            String src = (String)baseentMap.get(srcId);
            String target = MemberReader.getDimensionNumById((long)targetId);
            if (this.multiCurrency && "Currency".equals(src) && "Currency".equals(target)) continue;
            this.singleDimMap.put(src, target);
            this.srcDimIndex.put(src, dot.getInt("sequence"));
            this.lastSrc.put(target, src);
        }
        Map<Long, Map<String, Object>> pubMap = IntegrationUtil.getPubMap((Long)this._ctx.getSchema().p1, null);
        filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        if (pubMap.size() > 0) {
            filter.or(new QFilter("pubmappingid", "in", pubMap.keySet()));
        }
        DynamicObject[] allSingleMap = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"scope,dimmapid,pubmappingid,targmembnumber,srcmembnumber,issinglemapentry.srcdim,issinglemapentry.srcmemnumber,issinglemapentry.srcmembid,issinglemapentry.seq", (QFilter[])new QFilter[]{filter});
        List<DynamicObject> allSingleMapList = IntegrationUtil.addPubMapping(allSingleMap, pubMap);
        this.singleMap = new HashMap<String, DynamicObjectCollection>();
        for (DynamicObject e : allSingleMapList) {
            Long srcDimId = ((DynamicObject)e.getDynamicObjectCollection("issinglemapentry").get(0)).getLong("srcdim");
            String srcDimNum = (String)baseentMap.get(srcDimId);
            if (this.multiCurrency && "Currency".equals(srcDimNum) && !this.currencyMapId.equals(e.getLong("dimmapid"))) continue;
            this.singleMap.computeIfAbsent(srcDimNum, k -> new DynamicObjectCollection());
            DynamicObjectCollection col = this.singleMap.get(srcDimNum);
            col.add((Object)e);
            if (this.isNotUseIndex) continue;
            this.addIndexMap(srcDimNum, e);
        }
    }

    private void addIndexMap(String srcDimNum, DynamicObject obj) {
        Map scopeMap = this.indexMap.computeIfAbsent(srcDimNum, e -> new HashMap());
        String scope = obj.getString("scope");
        if ("1".equals(scope)) {
            Map srcMap = scopeMap.computeIfAbsent(scope, e -> new HashMap());
            String srcmembnumber = obj.getString("srcmembnumber");
            Set isSet = srcMap.computeIfAbsent(srcmembnumber, e -> new HashSet());
            isSet.add(obj.getLong("id"));
        } else if ("2".equals(scope)) {
            Map srcMap = scopeMap.computeIfAbsent(scope, e -> new HashMap());
            DynamicObjectCollection issinglemapentry = obj.getDynamicObjectCollection("issinglemapentry");
            String key = ((DynamicObject)issinglemapentry.get(0)).getString("srcmemnumber") + "," + ((DynamicObject)issinglemapentry.get(1)).getString("srcmemnumber");
            Set isSet = srcMap.computeIfAbsent(key, e -> new HashSet());
            isSet.add(obj.getLong("id"));
        } else if ("3".equals(scope)) {
            Map srcMap = scopeMap.computeIfAbsent(scope, e -> new HashMap());
            DynamicObjectCollection issinglemapentry = obj.getDynamicObjectCollection("issinglemapentry");
            String key = ((DynamicObject)issinglemapentry.get(0)).getString("srcmemnumber");
            Set isSet = srcMap.computeIfAbsent(key, e -> new HashSet());
            isSet.add(obj.getLong("id"));
        } else if ("4".equals(scope)) {
            Map srcMap = scopeMap.computeIfAbsent(scope, e -> new HashMap());
            DynamicObjectCollection issinglemapentry = obj.getDynamicObjectCollection("issinglemapentry");
            HashSet<String> keySet = new HashSet<String>(16);
            for (DynamicObject object : issinglemapentry) {
                keySet.add(object.getString("srcmemnumber"));
            }
            Set isSet = srcMap.computeIfAbsent(keySet, e -> new HashSet());
            isSet.add(obj.getLong("id"));
        }
    }

    private void initTargetDimMemberMap() {
        QFilter filter = new QFilter("model", "=", this._ctx.getModel().p1);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,shortnumber", (QFilter[])new QFilter[]{filter});
        HashMap number2Short = new HashMap();
        dims.forEach(e -> number2Short.put(e.getString("number"), e.getString("shortnumber")));
        Pair<Set<String>, Set<String>> asstNums = IntegrationUtil.getAsstInSingle(this._ctx);
        this.singleDimMap.forEach((src, target) -> {
            if (((Set)asstNums.p1).stream().anyMatch(p -> p.equalsIgnoreCase((String)src)) || ((Set)asstNums.p2).stream().anyMatch(p -> p.equalsIgnoreCase((String)src))) {
                if (target.equals("InternalCompany")) {
                    this.targetDimMemberMap.put((String)target, "ICNone");
                } else {
                    this.targetDimMemberMap.put((String)target, (String)number2Short.get(target) + NONE);
                }
            }
        });
    }

    private void initSrcDefaultMap() {
        this.srcDefaultMap = new HashMap<String, List<String>>();
        this._ctx.getSourceDefaultValsMap().values().forEach(e -> {
            String key = e.getDimItem().getNumber();
            this.srcDefaultMap.computeIfAbsent(key, k -> new ArrayList());
            List<String> members = this.srcDefaultMap.get(key);
            e.getDefVals().forEach(p -> members.add(p.getNumber()));
        });
    }

    private void initAllSourceKey() {
        for (Map.Entry<Long, MappedDimItem> aSource : this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().entrySet()) {
            this.allSourceKey.add(aSource.getValue().getMappedKey());
        }
    }

    private void initPriorityList(IDataSet<IRow> dataSet) {
        List<MappedGroup> serviceMappedGroup = this.getServiceMappedGroup();
        if (null == serviceMappedGroup || serviceMappedGroup.size() == 0) {
            return;
        }
        HashSet accounts = new HashSet(16);
        dataSet.forEach(row -> accounts.add(row.get("account").toString()));
        serviceMappedGroup.forEach(g -> g.forEach(row -> {
            if (!this.accountInDataSet(accounts, (MappedRow)row)) {
                return;
            }
            boolean accountHigh = false;
            for (MappedSourceItem src : row.getSrcMapped().values()) {
                if (!"AccountView".equals(src.getMappedDim().getNumber()) || MapScopeEnum.EQUALS != MapScopeEnum.getEnumByindex((int)src.getScope()) || src.getPriority() != 999) continue;
                this.accountHighPriority.put((Object)src.getNumber(), row);
                accountHigh = true;
                break;
            }
            if (!accountHigh) {
                this.notHighPriorityMappedRows.add((MappedRow)row);
            }
            if (!this.isNotUseIndex) {
                this.addCombineIndexMap((MappedRow)row);
            }
        }));
    }

    private void addCombineIndexMap(MappedRow row) {
        for (MappedSourceItem src : row.getSrcMapped().values()) {
            if (!"AccountView".equals(src.getMappedDim().getNumber())) continue;
            Integer scope = src.getScope();
            Long id = row.getId();
            Map srcMap = this.combineIndexMap.computeIfAbsent(scope + "", e -> new HashMap());
            if (MapScopeEnum.EQUALS == MapScopeEnum.getEnumByindex((int)scope)) {
                Set isSet = srcMap.computeIfAbsent(src.getNumber(), e -> new HashSet());
                isSet.add(id);
                break;
            }
            if (MapScopeEnum.RANGE == MapScopeEnum.getEnumByindex((int)scope)) {
                StringBuilder keySb = new StringBuilder(16);
                for (MappedSourceItem object : src.getScopeSourceItems()) {
                    keySb.append(object.getNumber()).append(",");
                }
                String key = keySb.substring(0, keySb.length() - 1);
                Set isSet = srcMap.computeIfAbsent(key, e -> new HashSet());
                isSet.add(id);
                break;
            }
            if (MapScopeEnum.LIKE == MapScopeEnum.getEnumByindex((int)scope)) {
                Set isSet = srcMap.computeIfAbsent(src.getNumber(), e -> new HashSet());
                isSet.add(id);
                break;
            }
            if (MapScopeEnum.INCLUDE != MapScopeEnum.getEnumByindex((int)scope)) break;
            HashSet<String> keySet = new HashSet<String>(16);
            for (MappedSourceItem object : src.getScopeSourceItems()) {
                keySet.add(object.getNumber());
            }
            Set isSet = srcMap.computeIfAbsent(keySet, e -> new HashSet());
            isSet.add(id);
            break;
        }
    }

    private boolean accountInDataSet(Set<String> accounts, MappedRow row) {
        boolean isMatch = false;
        MappedSourceItem srcAccount = row.getSrcMapped().get("AccountView");
        String srcNumber = srcAccount.getNumber();
        if (ALL.equals(srcNumber)) {
            return true;
        }
        IFilter<String> filter = FilterFactory.getFilter(srcAccount, this._ctx);
        if (filter instanceof EqualsFilter) {
            isMatch = accounts.contains(srcNumber);
        } else {
            for (String account : accounts) {
                if (!FilterFactory.getFilter(srcAccount, this._ctx).isMatched(srcAccount, account, this._ctx)) continue;
                isMatch = true;
                break;
            }
        }
        return isMatch;
    }
}

