/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.formula.FormulaRow;
import kd.fi.bcm.business.integrationnew.provider.formula.GLFormulaDataProvider;
import kd.fi.bcm.business.integrationnew.service.FormulaIntegrateService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;

public class GLFormulaIntegrateService
extends FormulaIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(GLFormulaIntegrateService.class);

    public GLFormulaIntegrateService(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new GLFormulaDataProvider(this._ctx);
    }

    @Override
    protected void check() {
        boolean multiCurrency;
        super.check();
        long currencyMapId = IntegrationUtil.getDefinedToCurrencyMap(this._ctx);
        boolean bl = multiCurrency = currencyMapId != 0L;
        if (multiCurrency && !ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, "CM031")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u5f00\u542f\u7cfb\u7edf\u53c2\u6570\u201cCM031|\u662f\u5426\u542f\u7528\u539f\u5e01\u201d\uff0c\u65e0\u6cd5\u96c6\u6210\u539f\u5e01\u6570\u636e\u3002", (String)"GLBalanceIntegrateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void execute() {
        if (this._ctx.getFormulaMappedGroup() == null || this._ctx.getFormulaMappedGroup().size() == 0) {
            return;
        }
        log.startWatch();
        this.beforeExecute();
        String schemeAndOrg = (String)this._ctx.getSchema().p2 + "|" + (String)this._ctx.getOrg().p2;
        log.info(String.format("\u96c6\u6210\u603b\u8d26\u516c\u5f0f\u53d6\u6570[%s]\u9884\u5904\u7406\u8017\u65f6", schemeAndOrg));
        IDataSet ds = (IDataSet)this._provider.loadData();
        log.info(String.format("\u96c6\u6210\u603b\u8d26\u516c\u5f0f\u53d6\u6570[%s]\u67e5\u8be2\u8017\u65f6", schemeAndOrg));
        Recorder rowSize = new Recorder((Object)0);
        ds.forEach(row -> this.getServiceMappedGroup().forEach(g -> {
            g.forEach(mrow -> this.match((IRow)row, (MappedRow)mrow));
            rowSize.setRecord((Object)((Integer)rowSize.getRecord() + g.rowSize()));
        }));
        log.info(String.format("\u96c6\u6210\u603b\u8d26\u516c\u5f0f\u53d6\u6570[%s]\u5339\u914d\u8017\u65f6", schemeAndOrg));
        this._output.output();
        log.info(String.format("\u96c6\u6210\u603b\u8d26\u516c\u5f0f\u53d6\u6570[%s]\u8f93\u51fa\u8017\u65f6", schemeAndOrg));
        this.afterExecute();
    }

    @Override
    public void match(IRow resultRow, MappedRow mappedRow) {
        ValueItem valueItem;
        FormulaRow row = (FormulaRow)resultRow;
        Map<MappedRow, ValueList> result = this._ctx.getResult();
        String[] tempKey = row.getFormulaKey().split("!");
        result.computeIfAbsent(mappedRow, l -> new ValueList());
        ValueList valueList = result.get(mappedRow);
        if (tempKey.length == 1 && mappedRow.getUuid().equals(row.getFormulaKey())) {
            valueItem = new ValueItem();
            valueList.addValue(valueItem);
            valueItem.setValue(row.getFormulaValue());
            valueItem.setProperty("isNumber", row.isNumber());
            valueItem.setProperty("fitNumber", row.getFitNumber());
            valueItem.setProperty("fitDim", row.getFitDim());
            valueItem.setProperty("error", row.getError());
            valueItem.setDataTraceFrom(row.getDataTraceFrom());
        }
        if (tempKey.length > 1 && mappedRow.getUuid().equals(tempKey[0])) {
            valueItem = new ValueItem();
            valueList.addValue(valueItem);
            valueItem.setValue(row.getFormulaValue());
            valueItem.setProperty("isNumber", row.isNumber());
            valueItem.setProperty("fitNumber", tempKey[2]);
            valueItem.setProperty("fitDim", tempKey[1]);
            valueItem.setProperty("error", row.getError());
            valueItem.setDataTraceFrom(row.getDataTraceFrom());
        }
    }

    @Override
    protected void afterExecute() {
        String errMsg = (String)this._ctx.getCustomParam("error");
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            throw new KDBizException(errMsg);
        }
    }
}

