/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.OlapOutput;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.gl.GLDataProvider;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GLIntegrateService
extends AbstractIntegrateService {
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private Map<String, MappedGroup> comboGroupMap;
    private final List<String> allSourceKey = new ArrayList<String>();
    private Map<String, String> singleDimMap;
    private Map<String, Integer> srcDimIndex;
    private Map<String, String> lastSrc;
    private Map<String, DynamicObjectCollection> singleMap;
    private final Map<String, String> targetDimMemberMap = new HashMap<String, String>(16);
    private Map<String, List<String>> srcDefaultMap;

    public GLIntegrateService(IIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new GLDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new OlapOutput(this._ctx);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        this.groupComboMappedRow();
        this.initAllSourceKey();
        this.initSrcInfo();
        this.initSrcDefaultMap();
        this.initTargetDefaultMap();
    }

    @Override
    public void execute() {
        this.beforeExecute();
        IDataSet ds = (IDataSet)this._provider.loadData();
        ds.forEach(data -> this.comboGroupMap.forEach((k, group) -> {
            if (!data.get("key").equals(k)) {
                return;
            }
            group.forEach(mappedRow -> this.match((IRow)data, (MappedRow)mappedRow));
        }));
        this._output.output();
        this.afterExecute();
    }

    @Override
    public void match(IRow resultRow, MappedRow mappedRow) {
        Map assgrp = (Map)resultRow.get("assgrp");
        String fetchType = null;
        ValueItem valueItem = new ValueItem();
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(3);
        flagMap.put("isIgnore", false);
        flagMap.put("targetMemberExist", true);
        HashMap<String, Object> srcInfo = new HashMap<String, Object>(16);
        for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
            DimMappedRelation.SingleDimRelationPair singlePair;
            String string = src.getMappedDim().getMappedKey();
            String srcNumber = src.getNumber();
            if ("AccountBookType".equals(string) || "AccountTable".equals(string) || "OrgView".equals(string) || "ReClassParam".equals(string)) continue;
            if ("ChangeType".equalsIgnoreCase(string)) {
                fetchType = srcNumber;
                continue;
            }
            Object value = null;
            if ("AccountView".equals(string)) {
                value = (String)resultRow.get("number");
            } else if (assgrp != null && assgrp.containsKey(string)) {
                if (assgrp.get(string) == null) {
                    if (!ALL.equals(srcNumber)) {
                        return;
                    }
                } else {
                    value = (String)((Map)assgrp.get(string)).get("number");
                }
            }
            if (value != null) {
                if (!ALL.equals(srcNumber) && !FilterFactory.getFilter(src, this._ctx).isMatched(src, (String)value, this._ctx)) {
                    return;
                }
                srcInfo.put(string, value);
            }
            if ((singlePair = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId())) == null) continue;
            String targetDimension = singlePair.getTargetDimItem().getDimItem().getNumber();
            String targetMember = mappedRow.getTargMapped().get(targetDimension).getNumber();
            if (IGNORE.equalsIgnoreCase(targetMember)) {
                return;
            }
            if (ALL.equals(targetMember)) {
                if (value == null) {
                    return;
                }
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)targetDimension, (String)value);
                if (m == null) {
                    return;
                }
                valueItem.setProperty(targetDimension, m.getNumber());
                continue;
            }
            valueItem.setProperty(targetDimension, targetMember);
        }
        if (resultRow.get(fetchType) == null) {
            return;
        }
        int allSourceSize = this.allSourceKey.size();
        if (allSourceSize > mappedRow.getSrcMapped().size()) {
            ArrayList mappedRowKey = new ArrayList(10);
            for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
                mappedRowKey.add(src.getMappedDim().getMappedKey());
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(16);
            ArrayList<String> emptySrc = new ArrayList<String>(CollectionUtils.disjunction(this.allSourceKey, (Collection)mappedRowKey));
            emptySrc.sort(Comparator.comparingInt(o -> this.srcDimIndex.getOrDefault(o, 9999)));
            for (String srcDim : emptySrc) {
                String srcMember = null;
                String targetDimension = this.singleDimMap.get(srcDim);
                boolean existTarget = this.singleDimMap.containsKey(srcDim);
                if (hashMap.getOrDefault(targetDimension, false).booleanValue()) continue;
                if ("Currency".equals(srcDim)) {
                    srcMember = (String)resultRow.get("currency");
                } else if (assgrp == null || !assgrp.containsKey(srcDim)) {
                    if (existTarget && valueItem.getProperty(targetDimension) == null) {
                        valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                    }
                } else if (assgrp.get(srcDim) != null) {
                    srcMember = (String)((Map)assgrp.get(srcDim)).get("number");
                } else if (existTarget && valueItem.getProperty(targetDimension) == null) {
                    valueItem.setProperty(targetDimension, this.targetDimMemberMap.get(targetDimension));
                }
                if (srcMember == null) {
                    srcInfo.put(srcDim, null);
                    continue;
                }
                if (existTarget) {
                    DynamicObjectCollection col = this.singleMap.get(srcDim);
                    if (this.matchSingleMemMap(srcMember, (List<DynamicObject>)col, valueItem, targetDimension, flagMap)) {
                        hashMap.put(targetDimension, true);
                    } else if (srcDim.equals(this.lastSrc.get(targetDimension))) {
                        return;
                    }
                }
                srcInfo.put(srcDim, srcMember);
            }
        }
        for (Map.Entry entry : this.srcDefaultMap.entrySet()) {
            String key = (String)entry.getKey();
            if (srcInfo.containsKey(key) || assgrp == null || !assgrp.containsKey(key)) continue;
            if (assgrp.get(key) == null) {
                return;
            }
            String srcMember = (String)((Map)assgrp.get(key)).get("number");
            if (!((List)entry.getValue()).contains(srcMember)) {
                return;
            }
            srcInfo.put(key, srcMember);
        }
        if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
            ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
            boolean bl = mappedRow.isNegate();
            BigDecimal amount = resultRow.get(fetchType) instanceof BigDecimal ? (BigDecimal)resultRow.get(fetchType) : new BigDecimal(resultRow.get(fetchType).toString());
            valueItem.setValue(bl ? amount.negate() : amount);
            valueItem.setProperty("Currency", this._ctx.getCurrency().p2);
            vl.addValue(valueItem);
        }
    }

    private boolean matchSingleMemMap(String srcMember, List<DynamicObject> issinglemap, ValueItem valueItem, String targetDim, Map<String, Boolean> flagMap) {
        boolean matchSingle = false;
        if (issinglemap == null) {
            return false;
        }
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        for (DynamicObject isObject : issinglemap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && ALL.equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null) continue;
            if (StringUtils.isEmpty((CharSequence)srcMember)) {
                return false;
            }
            if (sourceItem != null && !ALL.equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, srcMember, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
                continue;
            }
            if (ALL.equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)targetDim, (String)srcMember);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            String targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue();
            if ("".equals(targetNumber)) {
                flagMap.put("targetMemberExist", false);
            } else if (IGNORE.equals(targetNumber)) {
                flagMap.put("isIgnore", true);
            }
            valueItem.setProperty(targetDim, targetNumber);
            matchSingle = true;
        }
        return matchSingle;
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        return new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, mainscope, false, false);
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        List<MappedGroup> groups = this._ctx.getCombineMappedGroup();
        groups.forEach(g -> g.forEach(row -> {
            MappedSourceItem fetchType = row.getSrcMapped().get("ChangeType");
            String number = fetchType.getNumber().split("\\|")[0].toLowerCase(Locale.ENGLISH);
            fetchType.setNumber(number);
        }));
        return groups;
    }

    private void groupComboMappedRow() {
        this.comboGroupMap = new HashMap<String, MappedGroup>(16);
        this._ctx.getCombineMappedGroup().forEach(e -> e.forEach(mappedRow -> {
            String key = IntegrationUtil.getMappedKey(mappedRow);
            this.comboGroupMap.computeIfAbsent(key, g -> new MappedGroup());
            MappedGroup group = this.comboGroupMap.get(key);
            group.addMappedRow((MappedRow)mappedRow);
        }));
    }

    private void initAllSourceKey() {
        for (Map.Entry<Long, MappedDimItem> aSource : this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().entrySet()) {
            this.allSourceKey.add(aSource.getValue().getMappedKey());
        }
    }

    private void initSrcInfo() {
        QFilter filter = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        DynamicObject[] baseents = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> baseentMap = new HashMap<Long, String>(16);
        for (DynamicObject ent : baseents) {
            baseentMap.put(ent.getLong("id"), ent.getString("number"));
        }
        DynamicObject[] dimMap = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"sequence,mappedtype,isdimmapsrcentry.srcdimension, isdimmaptargentry.tagdimension", (QFilter[])new QFilter[]{filter}, (String)"sequence");
        this.singleDimMap = new HashMap<String, String>();
        this.srcDimIndex = new HashMap<String, Integer>(16);
        this.lastSrc = new HashMap<String, String>(16);
        for (DynamicObject dot : dimMap) {
            if (dot.getInt("mappedtype") != 1) continue;
            long targetId = ((DynamicObject)dot.getDynamicObjectCollection("isdimmaptargentry").get(0)).getLong("tagdimension_id");
            long srcId = ((DynamicObject)dot.getDynamicObjectCollection("isdimmapsrcentry").get(0)).getLong("srcdimension_id");
            String src = (String)baseentMap.get(srcId);
            String target = MemberReader.getDimensionNumById((long)targetId);
            this.singleDimMap.put(src, target);
            this.srcDimIndex.put(src, dot.getInt("sequence"));
            this.lastSrc.put(target, src);
        }
        filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        DynamicObject[] allSingleMap = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"scope,dimmapid,targmembnumber,srcmembnumber,issinglemapentry.srcdim,issinglemapentry.srcmemnumber,issinglemapentry.srcmembid,issinglemapentry.seq", (QFilter[])new QFilter[]{filter});
        this.singleMap = new HashMap<String, DynamicObjectCollection>();
        for (DynamicObject e : allSingleMap) {
            Long srcDimId = ((DynamicObject)e.getDynamicObjectCollection("issinglemapentry").get(0)).getLong("srcdim");
            String srcDimNum = (String)baseentMap.get(srcDimId);
            this.singleMap.computeIfAbsent(srcDimNum, k -> new DynamicObjectCollection());
            DynamicObjectCollection col = this.singleMap.get(srcDimNum);
            col.add((Object)e);
        }
    }

    private void initSrcDefaultMap() {
        this.srcDefaultMap = new HashMap<String, List<String>>();
        this._ctx.getSourceDefaultValsMap().values().forEach(e -> {
            String key = e.getDimItem().getNumber();
            this.srcDefaultMap.computeIfAbsent(key, k -> new ArrayList());
            List<String> members = this.srcDefaultMap.get(key);
            e.getDefVals().forEach(p -> members.add(p.getNumber()));
        });
    }

    private void initTargetDefaultMap() {
        QFilter filter = new QFilter("model", "=", this._ctx.getModel().p1);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,shortnumber", (QFilter[])new QFilter[]{filter});
        HashMap number2Short = new HashMap();
        dims.forEach(e -> number2Short.put(e.getString("number"), e.getString("shortnumber")));
        Set asstNums = (Set)IntegrationUtil.getAsstInSingle((IIntegrateContext)this._ctx).p1;
        this.singleDimMap.forEach((src, target) -> {
            if (asstNums.stream().anyMatch(p -> p.equalsIgnoreCase((String)src))) {
                if (target.equals("InternalCompany")) {
                    this.targetDimMemberMap.put((String)target, "ICNone");
                } else {
                    this.targetDimMemberMap.put((String)target, (String)number2Short.get(target) + "None");
                }
            }
        });
    }
}

