/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.JVMShutdownHook;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.IntegrationServiceHelper;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.ctx.IntegrateContext;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.service.IntegrationNewServiceHelper;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.CustOperationContexts;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ExecuteOperationEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.enums.integration.NoticeStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class IntegrateDispatcher2 {
    private static final String BATCHNAME = "batchname";
    private static final String SELECT_TEMPLATE = "selecttemplate";
    private static final String SCHEDULELOGID = "scheduleLogId";
    private static final String CALLID = "callId";
    private static final String NOTICELOGID = "noticeLogId";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(IntegrateDispatcher2.class);

    private static void execute(IIntegrateContext ctx, CountDownLatch downLatch) {
        String src = (String)ctx.getCustomParam("issrc");
        IRunner runner = () -> {
            try {
                CustOperationContexts.setCustFormIdForIntegrate();
                IntegrationNewServiceHelper.execute(ctx);
            }
            finally {
                if (downLatch != null) {
                    downLatch.countDown();
                }
            }
        };
        if ("NGACC".equals(src)) {
            ThreadPoolService.runInGlIntegrateThread(runner);
        } else {
            ThreadPoolService.runInIntegrateThread(runner);
        }
    }

    private static void addHook() {
        JVMShutdownHook.addHook(() -> {
            DynamicObject[] exeObjs;
            new ManagedThreadFeature().start();
            QFilter statusFilter = new QFilter("collectstatus", "=", (Object)Integer.toString(CollectStatusEnum.RUNNING.getValue()));
            for (DynamicObject dynObj : exeObjs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, model, fy, period, collectstatus, modifydate, modifier, endtime,currency,scenario", (QFilter[])new QFilter[]{statusFilter})) {
                dynObj.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
                dynObj.set("modifydate", (Object)(dynObj.getDate("modifydate") == null ? new Date() : dynObj.getDate("modifydate")));
                dynObj.set("endtime", (Object)dynObj.getDate("modifydate"));
            }
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.save((DynamicObject[])exeObjs, (OperateOption)op);
            IntegrateDispatcher2.writeExecuteLogs(exeObjs, ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u5df2\u5173\u95ed\u6216\u505c\u6b62\uff0c\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3002", (String)"IntegrateDispatcher2_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        });
    }

    private static void writeExecuteLogs(DynamicObject[] recDyns, String errorMsg) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        for (DynamicObject recDyn : recDyns) {
            DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", (Object)recDyn.getDynamicObject("model").getLong("id"));
            dyObj.set("fy", (Object)recDyn.getDynamicObject("fy").getLong("id"));
            dyObj.set("period", (Object)recDyn.getDynamicObject("period").getLong("id"));
            dyObj.set("currency", (Object)recDyn.getDynamicObject("currency").getLong("id"));
            dyObj.set("scenario", (Object)recDyn.getDynamicObject("scenario").getLong("id"));
            dyObj.set("org", (Object)(recDyn.getLong("org_id") == 0L ? recDyn.getLong("org") : recDyn.getLong("org_id")));
            dyObj.set("scheme", (Object)(recDyn.getLong("scheme_id") == 0L ? recDyn.getLong("scheme") : recDyn.getLong("scheme_id")));
            dyObj.set("dimmembers", (Object)" ");
            dyObj.set("datafrom", (Object)" ");
            dyObj.set("error", (Object)errorMsg);
            dyObj.set("result", (Object)" ");
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collectorstate", (Object)CollectStatusEnum.FAIL.getValue());
            dyObj.set("collecttime", (Object)TimeServiceHelper.now());
            dyObj.set("executerec", (Object)recDyn.getLong("id"));
            dyObj.set("step", (Object)"A");
            logs.add(dyObj);
        }
        SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
    }

    public static boolean submitTask2(IntegrateEntity intEntity, boolean isSync, Consumer<IIntegrateContext> consumer) {
        return IntegrateDispatcher2.submitTask2(intEntity, isSync, false, consumer);
    }

    public static boolean submitTask2(IntegrateEntity intEntity, boolean isSync, boolean isEntryIntergate, Consumer<IIntegrateContext> consumer) {
        HashMap<String, DynamicObject> logSchemeMapping;
        CountDownLatch downLatch;
        HashMap schemeServicesMapping;
        Map<Long, DynamicObject> schemes;
        Map<Long, Pair<Long, String>> currencys;
        HashMap orgNumMap;
        Boolean isFromSchedule;
        Pair<Long, String> currency;
        Pair<Long, String> period;
        Pair<Long, String> year;
        Pair<Long, String> scene;
        Pair<Long, String> model;
        block38: {
            IntegrateDispatcher2.handleOrgWritePermission(intEntity);
            IntegrateDispatcher2.handlePeriodManager(intEntity);
            IntegrateDispatcher2.handleMergeECFlowstatusOfOrgs(intEntity);
            IntegrateDispatcher2.handleEntVersion(intEntity);
            if (intEntity.getOrgSchemePairs().size() == 0) {
                return true;
            }
            model = intEntity.getModel();
            scene = intEntity.getScene();
            year = intEntity.getYear();
            period = intEntity.getPeriod();
            currency = intEntity.getCurrency();
            Set<Long> orgSet = intEntity.getOrgs();
            Set<Long> schemeSet = intEntity.getSchemes();
            isFromSchedule = intEntity.getIsFromSchedule();
            orgNumMap = new HashMap(16);
            if (isFromSchedule.booleanValue()) {
                intEntity.getOrgSchemePairs().forEach(p -> orgNumMap.put(((Pair)p.p1).p1, ((Pair)p.p1).p2));
            }
            currencys = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)model.p1, orgSet.toArray(new Long[0]));
            DynamicObject[] schemeArray = BusinessDataServiceHelper.load((Object[])schemeSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme"));
            schemes = Stream.of(schemeArray).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            schemeServicesMapping = new HashMap();
            schemes.values().forEach(scheme -> {
                List<Class<? extends AbstractIntegrateService>> integrateService = IntegrateDispatcher2.getIntegrateService(scheme);
                schemeServicesMapping.put(scheme.getLong("id"), integrateService);
            });
            downLatch = null;
            if (isSync) {
                int sizeCount = orgSet.size() == 1 ? schemeServicesMapping.values().stream().map(List::size).reduce(Integer::sum).orElse(0) : orgSet.size() * ((List)schemeServicesMapping.values().iterator().next()).size();
                downLatch = new CountDownLatch(sizeCount);
            }
            logSchemeMapping = new HashMap<String, DynamicObject>();
            DLock lock = DLock.create((String)("IntegrateDispatcher2." + (String)model.p2 + (String)scene.p2 + (String)year.p2 + (String)period.p2));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = IntegrateDispatcher2.getExecuteLogs(intEntity, (Long)currency.p1, model, year, period, orgSet, schemeSet, true, scene);
                    Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), (DynamicObject)v));
                    ArrayList<DynamicObject> saveObj = new ArrayList<DynamicObject>();
                    for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
                        Pair schemePair = (Pair)pair.p2;
                        Pair org = (Pair)pair.p1;
                        String schemeKey = (String)org.p2 + (String)schemePair.p2;
                        DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
                        if (logDyn != null) continue;
                        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
                        dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        dynaObj.set("model", model.p1);
                        dynaObj.set("scheme", schemePair.p1);
                        dynaObj.set("org", org.p1);
                        dynaObj.set("scenario", scene.p1);
                        dynaObj.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
                        dynaObj.set("step", (Object)(isEntryIntergate ? ExecuteOperationEnum.ENTRY_INTEGRATION.getValue() : ExecuteOperationEnum.ACTION_COLLECT.getValue()));
                        if (intEntity.getCustomParam(BATCHNAME) != null) {
                            dynaObj.set("batch", intEntity.getCustomParam(BATCHNAME));
                        }
                        dynaObj.set("collectstatus", (Object)CollectStatusEnum.LINEUP.getValue());
                        dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                        dynaObj.set("optime", (Object)new Date());
                        dynaObj.set("endtime", null);
                        dynaObj.set("fy", year.p1);
                        dynaObj.set("period", period.p1);
                        dynaObj.set("currency", currency.p1);
                        dynaObj.set("paramjson", (Object)" ");
                        saveObj.add(dynaObj);
                        logSchemeMapping.put(schemeKey, dynaObj);
                    }
                    if (saveObj.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
                    }
                    break block38;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        ConcurrentHashMap<String, Integer> schemeServices = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, Integer> schemeServicesFail = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, String> schemeServicesFailMsg = new ConcurrentHashMap<String, String>(3);
        ConcurrentHashMap insertCount = new ConcurrentHashMap(3);
        ConcurrentHashMap schemeServicesLockDim = new ConcurrentHashMap(16);
        List<Long> rateOrgIdList = IntegrationUtil.getRateOrgIdList((Long)model.p1);
        List<Pair<Long, String>> currency4Rate = intEntity.getCurrency4Rate();
        int cnt = 0;
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u524d\u6e05\u6570\u5931\u8d25\u3002", (String)"IntegrateDispatcher2_7", (String)"fi-bcm-business", (Object[])new Object[0]);
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            Pair schemePair = (Pair)pair.p2;
            DynamicObject dynamicObject = schemes.get(((Pair)pair.p2).p1);
            if (IntegrateProductEnum.XExtendProduct.getNumber().equals(dynamicObject.getString("issrc.number"))) {
                ++cnt;
                continue;
            }
            Pair org = (Pair)pair.p1;
            Pair<Long, String> cur = rateOrgIdList.contains(org.p1) ? currency4Rate.get(cnt++) : currencys.get(org.p1);
            try {
                if (intEntity.getCustomParam(SELECT_TEMPLATE) == null) {
                    IntegrateDispatcher2.clearDataByImportMode(model, (Pair<Long, String>)schemePair, cur, year, period, (Pair<Long, String>)org, scene);
                }
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    errorInfo = e.getMessage();
                }
                orgSchemePairsNotNeed.add(pair);
                log.error(String.format("org:[%1$s],scheme:[%2$s] clearDataByImportMode fail.", ((Pair)pair.p1).p2, ((Pair)pair.p2).p2), (Throwable)e);
            }
            orgSchemePairsNeed.add(pair);
        }
        if (orgSchemePairsNotNeed.size() > 0) {
            orgSchemePairsNeed.removeAll(orgSchemePairsNotNeed);
            IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, errorInfo);
            intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        }
        cnt = 0;
        Map<Long, List<Pair>> pairMap = intEntity.getOrgSchemePairs().stream().collect(Collectors.groupingBy(l -> (Long)((Pair)l.p1).p1));
        HashSet<Long> logSet = new HashSet<Long>(16);
        for (Map.Entry entry : pairMap.entrySet()) {
            intEntity.setOrgSchemePairs((List)entry.getValue());
            IntegrateDispatcher2.createNoticeStatusLog(logSchemeMapping, false, intEntity);
            Long callId = (Long)intEntity.getCustomParam(CALLID);
            Map<Long, Long> noticeStatusLogMap = IntegrateDispatcher2.queryNoticeStatusLog(callId);
            for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
                String serviceSchemeKeyLockDim;
                Map lockMap;
                String serviceSchemeKeyFailMsg;
                String serviceNumbFailMsg;
                String serviceSchemeKeyFail;
                Integer serviceNumbFail;
                DynamicObject scheme3 = schemes.get(((Pair)pair.p2).p1);
                Pair schemePair = (Pair)pair.p2;
                Pair org = (Pair)pair.p1;
                DynamicObject isSchemeSys = scheme3.getDynamicObject("isscheme");
                Pair<Long, String> cur = rateOrgIdList.contains(org.p1) ? currency4Rate.get(cnt++) : currencys.get(org.p1);
                List services = (List)schemeServicesMapping.get(scheme3.getLong("id"));
                String schemeKey = (String)org.p2 + (String)schemePair.p2;
                DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
                logSet.add(logDyn.getLong("id"));
                String serviceSchemeKey = schemeKey + (String)cur.p2;
                Integer serviceNumb = (Integer)schemeServices.get(serviceSchemeKey);
                if (serviceNumb == null) {
                    schemeServices.put(serviceSchemeKey, services.size());
                }
                if ((serviceNumbFail = (Integer)schemeServicesFail.get(serviceSchemeKeyFail = serviceSchemeKey + "fail")) == null) {
                    schemeServicesFail.put(serviceSchemeKeyFail, 0);
                }
                if ((serviceNumbFailMsg = (String)schemeServicesFailMsg.get(serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg")) == null) {
                    schemeServicesFailMsg.put(serviceSchemeKeyFailMsg, "");
                }
                if ((lockMap = (Map)schemeServicesLockDim.get(serviceSchemeKeyLockDim = serviceSchemeKey + "lockDim")) == null) {
                    schemeServicesLockDim.put(serviceSchemeKeyLockDim, new ConcurrentHashMap(16));
                }
                for (Class as : services) {
                    try {
                        IntegrateContext context = new IntegrateContext(model, (Pair<Long, String>)schemePair, cur, scene, year, period, (Pair<Long, String>)org, as);
                        context.putCustomParam("SYSTEM_VERSION", isSchemeSys == null ? null : isSchemeSys.getString("version"));
                        context.putCustomParam("SYSTEM_SSID", isSchemeSys == null ? null : Long.valueOf(isSchemeSys.getLong("id")));
                        context.putCustomParam("BalType", 5);
                        context.putCustomParam("issrc", scheme3.getString("issrc.number"));
                        context.putCustomParam("currency", currency);
                        context.putCustomParam("org2currency", currencys);
                        context.putCustomParam("scene", scene);
                        context.putCustomParam("log", logDyn);
                        context.putCustomParam("ssid", isSchemeSys == null ? null : Long.valueOf(isSchemeSys.getLong("id")));
                        context.putCustomParam("servicenum", schemeServices);
                        context.putCustomParam("servicefailnum", schemeServicesFail);
                        context.putCustomParam("servicefailMsg", schemeServicesFailMsg);
                        context.putCustomParam("servicetotalnum", services.size());
                        context.putCustomParam("insertCount", insertCount);
                        context.putCustomParam("schemeServicesLockDim", schemeServicesLockDim);
                        context.putCustomParam("middlelib", scheme3.get("middlelib") == null ? null : ((DynamicObject)scheme3.get("middlelib")).getString("number"));
                        if (noticeStatusLogMap.get(logDyn.getLong("id")) != null) {
                            context.putCustomParam(NOTICELOGID, noticeStatusLogMap.get(logDyn.getLong("id")));
                            context.putCustomParam(CALLID, callId);
                        }
                        context.putCustomParam("consumer", consumer);
                        context.putCustomParam("isFromSchedule", isFromSchedule);
                        if (orgNumMap.size() > 0) {
                            context.putCustomParam("orgNumMap", orgNumMap);
                        }
                        context.putCustomParam("isEntryIntergate", isEntryIntergate);
                        if (intEntity.getCustomParam(BATCHNAME) != null) {
                            context.putCustomParam(BATCHNAME, intEntity.getCustomParam(BATCHNAME));
                        }
                        if (intEntity.getCustomParam(SELECT_TEMPLATE) != null) {
                            context.putCustomParam(SELECT_TEMPLATE, intEntity.getCustomParam(SELECT_TEMPLATE));
                        }
                        IntegrateDispatcher2.execute(context, downLatch);
                    }
                    catch (Exception e) {
                        throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
                    }
                }
            }
        }
        if (isSync && intEntity.getOrgSchemePairs().size() > 0) {
            IFormView currentView = (IFormView)intEntity.getCustomParam("currentView");
            if (currentView != null) {
                AbstractFormPlugin abstractFormPlugin = (AbstractFormPlugin)intEntity.getCustomParam("currentPlugin");
                IntegrateDispatcher2.dispatch(currentView, abstractFormPlugin, logSet);
            } else {
                try {
                    return downLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new KDBizException(ThrowableHelper.toString((Exception)interruptedException));
                }
            }
        }
        return true;
    }

    private static void dispatch(IFormView currentView, AbstractFormPlugin currentPlugin, Set<Long> logSet) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(currentView.getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ReportMultiExportPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.formplugin.intergration.scheme.SubmitIntegrateTask");
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 100);
        params.put("logSet", logSet);
        jobInfo.setParams(params);
        jobInfo.setCanStop(Boolean.valueOf(true));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)currentPlugin, "taskcloseback");
        IntegrateDispatcher2.dispatch(jobInfo, currentView, closeCallBack);
    }

    public static void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(view.getPageId());
        clientJobInfo.setCanStop(true);
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public static boolean submitTaskDistribute(IntegrateEntity intEntity, boolean isSync, boolean isEntryIntergate, Consumer<IIntegrateContext> consumer) {
        HashMap<String, DynamicObject> logSchemeMapping;
        block15: {
            if (isSync) {
                return IntegrateDispatcher2.submitTask2(intEntity, isSync, isEntryIntergate, consumer);
            }
            Pair<List<Pair<Pair<Long, String>, Pair<Long, String>>>, List<Pair<Pair<Long, String>, Pair<Long, String>>>> easOtherPair = IntegrateDispatcher2.getEasOtherPair(intEntity);
            if (((List)easOtherPair.p1).size() > 0) {
                intEntity.setOrgSchemePairs((List)easOtherPair.p1);
                IntegrateDispatcher2.submitTask2(intEntity, isSync, isEntryIntergate, consumer);
            }
            intEntity.setOrgSchemePairs((List)easOtherPair.p2);
            if (intEntity.getOrgSchemePairs().size() == 0) {
                return true;
            }
            IntegrateDispatcher2.handleOrgWritePermission(intEntity);
            IntegrateDispatcher2.handlePeriodManager(intEntity);
            IntegrateDispatcher2.handleMergeECFlowstatusOfOrgs(intEntity);
            IntegrateDispatcher2.handleEntVersion(intEntity);
            if (intEntity.getOrgSchemePairs().size() == 0) {
                return true;
            }
            logSchemeMapping = new HashMap<String, DynamicObject>();
            DLock lock = DLock.create((String)("IntegrateDispatcher2." + (String)intEntity.getModel().p2 + (String)intEntity.getScene().p2 + (String)intEntity.getYear().p2 + (String)intEntity.getPeriod().p2));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = IntegrateDispatcher2.getExecuteLogs(intEntity, (Long)intEntity.getCurrency().p1, intEntity.getModel(), intEntity.getYear(), intEntity.getPeriod(), intEntity.getOrgs(), intEntity.getSchemes(), true, intEntity.getScene());
                    Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), (DynamicObject)v));
                    ArrayList<DynamicObject> saveObj = new ArrayList<DynamicObject>();
                    for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
                        Pair schemePair = (Pair)pair.p2;
                        Pair org = (Pair)pair.p1;
                        String schemeKey = (String)org.p2 + (String)schemePair.p2;
                        DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
                        if (logDyn != null) continue;
                        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
                        dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        dynaObj.set("model", intEntity.getModel().p1);
                        dynaObj.set("scheme", schemePair.p1);
                        dynaObj.set("org", org.p1);
                        dynaObj.set("scenario", intEntity.getScene().p1);
                        dynaObj.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
                        dynaObj.set("step", (Object)(isEntryIntergate ? ExecuteOperationEnum.ENTRY_INTEGRATION.getValue() : ExecuteOperationEnum.ACTION_COLLECT.getValue()));
                        if (intEntity.getCustomParam(BATCHNAME) != null) {
                            dynaObj.set("batch", intEntity.getCustomParam(BATCHNAME));
                        }
                        dynaObj.set("collectstatus", (Object)CollectStatusEnum.LINEUP.getValue());
                        dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                        dynaObj.set("optime", (Object)new Date());
                        dynaObj.set("endtime", null);
                        dynaObj.set("fy", intEntity.getYear().p1);
                        dynaObj.set("period", intEntity.getPeriod().p1);
                        dynaObj.set("currency", intEntity.getCurrency().p1);
                        dynaObj.set("paramjson", (Object)" ");
                        saveObj.add(dynaObj);
                        logSchemeMapping.put(schemeKey, dynaObj);
                    }
                    if (saveObj.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
                    }
                    break block15;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        Long scheduleLogId = (Long)intEntity.getCustomParam(SCHEDULELOGID);
        boolean isFromPlan = IntegrateDispatcher2.checkIsFromPlan(scheduleLogId);
        if (isFromPlan) {
            IntegrateDispatcher2.createScheduleStatusLog(scheduleLogId, logSchemeMapping);
        }
        Map<Long, List<Pair>> pairMap = intEntity.getOrgSchemePairs().stream().collect(Collectors.groupingBy(l -> (Long)((Pair)l.p1).p1));
        pairMap.values().forEach(pairlist -> {
            intEntity.setOrgSchemePairs((List<Pair<Pair<Long, String>, Pair<Long, String>>>)pairlist);
            IntegrateDispatcher2.createNoticeStatusLog(logSchemeMapping, !isFromPlan, intEntity);
            MQCommonPublisher.publishDataIntegration((String)ObjectSerialUtil.toByteSerialized((Object)intEntity), (boolean)isEntryIntergate, (boolean)ConfigServiceHelper.getGlobalBoolParam("isUseSpecialService"));
        });
        return true;
    }

    private static boolean checkIsFromPlan(Long scheduleLogId) {
        return scheduleLogId != null && 0L != scheduleLogId;
    }

    private static void createNoticeStatusLog(Map<String, DynamicObject> logSchemeMapping, boolean isNeedNotify, IntegrateEntity intEntity) {
        long callId = GlobalIdUtil.genGlobalLongId();
        Set<Long> needCalculateSchemes = IntegrateDispatcher2.getNeedCalculateSchemes(intEntity.getSchemes());
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(logSchemeMapping.size());
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            String schemeKey = (String)((Pair)pair.p1).p2 + (String)((Pair)pair.p2).p2;
            DynamicObject schemeLog = logSchemeMapping.get(schemeKey);
            boolean isNeedCalculate = needCalculateSchemes.contains(((Pair)pair.p2).p1);
            if (schemeLog == null || !isNeedNotify && !isNeedCalculate) continue;
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_integration_notice");
            long schemeLogId = schemeLog.getLong("id");
            log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            log.set("callid", (Object)callId);
            log.set("integrateexeclog", (Object)schemeLogId);
            log.set("userid", (Object)RequestContext.get().getCurrUserId());
            log.set("noticestatus", (Object)(isNeedNotify ? NoticeStatusEnum.NOT_NOTIFIED.getValue() : NoticeStatusEnum.NOT_NEED_NOTIFY.getValue()));
            log.set("calculatestatus", (Object)(isNeedCalculate ? NoticeStatusEnum.NOT_CALCULATED.getValue() : NoticeStatusEnum.NOT_NEED_CALCULATE.getValue()));
            log.set("exestatus", (Object)CollectStatusEnum.RUNNING.getValue());
            log.set("createdate", (Object)new Date());
            logs.add(log);
        }
        if (!logs.isEmpty()) {
            intEntity.putCustomParam(CALLID, callId);
            SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
        }
    }

    private static Set<Long> getNeedCalculateSchemes(Set<Long> schemes) {
        QFilter idQf = new QFilter("id", "in", schemes);
        QFilter calculateQf = new QFilter("calculate", "=", (Object)true);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{idQf, calculateQf});
        HashSet<Long> resIds = new HashSet<Long>();
        ids.forEach(e -> resIds.add(e.getLong("id")));
        return resIds;
    }

    private static void handleEntVersion(IntegrateEntity intEntity) {
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        orgSchemePairs.forEach(p -> {
            boolean isEnver = MergeControlHelper.isQuoteLocked((Long)intEntity.getModel().p1, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, (Long)((Pair)p.p1).p1);
            if (isEnver) {
                orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            } else {
                orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            }
        });
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u7248\u672c\u5316\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"IntegrateDispatcher2_6", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static void createScheduleStatusLog(Long scheduleLogId, Map<String, DynamicObject> logSchemeMapping) {
        ArrayList logs = new ArrayList(logSchemeMapping.size());
        logSchemeMapping.values().forEach(schemeLog -> {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schedule_statuslog");
            long schemeLogId = schemeLog.getLong("id");
            log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            log.set("integrateexeclog", (Object)schemeLogId);
            log.set("schedulelog", (Object)scheduleLogId);
            log.set("status", (Object)CollectStatusEnum.LINEUP.getValue());
            logs.add(log);
        });
        if (!logs.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
        }
    }

    private static Map<Long, Long> queryScheduleStatusLog(Long scheduleLogId) {
        HashMap<Long, Long> scheduleLogMap = new HashMap<Long, Long>(16);
        if (scheduleLogId != null && 0L != scheduleLogId) {
            DynamicObject[] logs;
            QFBuilder builder = new QFBuilder("schedulelog", "=", (Object)scheduleLogId);
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"bcm_schedule_statuslog", (String)"id,integrateexeclog,status", (QFilter[])builder.toArray())) {
                scheduleLogMap.put(log.getLong("integrateexeclog.id"), log.getLong("id"));
            }
        }
        return scheduleLogMap;
    }

    private static Pair<List<Pair<Pair<Long, String>, Pair<Long, String>>>, List<Pair<Pair<Long, String>, Pair<Long, String>>>> getEasOtherPair(IntegrateEntity intEntity) {
        Set<Long> schemes = intEntity.getSchemes();
        QFilter idQf = new QFilter("id", "in", schemes);
        QFilter srcQf = new QFilter("issrc.number", "=", (Object)IntegrateProductEnum.EASREPProduct.getNumber());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{idQf, srcQf});
        schemes.clear();
        for (DynamicObject dynamicObject : load) {
            schemes.add(dynamicObject.getLong("id"));
        }
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> easList = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> otherList = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            if (schemes.contains(((Pair)pair.p2).p1)) {
                easList.add(pair);
                continue;
            }
            otherList.add(pair);
        }
        return Pair.onePair(easList, otherList);
    }

    public static boolean submitTaskConsume(IntegrateEntity intEntity, boolean isEntryIntergate) {
        Pair org;
        Pair<Long, String> model = intEntity.getModel();
        Pair<Long, String> scene = intEntity.getScene();
        Pair<Long, String> year = intEntity.getYear();
        Pair<Long, String> period = intEntity.getPeriod();
        Pair<Long, String> currency = intEntity.getCurrency();
        Set<Long> orgSet = intEntity.getOrgs();
        Set<Long> schemeSet = intEntity.getSchemes();
        Boolean isFromSchedule = intEntity.getIsFromSchedule();
        HashMap orgNumMap = new HashMap(16);
        if (isFromSchedule.booleanValue()) {
            intEntity.getOrgSchemePairs().forEach(p -> orgNumMap.put(((Pair)p.p1).p1, ((Pair)p.p1).p2));
        }
        Map<Long, Pair<Long, String>> currencys = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)model.p1, orgSet.toArray(new Long[0]));
        DynamicObject[] schemeArray = BusinessDataServiceHelper.load((Object[])schemeSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme"));
        Map<Long, DynamicObject> schemes = Stream.of(schemeArray).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap schemeServicesMapping = new HashMap();
        schemes.values().forEach(scheme -> {
            List<Class<? extends AbstractIntegrateService>> integrateService = IntegrateDispatcher2.getIntegrateService(scheme);
            schemeServicesMapping.put(scheme.getLong("id"), integrateService);
        });
        DynamicObject[] existLogs = IntegrateDispatcher2.getExecuteLogs(intEntity, (Long)currency.p1, model, year, period, orgSet, schemeSet, false, scene);
        HashMap logSchemeMapping = new HashMap();
        Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), v));
        Long scheduleLogId = (Long)intEntity.getCustomParam(SCHEDULELOGID);
        Map<Long, Long> scheduleStatusLogMap = IntegrateDispatcher2.queryScheduleStatusLog(scheduleLogId);
        Long callId = (Long)intEntity.getCustomParam(CALLID);
        Map<Long, Long> noticeStatusLogMap = IntegrateDispatcher2.queryNoticeStatusLog(callId);
        ConcurrentHashMap<String, Integer> schemeServices = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, Integer> schemeServicesFail = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, String> schemeServicesFailMsg = new ConcurrentHashMap<String, String>(3);
        ConcurrentHashMap insertCount = new ConcurrentHashMap(3);
        ConcurrentHashMap schemeServicesLockDim = new ConcurrentHashMap(16);
        List<Long> rateOrgIdList = IntegrationUtil.getRateOrgIdList((Long)model.p1);
        List<Pair<Long, String>> currency4Rate = intEntity.getCurrency4Rate();
        int cnt = 0;
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u91c7\u96c6\u524d\u6e05\u6570\u5931\u8d25\u3002", (String)"IntegrateDispatcher2_7", (String)"fi-bcm-business", (Object[])new Object[0]);
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            Pair schemePair = (Pair)pair.p2;
            DynamicObject scheme2 = schemes.get(((Pair)pair.p2).p1);
            if (IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme2.getString("issrc.number"))) {
                ++cnt;
                continue;
            }
            org = (Pair)pair.p1;
            Pair<Long, String> cur = rateOrgIdList.contains(org.p1) ? currency4Rate.get(cnt++) : currencys.get(org.p1);
            try {
                if (intEntity.getCustomParam(SELECT_TEMPLATE) == null) {
                    IntegrateDispatcher2.clearDataByImportMode(model, (Pair<Long, String>)schemePair, cur, year, period, (Pair<Long, String>)org, scene);
                }
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    errorInfo = e.getMessage();
                }
                orgSchemePairsNotNeed.add(pair);
                log.error(String.format("org:[%1$s],scheme:[%2$s] clearDataByImportMode fail.", ((Pair)pair.p1).p2, ((Pair)pair.p2).p2), (Throwable)e);
            }
            orgSchemePairsNeed.add(pair);
        }
        if (orgSchemePairsNotNeed.size() > 0) {
            orgSchemePairsNeed.removeAll(orgSchemePairsNotNeed);
            IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, errorInfo);
            intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        }
        cnt = 0;
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            String serviceSchemeKeyLockDim;
            Map lockMap;
            String serviceSchemeKeyFailMsg;
            String serviceNumbFailMsg;
            String serviceSchemeKeyFail;
            Integer serviceNumbFail;
            DynamicObject scheme3 = schemes.get(((Pair)pair.p2).p1);
            Pair schemePair = (Pair)pair.p2;
            org = (Pair)pair.p1;
            DynamicObject isSchemeSys = scheme3.getDynamicObject("isscheme");
            Pair<Long, String> cur = rateOrgIdList.contains(org.p1) ? currency4Rate.get(cnt++) : currencys.get(org.p1);
            List services = (List)schemeServicesMapping.get(scheme3.getLong("id"));
            String schemeKey = (String)org.p2 + (String)schemePair.p2;
            DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
            String serviceSchemeKey = schemeKey + (String)cur.p2;
            Integer serviceNumb = (Integer)schemeServices.get(serviceSchemeKey);
            if (serviceNumb == null) {
                schemeServices.put(serviceSchemeKey, services.size());
            }
            if ((serviceNumbFail = (Integer)schemeServicesFail.get(serviceSchemeKeyFail = serviceSchemeKey + "fail")) == null) {
                schemeServicesFail.put(serviceSchemeKeyFail, 0);
            }
            if ((serviceNumbFailMsg = (String)schemeServicesFailMsg.get(serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg")) == null) {
                schemeServicesFailMsg.put(serviceSchemeKeyFailMsg, "");
            }
            if ((lockMap = (Map)schemeServicesLockDim.get(serviceSchemeKeyLockDim = serviceSchemeKey + "lockDim")) == null) {
                schemeServicesLockDim.put(serviceSchemeKeyLockDim, new ConcurrentHashMap(16));
            }
            for (Class as : services) {
                try {
                    IntegrateContext context = new IntegrateContext(model, (Pair<Long, String>)schemePair, cur, scene, year, period, (Pair<Long, String>)org, as);
                    context.putCustomParam("SYSTEM_VERSION", isSchemeSys == null ? null : isSchemeSys.getString("version"));
                    context.putCustomParam("SYSTEM_SSID", isSchemeSys == null ? null : Long.valueOf(isSchemeSys.getLong("id")));
                    context.putCustomParam("BalType", 5);
                    context.putCustomParam("issrc", scheme3.getString("issrc.number"));
                    context.putCustomParam("currency", currency);
                    context.putCustomParam("org2currency", currencys);
                    context.putCustomParam("scene", scene);
                    context.putCustomParam("log", logDyn);
                    if (scheduleStatusLogMap.get(logDyn.getLong("id")) != null) {
                        context.putCustomParam("scheduleLog", scheduleStatusLogMap.get(logDyn.getLong("id")));
                    }
                    if (noticeStatusLogMap.get(logDyn.getLong("id")) != null) {
                        context.putCustomParam(NOTICELOGID, noticeStatusLogMap.get(logDyn.getLong("id")));
                        context.putCustomParam(CALLID, callId);
                    }
                    context.putCustomParam("ssid", isSchemeSys == null ? null : Long.valueOf(isSchemeSys.getLong("id")));
                    context.putCustomParam("servicenum", schemeServices);
                    context.putCustomParam("servicefailnum", schemeServicesFail);
                    context.putCustomParam("servicefailMsg", schemeServicesFailMsg);
                    context.putCustomParam("servicetotalnum", services.size());
                    context.putCustomParam("insertCount", insertCount);
                    context.putCustomParam("schemeServicesLockDim", schemeServicesLockDim);
                    context.putCustomParam("middlelib", scheme3.get("middlelib") == null ? null : ((DynamicObject)scheme3.get("middlelib")).getString("number"));
                    context.putCustomParam("consumer", null);
                    context.putCustomParam("isFromSchedule", isFromSchedule);
                    if (orgNumMap.size() > 0) {
                        context.putCustomParam("orgNumMap", orgNumMap);
                    }
                    context.putCustomParam("isEntryIntergate", isEntryIntergate);
                    if (intEntity.getCustomParam(BATCHNAME) != null) {
                        context.putCustomParam(BATCHNAME, intEntity.getCustomParam(BATCHNAME));
                    }
                    if (intEntity.getCustomParam(SELECT_TEMPLATE) != null) {
                        context.putCustomParam(SELECT_TEMPLATE, intEntity.getCustomParam(SELECT_TEMPLATE));
                    }
                    if (intEntity.getCustomParam(SCHEDULELOGID) != null) {
                        context.putCustomParam(SCHEDULELOGID, intEntity.getCustomParam(SCHEDULELOGID));
                    }
                    IntegrateDispatcher2.execute(context, null);
                }
                catch (Exception e) {
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
                }
            }
        }
        return true;
    }

    private static Map<Long, Long> queryNoticeStatusLog(Long callId) {
        HashMap<Long, Long> noticeLogMap = new HashMap<Long, Long>(16);
        if (callId != null && 0L != callId) {
            DynamicObject[] logs;
            QFBuilder builder = new QFBuilder("callid", "=", (Object)callId);
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"bcm_integration_notice", (String)"id,integrateexeclog", (QFilter[])builder.toArray())) {
                noticeLogMap.put(log.getLong("integrateexeclog.id"), log.getLong("id"));
            }
        }
        return noticeLogMap;
    }

    private static void clearDataByImportMode(Pair<Long, String> model, Pair<Long, String> schemePair, Pair<Long, String> cur, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> org, Pair<Long, String> scene) {
        Map<String, Set<String>> dimMembers = IntegrateDispatcher2.getDimMembers(model, schemePair, cur, year, period, org, scene);
        if (!Objects.isNull(dimMembers)) {
            IntegrateDispatcher2.setMoreDimMembers(model, schemePair, dimMembers);
            boolean isHaveEmptyDim = IntegrateDispatcher2.checkHaveEmptyDim(dimMembers);
            if (!isHaveEmptyDim) {
                IntegrationUtil.clearOlapData((String)model.p2, dimMembers);
            }
        }
    }

    private static boolean checkHaveEmptyDim(Map<String, Set<String>> dimMembers) {
        for (Map.Entry<String, Set<String>> map : dimMembers.entrySet()) {
            if (map.getValue() != null && !map.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void setMoreDimMembers(Pair<Long, String> model, Pair<Long, String> schemePair, Map<String, Set<String>> dimMembers) {
        QFilter qf = new QFilter("isscheme", "=", schemePair.p1);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bcm_iscleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        if (configs == null || configs.length == 0) {
            return;
        }
        HashMap<String, DynamicObject> dimTypeMap = new HashMap<String, DynamicObject>();
        DynamicObject dimObj = null;
        Set tempSet = null;
        for (DynamicObject dynamicObject : configs) {
            String dimtype = dynamicObject.getString("dimtype");
            long membId = dynamicObject.getLong("dimmemberid");
            int scope = dynamicObject.getInt("scope");
            String membernumber = dynamicObject.getString("membernumber");
            dimObj = (DynamicObject)dimTypeMap.get(dimtype);
            if (dimObj == null) {
                dimObj = IntegrationUtil.getDimPair((Long)model.p1, dimtype);
                dimTypeMap.put(dimtype, dimObj);
            }
            ArrayList<Long> membIds = new ArrayList<Long>();
            membIds.add(membId);
            if (dimObj == null) {
                throw new KDBizException("dimObj is null,dimtype is " + dimtype);
            }
            Pair<Integer, Map<Object, DynamicObject>> member = IntegrateDispatcher2.getMember(dimObj, membIds);
            Set<Object> queryMemberIdsByRange = new HashSet();
            if ((Integer)member.p1 == 1) {
                queryMemberIdsByRange = QueryMemberDetailsHelper.queryMemberNumbersByRange(dimObj.getString("memberform"), membId, membernumber, scope, ((Long)model.p1).toString(), DetailTypeEnum.MEMBERPERM);
            } else if ((Integer)member.p1 == 2) {
                queryMemberIdsByRange = QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(dimObj.getString("memberform"), membId, membernumber, scope, ((Long)model.p1).toString(), null);
            }
            tempSet = dimMembers.computeIfAbsent(dimtype, k -> new HashSet());
            tempSet.addAll(queryMemberIdsByRange);
        }
    }

    private static Map<String, Set<String>> getDimMembers(Pair<Long, String> model, Pair<Long, String> schemePair, Pair<Long, String> cur, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> org, Pair<Long, String> scene) {
        Long schemaId = (Long)schemePair.p1;
        QFilter qf = new QFilter("scheme", "=", (Object)schemaId);
        qf.and("importmode", "=", (Object)ISImpModeEnum.REPLACEIMPORT.getCode());
        DynamicObject importModeObj = QueryServiceHelper.queryOne((String)"bcm_isimportmode", (String)"importmode, dimension.number", (QFilter[])qf.toArray());
        if (!Objects.isNull(importModeObj)) {
            String dimensionNum = importModeObj.getString("dimension.number");
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemaId);
            qFilter.and("mappedtype", "=", (Object)"2");
            DynamicObject[] tarLackDimMaps = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"isdimmaptargentry,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmaptargdefval,isdimmaptargdefval.targetmemnum", (QFilter[])qFilter.toArray());
            Optional<DynamicObject> tarLack = ISImportModeUtil.getTarLackDimDefEntry(tarLackDimMaps, dimensionNum);
            if (tarLack.isPresent()) {
                Set tarLackValues = tarLack.get().getDynamicObjectCollection("isdimmaptargdefval").stream().map(t -> t.getString("targetmemnum")).collect(Collectors.toSet());
                HashMap<String, Set<String>> dimMembers = new HashMap<String, Set<String>>(16);
                dimMembers.put(DimEntityNumEnum.ENTITY.getNumber(), Sets.newHashSet((Object[])new String[]{(String)org.p2}));
                DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemaId, (String)"bcm_isscheme");
                MappingService service = new MappingService(scheme);
                if (service.isMultiCurrency() && ConfigServiceHelper.getBoolParam((Long)model.p1, "CM031")) {
                    dimMembers.put(DimEntityNumEnum.CURRENCY.getNumber(), Sets.newHashSet((Object[])new String[]{(String)cur.p2, "OC"}));
                    if (service.isFromMidLib()) {
                        ((Set)dimMembers.get(DimEntityNumEnum.CURRENCY.getNumber())).add(cur.p2);
                    }
                } else {
                    dimMembers.put(DimEntityNumEnum.CURRENCY.getNumber(), Sets.newHashSet((Object[])new String[]{(String)cur.p2}));
                }
                dimMembers.put(DimEntityNumEnum.YEAR.getNumber(), Sets.newHashSet((Object[])new String[]{(String)year.p2}));
                dimMembers.put(DimEntityNumEnum.PERIOD.getNumber(), Sets.newHashSet((Object[])new String[]{(String)period.p2}));
                IDNumberTreeNode orgNode = MemberReader.findMemberById((long)((Long)model.p1), (String)"bcm_entitymembertree", (Long)((Long)org.p1));
                dimMembers.put(DimEntityNumEnum.PROCESS.getNumber(), orgNode.isLeaf() ? Sets.newHashSet((Object[])new String[]{"EIRpt"}) : Sets.newHashSet((Object[])new String[]{"EIRpt", "CSTE"}));
                dimMembers.put(dimensionNum, tarLackValues);
                if (scene != null) {
                    dimMembers.put(DimEntityNumEnum.SCENARIO.getNumber(), Sets.newHashSet((Object[])new String[]{(String)scene.p2}));
                }
                return dimMembers;
            }
        }
        return null;
    }

    private static void handleOrgWritePermission(IntegrateEntity intEntity) {
        Set<Long> modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(intEntity.getModel().p1)) {
            return;
        }
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        Long orgDimId = DimensionServiceHelper.getIdByNum("bcm_dimension", (Long)intEntity.getModel().p1, DimEntityNumEnum.ENTITY.getNumber());
        Set<Long> orgIds = orgSchemePairs.stream().map(p -> (Long)((Pair)p.p1).p1).collect(Collectors.toSet());
        Set<Long> writePermissionIds = PermissionServiceImpl.getInstance((Long)intEntity.getModel().p1).matchWritePermMembers(orgDimId, "bcm_entitymembertree", orgIds);
        orgSchemePairs.forEach(p -> {
            if (writePermissionIds.contains(((Pair)p.p1).p1)) {
                orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            } else {
                orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            }
        });
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6b64\u7ec4\u7ec7\u6570\u636e\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntegrateDispatcher2_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static void handlePeriodManager(IntegrateEntity intEntity) {
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)intEntity.getModel().p1, "CM012");
        if (periodManage) {
            List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
            ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
            ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
            if (intEntity.getCustomParam("isEntryIntegrate") == null || !((Boolean)intEntity.getCustomParam("isEntryIntegrate")).booleanValue()) {
                Set<String> orgnumberset = orgSchemePairs.stream().map(x -> (String)((Pair)x.p1).p2).collect(Collectors.toSet());
                Set<String> periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)intEntity.getModel().p1, orgnumberset, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, "datastatus");
                orgSchemePairs.forEach(p -> {
                    if (periodOpenOrgSet.contains(((Pair)p.p1).p2)) {
                        orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                    } else {
                        orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                    }
                });
                intEntity.setOrgSchemePairs(orgSchemePairsNeed);
                IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u672a\u5f00\u542f\u6216\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntegrateDispatcher2_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    private static void handleMergeECFlowstatusOfOrgs(IntegrateEntity intEntity) {
        Set<Long> orgSet = IntegrationUtil.getMergeECFlowstatusOfOrgs((Long)intEntity.getModel().p1, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, intEntity.getOrgs().toArray(new Long[0]));
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        orgSchemePairs.forEach(p -> {
            if (orgSet.contains(((Pair)p.p1).p1)) {
                orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            } else {
                orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            }
        });
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u62a5\u8868\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"IntegrateDispatcher2_2", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static void writeNotNeedExecuteData(IntegrateEntity intEntity, List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed, String errorMsg) {
        if (orgSchemePairsNotNeed.size() > 0) {
            Set orgs = orgSchemePairsNotNeed.stream().map(x -> (Long)((Pair)x.p1).p1).collect(Collectors.toSet());
            Set schemes = orgSchemePairsNotNeed.stream().map(x -> (Long)((Pair)x.p2).p1).collect(Collectors.toSet());
            QFBuilder filters = new QFBuilder();
            filters.add("model", "=", intEntity.getModel().p1);
            filters.add("fy", "=", intEntity.getYear().p1);
            filters.add("period", "=", intEntity.getPeriod().p1);
            filters.add("currency", "=", intEntity.getCurrency().p1);
            filters.add("scenario", "=", intEntity.getScene().p1);
            filters.add("scheme", "in", schemes);
            filters.add("org", "in", orgs);
            DynamicObject[] existRecs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, collectstatus, modifydate, modifier, copyexe, paramjson, endtime", (QFilter[])filters.toArray());
            HashMap recSchemeMapping = new HashMap();
            Stream.of(existRecs).forEach(v -> recSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), v));
            ArrayList<DynamicObject> newReclist = new ArrayList<DynamicObject>();
            for (Pair<Pair<Long, String>, Pair<Long, String>> pair : orgSchemePairsNotNeed) {
                Pair schemePair = (Pair)pair.p2;
                Pair org = (Pair)pair.p1;
                String schemeKey = (String)org.p2 + (String)schemePair.p2;
                DynamicObject recDyn = (DynamicObject)recSchemeMapping.get(schemeKey);
                if (recDyn == null) {
                    DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
                    dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                    dynaObj.set("model", intEntity.getModel().p1);
                    dynaObj.set("scheme", schemePair.p1);
                    dynaObj.set("org", org.p1);
                    dynaObj.set("scenario", intEntity.getScene().p1);
                    dynaObj.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
                    dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                    dynaObj.set("modifydate", (Object)IntegrateDispatcher2.getCurrentDate());
                    dynaObj.set("endtime", (Object)IntegrateDispatcher2.getCurrentDate());
                    dynaObj.set("fy", intEntity.getYear().p1);
                    dynaObj.set("period", intEntity.getPeriod().p1);
                    dynaObj.set("currency", intEntity.getCurrency().p1);
                    dynaObj.set("paramjson", (Object)" ");
                    recDyn = dynaObj;
                    newReclist.add(dynaObj);
                } else {
                    recDyn.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
                    recDyn.set("modifydate", (Object)IntegrateDispatcher2.getCurrentDate());
                    recDyn.set("endtime", (Object)IntegrateDispatcher2.getCurrentDate());
                    recDyn.set("modifier", (Object)RequestContext.get().getUserId());
                }
                IntegrateDispatcher2.writeExecuteLogs(intEntity, recDyn, errorMsg);
            }
            SaveServiceHelper.save((DynamicObject[])newReclist.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])recSchemeMapping.values().toArray(new DynamicObject[0]));
        }
    }

    private static void writeExecuteLogs(IntegrateEntity intEntity, DynamicObject recDyn, String errorMsg) {
        DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
        dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyObj.set("model", intEntity.getModel().p1);
        dyObj.set("fy", intEntity.getYear().p1);
        dyObj.set("period", intEntity.getPeriod().p1);
        dyObj.set("scenario", intEntity.getScene().p1);
        dyObj.set("currency", intEntity.getCurrency().p1);
        dyObj.set("org", (Object)(recDyn.getLong("org_id") == 0L ? recDyn.getLong("org") : recDyn.getLong("org_id")));
        dyObj.set("scheme", (Object)(recDyn.getLong("scheme_id") == 0L ? recDyn.getLong("scheme") : recDyn.getLong("scheme_id")));
        dyObj.set("dimmembers", (Object)" ");
        dyObj.set("datafrom", (Object)" ");
        dyObj.set("error", (Object)errorMsg);
        dyObj.set("result", (Object)" ");
        dyObj.set("collector", (Object)RequestContext.get().getUserId());
        dyObj.set("collectorstate", (Object)CollectStatusEnum.FAIL.getValue());
        dyObj.set("collecttime", (Object)TimeServiceHelper.now());
        dyObj.set("executerec", (Object)recDyn.getLong("id"));
        if (intEntity.getCustomParam("isEntryIntegrate") != null && ((Boolean)intEntity.getCustomParam("isEntryIntegrate")).booleanValue()) {
            dyObj.set("step", (Object)"B");
        } else {
            dyObj.set("step", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
    }

    private static Date getCurrentDate() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static DynamicObject[] getExecuteLogs(IntegrateEntity intEntity, Long curId, Pair<Long, String> model, Pair<Long, String> fy, Pair<Long, String> period, Set<Long> orgs, Set<Long> schemesIds, boolean updateStatus, Pair<Long, String> scene) {
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", model.p1);
        filters.add("fy", "=", fy.p1);
        filters.add("period", "=", period.p1);
        filters.add("currency", "=", (Object)curId);
        filters.add("scenario", "=", scene.p1);
        filters.add("scheme", "in", schemesIds);
        filters.add("org", "in", orgs);
        DynamicObject[] existLogs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, checkstatus, collectstatus, modifydate, modifier, copyexe, paramjson, endtime, optime,exeip", (QFilter[])filters.toArray());
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<DynamicObject> needSave = new ArrayList<DynamicObject>(10);
        for (DynamicObject log : existLogs) {
            for (Pair<Pair<Long, String>, Pair<Long, String>> pair : orgSchemePairs) {
                if (log.getLong("org.id") != ((Long)((Pair)pair.p1).p1).longValue() || log.getLong("scheme.id") != ((Long)((Pair)pair.p2).p1).longValue()) continue;
                log.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
                log.set("collectstatus", (Object)CollectStatusEnum.LINEUP.getValue());
                log.set("optime", (Object)new Date());
                log.set("modifydate", null);
                log.set("endtime", null);
                log.set("modifier", (Object)RequestContext.get().getUserId());
                needSave.add(log);
            }
        }
        DynamicObject[] needSaveLog = needSave.toArray(new DynamicObject[0]);
        if (updateStatus) {
            SaveServiceHelper.save((DynamicObject[])needSaveLog);
        }
        return needSaveLog;
    }

    public static DynamicObject[] getExecuteLogs(Pair<Long, String> currencyObj, Pair<Long, String> model, Pair<Long, String> fy, Pair<Long, String> period, Long orgs, List<Long> schemes, Pair<Long, String> scene) {
        DynamicObject[] existLogs;
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", model.p1);
        filters.add("fy", "=", fy.p1);
        filters.add("period", "=", period.p1);
        filters.add("currency", "=", currencyObj.p1);
        filters.add("scenario", "=", scene.p1);
        filters.add("scheme", "in", schemes);
        filters.add("org", "=", (Object)orgs);
        for (DynamicObject log : existLogs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, checkstatus, collectstatus, modifydate, modifier, copyexe, paramjson, endtime, optime,exeip", (QFilter[])filters.toArray())) {
            if (log.getInt("collectstatus") == CollectStatusEnum.ISCPROCESS.getValue()) continue;
            log.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
            log.set("collectstatus", (Object)CollectStatusEnum.READY.getValue());
            log.set("modifydate", null);
            log.set("optime", (Object)new Date());
            log.set("endtime", null);
            log.set("modifier", (Object)RequestContext.get().getUserId());
        }
        SaveServiceHelper.save((DynamicObject[])existLogs);
        return existLogs;
    }

    public static boolean submitTask(boolean isSync, Long orgId, DynamicObjectCollection col, Pair<Long, String> currencyObj, Pair<Long, String> model, Pair<Long, String> scene, Pair<Long, String> currency, Pair<Long, String> fy, Pair<Long, String> period, Set<Long> templateIds, Consumer<IIntegrateContext> consumer) {
        HashMap<String, DynamicObject> logSchemeMapping;
        int[] countService;
        HashMap schemeServicesMapping;
        Pair _currency;
        Pair org;
        block24: {
            boolean isInegrateAble = IntegrateDispatcher2.checkInegrateAble(model, scene, fy, period, orgId, currency, col);
            if (!isInegrateAble) {
                return false;
            }
            DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])QFilter.of((String)"id = ? ", (Object[])new Object[]{orgId}).toArray());
            org = Pair.onePair((Object)orgDyn.getLong("id"), (Object)orgDyn.getString("number"));
            if ("EC".equals(currencyObj.p2) || "DC".equals(currencyObj.p2)) {
                DynamicObject currencyDynaByOrgId = IntegrateDispatcher2.getCurrencyDynaByOrgId(orgDyn.getLong("id"), "id, number");
                currency = Pair.onePair((Object)currencyDynaByOrgId.getLong("id"), (Object)currencyDynaByOrgId.getString("number"));
            }
            _currency = currency;
            schemeServicesMapping = new HashMap();
            countService = new int[]{0};
            ArrayList<Long> schemeIds = new ArrayList<Long>();
            col.forEach(scheme -> {
                schemeIds.add(scheme.getLong("id"));
                List<Class<? extends AbstractIntegrateService>> integrateService = IntegrateDispatcher2.getIntegrateService(scheme);
                schemeServicesMapping.put(scheme, integrateService);
                countService[0] = countService[0] + integrateService.size();
            });
            logSchemeMapping = new HashMap<String, DynamicObject>();
            DLock lock = DLock.create((String)("IntegrateDispatcher2." + (String)model.p2 + (String)scene.p2 + (String)fy.p2 + (String)period.p2));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = IntegrateDispatcher2.getExecuteLogs(currencyObj, model, fy, period, orgId, schemeIds, scene);
                    Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), (DynamicObject)v));
                    ArrayList<DynamicObject> saveObj = new ArrayList<DynamicObject>();
                    for (Map.Entry entry : schemeServicesMapping.entrySet()) {
                        DynamicObject scheme2 = (DynamicObject)entry.getKey();
                        Pair schemePair = Pair.onePair((Object)scheme2.getLong("id"), (Object)scheme2.getString("number"));
                        String schemeKey = (String)org.p2 + (String)schemePair.p2;
                        DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
                        if (logDyn != null) continue;
                        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
                        dynaObj.set("model", model.p1);
                        dynaObj.set("scheme", schemePair.p1);
                        dynaObj.set("org", org.p1);
                        dynaObj.set("scenario", scene.p1);
                        dynaObj.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
                        dynaObj.set("collectstatus", (Object)CollectStatusEnum.READY.getValue());
                        dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                        dynaObj.set("modifydate", (Object)new Date());
                        dynaObj.set("endtime", null);
                        dynaObj.set("optime", (Object)new Date());
                        dynaObj.set("fy", fy.p1);
                        dynaObj.set("period", period.p1);
                        dynaObj.set("currency", currencyObj.p1);
                        dynaObj.set("paramjson", (Object)" ");
                        saveObj.add(dynaObj);
                        logSchemeMapping.put(schemeKey, dynaObj);
                    }
                    if (saveObj.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
                    }
                    break block24;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        ConcurrentHashMap<String, Integer> schemeServices = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, Integer> schemeServicesFail = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, String> schemeServicesFailMsg = new ConcurrentHashMap<String, String>(3);
        ConcurrentHashMap schemeServicesLockDim = new ConcurrentHashMap(16);
        CountDownLatch downLatch = null;
        if (isSync) {
            downLatch = new CountDownLatch(countService[0]);
        }
        IntegrateEntity intEntity = IntegrateDispatcher2.getIntegrateEntityBySingleOrg(col, (Pair<Long, String>)org);
        IntegrateDispatcher2.createNoticeStatusLog(logSchemeMapping, false, intEntity);
        Long callId = (Long)intEntity.getCustomParam(CALLID);
        Map<Long, Long> noticeStatusLogMap = IntegrateDispatcher2.queryNoticeStatusLog(callId);
        ConcurrentHashMap insertCount = new ConcurrentHashMap(3);
        for (Map.Entry entry : schemeServicesMapping.entrySet()) {
            String serviceSchemeKeyLockDim;
            Map lockMap;
            String serviceSchemeKeyFailMsg;
            String serviceNumbFailMsg;
            String serviceSchemeKeyFail;
            Integer serviceNumbFail;
            DynamicObject scheme3 = (DynamicObject)entry.getKey();
            Pair schemePair = Pair.onePair((Object)scheme3.getLong("id"), (Object)scheme3.getString("number"));
            String schemeKey = (String)org.p2 + (String)schemePair.p2;
            DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
            String serviceSchemeKey = schemeKey + (String)currency.p2;
            Integer serviceNumb = (Integer)schemeServices.get(serviceSchemeKey);
            if (serviceNumb == null) {
                schemeServices.put(serviceSchemeKey, ((List)entry.getValue()).size());
            }
            if ((serviceNumbFail = (Integer)schemeServicesFail.get(serviceSchemeKeyFail = serviceSchemeKey + "fail")) == null) {
                schemeServicesFail.put(serviceSchemeKeyFail, 0);
            }
            if ((serviceNumbFailMsg = (String)schemeServicesFailMsg.get(serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg")) == null) {
                schemeServicesFailMsg.put(serviceSchemeKeyFailMsg, "");
            }
            if ((lockMap = (Map)schemeServicesLockDim.get(serviceSchemeKeyLockDim = serviceSchemeKey + "lockDim")) == null) {
                schemeServicesLockDim.put(serviceSchemeKeyLockDim, new ConcurrentHashMap(16));
            }
            DynamicObject isSchemeSys = scheme3.getDynamicObject("isscheme");
            for (Class as : (List)entry.getValue()) {
                try {
                    IntegrateContext context = new IntegrateContext(model, (Pair<Long, String>)schemePair, (Pair<Long, String>)_currency, scene, fy, period, (Pair<Long, String>)org, templateIds, as);
                    context.putCustomParam("SYSTEM_VERSION", isSchemeSys == null ? null : isSchemeSys.getString("version"));
                    context.putCustomParam("SYSTEM_SSID", isSchemeSys == null ? null : Long.valueOf(isSchemeSys.getLong("id")));
                    context.putCustomParam("issrc", scheme3.getString("issrc.number"));
                    context.putCustomParam("BalType", 5);
                    context.putCustomParam("currency", currencyObj);
                    context.putCustomParam("scene", scene);
                    context.putCustomParam("log", logDyn);
                    context.putCustomParam("servicenum", schemeServices);
                    context.putCustomParam("consumer", consumer);
                    context.putCustomParam("insertCount", insertCount);
                    context.putCustomParam("servicefailnum", schemeServicesFail);
                    context.putCustomParam("servicefailMsg", schemeServicesFailMsg);
                    context.putCustomParam("servicetotalnum", ((List)entry.getValue()).size());
                    context.putCustomParam("schemeServicesLockDim", schemeServicesLockDim);
                    if (noticeStatusLogMap.get(logDyn.getLong("id")) != null) {
                        context.putCustomParam(NOTICELOGID, noticeStatusLogMap.get(logDyn.getLong("id")));
                        context.putCustomParam(CALLID, callId);
                    }
                    IntegrateDispatcher2.execute(context, downLatch);
                }
                catch (Exception e) {
                    throw new KDBizException(ThrowableHelper.toString((Exception)e));
                }
            }
        }
        if (isSync) {
            try {
                return downLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
        return true;
    }

    private static IntegrateEntity getIntegrateEntityBySingleOrg(DynamicObjectCollection col, Pair<Long, String> orgPair) {
        IntegrateEntity intEntity = new IntegrateEntity();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        for (DynamicObject scheme : col) {
            orgSchemePairs.add((Pair<Pair<Long, String>, Pair<Long, String>>)Pair.onePair(orgPair, (Object)Pair.onePair((Object)scheme.getLong("id"), (Object)scheme.getString("number"))));
        }
        intEntity.setOrgSchemePairs(orgSchemePairs);
        return intEntity;
    }

    private static boolean checkInegrateAble(Pair<Long, String> model, Pair<Long, String> scene, Pair<Long, String> fy, Pair<Long, String> period, Long orgId, Pair<Long, String> currency, DynamicObjectCollection col) {
        boolean versionedOrg = MergeControlHelper.isQuoteLocked((Long)model.p1, (Long)scene.p1, (Long)fy.p1, (Long)period.p1, orgId);
        if (versionedOrg) {
            IntegrateEntity intEntity = new IntegrateEntity();
            intEntity.setModel(model);
            intEntity.setScene(scene);
            intEntity.setYear(fy);
            intEntity.setPeriod(period);
            intEntity.setCurrency(currency);
            ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
            IDNumberTreeNode member = MemberReader.findMemberById((long)((Long)model.p1), (String)"bcm_entitymembertree", (Long)orgId);
            Pair orgPair = Pair.onePair((Object)orgId, (Object)member.getNumber());
            for (DynamicObject obj : col) {
                orgSchemePairsNotNeed.add((Pair<Pair<Long, String>, Pair<Long, String>>)Pair.onePair((Object)orgPair, (Object)Pair.onePair((Object)obj.getLong("id"), (Object)obj.getString("number"))));
            }
            IntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u7248\u672c\u5316\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"IntegrateDispatcher2_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static List<Class<? extends AbstractIntegrateService>> getIntegrateService(DynamicObject schemeObj) {
        MappingContext context = new MappingContext(schemeObj);
        return context.getIntegrateService();
    }

    private static DynamicObject getCurrencyDynaByOrgId(Long orgId, String selectFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"currency.number, model", (QFilter[])new QFilter[]{qFilter});
        QFilter filter1 = new QFilter("number", "=", (Object)org.getString("currency.number"));
        QFilter filter2 = new QFilter("model", "=", (Object)org.getLong("model"));
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{filter1, filter2});
        return currency;
    }

    public static String submitTaskByExecute(Map<String, Object> param) {
        try {
            IntegrateDispatcher2.loadParam(param, logDyn -> {
                Pair orginCurrencyPair;
                DynamicObject orgDyn = logDyn.getDynamicObject("org");
                DynamicObject currencyDyn = logDyn.getDynamicObject("currency");
                DynamicObject periodDyn = logDyn.getDynamicObject("period");
                DynamicObject yearDyn = logDyn.getDynamicObject("fy");
                DynamicObject modelDyn = logDyn.getDynamicObject("model");
                DynamicObject sceneObj = logDyn.getDynamicObject("scenario");
                DynamicObject schemeDyn = logDyn.getDynamicObject("scheme");
                Pair orgPair = Pair.onePair((Object)orgDyn.getLong("id"), (Object)orgDyn.getString("number"));
                Pair currencyPair = orginCurrencyPair = Pair.onePair((Object)currencyDyn.getLong("id"), (Object)currencyDyn.getString("number"));
                Pair periodPair = Pair.onePair((Object)periodDyn.getLong("id"), (Object)periodDyn.getString("number"));
                Pair yearPair = Pair.onePair((Object)yearDyn.getLong("id"), (Object)yearDyn.getString("number"));
                Pair modelPair = Pair.onePair((Object)modelDyn.getLong("id"), (Object)modelDyn.getString("number"));
                Pair scene = Pair.onePair((Object)sceneObj.getLong("id"), (Object)sceneObj.getString("number"));
                Long schemeId = schemeDyn.getLong("id");
                HashSet<Long> templates = new HashSet<Long>();
                DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])new Object[]{schemeId}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme"));
                DynamicObjectCollection _schemes = new DynamicObjectCollection();
                for (DynamicObject scheme : schemes) {
                    _schemes.add((Object)scheme);
                }
                if (logDyn.getInt("collectstatus") == CollectStatusEnum.ISCPROCESS.getValue()) {
                    IntegrateDispatcher2.submitTask(true, (Long)orgPair.p1, _schemes, (Pair<Long, String>)orginCurrencyPair, (Pair<Long, String>)modelPair, (Pair<Long, String>)scene, (Pair<Long, String>)currencyPair, (Pair<Long, String>)yearPair, (Pair<Long, String>)periodPair, templates, null);
                } else if (logDyn.getInt("collectstatus") != CollectStatusEnum.SUCCESS.getValue()) {
                    logDyn.set("collectstatus", (Object)CollectStatusEnum.ISCFAIL);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDyn});
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(String.format("convert Objct [%s] to json error!", e.getMessage()));
        }
        return "success";
    }

    private static void loadParam(Map<String, Object> param, Consumer<DynamicObject> exeConsumer) {
        String exeNumber = ((DynamicObject)param.get("data")).getString("number");
        if (StringUtils.isEmpty((String)exeNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u96c6\u6210\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u53c2\u6570\u201c%s\u201d\u672a\u5b9a\u4e49\u3002", (String)"IntegrateDispatcher2_3", (String)"fi-bcm-business", (Object[])new Object[0]), "exeNumber"));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("copyexe.number", "=", (Object)exeNumber);
        DynamicObject[] dynaObjs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"collectstatus, model, fy, period, currency, scheme, org, scenario", (QFilter[])builder.toArray());
        if (dynaObjs == null || dynaObjs.length <= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u65e0\u91c7\u96c6\u72b6\u6001\u4e3a\u201c%2$s\u201d\u7684\u96c6\u6210\u65b9\u6848\u6570\u636e\u91c7\u96c6\u6267\u884c\u8bb0\u5f55\u3002", (String)"IntegrateDispatcher2_4", (String)"fi-bcm-business", (Object[])new Object[0]), IntegrationServiceHelper.class.getName(), CollectStatusEnum.READY.getName(), exeNumber));
        }
        Stream.of(dynaObjs).forEach(dynaObj -> {
            CollectStatusEnum status = CollectStatusEnum.getEnum((Integer)dynaObj.getInt("collectstatus"));
            switch (status) {
                case ISCPROCESS: {
                    exeConsumer.accept((DynamicObject)dynaObj);
                    break;
                }
            }
        });
    }

    public static Pair<Integer, Map<Object, DynamicObject>> getMember(DynamicObject dimObj, List<Long> membIds) {
        QFilter[] qFilterArray;
        QFilter qf = new QFilter("id", "in", membIds);
        String memberform = dimObj.getString("memberform");
        Long dimId = dimObj.getLong("id");
        boolean isUserDefine = "bcm_userdefinedmembertree".equalsIgnoreCase(memberform);
        if (isUserDefine) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = qf;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("dimension", "=", (Object)dimId);
        } else {
            qFilterArray = qf.toArray();
        }
        Map result = BusinessDataServiceHelper.loadFromCache((String)memberform, (String)"number,name", (QFilter[])qFilterArray);
        if (result.isEmpty()) {
            result = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"number,name,parentid", (QFilter[])new QFilter[]{qf, new QFilter("dimension", "=", (Object)dimId)});
            return Pair.onePair((Object)2, (Object)result);
        }
        return Pair.onePair((Object)1, (Object)result);
    }

    static {
        IntegrateDispatcher2.addHook();
    }
}

