/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.NoticeStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;

public class IntegrationNewServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(IntegrationNewServiceHelper.class);
    private static final int ctrlErrorLogOnlyOne = 666;
    private static final String STARTTIME = "startTime";
    private static final String ENDTIME = "endtime";
    private static final String CALLID = "callId";
    private static final String NOTICELOGID = "noticeLogId";

    public static Object execute(IIntegrateContext context) {
        log.startWatch();
        try {
            IntegrationNewServiceHelper.executeBefore(context);
            IntegrationNewServiceHelper.doExecute(context);
            IntegrationNewServiceHelper.executeAfter(context);
            log.warn("--execute--");
        }
        catch (Exception e) {
            String errorStr = e instanceof KDBizException ? e.getMessage() : ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30);
            log.error("--execute--\n" + e);
            IntegrationNewServiceHelper.writeErrorLog(context, errorStr);
        }
        return null;
    }

    private static void doExecute(IIntegrateContext context) {
        AbstractIntegrateService servive = null;
        try {
            servive = context.getServiceClass().getConstructor(IIntegrateContext.class).newInstance(context);
        }
        catch (Throwable e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u670d\u52a1\uff1a%s\u3002", (String)"IntegrationNewServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), (String)context.getOrg().p2 + "--" + (String)context.getSchema().p2));
        }
        if (servive == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u670d\u52a1\uff1a%s\u3002", (String)"IntegrationNewServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), (String)context.getOrg().p2 + "--" + (String)context.getSchema().p2));
        }
        context.putCustomParam(STARTTIME, System.currentTimeMillis());
        servive.execute();
    }

    private static void executeAfter(IIntegrateContext ctx) {
        if (DebugServiceHelper.isDebugModel()) {
            IntegrationNewServiceHelper.mutexLog(IntegrationNewServiceHelper::addDebugLog, ctx);
            ctx.putCustomParam("msg", null);
        } else {
            IntegrationNewServiceHelper.mutexLog(IntegrationNewServiceHelper::addSuccessLog, ctx);
        }
        ctx.putCustomParam("log", null);
        if (ConfigServiceHelper.getGlobalBoolParam("P002")) {
            if (HWModelParamUtil.getIsExecuteRule((Long)ctx.getModel().p1).booleanValue()) {
                Pair scence = (Pair)ctx.getCustomParam("scene");
                BizRuleExecParam p = new BizRuleExecParam((String)ctx.getModel().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, (Long)ctx.getOrg().p1, (String)ctx.getOrg().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, (Long)ctx.getFy().p1, (String)ctx.getFy().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, (Long)ctx.getPeriod().p1, (String)ctx.getPeriod().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, (Long)ctx.getCurrency().p1, (String)ctx.getCurrency().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, (Long)scence.p1, (String)scence.p2);
                Object noTemplate = ctx.getCustomParam("noTemplate");
                List<Object> ruleIds = new ArrayList();
                if (null != noTemplate) {
                    QFilter filter1 = new QFilter("model", "=", ctx.getModel().p1);
                    filter1.and("deletestatus", "=", (Object)false);
                    filter1.and("status", "=", (Object)"1");
                    ruleIds = BusinessDataServiceHelper.loadFromCache((String)"bcm_bizruleentity", (String)"id", (QFilter[])new QFilter[]{filter1}, (String)"executeseq").keySet().stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toList());
                    if (null != ruleIds && !ruleIds.isEmpty()) {
                        BizRuleExecStarter.execBizRule(ruleIds, p, true, false);
                    }
                }
            }
        } else if (ctx.getCustomParam("isFromSchedule") != null && ((Boolean)ctx.getCustomParam("isFromSchedule")).booleanValue() && IntegrationNewServiceHelper.isLastService(ctx)) {
            IntegrationNewServiceHelper.execBizRule(ctx);
        }
    }

    private static boolean isLastService(IIntegrateContext ctx) {
        Map servicenums = (Map)ctx.getCustomParam("servicenum");
        int servicenum = (Integer)servicenums.get((String)ctx.getOrg().p2 + (String)ctx.getSchema().p2);
        return servicenum == 0;
    }

    private static void execBizRule(IIntegrateContext ctx) {
        List<Long> bizRuleIds = IntegrationNewServiceHelper.getBizRuleIds((Long)ctx.getModel().p1, (Long)ctx.getPeriod().p1);
        Map currencys = (Map)ctx.getCustomParam("org2currency");
        Map<Pair, List<Map.Entry>> map = currencys.entrySet().stream().collect(Collectors.groupingBy(c -> (Pair)c.getValue()));
        map.forEach((k, v) -> {
            for (Map.Entry entry : v) {
                BizRuleExecParam p = new BizRuleExecParam((String)ctx.getModel().p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, (Long)k.p1, (String)k.p2);
                p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, (Long)((Pair)entry.getValue()).p1, (String)((Pair)entry.getValue()).p2);
                IntegrationNewServiceHelper.setCommonParams(p, ctx);
                BizRuleExecStarter.execBizRule(bizRuleIds, p, false);
            }
        });
    }

    private static List<Long> getBizRuleIds(Long modelid, Long periodid) {
        DynamicObject[] doc;
        ArrayList<Long> bizRuleIds = new ArrayList<Long>();
        for (DynamicObject d : doc = BusinessDataServiceHelper.load((String)"bcm_isbizrule", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_isbizrule").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelid)})) {
            Long bizruleid = d.getLong("bizrule_id");
            if (!IntegrationNewServiceHelper.isEffective(modelid, bizruleid, periodid)) continue;
            bizRuleIds.add(bizruleid);
        }
        return bizRuleIds;
    }

    private static boolean isEffective(Long modelid, Long bizruleid, Long periodId) {
        long periodDimensionId = BizRuleUtil.getPeriodDimensionId(modelid);
        QFilter filter = new QFilter("bizrule", "=", (Object)bizruleid);
        filter.and("dimension", "=", (Object)periodDimensionId);
        DynamicObjectCollection scopeColl = QueryServiceHelper.query((String)"bcm_bizrulescope", (String)"member", (QFilter[])new QFilter[]{filter});
        if (scopeColl != null && !scopeColl.isEmpty()) {
            for (DynamicObject scope : scopeColl) {
                if (periodId.longValue() != scope.getLong("member")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void setCommonParams(BizRuleExecParam p, IIntegrateContext ctx) {
        p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, (Long)ctx.getFy().p1, (String)ctx.getFy().p2);
        p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, (Long)ctx.getPeriod().p1, (String)ctx.getPeriod().p2);
        Pair scence = (Pair)ctx.getCustomParam("scene");
        p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, (Long)scence.p1, (String)scence.p2);
    }

    private static DynamicObject addSuccessLog(IIntegrateContext ctx) {
        DynamicObject schemeLog = (DynamicObject)ctx.getCustomParam("log");
        int status = schemeLog.getInt("collectstatus");
        String serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2;
        Map servicenums = (Map)ctx.getCustomParam("servicenum");
        int servicenum = (Integer)servicenums.get(serviceSchemeKey);
        if (CollectStatusEnum.FAIL.getValue() != status && servicenum > 0) {
            int count = ctx.getCustomParam("InsertOlapCount") == null ? 0 : (Integer)ctx.getCustomParam("InsertOlapCount");
            Map insertCount = (Map)ctx.getCustomParam("insertCount");
            Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
            insertCount.put(serviceSchemeKey, totalCount + count);
        }
        IntegrationNewServiceHelper.addTraceId(serviceSchemeKey, ctx);
        servicenums.put(serviceSchemeKey, --servicenum);
        if (ctx.getCustomParam("reportList") != null && servicenum == 0) {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
            DynamicObject dyObj = new DynamicObject(logObj.getDynamicObjectType());
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", ctx.getModel().p1);
            dyObj.set("scenario", ctx.getScene().p1);
            dyObj.set("fy", ctx.getFy().p1);
            dyObj.set("period", ctx.getPeriod().p1);
            Pair currency = (Pair)ctx.getCustomParam("currency");
            dyObj.set("currency", currency.p1);
            dyObj.set("org", ctx.getOrg().p1);
            dyObj.set("scheme", ctx.getSchema().p1);
            dyObj.set("dimmembers", (Object)"");
            dyObj.set("datafrom", null);
            dyObj.set("error", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6620\u5c04\u6210\u5458\uff1areportList:%s", (String)"IntegrationNewServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), JSON.toJSONString(ctx.getCustomParam("reportList"))));
            dyObj.set("result", (Object)ResManager.loadKDString((String)"\u7a7a", (String)"IntegrationNewServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collecttime", (Object)IntegrationNewServiceHelper.getCurrentDate());
            dyObj.set("executerec", (Object)schemeLog.getLong("id"));
            dyObj.set("importmode", (Object)ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1));
            dyObj.set("clearconfig", (Object)IntegrationNewServiceHelper.setImportmode(ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1), (Long)ctx.getModel().p1, (Long)ctx.getSchema().p1, -1));
            logObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
        }
        if (ctx.getCustomParam("reportList") == null && CollectStatusEnum.FAIL.getValue() != status && servicenum == 0) {
            schemeLog.set("checkstatus", (Object)CheckStatusEnum.SUCCESS.getValue());
            schemeLog.set("collectstatus", (Object)CollectStatusEnum.SUCCESS.getValue());
            schemeLog.set("modifydate", ctx.getCustomParam(STARTTIME));
            ctx.putCustomParam(ENDTIME, System.currentTimeMillis());
            schemeLog.set(ENDTIME, ctx.getCustomParam(ENDTIME));
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeLog}, (OperateOption)op);
            IntegrationNewServiceHelper.writeSuccessLog(ctx, schemeLog);
        }
        if (servicenum != 0) {
            Integer servicenumtotal = (Integer)ctx.getCustomParam("servicetotalnum");
            Map servicefailnum = (Map)ctx.getCustomParam("servicefailnum");
            String serviceSchemeKeyFail = serviceSchemeKey + "fail";
            Integer num = (Integer)servicefailnum.get(serviceSchemeKeyFail);
            if (servicenumtotal - num <= 1) {
                Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
                String serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg";
                ctx.putCustomParam("InsertOlapCount", 0);
                DLock.forceUnlock((String[])new String[]{"fi.bcm.IntegrationNewServiceHelper." + (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "log"});
                IntegrationNewServiceHelper.writeErrorLog(ctx, (String)servicefailMsg.get(serviceSchemeKeyFailMsg));
            } else {
                num = num + 1;
                servicefailnum.put(serviceSchemeKeyFail, num);
            }
        }
        return schemeLog;
    }

    private static void addTraceId(String serviceSchemeKey, IIntegrateContext ctx) {
        String traceId = RequestContext.get().getTraceId();
        if (traceId == null) {
            return;
        }
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        String traceId2 = (String)servicefailMsg.get(serviceSchemeKey + "traceId");
        if (traceId2 == null) {
            servicefailMsg.put(serviceSchemeKey + "traceId", traceId);
        } else if (!traceId2.contains(traceId)) {
            servicefailMsg.put(serviceSchemeKey + "traceId", traceId2 + "," + traceId);
        }
    }

    private static void writeSuccessLog(IIntegrateContext ctx, DynamicObject schemeLog) {
        Boolean isEntryIntergate = (Boolean)ctx.getCustomParam("isEntryIntergate");
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
        Long id = GlobalIdUtil.genGlobalLongId();
        logObj.set("id", (Object)id);
        logObj.set("model", ctx.getModel().p1);
        logObj.set("scenario", ctx.getScene().p1);
        logObj.set("fy", ctx.getFy().p1);
        logObj.set("period", ctx.getPeriod().p1);
        Pair currency = (Pair)ctx.getCustomParam("currency");
        logObj.set("currency", currency.p1);
        logObj.set("org", ctx.getOrg().p1);
        logObj.set("scheme", ctx.getSchema().p1);
        logObj.set("batch", ctx.getCustomParam("batchname"));
        logObj.set("dimmembers", (Object)"");
        logObj.set("datafrom", null);
        String spendTimeMessage = ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)ctx.getCustomParam("spendTimeMessage");
        String checkresult = ctx.getCustomParam("checkresult") == null ? "" : (String)ctx.getCustomParam("checkresult");
        Map insertCount = (Map)ctx.getCustomParam("insertCount");
        String serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2;
        Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
        String countStr = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6761\u6570\uff1a%s;", (String)"IntegrationNewServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), totalCount);
        String msg = countStr.concat(spendTimeMessage).concat(checkresult);
        String traceMsg = IntegrationNewServiceHelper.getTraceIdMsg(serviceSchemeKey, ctx);
        String interfaceMsg = IntegrationNewServiceHelper.getInterfaceMsg(serviceSchemeKey, ctx);
        String cleanRptsMsg = IntegrationNewServiceHelper.getCleanRptsMsg(ctx);
        String lockDimMsg = IntegrationNewServiceHelper.getLockDimMsg(ctx);
        logObj.set("error", (Object)(msg + traceMsg + interfaceMsg + cleanRptsMsg + lockDimMsg));
        logObj.set("result", (Object)ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f", (String)"IntegrationNewServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        logObj.set("collector", (Object)RequestContext.get().getUserId());
        logObj.set("collecttime", (Object)IntegrationNewServiceHelper.getCurrentDate());
        logObj.set("executerec", (Object)schemeLog.getLong("id"));
        logObj.set("collectorstate", (Object)CollectStatusEnum.SUCCESS.getValue());
        logObj.set("checkstate", (Object)CheckStatusEnum.SUCCESS.getValue());
        logObj.set("importmode", (Object)ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1));
        logObj.set("clearconfig", (Object)IntegrationNewServiceHelper.setImportmode(ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1), (Long)ctx.getModel().p1, (Long)ctx.getSchema().p1, -1));
        logObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
        Long spend = (Long)ctx.getCustomParam(ENDTIME) - (Long)ctx.getCustomParam(STARTTIME);
        StringBuilder sb = IntegrationNewServiceHelper.calculate(spend);
        StringBuilder spendString = new StringBuilder();
        log.info(spendString.append("cost and starttime endtime:").append(spend).append(",").append(schemeLog.getDate(ENDTIME).getTime()).append(",").append(schemeLog.getDate("modifydate").getTime()).append(",").append((CharSequence)sb).toString());
        logObj.set("spend", (Object)sb.toString());
        if (isEntryIntergate != null && isEntryIntergate.booleanValue()) {
            logObj.set("step", (Object)"B");
        } else {
            logObj.set("step", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        IntegrationNewServiceHelper.updateScheduleLog(ctx, CollectStatusEnum.SUCCESS.getValue());
        IntegrationNewServiceHelper.updateNoticeLog(ctx, CollectStatusEnum.COMPLETE.getValue() + "", id);
    }

    private static String getLockDimMsg(IIntegrateContext ctx) {
        String serviceSchemeKey;
        Map map;
        Map schemeServicesLockDim = (Map)ctx.getCustomParam("schemeServicesLockDim");
        if (schemeServicesLockDim != null && schemeServicesLockDim.size() > 0 && (map = (Map)schemeServicesLockDim.get(serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "lockDim")) != null && map.size() > 0) {
            Map<String, Map<String, List<String>>> msgMap = IntegrationUtil.getMsgMap(map);
            return String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6210\u5458\u56e0\u9501\u5b9a\u672a\u6210\u529f\u5165\u5e93:%1$s;", (String)"IntegrationNewServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]), JSONObject.toJSONString(msgMap));
        }
        return "";
    }

    private static void updateNoticeLog(IIntegrateContext ctx, String exestatus, Long integratereslogId) {
        Long noticeLogId = (Long)ctx.getCustomParam(NOTICELOGID);
        if (noticeLogId == null) {
            return;
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)noticeLogId, (String)"bcm_integration_notice");
        log.set("exestatus", (Object)exestatus);
        log.set("integratereslog", (Object)integratereslogId);
        if ((CollectStatusEnum.FAIL.getValue() + "").equals(exestatus) && NoticeStatusEnum.NOT_CALCULATED.getValue().equals(log.getString("calculatestatus"))) {
            log.set("calculatestatus", (Object)NoticeStatusEnum.FAIL_NOT_NEED_CALCULATE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        Long callId = (Long)ctx.getCustomParam(CALLID);
        boolean isCompleteAll = IntegrationNewServiceHelper.checkIsCompleteAll(callId);
        if (isCompleteAll) {
            IntegrationNewServiceHelper.doCalculate(callId, ctx);
            IntegrationNewServiceHelper.updateCalculatestatus(callId);
        }
    }

    private static void updateCalculatestatus(Long callId) {
        String sql = "update t_bcm_integrationnotice set fcalculatestatus = '" + NoticeStatusEnum.CALCULATED.getValue() + "' where fcallid = " + callId + " and fcalculatestatus = '" + NoticeStatusEnum.NOT_CALCULATED.getValue() + "'";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
    }

    private static void doCalculate(Long callId, IIntegrateContext ctx) {
        QFilter callQf = new QFilter("callid", "=", (Object)callId);
        QFilter calculatestatusQf = new QFilter("calculatestatus", "=", (Object)NoticeStatusEnum.NOT_CALCULATED.getValue());
        String selectField = "integrateexeclog.org.number,integrateexeclog.fy.number,integrateexeclog.period.number,integrateexeclog.currency.number";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_integration_notice", (String)selectField, (QFilter[])new QFilter[]{callQf, calculatestatusQf});
        query = IntegrationNewServiceHelper.getDistinctQuery(query);
        query.forEach(e -> {
            IRunner runner = () -> {
                log.info("executeCalculate param is:" + (String)ctx.getModel().p2 + ";" + (String)ctx.getOrg().p2 + ";" + (String)ctx.getScene().p2 + ";" + (String)ctx.getFy().p2 + ";" + (String)ctx.getPeriod().p2);
                MergeControlService.getInstance().executeCalculate((String)ctx.getModel().p2, (String)ctx.getOrg().p2, (String)ctx.getScene().p2, (String)ctx.getFy().p2, (String)ctx.getPeriod().p2);
            };
            ThreadPoolService.runInCalAfterIntegrateThread(runner);
        });
    }

    private static DynamicObjectCollection getDistinctQuery(DynamicObjectCollection query) {
        DynamicObjectCollection res = new DynamicObjectCollection();
        HashSet<String> checkSet = new HashSet<String>(query.size());
        for (DynamicObject obj : query) {
            String key = obj.getString("integrateexeclog.org.number") + obj.getString("integrateexeclog.fy.number") + obj.getString("integrateexeclog.period.number") + obj.getString("integrateexeclog.currency.number");
            if (!checkSet.add(key)) continue;
            res.add((Object)obj);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIsCompleteAll(Long callId) {
        DLock lock = DLock.create((String)("checkIsCompleteAll." + callId));
        try {
            if (lock.tryLock(3000L)) {
                QFilter callQf = new QFilter("callid", "=", (Object)callId);
                QFilter exestatusQf = new QFilter("exestatus", "=", (Object)(CollectStatusEnum.RUNNING.getValue() + ""));
                boolean bl = !QueryServiceHelper.exists((String)"bcm_integration_notice", (QFilter[])new QFilter[]{callQf, exestatusQf});
                return bl;
            }
        }
        catch (Throwable e) {
            log.error("checkIsCompleteAll fail :" + callId, e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return false;
    }

    private static String getCleanRptsMsg(IIntegrateContext ctx) {
        String cleanedRptParams = (String)ctx.getCustomParam("cleanedRptParams");
        String cleanedRptScopes = (String)ctx.getCustomParam("cleanedRptScopes");
        if (StringUtils.isEmpty((CharSequence)cleanedRptParams)) {
            return "";
        }
        return cleanedRptParams + cleanedRptScopes;
    }

    private static String getInterfaceMsg(String serviceSchemeKey, IIntegrateContext ctx) {
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        if (servicefailMsg == null) {
            return "";
        }
        String timeUserKey = serviceSchemeKey + "timeUser";
        return servicefailMsg.get(timeUserKey) == null ? "" : (String)servicefailMsg.get(timeUserKey);
    }

    public static StringBuilder calculate(Long spend) {
        long mi = spend % 1000L;
        long se = spend / 1000L % 60L;
        long min = spend / 1000L / 60L % 60L;
        long hour = spend / 1000L / 60L / 60L;
        StringBuilder sb = new StringBuilder();
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"IntegrationNewServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"IntegrationNewServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (se > 0L) {
            sb.append(se).append(ResManager.loadKDString((String)"\u79d2", (String)"IntegrationNewServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (mi > 0L) {
            sb.append(mi).append(ResManager.loadKDString((String)"\u6beb\u79d2", (String)"IntegrationNewServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)sb.toString())) {
            sb.append(ResManager.loadKDString((String)"0\u79d2", (String)"IntegrationNewServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return sb;
    }

    private static DynamicObject addDebugLog(IIntegrateContext ctx) {
        Map servicenums = (Map)ctx.getCustomParam("servicenum");
        int servicenum = (Integer)servicenums.get((String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2);
        servicenums.put((String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2, --servicenum);
        if (servicenum == 0) {
            DynamicObject schemeLog = (DynamicObject)ctx.getCustomParam("log");
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
            DynamicObject dyObj = new DynamicObject(logObj.getDynamicObjectType());
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", ctx.getModel().p1);
            dyObj.set("scenario", ctx.getScene().p1);
            dyObj.set("fy", ctx.getFy().p1);
            dyObj.set("period", ctx.getPeriod().p1);
            Pair currency = (Pair)ctx.getCustomParam("currency");
            dyObj.set("currency", currency.p1);
            dyObj.set("org", ctx.getOrg().p1);
            dyObj.set("scheme", ctx.getSchema().p1);
            dyObj.set("dimmembers", (Object)"");
            dyObj.set("datafrom", null);
            dyObj.set("batch", ctx.getCustomParam("batchname"));
            dyObj.set("error", (Object)String.format("Debug Info:\n%s", ctx.getCustomParam("msg")));
            dyObj.set("result", (Object)ResManager.loadKDString((String)"\u7a7a", (String)"IntegrationNewServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collecttime", (Object)IntegrationNewServiceHelper.getCurrentDate());
            dyObj.set("executerec", (Object)schemeLog.getLong("id"));
            schemeLog.set("collectstatus", (Object)CollectStatusEnum.SUCCESS.getValue());
            schemeLog.set(ENDTIME, (Object)IntegrationNewServiceHelper.getCurrentDate());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeLog});
            return dyObj;
        }
        return null;
    }

    private static void mutexLog(Consumer<IIntegrateContext> consumer, IIntegrateContext ctx) {
        block13: {
            try (DLock lock = DLock.create((String)("fi.bcm.IntegrationNewServiceHelper." + (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "log"));){
                if (lock.tryLock(10000L)) {
                    consumer.accept(ctx);
                    break block13;
                }
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25", (String)"IntegrationNewServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void writeErrorLog(IIntegrateContext context, String errorMsg) {
        Integer servicenumtotal = (Integer)context.getCustomParam("servicetotalnum");
        servicenumtotal = servicenumtotal == null ? Integer.valueOf(1) : servicenumtotal;
        int count = context.getCustomParam("InsertOlapCount") == null ? 0 : (Integer)context.getCustomParam("InsertOlapCount");
        IntegrationNewServiceHelper.markFail(context);
        String serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2;
        IntegrationNewServiceHelper.addTraceId(serviceSchemeKey, context);
        if (servicenumtotal > 1) {
            Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
            String serviceSchemeKeyFail = serviceSchemeKey + "fail";
            Integer num = (Integer)servicefailnum.get(serviceSchemeKeyFail);
            Map insertCount = (Map)context.getCustomParam("insertCount");
            Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
            if (servicenumtotal - num <= 1) {
                count = totalCount + count;
            } else {
                num = num + 1;
                servicefailnum.put(serviceSchemeKeyFail, num);
                insertCount.put(serviceSchemeKey, totalCount + count);
                Map servicefailMsg = (Map)context.getCustomParam("servicefailMsg");
                String serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg";
                servicefailMsg.put(serviceSchemeKeyFailMsg, errorMsg);
                return;
            }
        }
        Integer countFinal = count;
        IntegrationNewServiceHelper.mutexLog(ctx -> {
            String serviceSchemeKeyIn;
            Map servicenums = (Map)ctx.getCustomParam("servicenum");
            int servicenum = (Integer)servicenums.get(serviceSchemeKeyIn = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2);
            if (servicenum == 666) {
                return;
            }
            servicenums.put(serviceSchemeKeyIn, 666);
            int failStatus = IntegrationNewServiceHelper.getFailStatus(ctx);
            DynamicObject schemeLog = (DynamicObject)ctx.getCustomParam("log");
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemecollectlog");
            DynamicObject dyObj = new DynamicObject(logObj.getDynamicObjectType());
            Long id = GlobalIdUtil.genGlobalLongId();
            dyObj.set("id", (Object)id);
            dyObj.set("model", ctx.getModel().p1);
            dyObj.set("scenario", ctx.getScene().p1);
            dyObj.set("fy", ctx.getFy().p1);
            dyObj.set("period", ctx.getPeriod().p1);
            Pair currency = (Pair)ctx.getCustomParam("currency");
            dyObj.set("currency", currency.p1);
            dyObj.set("org", ctx.getOrg().p1);
            dyObj.set("scheme", ctx.getSchema().p1);
            dyObj.set("batch", ctx.getCustomParam("batchname"));
            dyObj.set("dimmembers", (Object)" ");
            dyObj.set("datafrom", (Object)" ");
            String errorMsgTotal = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6761\u6570\uff1a%s;", (String)"IntegrationNewServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), countFinal + ";");
            String traceMsg = IntegrationNewServiceHelper.getTraceIdMsg(serviceSchemeKeyIn, ctx);
            String interfaceMsg = IntegrationNewServiceHelper.getInterfaceMsg(serviceSchemeKey, ctx);
            String lockDimMsg = IntegrationNewServiceHelper.getLockDimMsg(ctx);
            dyObj.set("error", (Object)(errorMsgTotal + traceMsg + interfaceMsg + errorMsg + lockDimMsg));
            dyObj.set("result", (Object)ResManager.loadKDString((String)"\u7a7a", (String)"IntegrationNewServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collecttime", (Object)TimeServiceHelper.now());
            dyObj.set("executerec", (Object)schemeLog.getLong("id"));
            dyObj.set("collectorstate", (Object)failStatus);
            dyObj.set("importmode", (Object)ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1));
            logObj.set("clearconfig", (Object)IntegrationNewServiceHelper.setImportmode(ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1), (Long)ctx.getModel().p1, (Long)ctx.getSchema().p1, -1));
            dyObj.set("clearconfig", (Object)IntegrationNewServiceHelper.setImportmode(ISImportModeUtil.getImportModeByScheme((Long)ctx.getSchema().p1), (Long)ctx.getModel().p1, (Long)ctx.getSchema().p1, -1));
            dyObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
            Boolean isEntryIntergate = (Boolean)ctx.getCustomParam("isEntryIntergate");
            if (isEntryIntergate != null && isEntryIntergate.booleanValue()) {
                dyObj.set("step", (Object)"B");
            } else {
                dyObj.set("step", (Object)"A");
            }
            schemeLog.set("collectstatus", (Object)failStatus);
            ctx.putCustomParam(ENDTIME, System.currentTimeMillis());
            schemeLog.set(ENDTIME, ctx.getCustomParam(ENDTIME));
            Long spend = (Long)ctx.getCustomParam(ENDTIME) - schemeLog.getDate("modifydate").getTime();
            StringBuilder sb = IntegrationNewServiceHelper.calculate(spend);
            dyObj.set("spend", (Object)sb.toString());
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeLog}, (OperateOption)op);
            IntegrationNewServiceHelper.updateScheduleLog(ctx, CollectStatusEnum.FAIL.getValue());
            IntegrationNewServiceHelper.updateNoticeLog(ctx, failStatus + "", id);
        }, context);
    }

    private static String getTraceIdMsg(String serviceSchemeKey, IIntegrateContext ctx) {
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        if (servicefailMsg == null) {
            return "";
        }
        String traceIdMsg = servicefailMsg.get(serviceSchemeKey + "traceId") == null ? "" : (String)servicefailMsg.get(serviceSchemeKey + "traceId");
        return String.format(ResManager.loadKDString((String)"TraceId\u662f[%1$s]\uff0c\u6267\u884cIP\u662f[%2$s];", (String)"IntegrationNewServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]), traceIdMsg, NetAddressUtils.getLocalIpAddress());
    }

    private static int getFailStatus(IIntegrateContext context) {
        String serviceSchemeKey;
        String serviceSchemeKeyComplete;
        Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
        Integer num = (Integer)servicefailnum.get(serviceSchemeKeyComplete = (serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2) + "complete");
        if (num != null && num == 1) {
            return CollectStatusEnum.COMPLETE.getValue();
        }
        return CollectStatusEnum.FAIL.getValue();
    }

    private static void markFail(IIntegrateContext context) {
        Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
        String serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2;
        String serviceSchemeKeyComplete = serviceSchemeKey + "complete";
        if (servicefailnum == null) {
            return;
        }
        String failStatus = (String)context.getCustomParam("complete");
        if ("complete".equals(failStatus)) {
            servicefailnum.put(serviceSchemeKeyComplete, 1);
        }
    }

    private static void executeBefore(IIntegrateContext context) {
        IntegrationNewServiceHelper.mutexLog(ctx -> IntegrationNewServiceHelper.updateExeRec(ctx), context);
    }

    private static void updateExeRec(IIntegrateContext ctx) {
        DynamicObject existCol = (DynamicObject)ctx.getCustomParam("log");
        if (existCol != null) {
            int status = existCol.getInt("collectstatus");
            if (CollectStatusEnum.READY.getValue() == status || CollectStatusEnum.ISCPROCESS.getValue() == status || CollectStatusEnum.LINEUP.getValue() == status) {
                existCol.set("modifier", (Object)RequestContext.get().getUserId());
                existCol.set("collectstatus", (Object)CollectStatusEnum.RUNNING.getValue());
                existCol.set("exeip", (Object)NetAddressUtils.getLocalIpAddress());
                if (CollectStatusEnum.ISCPROCESS.getValue() != status) {
                    existCol.set("modifydate", (Object)IntegrationNewServiceHelper.getCurrentDate());
                }
                existCol.set(ENDTIME, null);
                existCol.set("paramjson", (Object)" ");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existCol});
            }
        }
    }

    private static Date getCurrentDate() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String setImportmode(Object formatValue, long modelId, Long schemeId, int subLength) {
        if (Objects.isNull(formatValue) || ISImpModeEnum.MERGEIMPORT.getCode().equals(formatValue)) {
            return ISImpModeEnum.MERGEIMPORT.getName();
        }
        if (ISImpModeEnum.REPLACEIMPORT.getCode().equals(formatValue)) {
            String cacheKey = "getAllReplaceImport_" + schemeId;
            Map<Pair<String, String>, Set<Pair<String, String>>> tarLackDimMember = (Map<Pair<String, String>, Set<Pair<String, String>>>)ThreadCache.get((Object)cacheKey);
            if (tarLackDimMember == null) {
                tarLackDimMember = ISImportModeUtil.getTarLackDimMember(schemeId);
            }
            if (tarLackDimMember != null) {
                Map.Entry<Pair<String, String>, Set<Pair<String, String>>> next = tarLackDimMember.entrySet().iterator().next();
                String members = next.getValue().stream().map(p -> (String)p.p2).collect(Collectors.joining(";"));
                String showName = (String)next.getKey().p2 + "|" + members + ";";
                if (subLength > -1 && showName.length() > subLength) {
                    showName = showName.substring(0, subLength) + "...";
                }
                showName = IntegrationNewServiceHelper.addClearConfig(showName, schemeId, modelId, subLength);
                return ISImpModeEnum.REPLACEIMPORT.getName() + "\uff1a" + showName;
            }
        }
        return "";
    }

    private static String addClearConfig(String showName, long id, long modelId, int subLength) {
        QFilter qf = new QFilter("isscheme", "=", (Object)id);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bcm_iscleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        if (configs == null || configs.length == 0) {
            return showName;
        }
        int showNameLength = showName.length();
        String dimtype = null;
        Integer scope = null;
        Long membId = null;
        DynamicObject dimObj = null;
        HashMap<String, DynamicObject> dimObjMap = new HashMap<String, DynamicObject>();
        StringBuilder sb = new StringBuilder();
        Map<String, List<DynamicObject>> configMap = IntegrationNewServiceHelper.getConfigMap(configs);
        boolean isEnoughLength = false;
        block0: for (Map.Entry<String, List<DynamicObject>> map : configMap.entrySet()) {
            if (isEnoughLength) break;
            for (DynamicObject dynamicObject : map.getValue()) {
                dimtype = dynamicObject.getString("dimtype");
                membId = dynamicObject.getLong("dimmemberid");
                scope = dynamicObject.getInt("scope");
                dimObj = IntegrationNewServiceHelper.getDimObj(dimtype, dimObjMap, modelId);
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)dimObj.getString("memberform"), (Long)membId);
                String memberName = IntegrationNewServiceHelper.getMemberName(member, membId, dimObj);
                sb.append(dimObj.getString("name")).append("|").append(memberName).append(IntegrationNewServiceHelper.getScopeDesc(scope));
                if (subLength <= -1 || showNameLength + sb.length() <= subLength) continue;
                isEnoughLength = true;
                continue block0;
            }
        }
        return showName + (isEnoughLength ? sb.substring(0, subLength - showNameLength - 1) + "..." : sb.toString());
    }

    private static String getMemberName(IDNumberTreeNode member, Long membId, DynamicObject dimObj) {
        String memberName = "";
        if (member.getId() == null || member.getId() == -1L) {
            ArrayList<Long> membIds = new ArrayList<Long>();
            membIds.add(membId);
            Pair<Integer, Map<Object, DynamicObject>> memberMap = IntegrateDispatcher2.getMember(dimObj, membIds);
            memberName = IntegrationNewServiceHelper.getMemberName((Map)memberMap.p2);
        } else {
            memberName = member.getName();
        }
        return memberName;
    }

    private static DynamicObject getDimObj(String dimtype, Map<String, DynamicObject> dimObjMap, long modelId) {
        DynamicObject dimObj = null;
        if (dimObjMap.get(dimtype) == null) {
            dimObj = IntegrationUtil.getDimPair(modelId, dimtype);
            dimObjMap.put(dimtype, dimObj);
        } else {
            dimObj = dimObjMap.get(dimtype);
        }
        return dimObj;
    }

    private static Map<String, List<DynamicObject>> getConfigMap(DynamicObject[] configs) {
        HashMap<String, List<DynamicObject>> configMap = new HashMap<String, List<DynamicObject>>();
        List configList = null;
        for (DynamicObject dynamicObject : configs) {
            configList = configMap.computeIfAbsent(dynamicObject.getString("dimtype"), k -> new ArrayList());
            configList.add(dynamicObject);
        }
        return configMap;
    }

    private static String getScopeDesc(Integer scope) {
        if (scope.intValue() == RangeEnum.VALUE_10.getValue()) {
            return ";";
        }
        RangeEnum range = RangeEnum.getRangeByVal((int)scope);
        return range.getName() + ";";
    }

    private static String getMemberName(Map<Object, DynamicObject> memberMap) {
        String name = null;
        if (memberMap != null) {
            name = ((DynamicObject)((Map.Entry)memberMap.entrySet().stream().findFirst().get()).getValue()).getString("name");
        }
        return name;
    }

    private static void updateScheduleLog(IIntegrateContext ctx, int status) {
        Long scheduleLog = (Long)ctx.getCustomParam("scheduleLog");
        if (scheduleLog == null) {
            return;
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)scheduleLog, (String)"bcm_schedule_statuslog");
        log.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

