/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.MiddleLibOutPut;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StandardMultiDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.integrationnew.service.AbstractFlowIntergrateService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.common.enums.integration.ComputeOprtEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class MiddleLibIntegrationService
extends AbstractFlowIntergrateService {
    private Map<String, String> mapkey;
    private Map<Long, List<DynamicObject>> singleMap;
    private List<String> dimNumber = new ArrayList<String>(10);
    private Set<String> preNumber = new HashSet<String>(10);
    private static final String DATA_SET = "databaseset";
    private static final String EXISTNORMALMAPPING = "exist_normal_mapping";
    private static final String AllSINGLE_VALUE = "allFromSingle_Value";
    private static final String AllSINGLE_MAPPEDROW = "allFromSingle_MappedRow";
    private static final String TARGETMAP = "targetMap";
    private static final String MATCHED = "matched";
    private static final String IGNORE = "IGNORE";
    private Table<String, String, Set<String>> forcheck = HashBasedTable.create();
    private static final String TARMEMBERNOTEXIST = "tarMemberNotExist";
    private static final String TARMEMBERNOTLEAF = "tarMemberNotLeaf";
    private static final String CHECKRESULT = "checkresult";
    private Map<String, Map<String, Boolean>> memberCollection;
    private List<String> allSourceKey = new ArrayList<String>();
    private Map<String, String> lowerKeyMap;
    private Multimap<String, MappedRow> accountHighPriority = ArrayListMultimap.create();
    private List<MappedRow> notHighPriorityMappedRows = new ArrayList<MappedRow>();
    private static final String selectField = "dseq,dimmapid,scope,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.seq,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber, pubmappingid";
    private DynamicObjectCollection userdefinedDims;

    public MiddleLibIntegrationService(IIntegrateContext ctx) {
        super(ctx);
        this.initPreNumber();
        this.mapkey = new HashMap<String, String>(16);
        ctx.getMappedRelation().getSingleMappedRelationPair().values().forEach(v -> {
            if (v.getMappedType() == 1) {
                this.mapkey.put(v.getTargetDimItem().getDimItem().getNumber().toLowerCase(Locale.ENGLISH), v.getSourceDimItem().getDimItem().getNumber());
            }
        });
        this.initSingleMap();
        this.userdefinedDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,fieldmapped,membermodel,number,dseq", (QFilter[])new QFBuilder().add("model", "=", this._ctx.getModel().p1).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        this.initDimNumber();
        this.initMemberCollection();
        this.initAllSourceKey();
        this.initLowerKeyMap();
    }

    private void initLowerKeyMap() {
        this.lowerKeyMap = new HashMap<String, String>();
        this.memberCollection.keySet().forEach(dim -> this.lowerKeyMap.put((String)dim, dim.toLowerCase(Locale.ENGLISH)));
    }

    private void initPreNumber() {
        this.preNumber.add(DimEntityNumEnum.ENTITY.getNumber());
        this.preNumber.add(DimEntityNumEnum.YEAR.getNumber());
        this.preNumber.add(DimEntityNumEnum.PERIOD.getNumber());
        this.preNumber.add(DimEntityNumEnum.CURRENCY.getNumber());
    }

    private void initDimNumber() {
        if (this.dimNumber.isEmpty()) {
            this.dimNumber = this.userdefinedDims.stream().map(d -> d.getString("number")).collect(Collectors.toList());
            this.dimNumber.add(DimEntityNumEnum.INTERCOMPANY.getNumber());
            this.dimNumber.add(DimEntityNumEnum.CHANGETYPE.getNumber());
            this.dimNumber.add(DimEntityNumEnum.ACCOUNT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.PROCESS.getNumber());
            this.dimNumber.add(DimEntityNumEnum.AUDITTRIAL.getNumber());
            this.dimNumber.add(DimEntityNumEnum.DATASORT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.SCENARIO.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MULTIGAAP.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MYCOMPANY.getNumber());
        }
    }

    private void initAllSourceKey() {
        Map<Long, MappedDimItem> sourceDimMap = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap();
        HashSet<String> hasNumber = new HashSet<String>(16);
        for (Map.Entry<Long, MappedDimItem> map : sourceDimMap.entrySet()) {
            hasNumber.add(map.getValue().getNumber());
        }
        Collection values = this._ctx.getMappedRelation().getSingleMappedRelationPair().values();
        QFilter schemeQf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            String srcNumber = singleDimRelationPair.getSourceDimItem().getDimItem().getNumber();
            if (singleDimRelationPair.getMappedType() != 1 || hasNumber.contains(srcNumber) || this.preNumber.contains(srcNumber)) continue;
            QFilter numberQf = new QFilter("number", "=", (Object)srcNumber);
            Map baseMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{schemeQf, numberQf});
            for (Map.Entry map : baseMap.entrySet()) {
                Long baseId = (Long)map.getKey();
                DynamicObject baseDy = (DynamicObject)map.getValue();
                MappedDimItem mdi = new MappedDimItem(baseId, srcNumber, srcNumber, baseDy.getString("entitynumber"));
                sourceDimMap.put(baseId, mdi);
            }
        }
        for (Map.Entry entry : sourceDimMap.entrySet()) {
            this.allSourceKey.add(((MappedDimItem)entry.getValue()).getMappedKey());
        }
    }

    private void initMemberCollection() {
        this.memberCollection = new HashMap<String, Map<String, Boolean>>(16);
        List<String> dimNumbs = DimensionServiceHelper.getDimensionNumListByModel(this._ctx.getModel().p1);
        dimNumbs.forEach(number -> {
            HashMap members = new HashMap(16);
            MemberReader.getAllNodeByDimNum((String)number, (String)((String)this._ctx.getModel().p2)).forEach(node -> members.put(node.getNumber(), node.isLeaf()));
            this.memberCollection.put((String)number, members);
        });
    }

    private void initSingleMap() {
        QFilter filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        Map<Long, Map<String, Object>> pubMap = IntegrationUtil.getPubMap((Long)this._ctx.getSchema().p1, null);
        this.singleMap = new HashMap<Long, List<DynamicObject>>(16);
        if (pubMap.size() > 0) {
            filter.or(new QFilter("pubmappingid", "in", pubMap.keySet()));
        }
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)selectField, (QFilter[])new QFilter[]{filter}, (String)"dseq, issinglemapentry.seq");
        HashSet<String> srcSet = new HashSet<String>(16);
        HashSet<String> tarSet = new HashSet<String>(16);
        this.addSingleMap(col, this.singleMap, srcSet, tarSet);
        this.addPubMapping(col, srcSet, tarSet, pubMap, this.singleMap);
    }

    private void addSingleMap(DynamicObject[] col, Map<Long, List<DynamicObject>> singleMap, Set<String> srcSet, Set<String> tarSet) {
        for (DynamicObject dot : col) {
            if (dot.getLong("pubmappingid") != 0L) continue;
            Long id = dot.getLong("dimmapid");
            List objs = singleMap.computeIfAbsent(id, k -> new ArrayList(10));
            objs.add(dot);
            srcSet.add(id + dot.getString("srcmembnumber"));
            tarSet.add(id + dot.getString("targmembnumber"));
        }
    }

    private void addPubMapping(DynamicObject[] col, Set<String> srcSet, Set<String> tarSet, Map<Long, Map<String, Object>> pubMap, Map<Long, List<DynamicObject>> singleMap) {
        for (DynamicObject dot : col) {
            String key;
            if (dot.getLong("pubmappingid") == 0L) continue;
            Map<String, Object> map = pubMap.get(dot.getLong("pubmappingid"));
            String dimNumber = (String)map.get("dimNumber");
            Long dimmapid = (Long)map.get("dimmapid");
            dot.set("dimmapid", (Object)dimmapid);
            boolean is4Dim = IntegrationUtil.checkIs4Dim(dimNumber);
            boolean isAdd = false;
            if (is4Dim) {
                key = dimmapid + dot.getString("targmembnumber");
                if (tarSet.add(key)) {
                    isAdd = true;
                }
            } else {
                key = dimmapid + dot.getString("srcmembnumber");
                if (srcSet.add(key)) {
                    isAdd = true;
                }
            }
            if (!isAdd) continue;
            List dynamicObjects = singleMap.computeIfAbsent(dimmapid, k -> new ArrayList(10));
            dynamicObjects.add(dot);
        }
    }

    @Override
    public void execute() {
        log.startWatch();
        StringBuilder spendTimeMessage = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        this.callServiceflow(sw, spendTimeMessage);
        this.beforeExecute();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", (String)"MiddleLibIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"MiddleLibIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        IDataSet ds = (IDataSet)this._provider.loadData();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%1$s]\u67e5\u8be2\u6570\u636e\u8017\u65f6,\u6e90\u6570\u636e\u6761\u6570\u4e3a%2$s", (String)"MiddleLibIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2, ((StdMdDataSet)ds).getSize()));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"MiddleLibIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        ds.forEach(row -> {
            this._ctx.putCustomParam(MATCHED, false);
            this._ctx.putCustomParam("priority", null);
            Collection accountHigh = this.accountHighPriority.get(row.get(this.mapkey.get("account")));
            if (accountHigh != null && accountHigh.size() > 0) {
                for (MappedRow maprow : accountHigh) {
                    this.match((IRow)row, maprow);
                }
            }
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                for (MappedRow mrow : this.notHighPriorityMappedRows) {
                    this.match((IRow)row, mrow);
                    if (this._ctx.getCustomParam("break") == null) continue;
                    this._ctx.putCustomParam("break", null);
                    break;
                }
            }
            this.handleAllFromSingleValue();
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                this.handleNotMatchRow((IRow)row);
                this.countNotMatchNum();
            }
        });
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", (String)"MiddleLibIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"MiddleLibIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        boolean checkSuccess = this.checkData(ds);
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u6821\u9a8c\u68c0\u67e5\u8fc7\u7a0b\u8017\u65f6", (String)"MiddleLibIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        if (checkSuccess) {
            this._output.output();
        }
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51faolap\u8017\u65f6", (String)"MiddleLibIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u6821\u9a8c\u68c0\u67e5\u8fc7\u7a0b\u53ca\u8f93\u51faolap\u8017\u65f6:", (String)"MiddleLibIntegrationService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.afterExecute();
        sw.stop();
        this._ctx.putCustomParam("spendTimeMessage", spendTimeMessage.toString());
        if (!checkSuccess) {
            throw new KDBizException((String)this._ctx.getCustomParam(CHECKRESULT));
        }
    }

    private void countNotMatchNum() {
        this._ctx.putCustomParam("check_countNotMatchNum", this._ctx.getCustomParam("check_countNotMatchNum") == null ? 1 : (Integer)this._ctx.getCustomParam("check_countNotMatchNum") + 1);
    }

    private boolean checkData(IDataSet<IRow> ds) {
        boolean checkSuccess = true;
        if (HWModelTypeEnum.LG.getNumber().equals(HWModelParamUtil.getModelType((Long)this._ctx.getModel().p1))) {
            StringBuilder result = new StringBuilder();
            if (this._ctx.getCustomParam("check_countNotMatchNum") != null) {
                result.append(String.format(ResManager.loadKDString((String)"\u6709%s\u6761\u6570\u636e\u672a\u627e\u5230\u6620\u5c04\uff0c\u8bf7\u6253\u5f00\u6821\u9a8c\u8868\u8fdb\u884c\u68c0\u67e5\u3002", (String)"MiddleLibIntegrationService_6", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getCustomParam("check_countNotMatchNum").toString())).append("\n");
            }
            if (this.forcheck.size() > 0) {
                if (this.forcheck.containsColumn((Object)TARMEMBERNOTEXIST)) {
                    result.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u6709\u76ee\u6807\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7ef4\u5ea6\u6216\u96c6\u6210\u65b9\u6848\u914d\u7f6e\uff1a", (String)"MiddleLibIntegrationService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
                    this.forcheck.column((Object)TARMEMBERNOTEXIST).forEach((k, v) -> result.append((String)k).append(ResManager.loadKDString((String)"\u7ef4\uff1a", (String)"MiddleLibIntegrationService_9", (String)"fi-bcm-business", (Object[])new Object[0])).append(String.join((CharSequence)", ", v)).append(";"));
                }
                if (this.forcheck.containsColumn((Object)TARMEMBERNOTLEAF)) {
                    result.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u6709\u76ee\u6807\u6210\u5458\u4e3a\u975e\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7ef4\u5ea6\u914d\u7f6e\uff1a", (String)"MiddleLibIntegrationService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
                    this.forcheck.column((Object)TARMEMBERNOTLEAF).forEach((k, v) -> result.append((String)k).append(ResManager.loadKDString((String)"\u7ef4\uff1a", (String)"MiddleLibIntegrationService_9", (String)"fi-bcm-business", (Object[])new Object[0])).append(String.join((CharSequence)", ", v)).append(";"));
                }
            }
            this._ctx.putCustomParam(CHECKRESULT, result.toString());
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme", (String)"location");
            if (result.length() > 0 && "PR".equalsIgnoreCase(scheme.getString("location"))) {
                checkSuccess = false;
            }
        } else if (this.forcheck.size() > 0 && this.forcheck.containsColumn((Object)TARMEMBERNOTLEAF)) {
            StringBuilder result = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u6709\u76ee\u6807\u6210\u5458\u4e3a\u975e\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7ef4\u5ea6\u914d\u7f6e\uff1a", (String)"MiddleLibIntegrationService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            this.forcheck.column((Object)TARMEMBERNOTLEAF).forEach((k, v) -> result.append((String)k).append(ResManager.loadKDString((String)"\u7ef4\uff1a", (String)"MiddleLibIntegrationService_9", (String)"fi-bcm-business", (Object[])new Object[0])).append(String.join((CharSequence)", ", v)).append(";"));
            this._ctx.putCustomParam(CHECKRESULT, result.toString());
        }
        return checkSuccess;
    }

    private void handleNotMatchRow(IRow row) {
        ArrayList rows = (ArrayList)this._ctx.getCustomParam(DATA_SET);
        if (null == this._ctx.getCustomParam(DATA_SET)) {
            rows = new ArrayList(10);
        }
        HashMap<String, Object> targetMap = new HashMap<String, Object>(16);
        targetMap.put("id", row.get("id"));
        targetMap.put(MATCHED, false);
        rows.add(targetMap);
        this._ctx.putCustomParam(DATA_SET, rows);
    }

    private void handleAllFromSingleValue() {
        if (this._ctx.getCustomParam(EXISTNORMALMAPPING) == null) {
            if (this._ctx.getCustomParam(AllSINGLE_VALUE) != null) {
                ValueList vl = this._ctx.getResult().computeIfAbsent((MappedRow)this._ctx.getCustomParam(AllSINGLE_MAPPEDROW), k -> new ValueList());
                vl.addValue((IValueItem)this._ctx.getCustomParam(AllSINGLE_VALUE));
            }
            this.setDataSet4Check((Map)this._ctx.getCustomParam(TARGETMAP));
        }
        this._ctx.putCustomParam(EXISTNORMALMAPPING, null);
        this._ctx.putCustomParam(AllSINGLE_VALUE, null);
        this._ctx.putCustomParam(AllSINGLE_MAPPEDROW, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void match(IRow r, MappedRow mappedRow) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>(16);
        ValueItem valueItem = new ValueItem();
        DataTraceFrom trace = new DataTraceFrom();
        int priority = -2;
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(3);
        flagMap.put("isIgnore", false);
        flagMap.put("targetMemberExist", true);
        for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
            void var11_12;
            String v;
            String upperKey = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId()).getTargetDimItem().getDimItem().getNumber();
            String string = this.lowerKeyMap.get(upperKey);
            if ("account".equals(string)) {
                priority = src.getPriority();
            }
            if (this.mapkey.containsKey(string)) {
                String string2 = this.mapkey.get(string);
            }
            if (StringUtils.isEmpty((CharSequence)(v = (String)r.get((String)var11_12)))) {
                return;
            }
            if (!"*".equals(src.getNumber()) && !FilterFactory.getFilter(src, this._ctx).isMatched(src, v, this._ctx)) {
                return;
            }
            String targetMemNum = mappedRow.getTargMapped().get(upperKey).getNumber();
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                targetMap.put((String)var11_12, IGNORE);
                flagMap.put("isIgnore", true);
                continue;
            }
            if ("*".equals(targetMemNum)) {
                IDNumberTreeNode iDNumberTreeNode = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)upperKey, (String)v);
                if (iDNumberTreeNode != null) {
                    targetMap.put((String)var11_12, iDNumberTreeNode.getNumber());
                    this.collectNotLeafMember(upperKey, iDNumberTreeNode.getNumber());
                } else {
                    targetMap.put((String)var11_12, "");
                    flagMap.put("targetMemberExist", false);
                    this.collectNotExistMember(upperKey, v);
                }
                valueItem.setProperty(upperKey, iDNumberTreeNode == null ? v : iDNumberTreeNode.getNumber());
                continue;
            }
            targetMap.put((String)var11_12, targetMemNum);
            this.collectNotLeafMember(upperKey, targetMemNum);
        }
        int allSourceSize = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().size();
        if (allSourceSize > mappedRow.getSrcMapped().size()) {
            ArrayList<String> mappedRowKey = new ArrayList<String>(10);
            for (MappedSourceItem mappedSourceItem : mappedRow.getSrcMapped().values()) {
                mappedRowKey.add(mappedSourceItem.getMappedDim().getMappedKey());
            }
            Collection c = CollectionUtils.disjunction(this.allSourceKey, mappedRowKey);
            for (Object key : c) {
                for (Map.Entry entry : this._ctx.getMappedRelation().getSingleMappedRelationPair().rowMap().entrySet()) {
                    if (!key.equals(((MappedDimItem)entry.getKey()).getMappedKey())) continue;
                    for (Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> entry2 : ((Map)entry.getValue()).entrySet()) {
                        if (!this.dimNumber.contains(((MappedDimItem)entry2.getKey()).getMappedKey())) continue;
                        String dimKey = this.lowerKeyMap.get(((MappedDimItem)entry2.getKey()).getMappedKey());
                        if (null != this.mapkey.get(dimKey)) {
                            dimKey = this.mapkey.get(dimKey);
                        }
                        if (null != r.get(dimKey)) {
                            List<DynamicObject> issinglemap = this.singleMap.get(((DimMappedRelation.SingleDimRelationPair)entry2.getValue()).getDimMappedId());
                            if (null == issinglemap) {
                                Map<Long, Map<String, Object>> pubMap = IntegrationUtil.getPubMap((Long)this._ctx.getSchema().p1, ((DimMappedRelation.SingleDimRelationPair)entry2.getValue()).getDimMappedId());
                                QFilter qf1 = new QFilter("schemeid", "=", this._ctx.getSchema().p1).and(new QFilter("dimmapid", "in", (Object)entry2.getValue().getDimMappedId()));
                                if (pubMap.size() > 0) {
                                    qf1.or(new QFilter("pubmappingid", "in", pubMap.keySet()));
                                }
                                DynamicObject[] temp = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)selectField, (QFilter[])new QFilter[]{qf1}, (String)"issinglemapentry.seq");
                                this.getSingMapAddPub(temp, this.singleMap, pubMap);
                                issinglemap = this.singleMap.get(entry2.getValue().getDimMappedId());
                            }
                            if (issinglemap == null) {
                                issinglemap = new ArrayList<DynamicObject>(16);
                            }
                            if (this.matchSingleMemMap(targetMap, dimKey, issinglemap, r, valueItem, entry2, flagMap)) continue;
                            return;
                        }
                        return;
                    }
                }
            }
        }
        this._ctx.putCustomParam(MATCHED, true);
        if (this._ctx.getCustomParam("priority") != null && priority != (Integer)this._ctx.getCustomParam("priority")) {
            this._ctx.putCustomParam("break", true);
            return;
        }
        this._ctx.putCustomParam("priority", priority);
        targetMap.put("id", r.get("id"));
        targetMap.put("amount", r.get("amount"));
        ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
        BigDecimal amount = (BigDecimal)r.get("amount");
        String string = (String)r.get("text");
        if (this.isOpenTrace) {
            ArrayList<DataTraceFromItem> df = new ArrayList<DataTraceFromItem>(1);
            DataTraceFromItem item = ((StdMdRow)r).getTraceFromItem();
            DataTraceFromItem dataTraceFromItem = new DataTraceFromItem();
            dataTraceFromItem.setV(item.getV());
            dataTraceFromItem.setD(item.getD());
            dataTraceFromItem.setOprt(item.getOprt());
            String symbol = mappedRow.isNegate() ? ComputeOprtEnum.SUBTRACT.getSymbol() : ComputeOprtEnum.PLUS.getSymbol();
            dataTraceFromItem.setOprt(symbol);
            df.add(dataTraceFromItem);
            trace.setDf(df);
            valueItem.setDataTraceFrom(trace);
        }
        if (mappedRow.isNegate()) {
            valueItem.setValue(Pair.onePair((Object)amount.negate(), (Object)string));
            targetMap.put("amount", amount.negate());
        } else {
            valueItem.setValue(Pair.onePair((Object)amount, (Object)string));
        }
        if (mappedRow.getSrcMapped().size() != 0) {
            if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
                vl.addValue(valueItem);
            }
            this._ctx.putCustomParam(EXISTNORMALMAPPING, true);
            this.setDataSet4Check(targetMap);
        } else {
            if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
                this._ctx.putCustomParam(AllSINGLE_VALUE, valueItem);
                this._ctx.putCustomParam(AllSINGLE_MAPPEDROW, mappedRow);
            }
            this._ctx.putCustomParam(TARGETMAP, targetMap);
        }
    }

    private void getSingMapAddPub(DynamicObject[] temp, Map<Long, List<DynamicObject>> singleMap, Map<Long, Map<String, Object>> pubMap) {
        HashSet<String> srcSet = new HashSet<String>(16);
        HashSet<String> tarSet = new HashSet<String>(16);
        this.addSingleMap(temp, singleMap, srcSet, tarSet);
        this.addPubMapping(temp, srcSet, tarSet, pubMap, singleMap);
    }

    private void collectNotLeafMember(String upperKey, String memberNumber) {
        Boolean isleaf = this.memberCollection.get(upperKey).get(memberNumber);
        if (isleaf != null && !isleaf.booleanValue()) {
            HashSet<String> set = this.forcheck.get((Object)upperKey, (Object)TARMEMBERNOTLEAF) == null ? new HashSet<String>(16) : (Set)this.forcheck.get((Object)upperKey, (Object)TARMEMBERNOTLEAF);
            set.add(memberNumber);
            this.forcheck.put((Object)upperKey, (Object)TARMEMBERNOTLEAF, set);
        }
    }

    private void collectNotExistMember(String upperKey, String v) {
        HashSet<String> set = this.forcheck.get((Object)upperKey, (Object)TARMEMBERNOTEXIST) == null ? new HashSet<String>(16) : (Set)this.forcheck.get((Object)upperKey, (Object)TARMEMBERNOTEXIST);
        set.add(v);
        this.forcheck.put((Object)upperKey, (Object)TARMEMBERNOTEXIST, set);
    }

    private void setDataSet4Check(Map<String, Object> targetMap) {
        ArrayList<Map<String, Object>> rows = (ArrayList<Map<String, Object>>)this._ctx.getCustomParam(DATA_SET);
        if (null == this._ctx.getCustomParam(DATA_SET)) {
            rows = new ArrayList<Map<String, Object>>(10);
        }
        rows.add(targetMap);
        this._ctx.putCustomParam(DATA_SET, rows);
    }

    private boolean matchSingleMemMap(Map<String, Object> targetMap, String dimKey, List<DynamicObject> issinglemap, IRow r, ValueItem valueItem, Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> dim, Map<String, Boolean> flagMap) {
        boolean matchSingle = false;
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        String v = (String)r.get(dimKey);
        for (DynamicObject isObject : issinglemap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && "*".equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null) continue;
            if (StringUtils.isEmpty((CharSequence)v)) {
                return false;
            }
            if (sourceItem != null && !"*".equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, v, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
            }
            if ("*".equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)dim.getKey().getNumber(), (String)v);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            String targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue();
            if ("".equals(targetNumber)) {
                flagMap.put("targetMemberExist", false);
                this.collectNotExistMember(dim.getKey().getNumber(), v);
            } else if (IGNORE.equals(targetNumber)) {
                flagMap.put("isIgnore", true);
            }
            valueItem.setProperty(dim.getKey().getNumber(), targetNumber);
            targetMap.put(dimKey.toLowerCase(Locale.ENGLISH), targetNumber);
            this.collectNotLeafMember(dim.getKey().getNumber(), targetNumber);
            matchSingle = true;
        }
        return matchSingle;
    }

    @Override
    protected void afterExecute() {
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        int scope = mainscope;
        MappedSourceItem item = new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, scope, false, false);
        return item;
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        List<MappedGroup> combineMappedGroup = this._ctx.getCombineMappedGroup();
        if (combineMappedGroup.size() == 0) {
            MappedGroup mg = new MappedGroup();
            combineMappedGroup.add(mg);
            MappedRow mr = new MappedRow(false, false);
            mg.addMappedRow(mr);
        }
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> singleMappedRelationPair = this._ctx.getMappedRelation().getSingleMappedRelationPair();
        Collection values = singleMappedRelationPair.values();
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            String dimTempNumber = singleDimRelationPair.getTargetDimItem().getDimItem().getNumber();
            if (Integer.parseInt(DimMappTypeEnum.SINGLE.getCode()) != singleDimRelationPair.getMappedType() || this.preNumber.contains(dimTempNumber)) continue;
            for (MappedGroup mg : combineMappedGroup) {
                for (MappedRow mr : mg) {
                    if (mr.getTargMapped().get(dimTempNumber) != null) continue;
                    long dimensionId = MemberReader.getDimensionIdByNum((long)((Long)this._ctx.getModel().p1), (String)dimTempNumber);
                    DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"bcm_dimension");
                    String memberform = dimension.getString("memberform");
                    MappedDimItem mdi = new MappedDimItem(dimensionId, dimTempNumber, dimTempNumber, memberform);
                    MappedTargetItem mti = new MappedTargetItem(0L, "*", mdi);
                    mr.addMappedTargetItem(mti);
                }
            }
        }
        return combineMappedGroup;
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new StandardMultiDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new MiddleLibOutPut(this._ctx);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        List<MappedGroup> serviceMappedGroup = this.getServiceMappedGroup();
        if (null == serviceMappedGroup || serviceMappedGroup.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u4e3a\u7a7a", (String)"MiddleLibIntegrationService_15", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList srcIsEmpty = new ArrayList();
        serviceMappedGroup.forEach(g -> g.forEach(row -> {
            boolean accountHigh = false;
            for (MappedSourceItem src : row.getSrcMapped().values()) {
                DimMappedRelation.SingleDimRelationPair singlePair = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId());
                if (singlePair == null) continue;
                String upperKey = singlePair.getTargetDimItem().getDimItem().getNumber();
                if (!DimEntityNumEnum.ACCOUNT.getNumber().equals(upperKey) || MapScopeEnum.EQUALS != MapScopeEnum.getEnumByindex((int)src.getScope()) || src.getPriority() != 999) continue;
                this.accountHighPriority.put((Object)src.getNumber(), row);
                accountHigh = true;
                break;
            }
            if (!accountHigh) {
                if (row.getSrcMapped().size() == 0) {
                    srcIsEmpty.add(row);
                } else {
                    this.notHighPriorityMappedRows.add((MappedRow)row);
                }
            }
        }));
        this.notHighPriorityMappedRows.addAll(srcIsEmpty);
    }
}

