/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.ModelOutPut;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.ModelDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class ModelIntegrationService
extends AbstractIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ModelIntegrationService.class);
    private Map<String, String> mapkey;
    private Map<Long, List<DynamicObject>> singleMap;
    private List<String> dimNumber = new ArrayList<String>(10);
    private Set<String> preNumber = new HashSet<String>(10);
    private static final String EXISTNORMALMAPPING = "exist_normal_mapping";
    private static final String AllSINGLE_VALUE = "allFromSingle_Value";
    private static final String AllSINGLE_MAPPEDROW = "allFromSingle_MappedRow";
    private static final String MATCHED = "matched";
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private Map<String, Map<String, Boolean>> memberCollection;
    private List<String> allSourceKey = new ArrayList<String>();
    private Map<String, String> lowerKeyMap;
    private Multimap<String, MappedRow> accountHighPriority = ArrayListMultimap.create();
    private List<MappedRow> notHighPriorityMappedRows = new ArrayList<MappedRow>();
    private static int srcAccountNotExist_priority = -2;
    private String selectField = "dseq,dimmapid,scope,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.seq,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber";
    DynamicObjectCollection userdefinedDims;

    public ModelIntegrationService(IIntegrateContext ctx) {
        super(ctx);
        this.initPreNumber();
        this.mapkey = new HashMap<String, String>(16);
        ctx.getMappedRelation().getSingleMappedRelationPair().values().forEach(v -> {
            if (v.getMappedType() == 1) {
                this.mapkey.put(v.getTargetDimItem().getDimItem().getNumber().toLowerCase(Locale.ENGLISH), v.getSourceDimItem().getDimItem().getNumber());
            }
        });
        this.initSingleMap();
        this.userdefinedDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,fieldmapped,membermodel,number,dseq", (QFilter[])new QFBuilder().add("model", "=", this._ctx.getModel().p1).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        this.initDimNumber();
        this.initMemberCollection();
        this.initAllSourceKey();
        this.initLowerKeyMap();
    }

    private void initPreNumber() {
        this.preNumber.add(DimEntityNumEnum.ENTITY.getNumber());
        this.preNumber.add(DimEntityNumEnum.YEAR.getNumber());
        this.preNumber.add(DimEntityNumEnum.PERIOD.getNumber());
        this.preNumber.add(DimEntityNumEnum.CURRENCY.getNumber());
        this.preNumber.add("BudgetPeriod");
    }

    private void initLowerKeyMap() {
        this.lowerKeyMap = new HashMap<String, String>();
        this.memberCollection.keySet().forEach(dim -> this.lowerKeyMap.put((String)dim, dim.toLowerCase(Locale.ENGLISH)));
    }

    private void initDimNumber() {
        if (this.dimNumber.isEmpty()) {
            this.dimNumber = this.userdefinedDims.stream().map(d -> d.getString("number")).collect(Collectors.toList());
            this.dimNumber.add(DimEntityNumEnum.INTERCOMPANY.getNumber());
            this.dimNumber.add(DimEntityNumEnum.CHANGETYPE.getNumber());
            this.dimNumber.add(DimEntityNumEnum.ACCOUNT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.PROCESS.getNumber());
            this.dimNumber.add(DimEntityNumEnum.AUDITTRIAL.getNumber());
            this.dimNumber.add(DimEntityNumEnum.DATASORT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.SCENARIO.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MULTIGAAP.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MYCOMPANY.getNumber());
        }
    }

    private void initAllSourceKey() {
        Map<Long, MappedDimItem> sourceDimMap = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap();
        HashSet<String> hasNumber = new HashSet<String>(16);
        for (Map.Entry<Long, MappedDimItem> map : sourceDimMap.entrySet()) {
            hasNumber.add(map.getValue().getNumber());
        }
        Collection values = this._ctx.getMappedRelation().getSingleMappedRelationPair().values();
        String srcNumber = null;
        QFilter schemeQf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        Map baseMap = null;
        DynamicObject baseDy = null;
        MappedDimItem mdi = null;
        Long baseId = 0L;
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            srcNumber = singleDimRelationPair.getSourceDimItem().getDimItem().getNumber();
            if (singleDimRelationPair.getMappedType() != 1 || hasNumber.contains(srcNumber) || this.preNumber.contains(srcNumber)) continue;
            QFilter numberQf = new QFilter("number", "=", (Object)srcNumber);
            baseMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{schemeQf, numberQf});
            for (Map.Entry map : baseMap.entrySet()) {
                baseId = (Long)map.getKey();
                baseDy = (DynamicObject)map.getValue();
                mdi = new MappedDimItem(baseId, srcNumber, srcNumber, baseDy.getString("entitynumber"));
                sourceDimMap.put(baseId, mdi);
            }
        }
        for (Map.Entry entry : sourceDimMap.entrySet()) {
            this.allSourceKey.add(((MappedDimItem)entry.getValue()).getMappedKey());
        }
    }

    private void initMemberCollection() {
        this.memberCollection = new HashMap<String, Map<String, Boolean>>(16);
        List<String> dimNumbs = DimensionServiceHelper.getDimensionNumListByModel(this._ctx.getModel().p1);
        dimNumbs.forEach(number -> {
            HashMap members = new HashMap(16);
            MemberReader.getAllNodeByDimNum((String)number, (String)((String)this._ctx.getModel().p2)).forEach(node -> members.put(node.getNumber(), node.isLeaf()));
            this.memberCollection.put((String)number, members);
        });
    }

    private void initSingleMap() {
        DynamicObject[] col;
        this.singleMap = new HashMap<Long, List<DynamicObject>>(16);
        QFilter filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        for (DynamicObject dot : col = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)this.selectField, (QFilter[])new QFilter[]{filter}, (String)"issinglemapentry.seq")) {
            Long id = dot.getLong("dimmapid");
            this.singleMap.computeIfAbsent(id, k -> new ArrayList(10));
            List<DynamicObject> objs = this.singleMap.get(id);
            objs.add(dot);
        }
        this._ctx.putCustomParam("singleMap", this.singleMap);
    }

    @Override
    public void execute() {
        log.startWatch();
        StringBuilder spendTimeMessage = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        this.beforeExecute();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", (String)"MiddleLibIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"MiddleLibIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        IDataSet ds = (IDataSet)this._provider.loadData();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%1$s]\u67e5\u8be2\u6570\u636e\u8017\u65f6,\u6e90\u6570\u636e\u6761\u6570\u4e3a%2$s", (String)"MiddleLibIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2, ((StdMdDataSet)ds).getSize()));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"MiddleLibIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        ds.forEach(row -> {
            this._ctx.putCustomParam(MATCHED, false);
            this._ctx.putCustomParam("priority", null);
            Collection accountHigh = this.accountHighPriority.get(row.get(this.mapkey.get("account")));
            if (accountHigh != null && accountHigh.size() > 0) {
                for (MappedRow maprow : accountHigh) {
                    this.match((IRow)row, maprow);
                }
            }
            if (!((Boolean)this._ctx.getCustomParam(MATCHED)).booleanValue()) {
                for (MappedRow mrow : this.notHighPriorityMappedRows) {
                    this.match((IRow)row, mrow);
                    if (this._ctx.getCustomParam("break") == null) continue;
                    this._ctx.putCustomParam("break", null);
                    break;
                }
            }
            this.handleAllFromSingleValue();
        });
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", (String)"MiddleLibIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"MiddleLibIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        this._output.output();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51faolap\u8017\u65f6", (String)"MiddleLibIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u6821\u9a8c\u68c0\u67e5\u8fc7\u7a0b\u53ca\u8f93\u51faolap\u8017\u65f6:", (String)"MiddleLibIntegrationService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.afterExecute();
        sw.stop();
        this._ctx.putCustomParam("spendTimeMessage", spendTimeMessage.toString());
    }

    private void appendSpendTimeMessage(StopWatch sw, StringBuilder sb, String message) {
        sw.split();
        sb.append(message).append(sw.toSplitString()).append(';');
        sw.reset();
        sw.start();
    }

    private void handleAllFromSingleValue() {
        if (this._ctx.getCustomParam(EXISTNORMALMAPPING) == null && this._ctx.getCustomParam(AllSINGLE_VALUE) != null) {
            ValueList vl = this._ctx.getResult().computeIfAbsent((MappedRow)this._ctx.getCustomParam(AllSINGLE_MAPPEDROW), k -> new ValueList());
            vl.addValue((IValueItem)this._ctx.getCustomParam(AllSINGLE_VALUE));
        }
        this._ctx.putCustomParam(EXISTNORMALMAPPING, null);
        this._ctx.putCustomParam(AllSINGLE_VALUE, null);
        this._ctx.putCustomParam(AllSINGLE_MAPPEDROW, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void match(IRow r, MappedRow mappedRow) {
        ValueItem valueItem = new ValueItem();
        int priority = srcAccountNotExist_priority;
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(3);
        flagMap.put("isIgnore", false);
        flagMap.put("targetMemberExist", true);
        for (MappedSourceItem src : mappedRow.getSrcMapped().values()) {
            void var9_10;
            String v;
            String upperKey = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId()).getTargetDimItem().getDimItem().getNumber();
            String string = this.lowerKeyMap.get(upperKey);
            if ("account".equals(string)) {
                priority = src.getPriority();
            }
            if (this.mapkey.containsKey(string)) {
                String string2 = this.mapkey.get(string);
            }
            if (StringUtils.isEmpty((CharSequence)(v = (String)r.get((String)var9_10)))) {
                return;
            }
            if (!ALL.equals(src.getNumber()) && !FilterFactory.getFilter(src, this._ctx).isMatched(src, v, this._ctx)) {
                return;
            }
            String targetMemNum = mappedRow.getTargMapped().get(upperKey).getNumber();
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                flagMap.put("isIgnore", true);
                continue;
            }
            if (!ALL.equals(targetMemNum)) continue;
            IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)upperKey, (String)v);
            if (m == null) {
                flagMap.put("targetMemberExist", false);
            }
            valueItem.setProperty(upperKey, m == null ? v : m.getNumber());
        }
        int allSourceSize = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap().size();
        if (allSourceSize > mappedRow.getSrcMapped().size()) {
            ArrayList<String> mappedRowKey = new ArrayList<String>(10);
            for (MappedSourceItem mappedSourceItem : mappedRow.getSrcMapped().values()) {
                mappedRowKey.add(mappedSourceItem.getMappedDim().getMappedKey());
            }
            Collection c = CollectionUtils.disjunction(this.allSourceKey, mappedRowKey);
            for (Object key : c) {
                for (Map.Entry rowKey : this._ctx.getMappedRelation().getSingleMappedRelationPair().rowMap().entrySet()) {
                    if (!key.equals(((MappedDimItem)rowKey.getKey()).getMappedKey())) continue;
                    for (Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> entry : ((Map)rowKey.getValue()).entrySet()) {
                        if (!this.dimNumber.contains(((MappedDimItem)entry.getKey()).getMappedKey())) continue;
                        String dimKey = this.lowerKeyMap.get(((MappedDimItem)entry.getKey()).getMappedKey());
                        if (null != this.mapkey.get(dimKey)) {
                            dimKey = this.mapkey.get(dimKey);
                        }
                        if (null != r.get(dimKey)) {
                            List<DynamicObject> issinglemap = this.singleMap.get(((DimMappedRelation.SingleDimRelationPair)entry.getValue()).getDimMappedId());
                            if (null == issinglemap) {
                                QFilter qf1 = new QFilter("schemeid", "=", this._ctx.getSchema().p1).and(new QFilter("dimmapid", "in", (Object)entry.getValue().getDimMappedId()));
                                DynamicObject[] temp = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)this.selectField, (QFilter[])new QFilter[]{qf1}, (String)"issinglemapentry.seq");
                                issinglemap = new ArrayList<DynamicObject>(temp.length);
                                Collections.addAll(issinglemap, temp);
                                this.singleMap.put(entry.getValue().getDimMappedId(), issinglemap);
                            }
                            if (this.matchSingleMemMap(dimKey, issinglemap, r, valueItem, entry, flagMap)) continue;
                            return;
                        }
                        return;
                    }
                }
            }
        }
        this._ctx.putCustomParam(MATCHED, true);
        if (this._ctx.getCustomParam("priority") != null && priority != (Integer)this._ctx.getCustomParam("priority")) {
            this._ctx.putCustomParam("break", true);
            return;
        }
        this._ctx.putCustomParam("priority", priority);
        ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
        BigDecimal amount = new BigDecimal(String.valueOf(r.get("amount").toString()));
        String string = (String)r.get("txt");
        if (StringUtils.isEmpty((CharSequence)string)) {
            if (mappedRow.isNegate()) {
                valueItem.setValue(amount.negate());
            } else {
                valueItem.setValue(amount);
            }
        } else {
            valueItem.setValue(string);
        }
        if (mappedRow.getSrcMapped().size() != 0) {
            if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
                vl.addValue(valueItem);
            }
            this._ctx.putCustomParam(EXISTNORMALMAPPING, true);
        } else if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
            this._ctx.putCustomParam(AllSINGLE_VALUE, valueItem);
            this._ctx.putCustomParam(AllSINGLE_MAPPEDROW, mappedRow);
        }
    }

    private boolean matchSingleMemMap(String dimKey, List<DynamicObject> issinglemap, IRow r, ValueItem valueItem, Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> dim, Map<String, Boolean> flagMap) {
        boolean matchSingle = false;
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        String v = (String)r.get(dimKey);
        for (DynamicObject isObject : issinglemap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && ALL.equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null) continue;
            if (StringUtils.isEmpty((CharSequence)v)) {
                return false;
            }
            if (sourceItem != null && !ALL.equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, v, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
            }
            if (ALL.equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)dim.getKey().getNumber(), (String)v);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            String targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue();
            if ("".equals(targetNumber)) {
                flagMap.put("targetMemberExist", false);
            } else if (IGNORE.equals(targetNumber)) {
                flagMap.put("isIgnore", true);
            }
            valueItem.setProperty(dim.getKey().getNumber(), targetNumber);
            matchSingle = true;
        }
        return matchSingle;
    }

    @Override
    protected void afterExecute() {
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        int scope = mainscope;
        MappedSourceItem item = new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, scope, false, false);
        return item;
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        List<MappedGroup> combineMappedGroup = this._ctx.getCombineMappedGroup();
        HashSet<String> numberSet = new HashSet<String>();
        Iterator<MappedRow> iterator = null;
        for (MappedGroup mappedGroup : combineMappedGroup) {
            iterator = mappedGroup.iterator();
            if (!iterator.hasNext()) continue;
            MappedRow next = iterator.next();
            Map<String, MappedTargetItem> targMapped = next.getTargMapped();
            for (Map.Entry<String, MappedTargetItem> map : targMapped.entrySet()) {
                numberSet.add(map.getKey());
            }
        }
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> singleMappedRelationPair = this._ctx.getMappedRelation().getSingleMappedRelationPair();
        Collection values = singleMappedRelationPair.values();
        MappedRow mr2 = null;
        MappedTargetItem mti = null;
        String dimTempNumber = null;
        MappedDimItem mdi = null;
        DynamicObject dimension = null;
        String memberform = null;
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            dimTempNumber = singleDimRelationPair.getTargetDimItem().getDimItem().getNumber();
            if (singleDimRelationPair.getMappedType() != 1 || this.preNumber.contains(dimTempNumber) || numberSet.contains(dimTempNumber)) continue;
            if (combineMappedGroup.size() == 0) {
                MappedGroup mg = new MappedGroup();
                combineMappedGroup.add(mg);
            }
            for (MappedGroup mg : combineMappedGroup) {
                if (mg.rowSize() == 0) {
                    mr2 = new MappedRow(false, false);
                    mg.addMappedRow(mr2);
                }
                for (MappedRow mr2 : mg) {
                    long dimensionId = MemberReader.getDimensionIdByNum((long)((Long)this._ctx.getModel().p1), (String)dimTempNumber);
                    dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"bcm_dimension");
                    memberform = dimension.getString("memberform");
                    mdi = new MappedDimItem(dimensionId, dimTempNumber, dimTempNumber, memberform);
                    mti = new MappedTargetItem(0L, ALL, mdi);
                    mr2.addMappedTargetItem(mti);
                }
            }
        }
        return combineMappedGroup;
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new ModelDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new ModelOutPut(this._ctx);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        List<MappedGroup> serviceMappedGroup = this.getServiceMappedGroup();
        if (null == serviceMappedGroup || serviceMappedGroup.size() == 0) {
            MappedRow mg = this.getMappedRow();
            this.notHighPriorityMappedRows.add(mg);
            return;
        }
        ArrayList srcIsEmpty = new ArrayList();
        serviceMappedGroup.forEach(g -> g.forEach(row -> {
            boolean accountHigh = false;
            for (MappedSourceItem src : row.getSrcMapped().values()) {
                DimMappedRelation.SingleDimRelationPair singeDimRelation = this._ctx.getMappedRelation().getSingeDimRelationByDimId(src.getMappedDim().getId());
                if (singeDimRelation == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7ec4\u5408\u6620\u5c04\u91cc\u7684\u7ef4\u5ea6\u662f\u5426\u90fd\u914d\u7f6e\u4e86\u5355\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"IntegrationNewServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                String upperKey = singeDimRelation.getTargetDimItem().getDimItem().getNumber();
                if (!DimEntityNumEnum.ACCOUNT.getNumber().equals(upperKey) || MapScopeEnum.EQUALS != MapScopeEnum.getEnumByindex((int)src.getScope()) || src.getPriority() != 999) continue;
                this.accountHighPriority.put((Object)src.getNumber(), row);
                accountHigh = true;
                break;
            }
            if (!accountHigh) {
                if (row.getSrcMapped().size() == 0) {
                    srcIsEmpty.add(row);
                } else {
                    this.notHighPriorityMappedRows.add((MappedRow)row);
                }
            }
        }));
        this.notHighPriorityMappedRows.addAll(srcIsEmpty);
    }

    private MappedRow getMappedRow() {
        long entityDimId = MemberReader.getDimensionIdByNum((long)((Long)this._ctx.getModel().p1), (String)DimEntityNumEnum.ENTITY.getNumber());
        MappedDimItem mdiEntity = new MappedDimItem(entityDimId, DimEntityNumEnum.ENTITY.getNumber(), DimEntityNumEnum.ENTITY.getNumber(), "bcm_entitymembertree");
        MappedTargetItem mtiEntity = new MappedTargetItem(0, ALL, mdiEntity);
        long accountDimId = MemberReader.getDimensionIdByNum((long)((Long)this._ctx.getModel().p1), (String)DimEntityNumEnum.ACCOUNT.getNumber());
        MappedDimItem mdiAccount = new MappedDimItem(accountDimId, DimEntityNumEnum.ACCOUNT.getNumber(), DimEntityNumEnum.ACCOUNT.getNumber(), "bcm_accountmembertree");
        MappedTargetItem mtiAccount = new MappedTargetItem(0, ALL, mdiAccount);
        MappedRow mg = new MappedRow(false, false);
        mg.addMappedTargetItem(mtiEntity);
        mg.addMappedTargetItem(mtiAccount);
        return mg;
    }
}

