/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIExportService;
import kd.fi.bcm.business.integration.model.MemMapExportColProperty;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PubMemberMapExportImp
implements IDIExportService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(PubMemberMapExportImp.class);
    protected List<String> errorMsgCollection = new ArrayList<String>(16);

    public XSSFWorkbook exportData(List<Long> dimMapIds) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        DynamicObject dimMappings = this.getDimMaps(dimMapIds);
        DynamicObjectCollection entryentity = dimMappings.getDynamicObjectCollection("entryentity");
        for (DynamicObject dimMapping : entryentity) {
            if (!dimMapIds.contains(dimMapping.getLong("id"))) continue;
            String sheetName = dimMapping.getString("cusname");
            XSSFSheet sheet = workBook.createSheet(sheetName);
            HashMap<String, MemMapExportColProperty> colProperties = this.getColHeadMap(dimMapping);
            this.renderHead(colProperties, sheet);
            this.setAutoSizeColumn(sheet, 1);
            Integer dataStartIndex = 2;
            DynamicObjectCollection mapping = this.getMemberMapData(dimMapping.getLong("id"));
            for (DynamicObject row : mapping) {
                Integer n = dataStartIndex;
                Integer n2 = dataStartIndex = Integer.valueOf(dataStartIndex + 1);
                XSSFRow currentRow = sheet.createRow(n.intValue());
                for (Map.Entry entry : colProperties.entrySet()) {
                    XSSFCell cell = currentRow.createCell(Integer.parseInt((String)entry.getKey()));
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(row.getString(((MemMapExportColProperty)entry.getValue()).getNumber()));
                }
            }
        }
        return workBook;
    }

    @Override
    public XSSFWorkbook exportTemplate(Long modelId) {
        XSSFWorkbook workBook = new XSSFWorkbook();
        List<Long> dimMapIds = this.getDimMapsByModel(modelId);
        DynamicObject dimMappings = this.getDimMaps(dimMapIds);
        DynamicObjectCollection entryentity = dimMappings.getDynamicObjectCollection("entryentity");
        for (DynamicObject dimMapping : entryentity) {
            XSSFSheet sheet = workBook.createSheet(dimMapping.getString("cusname"));
            HashMap<String, MemMapExportColProperty> colProperties = this.getColHeadMap(dimMapping);
            this.renderHead(colProperties, sheet);
            this.setAutoSizeColumn(sheet, 1);
        }
        return workBook;
    }

    private List<Long> getDimMapsByModel(Long modelId) {
        DynamicObject mappingSet = this.getMappingSetByModelId(modelId);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObjectCollection entryentity = mappingSet.getDynamicObjectCollection("entryentity");
        entryentity.forEach(e -> ids.add(e.getLong("id")));
        return ids;
    }

    private DynamicObject getMappingSetByModelId(long modelId) {
        QFilter filters = new QFilter("model", "=", (Object)modelId);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id", (QFilter[])filters.toArray());
    }

    protected void renderHead(HashMap<String, MemMapExportColProperty> colProperties, XSSFSheet sheet) {
        XSSFRow headRowMerge = sheet.createRow(0);
        XSSFRow headRow = sheet.createRow(1);
        CellStyle cellStyle = this.createHeaderCellStyle(sheet.getWorkbook());
        for (Map.Entry<String, MemMapExportColProperty> entry : colProperties.entrySet()) {
            int colIndex = Integer.parseInt(entry.getKey());
            XSSFCell mergeCell = headRowMerge.createCell(colIndex);
            mergeCell.setCellStyle(cellStyle);
            XSSFCell cell = headRow.createCell(colIndex);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(entry.getValue().getName());
            XSSFCellStyle cellDataStyle = sheet.getWorkbook().createCellStyle();
            sheet.setDefaultColumnStyle(colIndex, (CellStyle)cellDataStyle);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 1));
        headRowMerge.getCell(0).setCellValue(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"DIDimMemImpAndExpService2", (String)"fi-bcm-business", (Object[])new Object[0]));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 2, 3));
        headRowMerge.getCell(2).setCellValue(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"DIDimMemImpAndExpService8", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    protected HashMap<String, MemMapExportColProperty> getColHeadMap(DynamicObject dimMapping) {
        HashMap<String, MemMapExportColProperty> colHeadMap = new HashMap<String, MemMapExportColProperty>(16);
        String tarName = dimMapping.getDynamicObject("dimension").getString("name");
        Long tarDimId = dimMapping.getDynamicObject("dimension").getLong("id");
        String srcName = dimMapping.getDynamicObject("config").getString("name");
        Long srcDimId = dimMapping.getDynamicObject("config").getLong("id");
        colHeadMap.put(Integer.toString(0), new MemMapExportColProperty("targmembnumber", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, false));
        colHeadMap.put(Integer.toString(1), new MemMapExportColProperty("targmembname", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, true));
        colHeadMap.put(Integer.toString(2), new MemMapExportColProperty("srcmembnumber", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 1, srcDimId, false));
        colHeadMap.put(Integer.toString(3), new MemMapExportColProperty("srcmembname", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 1, srcDimId, true));
        return colHeadMap;
    }

    protected CellStyle createHeaderCellStyle(XSSFWorkbook workBook) {
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setLocked(true);
        return headerStyle;
    }

    protected void setAutoSizeColumn(XSSFSheet sheet, int headRowIndex) {
        int lastCellNum = sheet.getRow(headRowIndex).getLastCellNum();
        for (int i = 0; i <= lastCellNum; ++i) {
            int maxColSize = sheet.getColumnWidth(i);
            XSSFCell cell = sheet.getRow(headRowIndex).getCell(i);
            if (cell == null) continue;
            int colSize = cell.getStringCellValue().getBytes().length * 256 + 512;
            if (colSize > maxColSize) {
                maxColSize = colSize;
            }
            if (maxColSize > 65280) {
                maxColSize = 65280;
            }
            sheet.setColumnWidth(i, maxColSize);
        }
    }

    protected DynamicObject getDimMaps(List<Long> dimMapIds) {
        QFilter filters = new QFilter("entryentity.id", "in", dimMapIds);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
    }

    protected DynamicObjectCollection getMemberMapData(Long dimMapId) {
        String dataSelectField = "srcmembnumber,srcmembname,targmembname,targmembnumber";
        QFilter qf = new QFilter("pubmappingid", "=", (Object)dimMapId);
        return QueryServiceHelper.query((String)"bcm_issinglemap", (String)dataSelectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc");
    }

    public List<String> getErrors() {
        return this.errorMsgCollection;
    }
}

