/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.service.IDIImportService;
import kd.fi.bcm.business.integration.model.ImportFailData;
import kd.fi.bcm.business.integration.model.MemMapExportColProperty;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PubMemberMapImportImp
implements IDIImportService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(PubMemberMapImportImp.class);
    protected Integer successCount = 0;
    protected List<Object> errorMsgCollection = new ArrayList<Object>(16);
    private static final String ALL = "*";

    public void importData(String excelUrl, List<Long> dimMapIds, boolean deleteBeforeSave, Long modelId) {
        if (dimMapIds.size() == 0) {
            return;
        }
        List<DynamicObject> dimMappings = this.getDimMaps(dimMapIds);
        if (CollectionUtil.isEmpty(dimMappings)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u516c\u5171\u6620\u5c04\u3002", (String)"DIMemberMapImportImp10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(excelUrl);){
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            for (int i = 0; i < xssfWorkbook.getNumberOfSheets(); ++i) {
                XSSFSheet sheet = xssfWorkbook.getSheetAt(i);
                String mapName = sheet.getSheetName();
                DynamicObject dimMap = this.getMappingObj(dimMappings, mapName);
                if (dimMap == null) {
                    this.addErrorMsg(mapName, 0, ResManager.loadKDString((String)"\u516c\u5171\u6620\u5c04\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"PUBDimMemImpAndExpService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    continue;
                }
                Pair<Map<String, MemMapExportColProperty>, Map<String, String>> colIndexPropertiesPair = this.getImportHeadProperties(sheet, dimMap);
                Map colIndexPropertiesMap = (Map)colIndexPropertiesPair.p1;
                if (this.getErrorMsgs(sheet).size() > 0) continue;
                Map<String, DynamicObject> checkedDataMap = new LinkedHashMap<String, DynamicObject>(16);
                HashMap<String, Integer> rowDataKeyRowIndexMap = new HashMap<String, Integer>(16);
                int maxRow = sheet.getLastRowNum();
                for (int rowIndex = 2; rowIndex <= maxRow; ++rowIndex) {
                    XSSFRow row = sheet.getRow(rowIndex);
                    if (this.isEmptyRow(row)) continue;
                    DynamicObject singlemap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_issinglemap");
                    singlemap.set("pubmappingid", (Object)dimMap.getLong("id"));
                    singlemap.set("creator", (Object)RequestContext.get().getUserId());
                    singlemap.set("createtime", (Object)new Date());
                    StringBuilder sb = new StringBuilder(16);
                    String srcmembnumber = "";
                    Long srcDimId = 0L;
                    for (Map.Entry colPair : colIndexPropertiesMap.entrySet()) {
                        Integer colIndex = Integer.parseInt((String)colPair.getKey());
                        XSSFCell cell = row.getCell(colIndex.intValue());
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                        }
                        if (((MemMapExportColProperty)colPair.getValue()).getFieldType() == 1) {
                            if (!((MemMapExportColProperty)colPair.getValue()).isNameCol()) {
                                if (null == cell || StringUtils.isEmpty((String)cell.getStringCellValue())) {
                                    this.addErrorMsg(mapName, rowIndex + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u201c%1$s\u201d\u3002", (String)"PUBDimMemImpAndExpService_1", (String)"fi-bcm-business", (Object[])new Object[0]), ((MemMapExportColProperty)colPair.getValue()).getName()));
                                    continue;
                                }
                                sb.append(cell.getStringCellValue());
                            }
                            singlemap.set(((MemMapExportColProperty)colPair.getValue()).getNumber(), (Object)(cell == null ? "" : cell.getStringCellValue()));
                            continue;
                        }
                        if (((MemMapExportColProperty)colPair.getValue()).getFieldType() != 2) continue;
                        if (!((MemMapExportColProperty)colPair.getValue()).isNameCol()) {
                            if (null == cell || StringUtils.isEmpty((String)cell.getStringCellValue())) {
                                this.addErrorMsg(mapName, rowIndex + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u201c%1$s\u201d\u3002", (String)"PUBDimMemImpAndExpService_1", (String)"fi-bcm-business", (Object[])new Object[0]), ((MemMapExportColProperty)colPair.getValue()).getName()));
                                continue;
                            }
                            srcmembnumber = cell.getStringCellValue();
                            sb.append(srcmembnumber);
                            srcDimId = ((MemMapExportColProperty)colPair.getValue()).getDimId();
                        }
                        singlemap.set(((MemMapExportColProperty)colPair.getValue()).getNumber(), (Object)(cell == null ? "" : cell.getStringCellValue()));
                    }
                    singlemap.set("scope", (Object)"1");
                    DynamicObjectCollection issinglemapentry = singlemap.getDynamicObjectCollection("issinglemapentry");
                    DynamicObject singleEntry = issinglemapentry.addNew();
                    singleEntry.set("srcdim", (Object)srcDimId);
                    singleEntry.set("srcmemnumber", (Object)srcmembnumber);
                    singleEntry.set("seq", (Object)0);
                    if (this.getErrorMsgs(sheet, row).size() > 0) continue;
                    String key = sb.toString();
                    if (rowDataKeyRowIndexMap.containsKey(key)) {
                        this.addErrorMsg(mapName, rowIndex + 1, String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService7", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataKeyRowIndexMap.get(key) + 1));
                        continue;
                    }
                    rowDataKeyRowIndexMap.put(key, rowIndex);
                    checkedDataMap.put(String.valueOf(rowIndex), singlemap);
                }
                checkedDataMap = this.checkTarDataMap(checkedDataMap, mapName, (String)((Map)colIndexPropertiesPair.p2).get("tar"), modelNumber);
                if ((checkedDataMap = this.checkSrcDataMap(checkedDataMap, mapName, (String)((Map)colIndexPropertiesPair.p2).get("src"))).size() <= 0) continue;
                this.saveMembMap(checkedDataMap, dimMap, mapName, deleteBeforeSave);
                this.clearMapJson(dimMap.getLong("id"));
                this.successCount = this.successCount + checkedDataMap.size();
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"Excel\u6253\u5f00\u5931\u8d25\u3002", (String)"DIMemberMapImportImp2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25,\u8bf7\u68c0\u67e5\u6a21\u677f\u683c\u5f0f\u3002", (String)"DIMemberMapImportImp3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private Map<String, DynamicObject> checkSrcDataMap(Map<String, DynamicObject> checkedDataMap, String sheetName, String src) {
        HashMap<String, DynamicObject> resMap = new HashMap<String, DynamicObject>(16);
        List numbers = checkedDataMap.values().stream().map(e -> e.getString("srcmembnumber")).collect(Collectors.toList());
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)src, (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        Set numberSet = dyns.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        for (Map.Entry<String, DynamicObject> map : checkedDataMap.entrySet()) {
            String srcmembnumber = map.getValue().getString("srcmembnumber");
            if (numberSet.contains(srcmembnumber)) {
                resMap.put(map.getKey(), map.getValue());
                continue;
            }
            this.addErrorMsg(sheetName, Integer.parseInt(map.getKey()) + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u201c%1$s\u201d\u3002", (String)"PUBDimMemImpAndExpService_1", (String)"fi-bcm-business", (Object[])new Object[0]), srcmembnumber));
        }
        return resMap;
    }

    private Map<String, DynamicObject> checkTarDataMap(Map<String, DynamicObject> checkedDataMap, String sheetName, String tar, String modelNumber) {
        HashMap<String, DynamicObject> resMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<String, DynamicObject> map : checkedDataMap.entrySet()) {
            String targmembnumber = map.getValue().getString("targmembnumber");
            IDNumberTreeNode member = MemberReader.findMemberByNumber((String)modelNumber, (String)tar, (String)targmembnumber);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(member)) {
                this.addErrorMsg(sheetName, Integer.parseInt(map.getKey()) + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u201c%1$s\u201d\u3002", (String)"PUBDimMemImpAndExpService_1", (String)"fi-bcm-business", (Object[])new Object[0]), targmembnumber));
                continue;
            }
            map.getValue().set("targmembid", (Object)member.getBaseTreeNode().getId());
            resMap.put(map.getKey(), map.getValue());
        }
        return resMap;
    }

    private DynamicObject getMappingObj(List<DynamicObject> dimMappings, String mapName) {
        for (DynamicObject obj : dimMappings) {
            if (!mapName.equals(obj.getString("cusname"))) continue;
            return obj;
        }
        return null;
    }

    @Override
    public List<Object> getErrorMsgs() {
        return this.errorMsgCollection;
    }

    @Override
    public List<Object> getErrorMsgs(XSSFSheet sheet) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getSheetName().equals(sheet.getSheetName())).collect(Collectors.toList());
    }

    protected List<Object> getErrorMsgs(XSSFSheet sheet, XSSFRow row) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getRowNum() == row.getRowNum() + 1 && ((ImportFailData)x).getSheetName().equals(sheet.getSheetName())).collect(Collectors.toList());
    }

    protected List<Object> getErrorMsgs(String sheetName, int rowIndex) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getRowNum() == rowIndex + 1 && ((ImportFailData)x).getSheetName().equals(sheetName)).collect(Collectors.toList());
    }

    @Override
    public Integer getSuccessCount() {
        return this.successCount;
    }

    protected boolean isEmptyRow(XSSFRow row) {
        if (null == row) {
            return true;
        }
        boolean isEmpty = true;
        int maxCol = row.getLastCellNum();
        for (int i = 0; i < maxCol; ++i) {
            if (null == row.getCell(i) || !StringUtils.isNotEmpty((String)row.getCell(i).toString())) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    protected int saveMembMap(Map<String, DynamicObject> checkedDataMap, DynamicObject dimMap, String sheetName, boolean deleteBeforeSave) {
        List<Object> needSaveDatas = new ArrayList<DynamicObject>();
        if (deleteBeforeSave) {
            this.deleteMembMapByDimMapId(dimMap.getLong("id"));
            needSaveDatas = checkedDataMap.values().stream().collect(Collectors.toList());
        }
        this.fillDimMappingSeq(dimMap.getLong("id"), needSaveDatas);
        Object[] result = SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_issinglemap"), (Object[])needSaveDatas.toArray());
        return result.length;
    }

    private void fillDimMappingSeq(Long dimMapId, List<DynamicObject> needSaveDatas) {
        Integer maxSeq = this.getMemberMappingMaxSeq(dimMapId);
        for (DynamicObject obj : needSaveDatas) {
            int dseq = obj.getInt("dseq");
            if (dseq != 0) continue;
            maxSeq = maxSeq + 1;
            obj.set("dseq", (Object)maxSeq);
        }
    }

    private Integer getMemberMappingMaxSeq(Long dimMapId) {
        String dataSelectField = "max(dseq)";
        QFilter qf = new QFilter("pubmappingid", "=", (Object)dimMapId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_issinglemap", (String)dataSelectField, (QFilter[])qf.toArray());
        return object.getInt("max(dseq)");
    }

    protected void deleteMembMapByDimMapId(long dimMappingId) {
        QFilter qf = new QFilter("pubmappingid", "=", (Object)dimMappingId);
        DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])qf.toArray());
    }

    protected DynamicObject[] getMemberMapping(Long dimMappingId) {
        String dataSelectField = "id,dseq,srcmembname,srcmembnumber,targmembname,targmembnumber";
        QFilter qf = new QFilter("pubmappingid", "=", (Object)dimMappingId);
        return BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)dataSelectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc");
    }

    private Pair<Map<String, MemMapExportColProperty>, Map<String, String>> getImportHeadProperties(XSSFSheet sheet, DynamicObject dimMap) {
        HashMap<String, MemMapExportColProperty> colIndexPropertiesMap = new HashMap<String, MemMapExportColProperty>(16);
        XSSFRow groupRow = sheet.getRow(0);
        XSSFRow headRow = sheet.getRow(1);
        int maxColNum = headRow.getPhysicalNumberOfCells();
        HashMap headNameIndexMap = new HashMap(16);
        HashMap groupNameIndexMap = new HashMap(16);
        for (int colIndex = 0; colIndex < maxColNum; ++colIndex) {
            XSSFCell headCell;
            CellRangeAddress mergeHeadCellAddress;
            XSSFCell groupCell = groupRow.getCell(colIndex);
            CellRangeAddress mergeGroupCellAddress = this.getMergeRange(sheet, groupCell);
            if (null != mergeGroupCellAddress) {
                groupCell = sheet.getRow(mergeGroupCellAddress.getFirstRow()).getCell(mergeGroupCellAddress.getFirstColumn());
            }
            if (null != groupCell) {
                if (groupNameIndexMap.containsKey(groupCell.getStringCellValue())) {
                    ((List)groupNameIndexMap.get(groupCell.getStringCellValue())).add(colIndex);
                } else {
                    ArrayList<Integer> indexs = new ArrayList<Integer>();
                    indexs.add(colIndex);
                    groupNameIndexMap.put(groupCell.getStringCellValue(), indexs);
                }
            }
            if (null != (mergeHeadCellAddress = this.getMergeRange(sheet, headCell = headRow.getCell(colIndex)))) {
                headCell = sheet.getRow(mergeHeadCellAddress.getFirstRow()).getCell(mergeHeadCellAddress.getFirstColumn());
            }
            if (null == headCell) continue;
            if (headNameIndexMap.containsKey(headCell.getStringCellValue())) {
                ((List)headNameIndexMap.get(headCell.getStringCellValue())).add(colIndex);
                continue;
            }
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            indexs.add(colIndex);
            headNameIndexMap.put(headCell.getStringCellValue(), indexs);
        }
        List tarCellIndexs = (List)groupNameIndexMap.get(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"DIDimMemImpAndExpService2", (String)"fi-bcm-business", (Object[])new Object[0]));
        List srcCellIndexs = (List)groupNameIndexMap.get(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"DIDimMemImpAndExpService8", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (null == tarCellIndexs || null == srcCellIndexs) {
            this.addErrorMsg(sheet.getSheetName(), 1, ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef", (String)"DIMemberMapImportImp1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return Pair.onePair(colIndexPropertiesMap, null);
        }
        Pair<List<MemMapExportColProperty>, Map<String, String>> headPropertiesPair = this.getColHeadNamePropertyMap(dimMap);
        List headProperties = (List)headPropertiesPair.p1;
        for (MemMapExportColProperty colProperty : headProperties) {
            Collection intersectIndex;
            if (!headNameIndexMap.containsKey(colProperty.getName())) {
                this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService3", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                continue;
            }
            List indexs = (List)headNameIndexMap.get(colProperty.getName());
            if (colProperty.getFieldType() == 1) {
                intersectIndex = CollectionUtils.intersection((Collection)indexs, (Collection)tarCellIndexs);
                if (intersectIndex.size() == 0) {
                    this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c\u76ee\u6807\u7cfb\u7edf\u201d\u4e2d\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService4", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                    continue;
                }
                colIndexPropertiesMap.put(intersectIndex.toArray()[0].toString(), colProperty);
                continue;
            }
            if (colProperty.getFieldType() != 2) continue;
            intersectIndex = CollectionUtils.intersection((Collection)indexs, (Collection)srcCellIndexs);
            if (intersectIndex.size() == 0) {
                this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c\u6e90\u7cfb\u7edf\u201d\u4e2d\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService5", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                continue;
            }
            colIndexPropertiesMap.put(intersectIndex.toArray()[0].toString(), colProperty);
        }
        return Pair.onePair(colIndexPropertiesMap, (Object)headPropertiesPair.p2);
    }

    protected String getMemberMapRowKey(DynamicObject dimMemberMapRow) {
        String targmembnumber = dimMemberMapRow.getString("targmembnumber");
        String srcmembnumber = dimMemberMapRow.getString("srcmembnumber");
        return targmembnumber + ";" + srcmembnumber;
    }

    protected Pair<List<MemMapExportColProperty>, Map<String, String>> getColHeadNamePropertyMap(DynamicObject dimMapping) {
        ArrayList<MemMapExportColProperty> colHeadList = new ArrayList<MemMapExportColProperty>(16);
        HashMap<String, String> dimenMap = new HashMap<String, String>(16);
        DynamicObject dimension = dimMapping.getDynamicObject("dimension");
        String tarName = dimension.getString("name");
        Long tarDimId = dimension.getLong("id");
        colHeadList.add(new MemMapExportColProperty("targmembnumber", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, false, 0));
        colHeadList.add(new MemMapExportColProperty("targmembname", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, true, 1));
        dimenMap.put("tar", dimension.getString("number"));
        DynamicObject config = dimMapping.getDynamicObject("config");
        String srcName = config.getString("name");
        Long srcDimId = config.getLong("id");
        colHeadList.add(new MemMapExportColProperty("srcmembnumber", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, false, 2));
        colHeadList.add(new MemMapExportColProperty("srcmembname", String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, true, 3));
        dimenMap.put("src", config.getString("number"));
        return Pair.onePair(colHeadList, dimenMap);
    }

    protected CellRangeAddress getMergeRange(XSSFSheet sheet, XSSFCell cell) {
        Optional<CellRangeAddress> mergeOpt = sheet.getMergedRegions().stream().filter(x -> x.getFirstRow() <= cell.getRowIndex() && x.getLastRow() >= cell.getRowIndex() && x.getFirstColumn() <= cell.getColumnIndex() && x.getLastColumn() >= cell.getColumnIndex()).findFirst();
        if (mergeOpt.isPresent()) {
            return mergeOpt.get();
        }
        return null;
    }

    protected void addErrorMsg(String sheetName, Integer rowNumber, String msg) {
        this.errorMsgCollection.add(new ImportFailData(sheetName, rowNumber, msg));
    }

    protected List<DynamicObject> getDimMaps(List<Long> dimMapIds) {
        QFilter filters = new QFilter("entryentity.id", "in", dimMapIds);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"bcm_bdmapping", (String)"entryentity.id, entryentity.cusname, entryentity.config, entryentity.dimension", (QFilter[])filters.toArray());
        if (dyn == null) {
            return null;
        }
        ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dyn.getDynamicObjectCollection("entryentity")) {
            if (!dimMapIds.contains(dy.getLong("id"))) continue;
            dys.add(dy);
        }
        return dys;
    }

    protected void clearMapJson(Long dimMapId) {
        String searchText = "id,dimmapid,type,spreadjson,data";
        QFilter qf = new QFilter("dimmapid", "=", (Object)dimMapId);
        DynamicObject[] mapJsonObjs = BusinessDataServiceHelper.load((String)"bcm_ismapjson", (String)searchText, (QFilter[])new QFilter[]{qf});
        if (mapJsonObjs.length == 0) {
            return;
        }
        DynamicObject mapJsonObj = mapJsonObjs[0];
        mapJsonObj.set("data", (Object)"");
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_ismapjson"), (Object[])new DynamicObject[]{mapJsonObj});
    }
}

