/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.FilterFactory;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.output.XExtendOutPut;
import kd.fi.bcm.business.integrationnew.provider.IDataProvider;
import kd.fi.bcm.business.integrationnew.provider.standard2my.XExtendDataProvider;
import kd.fi.bcm.business.integrationnew.service.AbstractFlowIntergrateService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.enums.integration.ValueItemPriorityEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class XExtendIntegrationService
extends AbstractFlowIntergrateService {
    List<String> extendFields = new ArrayList<String>();
    protected Map<String, String> mapkey;
    protected Map<Long, List<DynamicObject>> singleMap;
    protected List<String> dimNumber = new ArrayList<String>(10);
    protected Set<String> preNumber = new HashSet<String>(10);
    protected static final String MATCHED = "matched";
    protected static final String IGNORE = "IGNORE";
    protected static final String TARMEMBERNOTEXIST = "tarMemberNotExist";
    protected static final String TARMEMBERNOTLEAF = "tarMemberNotLeaf";
    protected static final String CHECKRESULT = "checkresult";
    protected Map<String, Map<String, Boolean>> memberCollection;
    protected List<String> allSourceKey = new ArrayList<String>();
    protected Map<String, String> lowerKeyMap;
    protected long extendModelId;
    protected String selectField = "dseq,dimmapid,scope,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.seq,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber";
    DynamicObjectCollection userdefinedDims;

    public XExtendIntegrationService(IIntegrateContext ctx) {
        super(ctx);
        DynamicObject isScheme = BusinessDataServiceHelper.loadSingle((Object)ctx.getSchema().p1, (String)"bcm_isscheme", (String)"extendsmodel.id");
        this.extendModelId = isScheme.getLong("extendsmodel.id");
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"extfield.number", (QFilter[])new QFilter("extmodelid", "=", (Object)this.extendModelId).toArray(), (String)"sequence").values().forEach(f -> this.extendFields.add(f.getString("extfield.number")));
        ctx.putCustomParam("extendModelId", this.extendModelId);
        this.initPreNumber();
        this.mapkey = new HashMap<String, String>(16);
        ctx.getMappedRelation().getSingleMappedRelationPair().values().forEach(v -> {
            if (v.getMappedType() == 1) {
                this.mapkey.put(v.getTargetDimItem().getDimItem().getNumber().toLowerCase(Locale.ENGLISH), v.getSourceDimItem().getDimItem().getNumber());
            }
        });
        this.initSingleMap();
        this.userdefinedDims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,fieldmapped,membermodel,number,dseq", (QFilter[])new QFBuilder().add("model", "=", this._ctx.getModel().p1).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        this.initDimNumber();
        this.initMemberCollection();
        this.initAllSourceKey();
        this.initLowerKeyMap();
    }

    private void initLowerKeyMap() {
        this.lowerKeyMap = new HashMap<String, String>();
        this.memberCollection.keySet().forEach(dim -> this.lowerKeyMap.put((String)dim, dim.toLowerCase(Locale.ENGLISH)));
    }

    private void initPreNumber() {
        this.preNumber.add(DimEntityNumEnum.ENTITY.getNumber());
        this.preNumber.add(DimEntityNumEnum.YEAR.getNumber());
        this.preNumber.add(DimEntityNumEnum.PERIOD.getNumber());
        this.preNumber.add(DimEntityNumEnum.CURRENCY.getNumber());
    }

    private void initDimNumber() {
        if (this.dimNumber.isEmpty()) {
            this.dimNumber = this.userdefinedDims.stream().map(d -> d.getString("number")).collect(Collectors.toList());
            this.dimNumber.add(DimEntityNumEnum.INTERCOMPANY.getNumber());
            this.dimNumber.add(DimEntityNumEnum.CHANGETYPE.getNumber());
            this.dimNumber.add(DimEntityNumEnum.ACCOUNT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.PROCESS.getNumber());
            this.dimNumber.add(DimEntityNumEnum.AUDITTRIAL.getNumber());
            this.dimNumber.add(DimEntityNumEnum.DATASORT.getNumber());
            this.dimNumber.add(DimEntityNumEnum.SCENARIO.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MULTIGAAP.getNumber());
            this.dimNumber.add(DimEntityNumEnum.MYCOMPANY.getNumber());
        }
    }

    private void initAllSourceKey() {
        Map<Long, MappedDimItem> sourceDimMap = this._ctx.getMappedRelation().getMultiDimRelaionPair().getSourceDimMap();
        HashSet<String> hasNumber = new HashSet<String>(16);
        for (Map.Entry<Long, MappedDimItem> map : sourceDimMap.entrySet()) {
            hasNumber.add(map.getValue().getNumber());
        }
        Collection values = this._ctx.getMappedRelation().getSingleMappedRelationPair().values();
        QFilter schemeQf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        for (DimMappedRelation.SingleDimRelationPair singleDimRelationPair : values) {
            String srcNumber = singleDimRelationPair.getSourceDimItem().getDimItem().getNumber();
            if (singleDimRelationPair.getMappedType() != 1 || hasNumber.contains(srcNumber) || this.preNumber.contains(srcNumber)) continue;
            QFilter numberQf = new QFilter("number", "=", (Object)srcNumber);
            Map baseMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{schemeQf, numberQf});
            for (Map.Entry map : baseMap.entrySet()) {
                Long baseId = (Long)map.getKey();
                DynamicObject baseDy = (DynamicObject)map.getValue();
                MappedDimItem mdi = new MappedDimItem(baseId, srcNumber, srcNumber, baseDy.getString("entitynumber"));
                sourceDimMap.put(baseId, mdi);
            }
        }
        for (Map.Entry entry : sourceDimMap.entrySet()) {
            this.allSourceKey.add(((MappedDimItem)entry.getValue()).getMappedKey());
        }
    }

    private void initMemberCollection() {
        this.memberCollection = new HashMap<String, Map<String, Boolean>>(16);
        List<String> dimNumbs = DimensionServiceHelper.getDimensionNumListByModel(this._ctx.getModel().p1);
        dimNumbs.forEach(number -> {
            HashMap members = new HashMap(16);
            MemberReader.getAllNodeByDimNum((String)number, (String)((String)this._ctx.getModel().p2)).forEach(node -> members.put(node.getNumber(), node.isLeaf()));
            this.memberCollection.put((String)number, members);
        });
    }

    private void initSingleMap() {
        DynamicObject[] col;
        this.singleMap = new HashMap<Long, List<DynamicObject>>(16);
        QFilter filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
        for (DynamicObject dot : col = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)this.selectField, (QFilter[])new QFilter[]{filter}, (String)"issinglemapentry.seq")) {
            Long id = dot.getLong("dimmapid");
            this.singleMap.computeIfAbsent(id, k -> new ArrayList(10));
            List<DynamicObject> objs = this.singleMap.get(id);
            objs.add(dot);
        }
    }

    @Override
    public void execute() {
        this.checkExtModelLockStatus();
        StringBuilder spendTimeMessage = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        this.callServiceflow(sw, spendTimeMessage);
        this.beforeExecute();
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"MiddleLibIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        IDataSet ds = (IDataSet)this._provider.loadData();
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"MiddleLibIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        ds.forEach(row -> {
            this._ctx.putCustomParam(MATCHED, false);
            this.match((IRow)row, new MappedRow(false, false));
        });
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"MiddleLibIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        this._output.output();
        this.appendSpendTimeMessage(sw, spendTimeMessage, ResManager.loadKDString((String)"\u8f93\u51fa\u5230\u62d3\u5c55\u6570\u636e\u8868\u8017\u65f6:", (String)"MiddleLibIntegrationService_17", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.afterExecute();
        sw.stop();
        this._ctx.putCustomParam("spendTimeMessage", spendTimeMessage.toString());
    }

    @Override
    public void match(IRow r, MappedRow mappedRow) {
        ValueItem valueItem = new ValueItem();
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(3);
        flagMap.put("isIgnore", false);
        flagMap.put("targetMemberExist", true);
        for (String key : this.allSourceKey) {
            for (Map.Entry rowKey : this._ctx.getMappedRelation().getSingleMappedRelationPair().rowMap().entrySet()) {
                if (!key.equals(((MappedDimItem)rowKey.getKey()).getMappedKey())) continue;
                for (Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> entry : ((Map)rowKey.getValue()).entrySet()) {
                    if (!this.dimNumber.contains(((MappedDimItem)entry.getKey()).getMappedKey())) continue;
                    String dimKey = this.lowerKeyMap.get(((MappedDimItem)entry.getKey()).getMappedKey());
                    if (null != this.mapkey.get(dimKey)) {
                        dimKey = this.mapkey.get(dimKey);
                    }
                    if (null != r.get(dimKey)) {
                        List<DynamicObject> issinglemap = this.singleMap.get(((DimMappedRelation.SingleDimRelationPair)entry.getValue()).getDimMappedId());
                        if (null == issinglemap) {
                            QFilter qf1 = new QFilter("schemeid", "=", this._ctx.getSchema().p1).and(new QFilter("dimmapid", "in", (Object)entry.getValue().getDimMappedId()));
                            DynamicObject[] temp = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)this.selectField, (QFilter[])new QFilter[]{qf1}, (String)"issinglemapentry.seq");
                            temp = this.addExtendsMap(temp, (Long)this._ctx.getSchema().p1, entry.getValue().getDimMappedId());
                            issinglemap = new ArrayList<DynamicObject>(temp.length);
                            Collections.addAll(issinglemap, temp);
                            this.singleMap.put(entry.getValue().getDimMappedId(), issinglemap);
                        }
                        if (this.matchSingleMemMap(dimKey, issinglemap, r, valueItem, entry, flagMap)) continue;
                        return;
                    }
                    return;
                }
            }
        }
        if (!((Boolean)flagMap.get("isIgnore")).booleanValue() && ((Boolean)flagMap.get("targetMemberExist")).booleanValue()) {
            Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
            this._ctx.putCustomParam(MATCHED, true);
            ValueList vl = this._ctx.getResult().computeIfAbsent(mappedRow, k -> new ValueList());
            for (String fieldNumber : this.extendFields) {
                valueItem.setProperty((String)singleDimMap.get(fieldNumber), r.get((String)singleDimMap.get(fieldNumber)));
            }
            vl.addValue(valueItem);
        }
    }

    private DynamicObject[] addExtendsMap(DynamicObject[] temp, Long schemeId, long dimMappedId) {
        if (temp.length > 0) {
            return temp;
        }
        Map attrMap = (Map)this._ctx.getCustomParam("exAttrMap");
        Map map = (Map)attrMap.get(dimMappedId);
        Long id = (Long)map.get("inheritancescheme");
        if (id == null || id == 0L) {
            return temp;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("scheme", "=", (Object)id);
        qf.add("number", "=", map.get("number"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id", (QFilter[])qf.toArray());
        if (load == null || load.length == 0) {
            return temp;
        }
        QFilter qf1 = new QFilter("schemeid", "=", (Object)id).and(new QFilter("dimmapid", "in", (Object)load[0].getLong("id")));
        return BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)this.selectField, (QFilter[])new QFilter[]{qf1}, (String)"issinglemapentry.seq");
    }

    protected boolean matchSingleMemMap(String dimKey, List<DynamicObject> issinglemap, IRow r, ValueItem valueItem, Map.Entry<MappedDimItem, DimMappedRelation.SingleDimRelationPair> dim, Map<String, Boolean> flagMap) {
        boolean matchSingle = false;
        HashMap<Integer, String> tempTargetMap = new HashMap<Integer, String>(16);
        String v = (String)r.get(dimKey);
        for (DynamicObject isObject : issinglemap) {
            int scope = isObject.getInt("scope");
            MappedSourceItem sourceItem = null;
            for (DynamicObject srcDyn : isObject.getDynamicObjectCollection("issinglemapentry")) {
                if (sourceItem == null) {
                    sourceItem = this.buildSourceMapped(srcDyn, scope);
                    continue;
                }
                sourceItem.mergeSourceItem(this.buildSourceMapped(srcDyn, scope));
            }
            int isPriority = 0;
            if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.EQUALS) {
                isPriority = sourceItem != null && "*".equals(sourceItem.getNumber()) ? ValueItemPriorityEnum.LOW.getValue() : ValueItemPriorityEnum.HIGH.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.RANGE) {
                isPriority = ValueItemPriorityEnum.BETWEEN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.INCLUDE) {
                isPriority = ValueItemPriorityEnum.IN.getValue();
            } else if (MapScopeEnum.getEnumByindex((int)scope) == MapScopeEnum.LIKE) {
                isPriority = ValueItemPriorityEnum.LIKE.getValue();
            }
            if (tempTargetMap.get(isPriority) != null) continue;
            if (StringUtils.isEmpty((CharSequence)v)) {
                return false;
            }
            if (sourceItem != null && !"*".equals(sourceItem.getNumber()) && !FilterFactory.getFilter(sourceItem, this._ctx).isMatched(sourceItem, v, this._ctx)) continue;
            String targetMemNum = isObject.getString("targmembnumber");
            if (IGNORE.equalsIgnoreCase(targetMemNum)) {
                tempTargetMap.put(isPriority, IGNORE);
            }
            if ("*".equals(targetMemNum)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)dim.getKey().getNumber(), (String)v);
                if (m != null) {
                    tempTargetMap.put(isPriority, m.getNumber());
                    continue;
                }
                tempTargetMap.put(isPriority, "");
                continue;
            }
            tempTargetMap.put(isPriority, targetMemNum);
        }
        if (tempTargetMap.size() > 0) {
            String targetNumber = (String)tempTargetMap.entrySet().stream().max(Map.Entry.comparingByKey()).get().getValue();
            if ("".equals(targetNumber)) {
                flagMap.put("targetMemberExist", false);
            } else if (IGNORE.equals(targetNumber)) {
                flagMap.put("isIgnore", true);
            }
            Map singleDimMap = (Map)this._ctx.getCustomParam("singleDimMap");
            valueItem.setProperty((String)singleDimMap.get(dim.getKey().getNumber()), targetNumber);
            matchSingle = true;
        }
        return matchSingle;
    }

    private void checkExtModelLockStatus() {
        DynamicObjectCollection lockedData;
        HashSet org = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getOrg().p1});
        HashSet scenario = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getScene().p1});
        HashSet fy = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getFy().p1});
        HashSet period = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getPeriod().p1});
        HashSet<Long> currency = new HashSet<Long>(16);
        if ((Long)this._ctx.getCurrency().p1 != 0L) {
            IDNumberTreeNode node = MemberReader.findCurrencyMemberById((String)((String)this._ctx.getModel().p2), (Long)((Long)this._ctx.getCurrency().p1));
            if ("DC".equals(node.getNumber())) {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)((String)this._ctx.getModel().p2), (Long)((Long)this._ctx.getOrg().p1));
                String currencyNum = orgNode.getCurrency();
                IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)((String)this._ctx.getModel().p2), (String)currencyNum);
                currency.add(currencyNode.getId());
            } else {
                currency.add((Long)this._ctx.getCurrency().p1);
            }
        }
        if ((lockedData = ExtDataLockServiceHelper.isLocked((long)((Long)this._ctx.getModel().p1), this.extendModelId, org, scenario, fy, period, currency)).isEmpty()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u6267\u884c\u96c6\u6210", (String)"DIIntegrationService_21", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    @Override
    protected void afterExecute() {
    }

    private MappedSourceItem buildSourceMapped(DynamicObject srcEntry, int mainscope) {
        String membNum = srcEntry.getString("srcmemnumber");
        long membId = srcEntry.getLong("srcmembid");
        long dimId = srcEntry.getLong("srcdim");
        int seq = srcEntry.getInt("seq");
        return new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, mainscope, false, false);
    }

    @Override
    protected IDataProvider<IDataSet<IRow>> getDataProvider() {
        return new XExtendDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new XExtendOutPut(this._ctx);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        return null;
    }
}

