/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.servicehelper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class IntegrateServiceHelper {
    private static final String ALL = "*";

    public static boolean doCollect(boolean isSync, Long logId, Long modelId, List<Long> orgIds, Long scenarioId, Long yearId, Long periodId, List<Long> schemeIds, Set<String> tarCollectStatus) {
        tarCollectStatus.remove(" ");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode scenario = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId);
        IDNumberTreeNode year = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode period = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        DynamicObject[] schemeAssigns = IntegrateServiceHelper.getSchemeAssignRecords(modelId, schemeIds);
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        orgIds.forEach(e -> {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)modelNum, (Long)e);
            orgMap.put(org.getNumber(), (Long)e);
        });
        Table<Long, Long, DynamicObject> schemeOrgIdTable = IntegrateServiceHelper.getSchemeOrgIdTable(modelId, orgMap, schemeAssigns);
        ArrayList<Long> schemes = new ArrayList<Long>(schemeOrgIdTable.rowKeySet());
        IntegrationUtil.filterSchemeByScenarioAndDate(modelId, scenario.getNumber(), period.getNumber(), year.getNumber(), schemes);
        Map<String, String> recordStatusMap = IntegrateServiceHelper.collectRecordStatus(modelId, orgIds, scenarioId, yearId, periodId, schemes);
        ArrayList needRemove = Lists.newArrayList();
        for (Table.Cell cell : schemeOrgIdTable.cellSet()) {
            String key = cell.getRowKey() + "_" + cell.getColumnKey();
            if (!schemes.contains(cell.getRowKey()) || !orgIds.contains(cell.getColumnKey())) {
                needRemove.add(key);
                continue;
            }
            if (tarCollectStatus.size() <= 0 || !tarCollectStatus.stream().noneMatch(status -> status.equals(recordStatusMap.getOrDefault(key, Integer.toString(CollectStatusEnum.READY.getValue()))))) continue;
            needRemove.add(key);
        }
        for (String s : needRemove) {
            String[] idArray = s.split("_");
            schemeOrgIdTable.remove((Object)Long.parseLong(idArray[0]), (Object)Long.parseLong(idArray[1]));
        }
        IntegrateEntity intEntity = new IntegrateEntity();
        intEntity.setModel(modelId, modelNum);
        intEntity.setScene(scenario.getId(), scenario.getNumber());
        intEntity.setYear(year.getId(), year.getNumber());
        intEntity.setPeriod(period.getId(), period.getNumber());
        intEntity.setCurrency(MemberReader.findCurrencyMemberByNum((String)modelNum, (String)"EC").getId(), "EC");
        intEntity.putCustomParam("isEntryIntegrate", false);
        intEntity.putCustomParam("scheduleLogId", logId);
        List<Long> rateOrgIdList = IntegrationUtil.getRateOrgIdList(modelId);
        for (Table.Cell cell : schemeOrgIdTable.cellSet()) {
            Long orgId = (Long)cell.getColumnKey();
            Long schemeId = (Long)cell.getRowKey();
            String orgNum = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId).getNumber();
            QFilter filter = new QFilter("id", "=", (Object)schemeId);
            String schemeNum = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"number", (QFilter[])filter.toArray()).getString("number");
            if (rateOrgIdList.contains(orgId)) {
                IntegrationUtil.saveRateSchemeCurrency2IntEntity(intEntity, schemeId, orgNum);
                List<Pair<Long, String>> currency4Rate = intEntity.getCurrency4Rate();
                for (int i = 0; i < currency4Rate.size(); ++i) {
                    intEntity.addOrgSchemePair(orgId, orgNum, schemeId, schemeNum);
                }
                continue;
            }
            intEntity.addOrgSchemePair(orgId, orgNum, schemeId, schemeNum);
        }
        if (intEntity.getOrgSchemePairs().size() == 0) {
            return false;
        }
        IntegrateDispatcher2.submitTaskDistribute(intEntity, isSync, false, null);
        return true;
    }

    private static Map<String, String> collectRecordStatus(Long modelId, List<Long> orgIds, Long scenarioId, Long yearId, Long periodId, List<Long> schemeIds) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("scenario", "=", (Object)scenarioId);
        qf.add("fy", "=", (Object)yearId);
        qf.add("period", "=", (Object)periodId);
        qf.add("scheme", "in", schemeIds);
        qf.add("org.number", "in", (Object)MemberReader.change2MemberNumsById((long)modelId, (String)"bcm_entitymembertree", orgIds));
        HashMap<String, String> result = new HashMap<String, String>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_isschemeexecuterec", (String)"scheme,org,collectstatus", (QFilter[])qf.toArray(), null);){
            ds.forEachRemaining(row -> result.put(row.getString("scheme") + "_" + row.getString("org"), row.getString("collectstatus")));
        }
        return result;
    }

    public static DynamicObject[] getSchemeAssignRecords(Long modelId, List<Long> schemeIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        if (schemeIds != null) {
            qfBuilder.add("scheme", "in", schemeIds);
        }
        qfBuilder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{true}));
        qfBuilder.add(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        String selectProperties = "scheme,entity,property,propertyvalue,range,applytype";
        return BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray(), (String)"scheme,applytype desc");
    }

    public static Table<Long, Long, DynamicObject> getSchemeOrgIdTable(Long modelId, Map<String, Long> orgMap, DynamicObject[] assignRecords) {
        Long entityId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (DynamicObject schemeAssign : assignRecords) {
            schemeIds.add(schemeAssign.getDynamicObject("scheme").getLong("id"));
        }
        Pair<Map<String, List<Long>>, Map<String, List<Long>>> orgMember2Pair = IntegrationUtil.filterSingleMapMems(entityId, schemeIds, new ArrayList<String>(orgMap.keySet()));
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : assignRecords) {
            String number;
            long id;
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyValue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyValue)) continue;
                id = propertyValue.getLong("id");
                number = propertyValue.getString("number");
            } else {
                id = entity.getLong("id");
                number = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", (Long)id, number, schemeAssign.getInt("range"), isCustom, (Object)modelId);
            String applytype = schemeAssign.getString("applytype");
            rangItem.matchItems(arg_0 -> IntegrateServiceHelper.lambda$getSchemeOrgIdTable$3(orgMap, schemeAssign, orgMember2Pair, applytype, (Table)schemeOrgIdMaps, arg_0));
        }
        return schemeOrgIdMaps;
    }

    private static /* synthetic */ void lambda$getSchemeOrgIdTable$3(Map orgMap, DynamicObject schemeAssign, Pair orgMember2Pair, String applytype, Table schemeOrgIdMaps, SimpleItem c) {
        DynamicObject scheme;
        if (orgMap.containsKey(c.number) && (scheme = schemeAssign.getDynamicObject("scheme")) != null) {
            Long schemeid = scheme.getLong("id");
            if ((((Map)orgMember2Pair.p1).get(c.number) != null && ((List)((Map)orgMember2Pair.p1).get(c.number)).contains(schemeid) || ((Map)orgMember2Pair.p1).get(ALL) != null && ((List)((Map)orgMember2Pair.p1).get(ALL)).contains(schemeid)) && (((Map)orgMember2Pair.p2).get(c.number) == null || !((List)((Map)orgMember2Pair.p2).get(c.number)).contains(schemeid))) {
                if ("0".equals(applytype)) {
                    schemeOrgIdMaps.remove((Object)schemeid, orgMap.get(c.number));
                } else {
                    schemeOrgIdMaps.put((Object)schemeid, orgMap.get(c.number), (Object)scheme);
                }
            }
        }
    }
}

