/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class ISImportModeUtil {
    public static void updateImportMode(Tuple<Long, String, String> scheme, ISImpModeEnum importModeEnum) {
        DynamicObject importMode = BusinessDataServiceHelper.loadSingle((String)"bcm_isimportmode", (String)"importmode,model,dimension,modifier,modifydate", (QFilter[])new QFilter("scheme", "=", scheme.p1).toArray());
        if (importMode != null && !importModeEnum.getCode().equals(importMode.getString("importmode"))) {
            Long modelId = importMode.getLong("model.id");
            String oldImportMode = importMode.getString("importmode");
            String oldDimension = importMode.getString("dimension.number");
            importMode.set("importmode", (Object)importModeEnum.getCode());
            importMode.set("dimension", null);
            importMode.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            importMode.set("modifydate", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{importMode});
            String opName = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"ISImportModeUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]);
            String opDescription = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff1a%1$s,\u5bfc\u5165\u6a21\u5f0f\uff1a%2$s->%3$s,\u7ef4\u5ea6\uff1a%4$s->%5$s", (String)"ISImportModeUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), scheme.p2, ISImpModeEnum.getNameByCode((String)oldImportMode), importModeEnum.getBridge().loadKDString(), oldDimension, null);
            OperationLogUtil.writeOperationLog(opName, opDescription, modelId, "bcm_isscheme");
        }
    }

    public static void copyImportModeToNewScheme(Long oldSchemeId, DynamicObject newScheme) {
        DynamicObject importMode = BusinessDataServiceHelper.loadSingle((String)"bcm_isimportmode", (String)"id", (QFilter[])new QFilter("scheme", "=", (Object)oldSchemeId).toArray());
        if (!Objects.isNull(importMode)) {
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject importModeNew = (DynamicObject)cloneUtils.clone((IDataEntityBase)BusinessDataServiceHelper.loadSingle((Object)importMode.getLong("id"), (String)"bcm_isimportmode"));
            importModeNew.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            importModeNew.set("scheme", (Object)newScheme);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{importModeNew});
            ISImportModeUtil.setImpModeToScheme(newScheme, importModeNew);
        }
        ISImportModeUtil.copyClearDataConfig(oldSchemeId, newScheme);
    }

    private static void copyClearDataConfig(Long oldSchemeId, DynamicObject newScheme) {
        QFilter qf = new QFilter("isscheme", "=", (Object)oldSchemeId);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bcm_iscleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        if (configs == null || configs.length == 0) {
            return;
        }
        DynamicObject[] configsNew = new DynamicObject[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject configNew = (DynamicObject)cloneUtils.clone((IDataEntityBase)BusinessDataServiceHelper.loadSingle((Object)configs[i].getLong("id"), (String)"bcm_iscleardataconfig"));
            configNew.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            configNew.set("isscheme", (Object)newScheme);
            configsNew[i] = configNew;
        }
        SaveServiceHelper.save((DynamicObject[])configsNew);
    }

    public static void setImpModeToScheme(DynamicObject scheme, DynamicObject importMode) {
        scheme.set("importmodeid", (Object)importMode);
    }

    public static Optional<DynamicObject> getTarLackDimDefEntry(DynamicObject[] tarLackDimMaps, String dimensionNum) {
        for (DynamicObject tarLackDimMap : tarLackDimMaps) {
            Optional<DynamicObject> tarLack = tarLackDimMap.getDynamicObjectCollection("isdimmaptargentry").stream().filter(x -> dimensionNum.equals(x.getString("tagdimension.number"))).findFirst();
            if (!tarLack.isPresent()) continue;
            return tarLack;
        }
        return Optional.empty();
    }

    public static Optional<DynamicObject> getTarLackDimDefEntryByScheme(DynamicObject[] tarLackDimMaps, String dimensionNum, Long schemeId) {
        for (DynamicObject tarLackDimMap : tarLackDimMaps) {
            Optional<DynamicObject> tarLack;
            if (!schemeId.equals(tarLackDimMap.getLong("scheme.id")) || !(tarLack = tarLackDimMap.getDynamicObjectCollection("isdimmaptargentry").stream().filter(x -> dimensionNum.equals(x.getString("tagdimension.number"))).findFirst()).isPresent()) continue;
            return tarLack;
        }
        return Optional.empty();
    }

    public static String getImportModeByScheme(Long schemeId) {
        DynamicObject importMode = BusinessDataServiceHelper.loadSingle((String)"bcm_isimportmode", (String)"importmode", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray());
        return Objects.isNull(importMode) ? ISImpModeEnum.MERGEIMPORT.getCode() : importMode.getString("importmode");
    }

    public static String getImportModeBySchemeDI(Long schemeId) {
        Long importModelId = ISImportModeUtil.getImportModeIdScheme(schemeId);
        return ISImportModeUtil.getImportModeById(importModelId);
    }

    public static Long getImportModeIdScheme(Long schemeId) {
        QFilter qf = new QFilter("id", "=", (Object)schemeId);
        DynamicObject importMode = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"importmodeid", (QFilter[])qf.toArray());
        return importMode.getLong("importmodeid");
    }

    public static String getImportModeById(Long fid) {
        DynamicObject importMode = QueryServiceHelper.queryOne((String)"bcm_isimportmode", (String)"importmode", (QFilter[])new QFilter("id", "=", (Object)fid).toArray());
        return Objects.isNull(importMode) ? "" : importMode.getString("importmode");
    }

    public static String getTarLackDimMemberDI(Long schemeId) {
        Long importModelId = ISImportModeUtil.getImportModeIdScheme(schemeId);
        DynamicObject importMode = BusinessDataServiceHelper.loadSingle((String)"bcm_isimportmode", (String)"importmode,otherdim", (QFilter[])new QFilter("id", "=", (Object)importModelId).toArray());
        if (importMode != null && ISImpModeEnum.REPLACEIMPORT.getCode().equals(importMode.getString("importmode"))) {
            return importMode.getString("otherdim");
        }
        return null;
    }

    public static Map<Pair<String, String>, Set<Pair<String, String>>> getTarLackDimMember(Long schemeId) {
        String cacheKey = "getTarLackDimMember_" + schemeId;
        Map cachedResult = (Map)ThreadCache.get((Object)cacheKey);
        if (cachedResult != null) {
            return cachedResult;
        }
        DynamicObject importMode = BusinessDataServiceHelper.loadSingle((String)"bcm_isimportmode", (String)"importmode,dimension", (QFilter[])new QFilter("scheme", "=", (Object)schemeId).toArray());
        if (importMode != null && ISImpModeEnum.REPLACEIMPORT.getCode().equals(importMode.getString("importmode"))) {
            DynamicObject dimension = importMode.getDynamicObject("dimension");
            String dimNum = dimension.getString("number");
            String dimName = dimension.getString("name");
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
            qFilter.and("mappedtype", "=", (Object)"2");
            DynamicObject[] tarLackDimMaps = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"isdimmaptargentry,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmaptargdefval,isdimmaptargdefval.targetmemnum,isdimmaptargdefval.tagmemname", (QFilter[])qFilter.toArray());
            Optional<DynamicObject> tarLackDimDefEntry = ISImportModeUtil.getTarLackDimDefEntry(tarLackDimMaps, dimNum);
            if (tarLackDimDefEntry.isPresent()) {
                Set tarLackDefVal = tarLackDimDefEntry.get().getDynamicObjectCollection("isdimmaptargdefval").stream().map(t -> Pair.onePair((Object)t.getString("targetmemnum"), (Object)t.getString("tagmemname"))).collect(Collectors.toSet());
                Map<Pair<String, String>, Set<Pair<String, String>>> result = Collections.singletonMap(Pair.onePair((Object)dimNum, (Object)dimName), tarLackDefVal);
                ThreadCache.put((Object)cacheKey, result);
                return result;
            }
        }
        return null;
    }

    public static void getAllReplaceImport(long modelId) {
        DynamicObjectCollection product = QueryServiceHelper.query((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "not like", (Object)"DI%")});
        Set productIds = product.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        Set schemeIds = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("issrc", "in", productIds), new QFilter("model", "=", (Object)modelId)}).stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
        QFilter schemes = new QFilter("scheme", "in", schemeIds);
        QFilter replaceImport = new QFilter("importmode", "=", (Object)ISImpModeEnum.REPLACEIMPORT.getCode());
        DynamicObjectCollection importModes = QueryServiceHelper.query((String)"bcm_isimportmode", (String)"importmode,dimension.number,dimension.name,scheme", (QFilter[])new QFilter[]{schemes, replaceImport});
        HashMap<Long, DynamicObject> importModeMap = new HashMap<Long, DynamicObject>(schemeIds.size());
        for (DynamicObject importMode : importModes) {
            if (importMode == null || !ISImpModeEnum.REPLACEIMPORT.getCode().equals(importMode.getString("importmode"))) continue;
            importModeMap.put(importMode.getLong("scheme"), importMode);
        }
        Set replaceImportSchemes = importModes.stream().map(i -> i.getLong("scheme")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("scheme", "in", replaceImportSchemes);
        qFilter.and("mappedtype", "=", (Object)"2");
        DynamicObject[] tarLackDimMaps = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"scheme.id,isdimmaptargentry,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmaptargdefval,isdimmaptargdefval.targetmemnum,isdimmaptargdefval.tagmemname", (QFilter[])qFilter.toArray());
        for (Long schemeId : replaceImportSchemes) {
            String cacheKey = "getAllReplaceImport_" + schemeId;
            DynamicObject dimension = (DynamicObject)importModeMap.get(schemeId);
            String dimNum = dimension.getString("dimension.number");
            String dimName = dimension.getString("dimension.name");
            Optional<DynamicObject> tarLackDimDefEntry = ISImportModeUtil.getTarLackDimDefEntryByScheme(tarLackDimMaps, dimNum, schemeId);
            if (!tarLackDimDefEntry.isPresent()) continue;
            Set tarLackDefVal = tarLackDimDefEntry.get().getDynamicObjectCollection("isdimmaptargdefval").stream().map(t -> Pair.onePair((Object)t.getString("targetmemnum"), (Object)t.getString("tagmemname"))).collect(Collectors.toSet());
            Map result = Collections.singletonMap(Pair.onePair((Object)dimNum, (Object)dimName), tarLackDefVal);
            ThreadCache.put((Object)cacheKey, result);
        }
    }

    public static String getImportModeDimMem(Long schemeId) {
        Map<Pair<String, String>, Set<Pair<String, String>>> tarLackDimMember = ISImportModeUtil.getTarLackDimMember(schemeId);
        if (Objects.isNull(tarLackDimMember)) {
            return "";
        }
        Map.Entry<Pair<String, String>, Set<Pair<String, String>>> next = tarLackDimMember.entrySet().iterator().next();
        String members = next.getValue().stream().map(p -> (String)p.p2).collect(Collectors.joining("."));
        String dimName = (String)next.getKey().p2;
        return dimName + "." + members;
    }
}

