/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.ISCustomServiceConfig;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.integrationnew.util.SingleMapModel;
import kd.fi.bcm.business.permission.cache.MemPermClassCacheManager;
import kd.fi.bcm.business.permission.cache.MembPermCacheItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class IntegrationUtil {
    private static final Log log = LogFactory.getLog(IntegrationUtil.class);
    private static final String IGNORE = "IGNORE";
    private static final String ALL = "*";
    private static final String SPLIT = "@";
    private static final String NULL = "null";
    private static final String ORGID = "orgid";
    private static final String ORGNUMBER = "orgnumber";
    private static final int HTTP_CONN_TIMEOUT = 30000;
    private static final int HTTP_READ_TIMEOUT = 600000;
    public static final String NEED_ALL_DIMS = "needAllDims";
    public static final String DIMENSION = "dimension";
    public static final String DATA = "data";
    public static final String DEFAULT_MODEL = "930UnitTest12";
    private static final String selectFields = "id,name,number,parent,isleaf,storagetype,orgcode,currency,model,longnumber,copyfrom.id";

    public static DataSet queryCombineDimension(Long schemeId, Long orgId) {
        boolean isFalse = false;
        return IntegrationUtil.doQueryCombine(schemeId, orgId, v -> {
            QFilter schemeFilter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{v});
            String selectFields = IntegrationUtil.getSelectField(isFalse);
            return QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_isgroupmap", (String)selectFields, (QFilter[])schemeFilter.toArray(), null);
        });
    }

    public static DataSet queryCombineFomular(Long schemeId, Long orgId) {
        return IntegrationUtil.doQueryCombine(schemeId, orgId, IntegrationUtil::queryCombineFomular);
    }

    public static DataSet queryCombineFomular(Long schemeId) {
        boolean isTrue = true;
        QFilter schemeFilter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{schemeId});
        String selectFields = IntegrationUtil.getSelectField(isTrue);
        return QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_isgroupmap", (String)selectFields, (QFilter[])schemeFilter.toArray(), null);
    }

    public static DynamicObjectCollection queryCombine(Long schemeId, Long orgId, Set<Long> templateIds, Long periodId) {
        String templateStr = "templateid";
        DynamicObjectCollection collection = new DynamicObjectCollection();
        return IntegrationUtil.doQueryCombine(schemeId, orgId, v -> {
            QFilter schemeFilter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{v});
            HashSet<Long> newTemplateIds = new HashSet<Long>(templateIds);
            if (templateIds.size() > 0) {
                newTemplateIds.removeIf(newTemplateId -> !IntegrationUtil.isInner(periodId, newTemplateId));
                if (newTemplateIds.size() == 0) {
                    return collection;
                }
                schemeFilter.and(new QFilter(templateStr, "in", (Object)templateIds));
            }
            String selectFields = IntegrationUtil.getSelectField(null);
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)selectFields, (QFilter[])schemeFilter.toArray(), (String)"isgroupsrcmapentry.priority desc");
            HashMap<Long, Boolean> innerMap = new HashMap<Long, Boolean>();
            for (DynamicObject load : loads) {
                boolean isInner;
                if (load.get(templateStr) == null) {
                    collection.add((Object)load);
                    continue;
                }
                long templateId = ((DynamicObject)load.get(templateStr)).getLong("id");
                if (innerMap.get(templateId) == null) {
                    isInner = IntegrationUtil.isInner(periodId, templateId);
                    innerMap.put(templateId, isInner);
                } else {
                    isInner = (Boolean)innerMap.get(templateId);
                }
                if (!isInner) continue;
                collection.add((Object)load);
            }
            return collection;
        });
    }

    private static boolean isInner(Long periodId, long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bcm_templateentity");
        TemplateModel tm = new TemplateModel();
        tm.loadDynaObj2Model(template);
        boolean isInner = TemplateRangeService.isInnerRange("bcm_periodmembertree", tm, periodId);
        return isInner;
    }

    public static List<Long> querySchemeIdsByTemplateIds(Long model, Set<Long> templateIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.integrationnew.util.IntegrationUtil.querySchemeIdsByTemplateIds(Set<Long>)", (String)"bcm_isgroupmap", (String)"schemeid", (QFilter[])QFilter.of((String)"schemeid.model = ?", (Object[])new Object[]{model}).and(new QFilter("templateid", "in", templateIds)).toArray(), null);){
            queryDataSet.forEach(row -> result.add(row.getLong("schemeid")));
        }
        return result;
    }

    public static List<Long> querySchemeIdsByEAS2NG(Long model) {
        ArrayList<Long> result = new ArrayList<Long>();
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)model);
        qf.add("istarg.number", "=", (Object)"NG");
        qf.add("status", "=", (Object)"1");
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.integrationnew.util.IntegrationUtil.querySchemeIdsByEAS2NG(Long)", (String)"bcm_isscheme", (String)"id", (QFilter[])qf.toArray(), null);){
            queryDataSet.forEach(row -> result.add(row.getLong("id")));
        }
        return result;
    }

    private static <T> T doQueryCombine(Long schemeId, Long orgId, Function<Long, T> function) {
        String orgNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bcm_entitymembertree", (String)"number").getString("number");
        String selectProperties = "model,entity,property,propertyvalue,range";
        DynamicObject[] schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{schemeId}).toArray());
        boolean[] flag = new boolean[]{false};
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            Long mId = 0L;
            String mnumber = null;
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)schemeAssign.getDynamicObject("model").getLong("id"));
            rangItem.matchItems(c -> {
                if (StringUtils.equals((CharSequence)orgNumber, (CharSequence)c.number)) {
                    flag[0] = true;
                }
            });
            if (flag[0]) break;
        }
        if (flag[0]) {
            return function.apply(schemeId);
        }
        throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u8be5\u65b9\u6848\u7684\u4f7f\u7528\u6743", (String)"IntegrationUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public static String getSelectField(Boolean isFomular) {
        ArrayList<String> fields = new ArrayList<String>(30);
        fields.add("id");
        fields.add("dseq");
        fields.add("group");
        fields.add("computeoprt");
        fields.add("isdyna");
        fields.add("dimmapid");
        fields.add("templateid");
        fields.add("srctype");
        fields.add("order");
        fields.add("level");
        fields.add("weight");
        fields.add("isgrouptargmapentry.tarmember");
        fields.add("isgrouptargmapentry.id");
        fields.add("isgrouptargmapentry.tardimension");
        fields.add("isgrouptargmapentry.tarmembnumber");
        fields.add("isgrouptargmapentry.tarmembname");
        fields.add("isgrouptargmapentry.seq");
        fields.add("isgroupsrcmapentry.priority");
        if (isFomular == null) {
            fields.add("isgroupsrcmapentry.srcmember");
            fields.add("isgroupsrcmapentry.id");
            fields.add("isgroupsrcmapentry.srcdimension");
            fields.add("isgroupsrcmapentry.srcmembnumber");
            fields.add("isgroupsrcmapentry.isdynadim");
            fields.add("isgroupsrcmapentry.scope");
            fields.add("isgroupsrcmapentry.seq");
            fields.add("isgroupsrcmapentry.istext");
            fields.add("isgroupsrcmapentry.srcpropertyid");
            fields.add("isgroupsrcexprentry.expressions");
            fields.add("isgroupsrcexprentry.id");
        } else if (isFomular.booleanValue()) {
            fields.add("isgroupsrcexprentry.expressions");
            fields.add("isgroupsrcexprentry.id");
        } else {
            fields.add("isgroupsrcmapentry.srcmember");
            fields.add("isgroupsrcmapentry.id");
            fields.add("isgroupsrcmapentry.srcdimension");
            fields.add("isgroupsrcmapentry.srcmembnumber");
            fields.add("isgroupsrcmapentry.srcmembname");
            fields.add("isgroupsrcmapentry.isdynadim");
            fields.add("isgroupsrcmapentry.scope");
            fields.add("isgroupsrcmapentry.istext");
            fields.add("isgroupsrcmapentry.srcpropertyid");
            fields.add("isgroupsrcmapentry.seq");
        }
        return fields.stream().collect(Collectors.joining(","));
    }

    public static DataSet queryISBaseDataList(long schemeId) {
        return QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_isbaseentlist", (String)"id,entitynumber,number", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)}, null);
    }

    public static DataSet queryDimensionList(long modelId) {
        return QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_dimension", (String)"id,membermodel,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, null);
    }

    public static DynamicObject[] queryDefaultAndMemMapping(long schemeId) {
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,sequence, mappedtype, tagbyfrom, tagdimension, tagdimtype, tagmemb, tagmemname, targetmemnum, srcbyfrom, srcdimension, srcdimtype, srcmemb, srcmemname, soucememnum, inheritancescheme, filtervalue, datafiltercondition, reservedfield, number", (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{schemeId}).toArray());
    }

    public static void main(String[] args) {
        IntegrationUtil.queryDefaultAndMemMapping(726499519277318144L);
    }

    public static void debugSql(WatchLogger log, String accountBalance, QFBuilder builder, List<String> selectors) {
        kd.fi.bcm.business.integration.util.IntegrationUtil.debugSql(log, accountBalance, builder, selectors);
    }

    public static Map<Long, Set<String>> queryCommonMemMapping(Long schemeId, Pair<Long, String> org, Pair<Long, String> currency, Pair<Long, String> fy, Pair<Long, String> period) {
        HashMap<Long, Set<String>> idNumberMap = new HashMap<Long, Set<String>>();
        QFilter filter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{schemeId}).and(new QFilter("targmembid", "in", (Object)Lists.newArrayList((Object[])new Long[]{(Long)org.p1, (Long)currency.p1, (Long)fy.p1, (Long)period.p1})));
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_issinglemap", (String)"id,dimmapid,srcmembnumber, targmembid", (QFilter[])filter.toArray(), null);){
            for (Row next : queryDataSet) {
                Long targetId = next.getLong("targmembid");
                HashSet<String> numbers = (HashSet<String>)idNumberMap.get(targetId);
                if (numbers == null) {
                    numbers = new HashSet<String>();
                    idNumberMap.put(targetId, numbers);
                }
                numbers.add(next.getString("srcmembnumber"));
            }
        }
        if (idNumberMap.size() < 4) {
            filter = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{schemeId}).and(new QFilter("targmembid", "in", (Object)Lists.newArrayList((Object[])new Long[]{0L})));
            queryDataSet = QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_issinglemap", (String)"id,dimmapid,srcmembnumber, targmembid", (QFilter[])filter.toArray(), null);
            var8_8 = null;
            try {
                for (Row next : queryDataSet) {
                    DynamicObject dimMap;
                    DynamicObjectCollection isdimmaptargentry;
                    String srcmembnumber = next.getString("srcmembnumber");
                    if (!ALL.equals(srcmembnumber) || (isdimmaptargentry = (dimMap = BusinessDataServiceHelper.loadSingle((Object)next.getLong("dimmapid"), (String)"bcm_isdimmap")).getDynamicObjectCollection("isdimmaptargentry")).size() <= 0) continue;
                    DynamicObject bcm_dimension = ((DynamicObject)isdimmaptargentry.get(0)).getDynamicObject("tagdimension");
                    if (DimTypesEnum.ENTITY.getNumber().equals(bcm_dimension.getString("number")) && !idNumberMap.containsKey(org.p1)) {
                        IntegrationUtil.setNumbers(idNumberMap, (Long)org.p1, (String)org.p2);
                        continue;
                    }
                    if (DimTypesEnum.CURRENCY.getNumber().equals(bcm_dimension.getString("number")) && !idNumberMap.containsKey(currency.p1)) {
                        IntegrationUtil.setNumbers(idNumberMap, (Long)currency.p1, (String)currency.p2);
                        continue;
                    }
                    if (DimTypesEnum.YEAR.getNumber().equals(bcm_dimension.getString("number")) && !idNumberMap.containsKey(fy.p1)) {
                        IntegrationUtil.setNumbers(idNumberMap, (Long)fy.p1, (String)fy.p2);
                        continue;
                    }
                    if (!DimTypesEnum.PERIOD.getNumber().equals(bcm_dimension.getString("number")) || idNumberMap.containsKey(period.p1)) continue;
                    IntegrationUtil.setNumbers(idNumberMap, (Long)period.p1, (String)period.p2);
                }
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (queryDataSet != null) {
                    if (var8_8 != null) {
                        try {
                            queryDataSet.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        queryDataSet.close();
                    }
                }
            }
        }
        return idNumberMap;
    }

    private static void setNumbers(Map<Long, Set<String>> idNumberMap, Long targetId, String srcmembnumber) {
        Set<String> numbers = idNumberMap.get(targetId);
        if (numbers == null) {
            numbers = new HashSet<String>();
            idNumberMap.put(targetId, numbers);
        }
        numbers.add(srcmembnumber);
    }

    public static DataSet queryMemberMapped(QFBuilder qf, String selector) {
        return QueryServiceHelper.queryDataSet((String)IntegrationUtil.class.getName(), (String)"bcm_issinglemap", (String)(selector == null ? "targmembnumber,targmembid,issinglemapentry.srcmemnumber" : selector), (QFilter[])qf.toArray(), (String)"dseq");
    }

    public static DynamicObjectCollection queryMemberMappedObj(QFBuilder qf, String selector) {
        return QueryServiceHelper.query((String)"bcm_issinglemap", (String)(selector == null ? "pubmappingid, targmembnumber,srcmembnumber,targmembid,issinglemapentry.srcmemnumber" : selector), (QFilter[])qf.toArray(), (String)"dseq");
    }

    public static List<DynamicObject> queryExMemberMapped(Long dimMappedId, String selector, Map<Long, Map<String, Object>> attrMap, String dimNum) {
        QFBuilder qf = new QFBuilder();
        qf.add("dimmapid", "=", (Object)dimMappedId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"pubmappingid, scheme.model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimMappedId)});
        boolean isMappingSetEnable = IntegrationUtil.checkMappingSetEnable(0L, dynamicObject.getLong("scheme.model.id"));
        if (isMappingSetEnable && dynamicObject != null && dynamicObject.getLong("pubmappingid") != 0L) {
            qf.or("pubmappingid", "=", (Object)dynamicObject.getLong("pubmappingid"));
        }
        DynamicObjectCollection ds = IntegrationUtil.queryMemberMappedObj(qf, selector);
        boolean isUniqTar = IntegrationUtil.checkIs4Dim(dimNum);
        Pair<List<DynamicObject>, Set<String>> numberPair = IntegrationUtil.getNumberSet(ds, isUniqTar);
        IntegrationUtil.addPubMapping(ds, numberPair, isUniqTar);
        if (((List)numberPair.p1).size() > 0) {
            return (List)numberPair.p1;
        }
        if (attrMap == null || attrMap.size() == 0) {
            return (List)numberPair.p1;
        }
        Map<String, Object> map = attrMap.get(dimMappedId);
        Long id = (Long)map.get("inheritancescheme");
        if (id == null || id == 0L) {
            return ds;
        }
        qf.clear();
        qf.add("scheme", "=", (Object)id);
        qf.add("number", "=", map.get("number"));
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])qf.toArray());
        if (load == null || load.size() == 0) {
            return ds;
        }
        qf.clear();
        qf.add("dimmapid", "=", (Object)((DynamicObject)load.get(0)).getLong("id"));
        return IntegrationUtil.queryMemberMappedObj(qf, selector);
    }

    public static boolean checkMappingSetEnable(long schemeId, long modelId) {
        DynamicObject obj;
        if (modelId == 0L && (obj = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"model.id", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray())) != null) {
            modelId = obj.getLong("model.id");
        }
        QFilter filters = new QFilter("model", "=", (Object)modelId);
        filters.and(new QFilter("status", "=", (Object)"1"));
        return QueryServiceHelper.exists((String)"bcm_bdmapping", (QFilter[])filters.toArray());
    }

    private static void addPubMapping(DynamicObjectCollection cos, Pair<List<DynamicObject>, Set<String>> numberPair, boolean isUniqTar) {
        for (DynamicObject obj : cos) {
            if (obj.getLong("pubmappingid") <= 0L) continue;
            if (isUniqTar && !((Set)numberPair.p2).contains(obj.getString("targmembnumber"))) {
                ((List)numberPair.p1).add(obj);
                continue;
            }
            if (isUniqTar || ((Set)numberPair.p2).contains(obj.getString("srcmembnumber"))) continue;
            ((List)numberPair.p1).add(obj);
        }
    }

    private static Pair<List<DynamicObject>, Set<String>> getNumberSet(DynamicObjectCollection cos, boolean isUniqTar) {
        ArrayList<DynamicObject> resObj = new ArrayList<DynamicObject>(16);
        HashSet<String> uniqSet = new HashSet<String>(16);
        for (DynamicObject obj : cos) {
            if (obj.getLong("pubmappingid") != 0L) continue;
            resObj.add(obj);
            if (isUniqTar) {
                uniqSet.add(obj.getString("targmembnumber"));
                continue;
            }
            uniqSet.add(obj.getString("srcmembnumber"));
        }
        return Pair.onePair(resObj, uniqSet);
    }

    public static Long copy(Object primaryKeyValue, Object number, Object name) {
        HashBasedTable result = HashBasedTable.create();
        DynamicObject schemDyn = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bcm_isscheme");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        long schemeId = GlobalIdUtil.genGlobalLongId();
        long oldId = schemDyn.getLong("id");
        schemDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)schemDyn);
        schemDyn.set("id", (Object)schemeId);
        schemDyn.set("number", number);
        schemDyn.set("name", name);
        schemDyn.set("modifier", (Object)RequestContext.get().getUserId());
        schemDyn.set("creator", (Object)RequestContext.get().getUserId());
        schemDyn.set("modifytime", (Object)TimeServiceHelper.now());
        schemDyn.set("createtime", (Object)TimeServiceHelper.now());
        schemDyn.set("effectivedate", (Object)schemDyn.getDate("effectivedate"));
        schemDyn.set("expiringdate", (Object)schemDyn.getDate("expiringdate"));
        schemDyn.set("versionnumber", (Object)new BigDecimal(1));
        schemDyn.set("status", (Object)"0");
        result.put((Object)"bcm_isscheme", (Object)oldId, (Object)schemDyn);
        IntegrationUtil.handleBasedata((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        List<Object> dimIds = IntegrationUtil.handleDim((Table<String, Long, DynamicObject>)result, schemDyn, schemeId, oldId);
        IntegrationUtil.handleSingle((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleComb((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleSheet((Table<String, Long, DynamicObject>)result, dimIds);
        Map<Long, Long> idMap = IntegrationUtil.handleSheetMapping((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handlePageSelect((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleCellMapping((Table<String, Long, DynamicObject>)result, schemeId, oldId, idMap);
        IntegrationUtil.handleAssignEntity(oldId, schemeId);
        IntegrationUtil.handleIni(oldId, schemeId);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                IntegrationUtil.handleImportMode(oldId, schemDyn);
                result.rowMap().forEach((k, v) -> {
                    Collection values = v.values();
                    if (values.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
                    }
                });
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return schemeId;
    }

    private static void handleIni(long oldSchemeId, long newSchemeId) {
        QFilter filter = new QFilter("scheme", "=", (Object)oldSchemeId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "type,scheme,value,ordernum";
        DynamicObjectCollection inis = QueryServiceHelper.query((String)"bcm_iniruledata", (String)selectFields, (QFilter[])filters);
        ArrayList<DynamicObject> Copys = new ArrayList<DynamicObject>(inis.size());
        long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        Date date = new Date();
        for (DynamicObject ini : inis) {
            DynamicObject copyItem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iniruledata");
            copyItem.set("scheme", (Object)newSchemeId);
            copyItem.set("type", (Object)ini.getString("type"));
            copyItem.set("value", (Object)ini.getString("value"));
            copyItem.set("ordernum", (Object)ini.getInt("ordernum"));
            copyItem.set("creater", (Object)userId);
            copyItem.set("createdate", (Object)date);
            copyItem.set("modifier", (Object)userId);
            copyItem.set("modifydate", (Object)date);
            Copys.add(copyItem);
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_iniruledata"), (Object[])Copys.toArray());
    }

    private static void handleAssignEntity(long oldSchemeId, long newSchemeId) {
        QFilter filter = new QFilter("scheme", "=", (Object)oldSchemeId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "entity,scheme,textname,property,range,propertyvalue,model,applytype";
        DynamicObjectCollection assignEntitys = QueryServiceHelper.query((String)"bcm_isschemeassignentity", (String)selectFields, (QFilter[])filters);
        ArrayList<DynamicObject> Copys = new ArrayList<DynamicObject>(assignEntitys.size());
        for (DynamicObject item : assignEntitys) {
            DynamicObject copyItem = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeassignentity");
            copyItem.set("model", item.get("model"));
            copyItem.set("entity", item.get("entity"));
            copyItem.set("scheme", (Object)newSchemeId);
            copyItem.set("textname", item.get("textname"));
            copyItem.set("property", item.get("property"));
            copyItem.set("range", item.get("range"));
            copyItem.set("propertyvalue", item.get("propertyvalue"));
            copyItem.set("applytype", item.get("applytype"));
            Copys.add(copyItem);
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_isschemeassignentity"), (Object[])Copys.toArray());
    }

    private static void handlePageSelect(Table<String, Long, DynamicObject> result, long schemeId, long oldId) {
        QFilter filters = QFilter.of((String)"scheme = ?", (Object[])new Object[]{oldId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isspagedimselect", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] dimmapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isspagedimselect"));
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)dimmapDyns.length);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < dimmapDyns.length; ++i) {
            DynamicObject temp = dimmapDyns[i];
            oldId = temp.getLong("id");
            temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
            temp.set("scheme_id", (Object)schemeId);
            temp.set("scheme", (Object)schemeId);
            temp.set("id", (Object)genGlobalLongIds[i]);
            result.put((Object)"bcm_isspagedimselect", (Object)oldId, (Object)temp);
        }
    }

    private static void handleCellMapping(Table<String, Long, DynamicObject> result, long schemeId, long oldId, Map<Long, Long> idMap) {
        QFilter filters = QFilter.of((String)"scheme = ?", (Object[])new Object[]{oldId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_iscellmappingdata", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] dimmapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_iscellmappingdata"));
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)dimmapDyns.length);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < dimmapDyns.length; ++i) {
            DynamicObject temp = dimmapDyns[i];
            oldId = temp.getLong("id");
            temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
            temp.set("scheme_id", (Object)schemeId);
            temp.set("scheme", (Object)schemeId);
            temp.set("id", (Object)genGlobalLongIds[i]);
            temp.set("sheetmappingid", (Object)idMap.get(temp.getLong("sheetmappingid")));
            result.put((Object)"bcm_iscellmappingdata", (Object)oldId, (Object)temp);
        }
    }

    private static Map<Long, Long> handleSheetMapping(Table<String, Long, DynamicObject> result, long schemeId, long oldId) {
        QFilter filters = QFilter.of((String)"scheme = ?", (Object[])new Object[]{oldId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_issheetmapping", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] dimmapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_issheetmapping"));
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)dimmapDyns.length);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(dimmapDyns.length);
        for (int i = 0; i < dimmapDyns.length; ++i) {
            DynamicObject temp = dimmapDyns[i];
            oldId = temp.getLong("id");
            temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
            temp.set("scheme_id", (Object)schemeId);
            temp.set("scheme", (Object)schemeId);
            temp.set("id", (Object)genGlobalLongIds[i]);
            result.put((Object)"bcm_issheetmapping", (Object)oldId, (Object)temp);
            idMap.put(oldId, genGlobalLongIds[i]);
        }
        return idMap;
    }

    private static void handleImportMode(Long oldId, DynamicObject schemDyn) {
        ISImportModeUtil.copyImportModeToNewScheme(oldId, schemDyn);
    }

    private static void handleBasedata(Table<String, Long, DynamicObject> result, long schemeId, long oldSchemeId) {
        QFilter filters = QFilter.of((String)"scheme = ?", (Object[])new Object[]{oldSchemeId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isbaseentlist", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] basedataDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isbaseentlist"));
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)basedataDyns.length);
        String meta = "bcm_isbaseentlist";
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < basedataDyns.length; ++i) {
            DynamicObject temp = basedataDyns[i];
            long oldId = temp.getLong("id");
            temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
            temp.set("id", (Object)genGlobalLongIds[i]);
            temp.set("scheme_id", (Object)schemeId);
            result.put((Object)meta, (Object)oldId, (Object)temp);
        }
    }

    private static List<Object> handleDim(Table<String, Long, DynamicObject> result, DynamicObject schemDyn, long schemeId, long oldSchemeId) {
        QFilter filters = QFilter.of((String)"scheme = ?", (Object[])new Object[]{oldSchemeId});
        CloneUtils cloneUtils = new CloneUtils(true, true);
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isdimmap", (QFilter[])filters.toArray(), null, (int)-1);
        ArrayList<Object> dimIds = new ArrayList<Object>(queryPrimaryKeys);
        DynamicObject[] dimmapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isdimmap"));
        MappingContext context = new MappingContext(schemDyn);
        boolean isSrcNg = context.isSrcNg();
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)dimmapDyns.length);
        String meta = "bcm_isdimmap";
        for (int i = 0; i < dimmapDyns.length; ++i) {
            DynamicObjectCollection tarDims;
            DynamicObject temp = dimmapDyns[i];
            long oldId = temp.getLong("id");
            temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
            temp.set("scheme_id", (Object)schemeId);
            temp.set("id", (Object)genGlobalLongIds[i]);
            result.put((Object)meta, (Object)oldId, (Object)temp);
            DynamicObjectCollection srcDims = temp.getDynamicObjectCollection("isdimmapsrcentry");
            if (srcDims != null && srcDims.size() > 0) {
                for (DynamicObject srcDim : srcDims) {
                    srcDim.set("id", null);
                    DynamicObjectCollection srcdefval = srcDim.getDynamicObjectCollection("isdimmapsrcdefval");
                    if (srcdefval != null && srcdefval.size() > 0) {
                        for (DynamicObject defval : srcdefval) {
                            defval.set("id", null);
                        }
                    }
                    if (isSrcNg) continue;
                    srcDim.set("srcdimension", result.get((Object)"bcm_isbaseentlist", (Object)srcDim.getDynamicObject("srcdimension").getLong("id")));
                }
            }
            if ((tarDims = temp.getDynamicObjectCollection("isdimmaptargentry")) == null || tarDims.size() <= 0) continue;
            for (DynamicObject tarDim : tarDims) {
                tarDim.set("id", null);
                DynamicObjectCollection tardefval = tarDim.getDynamicObjectCollection("isdimmaptargdefval");
                if (tardefval != null && tardefval.size() > 0) {
                    for (DynamicObject defval : tardefval) {
                        defval.set("id", null);
                    }
                }
                if (!isSrcNg) continue;
                tarDim.set("tagdimension", result.get((Object)"bcm_isbaseentlist", (Object)tarDim.getDynamicObject("tagdimension").getLong("id")));
            }
        }
        return dimIds;
    }

    private static void handleSingle(Table<String, Long, DynamicObject> result, long schemeId, long oldSchemeId) {
        QFilter filters = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{oldSchemeId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_issinglemap", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] singlemapDyns = null;
        if (queryPrimaryKeys != null && queryPrimaryKeys.size() > 0) {
            singlemapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_issinglemap"));
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        if (singlemapDyns != null && singlemapDyns.length > 0) {
            String meta = "bcm_issinglemap";
            for (int i = 0; i < singlemapDyns.length; ++i) {
                DynamicObject temp = singlemapDyns[i];
                long oldId = temp.getLong("id");
                temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
                temp.set("schemeid_id", (Object)schemeId);
                temp.set("id", null);
                DynamicObject dimmap = (DynamicObject)result.get((Object)"bcm_isdimmap", (Object)temp.getLong("dimmapid"));
                temp.set("dimmapid", (Object)dimmap.getLong("id"));
                result.put((Object)meta, (Object)oldId, (Object)temp);
                DynamicObjectCollection singleEntitys = temp.getDynamicObjectCollection("issinglemapentry");
                if (singleEntitys == null || singleEntitys.size() <= 0) continue;
                for (DynamicObject singleentry : singleEntitys) {
                    singleentry.set("id", null);
                    singleentry.set("srcdim", (Object)((DynamicObject)result.get((Object)"bcm_isbaseentlist", (Object)singleentry.getLong("srcdim"))).getLong("id"));
                }
            }
        }
    }

    private static void handleComb(Table<String, Long, DynamicObject> result, long schemeId, long oldSchemeId) {
        QFilter filters = QFilter.of((String)"schemeid = ?", (Object[])new Object[]{oldSchemeId});
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isgroupmap", (QFilter[])filters.toArray(), null, (int)-1);
        DynamicObject[] groupmapDyns = null;
        if (queryPrimaryKeys.size() > 0) {
            groupmapDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isgroupmap"));
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        if (groupmapDyns != null && groupmapDyns.length > 0) {
            String meta = "bcm_isgroupmap";
            for (int i = 0; i < groupmapDyns.length; ++i) {
                DynamicObject dimId;
                DynamicObject temp = groupmapDyns[i];
                long oldId = temp.getLong("id");
                temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
                temp.set("schemeid_id", (Object)schemeId);
                temp.set("id", null);
                DynamicObject dimmap = (DynamicObject)result.get((Object)"bcm_isdimmap", (Object)temp.getLong("dimmapid"));
                temp.set("dimmapid", (Object)dimmap.getLong("id"));
                result.put((Object)meta, (Object)oldId, (Object)temp);
                DynamicObjectCollection isgrouptargmapentry = temp.getDynamicObjectCollection("isgrouptargmapentry");
                if (isgrouptargmapentry != null && isgrouptargmapentry.size() > 0) {
                    for (DynamicObject entry : isgrouptargmapentry) {
                        entry.set("id", null);
                        dimId = (DynamicObject)result.get((Object)"bcm_isbaseentlist", (Object)entry.getLong("tardimension"));
                        if (dimId == null) continue;
                        entry.set("tardimension", (Object)dimId.getLong("id"));
                    }
                }
                if ((isgrouptargmapentry = temp.getDynamicObjectCollection("isgroupsrcmapentry")) != null && isgrouptargmapentry.size() > 0) {
                    for (DynamicObject entry : isgrouptargmapentry) {
                        entry.set("id", null);
                        dimId = (DynamicObject)result.get((Object)"bcm_isbaseentlist", (Object)entry.getLong("srcdimension"));
                        if (dimId == null) continue;
                        entry.set("srcdimension", (Object)dimId.getLong("id"));
                    }
                }
                if ((isgrouptargmapentry = temp.getDynamicObjectCollection("isgroupsrcexprentry")) == null || isgrouptargmapentry.size() <= 0) continue;
                for (DynamicObject entry : isgrouptargmapentry) {
                    entry.set("id", null);
                }
            }
        }
    }

    private static void handleSheet(Table<String, Long, DynamicObject> result, List<Object> dimIds) {
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_ismapjson", (QFilter[])new QFilter("dimmapid", "in", dimIds).toArray(), null, (int)-1);
        DynamicObject[] mapJSONDyns = null;
        if (queryPrimaryKeys != null && queryPrimaryKeys.size() > 0) {
            mapJSONDyns = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_ismapjson"));
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        if (mapJSONDyns != null) {
            String meta = "bcm_ismapjson";
            for (int i = 0; i < mapJSONDyns.length; ++i) {
                DynamicObject temp = mapJSONDyns[i];
                long oldId = temp.getLong("id");
                temp = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
                DynamicObject dimmap = (DynamicObject)result.get((Object)"bcm_isdimmap", (Object)temp.getLong("dimmapid"));
                temp.set("dimmapid", (Object)dimmap.getLong("id"));
                temp.set("id", null);
                result.put((Object)meta, (Object)oldId, (Object)temp);
                temp.set("spreadjson", null);
                temp.set(DATA, null);
            }
        }
    }

    public static Pair<Long, String> getCommonSingleMappedMembInfo(IIntegrateContext ctx, String entityNum, String membNumb) {
        Recorder dimMapId = new Recorder(null);
        String entityNumb = null;
        for (Table.Cell c : ctx.getMappedRelation().getSingleMappedRelationPair().cellSet()) {
            if (!((MappedDimItem)c.getColumnKey()).getEntityNumb().equals(entityNum) && !((MappedDimItem)c.getRowKey()).getEntityNumb().equals(entityNum)) continue;
            dimMapId.setRecord((Object)Pair.onePair((Object)((MappedDimItem)c.getRowKey()).getEntityNumb().equals(entityNum), (Object)((DimMappedRelation.SingleDimRelationPair)c.getValue()).getDimMappedId()));
            entityNumb = ((MappedDimItem)c.getRowKey()).getEntityNumb();
        }
        if (dimMapId.getRecord() == null) {
            throw new KDBizException(String.format("not fount dimension[%s] mapped!", entityNum));
        }
        QFBuilder qf = new QFBuilder();
        qf.add("dimmapid", "=", ((Pair)dimMapId.getRecord()).p2);
        qf.add((Boolean)((Pair)dimMapId.getRecord()).p1 == false ? "targmembnumber" : "issinglemapentry.srcmemnumber", "=", (Object)membNumb);
        Pair info = null;
        try (DataSet ds = IntegrationUtil.queryMemberMapped(qf, (Boolean)((Pair)dimMapId.getRecord()).p1 != false ? "targmembnumber,targmembid" : "issinglemapentry.srcmemnumber,issinglemapentry.srcmembid");){
            if (ds.hasNext()) {
                Row row = ds.next();
                info = Pair.onePair((Object)row.getLong((Boolean)((Pair)dimMapId.getRecord()).p1 != false ? "targmembid" : "issinglemapentry.srcmembid"), (Object)row.getString((Boolean)((Pair)dimMapId.getRecord()).p1 != false ? "targmembnumber" : "issinglemapentry.srcmemnumber"));
            }
        }
        if (info == null) {
            throw new KDBizException("queryMemberMapped is null:" + ((Pair)dimMapId.getRecord()).p2 + ":" + membNumb);
        }
        return IntegrationUtil.fillInfo(info, entityNumb, (Boolean)((Pair)dimMapId.getRecord()).p1, (Long)ctx.getSchema().p1);
    }

    private static Pair<Long, String> fillInfo(Pair<Long, String> info, String entityNumb, Boolean record, Long id) {
        DynamicObject scheme;
        Long ssid;
        DynamicObject[] load;
        if (record != null && !record.booleanValue() && info != null && (Long)info.p1 == 0L && (load = BusinessDataServiceHelper.load((String)entityNumb, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", info.p2), new QFilter("ssid", "=", (Object)(ssid = Long.valueOf((scheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isscheme", (String)"id,isscheme")).getDynamicObject("isscheme").getLong("id"))))})) != null && load.length > 0) {
            return Pair.onePair((Object)load[0].getLong("id"), (Object)info.p2);
        }
        return info;
    }

    public static Long newVersion(Long oldschemeid, IDataModel model) {
        HashBasedTable result = HashBasedTable.create();
        DynamicObject schemDyn = BusinessDataServiceHelper.loadSingle((Object)oldschemeid, (String)"bcm_isscheme");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        long schemeId = GlobalIdUtil.genGlobalLongId();
        long oldId = schemDyn.getLong("id");
        schemDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)schemDyn);
        schemDyn.set("id", (Object)schemeId);
        schemDyn.set("number", model.getValue("number"));
        schemDyn.set("name", model.getValue("name"));
        schemDyn.set("modifier", (Object)RequestContext.get().getUserId());
        schemDyn.set("creator", (Object)RequestContext.get().getUserId());
        schemDyn.set("modifytime", (Object)TimeServiceHelper.now());
        schemDyn.set("createtime", (Object)TimeServiceHelper.now());
        schemDyn.set("effectivedate", model.getValue("effectivedate"));
        schemDyn.set("expiringdate", model.getValue("expiringdate"));
        schemDyn.set("versionnumber", model.getValue("versionnumber"));
        schemDyn.set("description", model.getValue("description"));
        schemDyn.set("status", (Object)"0");
        result.put((Object)"bcm_isscheme", (Object)oldId, (Object)schemDyn);
        IntegrationUtil.handleBasedata((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        List<Object> dimIds = IntegrationUtil.handleDim((Table<String, Long, DynamicObject>)result, schemDyn, schemeId, oldId);
        IntegrationUtil.handleSingle((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleComb((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleSheet((Table<String, Long, DynamicObject>)result, dimIds);
        IntegrationUtil.handleSchemeDistribution((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        Map<Long, Long> idMap = IntegrationUtil.handleSheetMapping((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handlePageSelect((Table<String, Long, DynamicObject>)result, schemeId, oldId);
        IntegrationUtil.handleCellMapping((Table<String, Long, DynamicObject>)result, schemeId, oldId, idMap);
        IntegrationUtil.handleIni(oldId, schemeId);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                IntegrationUtil.handleImportMode(oldId, schemDyn);
                result.rowMap().forEach((k, v) -> {
                    Collection values = v.values();
                    if (values.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
                    }
                });
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return schemeId;
    }

    private static void handleSchemeDistribution(Table<String, Long, DynamicObject> result, long schemeId, long oldSchemeId) {
        QFBuilder qf = new QFBuilder("scheme", "=", (Object)oldSchemeId);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)"id, model, entity, scheme, textname, property, propertyvalue, range,applytype", (QFilter[])qf.toArray());
        long[] genGlobalLongIds = GlobalIdUtil.genGlobalLongIds((int)dyns.length);
        for (int i = 0; i < dyns.length; ++i) {
            DynamicObject newDy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyns[i], (boolean)true, (boolean)true);
            long oldid = dyns[i].getLong("id");
            newDy.set("id", (Object)genGlobalLongIds[i]);
            newDy.set("scheme", (Object)schemeId);
            newDy.set("scheme_id", (Object)schemeId);
            result.put((Object)"bcm_isschemeassignentity", (Object)oldid, (Object)newDy);
        }
    }

    public static void filterSchemeByScenarioAndDate(long modelid, String scenarioNum, String periodNum, String yearNum, List<Long> schemeIds) {
        Set<Long> scenarioSchemeIds = IntegrationUtil.filterSchemeByScenario(modelid, scenarioNum, schemeIds);
        IntegrationUtil.filterSchemeByDate(modelid, periodNum, yearNum, scenarioSchemeIds);
        schemeIds.clear();
        schemeIds.addAll(scenarioSchemeIds);
    }

    public static void filterSchemeByDate(long modelid, String periodNum, String yearNum, Set<Long> schemeIds) {
        QFBuilder qfbPeriod = new QFBuilder();
        qfbPeriod.add("model", "=", (Object)modelid);
        qfbPeriod.add("number", "=", (Object)periodNum);
        DynamicObject periodDate = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"effdate, expdate", (QFilter[])qfbPeriod.toArray());
        String effdate = periodDate.getString("effdate");
        String expdate = periodDate.getString("expdate");
        String format = ResManager.getLocaleString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"IntegrationUtil_1", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String year = ResManager.getLocaleString((String)"\u5e74", (String)"IntegrationUtil_2", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String yearSub = yearNum.substring(2);
        effdate = yearSub + year + effdate;
        expdate = yearSub + year + expdate;
        Date effDate = new Date();
        Date expDate = new Date();
        try {
            effDate = sdf.parse(effdate);
            expDate = sdf.parse(expdate);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        ArrayList effectiveSchemeIds = Lists.newArrayList();
        QFBuilder qFBuilder = new QFBuilder();
        qFBuilder.add("id", "in", schemeIds);
        qFBuilder.add("status", "=", (Object)"1");
        DynamicObject[] dynamics = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id, number, effectivedate, expiringdate, versionnumber", (QFilter[])qFBuilder.toArray(), (String)"number asc, versionnumber desc");
        HashSet numberExist = Sets.newHashSet();
        for (DynamicObject dynamic : dynamics) {
            String number;
            if (dynamic.getDate("effectivedate").after(expDate) || dynamic.getDate("expiringdate") != null && dynamic.getDate("expiringdate").before(effDate) || !numberExist.add(number = dynamic.getString("number"))) continue;
            effectiveSchemeIds.add(dynamic.getLong("id"));
        }
        schemeIds.clear();
        schemeIds.addAll(effectiveSchemeIds);
    }

    public static Set<Long> filterSchemeByScenario(long modelid, String scenarioNum, List<Long> schemeIds) {
        HashSet<Long> scenarioSchemeIds = new HashSet<Long>(16);
        Map<String, List<String>> sceneperiods = DimensionServiceHelper.getScenePeriodMap(modelid);
        if (sceneperiods.size() == 0) {
            schemeIds.clear();
            return scenarioSchemeIds;
        }
        Long periodId = MemberReader.getDimensionIdByNum((long)modelid, (String)DimTypesEnum.PERIOD.getNumber());
        Pair<Set<Long>, Map<Long, Long>> dimAndSetPair = IntegrationUtil.getDimAndSetPair(schemeIds, periodId);
        List<String> periods = sceneperiods.get(scenarioNum);
        periods.add(ALL);
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("dimmapid", "in", dimAndSetPair.p1);
        qfb.add("targmembnumber", "in", periods);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"schemeid, srcmembnumber,targmembnumber", (QFilter[])qfb.toArray());
        ArrayList<DynamicObject> loadAll = new ArrayList<DynamicObject>(16);
        loadAll.addAll((Collection<DynamicObject>)dyns);
        IntegrationUtil.addPubMapping(loadAll, (Map)dimAndSetPair.p2, periods, DimTypesEnum.PERIOD.getNumber());
        for (DynamicObject dyn : loadAll) {
            scenarioSchemeIds.add(dyn.getLong("schemeid"));
        }
        scenarioSchemeIds.addAll(IntegrationUtil.addPeriodSchemeIdFromParent(schemeIds, periods, loadAll, periodId));
        return scenarioSchemeIds;
    }

    private static Set<Long> addPeriodSchemeIdFromParent(List<Long> SchemeIds, List<String> periods, List<DynamicObject> dyns, Long dimId) {
        DynamicObject[] parentScheme;
        HashSet<Long> needAddScheme = new HashSet<Long>(8);
        ArrayList<Long> notExistSchemeIds = new ArrayList<Long>(8);
        for (Long schemeId : SchemeIds) {
            notExistSchemeIds.add(schemeId);
        }
        for (DynamicObject dyn : dyns) {
            if (!notExistSchemeIds.contains(dyn.getLong("schemeid"))) continue;
            notExistSchemeIds.remove(dyn.getLong("schemeid"));
        }
        QFilter filter = new QFilter("scheme", "in", notExistSchemeIds).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,inheritancescheme,scheme", (QFilter[])filter.toArray());
        HashMap scheme2inherMap = new HashMap(8);
        HashSet inherSchemeIds = new HashSet();
        schemes.forEach(scheme -> {
            if (scheme.getLong("inheritancescheme") != 0L) {
                inherSchemeIds.add(scheme.getLong("inheritancescheme"));
                scheme2inherMap.put(scheme.getLong("scheme"), scheme.getLong("inheritancescheme"));
            }
        });
        QFilter filterinher = new QFilter("scheme", "in", inherSchemeIds).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId));
        DynamicObjectCollection parentDimmap = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,inheritancescheme,scheme", (QFilter[])filterinher.toArray());
        HashSet<Long> dimmapId = new HashSet<Long>();
        for (DynamicObject dynamicObject : parentDimmap) {
            dimmapId.add(dynamicObject.getLong("id"));
        }
        Set entrySet = scheme2inherMap.entrySet();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", inherSchemeIds);
        qfb.add("targmembnumber", "in", periods);
        qfb.and("dimmapid", "in", dimmapId);
        for (DynamicObject pScheme : parentScheme = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"schemeid", (QFilter[])qfb.toArray())) {
            for (Map.Entry longLongEntry : entrySet) {
                if (!((Long)longLongEntry.getValue()).equals(pScheme.getLong("schemeid_id"))) continue;
                needAddScheme.add((Long)longLongEntry.getKey());
            }
        }
        return needAddScheme;
    }

    private static List<DynamicObject> addSchemeIdFromParent(List<String> tarMembs, Set<Long> absentMappingSchemes, Long dimId) {
        QFilter filter = new QFilter("scheme", "in", absentMappingSchemes).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,inheritancescheme,scheme", (QFilter[])filter.toArray());
        HashMap scheme2inherMap = new HashMap(8);
        HashSet inherSchemeIds = new HashSet();
        schemes.forEach(scheme -> {
            if (scheme.getLong("inheritancescheme") != 0L) {
                inherSchemeIds.add(scheme.getLong("inheritancescheme"));
                scheme2inherMap.put(scheme.getLong("scheme"), scheme.getLong("inheritancescheme"));
            }
        });
        QFilter filterinher = new QFilter("scheme", "in", inherSchemeIds).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId));
        DynamicObjectCollection parentDimmap = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,inheritancescheme,scheme", (QFilter[])filterinher.toArray());
        HashSet<Long> dimmapId = new HashSet<Long>();
        for (DynamicObject dynamicObject : parentDimmap) {
            dimmapId.add(dynamicObject.getLong("id"));
        }
        Set entrySet = scheme2inherMap.entrySet();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", inherSchemeIds);
        qfb.add("targmembnumber", "in", tarMembs);
        qfb.and("dimmapid", "in", dimmapId);
        DynamicObjectCollection parentScheme = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"id,schemeid,srcmembnumber,targmembnumber,targmembid", (QFilter[])qfb.toArray());
        ArrayList<DynamicObject> needAddScheme = new ArrayList<DynamicObject>(8);
        if (parentScheme.size() > 0) {
            for (Map.Entry longLongEntry : entrySet) {
                for (DynamicObject pScheme : parentScheme) {
                    if (!((Long)longLongEntry.getValue()).equals(pScheme.getLong("schemeid"))) continue;
                    QFBuilder qfbCopy = new QFBuilder();
                    qfbCopy.add("id", "in", (Object)pScheme.getLong("id"));
                    DynamicObject parentSchemeCopy = QueryServiceHelper.queryOne((String)"bcm_issinglemap", (String)"schemeid,srcmembnumber,targmembnumber,targmembid", (QFilter[])qfbCopy.toArray());
                    parentSchemeCopy.set("schemeid", longLongEntry.getKey());
                    needAddScheme.add(parentSchemeCopy);
                }
            }
        }
        return needAddScheme;
    }

    private static DynamicObject getScheme(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_isscheme");
    }

    public static Pair<Map<String, List<Long>>, Map<String, List<Long>>> filterSingleMapMems(Long dimId, Collection<Long> schemeIds, List<String> tarMembs) {
        Pair<Set<Long>, Map<Long, Long>> dimPair = IntegrationUtil.getDimAndSetPair(schemeIds, dimId);
        Set dimmapids = (Set)dimPair.p1;
        Map setSchemeMap = (Map)dimPair.p2;
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("dimmapid", "in", (Object)dimmapids);
        tarMembs.add(IGNORE);
        tarMembs.add(ALL);
        qfb.add("targmembnumber", "in", tarMembs);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"schemeid,srcmembnumber,targmembnumber,targmembid", (QFilter[])qfb.toArray());
        ArrayList<DynamicObject> loadAll = new ArrayList<DynamicObject>(16);
        loadAll.addAll((Collection<DynamicObject>)load);
        String dimNum = MemberReader.getDimensionNumById((long)dimId);
        IntegrationUtil.addPubMapping(loadAll, setSchemeMap, tarMembs, dimNum);
        HashSet<Long> absentMappingSchemes = new HashSet<Long>(schemeIds);
        loadAll.stream().map(k -> k.getLong("schemeid")).collect(Collectors.toList()).forEach(absentMappingSchemes::remove);
        List<DynamicObject> needaddScheme = IntegrationUtil.addSchemeIdFromParent(tarMembs, absentMappingSchemes, dimId);
        if (needaddScheme.size() > 0) {
            loadAll.addAll(needaddScheme);
        }
        List<DynamicObject> ignoreDyns = loadAll.stream().filter(d -> IGNORE.equals(d.getString("targmembnumber"))).collect(Collectors.toList());
        List<DynamicObject> otherDyns = loadAll.stream().filter(d -> !IGNORE.equals(d.getString("targmembnumber"))).collect(Collectors.toList());
        HashMap result = new HashMap(tarMembs.size());
        otherDyns.forEach(l -> {
            List schemes = result.getOrDefault(l.getString("targmembnumber"), new ArrayList());
            schemes.add(l.getLong("schemeid"));
            result.put(l.getString("targmembnumber"), schemes);
        });
        HashMap resultIgnore = new HashMap(tarMembs.size());
        ignoreDyns.forEach(l -> {
            List schemes = resultIgnore.getOrDefault(l.getString("srcmembnumber"), new ArrayList());
            schemes.add(l.getLong("schemeid"));
            resultIgnore.put(l.getString("srcmembnumber"), schemes);
        });
        return Pair.onePair(result, resultIgnore);
    }

    public static Pair<Set<Long>, Map<Long, Long>> getDimAndSetPair(Collection<Long> schemeIds, Long dimId) {
        QFBuilder qfb = new QFBuilder();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
        DynamicObjectCollection dimMap = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, scheme, pubmappingid", (QFilter[])qfb.toArray());
        HashSet<Long> dimmapids = new HashSet<Long>(schemeIds.size());
        HashMap<Long, Long> setSchemeMap = new HashMap<Long, Long>(schemeIds.size());
        boolean enable = false;
        if (schemeIds.size() > 0) {
            enable = IntegrationUtil.checkMappingSetEnable(schemeIds.stream().findFirst().get(), 0L);
        }
        for (DynamicObject d : dimMap) {
            dimmapids.add(d.getLong("id"));
            if (d.getLong("pubmappingid") == 0L || !enable) continue;
            setSchemeMap.put(d.getLong("pubmappingid"), d.getLong("scheme"));
        }
        return Pair.onePair(dimmapids, setSchemeMap);
    }

    public static void addPubMapping(List<DynamicObject> loadAll, Map<Long, Long> setSchemeMap, List<String> tarMembs, String dimNum) {
        if (setSchemeMap.size() == 0) {
            return;
        }
        QFBuilder qfb = new QFBuilder();
        qfb.add("pubmappingid", "in", setSchemeMap.keySet());
        qfb.add("targmembnumber", "in", tarMembs);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"schemeid,pubmappingid,srcmembnumber,targmembnumber,targmembid", (QFilter[])qfb.toArray());
        for (DynamicObject obj : load) {
            obj.set("schemeid", (Object)setSchemeMap.get(obj.getLong("pubmappingid")));
        }
        boolean is4Dim = IntegrationUtil.checkIs4Dim(dimNum);
        Pair<Set<String>, Set<String>> existNumPair = IntegrationUtil.getExistNum(loadAll);
        for (DynamicObject obj : load) {
            String tar = obj.getLong("schemeid") + obj.getString("targmembnumber");
            String src = obj.getLong("schemeid") + obj.getString("srcmembnumber");
            if (is4Dim) {
                if (((Set)existNumPair.p1).contains(tar)) continue;
                loadAll.add(obj);
                continue;
            }
            if (((Set)existNumPair.p2).contains(src)) continue;
            loadAll.add(obj);
        }
    }

    private static Pair<Set<String>, Set<String>> getExistNum(List<DynamicObject> loadAll) {
        HashSet<String> tarSet = new HashSet<String>(16);
        HashSet<String> srcSet = new HashSet<String>(16);
        for (DynamicObject obj : loadAll) {
            tarSet.add(obj.getLong("schemeid") + obj.getString("targmembnumber"));
            srcSet.add(obj.getLong("schemeid") + obj.getString("srcmembnumber"));
        }
        return Pair.onePair(tarSet, srcSet);
    }

    public static boolean checkIs4Dim(String dimNum) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNum) || DimTypesEnum.YEAR.getNumber().equals(dimNum) || DimTypesEnum.PERIOD.getNumber().equals(dimNum) || DimTypesEnum.CURRENCY.getNumber().equals(dimNum);
    }

    public static void filterIdSingleMapMems(Long dimId, List<Long> schemeIds, String tarMemb) {
        QFBuilder qfb = new QFBuilder();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
        DynamicObject[] dimmap = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id", (QFilter[])qfb.toArray());
        HashSet dimmapids = new HashSet(schemeIds.size());
        Arrays.stream(dimmap).forEach(d -> dimmapids.add(d.getLong("id")));
        qfb.clear();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("dimmapid", "in", dimmapids);
        ArrayList<String> tarMembs = new ArrayList<String>();
        tarMembs.add(IGNORE);
        tarMembs.add(ALL);
        tarMembs.add(tarMemb);
        qfb.add("targmembnumber", "in", tarMembs);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"schemeid,srcmembnumber,targmembnumber,targmembid", (QFilter[])qfb.toArray());
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject obj : load) {
            ids.add(obj.getDynamicObject("schemeid").getLong("id"));
        }
        schemeIds.clear();
        schemeIds.addAll(ids);
    }

    public static Set<Long> getMergeECFlowstatusOfOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, Long ... orgs) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelId, Arrays.asList(orgs), scenarioId, yearId, periodId);
        return mcStatusMap.entrySet().stream().filter(e -> ((McStatus)e.getValue()).getFlow().isSubmit()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Set<Long> getMergeECFlowArchiveStatusOfOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, Long ... orgs) {
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelId, Arrays.asList(orgs), scenarioId, yearId, periodId);
        return mcStatusMap.entrySet().stream().filter(e -> ((McStatus)e.getValue()).getFlow().isArchive()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Long getDefinedToCurrencyMap(IIntegrateContext _ctx) {
        Recorder result = new Recorder((Object)0L);
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> mapPair = _ctx.getMappedRelation().getSingleMappedRelationPair();
        mapPair.rowMap().forEach((src, map) -> {
            if (src.getNumber().equals("Currency")) {
                map.forEach((target, v) -> {
                    if (!target.getNumber().equals("Currency")) {
                        result.setRecord((Object)v.getDimMappedId());
                    }
                });
            }
        });
        return (Long)result.getRecord();
    }

    public static Pair<Set<String>, Set<String>> getBaseEntity(IIntegrateContext _ctx) {
        if (_ctx.getCustomParam("baseEntity") == null) {
            QFBuilder builder = new QFBuilder("scheme", "=", _ctx.getSchema().p1);
            builder.add("number", "not in", (Object)new String[]{"AccountBookType", "AccountView", "ChangeType", "Currency", "Entity", "Period"});
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"number", (QFilter[])builder.toArray());
            HashSet asstDim = new HashSet(16);
            HashSet commonDim = new HashSet(16);
            col.forEach(e -> {
                String number = e.getString("number");
                if ("comassist1".equals(number) || "comassist2".equals(number)) {
                    commonDim.add(number);
                } else {
                    asstDim.add(number);
                }
            });
            _ctx.putCustomParam("baseEntity", Pair.onePair(asstDim, commonDim));
        }
        return (Pair)_ctx.getCustomParam("baseEntity");
    }

    public static Pair<Set<String>, Set<String>> getAsstInSingle(IIntegrateContext _ctx) {
        Pair<Set<String>, Set<String>> baseEntity = IntegrationUtil.getBaseEntity(_ctx);
        Table<MappedDimItem, MappedDimItem, DimMappedRelation.SingleDimRelationPair> mapPair = _ctx.getMappedRelation().getSingleMappedRelationPair();
        Set itemSet = mapPair.rowKeySet();
        HashSet<String> asstInSingle = new HashSet<String>(16);
        HashSet<String> commonInSingle = new HashSet<String>(16);
        for (MappedDimItem item : itemSet) {
            Recorder isEntity = new Recorder((Object)false);
            ((Map)mapPair.rowMap().get(item)).forEach((k, v) -> {
                if (DimTypesEnum.ENTITY.getNumber().equals(k.getNumber())) {
                    isEntity.setRecord((Object)true);
                }
            });
            if (((Boolean)isEntity.getRecord()).booleanValue()) continue;
            if (((Set)baseEntity.p1).contains(item.getNumber())) {
                asstInSingle.add(item.getNumber());
                continue;
            }
            if (!((Set)baseEntity.p2).contains(item.getNumber())) continue;
            commonInSingle.add(item.getNumber());
        }
        return Pair.onePair(asstInSingle, commonInSingle);
    }

    public static Pair<Set<String>, Set<String>> getAsstInCombo(MappedRow mappedRow, IIntegrateContext _ctx) {
        Pair<Set<String>, Set<String>> baseEntity = IntegrationUtil.getBaseEntity(_ctx);
        HashSet asstInCombo = new HashSet(16);
        HashSet commonInCombo = new HashSet(16);
        mappedRow.srcMappediterator().forEachRemaining(s -> {
            String dimNum = ((MappedSourceItem)s.getValue()).getMappedDim().getNumber();
            if (((Set)baseEntity.p1).contains(dimNum)) {
                asstInCombo.add(dimNum);
            } else if (((Set)baseEntity.p2).contains(dimNum)) {
                commonInCombo.add(dimNum);
            }
        });
        return Pair.onePair(asstInCombo, commonInCombo);
    }

    public static Pair<Set<String>, Set<String>> getAsstInSrcDef(IIntegrateContext _ctx) {
        Pair<Set<String>, Set<String>> baseEntity = IntegrationUtil.getBaseEntity(_ctx);
        HashSet<String> asstInSrcDef = new HashSet<String>(16);
        HashSet<String> commonInSrcDef = new HashSet<String>(16);
        Map<Object, DimMappedRelation.DimAndDefValRela> srcDefMap = _ctx.getSourceDefaultValsMap();
        for (DimMappedRelation.DimAndDefValRela valRela : srcDefMap.values()) {
            if (((Set)baseEntity.p1).contains(valRela.getDimItem().getNumber())) {
                asstInSrcDef.add(valRela.getDimItem().getNumber());
                continue;
            }
            if (!((Set)baseEntity.p2).contains(valRela.getDimItem().getNumber())) continue;
            commonInSrcDef.add(valRela.getDimItem().getNumber());
        }
        return Pair.onePair(asstInSrcDef, commonInSrcDef);
    }

    public static Set<String> getAsstInAll(Set<String> inCombo, Set<String> inSingle, Set<String> inSrcDef) {
        inCombo.addAll(inSingle);
        inCombo.addAll(inSrcDef);
        return inCombo;
    }

    public static QFilter getFetchTypeFilter(DynamicObject scheme) {
        MappingService context = new MappingService(scheme);
        QFilter filter = new QFilter("product", "=", (Object)scheme.getString("issrc.number"));
        if (!context.isMultiCurrency() || context.isFromMidLib()) {
            filter.and("number", "not in", (Object)new String[]{"beginfor", "creditfor", "debitfor", "endfor", "yearcreditfor", "yeardebitfor", "beginall", "creditall", "debitall", "endall", "yearcreditall", "yeardebitall"});
        }
        return filter;
    }

    public static List<Long> getRateOrgIdList(Long modelId) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("isexchangerate", "=", (Object)"1").toArray());
        ArrayList<Long> rateOrgIdList = new ArrayList<Long>(10);
        dynamicObjects.forEach(dynamicObject -> rateOrgIdList.add(dynamicObject.getLong("id")));
        return rateOrgIdList;
    }

    public static Set<Long> getRateOrgIdSet(Long modelId) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("isexchangerate", "=", (Object)"1").toArray());
        HashSet<Long> rateOrgIdSet = new HashSet<Long>(10);
        dynamicObjects.forEach(dynamicObject -> rateOrgIdSet.add(dynamicObject.getLong("id")));
        return rateOrgIdSet;
    }

    public static void saveRateSchemeCurrency2IntEntity(IntegrateEntity intEntity, long schemeId, String orgNum) {
        Long dimMapId = 0L;
        DynamicObjectCollection dimmapidDateSet = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,isdimmaptargentry.tagdimension", (QFilter[])new QFilter("scheme.id", "=", (Object)schemeId).toArray());
        for (DynamicObject dynamicObject2 : dimmapidDateSet) {
            long tarDimId = dynamicObject2.getLong("isdimmaptargentry.tagdimension");
            if (!DimEntityNumEnum.getEntieyNumByNumber((String)MemberReader.getDimensionNumById((long)tarDimId)).equals("bcm_currencymembertree")) continue;
            dimMapId = dynamicObject2.getLong("id");
            break;
        }
        DynamicObjectCollection currencyDataSet = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"targmembid, targmembnumber", (QFilter[])new QFilter("dimmapid", "=", (Object)dimMapId).toArray());
        currencyDataSet.forEach(curObj -> intEntity.addRateOrgSchemeCurrencyPair(curObj.getLong("targmembid"), curObj.getString("targmembnumber")));
        DynamicObjectCollection mdDataCurSet = QueryServiceHelper.query((String)"bcm_dsmddata", (String)"currency", (QFilter[])new QFilter("entity", "=", (Object)orgNum).toArray());
        HashSet curSet = new HashSet(16);
        mdDataCurSet.forEach(dynamicObject -> curSet.add(dynamicObject.getString("currency")));
        List<Pair<Long, String>> currency4Rate = intEntity.getCurrency4Rate();
        int j = currency4Rate.size();
        for (int i = j - 1; i >= 0; --i) {
            if (curSet.contains(currency4Rate.get((int)i).p2)) continue;
            currency4Rate.remove(currency4Rate.get(i));
        }
    }

    public static void addExchangeRateOrg(DynamicObjectCollection doc, Long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid).and("isexchangerate", "=", (Object)Character.valueOf('1'));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])qFilter.toArray());
        Collections.addAll(doc, objects);
    }

    public static void deleteRateManagement(IntegrateEntity intEntity, long orgId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", intEntity.getModel().p1);
        qfBuilder.add("entity", "=", (Object)orgId);
        qfBuilder.add("scene", "=", intEntity.getScene().p1);
        qfBuilder.add("period", "=", intEntity.getPeriod().p1);
        qfBuilder.add("fy", "=", intEntity.getYear().p1);
        DeleteServiceHelper.delete((String)"bcm_exchagerate", (QFilter[])qfBuilder.toArray());
    }

    public static void clearOlapData(String modelNumber, Map<String, Set<String>> dimMembers) {
        Set<String> oneDimNumValues;
        String oneDimNum;
        RunScriptBuilder run = new RunScriptBuilder(modelNumber);
        String selectDim = DimEntityNumEnum.YEAR.getNumber();
        if (dimMembers.get(selectDim) == null) {
            Map.Entry<String, Set<String>> oneDimMember = dimMembers.entrySet().iterator().next();
            oneDimNum = oneDimMember.getKey();
            oneDimNumValues = oneDimMember.getValue();
        } else {
            oneDimNum = selectDim;
            oneDimNumValues = dimMembers.get(selectDim);
        }
        dimMembers.forEach((dimNum, members) -> {
            if (!dimNum.equalsIgnoreCase(oneDimNum)) {
                run.addDimensionScope((String)dimNum, members.toArray(new String[0]));
            }
        });
        oneDimNumValues.forEach(memNum -> {
            run.appendV((PairList<String, String>)PairList.newWithParam((Object)oneDimNum, (Object)memNum));
            run.appendEqualSign();
            run.appendStr(null);
            run.setSourceEnum(OlapSourceEnum.I1);
            run.endRunExpress();
        });
        run.runScript();
    }

    public static String checkDimMemberPerm(Map<String, String> commonMember, Long modelId) {
        boolean modelManage = MemberPermHelper.isModelAdmin(modelId);
        StringBuilder noPremMember = new StringBuilder();
        if (!modelManage) {
            commonMember.forEach((dimNumber, memNumber) -> {
                if (PermEnum.NOPERM == IntegrationUtil.getMemePerm(modelId, dimNumber, memNumber) || PermEnum.NOPERM == IntegrationUtil.getMemeClassPerm(modelId, dimNumber, memNumber)) {
                    noPremMember.append((String)dimNumber).append("|").append((String)memNumber).append(",");
                }
            });
        }
        if (noPremMember.length() > 0) {
            return noPremMember.substring(0, noPremMember.length() - 1);
        }
        return null;
    }

    public static PermEnum getMemePerm(Long modelId, String dimNumber, String member) {
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNumber);
        MembPermCacheItem permCache = new MembPermCacheItem(modelId, dimId);
        return permCache.getMembPermControlType(dimNumber, member);
    }

    public static PermEnum getMemeClassPerm(Long modelId, String dimNumber, String member) {
        MemPermClassCacheManager memPermClass = new MemPermClassCacheManager(modelId);
        return memPermClass.getMemPermClassType(dimNumber, member);
    }

    public static Map<String, Object> getSrcOrgProfitCenter(IIntegrateContext _ctx, SingleMapModel singleMapModel) {
        HashMap<String, Object> srcOrgMap = new HashMap<String, Object>(4);
        String tarDimNum = DimTypesEnum.ENTITY.getNumber();
        List<DimMappedRelation.SingleDimRelationPair> entity2Pairs = _ctx.getMappedRelation().getTarDim2Pairs().get(tarDimNum);
        for (DimMappedRelation.SingleDimRelationPair pair : entity2Pairs) {
            String ignoreOrg;
            String srcOrgNum = "";
            String srcDimNum = pair.getSourceDimItem().getDimItem().getNumber();
            Pair<Long, String> pairSrc = singleMapModel.getFromMultiSrc(tarDimNum, srcDimNum, (String)_ctx.getOrg().p2);
            if (pairSrc == null) {
                if (singleMapModel.getFromMultiSrc(tarDimNum, srcDimNum, ALL) != null) {
                    srcOrgNum = (String)_ctx.getOrg().p2;
                }
            } else {
                srcOrgNum = (String)pairSrc.p2;
            }
            DynamicObject srcMemDyn = null;
            Map srcProfitCenter = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)srcOrgNum)) {
                String formId = pair.getSourceDimItem().getDimItem().getEntityNumb();
                if (tarDimNum.equals(srcDimNum)) {
                    srcMemDyn = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)srcOrgNum)});
                } else {
                    DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, customservice", (QFilter[])new QFilter[]{new QFilter("id", "=", _ctx.getSchema().p1)});
                    DynamicObject service = schemeDyn.getDynamicObject("customservice");
                    if (service == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b9a\u5236\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u8bbe\u7f6e\u3002", (String)"IntegrationUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    ISCustomServiceConfig serviceConfig = new ISCustomServiceConfig(service.getString("cloudid"), service.getString("appid"), service.getString("number"), service.getString("method"), service.getString("classpath"));
                    HashMap<String, String> param = new HashMap<String, String>(4);
                    param.put("formId", formId);
                    param.put("dimNumber", srcDimNum);
                    param.put("memberNumberStr", srcOrgNum);
                    try {
                        srcProfitCenter = kd.bos.util.StringUtils.isNotEmpty((String)serviceConfig.getClazzPath()) ? (Map)MsServiceHelper.invokeBizServiceByGivenClassPath((String)serviceConfig.getCloudId(), (String)serviceConfig.getAppId(), (String)serviceConfig.getClazzPath(), (String)serviceConfig.getService(), (String)serviceConfig.getMethod(), (Object[])new Object[]{param}) : (Map)MsServiceHelper.invokeService((String)serviceConfig.getCloudId(), (String)serviceConfig.getAppId(), (String)serviceConfig.getService(), (String)serviceConfig.getMethod(), (Object[])new Object[]{param});
                    }
                    catch (Exception e) {
                        log.info(String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230%s\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntegrationUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]), srcOrgNum));
                    }
                }
            }
            if (srcMemDyn == null && srcProfitCenter == null) continue;
            Pair<Long, String> ignorePair = singleMapModel.getFromMultiSrc(tarDimNum, srcDimNum, IGNORE);
            if (ignorePair != null && (ignoreOrg = (String)ignorePair.p2).equals(srcOrgNum)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u7ec4\u7ec7\u201c%s\u201d\u6620\u5c04\u76ee\u6807\u4e3aIGNORE\uff0c\u65e0\u9700\u96c6\u6210\u3002", (String)"GLBalanceDataProvider_6", (String)"fi-bcm-business", (Object[])new Object[0]), _ctx.getOrg().p2));
            }
            if (tarDimNum.equals(srcDimNum)) {
                srcOrgMap.put(ORGID, srcMemDyn.getLong("id"));
                srcOrgMap.put(ORGNUMBER, srcOrgNum);
                continue;
            }
            srcOrgMap.putAll(srcProfitCenter);
        }
        if (srcOrgMap.get(ORGID) == null || srcOrgMap.get(ORGNUMBER) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u9009\u62e9\u7684\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4\u5728\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e2d\u3002", (String)"GLBalanceDataProvider_0", (String)"fi-bcm-business", (Object[])new Object[0]), _ctx.getOrg().p2));
        }
        return srcOrgMap;
    }

    public static Map<String, Object> getOtherSourceOlapData(DynamicObject ngModel, Map<String, Object> filter, Boolean isWithName) {
        String userUrl = ngModel.getString("userurl");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("modelShowNumber", ngModel.getString("number"));
        params.put("modelName", ngModel.getString("name"));
        params.put("filter", filter);
        if (isWithName.booleanValue()) {
            params.put("isWithName", "1");
        }
        try {
            String loginToken = IntegrationUtil.getLoginToken(ngModel);
            HashMap<String, String> requestHeader = new HashMap<String, String>(2);
            requestHeader.put("accessToken", loginToken);
            String fullUrl = userUrl + "/kapi/app/cm/olapData";
            String paramStr = JSON.toJSONString(params);
            log.info("ModelDataProvider queryOlap fullUrl:" + fullUrl + ", begin:");
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)30000, (int)600000);
            ApiResult res = (ApiResult)JSON.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                throw new Exception(res.getMessage());
            }
            log.info("ModelDataProvider olap fullUrl:" + fullUrl + ", begin:");
            return (Map)((Map)res.getData()).get("dataList");
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30)});
        }
    }

    public static List<Map<String, Object>> getOtherSourceExDimData(DynamicObject ngModel, Map<String, Object> params) throws IOException {
        params.put("modelnumber", ngModel.getString("number"));
        String loginToken = IntegrationUtil.getLoginToken(ngModel);
        HashMap<String, String> requestHeader = new HashMap<String, String>(2);
        requestHeader.put("accessToken", loginToken);
        String userUrl = ngModel.getString("userurl");
        String fullUrl = userUrl + "/kapi/app/cm/extdimensionInfo";
        String paramStr = JSON.toJSONString(params);
        log.info("ModelDataProvider exdimensionInfo fullUrl:" + fullUrl + ", begin:");
        String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)30000, (int)600000);
        ApiResult res = (ApiResult)JSON.parseObject((String)response, ApiResult.class);
        if (!res.getSuccess()) {
            throw new KDException(res.getMessage());
        }
        log.info("ModelDataProvider exdimensionInfo fullUrl:" + fullUrl + ", begin:");
        return (List)res.getData();
    }

    public static String getLoginToken(DynamicObject ngModel) {
        String phoneNumber = ngModel.getString("phonenumber");
        String passWord = ngModel.getString("password");
        KAESEncrypter ken = new KAESEncrypter();
        String pw = ken.decode(passWord);
        Long tdpdatacenterId = null;
        Object tdpdatacenterObj = ngModel.get("tdpdatacenterid");
        if (tdpdatacenterObj instanceof DynamicObject) {
            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
        } else if (tdpdatacenterObj instanceof Long) {
            tdpdatacenterId = (Long)tdpdatacenterObj;
        }
        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
        return DimMappingHelper.getLoginTokenWithPass(phoneNumber, pw, tdpdatacenter);
    }

    public static void saveIniRule(Object returnData, Long schemeId) {
        if (returnData == null) {
            return;
        }
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bcm_iniruledata", (QFilter[])new QFilter[]{qf});
                DynamicObject saveData = null;
                List dataList = (List)returnData;
                DynamicObject[] doArr = new DynamicObject[dataList.size()];
                long userId = Long.parseLong(RequestContext.get().getUserId());
                Date date = new Date();
                for (int i = 0; i < dataList.size(); ++i) {
                    saveData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iniruledata");
                    saveData.set("scheme", (Object)schemeId);
                    saveData.set("type", (Object)"1");
                    saveData.set("value", dataList.get(i));
                    saveData.set("ordernum", (Object)i);
                    saveData.set("creater", (Object)userId);
                    saveData.set("createdate", (Object)date);
                    saveData.set("modifier", (Object)userId);
                    saveData.set("modifydate", (Object)date);
                    doArr[i] = saveData;
                }
                SaveServiceHelper.save((DynamicObject[])doArr);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    public static DynamicObject getDimPair(Long modelId, String dimtype) {
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimtype);
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{dimId}, (String)"bcm_dimension");
        for (DynamicObject dynamicObject : dimMap.values()) {
            if (dynamicObject == null) continue;
            return dynamicObject;
        }
        return null;
    }

    public static Map<String, Object> getGLReturn() {
        HashMap<String, Object> glMap = new HashMap<String, Object>();
        glMap.put("getSuccess", true);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("account", "1121");
        data.put("debitlocal", 100);
        data.put("creditlocal", 200);
        data.put("local", 100);
        data.put("for", 100);
        HashMap assgrp = new HashMap(16);
        HashMap<String, String> member = new HashMap<String, String>(16);
        member.put("number", "aaaaa");
        member.put("name", "bbbbb");
        assgrp.put("0005", member);
        data.put("assgrp", assgrp);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        list.add(data);
        try {
            glMap.put("getData", JSONUtils.toString(list));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return glMap;
    }

    public static Map<String, Object> getGLReportReturnData() {
        String glReturnData = "{\"dt\":{\"orgUnit1\":{\"162\":{\"rt\":1,\"dl\":[[{\"E7\":{\"v\":\"123\"},\"D7\":{\"t\":\"\u68c0\u6d4b\u8ba4\u8bc1\u4e1a\u52a1\u6536\u5165\"},\"C7\":{\"t\":\"6001.23\"},\"B7\":{\"t\":\"\u62db\u5546\u5c40\u80fd\u6e90\u8fd0\u8f93\u80a1\u4efd\u6709\u9650\u516c\u53f8\u6df1\u5733\u5206\u516c\u53f8\"}},{\"E8\":{\"v\":\"123\"},\"D8\":{\"t\":\"\u4ee3\u7406\u4e1a\u52a1\u8d1f\u503a\"},\"C8\":{\"t\":\"2314\"},\"B8\":{\"t\":\"\u62db\u5546\u5c40\u5de5\u4e1a\u96c6\u56e2\u6709\u9650\u516c\u53f8\"}},{\"E9\":{\"v\":\"123\"},\"D9\":{\"t\":\"\u8425\u4e1a\u5916\u6536\u5165_\u5176\u4ed6\"},\"C9\":{\"t\":\"6301.99\"},\"B9\":{\"t\":\"\u62db\u5546\u5c40\u6d77\u901a\u8d38\u6613\u6709\u9650\u516c\u53f8\"}},{\"B10\":{\"t\":\"\u62db\u5546\u5c40\u80fd\u6e90\u8fd0\u8f93\u80a1\u4efd\u6709\u9650\u516c\u53f8\"},\"D10\":{\"t\":\"\u68c0\u6d4b\u8ba4\u8bc1\u4e1a\u52a1\u6536\u5165\"},\"C10\":{\"t\":\"6001.23\"},\"E10\":{\"v\":\"123\"}}]]}}}}";
        JSONObject map1 = JSON.parseObject((String)glReturnData);
        return map1;
    }

    public static void addTimeUse(IIntegrateContext _ctx, Long startTime, String interfaceName) {
        Long endTime = System.currentTimeMillis();
        if (_ctx == null) {
            return;
        }
        Map servicefailMsg = (Map)_ctx.getCustomParam("servicefailMsg");
        if (servicefailMsg == null) {
            return;
        }
        String serviceSchemeKey = (String)_ctx.getOrg().p2 + (String)_ctx.getSchema().p2 + (String)_ctx.getCurrency().p2;
        String useStr = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3:[%1$s],\u8017\u65f6[%2$s]\u6beb\u79d2;", (String)"IntegrationNewServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]), interfaceName, endTime - startTime);
        String timeUserKey = serviceSchemeKey + "timeUser";
        servicefailMsg.put(timeUserKey, (servicefailMsg.get(timeUserKey) == null ? "" : (String)servicefailMsg.get(timeUserKey)) + useStr);
    }

    public static String getMappedKey(MappedRow row) {
        String bookType = IntegrationUtil.getSrcMember(row.getSrcMapped().get("AccountBookType"));
        String accountTable = IntegrationUtil.getSrcMember(row.getSrcMapped().get("AccountTable"));
        String orgView = IntegrationUtil.getSrcMember(row.getSrcMapped().get("OrgView"));
        String reClassParam = IntegrationUtil.getSrcMember(row.getSrcMapped().get("ReClassParam"));
        if (StringUtils.isEmpty((CharSequence)reClassParam) || NULL.equals(reClassParam)) {
            reClassParam = "1";
        }
        return bookType + SPLIT + accountTable + SPLIT + orgView + SPLIT + reClassParam;
    }

    private static String getSrcMember(MappedSourceItem item) {
        if (item == null || kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)item.getNumber())) {
            return NULL;
        }
        return item.getNumber();
    }

    public static List<MappedDefaultVal> getDefValue(List<MappedDefaultVal> defVals, String dim, boolean isSingleScene, IIntegrateContext _ctx) {
        if (!isSingleScene) {
            return defVals;
        }
        ArrayList<MappedDefaultVal> res = new ArrayList<MappedDefaultVal>(16);
        String dimStr = null;
        if ("Entity".equals(dim)) {
            dimStr = (String)_ctx.getOrg().p2;
        } else if ("Scenario".equals(dim)) {
            dimStr = (String)_ctx.getScene().p2;
        } else if ("Year".equals(dim)) {
            dimStr = (String)_ctx.getFy().p2;
        } else if ("Period".equals(dim)) {
            dimStr = (String)_ctx.getPeriod().p2;
        } else if ("Currency".equals(dim)) {
            dimStr = (String)_ctx.getCurrency().p2;
        }
        if (dimStr == null) {
            return defVals;
        }
        for (MappedDefaultVal defVal : defVals) {
            if (!dimStr.equals(defVal.getNumber())) continue;
            res.add(defVal);
            break;
        }
        return res;
    }

    public static boolean intSingleScene(IIntegrateContext ctx, String ... product) {
        Pair<Long, String> schema = ctx.getSchema();
        if (schema == null) {
            return false;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"issrc.number", (QFilter[])new QFilter[]{new QFilter("id", "=", schema.p1)});
        if (object == null) {
            return false;
        }
        for (String pro : product) {
            if (!pro.equals(object.getString("issrc.number"))) continue;
            return true;
        }
        return false;
    }

    public static int getIndexDim(String[] allDims, String dim) {
        for (int i = 0; i < allDims.length; ++i) {
            if (!dim.equals(allDims[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getLockDim(Long modelId) {
        long lockDim = DataLockHelper.getLockDim(modelId);
        if (lockDim == 0L) {
            return null;
        }
        return MemberReader.getDimensionNumById((long)lockDim);
    }

    public static Pair<Boolean, List<Pair<String, String>>> getLockDim(Long modelId, String sceneNum, String entity, String year, String period, String currency, String dimNum) {
        HashSet<String> yearNums = new HashSet<String>(16);
        yearNums.add(year);
        HashSet<String> periodNums = new HashSet<String>(16);
        periodNums.add(period);
        HashSet<String> currencyNums = new HashSet<String>(16);
        currencyNums.add(currency);
        LockScope lockScope = LockScopeServiceHelper.queryLockScope(modelId, sceneNum, yearNums, periodNums, currencyNums);
        Pair<Boolean, List<Pair<String, String>>> lock = lockScope.isLock(year, period, currency, entity, dimNum);
        if (((Boolean)lock.p1).booleanValue() && lock.p2 == null) {
            ArrayList<Pair> list = new ArrayList<Pair>(16);
            Pair resPair = Pair.onePair((Object)ResManager.loadKDString((String)"\u5df2\u5f52\u6863", (String)"MergeStatus_0", (String)"fi-bcm-business", (Object[])new Object[0]), (Object)"");
            list.add(resPair);
            return Pair.onePair((Object)true, list);
        }
        return lock;
    }

    public static boolean checkLock(String[] dims, String[] dimData, String lockDim, Map<String, String> warnRpt, Long modelId, String sceneNum, String orgNum, String yearNum, String periodNum, String currencyNum) {
        if (lockDim == null || warnRpt == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < dims.length; ++i) {
            if (!lockDim.equals(dims[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        return IntegrationUtil.checkLock(lockDim, dimData[index], warnRpt, modelId, sceneNum, orgNum, yearNum, periodNum, currencyNum);
    }

    public static boolean checkLock(String lockDim, String lockDimNum, Map<String, String> warnRpt, Long modelId, String sceneNum, String orgNum, String yearNum, String periodNum, String currencyNum) {
        if (lockDim == null) {
            return false;
        }
        Pair<Boolean, List<Pair<String, String>>> lock = IntegrationUtil.getLockDim(modelId, sceneNum, orgNum, yearNum, periodNum, currencyNum, lockDimNum);
        if (((Boolean)lock.p1).booleanValue()) {
            IntegrationUtil.getLockMap(warnRpt, lockDim, lockDimNum, (List)lock.p2);
            return true;
        }
        return false;
    }

    private static void getLockMap(Map<String, String> warnRpt, String lockDim, String dimDatum, List<Pair<String, String>> msg) {
        String key = lockDim + ":" + dimDatum;
        if (warnRpt.containsKey(key)) {
            return;
        }
        StringBuilder sb = new StringBuilder(16);
        for (Pair<String, String> pair : msg) {
            sb.append((String)pair.p1).append(":").append((String)pair.p2).append(";");
        }
        warnRpt.put(key, sb.toString());
    }

    public static boolean checkLock(SaveCommandInfo info, List<String> allDims, String[] saveDimNums, String lockDim, Map<String, String> warnRpt, Long modelId, String sceneNum, String orgNum, String yearNum, String periodNum, String currencyNum) {
        if (lockDim == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < allDims.size(); ++i) {
            if (!lockDim.equals(allDims.get(i))) continue;
            index = i;
            break;
        }
        currencyNum = IntegrationUtil.getCurrncyNum(currencyNum, info, allDims, saveDimNums);
        if (index == -1) {
            List fixedDimensions = info.getFixedDimensions();
            for (FixedDimension fixd : fixedDimensions) {
                if (!lockDim.equals(fixd.getName())) continue;
                return IntegrationUtil.checkLock(lockDim, fixd.getValue(), warnRpt, modelId, sceneNum, orgNum, yearNum, periodNum, currencyNum);
            }
        } else {
            return IntegrationUtil.checkLock(lockDim, saveDimNums[index], warnRpt, modelId, sceneNum, orgNum, yearNum, periodNum, currencyNum);
        }
        return false;
    }

    private static String getCurrncyNum(String currencyNum, SaveCommandInfo info, List<String> allDims, String[] saveDimNums) {
        if ("DC".equals(currencyNum) || "EC".equals(currencyNum)) {
            int index = -1;
            for (int i = 0; i < allDims.size(); ++i) {
                if (!DimTypesEnum.CURRENCY.getNumber().equals(allDims.get(i))) continue;
                index = i;
                break;
            }
            if (index == -1) {
                List fixedDimensions = info.getFixedDimensions();
                for (FixedDimension fixd : fixedDimensions) {
                    if (!DimTypesEnum.CURRENCY.getNumber().equals(fixd.getName())) continue;
                    return fixd.getValue();
                }
            } else {
                return saveDimNums[index];
            }
        }
        return currencyNum;
    }

    public static Map<String, String> getWarnRptFromCtx(IIntegrateContext _ctx) {
        Map schemeServicesLockDim = (Map)_ctx.getCustomParam("schemeServicesLockDim");
        if (schemeServicesLockDim == null) {
            return null;
        }
        String schemeKey = (String)_ctx.getOrg().p2 + (String)_ctx.getSchema().p2 + (String)_ctx.getCurrency().p2 + "lockDim";
        return (Map)schemeServicesLockDim.get(schemeKey);
    }

    public static Map<String, String> getWarnRptFromDiCtx(DIIIntegrateContext _ctx) {
        Map schemeServicesLockDim = (Map)_ctx.getCustomParam("schemeServicesLockDim");
        if (schemeServicesLockDim == null) {
            return null;
        }
        String schemeKey = (String)_ctx.getOrg().p2 + (String)_ctx.getSchema().p2 + (String)_ctx.getCurrency().p2 + "lockDim";
        return (Map)schemeServicesLockDim.get(schemeKey);
    }

    public static Map<String, Map<String, List<String>>> getMsgMap(Map<String, String> map) {
        HashMap<String, Map<String, List<String>>> resMap = new HashMap<String, Map<String, List<String>>>(16);
        for (Map.Entry<String, String> m : map.entrySet()) {
            String[] splitKey = m.getKey().split(":");
            String[] splitValue = m.getValue().split(":");
            Map valueDim = resMap.computeIfAbsent(splitKey[0], e -> new HashMap(16));
            List valueNum = valueDim.computeIfAbsent(splitValue[0], e -> new ArrayList(16));
            valueNum.add(splitKey[1]);
        }
        return resMap;
    }

    public static Map<Long, Map<String, Object>> getPubMap(Long schemeId, Long dimmapid) {
        HashMap<Long, Map<String, Object>> pubMap = new HashMap<Long, Map<String, Object>>(16);
        boolean enable = IntegrationUtil.checkMappingSetEnable(schemeId, 0L);
        if (!enable) {
            return pubMap;
        }
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        filter.and("mappedtype", "=", (Object)"1");
        if (dimmapid != null) {
            filter = new QFilter("id", "=", (Object)dimmapid);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, scheme, pubmappingid, isdimmaptargentry.tagdimension.number, isdimmapsrcentry.srcdimension", (QFilter[])filter.toArray());
        for (DynamicObject obj : query) {
            if (obj.getLong("pubmappingid") == 0L) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("dimmapid", obj.getLong("id"));
            map.put("dimNumber", obj.getString("isdimmaptargentry.tagdimension.number"));
            map.put("srcDimId", obj.getLong("isdimmapsrcentry.srcdimension"));
            pubMap.put(obj.getLong("pubmappingid"), map);
        }
        return pubMap;
    }

    public static List<DynamicObject> addPubMapping(DynamicObject[] col, Map<Long, Map<String, Object>> pubMap) {
        if (pubMap.size() == 0) {
            return Arrays.asList(col);
        }
        HashSet<String> srcSet = new HashSet<String>(16);
        HashSet<String> tarSet = new HashSet<String>(16);
        ArrayList<DynamicObject> resList = new ArrayList<DynamicObject>(16);
        for (DynamicObject dot : col) {
            if (dot.getLong("pubmappingid") != 0L) continue;
            Long id = dot.getLong("dimmapid");
            srcSet.add(id + dot.getString("srcmembnumber"));
            tarSet.add(id + dot.getString("targmembnumber"));
            resList.add(dot);
        }
        for (DynamicObject dot : col) {
            String key;
            if (dot.getLong("pubmappingid") == 0L) continue;
            Map<String, Object> map = pubMap.get(dot.getLong("pubmappingid"));
            String dimNumber = (String)map.get("dimNumber");
            Long dimmapid = (Long)map.get("dimmapid");
            Long srcDimId = (Long)map.get("srcDimId");
            dot.set("dimmapid", (Object)dimmapid);
            ((DynamicObject)dot.getDynamicObjectCollection("issinglemapentry").get(0)).set("srcdim", (Object)srcDimId);
            boolean is4Dim = IntegrationUtil.checkIs4Dim(dimNumber);
            boolean isAdd = false;
            if (is4Dim) {
                key = dimmapid + dot.getString("targmembnumber");
                if (tarSet.add(key)) {
                    isAdd = true;
                }
            } else {
                key = dimmapid + dot.getString("srcmembnumber");
                if (srcSet.add(key)) {
                    isAdd = true;
                }
            }
            if (!isAdd) continue;
            resList.add(dot);
        }
        return resList;
    }

    public static void deleteSingMappingByAll() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_bdmapping", (String)"entryentity.id", null);
        HashSet ids = new HashSet(16);
        if (query == null || query.size() == 0) {
            return;
        }
        query.forEach(e -> ids.add(e.getLong("entryentity.id")));
        if (ids.size() > 0) {
            QFilter qf1 = new QFilter("pubmappingid", ">", (Object)0L);
            QFilter qf2 = new QFilter("pubmappingid", "not in", ids);
            QFilter qf3 = new QFilter("schemeid", "=", (Object)0L);
            DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        }
    }
}

