/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.integration.ExportFileRuleEnum;
import org.apache.commons.collections.CollectionUtils;

public class IsRpaSchemeUtil {
    public static String trimFirstAndLastChar(String str, String element) {
        if (StringUtils.isNotEmpty((String)str)) {
            boolean endIndexFlag;
            boolean beginIndexFlag;
            do {
                int endIndex;
                int beginIndex = str.indexOf(element) == 0 ? 1 : 0;
                int n = endIndex = str.lastIndexOf(element) + 1 == str.length() ? str.lastIndexOf(element) : str.length();
                if (StringUtils.isEmpty((String)str)) break;
                beginIndexFlag = str.indexOf(element) == 0;
                str = str.substring(beginIndex, endIndex);
                boolean bl = endIndexFlag = str.lastIndexOf(element) + 1 == str.length();
            } while (beginIndexFlag || endIndexFlag);
        }
        return str;
    }

    public static void buildJqExportParamMap(long schemeId, Map<String, Map<String, String>> jqOrgMappingSingleMap, Map<String, Set<String>> reportData2OrgMap) {
        DynamicObjectCollection singleMap = QueryServiceHelper.query((String)"bcm_issinglemap", (String)"targmembid,targmembnumber,srcmembnumber,srcmembname,srcreporttype,reportdatatype", (QFilter[])new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId)});
        if (CollectionUtils.isNotEmpty((Collection)singleMap)) {
            for (DynamicObject dy : singleMap) {
                if (dy == null) continue;
                String org = dy.getString("targmembnumber");
                String reportDataType = dy.getString("reportdatatype");
                if (StringUtils.isEmpty((String)reportDataType)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u6210\u5458\u6620\u5c04\u672a\u914d\u7f6e\u62a5\u8868\u6570\u636e\u3002", (String)"IsRpaSchemeUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(ExportFileRuleEnum.ENTERPRISECODE.getCode(), dy.getString("srcmembnumber"));
                map.put(ExportFileRuleEnum.COMPANY_NAME.getCode(), dy.getString("srcmembname"));
                map.put(ExportFileRuleEnum.REPORTTYPECODE.getCode(), String.valueOf(dy.getInt("srcreporttype")));
                map.put(ExportFileRuleEnum.REPORTDATATYPE.getCode(), reportDataType);
                jqOrgMappingSingleMap.put(org + "@" + reportDataType, map);
                reportData2OrgMap.computeIfAbsent(reportDataType, s -> new HashSet());
                Set<String> ids = reportData2OrgMap.get(reportDataType);
                ids.add(dy.getString("targmembid"));
            }
        }
    }

    public static String getMessageDetail(String noEffOrgs) {
        StringBuilder sb = new StringBuilder();
        for (String str : noEffOrgs.split(",")) {
            sb.append(str).append("\n");
        }
        return sb.toString();
    }
}

