/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;

public class SingleMapModel {
    protected IIntegrateContext _ctx;
    private Table<String, String, Pair<Long, String>> srcMapTargMemb;
    private Table<String, String, Pair<Long, String>> tarMapsrcMemb;
    private Table<Pair<String, String>, String, Pair<Long, String>> tarMapMultiSrcMemb;

    public SingleMapModel(IIntegrateContext _ctx) {
        this._ctx = _ctx;
        this.srcMapTargMemb = HashBasedTable.create();
        this.tarMapsrcMemb = HashBasedTable.create();
        this.tarMapMultiSrcMemb = HashBasedTable.create();
    }

    public void buildTar(long dimId) {
        MappedDimItem dimitem = this._ctx.getMappedDimItemById(dimId);
        if (this.tarMapsrcMemb.containsRow((Object)dimitem.getNumber())) {
            return;
        }
        List<DimMappedRelation.SingleDimRelationPair> relationPairList = this._ctx.getMappedRelation().getTarDim2Pairs().get(dimitem.getNumber());
        relationPairList.forEach(pair -> {
            if (pair != null && pair.getDimMappedId() != 0L) {
                String selector = "targmembnumber,srcmembnumber,targmembid,issinglemapentry.srcmemnumber,issinglemapentry.srcmembid, pubmappingid";
                List<DynamicObject> ds = IntegrationUtil.queryExMemberMapped(pair.getDimMappedId(), selector, (Map)this._ctx.getCustomParam("exAttrMap"), dimitem.getNumber());
                this.buildTarMapSrcMemb(dimitem, pair.getSourceDimItem().getDimItem().getNumber(), ds);
            }
        });
    }

    public void buildSrc(long dimId) {
        MappedDimItem dimitem = this._ctx.getMappedDimItemById(dimId);
        if (this.srcMapTargMemb.containsRow((Object)dimitem.getNumber())) {
            return;
        }
        QFBuilder qf = new QFBuilder();
        DimMappedRelation.SingleDimRelationPair sdp = this._ctx.getMappedRelation().getSingeDimRelationByDimId(dimId);
        if (sdp != null && sdp.getDimMappedId() != 0L) {
            qf.add("dimmapid", "=", (Object)sdp.getDimMappedId());
            String dimNumber = sdp.getTargetDimItem().getDimItem().getNumber();
            List<DynamicObject> ds = IntegrationUtil.queryExMemberMapped(sdp.getDimMappedId(), null, null, dimNumber);
            this.buildSrcMapTargMemb(dimitem, ds);
        }
    }

    private void buildSrcMapTargMemb(MappedDimItem dimitem, List<DynamicObject> ds) {
        for (DynamicObject obj : ds) {
            this.srcMapTargMemb.put((Object)dimitem.getNumber(), (Object)obj.getString("issinglemapentry.srcmemnumber"), (Object)Pair.onePair((Object)obj.getLong("targmembid"), (Object)obj.getString("targmembnumber")));
        }
    }

    public void buildSrc(DimMappedRelation.SingleDimRelationPair sdp) {
        QFBuilder qf = new QFBuilder();
        if (sdp != null && sdp.getDimMappedId() != 0L) {
            qf.add("dimmapid", "=", (Object)sdp.getDimMappedId());
            try (DataSet ds = IntegrationUtil.queryMemberMapped(qf, null);){
                this.buildSrcMapTargMemb(sdp.getSourceDimItem().getDimItem(), ds);
            }
        }
    }

    public Pair<Long, String> getTar(String dim, String number) {
        return (Pair)this.srcMapTargMemb.get((Object)dim, (Object)number);
    }

    public Pair<Long, String> getSrc(String dim, String number) {
        return (Pair)this.tarMapsrcMemb.get((Object)dim, (Object)number);
    }

    public Map<String, Pair<Long, String>> getAllSrc(String dim) {
        return this.tarMapsrcMemb.row((Object)dim);
    }

    public Pair<Long, String> getFromMultiSrc(String dim, String srcDim, String number) {
        return (Pair)this.tarMapMultiSrcMemb.get((Object)Pair.onePair((Object)dim, (Object)srcDim), (Object)number);
    }

    private void buildSrcMapTargMemb(MappedDimItem dimitem, DataSet ds) {
        while (ds.hasNext()) {
            Row r = ds.next();
            this.srcMapTargMemb.put((Object)dimitem.getNumber(), (Object)r.getString("issinglemapentry.srcmemnumber"), (Object)Pair.onePair((Object)r.getLong("targmembid"), (Object)r.getString("targmembnumber")));
        }
    }

    private void buildTarMapSrcMemb(MappedDimItem dimitem, String srcDimNum, List<DynamicObject> ds) {
        for (DynamicObject obj : ds) {
            this.tarMapsrcMemb.put((Object)dimitem.getNumber(), (Object)obj.getString("targmembnumber"), (Object)Pair.onePair((Object)obj.getLong("issinglemapentry.srcmembid"), (Object)obj.getString("issinglemapentry.srcmemnumber")));
            this.tarMapMultiSrcMemb.put((Object)Pair.onePair((Object)dimitem.getNumber(), (Object)srcDimNum), (Object)obj.getString("targmembnumber"), (Object)Pair.onePair((Object)obj.getLong("issinglemapentry.srcmembid"), (Object)obj.getString("issinglemapentry.srcmemnumber")));
        }
    }

    public Map<String, Pair<Long, String>> getMapBySor(String dim) {
        return this.srcMapTargMemb.row((Object)dim);
    }

    public Table<String, String, Pair<Long, String>> getTarMapsrcMemb() {
        return this.tarMapsrcMemb;
    }
}

