/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest;

import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.invest.AccountTabInfo;
import kd.fi.bcm.business.invest.AccountTabManager;
import kd.fi.bcm.business.invest.AccountTabModel;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class AccountCacheService {
    private IPageCache cache;
    private String KEY_TABMANAGER = "TABMANAGER";

    public AccountCacheService(IPageCache cache) {
        this.cache = cache;
    }

    public void cacheAccontTabModel(AccountTabModel tabModel) {
        this.cache.put(tabModel.getTabKey(), ObjectSerialUtil.toByteSerialized((Object)tabModel));
    }

    public AccountTabModel getAccontTabModel(AccountTabInfo tabInfo) {
        String serial = this.cache.get(tabInfo.getTabKey());
        AccountTabModel tabModel = null;
        tabModel = StringUtils.isNotEmpty((String)serial) ? (AccountTabModel)ObjectSerialUtil.deSerializedBytes((String)serial) : new AccountTabModel(tabInfo.getTabKey());
        return tabModel;
    }

    public void cacheAccountTabManager(AccountTabManager manager) {
        this.cache.put(this.KEY_TABMANAGER, ObjectSerialUtil.toByteSerialized((Object)manager));
    }

    public AccountTabManager getAccountTabManager() {
        String serial = this.cache.get(this.KEY_TABMANAGER);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (AccountTabManager)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return null;
    }
}

