/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.business.invest.AccountTabInfo;

public class AccountTabManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AccountTabInfo> tabs = new ArrayList<AccountTabInfo>();

    public boolean addAccountTabInfo(AccountTabInfo tabInfo) {
        if (!this.tabs.contains((Object)tabInfo)) {
            return this.tabs.add(tabInfo);
        }
        return false;
    }

    public void releaseByKey(String key) {
        int index = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            AccountTabInfo tab = this.tabs.get(i);
            if (!tab.getTabKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.tabs.remove(index);
        }
    }

    public AccountTabInfo getCurrSelectReportTabInfo() {
        for (AccountTabInfo tab : this.tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public AccountTabInfo getFirstAccountTabInfo() {
        return this.tabs.size() > 0 ? this.tabs.get(0) : null;
    }

    public AccountTabInfo searchTabInfo(String tabKey) {
        for (AccountTabInfo t : this.tabs) {
            if (!tabKey.equals(t.getTabKey())) continue;
            return t;
        }
        return null;
    }

    public List<AccountTabInfo> getTabs() {
        return this.tabs;
    }

    public void setTabs(List<AccountTabInfo> tabs) {
        this.tabs = tabs;
    }
}

