/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetEntryConstant;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.invest.InvProcessEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class InvElimTemplateService {
    public static String getTemplateLongNumber(String foucusNodeId) {
        if (StringUtils.isEmpty((CharSequence)foucusNodeId)) {
            return "";
        }
        DynamicObject catalogDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)foucusNodeId), (String)"bcm_invtemplatecatalog", (String)"longnumber");
        if (Objects.nonNull(catalogDy)) {
            return InvElimTemplateService.getCatalogPrefixByLongNumber(catalogDy.getString("longnumber"));
        }
        return "";
    }

    public static String getCatalogPrefixByLongNumber(String longNumber) {
        TemplateCatalogEnum catalogEnum = InvElimTemplateService.getCatalogEnumByLongNumber(longNumber);
        return catalogEnum == null ? "" : catalogEnum.getLongnumber();
    }

    public static TemplateCatalogEnum getCatalogEnumByLongNumber(String longNumber) {
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            return null;
        }
        if (Objects.equals(longNumber, TemplateCatalogEnum.ROOT.getLongnumber())) {
            return TemplateCatalogEnum.ROOT;
        }
        for (TemplateCatalogEnum catalogEnum : TemplateCatalogEnum.values()) {
            if (catalogEnum == TemplateCatalogEnum.ROOT || !longNumber.startsWith(catalogEnum.getLongnumber())) continue;
            return catalogEnum;
        }
        return null;
    }

    public static TreeNode getTemplateTree(long modelId, DynamicObject[] templateColl, List<TreeNode> templateNodeList, String rootId, TreeNode treeNode) {
        List<Map<String, String>> templatecatalogList = InvElimTemplateService.mergeTemplatecatalogList(modelId);
        return InvElimTemplateService.traverseTemplateTree(templatecatalogList, templateColl, templateNodeList, rootId, treeNode);
    }

    public static TreeNode traverseTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObject[] templateColl, List<TreeNode> templateNodeList, String rootId, TreeNode treeNode) {
        if (!templateNodeList.isEmpty()) {
            treeNode.setChildren(templateNodeList);
        }
        if (templatecatalogList.isEmpty()) {
            return new TreeNode();
        }
        for (Map<String, String> map : templatecatalogList) {
            String fieldId = map.get("id");
            String fieldName = map.get("name");
            String parentid = map.get("parentid");
            if (!parentid.equals(rootId)) continue;
            if (templateColl != null && templateColl.length > 0) {
                templateNodeList = new ArrayList<TreeNode>(templateColl.length);
                for (DynamicObject templateObject : templateColl) {
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString());
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = InvElimTemplateService.traverseTemplateTree(templatecatalogList, templateColl, templateNodeList, fieldId, entry);
            ArrayList<TreeNode> children = treeNode.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                treeNode.setChildren(children);
            }
            if (entry.getChildren() != null) {
                children.add(entry);
            }
            entry.setIsOpened(true);
        }
        return treeNode;
    }

    public static void saveDistributeRecord(List<DynamicObject> orgList, List<Long> tplIds, long modelId) {
        List<DynamicObject> distList = InvElimTemplateService.mergeResult(orgList, tplIds, modelId);
        if (CollectionUtils.isEmpty(distList)) {
            return;
        }
        List templateIds = distList.stream().map(s -> s.getLong("template")).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", (Object)templateIds.toArray());
        Collection tplList = BusinessDataServiceHelper.loadFromCache((String)"bcm_invelimtemplatebase", (String)"id,number,name", (QFilter[])new QFilter[]{qf}).values();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        String selectFields = "id,entity,template,range,propertyvalue,isexcept ";
        DynamicObjectCollection oldColl = QueryServiceHelper.query((String)"bcm_invelimtplassign", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (DynamicObject tem : oldColl) {
            Iterator<DynamicObject> itr = distList.iterator();
            while (itr.hasNext()) {
                DynamicObject dd = itr.next();
                Object entityid = dd.get("entity");
                String colName = !ObjectUtils.isEmpty((Object)entityid) ? "entity" : "propertyvalue";
                dd.set("creator", (Object)RequestContext.get().getCurrUserId());
                dd.set("createtime", (Object)TimeServiceHelper.now());
                if (tem.getLong("template") != dd.getLong("template") || !tem.get("range").equals(dd.get("range")) || !tem.get("isexcept").equals(dd.get("isexcept")) || tem.getLong(colName) != dd.getLong(colName)) continue;
                itr.remove();
            }
        }
        if (distList.isEmpty()) {
            return;
        }
        boolean flag = false;
        try (TXHandle tx = TX.required();){
            String result;
            try {
                DynamicObject[] newdoc = distList.toArray(new DynamicObject[0]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                if (oo.length > 0) {
                    SaveServiceHelper.update((DynamicObject[])tplList.toArray(new DynamicObject[0]));
                }
                result = (flag = true) ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName();
            }
            catch (Exception e) {
                try {
                    tx.markRollback();
                    throw e;
                }
                catch (Throwable throwable) {
                    result = flag ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName();
                    HashSet<String> numbers = new HashSet<String>(16);
                    HashSet<String> names = new HashSet<String>(16);
                    for (DynamicObject dy : tplList) {
                        numbers.add(dy.getString("number"));
                        names.add(dy.getString("name"));
                    }
                    String opDescription = Joiner.on((String)",").join(numbers) + " " + Joiner.on((String)",").join(names) + " " + result;
                    OperationLogUtil.writeOperationLog(OpItemEnum.SEND.getName(), opDescription, modelId, "bcm_invelimtplassign");
                    throw throwable;
                }
            }
            HashSet<String> numbers = new HashSet<String>(16);
            HashSet<String> names = new HashSet<String>(16);
            for (DynamicObject dy : tplList) {
                numbers.add(dy.getString("number"));
                names.add(dy.getString("name"));
            }
            String opDescription = Joiner.on((String)",").join(numbers) + " " + Joiner.on((String)",").join(names) + " " + result;
            OperationLogUtil.writeOperationLog(OpItemEnum.SEND.getName(), opDescription, modelId, "bcm_invelimtplassign");
        }
    }

    private static List<DynamicObject> mergeResult(List<DynamicObject> orgList, List<Long> tplList, Long modelId) {
        if (!orgList.isEmpty()) {
            HashMap<String, DynamicObject> mergeMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dyn : orgList) {
                String formatKey;
                IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)dyn.getLong("oid")).getBaseTreeNode();
                if (IDNumberTreeNode.NotFoundTreeNode != node) {
                    dyn.set("oid", (Object)node.getId());
                }
                if (mergeMap.containsKey(formatKey = String.format("%s_%s_%s_%s", dyn.get("oid"), dyn.get("pid"), dyn.get("rangevalue"), dyn.get("org_isexcept")))) continue;
                mergeMap.put(formatKey, dyn);
            }
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
            for (Long tem : tplList) {
                for (Map.Entry kv : mergeMap.entrySet()) {
                    DynamicObject org = (DynamicObject)kv.getValue();
                    DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invelimtplassign");
                    if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim()) || Objects.equals("0", org.getString("pid").trim())) {
                        distribute.set("entity", (Object)Long.valueOf(org.get("oid").toString()));
                    } else {
                        distribute.set("property", org.get("pid"));
                        distribute.set("propertyvalue", org.get("oid"));
                    }
                    distribute.set("range", org.get("rangevalue"));
                    distribute.set("template", (Object)tem);
                    distribute.set("model", (Object)modelId);
                    distribute.set("isexcept", (Object)org.getString("org_isexcept"));
                    result.add(distribute);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void deleteDistRecord(Object[] rows, long modelId) {
        QFilter idFilter = new QFilter("id", "in", (Object)rows);
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_invelimtplassign", (QFilter[])new QFilter[]{idFilter});
                OperationLogUtil.writeOperationLog(OpItemEnum.BACKSEND.getName(), Arrays.toString(rows) + " " + ResultStatusEnum.SUCCESS.getName(), modelId, "bcm_invelimtplassign");
            }
            catch (Exception ex) {
                OperationLogUtil.writeOperationLog(OpItemEnum.BACKSEND.getName(), ResultStatusEnum.FAIL.getName(), modelId, "bcm_invelimtplassign");
                tx.markRollback();
                throw ex;
            }
        }
    }

    public static List<Map<String, String>> mergeTemplatecatalogList(long modelId) {
        DynamicObjectCollection doc = InvElimTemplateService.getTemplatecatalogList(modelId);
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(10);
        doc.stream().forEach(p -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", p.getString("id"));
            map.put("name", p.getString("name"));
            map.put("parentid", p.getString("parent"));
            map.put("longnumber", p.getString("longnumber"));
            clist.add(map);
        });
        return clist;
    }

    public static DynamicObjectCollection getTemplatecatalogList(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,parent,name,longnumber";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_invtemplatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public static void initBalanceTypeCombo(IFormView view) {
        String balanceType = "balancetype";
        ComboEdit ce = (ComboEdit)view.getControl(balanceType);
        BalanceTypeEnum[] balanceTypeEnums = InvSheetEntryConstant.getBalanceTypeEnums();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(balanceTypeEnums.length);
        for (BalanceTypeEnum linkCreateTypeEnum : balanceTypeEnums) {
            items.add(new ComboItem(new LocaleString(linkCreateTypeEnum.getName()), String.valueOf(linkCreateTypeEnum.getIndex())));
        }
        ce.setComboItems(items);
        if (view.getModel().getValue(balanceType) == null) {
            view.getModel().setValue(balanceType, (Object)BalanceTypeEnum.BALANCE.getIndex());
        }
    }

    public static void initLinkCreateTypeCombo(IFormView view) {
        String linkCreateType = "linkcreatetype";
        ComboEdit ce = (ComboEdit)view.getControl(linkCreateType);
        InvSheetEntryConstant.LinkCreateTypeEnum[] linkCreateTypeEnums = InvSheetEntryConstant.LinkCreateTypeEnum.values();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(linkCreateTypeEnums.length);
        for (InvSheetEntryConstant.LinkCreateTypeEnum linkCreateTypeEnum : linkCreateTypeEnums) {
            items.add(new ComboItem(new LocaleString(linkCreateTypeEnum.getCaption()), linkCreateTypeEnum.getValue()));
        }
        ce.setComboItems(items);
        if (view.getModel().getValue(linkCreateType) == null) {
            view.getModel().setValue(linkCreateType, (Object)InvSheetEntryConstant.LinkCreateTypeEnum.AUTOCREATEADJUST.getValue());
        }
    }

    public static DynamicObjectCollection getTemplateColls(Long modelid) {
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        filter.and("templatecatalog.longnumber", "like", (Object)"root.InvElim%").and("status", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,name,templatecatalog,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])filters, (String)"sequence,number asc,versionnumber asc");
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet groupIds = new HashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            if (groupIds.add(groupId)) {
                result.add(c);
            }
        });
        return result;
    }

    public static List<ValueMapItem> initProcessCombo(long modelId) {
        ArrayList<ValueMapItem> items = new ArrayList<ValueMapItem>(10);
        InvElimTemplateService.getProcessCombo(modelId, (number, name) -> items.add(new ValueMapItem(null, number, new LocaleString(number + " " + name))));
        return items;
    }

    public static void getProcessCombo(long modelId, BiConsumer<String, String> consumerNumberAndName) {
        List ls = InvProcessEnum.getAllNumber();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("number", "in", (Object)ls);
        qfBuilder.add("isleaf", "=", (Object)true);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"number,name", (QFilter[])qfBuilder.toArray());
        for (DynamicObject dy : doc) {
            String number = dy.getString("number");
            if (!ls.contains(number)) continue;
            String name = dy.getString("name");
            consumerNumberAndName.accept(number, name);
            ls.remove(number);
        }
    }
}

