/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetTemplateConstant;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.StringUtils;

public class InvSheetTemplateService {
    public static DynamicObject[] getInvSheetAccLayout(Long templateId) {
        QFBuilder qfBuilder = new QFBuilder("template.id", "=", (Object)templateId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_invsheetacclayout", (String)"id,extdimid.id as extdimid,extdimid.name as name,extdimid.number as number", (QFilter[])qfBuilder.toArray());
        Set extdimids = doc.stream().map(dy -> dy.getLong("extdimid")).collect(Collectors.toSet());
        DynamicObject[] extdims = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", extdimids)}, (String)"dseq");
        return extdims;
    }

    public static List<Long> getInvSheetTempRelationType(Long templateId) {
        String baseDataId = String.join((CharSequence)".", "invrelationtype", "fbasedataid");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)baseDataId, (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        List<Long> relationTypeList = query.stream().map(dy -> dy.getLong(baseDataId)).collect(Collectors.toList());
        return relationTypeList;
    }

    public static DynamicObjectCollection getSheetEntryList(Long modelId, Long templateId) {
        String selectFields = "id,name,number,model,scenario,templatecatalog";
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter templateFilter = new QFilter("sheettemplate.id", "=", (Object)templateId);
        QFilter[] filters = new QFilter[]{modelFilter, templateFilter};
        String orderBys = "number";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"getSheetEntryList", (String)"bcm_invsheetttplentrys", (String)selectFields, (QFilter[])filters, (String)orderBys);
        return dcs;
    }

    public static String getMaxEntrySeq(Long modelId, Long templateId, String templateNumber) {
        int maxSeq = 0;
        DynamicObjectCollection sheetEntryList = InvSheetTemplateService.getSheetEntryList(modelId, templateId);
        for (int i = 0; i < sheetEntryList.size(); ++i) {
            String substring;
            DynamicObject entryLast = (DynamicObject)sheetEntryList.get(i);
            String numberLast = (String)entryLast.get("number");
            if (!numberLast.startsWith(templateNumber) || !StringUtils.isNumeric((String)(substring = numberLast.substring(templateNumber.length()))) || substring.length() != 3) continue;
            maxSeq = Math.max(maxSeq, Integer.parseInt(substring));
        }
        return String.format("%03d", maxSeq + 1);
    }

    public static Pair<List<Long>, List<Long>> readOrWritePermSheetTemp(Long modelId) {
        String modelIdStr;
        long currUserId = RequestContext.get().getCurrUserId();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(currUserId, modelIdStr = String.valueOf(modelId));
        if (adminUserBol) {
            return Pair.onePair(Collections.emptyList(), Collections.emptyList());
        }
        String userIdStr = String.valueOf(currUserId);
        ArrayListMultimap<String, Long> tmplPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplate", modelIdStr, userIdStr);
        List noPermTempIds = tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        ArrayListMultimap<String, Long> catalogPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplatecatalog", modelIdStr, userIdStr);
        List noPermCatalogs = catalogPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        QFBuilder filterNoPerm = new QFBuilder("id", "in", (Object)noPermCatalogs);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"longnumber", (QFilter[])filterNoPerm.toArray());
        Set longNumberLike = query.parallelStream().map(dy -> dy.getString("longnumber")).map(str -> str + "!%").collect(Collectors.toSet());
        for (String longLike : longNumberLike) {
            filterNoPerm.or("longnumber", "like", (Object)longLike);
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and(filterNoPerm);
        DynamicObjectCollection noPermCatalogDy = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])qfBuilder.toArray());
        List noPermCatalogIds = noPermCatalogDy.parallelStream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return Pair.onePair((Object)noPermTempIds, noPermCatalogIds);
    }

    public static DynamicObjectCollection querySheetTemp(Long modelId, Long year, Long period, String relationType, String rltCatalog) {
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)year);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)period);
        if (fyNode == IDNumberTreeNode.NotFoundTreeNode || periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            return new DynamicObjectCollection();
        }
        Pair<List<Long>, List<Long>> pair = InvSheetTemplateService.readOrWritePermSheetTemp(modelId);
        Date lastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)fyNode.getNumber(), (String)periodNode.getNumber());
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("invrelationtype.fbasedataid.number", "=", (Object)relationType).and("invrelationtype.fbasedataid.categorized", "=", (Object)rltCatalog).and("status", "=", (Object)InvSheetTemplateConstant.BillStatusEnum.ENABLE.getCode()).and("effectivedate", "<", (Object)lastDate).and(new QFilter("expiringdate", ">=", (Object)lastDate).or("expiringdate", "=", null)).and("id", "not in", pair.p1).and("templatecatalog", "not in", pair.p2).and("templatecatalog.longnumber", "like", (Object)(TemplateCatalogEnum.INVELIM.getLongnumber() + "%"));
        CharSequence[] selectFields = InvSheetTemplateConstant.getSelectSimpleFields();
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection querySheetTemp(Long modelId, Long year, Long period, Long groupId) {
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)year);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)period);
        if (fyNode == IDNumberTreeNode.NotFoundTreeNode || periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            return new DynamicObjectCollection();
        }
        Date lastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)fyNode.getNumber(), (String)periodNode.getNumber());
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("group", "=", (Object)groupId).and("effectivedate", "<", (Object)lastDate).and(new QFilter("expiringdate", ">=", (Object)lastDate).or("expiringdate", "=", null)).and("templatecatalog.longnumber", "like", (Object)(TemplateCatalogEnum.INVELIM.getLongnumber() + "%"));
        CharSequence[] selectFields = InvSheetTemplateConstant.getSelectSimpleFields();
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject queryPeriodUseTempDyByGroupIdAndNumber(Long groupId, String tempNumber, long modelId, long yearId, long periodId) {
        DynamicObjectCollection sheetTemps = InvSheetTemplateService.querySheetTemp(modelId, yearId, periodId, groupId);
        if (sheetTemps.isEmpty()) {
            return null;
        }
        String selectProperties = "id,number,name,sheettemplate.id,sheettemplate.number,sheettemplate.name";
        DynamicObject sheetTempDy = (DynamicObject)sheetTemps.get(0);
        long pkValue = sheetTempDy.getLong("id");
        QFBuilder qfBuilder = new QFBuilder("sheettemplate", "=", (Object)pkValue).and("number", "=", (Object)tempNumber);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_invsheetttplentrys", (String)selectProperties, (QFilter[])qfBuilder.toArray());
        if (load == null || load.length == 0) {
            return null;
        }
        DynamicObject dynamicObject = load[0];
        dynamicObject.set("sheettemplate", (Object)dynamicObject);
        return dynamicObject;
    }

    public static DynamicObjectCollection querySheetTemp(Long modelId, Long year, Long period) {
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)year);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)period);
        if (fyNode == IDNumberTreeNode.NotFoundTreeNode || periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            return new DynamicObjectCollection();
        }
        Date lastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)fyNode.getNumber(), (String)periodNode.getNumber());
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("effectivedate", "<", (Object)lastDate).and(new QFilter("expiringdate", ">=", (Object)lastDate).or("expiringdate", "=", null)).and("templatecatalog.longnumber", "like", (Object)(TemplateCatalogEnum.INVELIM.getLongnumber() + "%"));
        CharSequence[] selectFields = InvSheetTemplateConstant.getSelectSimpleFields();
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)String.join((CharSequence)",", selectFields), (QFilter[])qfBuilder.toArray());
    }
}

