/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.convert.convertor.CheckingDataHandler;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.model.CtrlHoldingCompanyScheme;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.entity.EntityBizRecord;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.BizRuleDebugLogInfoEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.ReportTypeEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.invest.InvCopyModuleEnum;
import kd.fi.bcm.common.enums.invest.InvCopyWayEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.BizRuleDebugLogInfo;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvestServiceHelper {
    protected static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvestServiceHelper.class);
    public static final String INVCHANGEENTRY = "shareholder,holderec,changedate,changetype,changeamount,account,remark,cvt1currenyid,rate1id,change1amount,cvt2currenyid,rate2id,change2amount,cvt3currenyid,rate3id,change3amount,cvt4currenyid,rate4id,change4amount,cvt5currenyid,rate5id,change5amount";
    public static final String INVSHARERELA = "shareholder,changetype,invchangetype,sharescale,investdate,isout,investamount,holderec,remark,changescale,iscontrol";
    public static final String INVSHARERELAFIELD = "id,shareholder,investeecompany,changescale,sharescale,investdate,isout,investamount,holderec,invcompanycurrency,remark,creatorid,createtime,modifierid,modifytime,model,sharecase,changetype,iscontrol,invchangetype";
    private static final String[] copyModuleName = new String[]{InvCopyModuleEnum.MERGE_NODE.type(), InvCopyModuleEnum.MERGE_STRUCT.type(), InvCopyModuleEnum.INVEST_REF.type(), InvCopyModuleEnum.DYNAMICTYPE_REF.type()};

    public static void checkOrgAccessible(long modelId, long sceneId, long yearId, long periodId, long orgId) {
        InvestServiceHelper.checkParamIsNull(modelId, sceneId, yearId, periodId, orgId);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgId);
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode || "Entity".equals(orgNode.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7\u3002", (String)"InvestServiceHelper_29", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        IDNumberTreeNode fyNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        if (LockScopeServiceHelper.isExistArchiving(modelId, sceneNode.getNumber(), fyNode.getNumber(), periodNode.getNumber())) {
            // empty if block
        }
        if (!PermissionServiceImpl.getInstance(modelId).hasWritePerm(orgNode.getDimId(), orgNode.getId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u65e0\u5199\u5165\u6743\u9650\u3002", (String)"InvestServiceHelper_33", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
        }
        if (ConfigServiceHelper.getBoolParam(modelId, "CM012") && !PeriodSettingHelper.checkPeriodStatus(modelId, orgNode.getNumber(), sceneId, yearId, periodId, "datastatus")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvestServiceHelper_30", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
        }
        if (MergeControlHelper.isQuoteLocked(modelId, sceneId, yearId, periodId, orgId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u672a\u5f00\u542f\u7248\u672c\u5316\u3002", (String)"InvestServiceHelper_31", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
        }
        McStatus mcStatus = MergeStatusHelper.getMcStatus(modelId, sceneId, yearId, periodId, orgId);
        if (mcStatus.getFlow().isSubmit()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u9ed8\u8ba4\u5e01\u62a5\u8868\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u8005\u201c\u5df2\u5f52\u6863\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvestServiceHelper_32", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
        }
    }

    public static void checkParamIsNull(long modelId, long sceneId, long yearId, long periodId, long orgId) {
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvestServiceHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (sceneId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvestServiceHelper_25", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (yearId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvestServiceHelper_26", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (periodId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a", (String)"InvestServiceHelper_27", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (orgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7", (String)"InvestServiceHelper_28", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static Pair<String, String> cvtPeriodAndYear(long modelId, long scenarioId, long yearId, long periodId, String yearNum, String periodNum) {
        int periodOffset = 0;
        int yearOffset = 0;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (StringUtils.isEmpty((String)yearNum) || "CurrentYear".equals(yearNum)) {
            yearNum = MemberReader.findFyMemberById((String)modelNum, (Long)yearId).getNumber();
        } else if ("LastYear".equals(yearNum)) {
            yearOffset = -1;
        } else {
            yearId = MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum).getId();
        }
        if (StringUtils.isEmpty((String)periodNum) || "CurrentPeriod".equals(periodNum)) {
            periodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId).getNumber();
        } else if ("LastPeriod".equals(periodNum)) {
            periodOffset = -1;
        } else {
            periodId = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum).getId();
        }
        if (periodOffset == 0 && yearOffset == 0) {
            return Pair.onePair((Object)yearNum, (Object)periodNum);
        }
        Tuple yearAndPeriod = PeriodUtils.getPeriodByOffset((long)modelId, (ScenarioMemberEnum)ScenarioMemberEnum.getMemberByNumber((String)MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId).getNumber()), (long)yearId, (long)periodId, (int)yearOffset, (int)periodOffset);
        return Pair.onePair((Object)MemberReader.findFyMemberById((String)modelNum, (Long)((Long)yearAndPeriod.item1)).getNumber(), (Object)MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)yearAndPeriod.item2)).getNumber());
    }

    public static String searchCtrlHoldingCompany(long modelId, long cslId, long sceneId, long fyId, long period, String ctrlOrg) {
        return new CtrlHoldingCompanyScheme(modelId, cslId, sceneId, fyId, period).searchCtrlHoldingCompany(ctrlOrg);
    }

    public static String searchNewCommonParent(Long modelId, Long scenarioId, Long yearId, Long periodId, long unitId, String entityNum) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode unitNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)unitId);
        IDNumberTreeNode entityNode = InvestServiceHelper.queryEffectiveOrgNode(modelId, scenarioId, yearId, periodId, unitId, entityNum);
        if (entityNode == null || entityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5728\u5408\u5e76\u8282\u70b9%2$s\u4e0b\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvestServiceHelper_34", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum, unitNode.getNumber()));
        }
        return AdjustCheckServiceHelper.getParentDirectChild(unitNode.getNumber(), entityNode.getLongNumber());
    }

    public static String searchOldCommonParent(Long modelId, Long scenarioId, Long yearId, Long periodId, long unitId, String holder, String invest, String entityNum) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode rightNode = InvestServiceHelper.queryEffectiveOrgNode(modelId, scenarioId, yearId, periodId, unitId, entityNum);
        String leftNodeNum = StringUtil.equals((String)holder, (String)entityNum) ? invest : holder;
        IDNumberTreeNode leftNode = InvestServiceHelper.queryEffectiveOrgNode(modelId, scenarioId, yearId, periodId, unitId, leftNodeNum);
        if (rightNode == IDNumberTreeNode.NotFoundTreeNode) {
            IDNumberTreeNode unitNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)unitId);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5728\u5408\u5e76\u8282\u70b9%2$s\u4e0b\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvestServiceHelper_34", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum, unitNode.getNumber()));
        }
        if (leftNode == IDNumberTreeNode.NotFoundTreeNode) {
            IDNumberTreeNode unitNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)unitId);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5728\u5408\u5e76\u8282\u70b9%2$s\u4e0b\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvestServiceHelper_34", (String)"fi-bcm-business", (Object[])new Object[0]), leftNodeNum, unitNode.getNumber()));
        }
        String theSameParentLongNum = CheckingDataHandler.getTheSameParentLongNum(leftNode.getLongNumber(), rightNode.getLongNumber());
        if (StringUtils.isEmpty((String)theSameParentLongNum) || "Entity".equals(theSameParentLongNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5171\u540c\u7236\u7ea7\u3002", (String)"InvestServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)(theSameParentLongNum = AdjustCheckServiceHelper.getParentDirectChild(theSameParentLongNum.substring(theSameParentLongNum.lastIndexOf("!") + 1), rightNode.getLongNumber()))) || "Entity".equals(theSameParentLongNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5408\u9002\u7684\u7236_\u5b50\u7f16\u7801\u3002", (String)"InvestServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return theSameParentLongNum;
    }

    public static String searchDirectParent(Long modelId, Long scenarioId, Long yearId, Long periodId, long unitId, String entityNum, List<Long> relaCslConfigPks) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode unitNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)unitId);
        Pair<Long, IDNumberTreeNode> entityNodePair = InvestServiceHelper.queryEffectiveOrgNodeWithRelaCsls(modelId, scenarioId, yearId, periodId, unitId, entityNum, relaCslConfigPks);
        if (entityNodePair.p2 == IDNumberTreeNode.NotFoundTreeNode) {
            if (CollectionUtil.isEmpty(relaCslConfigPks)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5728\u5408\u5e76\u8282\u70b9%2$s\u4e0b\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvestServiceHelper_34", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum, unitNode.getNumber()));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u8054\u89c6\u56fe\u65e0\u6cd5\u627e\u5230\u7ec4\u7ec7%1$s\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvestServiceHelper_35", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum));
        }
        return ((IDNumberTreeNode)entityNodePair.p2).getParent_SonNumber();
    }

    public static Pair<Long, IDNumberTreeNode> queryEffectiveOrgNodeWithRelaCsls(Long modelId, Long scenarioId, Long yearId, Long periodId, Long unitId, String entityNum, List<Long> relaCslConfigPks) {
        IDNumberTreeNode entityNode = InvestServiceHelper.queryEffectiveOrgNode(modelId, scenarioId, yearId, periodId, unitId, entityNum);
        if (entityNode == IDNumberTreeNode.NotFoundTreeNode && !CollectionUtil.isEmpty(relaCslConfigPks)) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            Map<Long, IDNumberTreeNode> csl2Node = BcmThreadCache.findMemberByNum((String)modelNum, (String)"Entity", (String)"Entity").getChildren().stream().collect(Collectors.toMap(child -> (Long)child.getProperty("cslscheme.id"), child -> child, (c1, c2) -> c1));
            for (long cslId : relaCslConfigPks) {
                Set<Long> orgList;
                IDNumberTreeNode root = csl2Node.get(cslId);
                if (root == null || CollectionUtil.isEmpty(orgList = InvestServiceHelper.queryEffectiveOrgMapCacheNoMerge(modelId, scenarioId, yearId, periodId, root.getId()).get(entityNum))) continue;
                return Pair.onePair((Object)cslId, (Object)BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgList.iterator().next()));
            }
        }
        return Pair.onePair((Object)0L, (Object)entityNode);
    }

    public static IDNumberTreeNode queryEffectiveOrgNode(Long modelId, Long scene, Long fyId, Long period, Long pId, String number) {
        return BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)"Entity", (long)InvestServiceHelper.queryEffectiveOrg(modelId, scene, fyId, period, pId, number));
    }

    public static Long queryEffectiveOrg(Long modelId, Long scene, Long fyId, Long period, Long pId, String number) {
        Set<Long> effOrgList = InvestServiceHelper.queryEffectiveOrgList(modelId, scene, fyId, period, pId, number);
        return CollectionUtil.isEmpty(effOrgList) ? Long.valueOf(0L) : effOrgList.iterator().next();
    }

    public static Set<Long> queryEffectiveOrgList(Long modelId, Long scene, Long fyId, Long period, Long pId, String number) {
        return InvestServiceHelper.queryEffectiveOrgMapCache(modelId, scene, fyId, period, pId).get(number);
    }

    public static Map<String, Set<Long>> queryEffectiveOrgMapCache(Long modelId, Long scene, Long fyId, Long period, Long pId) {
        return (Map)BcmThreadCache.get((Object)"queryEffectiveOrg", (Object)scene, (Object)fyId, (Object)period, (Object)pId, () -> {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pId);
            FilterOrgStructParam orgParam = new FilterOrgStructParam((long)modelId, (long)scene, fyId, (long)period).setAutoDelChild(false).setOpenSortedDictionary(true);
            Table<String, String, Boolean> mergeStructTable = InvestServiceHelper.getMergeStructInfoSetting(modelId, scene, fyId, period);
            Set children = parentNode.getAllChildrenIds();
            Set<Long> effectiveOrgIds = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, children).keySet();
            effectiveOrgIds.removeIf(orgId -> {
                IDNumberTreeNode child = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgId);
                Boolean isMergeStruct = (Boolean)mergeStructTable.get((Object)child.getParent().getNumber(), (Object)child.getNumber());
                return isMergeStruct != null && isMergeStruct == false;
            });
            EntityVersioningUtil.dealNonEffectiveChildren(modelId, children, effectiveOrgIds, (Table<String, Long, EntityBizRecord>)HashBasedTable.create(), true);
            Map<String, Set<Long>> resultMap = EntityVersioningUtil.sortOrgByChangeType(modelNum, parentNode.getNumber(), effectiveOrgIds, orgParam.getSortedDictionary());
            resultMap.remove(parentNode.getNumber());
            resultMap.computeIfAbsent(parentNode.getNumber(), a -> Sets.newHashSet()).add(pId);
            return resultMap;
        });
    }

    public static Map<String, Set<Long>> queryEffectiveOrgMapCacheNoMerge(Long modelId, Long scene, Long fyId, Long period, Long pId) {
        return (Map)BcmThreadCache.get((Object)"queryEffectiveOrg.NoMerge", (Object)scene, (Object)fyId, (Object)period, (Object)pId, () -> {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pId);
            FilterOrgStructParam orgParam = new FilterOrgStructParam((long)modelId, (long)scene, fyId, (long)period).setOpenSortedDictionary(true);
            Set children = parentNode.getAllChildrenIds();
            Set<Long> effectiveOrgIds = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, children).keySet();
            Map<String, Set<Long>> resultMap = EntityVersioningUtil.sortOrgByChangeType(modelNum, parentNode.getNumber(), effectiveOrgIds, orgParam.getSortedDictionary());
            resultMap.computeIfAbsent(parentNode.getNumber(), a -> Sets.newHashSet()).add(pId);
            return resultMap;
        });
    }

    public static DynamicObjectCollection queryInvChangeEntry(long invOrgId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("investeecompany", "=", (Object)invOrgId));
        return QueryServiceHelper.query((String)"bcm_invchangeentry", (String)INVCHANGEENTRY, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection queryInvChangeEntry(long invOrgId, long accountId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("investeecompany", "=", (Object)invOrgId));
        qfBuilder.add(new QFilter("account", "=", (Object)accountId));
        return QueryServiceHelper.query((String)"bcm_invchangeentry", (String)INVCHANGEENTRY, (QFilter[])qfBuilder.toArray(), (String)"changedate");
    }

    public static DynamicObjectCollection queryInvShareRela(long invOrgId, long shareCaseId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("investeecompany", "=", (Object)invOrgId));
        qfBuilder.add("sharecase", "=", (Object)shareCaseId);
        return QueryServiceHelper.query((String)"bcm_invsharerela", (String)INVSHARERELA, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection queryInvShareRela(long invOrgId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("investeecompany", "=", (Object)invOrgId));
        return QueryServiceHelper.query((String)"bcm_invsharerela", (String)INVSHARERELA, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection queryInvShareRelaByModelID(long modelId, long shareCaseId) {
        QFBuilder qfBuilder = InvShareRelaService.getIsolationQFilter(modelId, shareCaseId);
        return QueryServiceHelper.query((String)"bcm_invsharerela", (String)INVSHARERELAFIELD, (QFilter[])qfBuilder.toArray(), (String)"investdate");
    }

    public static DynamicObjectCollection queryInvShareRelaECByModel(long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        return QueryServiceHelper.query((String)"bcm_invsharerela", (String)"holderec,invcompanycurrency", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection getInvChangeAccountSetting(long modelId) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_invchangeacct", (String)"account.id,account.number,account.name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        return doc;
    }

    public static String translateInvformla(String formula, long modelid) throws Exception {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        Pair<String, List<IFormula>> pair = parser.parse(formula, encoder);
        String aNumber = "";
        String atNumber = "";
        for (ParamItem paramItem : ((IFormula)((List)pair.p2).get(0)).getParamList()) {
            int index = paramItem.toString().indexOf(46);
            if (index <= 0) continue;
            String dimNumber = paramItem.toString().substring(0, index);
            if (dimNumber.equals("A")) {
                aNumber = paramItem.toString().substring(index + 1);
                continue;
            }
            if (!dimNumber.equals("CT")) continue;
            atNumber = paramItem.toString().substring(index + 1);
        }
        DynamicObject a = DimensionServiceHelper.queryMemberNameByNumber("bcm_accountmembertree", modelid, aNumber);
        String result = a.getString("name");
        if (MemberReader.isExistChangeTypeDimension((long)modelid)) {
            DynamicObject at = DimensionServiceHelper.queryMemberNameByNumber("bcm_changetypemembertree", modelid, atNumber);
            result = result + "|" + at.getString("name");
        }
        return result;
    }

    public static String addDimToFormula(String formula, String shortnumber, String dimmem) {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        Pair<String, List<IFormula>> pair = Pair.onePair(null, null);
        try {
            pair = parser.parse(formula, coder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> formulas = new ArrayList<String>(((List)pair.p2).size());
        for (IFormula f : (List)pair.p2) {
            ParamItem pi = new ParamItem(shortnumber + "." + dimmem);
            if (!(f.getName().equals(FormulaEnum.Inv.name()) || f.getName().equals(FormulaEnum.Esp.name()) || f.getName().equals(FormulaEnum.Bn.name()))) {
                f.getParamList().add(pi);
            }
            formulas.add(f.toString());
        }
        formula = ChkCheckServiceHelper.fixFormulaIntoLetter(formulas, (String)pair.p1);
        return formula;
    }

    private static Object[] mergeNodeUpdate(List<DynamicObject> moduleList, Map<Long, String> numbers, Long mode, Long scenario, Long year, Long period) {
        HashMap<Long, String> data = new HashMap<Long, String>(16);
        Map<Long, McStatus> submitNode = InvestServiceHelper.filterSubmitNode(mode, scenario, year, period, new HashSet<Long>(numbers.keySet()));
        moduleList.forEach(e -> {
            Long orgId = e.getLong("org.id");
            if (numbers.containsKey(orgId) && !submitNode.containsKey(orgId)) {
                data.put(orgId, e.getString("mergedatasource"));
            }
        });
        return MergeControlHelper.saveMergeDataSet(mode, scenario, year, period, data);
    }

    public static Map<Long, McStatus> filterSubmitNode(Long model, Long scenario, Long year, Long period, Set<Long> orgIds) {
        Map<Long, McStatus> batchMcStatus = McStatus.batchGetMcStatus(model, orgIds, scenario, year, period);
        Map<Long, McStatus> collect = batchMcStatus.entrySet().stream().filter(status -> ((McStatus)status.getValue()).getArchive().isArchive() || ((McStatus)status.getValue()).getFlow().isSubmit()).collect(Collectors.toMap(k -> (Long)k.getKey(), v -> (McStatus)v.getValue()));
        return collect;
    }

    public static kd.fi.bcm.common.Tuple<String, String, String> periodCopy(Map returnData, DynamicObject selectedNode, Long mode, Long scenario, Long year, Long period) {
        HashBasedTable messageColl = HashBasedTable.create();
        ArrayList<String> exMsg = new ArrayList<String>(16);
        Arrays.stream(copyModuleName).forEach(arg_0 -> InvestServiceHelper.lambda$periodCopy$15(returnData, selectedNode, mode, scenario, year, period, (Table)messageColl, exMsg, arg_0));
        return InvestServiceHelper.buildResult((Table<String, InvCopyModuleEnum, Collection<String>>)messageColl, exMsg);
    }

    private static void periodNotOpenTip(List<String> periodNotOpen, Map<String, Set<String>> resultMap) {
        for (String orgNumber : periodNotOpen) {
            resultMap.computeIfAbsent(orgNumber, k -> new HashSet(16)).add(ResManager.loadKDString((String)"\u671f\u95f4\u672a\u5f00\u542f", (String)"InvestServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static void noPermTip(List<String> noPermMergeList, Map<String, Set<String>> resultMap) {
        for (String orgNumber : noPermMergeList) {
            resultMap.computeIfAbsent(orgNumber, k -> new HashSet(16)).add(ResManager.loadKDString((String)"\u65e0\u5199\u5165\u6743\u9650", (String)"InvestServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static void submitTip(List<String> submitStatusList, Map<String, Set<String>> resultMap) {
        for (String orgNumber : submitStatusList) {
            resultMap.computeIfAbsent(orgNumber, k -> new HashSet(16)).add(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863", (String)"InvestServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static kd.fi.bcm.common.Tuple<String, String, String> buildResult(Table<String, InvCopyModuleEnum, Collection<String>> messageColl, List<String> exceptionMsg) {
        Set failOrg;
        if (messageColl.isEmpty() || CollectionUtil.isEmpty((Collection)(failOrg = messageColl.rowKeySet()))) {
            return new kd.fi.bcm.common.Tuple((Object)String.join((CharSequence)"\n\n", exceptionMsg), (Object)"", (Object)"");
        }
        String header = String.format(ResManager.loadKDString((String)"%1$s \u4e2a\u7ec4\u7ec7\u590d\u5236\u5931\u8d25\u3002", (String)"InvestServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]), failOrg.size());
        InvCopyModuleEnum[] copyModuleEnums = InvCopyModuleEnum.values();
        StringJoiner detailMsg = new StringJoiner("\n\n");
        for (String org : failOrg) {
            StringJoiner moduleMsg = new StringJoiner(";");
            for (InvCopyModuleEnum copyModuleEnum : copyModuleEnums) {
                Collection failDetails = (Collection)messageColl.get((Object)org, (Object)copyModuleEnum);
                if (CollectionUtil.isEmpty((Collection)failDetails)) continue;
                String text = copyModuleEnum.text();
                String details = ResManager.loadKDString((String)"%1$s\u590d\u5236\u5931\u8d25\uff08%2$s\uff09", (String)"InvestServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]);
                String format = String.format(details, text, String.join((CharSequence)",", failDetails));
                moduleMsg.add(format);
            }
            detailMsg.add(org + ":" + moduleMsg);
        }
        return new kd.fi.bcm.common.Tuple((Object)String.join((CharSequence)"\n\n", exceptionMsg), (Object)header, (Object)detailMsg.toString());
    }

    private static Map<String, Set<String>> copyMergeInfo(Map<?, ?> returnData, DynamicObject selectedNode, String module, Long modelId, Long tarScenario, Long tarYear, Long tarPeriod, Consumer<Map<String, Object>> consumer) {
        String copyWay = (String)returnData.get("copyway");
        HashSet allChildren = new HashSet(16);
        Map<Long, String> mergeNodeId2Number = InvestServiceHelper.collectMergeNode(selectedNode, modelId, copyWay, root -> {
            if (InvCopyWayEnum.NODE_ONLY.type().equals(copyWay)) {
                allChildren.addAll(root.getChildrenIds());
            } else {
                allChildren.addAll(root.getAllChildren().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
            }
        });
        Set<Long> tarEffectiveMerge = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(new FilterOrgStructParam(modelId, tarScenario, tarYear, tarPeriod, false, false), new ArrayList<Long>(mergeNodeId2Number.keySet())).keySet();
        Set<String> periodOpenNumber = InvRelationSearchService.batchSelectPeriodStatusOpen(modelId, Sets.newHashSet(mergeNodeId2Number.values()), tarScenario, tarYear, tarPeriod, "datastatus");
        Set periodNotOpenMerge = mergeNodeId2Number.entrySet().stream().filter(entry -> tarEffectiveMerge.contains(entry.getKey())).filter(entry -> !periodOpenNumber.contains(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        List<String> periodNotOpen = mergeNodeId2Number.entrySet().stream().filter(entry -> periodNotOpenMerge.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        Set<Long> havePermMerge = InvRelationSearchService.dealNoPermOrg(Sets.newHashSet(mergeNodeId2Number.keySet()), modelId);
        List noPermMerge = mergeNodeId2Number.keySet().stream().filter(tarEffectiveMerge::contains).filter(id -> !havePermMerge.contains(id)).collect(Collectors.toList());
        List<String> noPermMergeList = mergeNodeId2Number.entrySet().stream().filter(entry -> noPermMerge.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<String> submitStatusList = new ArrayList(16);
        ArrayList finalSubmitStatus = new ArrayList(16);
        boolean structNotCheckSubmitStatus = ConfigServiceHelper.getBoolParam(modelId, "isStructNotCheckSubmitStatus");
        if (!(InvCopyModuleEnum.INVEST_REF.type().equals(module) || InvCopyModuleEnum.DYNAMICTYPE_REF.type().equals(module) || InvCopyModuleEnum.MERGE_STRUCT.type().equals(module) && structNotCheckSubmitStatus)) {
            Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelId, Sets.newHashSet(mergeNodeId2Number.keySet()), tarScenario, tarYear, tarPeriod);
            List submitStatus = mergeNodeId2Number.keySet().stream().filter(tarEffectiveMerge::contains).filter(id -> ((McStatus)mcStatusMap.get(id)).getFlow().isSubmit()).collect(Collectors.toList());
            submitStatusList = mergeNodeId2Number.entrySet().stream().filter(entry -> submitStatus.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            finalSubmitStatus.addAll(submitStatus);
        }
        Map<Long, String> copyMerge = mergeNodeId2Number.entrySet().stream().filter(entry -> tarEffectiveMerge.contains(entry.getKey())).filter(entry -> !periodNotOpenMerge.contains(entry.getKey())).filter(entry -> !noPermMerge.contains(entry.getKey())).filter(entry -> !finalSubmitStatus.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Object> tempParamMap = new HashMap<String, Object>(16);
        tempParamMap.put("returnData", returnData);
        tempParamMap.put("allChildren", allChildren);
        tempParamMap.put("tarEffectiveMerge", tarEffectiveMerge);
        tempParamMap.put("periodNotOpenMerge", periodNotOpenMerge);
        tempParamMap.put("noPermMerge", noPermMerge);
        tempParamMap.put("submitStatus", finalSubmitStatus);
        tempParamMap.put("copyMerge", copyMerge);
        tempParamMap.put("modelId", modelId);
        tempParamMap.put("tarScenario", tarScenario);
        tempParamMap.put("tarYear", tarYear);
        tempParamMap.put("tarPeriod", tarPeriod);
        tempParamMap.put("module", module);
        HashMap<String, Set<String>> multimap = new HashMap<String, Set<String>>(16);
        InvestServiceHelper.periodNotOpenTip(periodNotOpen, multimap);
        InvestServiceHelper.noPermTip(noPermMergeList, multimap);
        InvestServiceHelper.submitTip(submitStatusList, multimap);
        consumer.accept(tempParamMap);
        return multimap;
    }

    private static void copyMergerStruct(Map<String, Object> paramMap) {
        try {
            Set allChildren = (Set)paramMap.get("allChildren");
            Set tarEffectiveMerge = (Set)paramMap.get("tarEffectiveMerge");
            Set periodNotOpenMerge = (Set)paramMap.get("periodNotOpenMerge");
            List noPermMerge = (List)paramMap.get("noPermMerge");
            List submitStatus = (List)paramMap.get("submitStatus");
            Map copyMerge = (Map)paramMap.get("copyMerge");
            Long modelId = (Long)paramMap.get("modelId");
            Long tarScenario = (Long)paramMap.get("tarScenario");
            Long tarYear = (Long)paramMap.get("tarYear");
            Long tarPeriod = (Long)paramMap.get("tarPeriod");
            Map returnData = (Map)paramMap.get("returnData");
            Long fromSceneId = (Long)returnData.get("sceneId");
            Long fromYearId = (Long)returnData.get("yearId");
            Long fromPeriodId = (Long)returnData.get("periodId");
            Boolean copyAllStruct = (Boolean)returnData.get(InvCopyModuleEnum.COPY_ALL_STRUCT.type());
            copyAllStruct = Objects.isNull(copyAllStruct) ? Boolean.FALSE : copyAllStruct;
            Table<String, String, DynamicObject> srcMergeStrSetting = InvestServiceHelper.queryMergeStructInfoSetting(modelId, fromSceneId, fromYearId, fromPeriodId, copyMerge.values());
            Set<Long> srcEffectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(new FilterOrgStructParam(modelId, fromSceneId, fromYearId, fromPeriodId, false, false), new ArrayList<Long>(allChildren)).keySet();
            Set<Long> tarEffectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(new FilterOrgStructParam(modelId, tarScenario, tarYear, tarPeriod, false, false), new ArrayList<Long>(allChildren)).keySet();
            ArrayList<DynamicObject> resultDyList = new ArrayList<DynamicObject>(allChildren.size());
            HashMap<Long, List> orgpnumberMap = new HashMap<Long, List>(16);
            for (Long child : allChildren) {
                boolean isMergeInfoStruct;
                IDNumberTreeNode childNode = MemberReader.findEntityMemberById((Long)modelId, (Long)child);
                IDNumberTreeNode parent = childNode.getParent();
                Long parentId = parent.getId();
                if (!tarEffectiveMerge.contains(parentId) || periodNotOpenMerge.contains(parentId) || noPermMerge.contains(parentId) || submitStatus.contains(parentId)) continue;
                DynamicObject newMergeStructDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergestructinfo");
                newMergeStructDy.set("model", (Object)modelId);
                newMergeStructDy.set("scenario", (Object)tarScenario);
                newMergeStructDy.set("year", (Object)tarYear);
                newMergeStructDy.set("period", (Object)tarPeriod);
                newMergeStructDy.set("orgpnumber", (Object)parent.getNumber());
                newMergeStructDy.set("orgnumber", (Object)childNode.getNumber());
                DynamicObject oldMergeStructDy = (DynamicObject)srcMergeStrSetting.get((Object)parent.getNumber(), (Object)childNode.getNumber());
                boolean bl = isMergeInfoStruct = ConfigServiceHelper.getBoolParam(modelId, "isMergeInfoStruct") ? copyAllStruct : false;
                if (oldMergeStructDy == null) {
                    if (!isMergeInfoStruct) continue;
                    if (srcEffectiveOrg.contains(child)) {
                        newMergeStructDy.set("ismerge", (Object)true);
                    } else {
                        if (!tarEffectiveOrg.contains(child)) continue;
                        newMergeStructDy.set("ismerge", (Object)false);
                    }
                } else {
                    if (!isMergeInfoStruct && !tarEffectiveOrg.contains(child)) continue;
                    newMergeStructDy.set("ismerge", oldMergeStructDy.get("ismerge"));
                    newMergeStructDy.set("mergemethod", oldMergeStructDy.get("mergemethod"));
                    newMergeStructDy.set("userdefined1", oldMergeStructDy.get("userdefined1"));
                    newMergeStructDy.set("userdefined2", oldMergeStructDy.get("userdefined2"));
                    newMergeStructDy.set("userdefined3", oldMergeStructDy.get("userdefined3"));
                }
                resultDyList.add(newMergeStructDy);
                orgpnumberMap.computeIfAbsent(parentId, e -> new ArrayList(16)).add(newMergeStructDy);
            }
            HashSet parentIdsTotal = new HashSet(16);
            orgpnumberMap.entrySet().stream().forEach(entry -> {
                boolean changed = InvestServiceHelper.checkMergeStructChanged(modelId, tarScenario, tarYear, tarPeriod, (Long)entry.getKey(), (List)entry.getValue());
                if (changed) {
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)entry.getKey()));
                    DynamicObjectCollection orgParents = MergeControlHelper.getOrgParents(modelId, orgNode.getLongNumber(), false);
                    Set parentIds = orgParents.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    parentIds.add(entry.getKey());
                    parentIdsTotal.addAll(parentIds);
                }
            });
            PlatUtil.executeWithTX(tx -> {
                QFBuilder baseQf = new QFBuilder("model", "=", (Object)modelId);
                baseQf.add("scenario", "=", (Object)tarScenario);
                baseQf.add("year", "=", (Object)tarYear);
                baseQf.add("period", "=", (Object)tarPeriod);
                baseQf.add("orgpnumber", "in", copyMerge.values());
                DeleteServiceHelper.delete((String)"bcm_mergestructinfo", (QFilter[])baseQf.toArray());
                if (!resultDyList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])resultDyList.toArray(new DynamicObject[0]));
                    InvestServiceHelper.clearMergeStructInfoSettingCache(modelId, tarScenario, tarYear, tarPeriod);
                }
                if (CollectionUtils.isNotEmpty((Collection)parentIdsTotal)) {
                    MergeStatusHelper.batchUpdateCalcStatus(modelId, tarScenario, tarYear, tarPeriod, parentIdsTotal);
                }
            });
        }
        catch (Exception e2) {
            String msg = String.format(ResManager.loadKDString((String)"\u80a1\u6743\u590d\u5236\u5408\u5e76\u67b6\u6784\u4fe1\u606f\u5f02\u5e38\uff1a%s", (String)"InvestServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), ThrowableHelper.printError((Throwable)e2));
            log.error(msg);
            throw new KDBizException(msg);
        }
    }

    private static Map<Long, String> collectMergeNode(DynamicObject selectedNode, Long modelId, String copyWay, Consumer<IDNumberTreeNode> rootNodeConsumer) {
        Map<Object, Object> mergeNodeId2Number;
        IDNumberTreeNode mergeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)selectedNode.getLong("id"));
        if (InvCopyWayEnum.ENTITY_AND_SUB.type().equals(copyWay)) {
            mergeNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"Entity");
            mergeNodeId2Number = mergeNode.getAllChildren(1).stream().collect(Collectors.toMap(IDNumberTreeNode::getId, IDNumberTreeNode::getNumber));
            mergeNodeId2Number.put(mergeNode.getId(), mergeNode.getNumber());
            rootNodeConsumer.accept(mergeNode);
        } else if (InvCopyWayEnum.NODE_AND_SUB.type().equals(copyWay)) {
            mergeNodeId2Number = mergeNode.getAllChildren(1).stream().collect(Collectors.toMap(IDNumberTreeNode::getId, IDNumberTreeNode::getNumber));
            mergeNodeId2Number.put(mergeNode.getId(), mergeNode.getNumber());
            rootNodeConsumer.accept(mergeNode);
        } else {
            mergeNodeId2Number = new HashMap<Long, String>(2);
            mergeNodeId2Number.put(mergeNode.getId(), mergeNode.getNumber());
            rootNodeConsumer.accept(mergeNode);
        }
        return mergeNodeId2Number;
    }

    private static void copyMergerModule(Map<String, Object> paramMap) {
        try {
            Map returnData = (Map)paramMap.get("returnData");
            Long fromSceneId = (Long)returnData.get("sceneId");
            Long fromYearId = (Long)returnData.get("yearId");
            Long fromPeriodId = (Long)returnData.get("periodId");
            Map copyMerge = (Map)paramMap.get("copyMerge");
            Long modelId = (Long)paramMap.get("modelId");
            Long tarScenario = (Long)paramMap.get("tarScenario");
            Long tarYear = (Long)paramMap.get("tarYear");
            Long tarPeriod = (Long)paramMap.get("tarPeriod");
            String module = (String)paramMap.get("module");
            QFBuilder baseqf = new QFBuilder("model", "=", (Object)modelId);
            baseqf.add("scenario", "=", (Object)fromSceneId);
            baseqf.add("year", "=", (Object)fromYearId);
            baseqf.add("period", "=", (Object)fromPeriodId);
            QFBuilder moduleQf = new QFBuilder();
            QFBuilder moduleDelQf = new QFBuilder();
            ArrayList<DynamicObject> moduleList = new ArrayList<DynamicObject>(10);
            Date now = new Date();
            long userId = RequestContext.get().getCurrUserId();
            InvestServiceHelper.setInvModuleQFilter(moduleQf, moduleDelQf, module, copyMerge, modelId);
            Collection moduleData = BusinessDataServiceHelper.loadFromCache((String)InvCopyModuleEnum.getModuleEnumBy((String)module).entityName(), (QFilter[])moduleQf.and(baseqf).toArray()).values();
            moduleData.forEach(s -> {
                DynamicObject target = (DynamicObject)OrmUtils.clone((IDataEntityBase)s, (boolean)false, (boolean)true);
                target.set("scenario_id", (Object)tarScenario);
                target.set("year_id", (Object)tarYear);
                target.set("period_id", (Object)tarPeriod);
                if (module.equals(InvCopyModuleEnum.DYNAMICTYPE_REF.type())) {
                    target.set("modifierid", (Object)userId);
                } else {
                    target.set("modifier", (Object)userId);
                }
                target.set("modifytime", (Object)now);
                moduleList.add(target);
            });
            QFBuilder qfDelete = new QFBuilder("model", "=", (Object)modelId);
            qfDelete.add("scenario", "=", (Object)tarScenario);
            qfDelete.add("year", "=", (Object)tarYear);
            qfDelete.add("period", "=", (Object)tarPeriod);
            if (module.equals(InvCopyModuleEnum.MERGE_NODE.type())) {
                Collection currData = BusinessDataServiceHelper.loadFromCache((String)InvCopyModuleEnum.getModuleEnumBy((String)module).entityName(), (QFilter[])moduleDelQf.and(qfDelete).toArray()).values();
                List<DynamicObject> diffList = currData.stream().filter(c -> !moduleList.stream().map(m -> m.get("org.number")).collect(Collectors.toList()).contains(c.get("org.number"))).collect(Collectors.toList());
                diffList.forEach(diff -> diff.set("mergedatasource", (Object)"1"));
                moduleList.addAll(diffList);
                InvestServiceHelper.mergeNodeUpdate(moduleList, copyMerge, modelId, tarScenario, tarYear, tarPeriod);
            } else if (!moduleList.isEmpty()) {
                moduleList.forEach(investref -> {
                    investref.set("sharecase", (Object)0L);
                    DynamicObjectCollection colls = investref.getDynamicObjectCollection("effecttemp");
                    Iterator iterator = colls.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject coll = (DynamicObject)iterator.next();
                        DynamicObject tempid = coll.getDynamicObject("temp");
                        if (!Objects.isNull(tempid)) continue;
                        iterator.remove();
                    }
                });
                DeleteServiceHelper.delete((String)InvCopyModuleEnum.getModuleEnumBy((String)module).entityName(), (QFilter[])moduleDelQf.and(qfDelete).toArray());
                SaveServiceHelper.save((DynamicObject[])moduleList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u80a1\u6743\u590d\u5236\u5408\u5e76\u8282\u70b9\u6216\u80a1\u6bd4\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38\uff1a%s", (String)"InvestServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]), ThrowableHelper.printError((Throwable)e));
            log.error(msg);
            throw new KDBizException(msg);
        }
    }

    private static void setInvModuleQFilter(QFBuilder moduleQf, QFBuilder moduleDelQf, String module, Map<Long, String> numbers, Long mode) {
        Set<Long> storageIds = InvestServiceHelper.selectStorageIds(numbers.values(), mode);
        HashSet allIds = Sets.newHashSet(numbers.keySet());
        allIds.addAll(storageIds);
        if (module.equals(InvCopyModuleEnum.MERGE_NODE.type())) {
            moduleQf.add("org", "in", storageIds);
            moduleDelQf.add("org", "in", (Object)allIds);
        } else if (module.equals(InvCopyModuleEnum.MERGE_STRUCT.type())) {
            moduleQf.add("orgpnumber", "in", numbers.values());
            moduleDelQf.add("orgpnumber", "in", numbers.values());
        } else if (module.equals(InvCopyModuleEnum.INVEST_REF.type())) {
            moduleQf.add("orgunit", "in", storageIds);
            moduleDelQf.add("orgunit", "in", (Object)allIds);
        } else if (module.equals(InvCopyModuleEnum.DYNAMICTYPE_REF.type())) {
            moduleQf.add("merge", "in", storageIds);
            moduleDelQf.add("merge", "in", (Object)allIds);
            moduleQf.add("level", "=", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode());
            moduleDelQf.add("level", "in", Arrays.asList(InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode(), InvDynamicStockRatioConstant.LevelEnum.detail.getCode()));
        }
    }

    public static Set<Long> selectStorageIds(Collection<String> numbers, Long mode) {
        HashSet<Long> ids = new HashSet<Long>(numbers.size());
        QFBuilder qf = new QFBuilder("model", "=", (Object)mode);
        qf.add("number", "in", numbers);
        qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        DynamicObjectCollection storageIds = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])qf.toArray());
        storageIds.forEach(row -> ids.add(row.getLong("id")));
        return ids;
    }

    public static Table<String, String, DynamicObject> queryMergeStructInfoSetting(Long modelId, Long sceneId, Long fyId, Long periodId, Collection<String> pNumberSet) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("scenario", "=", (Object)sceneId);
        qfBuilder.add("year", "=", (Object)fyId);
        qfBuilder.add("period", "=", (Object)periodId);
        if (pNumberSet != null) {
            qfBuilder.add("orgpnumber", "in", pNumberSet);
        }
        DynamicObjectCollection mergeStructDys = QueryServiceHelper.query((String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge,mergemethod,userdefined1,userdefined2,userdefined3", (QFilter[])qfBuilder.toArray());
        HashBasedTable tmpSetting = HashBasedTable.create();
        for (DynamicObject mergeStruct : mergeStructDys) {
            tmpSetting.put((Object)mergeStruct.getString("orgpnumber"), (Object)mergeStruct.getString("orgnumber"), (Object)mergeStruct);
        }
        return tmpSetting;
    }

    public static Table<String, String, Boolean> getMergeStructInfoSetting(Long modelId, Long sceneId, Long fyId, Long periodId) {
        String packKey = InvestServiceHelper.packMergeCacheKey("MergeStructInfoSetting", modelId, sceneId, fyId, periodId);
        return (Table)InvestServiceHelper.get(packKey, () -> {
            HashBasedTable tmpSetting = HashBasedTable.create();
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("scenario", "=", (Object)sceneId);
            qfBuilder.add("year", "=", (Object)fyId);
            qfBuilder.add("period", "=", (Object)periodId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)packKey, (String)"bcm_mergestructinfo", (String)"orgnumber,orgpnumber,ismerge", (QFilter[])qfBuilder.toArray(), null);){
                ds.forEachRemaining(arg_0 -> InvestServiceHelper.lambda$null$41((Table)tmpSetting, arg_0));
            }
            return tmpSetting;
        });
    }

    public static void clearMergeStructInfoSettingCache(Long modelId, Long sceneId, Long fyId, Long periodId) {
        InvestServiceHelper.clearCache(InvestServiceHelper.packMergeCacheKey("MergeStructInfoSetting", modelId, sceneId, fyId, periodId));
    }

    public static Map<String, String> getInvChangetypeSetting(Long modelId) {
        Map<String, ChangeTypeModel> invChatyModels = InvestServiceHelper.getInvChangetypeModel(modelId);
        return InvestServiceHelper.getInvChangetypeModel(modelId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> ((ChangeTypeModel)invChatyModels.getOrDefault(((ChangeTypeModel)p.getValue()).relatedChangeType(), (ChangeTypeModel)p.getValue())).change()));
    }

    public static Map<String, ChangeTypeModel> getInvChangetypeModel(Long modelId) {
        String packKey = InvestServiceHelper.packMergeCacheKey("InvCngtypeSet_V3.0", modelId, null, null, null);
        return (Map)InvestServiceHelper.get(packKey, () -> {
            Map<String, DynamicObject> invChangetypeDyMap = InvestServiceHelper.queryInvChangetypeDy(modelId);
            LinkedHashMap invChangetypeSettingMap = new LinkedHashMap(invChangetypeDyMap.size());
            ChangeTypeModel addNewModel = new ChangeTypeModel(invChangetypeDyMap.get(OrgBizChangeTypeEnum.initNewlyAdded.getCode()));
            Comparator<ChangeTypeModel> dseqComparator = Comparator.comparingInt(p -> p.seq() == 0 ? addNewModel.seq() : p.seq());
            Comparator<ChangeTypeModel> defaultComparator = Comparator.comparingInt(p -> p.isdefault() ? 0 : 1);
            AtomicInteger seqAto = new AtomicInteger(0);
            invChangetypeDyMap.values().stream().map(ChangeTypeModel::new).sorted(dseqComparator.thenComparing(defaultComparator)).collect(Collectors.toList()).forEach(p -> {
                p.setSeq(seqAto.incrementAndGet());
                invChangetypeSettingMap.put(p.number(), p);
            });
            return invChangetypeSettingMap;
        });
    }

    public static Map<String, DynamicObject> queryInvChangetypeDy(Long modelId) {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("model", "=", (Object)modelId);
        DynamicObject[] invChangeTypes = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"relatedchangetype.number,id,name,number,isdefault,change,dseq", (QFilter[])filter.toArray(), (String)"model desc");
        HashMap<String, DynamicObject> invChangetypeSettingMap = new HashMap<String, DynamicObject>(invChangeTypes.length);
        for (DynamicObject invChangeType : invChangeTypes) {
            invChangetypeSettingMap.computeIfAbsent(invChangeType.getString("number"), a -> invChangeType);
        }
        return invChangetypeSettingMap;
    }

    public static void clearInvChangetypeSettingCache(Long modelId) {
        InvestServiceHelper.clearCache(InvestServiceHelper.packMergeCacheKey("InvCngtypeSet", modelId, null, null, null));
    }

    public static boolean checkOrgAccessFromPath(Long modelId, Long sceneId, Long fyId, Long periodId, long pId, long id) {
        Table<String, String, Boolean> mergeStructInfo = InvestServiceHelper.getMergeStructInfoSetting(modelId, sceneId, fyId, periodId);
        Boolean isEffective = null;
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
        IDNumberTreeNode pNode = MemberReader.findEntityMemberById((Long)modelId, (Long)pId);
        String[] orgPath = orgNode.getLongNumber().split("!");
        for (int i = orgPath.length - 1; i > 0 && !pNode.getNumber().equals(orgPath[i]) && ((isEffective = (Boolean)mergeStructInfo.get((Object)orgPath[i - 1], (Object)orgPath[i])) == null || isEffective.booleanValue()); --i) {
        }
        return isEffective == null || isEffective != false;
    }

    public static DynamicObjectCollection queryEffDynamicShareRela(Long sceneId, Long fyId, Long periodId, Long mergeId) {
        QFBuilder qb = new QFBuilder("status", "=", (Object)"0");
        qb.add("level", "=", (Object)2);
        return InvestServiceHelper.queryDynamicShareRela(sceneId, fyId, periodId, mergeId, qb);
    }

    public static DynamicObjectCollection queryDynamicShareRelaDeleteList(Long sceneId, Long fyId, Long periodId, Long mergeId) {
        QFBuilder qb = new QFBuilder("status", "=", (Object)"1");
        qb.add("level", "=", (Object)2);
        return InvestServiceHelper.queryDynamicShareRela(sceneId, fyId, periodId, mergeId, qb);
    }

    public static DynamicObjectCollection queryDynamicShareRela(Long sceneId, Long fyId, Long periodId, Long mergeId, QFBuilder otherQFilter) {
        QFBuilder qb = new QFBuilder("scenario", "=", (Object)sceneId);
        qb.add("scenario", "=", (Object)sceneId);
        qb.add("year", "=", (Object)fyId);
        qb.add("period", "=", (Object)periodId);
        if (mergeId == null) {
            qb.add("merge", "=", (Object)mergeId);
        }
        if (otherQFilter != null) {
            qb.add(otherQFilter.toList());
        }
        return QueryServiceHelper.query((String)"bcm_dynamicstockratio", (String)"shareholder,investeecompany,invchangetype,openscale,changescale,sharescale,confirmopenscale,confirmchangescale,confirmsharescale,investdate,investammount,sharecase,modifytime,modifierid", (QFilter[])qb.toArray(), (String)"level,seqnum");
    }

    public static <T> T get(String packKey, CacheLoader<T> loader) {
        return (T)ThreadCache.get((Object)packKey, () -> {
            String cacheStr = (String)AppCacheServiceHelper.get(packKey);
            if (cacheStr == null) {
                Object t = loader.load();
                if (t != null) {
                    AppCacheServiceHelper.put(packKey, SerializationUtils.serializeToBase64((Object)t));
                }
                return t;
            }
            try {
                return SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
            catch (Throwable t1) {
                AppCacheServiceHelper.remove(packKey);
                return loader.load();
            }
        });
    }

    private static void clearCache(String cacheKey) {
        ThreadCache.remove((Object)cacheKey);
        AppCacheServiceHelper.remove(cacheKey);
    }

    public static String packMergeCacheKey(String sign, Long modelId, Long sceneId, Long fyId, Long periodId) {
        StringJoiner sb = new StringJoiner("_");
        sb.add(sign);
        sb.add(modelId.toString());
        if (sceneId != null) {
            sb.add(sceneId.toString());
        }
        if (fyId != null) {
            sb.add(fyId.toString());
        }
        if (periodId != null) {
            sb.add(periodId.toString());
        }
        return sb.toString();
    }

    public static DynamicObjectCollection queryDynamicShareRelation(long modelId, ReportTypeEnum reportType, Long mergeId, long sceneId, long yearId, long periodId) {
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("scenario", "=", (Object)sceneId);
        qb.add("status", "=", (Object)"0");
        qb.add("level", "in", (Object)Sets.newHashSet((Object[])new Integer[]{2, 3}));
        IDNumberTreeNode mergeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)mergeId);
        if (mergeNode.isShare()) {
            mergeId = mergeNode.getCopyfromId();
        }
        qb.add("merge", "=", (Object)mergeId);
        Set<IDNumberTreeNode> periods = InvestServiceHelper.getEffectivePeriod(modelId, sceneId);
        Set<String> enablePeriods = periods.stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        if (ReportTypeEnum.ALL == reportType) {
            Set<IDNumberTreeNode> periodNodes = InvestServiceHelper.getEffectLeafPeriod(modelId, enablePeriods, periodId);
            List<IDNumberTreeNode> maxPeriodList = InvestServiceHelper.getMaxPeriod(yearNum, periodNodes);
            if (CollectionUtils.isEmpty(maxPeriodList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8d22\u5e74[%1$s]\u6709\u6548\u7684\u6700\u5927\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u60c5\u666f\u7684\u9002\u7528\u671f\u95f4\u914d\u7f6e\u3002", (String)"InvestServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            Map<Long, Set<Long>> queryYearPeriodIds = InvestServiceHelper.getQueryYearPeriodIds(modelId, yearNum, enablePeriods, maxPeriodList, false);
            QFilter qf = null;
            for (Map.Entry<Long, Set<Long>> kv : queryYearPeriodIds.entrySet()) {
                QFilter temp = new QFilter("year", "=", (Object)kv.getKey()).and("period", "in", kv.getValue());
                if (qf == null) {
                    qf = temp;
                    continue;
                }
                qf = qf.or(temp);
            }
            qb.add(qf);
        } else if (ReportTypeEnum.YEAR == reportType) {
            Set<IDNumberTreeNode> periodNodes = InvestServiceHelper.getEffectLeafPeriod(modelId, enablePeriods, periodId);
            List<IDNumberTreeNode> maxPeriodList = InvestServiceHelper.getMaxPeriod(yearNum, periodNodes);
            if (CollectionUtils.isEmpty(maxPeriodList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8d22\u5e74[%1$s]\u6709\u6548\u7684\u6700\u5927\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u60c5\u666f\u7684\u9002\u7528\u671f\u95f4\u914d\u7f6e\u3002", (String)"InvestServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            Map<Long, Set<Long>> queryYearPeriodIds = InvestServiceHelper.getQueryYearPeriodIds(modelId, yearNum, enablePeriods, maxPeriodList, true);
            QFilter currentQfilter = new QFilter("year", "=", (Object)yearId).and("period", "in", queryYearPeriodIds.get(yearId));
            qb.add(currentQfilter);
        } else if (ReportTypeEnum.MONTH == reportType) {
            qb.add(new QFilter("year", "=", (Object)yearId));
            qb.add(new QFilter("period", "in", InvestServiceHelper.getEffectLeafPeriod(modelId, enablePeriods, periodId).stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet())));
        }
        return QueryServiceHelper.query((String)"bcm_dynamicstockratio", (String)"id,seqnum,level,scenario,year,year.number,year.name,period,period.number,period.name,period.expmonth,period.expday,shareholder.id,shareholder.number as shareholdernumber,shareholder.name as shareholdername,investeecompany.id,investeecompany.number as investeecompanynumber,investeecompany.name as investeecompanyname,invchangetype.id,invchangetype.name as invchangetypename,openscale,changescale,sharescale,confirmopenscale,confirmchangescale,confirmsharescale,investdate,modifytime,modifierid.name as modifier", (QFilter[])qb.toArray());
    }

    private static Map<Long, Set<Long>> getQueryYearPeriodIds(long modelId, String yearNum, Set<String> enablePeriods, List<IDNumberTreeNode> maxPeriodNodes, boolean isGetCurrentYearPeriod) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        IDNumberTreeNode periodNode = maxPeriodNodes.get(0);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum);
        if (isGetCurrentYearPeriod) {
            String[] lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)yearNum, (String)periodNode.getNumber(), (boolean)true);
            while (yearNum.equals(lastPeriodIncludeYear[0])) {
                IDNumberTreeNode node = MemberReader.findPeriodMemberByNum((String)modelNum, (String)lastPeriodIncludeYear[1]);
                if (enablePeriods.contains(node.getNumber())) {
                    result.computeIfAbsent(yearNode.getId(), k -> new HashSet(16)).add(node.getId());
                }
                lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)yearNum, (String)lastPeriodIncludeYear[1], (boolean)true);
            }
        } else {
            String[] lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)yearNum, (String)periodNode.getNumber(), (boolean)true);
            while (lastPeriodIncludeYear[0] != null && lastPeriodIncludeYear[1] != null) {
                IDNumberTreeNode perNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)lastPeriodIncludeYear[1]);
                if (enablePeriods.contains(perNode.getNumber())) {
                    IDNumberTreeNode tempYearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)lastPeriodIncludeYear[0]);
                    result.computeIfAbsent(tempYearNode.getId(), k -> new HashSet(16)).add(perNode.getId());
                }
                lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)lastPeriodIncludeYear[0], (String)lastPeriodIncludeYear[1], (boolean)true);
            }
        }
        result.computeIfAbsent(yearNode.getId(), k -> new HashSet(16)).addAll(maxPeriodNodes.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        return result;
    }

    private static List<IDNumberTreeNode> getMaxPeriod(String yearNum, Set<IDNumberTreeNode> periodNodes) {
        if (CollectionUtils.isEmpty(periodNodes)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvestServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String yearStr = "";
        yearStr = yearNum.startsWith(DimTypesEnum.YEAR.getShortNumber()) ? yearNum.substring(2) : DateUtils.getCurrentData().get(1) + "";
        int year = Integer.parseInt(yearStr);
        Iterator<IDNumberTreeNode> it = periodNodes.iterator();
        ArrayList<IDNumberTreeNode> maxNodeList = new ArrayList<IDNumberTreeNode>(16);
        IDNumberTreeNode maxNode = it.next();
        maxNodeList.add(maxNode);
        Date maxDate = PeriodUtils.getDate((int)year, (int)(Integer.parseInt(maxNode.getProperty("expmonth").toString()) - 1), (int)Integer.parseInt(maxNode.getProperty("expday").toString()));
        while (it.hasNext()) {
            IDNumberTreeNode tempNode = it.next();
            Date tempDate = PeriodUtils.getDate((int)year, (int)(Integer.parseInt(tempNode.getProperty("expmonth").toString()) - 1), (int)Integer.parseInt(tempNode.getProperty("expday").toString()));
            int compareValue = maxDate.compareTo(tempDate);
            if (compareValue == 0) {
                maxNodeList.add(tempNode);
                continue;
            }
            if (compareValue >= 0) continue;
            maxDate = tempDate;
            maxNodeList.clear();
            maxNodeList.add(tempNode);
        }
        return maxNodeList;
    }

    private static Set<IDNumberTreeNode> getEffectLeafPeriod(long modelId, Set<String> enablePeriods, long periodId) {
        HashSet<IDNumberTreeNode> result = new HashSet<IDNumberTreeNode>(16);
        IDNumberTreeNode node = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        InvestServiceHelper.getLeafNode(result, enablePeriods, node);
        return result;
    }

    private static void getLeafNode(Set<IDNumberTreeNode> result, Set<String> enablePeriods, IDNumberTreeNode node) {
        if (node.isLeaf()) {
            if (enablePeriods.contains(node.getNumber())) {
                result.add(node);
            }
        } else {
            for (IDNumberTreeNode child : node.getChildren()) {
                InvestServiceHelper.getLeafNode(result, enablePeriods, child);
            }
        }
    }

    private static Set<IDNumberTreeNode> getEffectivePeriod(long modelId, long sceneId) {
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod(modelId, sceneId);
        if (coll == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0e\u60c5\u666f\u5bf9\u4e0d\u4e0a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvestServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Long[] periodIds = DynamicObjectCollectionUtil.getFieldPKArray(coll, "fbasedataid");
        HashSet<IDNumberTreeNode> result = new HashSet<IDNumberTreeNode>(16);
        for (Long periodId : periodIds) {
            result.add(MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId));
        }
        return result;
    }

    public static List<Long> queryInvSheetPaperResult(Long model, Long scene, Long year, Long period, Set<String> orgNumSet, Set<Long> tempPkSet) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        QFilter qb = new QFilter("adjust.process", "in", Arrays.asList("ADJ", "CADJ", "EJE", "EICA", "EIT", "EOE", "ECF", "EOther", "CCADJ")).and("adjust.entity.number", "in", orgNumSet).and(new QFilter("adjust.sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.SHEETINV.getValue() + "")).or("entrysource", "=", (Object)(EntrySourceEnum.INVSHEETCREATE.getValue() + "")));
        if (tempPkSet != null) {
            qb.and("adjust.extend", "in", tempPkSet);
        }
        AdjustmentServiceHelper.collectAdjust(model, scene, year, period, null, qb).values().forEach(idSet -> idSet.forEach(id -> result.add((Long)id)));
        return result;
    }

    public static void excRule(BizRuleExecParam param, DynamicObject[] records, List<BizRuleExecParam> excuteParams) {
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(param.getModelNum(), excuteParams, ApplicationTypeEnum.CM);
        for (DynamicObject record : records) {
            String reason;
            long bizRuleId = record.getLong("bizrule");
            List infolist = (List)ThreadCache.get((Object)String.valueOf(bizRuleId));
            String executeInfoMsg = "";
            if (CollectionUtils.isNotEmpty((Collection)infolist)) {
                executeInfoMsg = infolist.stream().filter(log -> log.getLevel() == BizRuleDebugLogInfoEnum.LOG).map(BizRuleDebugLogInfo::getInfo).collect(Collectors.joining(","));
            }
            if (StringUtils.isNotEmpty((String)(reason = result.get(bizRuleId)))) {
                record.set("execstatus", (Object)BRExecStatusEnum.FAILED.getIndex());
                record.set("reason", (Object)(reason + System.lineSeparator() + executeInfoMsg));
            } else {
                record.set("execstatus", (Object)BRExecStatusEnum.SUCCESS.getIndex());
                record.set("reason", (Object)executeInfoMsg);
            }
            if (ThreadCache.get((Object)(bizRuleId + "startTime")) != null) {
                record.set("starttime", ThreadCache.get((Object)(bizRuleId + "startTime")));
            }
            if (ThreadCache.get((Object)(bizRuleId + "endTime")) != null) {
                record.set("endtime", ThreadCache.get((Object)(bizRuleId + "endTime")));
                continue;
            }
            record.set("endtime", (Object)System.currentTimeMillis());
        }
        SaveServiceHelper.update((DynamicObject[])records);
    }

    public static boolean checkMergeStructChanged(long modelId, long scenarioId, long fyId, long periodId, Long orgId, List<DynamicObject> list) {
        IDNumberTreeNode selectedNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        Map<String, Set<Long>> stringListMap = InvestServiceHelper.queryEffectiveOrgMapCache(modelId, scenarioId, fyId, periodId, orgId);
        HashSet subNodeSet = new HashSet(16);
        stringListMap.forEach((key, value) -> {
            IDNumberTreeNode entityMember;
            if (!value.isEmpty() && Objects.nonNull((entityMember = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)value.iterator().next()))).getParent()) && entityMember.getParent().getNumber().equals(selectedNode.getNumber())) {
                subNodeSet.add(entityMember.getNumber());
            }
        });
        if (CollectionUtils.isEmpty(list) && CollectionUtils.isNotEmpty(subNodeSet) || CollectionUtils.isEmpty(subNodeSet) && CollectionUtils.isNotEmpty(list)) {
            return true;
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        boolean flag = false;
        for (DynamicObject mergeStruct : list) {
            numberSet.add(mergeStruct.getString("orgnumber"));
            if (subNodeSet.contains(mergeStruct.getString("orgnumber"))) {
                if (mergeStruct.getBoolean("ismerge")) continue;
                flag = true;
                break;
            }
            if (!mergeStruct.getBoolean("ismerge")) continue;
            flag = true;
            break;
        }
        subNodeSet.removeAll(numberSet);
        if (CollectionUtils.isNotEmpty(subNodeSet)) {
            return true;
        }
        return flag;
    }

    private static /* synthetic */ void lambda$null$41(Table tmpSetting, Row p) {
        tmpSetting.put((Object)p.getString("orgpnumber"), (Object)p.getString("orgnumber"), (Object)p.getBoolean("ismerge"));
    }

    private static /* synthetic */ void lambda$periodCopy$15(Map returnData, DynamicObject selectedNode, Long mode, Long scenario, Long year, Long period, Table messageColl, List exMsg, String module) {
        InvCopyModuleEnum moduleEnum = InvCopyModuleEnum.getModuleEnumBy((String)module);
        try {
            Boolean moduleFlag = (Boolean)returnData.get(module);
            Map<String, Set<Object>> result = new HashMap<String, Set>(16);
            if (InvCopyModuleEnum.MERGE_STRUCT == moduleEnum) {
                Boolean copyAllStructflag = (Boolean)returnData.get(InvCopyModuleEnum.COPY_ALL_STRUCT.type());
                if (moduleFlag.booleanValue() || copyAllStructflag.booleanValue()) {
                    result = InvestServiceHelper.copyMergeInfo(returnData, selectedNode, module, mode, scenario, year, period, map -> InvestServiceHelper.copyMergerStruct(map));
                    String packKey = InvestServiceHelper.packMergeCacheKey("MergeStructInfoSetting", mode, scenario, year, period);
                    ThreadCache.remove((Object)packKey);
                    InvestServiceHelper.clearMergeStructInfoSettingCache(mode, scenario, year, period);
                }
            } else if (Boolean.TRUE.equals(moduleFlag)) {
                result = InvestServiceHelper.copyMergeInfo(returnData, selectedNode, module, mode, scenario, year, period, map -> InvestServiceHelper.copyMergerModule(map));
            }
            result.forEach((k, v) -> {
                Collection cfr_ignored_0 = (Collection)messageColl.put(k, (Object)moduleEnum, v);
            });
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u80a1\u6743\u590d\u5236%s\u5f02\u5e38\u3002", (String)"InvestServiceHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), moduleEnum.text());
            exMsg.add(msg);
        }
    }
}

