/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.dto;

import java.io.IOException;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.ToStringHelper;

public class InvMsResult {
    private int code;
    private String message;
    private Object data;

    public static InvMsResult fail(ResultEnum resultEnum) {
        return new InvMsResult(resultEnum);
    }

    public static InvMsResult success() {
        return new InvMsResult(ResultEnum.SUCCESS);
    }

    private InvMsResult(ResultEnum resultEnum) {
        this.code = resultEnum.code;
        this.message = resultEnum.message.loadKDString();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public InvMsResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public InvMsResult setData(Object data) {
        this.data = data;
        return this;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            throw new KDBizException(String.format("convert Objct [%s] to json error!", ToStringHelper.deepToString((Object)this)));
        }
    }

    public static enum ResultEnum {
        SUCCESS(200, new MultiLangEnumBridge("\u6210\u529f\u3002", "InvMsResult_1", "fi-bcm-business")),
        PARAM_ERROR(400, new MultiLangEnumBridge("\u5165\u53c2\u5f02\u5e38\u3002", "InvMsResult_2", "fi-bcm-business")),
        PERMISSION_DENIED(403, new MultiLangEnumBridge("\u6743\u9650\u6821\u9a8c\u5931\u8d25\u3002", "InvMsResult_3", "fi-bcm-business")),
        BUSINESS_REFUSE(422, new MultiLangEnumBridge("\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25\u3002", "InvMsResult_4", "fi-bcm-business")),
        BUSINESS_EXCEPTION(500, new MultiLangEnumBridge("\u670d\u52a1\u53d1\u751f\u5f02\u5e38\u3002", "InvMsResult_5", "fi-bcm-business"));

        int code;
        MultiLangEnumBridge message;

        private ResultEnum(int code, MultiLangEnumBridge message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }
    }
}

