/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.fi.bcm.business.invest.api.dto.MemberCheckEnum;
import kd.fi.bcm.business.invest.api.validator.EnumRange;
import kd.fi.bcm.business.invest.api.validator.IntRange;
import kd.fi.bcm.business.invest.api.validator.MemberExists;
import kd.fi.bcm.business.invest.api.validator.MemberPerm;
import kd.fi.bcm.business.invest.api.validator.NotNull;
import kd.fi.bcm.business.invest.api.validator.OrgIsLeaf;

public class InvRecalculateRatioRelationDTO {
    @NotNull
    private Long modelId;
    @NotNull
    @MemberExists(value=MemberCheckEnum.SCENARIO_EXISTS)
    @MemberPerm(value=MemberCheckEnum.SCENARIO_HAVE_WRITE_PERM)
    private Long scenarioId;
    @NotNull
    @MemberExists(value=MemberCheckEnum.YEAR_EXISTS)
    @MemberPerm(value=MemberCheckEnum.YEAR_HAVE_WRITE_PERM)
    private Long yearId;
    @NotNull
    @MemberExists(value=MemberCheckEnum.PERIOD_EXISTS)
    @MemberPerm(value=MemberCheckEnum.PERIOD_HAVE_WRITE_PERM)
    private Long periodId;
    @NotNull
    @MemberExists(value=MemberCheckEnum.ENTITY_EXISTS)
    @MemberPerm(value=MemberCheckEnum.ENTITY_HAVE_WRITE_PERM)
    @OrgIsLeaf(value=false)
    private Long orgId;
    @IntRange(min=1, max=3)
    private int recalculateOptions;
    @EnumRange(value={1, 2})
    private int calcType;
    @EnumRange(value={3, 4})
    private int calcRange;

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(Long scenarioId) {
        this.scenarioId = scenarioId;
    }

    public Long getYearId() {
        return this.yearId;
    }

    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public int getRecalculateOptions() {
        return this.recalculateOptions;
    }

    @JsonIgnore
    public boolean isCalcStaticStock() {
        return (this.recalculateOptions & 2) == 2;
    }

    @JsonIgnore
    public boolean isCalcDynamicStock() {
        return (this.recalculateOptions & 1) == 1;
    }

    public void setRecalculateOptions(int recalculateOptions) {
        this.recalculateOptions = recalculateOptions;
    }

    public int getCalcType() {
        return this.calcType;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public int getCalcRange() {
        return this.calcRange;
    }

    public void setCalcRange(int calcRange) {
        this.calcRange = calcRange;
    }
}

