/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.dto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ToStringHelper;

public class InvResultDTO {
    public static final String ERRORCODE_SUCCESS = "success";
    public static final String ERRORCODE_FAIL = "fail";
    private boolean success = true;
    private Object data;
    private String message;
    private String errorCode;

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected void init(Map<String, Object> obj) {
        this.setSuccess((Boolean)obj.get(ERRORCODE_SUCCESS));
        this.setMessage((String)obj.get("message"));
        this.setData(obj.get("data"));
        this.setErrorCode((String)obj.get("errorCode"));
    }

    protected Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        ret.put(ERRORCODE_SUCCESS, this.getSuccess());
        ret.put("message", this.getMessage());
        ret.put("data", this.getData());
        ret.put("errorCode", this.getErrorCode());
        return ret;
    }

    public static InvResultDTO fail(String msg) {
        return InvResultDTO.fail(msg, ERRORCODE_FAIL);
    }

    public static InvResultDTO fail(String msg, String errorCode) {
        InvResultDTO result = new InvResultDTO();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setErrorCode(errorCode);
        return result;
    }

    public static InvResultDTO success(Object data) {
        InvResultDTO result = new InvResultDTO();
        result.setSuccess(true);
        result.setData(data);
        result.setErrorCode(ERRORCODE_SUCCESS);
        return result;
    }

    public static InvResultDTO ex(Throwable ex) {
        InvResultDTO result = new InvResultDTO();
        result.setSuccess(false);
        result.setMessage(ex.getMessage());
        if (ex instanceof KDException && !StringUtils.isEmpty((String)((KDException)ex).getErrorCode().getCode())) {
            result.setErrorCode(((KDException)ex).getErrorCode().toString());
        } else {
            result.setErrorCode(ERRORCODE_FAIL);
        }
        return result;
    }

    public static InvResultDTO fromMap(Map<String, Object> ret) {
        InvResultDTO apiret = new InvResultDTO();
        apiret.init(ret);
        return apiret;
    }

    public static Map<String, Object> toMap(InvResultDTO result) {
        return result.toMap();
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            throw new KDBizException(String.format("convert Objct [%s] to json error!", ToStringHelper.deepToString((Object)this)));
        }
    }
}

