/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.dto;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;

public enum MemberCheckEnum {
    ENTITY_EXISTS((modelId, memberId) -> MemberCheckEnum.memberExists(modelId, memberId, "bcm_entitymembertree")),
    SCENARIO_EXISTS((modelId, memberId) -> MemberCheckEnum.memberExists(modelId, memberId, "bcm_scenemembertree")),
    YEAR_EXISTS((modelId, memberId) -> MemberCheckEnum.memberExists(modelId, memberId, "bcm_fymembertree")),
    PERIOD_EXISTS((modelId, memberId) -> MemberCheckEnum.memberExists(modelId, memberId, "bcm_periodmembertree")),
    ENTITY_HAVE_WRITE_PERM((modelId, memberId) -> MemberCheckEnum.memberHaveWritePerm(modelId, memberId, PresetConstant.ENTITY_DIM, "bcm_entitymembertree")),
    SCENARIO_HAVE_WRITE_PERM((modelId, memberId) -> MemberCheckEnum.memberHaveWritePerm(modelId, memberId, PresetConstant.SCENE_DIM, "bcm_scenemembertree")),
    YEAR_HAVE_WRITE_PERM((modelId, memberId) -> MemberCheckEnum.memberHaveWritePerm(modelId, memberId, PresetConstant.FY_DIM, "bcm_fymembertree")),
    PERIOD_HAVE_WRITE_PERM((modelId, memberId) -> MemberCheckEnum.memberHaveWritePerm(modelId, memberId, PresetConstant.PERIOD_DIM, "bcm_periodmembertree"));

    private BiPredicate<Long, Object> predicate;

    private MemberCheckEnum(BiPredicate<Long, Object> predicate) {
        this.predicate = predicate;
    }

    public BiPredicate<Long, Object> getPredicate() {
        return this.predicate;
    }

    private static boolean memberExists(Long modelId, Object orgId, String entityNumber) {
        IDNumberTreeNode entityMember;
        if (Objects.isNull(modelId) || Objects.isNull(orgId)) {
            return true;
        }
        IDNumberTreeNode baseTreeNode = entityMember = MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)LongUtil.toLong((Object)orgId));
        if ("bcm_entitymembertree".equals(entityNumber) && entityMember != IDNumberTreeNode.NotFoundTreeNode) {
            baseTreeNode = entityMember.getBaseTreeNode();
        }
        return entityMember != IDNumberTreeNode.NotFoundTreeNode && baseTreeNode != IDNumberTreeNode.NotFoundTreeNode;
    }

    private static boolean memberHaveWritePerm(Long modelId, Object memberId, String dimNum, String entityNumber) {
        if (Objects.isNull(modelId) || Objects.isNull(memberId) || (Long)memberId == 0L || (Long)memberId < 0L || modelId == 0L || modelId < 0L) {
            return true;
        }
        HashSet memberIds = Sets.newHashSet((Object[])new Long[]{(Long)memberId});
        MemberCheckEnum.retainReadWriteMembers(modelId, dimNum, entityNumber, memberIds);
        return !memberIds.isEmpty();
    }

    private static void retainReadWriteMembers(long modelId, String dimNum, String entity, Set<Long> memberIds) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return;
        }
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        Set<Long> readWritePermissionIds = PermissionServiceImpl.getInstance(modelId).matchWritePermMembers(dimId, entity, memberIds);
        memberIds.removeIf(memberId -> !readWritePermissionIds.contains(memberId));
    }
}

