/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.api.dto.InvCopyRatioRelationDTO;
import kd.fi.bcm.business.invest.api.dto.InvMsResult;
import kd.fi.bcm.business.invest.api.dto.InvRecalculateRatioRelationDTO;
import kd.fi.bcm.business.invest.api.validator.InvMsCheckHelper;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.function.TripleConsumer;
import kd.fi.bcm.business.invest.function.VoidFunction;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.invest.helper.InvStaticStockRatioHelper;
import kd.fi.bcm.business.invest.invratio.InvDynamicStockRadioService;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.invratio.InvStaticRadioService;
import kd.fi.bcm.business.invest.invratio.model.InvRelationRadioDTO;
import kd.fi.bcm.business.invest.invratio.model.InvRelationRadioInfo;
import kd.fi.bcm.business.invest.invstructuretable.InvDynamicStockService;
import kd.fi.bcm.business.invest.relation.InvRelationLogContext;
import kd.fi.bcm.business.invest.relation.InvRelationLogService;
import kd.fi.bcm.business.invest.service.InvValidateHelper;
import kd.fi.bcm.business.invest.shareholder.InvCalculateShareRelaService;
import kd.fi.bcm.business.invest.shareholder.model.InvRelationSearchConfig;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ScenePeriodServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvStaticStockRatioConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class InvRelationSearchHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvRelationSearchHelper.class);

    public static InvMsResult copyFromAnotherPeriod(InvCopyRatioRelationDTO dto) {
        try {
            Long modelId = dto.getModelId();
            Long scenarioId = dto.getScenarioId();
            Long periodId = dto.getPeriodId();
            Long yearId = dto.getYearId();
            Long tarSceneId = dto.getTarScenarioId();
            Long targetPeriodId = dto.getTargetPeriodId();
            Long tarYearId = dto.getTarYearId();
            String menuName = ResManager.loadKDString((String)"\u65e0\u3010\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u3011-\u3010\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\u3011\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u3002", (String)"InvRelationSearchHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]);
            InvMsResult invMsResult = InvMsCheckHelper.checkDto(dto, modelId, "4730fc9f000020ae", menuName, maps -> {
                String msg;
                if (Objects.isNull(maps) || Objects.isNull(modelId) || Objects.isNull(scenarioId) || Objects.isNull(periodId) || Objects.isNull(tarSceneId) || Objects.isNull(targetPeriodId)) {
                    return;
                }
                IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
                String sceneNumber = sceneMember.getNumber();
                List periodIds = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, Collections.singletonList(sceneNumber)).getOrDefault(sceneNumber, Collections.emptyList());
                if (!periodIds.contains(periodId)) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u6e90\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u6e90\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"InvRelationSearchHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), periodId, scenarioId);
                    maps.compute("periodId", (k, v) -> Objects.isNull(v) ? msg2 : new StringJoiner(" ").add((CharSequence)v).add(msg2).toString());
                }
                List targetPeriodIds = periodIds;
                if (!tarSceneId.equals(scenarioId)) {
                    IDNumberTreeNode targetSceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)tarSceneId);
                    String targetSceneNumber = targetSceneMember.getNumber();
                    targetPeriodIds = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, Collections.singletonList(targetSceneNumber)).getOrDefault(targetSceneNumber, Collections.emptyList());
                }
                if (!targetPeriodIds.contains(targetPeriodId)) {
                    msg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u76ee\u6807\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"InvRelationSearchHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), periodId, scenarioId);
                    maps.compute("targetPeriodId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                }
                if (Objects.isNull(yearId) || Objects.isNull(tarYearId)) {
                    return;
                }
                if (scenarioId.equals(tarSceneId) && yearId.equals(tarYearId) && periodId.equals(targetPeriodId)) {
                    msg = ResManager.loadKDString((String)"\u76ee\u6807\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u4e0d\u80fd\u548c\u6e90\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u5b8c\u5168\u76f8\u540c\u3002", (String)"InvRelationSearchHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]);
                    maps.compute("tarScenarioId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                    maps.compute("tarYearId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                    maps.compute("targetPeriodId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                }
            });
            if (Objects.nonNull(invMsResult)) {
                return invMsResult;
            }
            Long orgId = dto.getOrgId();
            IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            IDNumberTreeNode baseTreeNode = entityMember.getBaseTreeNode();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("yearId", yearId);
            returnData.put("periodId", periodId);
            returnData.put("sceneId", scenarioId);
            returnData.put("copyway", String.valueOf(dto.getCopyWay()));
            returnData.put("mergenode", dto.isCopyMergeNode());
            returnData.put("mergestruct", dto.isCopyMergeStruct());
            returnData.put("investref", dto.isCopyStaticStock());
            returnData.put("dynamictype", dto.isCopyDynamicStock());
            returnData.put("copyallstruct", dto.isCopyAllStruct());
            DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((Object)baseTreeNode.getId(), (String)"bcm_entitymembertree");
            InvestServiceHelper.periodCopy(returnData, orgDy, modelId, tarSceneId, tarYearId, targetPeriodId);
            InvRelationLogContext logContext = new InvRelationLogContext(modelId, tarSceneId, tarYearId, targetPeriodId, entityMember.getBaseTreeNode().getId());
            InvRelationLogService invRelationLogService = InvRelationLogService.logWithoutStaticChange(logContext);
            invRelationLogService.logCopy(returnData);
            invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.MS_API_COPY);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_EXCEPTION).setData(e.getMessage());
        }
        return InvMsResult.success();
    }

    public static InvMsResult recalculateRatioRelation(InvRecalculateRatioRelationDTO dto) {
        try {
            Set<Object> orgSet;
            Long modelId = dto.getModelId();
            Long scenarioId = dto.getScenarioId();
            Long periodId = dto.getPeriodId();
            String menuName = ResManager.loadKDString((String)"\u65e0\u3010\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u3011-\u3010\u80a1\u6743\u91cd\u7b97\u3011\u4f53\u7cfb\u529f\u80fd\u6743\u9650\u3002", (String)"InvRelationSearchHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]);
            InvMsResult invMsResult = InvMsCheckHelper.checkDto(dto, modelId, "1GL+56M159N1", menuName, maps -> {
                if (Objects.isNull(maps) || Objects.isNull(modelId) || Objects.isNull(scenarioId) || Objects.isNull(periodId)) {
                    return;
                }
                IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
                String sceneNumber = sceneMember.getNumber();
                List periodIds = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, Collections.singletonList(sceneNumber)).getOrDefault(sceneNumber, Collections.emptyList());
                if (!periodIds.contains(periodId)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"InvRelationSearchHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), periodId, scenarioId);
                    maps.compute("periodId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                }
            });
            if (Objects.nonNull(invMsResult)) {
                return invMsResult;
            }
            Long orgId = dto.getOrgId();
            IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (dto.getCalcRange() == InvDynamicStockService.CalcRangeEnum.includeSub.getCode()) {
                orgSet = entityMember.getAllChildren().stream().filter(node -> !node.isLeaf()).map(IDNumberTreeNode::getId).collect(Collectors.toSet());
                orgSet.add(orgId);
            } else {
                orgSet = Sets.newHashSet((Object[])new Long[]{orgId});
            }
            InvRelationSearchService.dealNoPermOrg((Set<Long>)orgSet, modelId);
            InvRelationSearchService.getEffectiveEntity(orgSet, modelId, scenarioId, dto.getYearId(), periodId);
            InvRelationSearchConfig config = new InvRelationSearchConfig(modelId, scenarioId, dto.getYearId(), periodId, orgId);
            InvCalculateShareRelaService reCalService = new InvCalculateShareRelaService(config, dto.isCalcStaticStock(), dto.isCalcDynamicStock(), dto.getCalcType(), dto.getCalcRange(), orgSet);
            List<String> checkRs = reCalService.doCheck();
            if (!checkRs.isEmpty()) {
                throw new KDBizException(String.join((CharSequence)"\n", checkRs));
            }
            reCalService.doCalculate();
            InvRelationLogContext logContext = new InvRelationLogContext(modelId, scenarioId, dto.getYearId(), periodId, MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getBaseTreeNode().getId());
            InvRelationLogService invRelationLogService = InvRelationLogService.logWithoutStaticChange(logContext);
            invRelationLogService.logReCalculate(dto.isCalcStaticStock(), dto.isCalcDynamicStock(), dto.getCalcType(), dto.getCalcRange(), reCalService.isSupportRuleExc());
            invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.MS_API_CALCULATE);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_EXCEPTION).setData(e.getMessage());
        }
        return InvMsResult.success();
    }

    public static InvMsResult addInvRelation(InvRelationRadioDTO dto) {
        try {
            Long modelId = dto.getModel();
            Long scenarioId = dto.getScenario();
            Long periodId = dto.getPeriod();
            Long yearId = dto.getYear();
            String orgUnit = dto.getOrgUnit();
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode memberById = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgUnit);
            Long baseId = memberById.getId();
            dto.setOrgUnitId(baseId);
            InvMsResult invMsResult = InvMsCheckHelper.checkDto(dto, modelId, "", "", maps -> {
                if (Objects.isNull(maps) || Objects.isNull(modelId) || Objects.isNull(scenarioId) || Objects.isNull(periodId)) {
                    return;
                }
                IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)scenarioId);
                String sceneNumber = sceneMember.getNumber();
                List periodIds = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, Collections.singletonList(sceneNumber)).getOrDefault(sceneNumber, Collections.emptyList());
                if (!periodIds.contains(periodId)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u671f\u95f4%1$s\u4e0d\u5b58\u5728\u4e8e\u201c\u60c5\u666f%2$s\u201d\u7684\u9002\u7528\u671f\u95f4\u3002", (String)"InvRelationSearchHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), periodId, scenarioId);
                    maps.compute("periodId", (k, v) -> Objects.isNull(v) ? msg : new StringJoiner(" ").add((CharSequence)v).add(msg).toString());
                }
            });
            if (Objects.nonNull(invMsResult)) {
                return invMsResult;
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)orgUnit) && !PeriodSettingHelper.checkPeriodStatus(modelId, orgUnit, scenarioId, yearId, periodId, "datastatus")) {
                String msg = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%1$s\u3011\u5728\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"InvRelationSearchHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]);
                return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_EXCEPTION).setData(String.format(msg, orgUnit));
            }
            InvRelationLogContext logContext = new InvRelationLogContext(modelId, scenarioId, yearId, periodId, baseId);
            InvRelationLogService invRelationLogService = InvRelationLogService.logWithStaticChange(logContext);
            InvRelationLogService invRelationDyLogService = InvRelationLogService.logWithoutStaticChange(logContext);
            List<InvRelationRadioInfo> invRelationRadioInfos = dto.getInvRelationRadioInfos();
            Map<String, List<InvRelationRadioInfo>> relationInfosGroup = invRelationRadioInfos.stream().collect(Collectors.groupingBy(e -> e.getCategorized()));
            List<InvRelationRadioInfo> staticInvRelationRadioInfos = relationInfosGroup.get(InvRelationTypeConstant.CatalogEnum.relation.getCode());
            List<InvRelationRadioInfo> dynamicInvRelationRadioInfos = relationInfosGroup.get(InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            Integer accuracy = Integer.parseInt(InvRelationSetHelper.queryAccuracy(modelId));
            staticInvRelationRadioInfos.forEach(info -> {
                String relationType = info.getRelationType();
                info.setInvrelatype(((InvRelaTypeEnum)InvRelationTypeConstant.getCode2InvRelaTypeEnum().get(relationType)).getType());
                BigDecimal confirmscale = info.getConfirmscale();
                confirmscale = confirmscale.setScale((int)accuracy, RoundingMode.HALF_UP);
                info.setConfirmscale(confirmscale);
                info.setOrgunit(orgUnit);
            });
            dynamicInvRelationRadioInfos.forEach(info -> {
                String relationType = info.getRelationType();
                info.setInvchangetype(relationType);
                info.setOrgunit(orgUnit);
                BigDecimal confirmopenscale = info.getConfirmopenscale();
                BigDecimal confirmchangescale = info.getConfirmchangescale();
                BigDecimal confirmsharescale = info.getConfirmsharescale();
                if (Objects.nonNull(confirmopenscale)) {
                    confirmopenscale = confirmopenscale.setScale((int)accuracy, RoundingMode.HALF_UP);
                    info.setConfirmopenscale(confirmopenscale);
                }
                if (Objects.nonNull(confirmchangescale)) {
                    confirmchangescale = confirmchangescale.setScale((int)accuracy, RoundingMode.HALF_UP);
                    info.setConfirmchangescale(confirmchangescale);
                }
                if (Objects.nonNull(confirmsharescale)) {
                    confirmsharescale = confirmsharescale.setScale((int)accuracy, RoundingMode.HALF_UP);
                    info.setConfirmsharescale(confirmsharescale);
                }
            });
            InvRelationSearchHelper.addStaticRelaitons(modelId, scenarioId, periodId, yearId, baseId, invRelationLogService, staticInvRelationRadioInfos);
            InvRelationSearchHelper.addDynamicRelaitons(modelId, scenarioId, periodId, yearId, baseId, invRelationDyLogService, dynamicInvRelationRadioInfos);
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_EXCEPTION).setData(e2.getMessage());
        }
        return InvMsResult.success();
    }

    private static void addDynamicRelaitons(Long modelId, Long scenarioId, Long periodId, Long yearId, Long baseId, InvRelationLogService invRelationLogService, List<InvRelationRadioInfo> dynamicInvRelationRadioInfos) {
        InvDynamicStockRadioService invDynamicStockRadioService = new InvDynamicStockRadioService();
        Map<String, DynamicObject> collect = invDynamicStockRadioService.collectRelation(modelId, yearId, scenarioId, periodId, Collections.singletonList(baseId));
        int seq = invDynamicStockRadioService.getSeq();
        DynamicObjectCollection changeTypes = InvChangeTypeServiceHelper.findChangeType(modelId);
        Map<String, DynamicObject> changeTypeNumber2Id = changeTypes.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e, (v1, v2) -> v1));
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet<DynamicObject> needUpdateData = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> needNewSaveData = new HashSet<DynamicObject>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        Date now = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        InvValidateHelper<JSONObject> jsonValidateHelper = InvDynamicStockRadioService.jsonObjectValidateHelper(modelId);
        InvValidateHelper<DynamicObject> dynamicValidateHelper = InvDynamicStockRadioService.dynObjectValidateHelper(modelId);
        for (InvRelationRadioInfo invRelationRadioInfo : dynamicInvRelationRadioInfos) {
            Runnable runLog;
            Consumer<DynamicObject> renderDataCompute;
            JSONObject data = (JSONObject)JSONObject.toJSON((Object)invRelationRadioInfo);
            String key = InvDynamicStockRadioService.generateKey(data);
            DynamicObject dynamicObject = collect.get(key);
            List<String> validateRs = jsonValidateHelper.doValidate(data);
            if (CollectionUtils.isNotEmpty(validateRs)) {
                String msg = String.join((CharSequence)" ", validateRs);
                throw new KDBizException(msg);
            }
            DynamicObject changeTypeDy = changeTypeNumber2Id.get(data.getString("invchangetype"));
            DynamicObject newDynObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dynamicstockratio");
            if (Objects.nonNull(dynamicObject)) {
                DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynObject);
                newDynObject.set("id", (Object)dynamicObject.getLong("id"));
                renderDataCompute = needUpdateData::add;
                if (InvDynamicStockRatioConstant.StatusEnum.DISABLE.getCode().equals(dynamicObject.getString("status"))) {
                    newDynObject.set("seqnum", (Object)(++seq));
                    runLog = () -> invRelationLogService.logDynamicAddNew(newDynObject, changeTypeDy);
                } else {
                    runLog = () -> invRelationLogService.logDynamicModify(newDynObject, dynamicObject, changeTypeDy);
                }
            } else {
                newDynObject.set("id", (Object)idDistributor.getLongId());
                newDynObject.set("seqnum", (Object)(++seq));
                renderDataCompute = needNewSaveData::add;
                runLog = () -> invRelationLogService.logDynamicAddNew(newDynObject, changeTypeDy);
            }
            newDynObject.set("model", (Object)modelId);
            newDynObject.set("scenario", (Object)scenarioId);
            newDynObject.set("year", (Object)yearId);
            newDynObject.set("period", (Object)periodId);
            newDynObject.set("merge", (Object)baseId);
            newDynObject.set("shareholder", (Object)InvRelationSearchHelper.getMemberId(modelNum, data, DimTypesEnum.INTERCOMPANY.getNumber(), "shareholder"));
            newDynObject.set("investeecompany", (Object)InvRelationSearchHelper.getMemberId(modelNum, data, DimTypesEnum.ENTITY.getNumber(), "investeecompany"));
            Long changTypeId = changeTypeDy == null ? 0L : changeTypeDy.getLong("id");
            newDynObject.set("invchangetype", (Object)changTypeId);
            newDynObject.set("confirmopenscale", (Object)data.getBigDecimal("confirmopenscale"));
            newDynObject.set("confirmsharescale", (Object)data.getBigDecimal("confirmsharescale"));
            newDynObject.set("confirmchangescale", (Object)data.getBigDecimal("confirmchangescale"));
            newDynObject.set("level", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode());
            newDynObject.set("status", (Object)InvDynamicStockRatioConstant.StatusEnum.ENABLE.getCode());
            newDynObject.set("modifierid", (Object)userId);
            newDynObject.set("modifytime", (Object)now);
            newDynObject.set("sharecase", (Object)0L);
            DynamicObjectCollection limTemplate = newDynObject.getDynamicObjectCollection("invelimtemplate");
            limTemplate.clear();
            DynamicObjectCollection effectTemps = newDynObject.getDynamicObjectCollection("effecttemp");
            Pair<Set<String>, Set<String>> warringNumbers = invDynamicStockRadioService.importTemplate(data, effectTemps);
            Pair<Set<String>, Set<String>> warringNewNumbers = invDynamicStockRadioService.importNewTemplate(data, effectTemps);
            List<String> dyCheckRs = dynamicValidateHelper.doValidate(newDynObject);
            InvRelationSearchHelper.addTemplateCheckMsg(warringNumbers, dyCheckRs);
            InvRelationSearchHelper.addNewTemplateCheckMsg(warringNewNumbers, dyCheckRs);
            renderDataCompute.accept(newDynObject);
            runLog.run();
        }
        InvDynamicStockRatioHelper.newAddSave(needNewSaveData);
        InvDynamicStockRatioHelper.updateDynStockRadioInfo(needUpdateData);
        invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.MS_API_ADDRELATION);
    }

    private static void addStaticRelaitons(Long modelId, Long scenarioId, Long periodId, Long yearId, Long baseId, InvRelationLogService invRelationLogService, List<InvRelationRadioInfo> staticInvRelationRadioInfos) {
        InvStaticRadioService invStaticRadioService = new InvStaticRadioService();
        Map<String, DynamicObject> collect = invStaticRadioService.collectRelation(modelId, yearId, scenarioId, periodId, Collections.singletonList(baseId));
        Map<String, Integer> relationType2Seq = invStaticRadioService.getRelationType2Seq();
        Map<String, String> relationTypeNumber2Name = invStaticRadioService.getRelationTypeNumber2Name();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet<DynamicObject> needUpdateData = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> needNewSaveData = new HashSet<DynamicObject>(16);
        GlobalIdDistributer idDistributor = new GlobalIdDistributer();
        Date now = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        InvValidateHelper<JSONObject> jsonValidateHelper = InvStaticRadioService.jsonObjectValidateHelper(modelId);
        InvValidateHelper<DynamicObject> dynamicValidateHelper = InvStaticRadioService.dynObjectValidateHelper(modelId);
        for (InvRelationRadioInfo invRelationRadioInfo : staticInvRelationRadioInfos) {
            Runnable runLog;
            Integer seq;
            Consumer<DynamicObject> renderDataCompute;
            String msg;
            JSONObject data = (JSONObject)JSONObject.toJSON((Object)invRelationRadioInfo);
            String key = InvStaticRadioService.generateKey(data);
            DynamicObject dynamicObject = collect.get(key);
            List<String> validateRs = jsonValidateHelper.doValidate(data);
            if (!relationTypeNumber2Name.containsKey(data.getString("invrelatype"))) {
                msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u80a1\u6bd4\u7c7b\u578b\u3010%1$s\u3011\u3002", (String)"InvRelationSearchHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]);
                validateRs.add(String.format(msg, data.getString("invrelatype")));
            }
            if (CollectionUtils.isNotEmpty(validateRs)) {
                msg = String.join((CharSequence)" ", validateRs);
                throw new KDBizException(msg);
            }
            String relationType = data.getString("invrelatype");
            DynamicObject newDynObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invrelation");
            if (Objects.nonNull(dynamicObject)) {
                DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynObject);
                newDynObject.set("id", (Object)dynamicObject.getLong("id"));
                renderDataCompute = needUpdateData::add;
                if (InvStaticStockRatioConstant.DeleteStatus.DELETE.getCode().equals(dynamicObject.getString("isdelete"))) {
                    seq = relationType2Seq.computeIfPresent(relationType, (k, v) -> {
                        Integer n = v;
                        Integer n2 = v = Integer.valueOf(v + 1);
                        return n;
                    });
                    newDynObject.set("relaseq", (Object)(seq == null ? Integer.valueOf(0) : seq));
                    runLog = () -> invRelationLogService.collectStaticChange(newDynObject, Collections.emptyList());
                } else {
                    runLog = () -> invRelationLogService.collectStaticChange(newDynObject, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                }
            } else {
                newDynObject.set("id", (Object)idDistributor.getLongId());
                seq = relationType2Seq.computeIfPresent(relationType, (k, v) -> {
                    Integer n = v;
                    Integer n2 = v = Integer.valueOf(v + 1);
                    return n;
                });
                newDynObject.set("relaseq", (Object)(seq == null ? Integer.valueOf(0) : seq));
                renderDataCompute = needNewSaveData::add;
                runLog = () -> invRelationLogService.collectStaticChange(newDynObject, Collections.emptyList());
            }
            newDynObject.set("model", (Object)modelId);
            newDynObject.set("scenario", (Object)scenarioId);
            newDynObject.set("year", (Object)yearId);
            newDynObject.set("period", (Object)periodId);
            newDynObject.set("orgunit", (Object)baseId);
            newDynObject.set("shareholder", (Object)InvRelationSearchHelper.getMemberId(modelNum, data, DimTypesEnum.INTERCOMPANY.getNumber(), "shareholder"));
            newDynObject.set("investeecompany", (Object)InvRelationSearchHelper.getMemberId(modelNum, data, DimTypesEnum.ENTITY.getNumber(), "investeecompany"));
            newDynObject.set("invrelatype", (Object)relationType);
            BigDecimal confirmscale = data.getBigDecimal("confirmscale");
            newDynObject.set("confirmscale", (Object)confirmscale);
            if (InvRelaTypeEnum.MinRelaType.getType().equals(relationType) || InvRelaTypeEnum.SameLevelRelaType.getType().equals(relationType)) {
                newDynObject.set("minconfirmscale", (Object)confirmscale);
            } else {
                newDynObject.set("minconfirmscale", (Object)BigDecimal.valueOf(100L).subtract(confirmscale));
            }
            newDynObject.set("isdelete", (Object)InvStaticStockRatioConstant.DeleteStatus.SAVE.getCode());
            newDynObject.set("modifier", (Object)userId);
            newDynObject.set("modifytime", (Object)now);
            DynamicObjectCollection limTemplate = newDynObject.getDynamicObjectCollection("invelimtemplate");
            limTemplate.clear();
            DynamicObjectCollection effectTemps = newDynObject.getDynamicObjectCollection("effecttemp");
            Pair<Set<String>, Set<String>> warringNumbers = invStaticRadioService.importTemplate(data, effectTemps);
            Pair<Set<String>, Set<String>> warringNewNumbers = invStaticRadioService.importNewTemplate(data, effectTemps);
            List<String> dyCheckRs = dynamicValidateHelper.doValidate(newDynObject);
            InvRelationSearchHelper.addTemplateCheckMsg(warringNumbers, dyCheckRs);
            InvRelationSearchHelper.addNewTemplateCheckMsg(warringNewNumbers, dyCheckRs);
            renderDataCompute.accept(newDynObject);
            runLog.run();
        }
        InvStaticStockRatioHelper.newAddSave(needNewSaveData);
        InvStaticStockRatioHelper.updateStockRadioInfo(needUpdateData);
        invRelationLogService.saveLogs(InvRelationLogService.OperationEnum.MS_API_ADDRELATION);
    }

    private static void addTemplateCheckMsg(Pair<Set<String>, Set<String>> setSetPair, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)setSetPair.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u6743\u76ca\u6a21\u677f\u3002", (String)"InvDynamicStockRadioImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)setSetPair.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvDynamicStockRadioImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private static void addNewTemplateCheckMsg(Pair<Set<String>, Set<String>> warringNewNumbers, List<String> dyCheckRs) {
        Set isExceptOutOfEnum;
        Set noThisTempNumbers = (Set)warringNewNumbers.p1;
        if (!noThisTempNumbers.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u6a21\u677f\u7f16\u7801|\u5206\u5f55\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f\u6a21\u677f\u5206\u5f55\u914d\u7f6e\u3002", (String)"InvDynamicStockRadioImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", noThisTempNumbers)));
        }
        if (!(isExceptOutOfEnum = (Set)warringNewNumbers.p2).isEmpty()) {
            String msg = ResManager.loadKDString((String)"%1$s\u8d85\u51fa\u662f\u5426\u9002\u7528\u53d6\u503c\u8303\u56f4{0\uff1a\u9002\u7528\uff0c1\uff1a\u4f8b\u5916}", (String)"InvDynamicStockRadioImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            dyCheckRs.add(String.format(msg, String.join((CharSequence)"\u3001", isExceptOutOfEnum)));
        }
    }

    private static Long getMemberId(String modelNum, JSONObject data, String dimNum, String key) {
        String number = data.getString(key);
        IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
        return mc.getId();
    }

    public static void buildShowTxtAndConfig(Collection<DynamicObject> effectTemp, TripleConsumer<String, String, String> showTxtAndConfigConsumer) {
        if (showTxtAndConfigConsumer == null) {
            return;
        }
        if (effectTemp == null) {
            showTxtAndConfigConsumer.accept("", "", "");
            return;
        }
        StringJoiner configRowJoiner = new StringJoiner(",");
        StringJoiner configRowNumberJoiner = new StringJoiner(",");
        StringJoiner showTxtRowJoiner = new StringJoiner(",");
        for (DynamicObject dy : effectTemp) {
            DynamicObject dynamicObject = dy.getDynamicObject("temp");
            String isExcept = dy.getString("isexcept");
            InvStaticStockRatioConstant.ExceptEnum exceptEnum = InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept);
            if (exceptEnum == null || dynamicObject == null) continue;
            StringJoiner showTxtJoiner = new StringJoiner("@");
            StringJoiner configNumberJoiner = new StringJoiner("@");
            StringJoiner configJoiner = new StringJoiner("@");
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            String number = dynamicObject.getString("number");
            showTxtJoiner.add(name).add(exceptEnum.getName());
            configNumberJoiner.add(number).add(isExcept);
            configJoiner.add(String.valueOf(id)).add(isExcept);
            showTxtRowJoiner.add(showTxtJoiner.toString());
            configRowNumberJoiner.add(configNumberJoiner.toString());
            configRowJoiner.add(configJoiner.toString());
        }
        showTxtAndConfigConsumer.accept(showTxtRowJoiner.toString(), configRowJoiner.toString(), configRowNumberJoiner.toString());
    }

    public static void buildShowTxtAndConfigNew(Collection<DynamicObject> effectTempNew, TripleConsumer<String, String, String> showTxtAndConfigConsumer) {
        if (showTxtAndConfigConsumer == null) {
            return;
        }
        if (effectTempNew == null) {
            showTxtAndConfigConsumer.accept("", "", "");
            return;
        }
        StringJoiner configRowJoiner = new StringJoiner(",");
        StringJoiner configRowNumberJoiner = new StringJoiner(",");
        StringJoiner showTxtRowJoiner = new StringJoiner(",");
        for (DynamicObject dy : effectTempNew) {
            DynamicObject dynamicObject = dy.getDynamicObject("temp");
            String isExcept = dy.getString("isexcept");
            InvStaticStockRatioConstant.ExceptEnum exceptEnum = InvStaticStockRatioConstant.ExceptEnum.getExceptByCode((String)isExcept);
            if (exceptEnum == null || dynamicObject == null) continue;
            StringJoiner showTxtJoiner = new StringJoiner("@");
            StringJoiner configNumberJoiner = new StringJoiner("@");
            StringJoiner configJoiner = new StringJoiner("@");
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            String number = dynamicObject.getString("number");
            DynamicObject sheetTemplate = dynamicObject.getDynamicObject("sheettemplate");
            String tempId = sheetTemplate.getString("id");
            String tempName = sheetTemplate.getString("name");
            String tempNumber = sheetTemplate.getString("number");
            showTxtJoiner.add(tempName + "|" + name).add(exceptEnum.getName());
            configNumberJoiner.add(tempNumber + "|" + number).add(isExcept);
            configJoiner.add(String.valueOf(id)).add(isExcept).add(tempId);
            showTxtRowJoiner.add(showTxtJoiner.toString());
            configRowNumberJoiner.add(configNumberJoiner.toString());
            configRowJoiner.add(configJoiner.toString());
        }
        showTxtAndConfigConsumer.accept(showTxtRowJoiner.toString(), configRowJoiner.toString(), configRowNumberJoiner.toString());
    }

    public static Table<Integer, Long, String> analysisEachRow(String rowData) {
        HashBasedTable config = HashBasedTable.create();
        if (StringUtils.isBlank((CharSequence)rowData)) {
            return config;
        }
        String[] rowsNew = rowData.split(",");
        for (int i = 0; i < rowsNew.length; ++i) {
            String row = rowsNew[i];
            String[] rowSplit = row.split("@");
            if (rowSplit.length <= 1) continue;
            String id = rowSplit[0];
            Long idLong = LongUtil.toLong((Object)id);
            String isExcept = rowSplit[1];
            config.put((Object)i, (Object)idLong, (Object)isExcept);
        }
        return config;
    }

    public static void loadTemp(Table<Integer, Long, String> config, String entityName, VoidFunction clearEntity, TripleConsumer<Integer, DynamicObject, String> consumerEachRowTemp) {
        if (config == null) {
            return;
        }
        Set tempIds = config.columnKeySet();
        Map id2Dy = BusinessDataServiceHelper.loadFromCache((Object[])tempIds.toArray(), (String)entityName);
        if (!id2Dy.isEmpty() && clearEntity != null) {
            clearEntity.doAction();
        }
        InvRelationSearchHelper.fillToRow(config, id2Dy, consumerEachRowTemp);
    }

    public static void fillToRow(Table<Integer, Long, String> config, Map<Object, DynamicObject> id2Dy, TripleConsumer<Integer, DynamicObject, String> consumerEachRowTemp) {
        if (config == null || id2Dy == null || consumerEachRowTemp == null) {
            return;
        }
        int rowNum = 0;
        for (int i = 0; i < config.size(); ++i) {
            Map row = config.row((Object)i);
            for (Map.Entry entry : row.entrySet()) {
                Long tempId = (Long)entry.getKey();
                DynamicObject dynamicObject = id2Dy.get(tempId);
                if (dynamicObject == null) continue;
                consumerEachRowTemp.accept(rowNum, dynamicObject, (String)entry.getValue());
                ++rowNum;
            }
        }
    }

    public static void collectTempAndFillRowAction(String tmpConfig, DynamicObjectCollection effectTemp, List<Long> tempIdCollector, List<Consumer<Map<Object, DynamicObject>>> fillRowCollector) {
        if (effectTemp == null || tempIdCollector == null || fillRowCollector == null) {
            return;
        }
        Table<Integer, Long, String> temConfigMap = InvRelationSearchHelper.analysisEachRow(tmpConfig);
        fillRowCollector.add(id2Dy -> InvRelationSearchHelper.fillToRow(temConfigMap, id2Dy, (seq, tempDy, isExcept) -> {
            DynamicObject rowDy = effectTemp.addNew();
            rowDy.set("temtype", (Object)"bcm_invelimtemplatebase");
            rowDy.set("temp", (Object)tempDy.getLong("id"));
            rowDy.set("isexcept", isExcept);
        }));
        tempIdCollector.addAll(temConfigMap.columnKeySet());
    }

    public static void collectTempNewAndFillRowAction(String tmpConfig, DynamicObjectCollection effectTemp, List<Long> tempIdCollector, List<BiConsumer<Map<Object, DynamicObject>, Map<Object, DynamicObject>>> fillRowCollector) {
        if (effectTemp == null || tempIdCollector == null || fillRowCollector == null) {
            return;
        }
        Table<Integer, Long, String> temConfigMap = InvRelationSearchHelper.analysisEachRow(tmpConfig);
        fillRowCollector.add((id2Dy, sheet2Dy) -> InvRelationSearchHelper.fillToRow(temConfigMap, id2Dy, (seq, sheetEntryDy, isExcept) -> {
            DynamicObject rowDy = effectTemp.addNew();
            rowDy.set("temtype", (Object)"bcm_invsheetttplentrys");
            rowDy.set("temp", (Object)sheetEntryDy.getLong("id"));
            rowDy.set("isexcept", isExcept);
            rowDy.set("number", (Object)sheetEntryDy.getString("number"));
            long sheetId = sheetEntryDy.getLong("sheettemplate.id");
            Object group = Optional.ofNullable(sheet2Dy.get(sheetId)).map(sheetTempDy -> sheetTempDy.get("group")).orElseGet(() -> 0L);
            rowDy.set("group", group);
        }));
        tempIdCollector.addAll(temConfigMap.columnKeySet());
    }

    public static void queryDataAndDoFillRowAction(List<Long> tempIds, List<Consumer<Map<Object, DynamicObject>>> fillRowActions, List<Long> tempNewIds, List<BiConsumer<Map<Object, DynamicObject>, Map<Object, DynamicObject>>> fillRowNewActions) {
        InvRelationSearchHelper.queryThenDoAction(tempIds, fillRowActions);
        InvRelationSearchHelper.queryNewThenDoAction(tempNewIds, fillRowNewActions);
    }

    private static void queryThenDoAction(List<Long> tempIds, List<Consumer<Map<Object, DynamicObject>>> fillRowActions) {
        if (CollectionUtil.isEmpty(tempIds) || CollectionUtil.isEmpty(fillRowActions)) {
            return;
        }
        QFBuilder qfTempBuilder = new QFBuilder("id", "in", tempIds);
        DynamicObjectCollection tempDys = QueryServiceHelper.query((String)"bcm_invelimtemplatebase", (String)"id", (QFilter[])qfTempBuilder.toArray());
        Map<Object, DynamicObject> id2Dy = tempDys.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy));
        fillRowActions.forEach(action -> action.accept(id2Dy));
    }

    private static void queryNewThenDoAction(List<Long> tempNewIds, List<BiConsumer<Map<Object, DynamicObject>, Map<Object, DynamicObject>>> fillRowNewActions) {
        if (CollectionUtil.isEmpty(tempNewIds) || CollectionUtil.isEmpty(fillRowNewActions)) {
            return;
        }
        QFBuilder qfTempNewBuilder = new QFBuilder("id", "in", tempNewIds);
        String tempNewFields = String.join((CharSequence)",", "id", "number", "sheettemplate.id");
        DynamicObjectCollection tempNewDys = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)tempNewFields, (QFilter[])qfTempNewBuilder.toArray());
        Map<Object, DynamicObject> id2DyNew = tempNewDys.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy));
        Set sheetIds = tempNewDys.stream().map(dy -> dy.getLong("sheettemplate.id")).collect(Collectors.toSet());
        String selectFields = String.join((CharSequence)",", "id", "group");
        QFBuilder qfBuilder = new QFBuilder("id", "in", sheetIds);
        DynamicObjectCollection sheetDys = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qfBuilder.toArray());
        Map<Object, DynamicObject> sheet2Dy = sheetDys.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy));
        fillRowNewActions.forEach(action -> action.accept(id2DyNew, sheet2Dy));
    }

    public static Pair<DynamicObjectCollection, DynamicObjectCollection> getTempAndTempNewPair(DynamicObject dy, Map<Object, DynamicObject> temId2Dy, BiFunction<Long, String, DynamicObject> findNewTempAction) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection dynamicObjectsNew = new DynamicObjectCollection();
        if (dy == null) {
            return Pair.onePair((Object)dynamicObjects, (Object)dynamicObjectsNew);
        }
        DynamicObjectCollection effectTemp = dy.getDynamicObjectCollection("effecttemp");
        for (DynamicObject dynamicObject : effectTemp) {
            DynamicObject sheet;
            String tempType = dynamicObject.getString("temtype");
            if ("bcm_invelimtemplatebase".equals(tempType)) {
                dynamicObjects.add((Object)dynamicObject);
                continue;
            }
            DynamicObject tempDy = InvRelationSearchHelper.getSheetTempDy(dynamicObject, findNewTempAction);
            if (tempDy == null || (sheet = temId2Dy.get(tempDy.getLong("id"))) == null) continue;
            dynamicObject.set("temp", (Object)sheet);
            dynamicObjectsNew.add((Object)dynamicObject);
        }
        return Pair.onePair((Object)dynamicObjects, (Object)dynamicObjectsNew);
    }

    private static DynamicObject getSheetTempDy(DynamicObject dynamicObject, BiFunction<Long, String, DynamicObject> findNewTempAction) {
        DynamicObject tempDy = dynamicObject.getDynamicObject("temp");
        if (tempDy == null && findNewTempAction != null) {
            long groupId = dynamicObject.getLong("group");
            String tempNumber = dynamicObject.getString("number");
            DynamicObject tempByNumberAndGroupId = findNewTempAction.apply(groupId, tempNumber);
            dynamicObject.set("temp", (Object)tempByNumberAndGroupId);
        }
        return tempDy;
    }

    public static Map<Object, DynamicObject> getNewTempId2Dy(Collection<DynamicObject> staticOrDynStockRatios) {
        Object[] pkArray = staticOrDynStockRatios.stream().map(dy -> dy.getDynamicObjectCollection("effecttemp")).flatMap(dys -> dys.stream().filter(dy -> "bcm_invsheetttplentrys".equals(dy.get("temtype"))).map(dy -> dy.getDynamicObject("temp")).filter(Objects::nonNull).map(dy -> dy.getLong("id"))).toArray();
        return BusinessDataServiceHelper.loadFromCache((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_invsheetttplentrys"));
    }
}

