/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.api.dto.InvResultDTO;
import kd.fi.bcm.business.invest.api.dto.InvShareRelaDTO;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvShareRelaConstant;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;

public class InvShareRelaHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(InvShareRelaHelper.class);

    public static InvResultDTO save(List<InvShareRelaDTO> dtoList) {
        InvResultDTO result = InvResultDTO.success("");
        log.startWatch();
        log.info(String.format("InvShareRelaHelper.save  request  param:%s", ObjectSerialUtil.toJson(dtoList)));
        try {
            if (dtoList.isEmpty()) {
                return result;
            }
            ArrayList dataPairs = new ArrayList(16);
            HashSet uniKey = new HashSet(16);
            dtoList.forEach(invShareRelaDTO -> {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsharerela");
                InvShareRelaHelper.validMustInput(invShareRelaDTO);
                Date now = TimeServiceHelper.now();
                long currUserId = RequestContext.get().getCurrUserId();
                dy.set("creatorid", (Object)currUserId);
                dy.set("createtime", (Object)now);
                dy.set("modifierid", (Object)currUserId);
                dy.set("modifytime", (Object)now);
                dy.set("remark", (Object)invShareRelaDTO.getRemark());
                InvShareRelaHelper.validModel(invShareRelaDTO, dy);
                InvShareRelaHelper.validInvestedCompany(invShareRelaDTO, dy);
                InvShareRelaHelper.validShareHolder(invShareRelaDTO, dy);
                InvShareRelaHelper.validInvChangeType(invShareRelaDTO, dy);
                InvShareRelaHelper.validInvDate(invShareRelaDTO, dy);
                InvShareRelaHelper.validInvAmount(invShareRelaDTO, dy);
                InvShareRelaHelper.validShareScale(invShareRelaDTO, dy);
                InvShareRelaHelper.validShareCase(invShareRelaDTO, dy);
                if (!uniKey.add(InvShareRelaHelper.getUniKey(invShareRelaDTO))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\u3002", (String)"InvShareRelaHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(invShareRelaDTO)));
                }
                dataPairs.add(Pair.onePair((Object)invShareRelaDTO, (Object)dy));
            });
            HashSet<DynamicObject> needSaveDatas = new HashSet<DynamicObject>(16);
            Map<Long, Map<Long, List<Pair>>> groupData = dataPairs.stream().collect(Collectors.groupingBy(e -> ((DynamicObject)e.p2).getLong("sharecase"), Collectors.groupingBy(f -> ((DynamicObject)f.p2).getLong("investeecompany.id"))));
            groupData.forEach((sharecaseId, pairsMap) -> pairsMap.forEach((investeecompanyId, pairList) -> needSaveDatas.addAll(InvShareRelaHelper.validInvRelaFromDb(pairList))));
            if (dtoList.get(0).getSaveFlag() != null && dtoList.get(0).getSaveFlag().booleanValue()) {
                InvShareRelaHelper.doSave(dtoList.get(0).getModelId(), needSaveDatas);
            }
        }
        catch (Exception e2) {
            log.error(String.format("InvShareRelaHelper.save request error:%s", e2.getMessage()));
            result = InvResultDTO.fail(e2.getMessage());
        }
        log.infoEnd(String.format("InvShareRelaHelper.save request result:%s", ObjectSerialUtil.toJson((Object)result)));
        return result;
    }

    private static String getUniKey(InvShareRelaDTO dto) {
        return String.format("%s|%s|%s", dto.getShareHolderNum(), dto.getInvesteeCompanyNum(), dto.getInvestDate() == null ? "" : DateTimeUtils.format((Date)dto.getInvestDate(), (String)"yyyy-MM-dd"));
    }

    private static Set<DynamicObject> validInvRelaFromDb(List<Pair<InvShareRelaDTO, DynamicObject>> pairList) {
        HashSet<DynamicObject> result = new HashSet<DynamicObject>(16);
        if (pairList == null || pairList.isEmpty()) {
            return result;
        }
        DynamicObject[] relations = InvShareRelaHelper.selectRelationFromDB((DynamicObject)pairList.get((int)0).p2);
        List<DynamicObject> allRelations = pairList.stream().map(e -> (DynamicObject)e.p2).collect(Collectors.toList());
        pairList.forEach(p -> {
            Optional<DynamicObject> objectOptional;
            Map<String, Optional<DynamicObject>> maxDateGroup;
            InvShareRelaDTO invShareRelaDTO = (InvShareRelaDTO)p.p1;
            DynamicObject newDy = (DynamicObject)p.p2;
            newDy.set("iscontrol", (Object)(invShareRelaDTO.isIscontrol() != false ? "1" : "0"));
            newDy.set("changescale", (Object)invShareRelaDTO.getShareScale());
            if (relations != null && relations.length > 0 && (maxDateGroup = Arrays.stream(relations).collect(Collectors.groupingBy(InvShareRelaService::getShareholderNumber, Collectors.maxBy(Comparator.comparing(dy -> dy.getDate("investdate")))))).containsKey(invShareRelaDTO.getShareHolderNum()) && (objectOptional = maxDateGroup.get(invShareRelaDTO.getShareHolderNum())).isPresent()) {
                Date oldDate = DateTimeUtils.truncateDate((Date)objectOptional.get().getDate("investdate"));
                Date newDate = DateTimeUtils.truncateDate((Date)newDy.getDate("investdate"));
                if (oldDate != null && newDate != null) {
                    if (oldDate.equals(newDate)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d+\u88ab\u6295\u8d44\u5355\u4f4d+\u6295\u8d44\u65e5\u671f\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\u3002", (String)"InvShareRelaHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(invShareRelaDTO)));
                    }
                    if (oldDate.after(newDate)) {
                        throw new KDBizException(InvShareRelaHelper.getErrorMessage(invShareRelaDTO) + String.format(ResManager.loadKDString((String)"\u6295\u8d44\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u6295\u8d44\u5355\u4f4d\u5df2\u6709\u7684\u6700\u5927\u6295\u8d44\u65e5\u671f[%1$s]\u3002", (String)"InvShareRelaHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), DateTimeUtils.format((Date)objectOptional.get().getDate("investdate"), (String)"yyyy-MM-dd")));
                    }
                    newDy.set("changescale", (Object)invShareRelaDTO.getShareScale().subtract(objectOptional.get().getBigDecimal("sharescale")));
                }
            }
        });
        if (relations != null && relations.length > 0) {
            allRelations.addAll(Arrays.asList(relations));
        }
        InvShareRelaService.groupCollectBeforeCheckControlAndSumShareScale(allRelations, (shareholderConfigMap, calculateUtil) -> InvShareRelaService.buildControlSumAndShareScaleSumThenCheck(shareholderConfigMap, (Pair<String, Set<DynamicObject>>)calculateUtil, controlSum -> {
            if (controlSum > 1) {
                String investDate = InvShareRelaService.getCheckingDate(shareholderConfigMap);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u671f\u5b58\u5728\u591a\u4e2a\u63a7\u5236\u80a1\u4e1c\uff0c\u8bf7\u4fee\u6539\u6210\u4e00\u4e2a\uff0c\u5173\u6ce8\u662f\u5426\u53d7\u5df2\u6709\u7684\u80a1\u6743\u5173\u7cfb\u5f71\u54cd\u3002", (String)"InvShareRelaHelper_28", (String)"fi-bcm-business", (Object[])new Object[0]), ((InvShareRelaDTO)((Pair)pairList.get((int)0)).p1).getInvesteeCompanyNum(), investDate));
            }
        }, shareScaleSum -> {
            if (new BigDecimal("100").compareTo((BigDecimal)shareScaleSum) < 0) {
                String investDate = InvShareRelaService.getCheckingDate(shareholderConfigMap);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u88ab\u6295\u8d44\u5355\u4f4d\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u671f\u7684\u6295\u8d44\u6bd4\u4f8b\u603b\u989d\u8d85\u8fc7100%%\uff0c\u8bf7\u4fee\u6539\uff0c\u5173\u6ce8\u662f\u5426\u53d7\u5df2\u6709\u7684\u80a1\u6743\u5173\u7cfb\u5f71\u54cd\u3002", (String)"InvShareRelaHelper_29", (String)"fi-bcm-business", (Object[])new Object[0]), ((InvShareRelaDTO)((Pair)pairList.get((int)0)).p1).getInvesteeCompanyNum(), investDate));
            }
        }));
        result.addAll(allRelations);
        return result;
    }

    private static DynamicObject[] selectRelationFromDB(DynamicObject invShareRela) {
        QFBuilder qfBuilder = InvShareRelaService.getIsolationQFilter(invShareRela.getLong("model"), invShareRela.getLong("sharecase"));
        qfBuilder.and("investeecompany", "=", (Object)invShareRela.getLong("investeecompany.id"));
        String selectProperties = new StringJoiner(",").add(String.join((CharSequence)",", InvShareRelaConstant.uniqueCombo())).add(String.join((CharSequence)",", InvShareRelaConstant.otherUpdateField())).add("id").add("changescale").add("creatorid").add("createtime").toString();
        return InvShareRelaService.loadInvShareRela(selectProperties, qfBuilder);
    }

    private static void validShareCase(InvShareRelaDTO dto, DynamicObject dy) {
        String shareCaseNum = StringUtils.isEmpty((CharSequence)dto.getShareCaseNum()) ? "defaultInvest" : dto.getShareCaseNum();
        QFBuilder qf = new QFBuilder("model", "=", (Object)dto.getModelId());
        qf.add("number", "=", (Object)shareCaseNum);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_invsharecase", (String)"id,number", (QFilter[])qf.toArray());
        if (dynamicObject == null) {
            String msg = ResManager.loadKDString((String)"%1$s\u6743\u76ca\u65b9\u6848\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"InvShareRelaHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("sharecase", (Object)dynamicObject.getLong("id"));
    }

    private static String getErrorMessage(InvShareRelaDTO dto) {
        return String.format("%s - %s - %s - %s :", dto.getShareHolderNum(), dto.getInvesteeCompanyNum(), dto.getInvChangeTypeNum(), dto.getInvestDate() == null ? "" : DateTimeUtils.format((Date)dto.getInvestDate(), (String)"yyyy-MM-dd"));
    }

    private static void validMustInput(InvShareRelaDTO dto) {
        if (dto.getModelId() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getHolderCurrencyNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getInvesteeCompanyNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getShareHolderNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (Objects.equals(dto.getInvesteeCompanyNum(), dto.getShareHolderNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u4e0e\u88ab\u6295\u8d44\u5355\u4f4d\u76f8\u540c\u3002", (String)"InvShareRelaHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getInvChangeTypeNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (dto.getInvestDate() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (dto.isIscontrol() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u662f\u5426\u8fbe\u6210\u63a7\u5236\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (dto.getRemark() != null && dto.getRemark().length() > 200) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7200\u5b57\u7b26\u3002", (String)"InvShareRelaHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
    }

    private static void validShareScale(InvShareRelaDTO dto, DynamicObject dy) {
        if (dto.getShareScale() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (dto.getShareScale().compareTo(new BigDecimal("100")) > 0 || dto.getShareScale().compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u5fc5\u987b\u57280~100%\u4e4b\u95f4\u3002", (String)"InvShareRelaHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (dto.getShareScale().scale() > 15) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u671f\u672b\u6301\u80a1\u6bd4\u4f8b\u7684\u5c0f\u6570\u4e0d\u80fd\u8d85\u8fc715\u4f4d\u3002", (String)"InvShareRelaHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("sharescale", (Object)dto.getShareScale());
    }

    private static void validInvAmount(InvShareRelaDTO dto, DynamicObject dy) {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = dto.getInvestAmount() == null ? BigDecimal.ZERO : dto.getInvestAmount();
        if (!InvestUtils.checkAmountOutOfRange((BigDecimal)amount)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6295\u8d44\u91d1\u989d\u6570\u503c\u8d8a\u754c,\u7cbe\u5ea6\u5e94\u4e3a[17,4]\u3002", (String)"InvShareRelaHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("investamount", (Object)amount);
    }

    private static void validInvDate(InvShareRelaDTO dto, DynamicObject dy) {
        if (dto.getInvestDate() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("investdate", (Object)DateTimeUtils.truncateDate((Date)dto.getInvestDate()));
    }

    public static DynamicObject[] doSave(Long modelId, Set<DynamicObject> data) {
        HashSet update = Sets.newHashSet();
        HashSet addNew = Sets.newHashSet();
        for (DynamicObject datum : data) {
            if (datum.getLong("id") == 0L) {
                addNew.add(datum);
                continue;
            }
            update.add(datum);
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            if (!update.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])update.toArray(new DynamicObject[0]));
            }
            if (!addNew.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addNew.toArray(new DynamicObject[0]));
            }
            DynamicObject[] dynamicObjects = data.toArray(new DynamicObject[0]);
            InvestUtils.updateInvChangeStatus((long)modelId, (DynamicObject[])dynamicObjects);
            DynamicObject[] dynamicObjectArray = dynamicObjects;
            return dynamicObjectArray;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void validInvChangeType(InvShareRelaDTO dto, DynamicObject dy) {
        if (StringUtils.isEmpty((CharSequence)dto.getInvChangeTypeNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        Map<String, ChangeTypeModel> changetypeMap = InvestServiceHelper.getInvChangetypeModel(dto.getModelId());
        if (!changetypeMap.containsKey(dto.getInvChangeTypeNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u7c7b\u578b\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"InvShareRelaHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("invchangetype", (Object)changetypeMap.get(dto.getInvChangeTypeNum()).getId());
    }

    private static void validShareHolder(InvShareRelaDTO dto, DynamicObject dy) {
        if (StringUtils.isEmpty((CharSequence)dto.getShareHolderNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if ("ICNone".equals(dto.getShareHolderNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u9700\u8981\u4e3a\u6b63\u786e\u7684\u5f80\u6765\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"InvShareRelaHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)dto.getModelId());
        qf.and("number", "=", (Object)dto.getShareHolderNum());
        DynamicObject icDy = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id,number,name", (QFilter[])qf.toArray());
        if (icDy == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u9700\u8981\u4e3a\u6b63\u786e\u7684\u5f80\u6765\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"InvShareRelaHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        DynamicObject hoderIcDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_icmembertree");
        hoderIcDy.set("id", (Object)icDy.getLong("id"));
        hoderIcDy.set("number", (Object)icDy.getString("number"));
        if (StringUtils.isEmpty((CharSequence)dto.getHolderCurrencyNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        IDNumberTreeNode currencyMember = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)dto.getModelId()), (String)dto.getHolderCurrencyNum());
        if (currencyMember.getId() == -1L) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5e01\u79cd\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"InvShareRelaHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        QFBuilder qf2 = new QFBuilder("model", "=", (Object)dto.getModelId());
        qf2.add("number", "=", (Object)dto.getShareHolderNum());
        qf2.add("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        DynamicObject shareHolderDy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,isinnerorg,isindependentorg,currency.id,currency.number", (QFilter[])qf2.toArray());
        if (shareHolderDy != null) {
            if (!shareHolderDy.getBoolean("isindependentorg")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6295\u8d44\u5355\u4f4d\u5fc5\u987b\u4e3a\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
            }
            if (shareHolderDy.getBoolean("isinnerorg") && !Objects.equals(shareHolderDy.getString("currency.number"), dto.getHolderCurrencyNum())) {
                throw new KDBizException(InvShareRelaHelper.getErrorMessage(dto) + String.format(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u4e3a\u5185\u90e8\u7ec4\u7ec7\uff0c\u5e01\u79cd\u5e94\u4e3a[%1$s]\uff0c\u800c\u5bfc\u5165\u7684\u5e01\u79cd\u662f[%2$s]\u3002", (String)"InvShareRelaHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), shareHolderDy.getString("currency.number"), dto.getHolderCurrencyNum()));
            }
        }
        dy.set("isout", (Object)(shareHolderDy != null && shareHolderDy.getBoolean("isinnerorg") ? 1 : 0));
        dy.set("shareholder", (Object)hoderIcDy);
        dy.set("holderec", (Object)currencyMember.getId());
    }

    private static void validInvestedCompany(InvShareRelaDTO dto, DynamicObject dy) {
        IDNumberTreeNode currencyNode;
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), dto.getModelId().toString());
        if (StringUtils.isEmpty((CharSequence)dto.getInvesteeCompanyNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u88ab\u6295\u8d44\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)dto.getModelId());
        qf.add("number", "=", (Object)dto.getInvesteeCompanyNum());
        qf.add("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        DynamicObject investeeCompanyDy = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,isindependentorg,currency.number", (QFilter[])qf.toArray());
        if (investeeCompanyDy == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"InvShareRelaHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (!investeeCompanyDy.getBoolean("isindependentorg")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u88ab\u6295\u8d44\u5355\u4f4d\u5fc5\u987b\u4e3a\u5fc5\u987b\u4e3a\u72ec\u7acb\u6cd5\u4eba\u516c\u53f8\u3002", (String)"InvShareRelaHelper_25", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        Set<Object> writePermOrgIds = new HashSet(16);
        if (!adminUserBol) {
            long dimensionId = MemberReader.getDimensionIdByNum((long)dto.getModelId(), (String)PresetConstant.ENTITY_DIM);
            writePermOrgIds = PermissionServiceImpl.getInstance(dto.getModelId()).matchWritePermMembers(dimensionId, "bcm_entitymembertree", Lists.newArrayList((Object[])new Long[]{investeeCompanyDy.getLong("id")}));
        }
        if (!adminUserBol && !writePermOrgIds.contains(investeeCompanyDy.getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u60a8\u5bf9\u88ab\u6295\u8d44\u5355\u4f4d\u65e0\u5199\u6743\u9650\u3002", (String)"InvShareRelaHelper_26", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        DynamicObject invCompany = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
        invCompany.set("id", (Object)investeeCompanyDy.getLong("id"));
        invCompany.set("number", (Object)investeeCompanyDy.getString("number"));
        dy.set("investeecompany", (Object)invCompany);
        if (StringUtils.isNotEmpty((CharSequence)investeeCompanyDy.getString("currency.number")) && (currencyNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)dto.getModelId()), (String)investeeCompanyDy.getString("currency.number"))).getId() != -1L) {
            dy.set("invcompanycurrency", (Object)currencyNode.getId());
        }
    }

    private static void validModel(InvShareRelaDTO dto, DynamicObject dy) {
        if (dto.getModelId() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvShareRelaHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        if (!QueryServiceHelper.exists((String)"bcm_model", (Object)dto.getModelId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4f53\u7cfb\u53c2\u6570\u4f20\u5165\u6709\u8bef\u3002", (String)"InvShareRelaHelper_27", (String)"fi-bcm-business", (Object[])new Object[0]), InvShareRelaHelper.getErrorMessage(dto)));
        }
        dy.set("model", (Object)dto.getModelId());
    }

    public static InvResultDTO testInvRelaMsService(Long modelId, String shareHolderNum, String investeeCompanyNum, String invChangeTypeNum, Boolean isControl, BigDecimal shareScale, Date investDate, BigDecimal investAmount, String holderCurrencyNum, String shareCaseNum, String remark) throws Exception {
        InvShareRelaDTO dto = new InvShareRelaDTO();
        dto.setSaveFlag(Boolean.TRUE);
        dto.setModelId(modelId);
        dto.setShareHolderNum(shareHolderNum);
        dto.setInvesteeCompanyNum(investeeCompanyNum);
        dto.setInvChangeTypeNum(invChangeTypeNum);
        dto.setIscontrol(isControl);
        dto.setShareScale(shareScale);
        dto.setInvestDate(investDate);
        dto.setInvestAmount(investAmount);
        dto.setHolderCurrencyNum(holderCurrencyNum);
        dto.setShareCaseNum(shareCaseNum);
        dto.setRemark(remark);
        ArrayList list = new ArrayList(16);
        String param = JSONUtils.toString(list);
        String s = (String)MsServiceHelper.invokeService((String)"fi", (String)"bcm", (String)"InvestMsService", (String)"addInvShareRela", (Object[])new Object[]{param});
        return (InvResultDTO)JSONUtils.cast((String)s, InvResultDTO.class);
    }
}

