/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.api.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.fi.bcm.business.invest.api.dto.InvMsResult;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.lang.StringUtils;

public class InvMsCheckHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(InvMsCheckHelper.class);

    public static InvMsResult checkDto(Object dto, Long modelId, String permItemId, String menuName, Consumer<Map<String, String>> periodInScenarioCheck) throws IllegalAccessException {
        String modelCheck = InvRelationSearchService.modelExists(modelId);
        if (Objects.nonNull(modelCheck)) {
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_REFUSE).setData(modelCheck);
        }
        Class<?> dtoClass = dto.getClass();
        Map<Class<? extends Annotation>, List<Field>> annotation2FieldMap = InvRelationSearchService.getAnnotation2FieldMap(dtoClass);
        Map<String, String> maps = InvRelationSearchService.nullAndExistsCheck(dto, modelId, annotation2FieldMap);
        if (!maps.isEmpty()) {
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_REFUSE).setData(maps);
        }
        if (!StringUtils.isBlank((String)permItemId) && !InvRelationSearchService.checkModelPermission(LongUtil.toLong((Object)modelId), "bcm_invrelation_search", permItemId)) {
            return InvMsResult.fail(InvMsResult.ResultEnum.PERMISSION_DENIED).setData(menuName);
        }
        maps = InvRelationSearchService.memberPermCheck(dto, modelId, annotation2FieldMap);
        if (!maps.isEmpty()) {
            return InvMsResult.fail(InvMsResult.ResultEnum.PERMISSION_DENIED).setData(maps);
        }
        maps = InvRelationSearchService.rangeCheck(dto, annotation2FieldMap);
        InvRelationSearchService.orgIsLeafCheck(dto, modelId, annotation2FieldMap, maps);
        periodInScenarioCheck.accept(maps);
        if (!maps.isEmpty()) {
            return InvMsResult.fail(InvMsResult.ResultEnum.BUSINESS_REFUSE).setData(maps);
        }
        return null;
    }
}

