/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.changecase.OrgBizTypeArrayModel;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.helper.InvLockHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.InvStructureContext;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.invest.InvCaseChangeTypeEnum;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.KDAssert;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.StringUtils;

public class InvCasePageDimLoadOrgService {
    private final long modelId;
    private final long cslSchemeId;
    private final long scenarioId;
    private final long yearId;
    private InvStructureContext ctx;
    private final PermissionService permissionService;
    private final List<Long> periodIds = new ArrayList<Long>(16);
    private final Map<Long, Date[]> scenePeriodIdSet = new HashMap<Long, Date[]>();
    private final Map<Long, OrgBizTypeArrayModel> orgBizTypeArrayModelMap = new ConcurrentHashMap<Long, OrgBizTypeArrayModel>(12);
    private final Set<DynamicObject> newPageDims = new ConcurrentHashSet(16);
    private List<DynamicObject> cases = new CopyOnWriteArrayList<DynamicObject>();
    private Set<String> uniqueKeyInDB = new ConcurrentHashSet();
    private static final Set<String> CHANGE_TYPES = Arrays.stream(InvCaseChangeTypeEnum.values()).filter(invCaseChangeType -> invCaseChangeType != InvCaseChangeTypeEnum.DEALPARENT && invCaseChangeType != InvCaseChangeTypeEnum.NEWPARENT).map(InvCaseChangeTypeEnum::getIndex).collect(Collectors.toSet());

    public InvCasePageDimLoadOrgService(long modelId, long cslSchemeId, long scenarioId, long yearId) {
        this.modelId = modelId;
        this.cslSchemeId = cslSchemeId;
        this.scenarioId = scenarioId;
        this.yearId = yearId;
        ArrayList<String> checkRs = new ArrayList<String>(4);
        if (this.modelId == 0L) {
            checkRs.add(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCasePageDimLoadOrgService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (this.cslSchemeId == 0L) {
            checkRs.add(ResManager.loadKDString((String)"\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCasePageDimLoadOrgService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (this.yearId == 0L) {
            checkRs.add(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCasePageDimLoadOrgService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.permissionService = PermissionServiceImpl.getInstance(modelId);
        if (this.scenarioId == 0L) {
            checkRs.add(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCasePageDimLoadOrgService_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        } else {
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Scenario");
            if (this.permissionService.hasNoPerm(dimensionId, scenarioId)) {
                checkRs.add(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u65e0\u6743\u3002", (String)"InvCasePageDimLoadOrgService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        this.ctx = new InvStructureContext(modelId, scenarioId, yearId, 0L);
        KDAssert.assertTrue((boolean)checkRs.isEmpty(), () -> new KDBizException(String.join((CharSequence)"\n", checkRs)));
    }

    public ResultBox doHandleLoadOrg(String periodStr, String entityNumber, long selectedCaseId, String isAllCase, List<Long> noPermCase) {
        this.prepareData(periodStr, entityNumber, selectedCaseId, isAllCase);
        if (this.periodIds.isEmpty()) {
            return ResultBox.of();
        }
        ConcurrentLinkedQueue logs = new ConcurrentLinkedQueue();
        this.cases.removeIf(dy -> {
            boolean thisCaseNodePerm = noPermCase.contains(dy.getLong("id"));
            if (thisCaseNodePerm) {
                logs.add(this.logCaseNoPerm((DynamicObject)dy));
            }
            return thisCaseNodePerm;
        });
        KDAssert.assertFalse((boolean)this.cases.isEmpty(), () -> new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u65b9\u6848\u9002\u7528\u5f53\u524d\u60c5\u666f\u3001\u5df2\u5206\u914d\u5230\u5f53\u524d\u89c6\u56fe\u3001\u5f53\u524d\u7528\u6237\u6709\u6743\u3002", (String)"InvCasePageDimLoadOrgService_9", (String)"fi-bcm-business", (Object[])new Object[0])));
        Map<Long, String> caseId2Number = this.cases.stream().collect(Collectors.toMap(sy -> sy.getLong("id"), dy -> dy.getString("number"), (v1, v2) -> v1));
        LinkedList<IRunner> task = new LinkedList<IRunner>();
        for (Long periodId : this.periodIds) {
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)this.modelId, (Long)periodId);
            if (!periodNode.isLeaf()) continue;
            task.add(() -> this.analyzeEachPeriod(periodId, this.orgBizTypeArrayModelMap.get(periodId)));
        }
        ThreadPoolService.runInWaiting4AdjustChildTaskThread(task.toArray(new IRunner[0]));
        List<Long> targetIds = this.newPageDims.stream().map(dy -> dy.getLong("tarparentorg")).collect(Collectors.toList());
        Long dimensionId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)"Entity");
        Set<Long> writePermTarget = this.permissionService.matchWritePermMembers(dimensionId, "bcm_entitymembertree", targetIds);
        Optional<String> rs = InvLockHelper.newAddOrRemoveCasePageDimTryLock(this.yearId, 2000L, () -> {
            this.queryUniqueKeyInDB();
            HashSet uniqueKeyNew = new HashSet(16);
            this.newPageDims.removeIf(dy -> {
                boolean noPerm;
                long tarParentId = dy.getLong("tarparentorg");
                String key = this.buildUniqueKey((DynamicObject)dy);
                boolean isLoaded = this.uniqueKeyInDB.contains(key);
                if (isLoaded) {
                    logs.add(this.logLoaded(caseId2Number, (DynamicObject)dy));
                    return true;
                }
                boolean bl = noPerm = !writePermTarget.contains(tarParentId);
                if (noPerm) {
                    logs.add(this.logTarParentNoPerm(caseId2Number, (DynamicObject)dy, tarParentId));
                    return true;
                }
                return !uniqueKeyNew.add(key);
            });
            logs.addAll(this.logSuccess(caseId2Number));
            SaveServiceHelper.save((DynamicObject[])this.newPageDims.toArray(new DynamicObject[0]));
        });
        rs.ifPresent(logs::add);
        ResultBox resultBox = ResultBox.of();
        resultBox.add(String.join((CharSequence)"\r\n", new TreeSet(logs)));
        resultBox.setData(this.newPageDims);
        return resultBox;
    }

    private void prepareData(String periodStr, String entityNumber, long selectedCaseId, String isAllCase) {
        KDAssert.assertFalse((!CaseScopeEnum.ALL_CASE.code.equals(isAllCase) && selectedCaseId == 0L ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u65b9\u6848\u83b7\u53d6\u65f6\uff0c\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"InvCasePageDimLoadOrgService_6", (String)"fi-bcm-business", (Object[])new Object[0])));
        QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"sceneperiod.fbasedataid_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.scenarioId)}).forEach(dy -> {
            long periodId = dy.getLong("sceneperiod.fbasedataid_id");
            this.scenePeriodIdSet.put(periodId, PeriodUtils.calcStartAndEndDate((long)this.ctx.getModelId(), (long)this.ctx.getFyId(), (long)periodId));
        });
        KDAssert.assertFalse((boolean)this.scenePeriodIdSet.isEmpty(), () -> new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u65e0\u53ef\u7528\u671f\u95f4\u3002", (String)"InvCasePageDimLoadOrgService_8", (String)"fi-bcm-business", (Object[])new Object[0])));
        for (Long periodId2 : ((DimensionScope)SerializationUtils.deSerializeFromBase64((String)periodStr)).getResolveScopeIds()) {
            if (!this.scenePeriodIdSet.containsKey(periodId2) || !BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Period", (long)periodId2).isLeaf()) continue;
            this.periodIds.add(periodId2);
        }
        KDAssert.assertFalse((boolean)this.periodIds.isEmpty(), () -> new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u89e3\u6790\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"InvCasePageDimLoadOrgService_7", (String)"fi-bcm-business", (Object[])new Object[0])));
        Optional<IDNumberTreeNode> rootNodeOp = BcmThreadCache.findMemberByNum((String)this.ctx.getModelNum(), (String)"Entity", (String)"Entity").getChildren().stream().filter(child -> this.cslSchemeId == (Long)child.getProperty("cslscheme.id")).findFirst();
        if (!rootNodeOp.isPresent()) {
            return;
        }
        List<IRunner> taskList = this.periodIds.stream().map(periodId -> this.buildOrgBizTypeArrayModel((Long)periodId, ((IDNumberTreeNode)rootNodeOp.get()).getAllChildrenIds())).collect(Collectors.toList());
        taskList.add(() -> this.filterRelevantCaseFromDB((Consumer<QFilter>)((Consumer)filter -> {
            if (!CaseScopeEnum.ALL_CASE.code.equals(isAllCase)) {
                filter.and("id", "=", (Object)selectedCaseId);
            }
        })));
        ThreadPoolService.runInWaiting4AdjustChildTaskThread(taskList.toArray(new IRunner[0]));
        this.prepareOrgBizTypeList(entityNumber);
    }

    private IRunner buildOrgBizTypeArrayModel(Long periodId, Set<Long> allChildrenIds) {
        return () -> {
            OrgBizTypeArrayModel orgBizTypeArrayModel = new OrgBizTypeArrayModel(this.ctx, periodId);
            FilterOrgStructParam param = new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), (long)periodId);
            orgBizTypeArrayModel.setEfftiveOrgSet(EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, allChildrenIds).keySet());
            this.orgBizTypeArrayModelMap.put(periodId, orgBizTypeArrayModel);
        };
    }

    private String logCaseNoPerm(DynamicObject dy) {
        String number = dy.getString("number");
        return String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\uff0c\u65e0\u6570\u636e\u6743\u9650\u3002", (String)"InvCasePageDimLoadOrgService_11", (String)"fi-bcm-business", (Object[])new Object[0]), number);
    }

    private String logLoaded(Map<Long, String> caseId2Number, DynamicObject dy) {
        long srcOrgId = dy.getLong("org");
        IDNumberTreeNode srcOrgNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)srcOrgId);
        long tarPOrgId = dy.getLong("tarparentorg");
        IDNumberTreeNode tarOrgNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)tarPOrgId);
        long caseId = dy.getLong("case");
        long periodId = dy.getLong("period");
        IDNumberTreeNode srcPeriod = MemberReader.findPeriodMemberById((Long)this.modelId, (Long)periodId);
        long tarPeriodId = dy.getLong("tarperiod");
        IDNumberTreeNode tarPeriod = MemberReader.findPeriodMemberById((Long)this.modelId, (Long)tarPeriodId);
        return String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\uff0c%2$s\u6708%3$s->%4$s\u6708%5$s\u5b58\u5728\u8bb0\u5f55\uff0c\u4e0d\u91cd\u65b0\u83b7\u53d6\u3002", (String)"InvCasePageDimLoadOrgService_14", (String)"fi-bcm-business", (Object[])new Object[0]), caseId2Number.get(caseId), srcPeriod.getNumber(), srcOrgNode.getNumber(), tarPeriod.getNumber(), tarOrgNode.getNumber());
    }

    private String logTarParentNoPerm(Map<Long, String> caseId2Number, DynamicObject dy, long tarParentId) {
        long caseId = dy.getLong("case");
        IDNumberTreeNode tarParentNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)tarParentId);
        return String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\uff0c\u76ee\u6807\u7236\u7ea7\u7ec4\u7ec7%2$s\u65e0\u5199\u5165\u6743\u9650\u3002", (String)"InvCasePageDimLoadOrgService_15", (String)"fi-bcm-business", (Object[])new Object[0]), caseId2Number.get(caseId), tarParentNode.getNumber());
    }

    private Set<String> logSuccess(Map<Long, String> caseId2Number) {
        return this.newPageDims.stream().map(dy -> {
            long caseId = dy.getLong("case");
            long periodId = dy.getLong("period");
            IDNumberTreeNode srcPeriod = MemberReader.findPeriodMemberById((Long)this.modelId, (Long)periodId);
            return String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\uff0c%2$s\u6708\u53d8\u52a8\u7ec4\u7ec7\u83b7\u53d6\u6210\u529f\u3002", (String)"InvCasePageDimLoadOrgService_16", (String)"fi-bcm-business", (Object[])new Object[0]), caseId2Number.get(caseId), srcPeriod.getNumber());
        }).collect(Collectors.toSet());
    }

    private void analyzeEachPeriod(Long periodId, OrgBizTypeArrayModel orgBizTypeArrayModel) {
        if (orgBizTypeArrayModel == null) {
            return;
        }
        int effMonth = Integer.parseInt(MemberReader.findPeriodMemberById((String)this.ctx.getModelNum(), (Long)periodId).getProperty("effmonth").toString());
        List tarPeriods = this.scenePeriodIdSet.keySet().stream().filter(p -> Integer.parseInt(MemberReader.findPeriodMemberById((String)this.ctx.getModelNum(), (Long)p).getProperty("effmonth").toString()) > effMonth).collect(Collectors.toList());
        tarPeriods.add(periodId);
        HashMultimap changeTypeNumber2Org = HashMultimap.create();
        orgBizTypeArrayModel.forEachBizType((orgId, bizType) -> changeTypeNumber2Org.put(bizType, orgId));
        ArrayList parentControl = Lists.newArrayList((Object[])new InvCaseChangeTypeEnum[]{InvCaseChangeTypeEnum.DEALPARENT, InvCaseChangeTypeEnum.NEWPARENT});
        HashSet<String> deduplication = new HashSet<String>(16);
        for (DynamicObject caseObject : this.cases) {
            deduplication.clear();
            long caseId = caseObject.getLong("id");
            String chargeAgainst = caseObject.getString("chargeagainst");
            InvCaseChangeTypeEnum changeTypeEnum = InvCaseChangeTypeEnum.getByChangeType((String)caseObject.getString("changetype"));
            if (parentControl.contains(changeTypeEnum)) {
                orgBizTypeArrayModel.forEachSameControlPair(this.cslSchemeId, (disposalId, newlyAddId) -> {
                    block7: {
                        IDNumberTreeNode newlyAddNode;
                        IDNumberTreeNode disposalNode;
                        block6: {
                            disposalNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)disposalId);
                            newlyAddNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)newlyAddId);
                            if (disposalNode == IDNumberTreeNode.NotFoundTreeNode || newlyAddNode == IDNumberTreeNode.NotFoundTreeNode) {
                                return;
                            }
                            if (changeTypeEnum != InvCaseChangeTypeEnum.DEALPARENT) break block6;
                            IDNumberTreeNode srcNode = disposalNode;
                            String commonParentLongNum = this.pathCommonParentLongNumber(disposalNode.getLongNumber(), newlyAddNode.getLongNumber());
                            IDNumberTreeNode tarNode = MemberReader.findMemberByLongNumber((String)this.ctx.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)commonParentLongNum);
                            Date disposalDate = orgBizTypeArrayModel.getNoCurPeriodMap().get(disposalId);
                            HashSet<Long> srcPeriodIds = new HashSet<Long>(16);
                            if (disposalDate == null) {
                                srcPeriodIds.add(periodId);
                            } else {
                                this.scenePeriodIdSet.entrySet().stream().filter(p -> InvDynamicStockRatioHelper.isCurPeriod((Date[])p.getValue(), disposalDate)).forEach(p -> srcPeriodIds.add((Long)p.getKey()));
                            }
                            for (Long srcPeriodId : srcPeriodIds) {
                                if (tarNode == IDNumberTreeNode.NotFoundTreeNode || !deduplication.add(srcPeriodId + srcNode.getNumber().concat("_").concat(tarNode.getNumber()))) continue;
                                for (Long tarPeriod : tarPeriods) {
                                    this.newPageDims.add(this.createNewPageDim(caseId, "1".equals(chargeAgainst) ? tarPeriod : srcPeriodId, srcNode, tarPeriod, tarNode));
                                }
                            }
                            break block7;
                        }
                        IDNumberTreeNode srcNode = newlyAddNode;
                        String commonParentLongNum = this.pathCommonParentLongNumber(newlyAddNode.getLongNumber(), disposalNode.getLongNumber());
                        IDNumberTreeNode tarNode = MemberReader.findMemberByLongNumber((String)this.ctx.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)commonParentLongNum);
                        if (tarNode == IDNumberTreeNode.NotFoundTreeNode || !deduplication.add(periodId + srcNode.getNumber().concat("_").concat(tarNode.getNumber()))) break block7;
                        for (Long tarPeriod : tarPeriods) {
                            this.newPageDims.add(this.createNewPageDim(caseId, "1".equals(chargeAgainst) ? tarPeriod : periodId, srcNode, tarPeriod, tarNode));
                        }
                    }
                });
                continue;
            }
            for (Long dealOrg : changeTypeNumber2Org.get((Object)changeTypeEnum.getIndex())) {
                IDNumberTreeNode srcNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)"Entity", (long)dealOrg);
                if (srcNode == IDNumberTreeNode.NotFoundTreeNode || !deduplication.add(srcNode.getParent_SonNumber())) continue;
                for (Long tarPeriod : tarPeriods) {
                    this.newPageDims.add(this.createNewPageDim(caseId, "1".equals(chargeAgainst) ? tarPeriod : periodId, srcNode, tarPeriod, srcNode));
                }
            }
        }
    }

    private String pathCommonParentLongNumber(String longNumberTarget, String longNumberShare) {
        String[] orgTargetString = longNumberTarget.split("!");
        String[] orgShareString = longNumberShare.split("!");
        List<String> orgTargetList = Arrays.asList(orgTargetString);
        List<String> orgShareList = Arrays.asList(orgShareString);
        for (int i = orgTargetList.size() - 2; i >= 0; --i) {
            for (int j = orgShareList.size() - 2; j >= 0; --j) {
                if (!orgTargetList.get(i).equals(orgShareList.get(j))) continue;
                StringJoiner pathLongNumber = new StringJoiner("!");
                for (int k = 0; k < i + 2; ++k) {
                    pathLongNumber.add(orgTargetList.get(k));
                }
                return pathLongNumber.toString();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u65e0\u5171\u540c\u7236\u7ea7\u3002", (String)"InvCasePageDimLoadOrgService_17", (String)"fi-bcm-business", (Object[])new Object[0]), longNumberTarget, longNumberShare));
    }

    private void filterRelevantCaseFromDB(Consumer<QFilter> moreQFilter) {
        IDNumberTreeNode scenarioMemberNode = MemberReader.findScenaMemberById((Long)this.modelId, (Long)this.scenarioId);
        if (scenarioMemberNode == IDNumberTreeNode.NotFoundTreeNode) {
            this.cases = new LinkedList<DynamicObject>();
            return;
        }
        Long currentSce = scenarioMemberNode.getId();
        ArrayList parentIds = new ArrayList(4);
        this.findAllParent(scenarioMemberNode, (Consumer<IDNumberTreeNode>)((Consumer)parent -> parentIds.add(parent.getId())));
        ArrayList<Long> caseSuitable = new ArrayList<Long>(16);
        ArrayList<Long> caseIsExcept = new ArrayList<Long>(16);
        QFilter currentSceSetting = new QFilter("scenarios.scenariomeb", "in", (Object)currentSce);
        QFilter parentSceSetting = new QFilter("scenarios.scenariomeb", "in", parentIds).and("scenarios.scenarioscope", "=", (Object)String.valueOf(RangeEnum.VALUE_90.getValue()));
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        moreQFilter.accept((Object)filter);
        filter.and("distributeentry.cslscheme", "=", (Object)this.cslSchemeId);
        filter.and(currentSceSetting.or(parentSceSetting));
        String selectFields = "id,number,changetype,chargeagainst,scenarios.isexcept";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invchangecaseentity", (String)selectFields, (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> caseSuitableMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : query) {
            String string = dy.getString("scenarios.isexcept");
            long id = dy.getLong("id");
            if (PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode().equals(string)) {
                caseSuitable.add(id);
                caseSuitableMap.put(id, dy);
                continue;
            }
            caseIsExcept.add(id);
        }
        caseSuitable.removeAll(caseIsExcept);
        this.cases.addAll(caseSuitableMap.entrySet().stream().filter(entry -> caseSuitable.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    private void findAllParent(IDNumberTreeNode scenarioMemberNode, Consumer<IDNumberTreeNode> func) {
        IDNumberTreeNode parent = scenarioMemberNode.getParent();
        if (parent == null || parent == IDNumberTreeNode.NotFoundTreeNode || parent.getId() == 0L) {
            return;
        }
        func.accept((Object)parent);
        this.findAllParent(parent, func);
    }

    private void prepareOrgBizTypeList(String entityNumber) {
        Comparator<IDNumberTreeNode> expmonthComparator = Comparator.comparingInt(p -> Integer.parseInt(p.getProperty("expmonth").toString()));
        Comparator<IDNumberTreeNode> expdayComparator = Comparator.comparingInt(p -> Integer.parseInt(p.getProperty("expday").toString()));
        List periodSortedList = this.periodIds.stream().map(periodId -> MemberReader.findPeriodMemberById((String)this.ctx.getModelNum(), (Long)periodId)).sorted(expmonthComparator.thenComparing(expdayComparator)).collect(Collectors.toList());
        Date[] periodScope = PeriodUtils.calcStartAndEndDate((long)this.ctx.getModelId(), (long)this.ctx.getFyId(), (long)((IDNumberTreeNode)periodSortedList.get(periodSortedList.size() - 1)).getId());
        if (periodScope.length < 2) {
            return;
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)this.ctx.getModelId());
        qb.and("cslscheme", "=", (Object)this.cslSchemeId);
        qb.and("isexchangerate", "=", (Object)false);
        qb.and("status", "!=", (Object)"A");
        if (!StringUtils.isBlank((String)entityNumber)) {
            qb.and("number", "=", (Object)entityNumber);
        }
        qb.and("bizchangerds.changetype", "in", InvDynamicStockRatioHelper.resolveBizTypeScope(this.ctx.getModelId(), CHANGE_TYPES));
        qb.add("bizchangerds.bizeffdate", "<=", (Object)periodScope[1]);
        Set<String> bizSelectFieldSet = InvDynamicStockRatioHelper.getChangeTypeBizSelectField();
        bizSelectFieldSet.add(InvDynamicStockRatioHelper.getBizTypeScopeFieldStr(this.ctx.getModelId(), "bizchangerds.changetype", "relatedChangetype"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_entitymembertree", (String)String.join((CharSequence)",", bizSelectFieldSet), (QFilter[])qb.toArray(), null).orderBy(new String[]{"bizeffdate desc", "relatedChangetype asc"});){
            ds.forEachRemaining(bizType -> {
                for (OrgBizTypeArrayModel model : this.orgBizTypeArrayModelMap.values()) {
                    model.addOrgBizTypeRecord(bizType.getLong("id"), bizType.getString("changetype"), bizType.getDate("bizeffdate"));
                }
            });
        }
    }

    private DynamicObject createNewPageDim(Long caseId, Long periodId, IDNumberTreeNode srcOrgNode, Long tarPeriod, IDNumberTreeNode targetOrgNode) {
        DynamicObject tempObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invcasepagedim");
        tempObject.set("model", (Object)this.modelId);
        tempObject.set("scenario", (Object)this.scenarioId);
        tempObject.set("case", (Object)caseId);
        tempObject.set("year", (Object)this.yearId);
        tempObject.set("period", (Object)periodId);
        tempObject.set("tarperiod", (Object)tarPeriod);
        tempObject.set("org", (Object)srcOrgNode.getId());
        tempObject.set("tarorg", (Object)targetOrgNode.getId());
        tempObject.set("tarparentorg", (Object)targetOrgNode.getParent().getId());
        tempObject.set("tarorgnumber", (Object)targetOrgNode.getParent().getNumber());
        tempObject.set("status", (Object)InvCaseHandleRunStatusEnum.NOHANDLE.getIndex());
        tempObject.set("sourcetype", (Object)"1");
        tempObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        tempObject.set("modifydate", (Object)TimeServiceHelper.now());
        tempObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        tempObject.set("createdate", (Object)TimeServiceHelper.now());
        return tempObject;
    }

    private void queryUniqueKeyInDB() {
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and("scenario", "=", (Object)this.scenarioId);
        filter.and("year", "=", (Object)this.yearId);
        String selectFields = String.join((CharSequence)",", "org", "tarorg", "case", "period", "tarperiod");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_invcasepagedim", (String)selectFields, (QFilter[])filter.toArray());
        this.uniqueKeyInDB.addAll(query.stream().map(this::buildUniqueKey).collect(Collectors.toSet()));
    }

    private String buildUniqueKey(DynamicObject dynamicObject) {
        long srcOrgId = dynamicObject.getLong("org");
        IDNumberTreeNode srcOrgNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)srcOrgId);
        long tarOrgId = dynamicObject.getLong("tarorg");
        IDNumberTreeNode tarOrgNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)tarOrgId);
        String caseId = dynamicObject.getString("case");
        String periodId = dynamicObject.getString("period");
        String tarPeriodId = dynamicObject.getString("tarperiod");
        String srcOrgNumber = srcOrgNode.getNumber();
        String srcOrgPNumber = Optional.ofNullable(srcOrgNode.getParent()).map(IDNumberTreeNode::getNumber).orElseGet(() -> "");
        String tarOrgNumber = tarOrgNode.getNumber();
        return String.join((CharSequence)"&", caseId, periodId, tarPeriodId, srcOrgNumber, srcOrgPNumber, tarOrgNumber);
    }

    static enum CaseScopeEnum {
        ALL_CASE("1"),
        SELECTED("2");

        private String code;

        private CaseScopeEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

