/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.invest.changecase;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.changecase.InvCasePageDimService;
import kd.fi.bcm.business.invest.changecase.InvChangeHandleServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKFormulaStatusEnum;
import kd.fi.bcm.common.enums.invest.InvCaseHandleRunStatusEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.compress.utils.Lists;

public class InvCasePageDimRunService {
    private static final String SYSTEM_TYPE = "fi-bcm-business";
    private static final String ENTITY_NAME = "bcm_invcasepagedimrun";
    private static final String PAGE_DIM_ID = "pagedim_id";
    private static final String DIM_SPLIT = ",";
    private static final String FIELD_VALUE_SPLIT = "@";
    private ExecuteContext ctx;
    private static final String MODEL_NUMBER = "model";
    private static final String TARGET_ORG = "entity";
    private static final String SCENARIO = "scenario";
    private static final String YEAR = "year";
    private static final String TARGET_PERIOD = "period";
    private static final String SOURCE_DIM = "sourcedim";
    private static final String TARGET_DIM = "targetdim";
    public static final String COMPUTE_TYPE = "computetype";
    private static final String PAGE_DIM = "pagedim";
    private static final String[] commDim = new String[]{"model", "entity", "scenario", "year", "period"};

    public InvCasePageDimRunService(ExecuteContext ctx) {
        this.ctx = ctx;
    }

    public void doExecute(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> log, List<DynamicObject> allPageDimRun) {
        Map<Long, String> convertedAll = this.signalConverted(allPageDimRun);
        if (!allPageDimRun.isEmpty()) {
            this.runFromRecords(allPageDimRun, Collections.emptyList(), (Map)dimAndCase.p1, Boolean.TRUE, () -> this.buildDim2ScopeMapAndMemberScope(dimAndCase, allPageDimRun));
        }
        this.logConvertedResult(dimAndCase, log, convertedAll);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])allPageDimRun.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])log.toArray(new DynamicObject[0]));
                Collection dimPageObjects = ((Map)dimAndCase.p1).values();
                SaveServiceHelper.save((DynamicObject[])dimPageObjects.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public void doRecall(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> log, List<Long> pageIds) {
        ArrayList delLogIds = Lists.newArrayList();
        Map<Long, String> converted = this.recallOrReRunByPageDimIds(pageIds, (delIds, runLogs) -> {
            delLogIds.addAll(delIds);
            runLogs.removeIf(next -> delIds.contains(next.getLong("id")));
        });
        Collection dimPageObjects = ((Map)dimAndCase.p1).values();
        this.logConvertedResult(dimAndCase, log, converted);
        dimPageObjects.forEach(dy -> {
            DynamicObjectCollection dimScope = dy.getDynamicObjectCollection("dimscope");
            dimScope.clear();
        });
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)ENTITY_NAME), (Object[])delLogIds.toArray(new Long[0]));
                SaveServiceHelper.save((DynamicObject[])log.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])dimPageObjects.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public void reRunAfterMerge(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase) {
        HashSet<String> dealInfo = new HashSet<String>(16);
        Pair newDimAndCase = new Pair(new HashMap((Map)dimAndCase.p1), dimAndCase.p2);
        List<DynamicObject> logList = this.verifyChangeCase((Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>>)newDimAndCase, dealInfo, (dimPageObject, caseObject) -> null);
        List<Long> pageIds = this.getRecallPageDimIds((Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>>)newDimAndCase, logList);
        logList = this.verifyChangeCase(dimAndCase, dealInfo, (dimPageObject, caseObject) -> this.reRunCheck((Set<String>)dealInfo, (DynamicObject)dimPageObject, (DynamicObject)caseObject));
        List<DynamicObject> allPageDimRun = this.getPageDimRunLogDys(dimAndCase, logList);
        Map<Long, String> convertedAll = this.signalConverted(allPageDimRun);
        ArrayList delLogIds = Lists.newArrayList();
        DynamicObjectCollection recallObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)this.selectAll(), (QFilter[])new QFBuilder(PAGE_DIM, "in", pageIds).toArray());
        recallObjects.forEach(dy -> delLogIds.add(dy.getLong("id")));
        if (!allPageDimRun.isEmpty() || !recallObjects.isEmpty()) {
            this.runFromRecords(allPageDimRun, (Collection<DynamicObject>)recallObjects, (Map)newDimAndCase.p1, Boolean.FALSE, () -> this.buildDim2ScopeMapAndMemberScope(dimAndCase, allPageDimRun));
        }
        this.logConvertedResult(dimAndCase, logList, convertedAll);
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)ENTITY_NAME), (Object[])delLogIds.toArray(new Long[0]));
                SaveServiceHelper.save((DynamicObject[])allPageDimRun.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
                Collection dimPageObjects = ((Map)dimAndCase.p1).values();
                SaveServiceHelper.save((DynamicObject[])dimPageObjects.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public DynamicObject recallCheck(Set<String> dealInfo, DynamicObject dimPageObject, DynamicObject caseObject) {
        if (!InvCaseHandleRunStatusEnum.SUCCESS.getIndex().equals(dimPageObject.getString("status"))) {
            long dimPageId = dimPageObject.getLong("id");
            String msg = String.format(ResManager.loadKDString((String)"\u65b9\u6848%s\uff1a\u6e90[%1$s|%2$s] \u81f3 \u76ee\u6807[%3$s|%4$s]\u975e\u6267\u884c\u6210\u529f\u72b6\u6001\u3002", (String)"InvCasePageDimRunService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), InvCasePageDimService.getCaseNumber(dimPageObject), InvCasePageDimService.getSrcOrgNumber(dimPageObject), InvCasePageDimService.getSrcPeriodNumber(dimPageObject), dimPageObject.getString("tarorgnumber"), InvCasePageDimService.getTarPeriodNumber(dimPageObject));
            dealInfo.add(msg);
            return InvChangeHandleServiceHelper.buildLogDynamicObject(dimPageId, caseObject.getLong("id"), InvCaseHandleRunStatusEnum.FAIL, msg);
        }
        return null;
    }

    public DynamicObject executeCheck(Set<String> dealInfo, DynamicObject dimPageObject, DynamicObject caseObject) {
        long dimPageId = dimPageObject.getLong("id");
        if (InvCaseHandleRunStatusEnum.SUCCESS.getIndex().equals(dimPageObject.getString("status"))) {
            String msg = String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\uff1a\u6e90[%2$s|%3$s] \u81f3 \u76ee\u6807[%4$s|%5$s]\u5df2\u6267\u884c\u3002", (String)"InvCasePageDimRunService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), InvCasePageDimService.getCaseNumber(dimPageObject), InvCasePageDimService.getSrcOrgNumber(dimPageObject), InvCasePageDimService.getSrcPeriodNumber(dimPageObject), dimPageObject.getString("tarorgnumber"), InvCasePageDimService.getTarPeriodNumber(dimPageObject));
            dealInfo.add(msg);
            return InvChangeHandleServiceHelper.buildLogDynamicObject(dimPageId, caseObject.getLong("id"), InvCaseHandleRunStatusEnum.FAIL, msg);
        }
        return this.reRunCheck(dealInfo, dimPageObject, caseObject);
    }

    public List<DynamicObject> getPageDimRunLogDys(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> log) {
        Long modelId = (Long)this.ctx.getModel().getId();
        String scenarioNum = this.ctx.getScenario().number;
        String yearNum = this.ctx.getFy().number;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Iterator iterator = ((Map)dimAndCase.p1).entrySet().iterator();
        ArrayList allPageDimRun = Lists.newArrayList();
        block0: while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            DynamicObject dimPageObject = (DynamicObject)next.getValue();
            long dimPageId = dimPageObject.getLong("id");
            DynamicObject caseObject = (DynamicObject)((Map)dimAndCase.p2).get(next.getKey());
            DynamicObject[] entries = BusinessDataServiceHelper.load((String)"bcm_invchangecaseentry", (String)"invchangecase,computetype,sort,issinglemapentry,issinglemapentry.membid,issinglemapentry.dimid,issinglemapentry.dimnumber,issinglemapentry.memnumber,issinglemapentry.issrc", (QFilter[])new QFilter[]{new QFilter("invchangecase", "=", (Object)caseObject.getLong("id"))}, (String)"sort");
            ArrayList currentDimRun = Lists.newArrayList();
            for (DynamicObject entry : entries) {
                DynamicObject pageDimRun = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
                currentDimRun.add(pageDimRun);
                pageDimRun.set(MODEL_NUMBER, (Object)modelNum);
                pageDimRun.set(SCENARIO, (Object)scenarioNum);
                pageDimRun.set(YEAR, (Object)yearNum);
                pageDimRun.set(PAGE_DIM, (Object)dimPageObject);
                String computeType = entry.getString(COMPUTE_TYPE);
                pageDimRun.set(COMPUTE_TYPE, (Object)computeType);
                DynamicObjectCollection dimEntry = entry.getDynamicObjectCollection("issinglemapentry");
                List<DynamicObject> srcEntry = dimEntry.stream().filter(e -> e.getBoolean("issrc")).collect(Collectors.toList());
                List<DynamicObject> trgEntry = dimEntry.stream().filter(e -> !e.getBoolean("issrc")).collect(Collectors.toList());
                Map<String, IDNumberTreeNode> srcNodes = InvChangeHandleServiceHelper.tranEntryToNode(srcEntry, modelNum);
                Map<String, IDNumberTreeNode> trgNodes = InvChangeHandleServiceHelper.tranEntryToNode(trgEntry, modelNum);
                String tarProcess = "";
                String tarCurrency = "";
                String sourceCurrency = "";
                String sourceProcess = "";
                ArrayList sourceDim = Lists.newArrayList();
                ArrayList targetDim = Lists.newArrayList();
                for (Map.Entry<String, IDNumberTreeNode> stringIDNumberTreeNodeEntry : trgNodes.entrySet()) {
                    IDNumberTreeNode srcNode;
                    StringJoiner msg = this.checkDimDelete(stringIDNumberTreeNodeEntry, srcNode = srcNodes.get(stringIDNumberTreeNodeEntry.getKey()));
                    if (msg.length() != 0) {
                        dimPageObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        dimPageObject.set("modifydate", (Object)TimeServiceHelper.now());
                        Object sort = entry.get("sort");
                        String name = caseObject.getLocaleString("name").getLocaleValue();
                        Object number = caseObject.get("number");
                        log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(dimPageId, caseObject.getLong("id"), InvCaseHandleRunStatusEnum.FAIL, String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s(%2$s) \u7b2c%3$s\u884c\u914d\u7f6e\u7684%4$s\u5df2\u88ab\u7ef4\u5ea6\u5220\u9664,\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"InvCasePageDimRunService_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, name, sort, msg)));
                        continue block0;
                    }
                    if ("Currency".equals(stringIDNumberTreeNodeEntry.getKey())) {
                        tarCurrency = stringIDNumberTreeNodeEntry.getValue().getNumber();
                        if (Objects.isNull(srcNode) || srcNode == IDNumberTreeNode.NotFoundTreeNode) {
                            sourceCurrency = tarCurrency;
                            continue;
                        }
                        sourceCurrency = srcNode.getNumber();
                        continue;
                    }
                    if ("Process".equals(stringIDNumberTreeNodeEntry.getKey())) {
                        tarProcess = stringIDNumberTreeNodeEntry.getValue().getNumber();
                        sourceProcess = Objects.isNull(srcNode) || srcNode == IDNumberTreeNode.NotFoundTreeNode ? tarProcess : srcNode.getNumber();
                    }
                    targetDim.add(stringIDNumberTreeNodeEntry.getKey() + FIELD_VALUE_SPLIT + stringIDNumberTreeNodeEntry.getValue().getNumber());
                    sourceDim.add(stringIDNumberTreeNodeEntry.getKey() + FIELD_VALUE_SPLIT + (srcNode == null ? stringIDNumberTreeNodeEntry.getValue().getNumber() : srcNode.getNumber()));
                }
                String tarOrgNumber = TransMemberUtil.isSpecialEntity(tarProcess) ? InvCasePageDimService.getTarParentOrgNumber(dimPageObject) + "_" + InvCasePageDimService.getTarOrgNumber(dimPageObject) : InvCasePageDimService.getTarParentOrgNumber(dimPageObject);
                pageDimRun.set(TARGET_ORG, (Object)tarOrgNumber);
                pageDimRun.set(TARGET_PERIOD, (Object)InvCasePageDimService.getTarPeriodNumber(dimPageObject));
                sourceDim.add("Period@" + InvCasePageDimService.getSrcPeriodNumber(dimPageObject));
                Long tarOrgId = InvCasePageDimService.getTarOrgId(dimPageObject);
                tarCurrency = InvChangeHandleServiceHelper.tranCurrency(modelNum, tarOrgId, tarCurrency, tarProcess);
                Long srcOrgId = InvCasePageDimService.getSrcOrgId(dimPageObject);
                sourceCurrency = InvChangeHandleServiceHelper.tranCurrency(modelNum, srcOrgId, sourceCurrency, sourceProcess);
                IDNumberTreeNode entityMemberById = MemberReader.findEntityMemberById((Long)modelId, (Long)srcOrgId);
                String srcOrgNumber = InvCasePageDimService.getSrcOrgNumber(dimPageObject);
                srcOrgNumber = TransMemberUtil.isSpecialEntity(sourceProcess) ? entityMemberById.getParent_SonNumber() : srcOrgNumber;
                sourceDim.add("Entity@" + srcOrgNumber);
                targetDim.add("Currency@" + tarCurrency);
                sourceDim.add("Currency@" + sourceCurrency);
                pageDimRun.set(SOURCE_DIM, (Object)String.join((CharSequence)DIM_SPLIT, sourceDim));
                pageDimRun.set(TARGET_DIM, (Object)String.join((CharSequence)DIM_SPLIT, targetDim));
            }
            allPageDimRun.addAll(currentDimRun);
            dimPageObject.set("status", (Object)InvCaseHandleRunStatusEnum.SUCCESS.getIndex());
            dimPageObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dimPageObject.set("modifydate", (Object)TimeServiceHelper.now());
            log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(dimPageId, caseObject.getLong("id"), InvCaseHandleRunStatusEnum.SUCCESS, ""));
        }
        return allPageDimRun;
    }

    private StringJoiner checkDimDelete(Map.Entry<String, IDNumberTreeNode> stringIDNumberTreeNodeEntry, IDNumberTreeNode srcNode) {
        String s;
        StringJoiner msg = new StringJoiner("\u3001");
        if (stringIDNumberTreeNodeEntry.getValue() == IDNumberTreeNode.NotFoundTreeNode) {
            s = ResManager.loadKDString((String)"\u76ee\u6807\uff1a%1$s", (String)"InvCasePageDimRunService_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            msg.add(String.format(s, stringIDNumberTreeNodeEntry.getKey()));
        }
        if (srcNode == IDNumberTreeNode.NotFoundTreeNode) {
            s = ResManager.loadKDString((String)"\u6e90\uff1a%1$s", (String)"InvCasePageDimRunService_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            msg.add(String.format(s, stringIDNumberTreeNodeEntry.getKey()));
        }
        return msg;
    }

    public List<DynamicObject> verifyChangeCase(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, Set<String> dealInfo, BinaryOperator<DynamicObject> otherCheck) {
        Long modelId = (Long)this.ctx.getModel().id;
        ArrayList log = Lists.newArrayList();
        Map<Long, List<Long>> versionOrgMap = this.pickVersionOrgIds(dimAndCase);
        Iterator iterator = ((Map)dimAndCase.p1).entrySet().iterator();
        while (iterator.hasNext()) {
            String msg;
            String msg2;
            String msg3;
            Map.Entry next = iterator.next();
            DynamicObject dimPageObject = (DynamicObject)next.getValue();
            long pk = dimPageObject.getLong("id");
            DynamicObject caseObject = (DynamicObject)((Map)dimAndCase.p2).get(next.getKey());
            long tarPeriodId = InvCasePageDimService.getTarPeriodId(dimPageObject);
            long tarParentOrgId = InvCasePageDimService.getTarParentOrgId(dimPageObject);
            long srcPeriodId = InvCasePageDimService.getSrcPeriodId(dimPageObject);
            long srcOrgId = InvCasePageDimService.getSrcOrgId(dimPageObject);
            long caseId = caseObject.getLong("id");
            long scenarioId = InvCasePageDimService.getScenarioId(dimPageObject);
            long yearId = InvCasePageDimService.getYearId(dimPageObject);
            if (!((List)versionOrgMap.getOrDefault(tarPeriodId, new ArrayList())).contains(tarParentOrgId)) {
                msg3 = ResManager.loadKDString((String)"\u76ee\u6807\u7ec4\u7ec7\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                dealInfo.add(msg3);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg3));
                iterator.remove();
                continue;
            }
            if (!((List)versionOrgMap.getOrDefault(srcPeriodId, new ArrayList())).contains(srcOrgId)) {
                msg3 = ResManager.loadKDString((String)"\u6e90\u7ec4\u7ec7\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                dealInfo.add(msg3);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg3));
                iterator.remove();
                continue;
            }
            DynamicObject tarParentOrg = dimPageObject.getDynamicObject("tarparentorg");
            DynamicObject tarOrg = dimPageObject.getDynamicObject("tarorg");
            String tarParentOrgNumber = tarParentOrg.getString("number");
            String tarOrgNumber = tarOrg.getString("number");
            String tarPeriodNumber = InvCasePageDimService.getTarPeriodNumber(dimPageObject);
            if (!PeriodSettingHelper.checkPeriodStatus(modelId, tarParentOrgNumber, scenarioId, yearId, tarPeriodId, "datastatus")) {
                msg2 = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u6570\u636e\u671f\u95f4%2$s\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), tarParentOrgNumber, tarPeriodNumber);
                dealInfo.add(msg2);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg2));
                iterator.remove();
                continue;
            }
            if (!PeriodSettingHelper.checkPeriodStatus(modelId, tarOrgNumber, scenarioId, yearId, tarPeriodId, "datastatus")) {
                msg2 = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u6570\u636e\u671f\u95f4%2$s\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), tarOrgNumber, tarPeriodNumber);
                dealInfo.add(msg2);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg2));
                iterator.remove();
                continue;
            }
            McStatus mcStatus = McStatus.getMcStatus(modelId, tarParentOrgId, scenarioId, yearId, tarPeriodId);
            if (mcStatus.getArchive().isArchive()) {
                msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u53ef\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), tarParentOrgNumber);
                dealInfo.add(msg);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg));
                iterator.remove();
                continue;
            }
            if (mcStatus.getFlow().isSubmit()) {
                msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684\u9ed8\u8ba4\u5e01\u62a5\u8868\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u4e0d\u53ef\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), tarParentOrgNumber);
                dealInfo.add(msg);
                log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.FAIL, msg));
                iterator.remove();
                continue;
            }
            DynamicObject result = (DynamicObject)otherCheck.apply(dimPageObject, caseObject);
            if (!Objects.nonNull(result)) continue;
            iterator.remove();
            log.add(result);
        }
        return log;
    }

    public List<Long> getRecallPageDimIds(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> log) {
        ArrayList pageIds = Lists.newArrayList();
        Long modelId = (Long)this.ctx.getModel().id;
        for (Map.Entry next : ((Map)dimAndCase.p1).entrySet()) {
            DynamicObject dimPageObject = (DynamicObject)next.getValue();
            long pageId = dimPageObject.getLong("id");
            if (modelId != InvCasePageDimService.getModelId(dimPageObject)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u64a4\u56de\u7684\u4f53\u7cfb\u548c\u5f53\u524d\u7684\u4f53\u7cfb\u4e0d\u540c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvCasePageDimRunService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            pageIds.add(pageId);
            dimPageObject.set("status", (Object)InvCaseHandleRunStatusEnum.RECALL.getIndex());
            dimPageObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dimPageObject.set("modifydate", (Object)TimeServiceHelper.now());
            log.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pageId, InvCasePageDimService.getCaseId(dimPageObject), InvCaseHandleRunStatusEnum.RECALL, ""));
        }
        return pageIds;
    }

    private Map<Long, String> recallOrReRunByPageDimIds(Collection<Long> pageDimIds, BiConsumer<List<Long>, DynamicObjectCollection> recallOrReRunAction) {
        DynamicObjectCollection recallObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)this.selectAll(), (QFilter[])new QFBuilder(PAGE_DIM, "in", pageDimIds).toArray());
        ArrayList ids = new ArrayList(recallObjects.size());
        Map<String, List<DynamicObject>> collect = recallObjects.stream().peek(dy -> ids.add(dy.getLong("id"))).collect(Collectors.groupingBy(dy -> {
            StringJoiner joiner = new StringJoiner("_");
            for (String dim : commDim) {
                joiner.add(dy.getString(dim));
            }
            return joiner.toString();
        }));
        QFBuilder qfBuilder = null;
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : collect.entrySet()) {
            DynamicObject dynamicObject2 = stringListEntry.getValue().get(0);
            QFBuilder group = new QFBuilder();
            for (String dim : commDim) {
                group.and(dim, "=", (Object)dynamicObject2.getString(dim));
            }
            if (qfBuilder == null) {
                qfBuilder = group;
                continue;
            }
            qfBuilder.or(group);
        }
        if (qfBuilder == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection runObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)this.selectAll(), (QFilter[])qfBuilder.toArray());
        List allPageDims = runObjects.stream().map(dynamicObject -> dynamicObject.getLong(PAGE_DIM)).collect(Collectors.toList());
        Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase = InvChangeHandleServiceHelper.getDim2CaseMap(allPageDims.toArray());
        recallOrReRunAction.accept(ids, runObjects);
        if (runObjects.isEmpty() && recallObjects.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, String> convertedRun = this.signalConverted((List<DynamicObject>)runObjects);
        Map<Long, String> convertedRecall = this.signalConverted((List<DynamicObject>)recallObjects);
        this.runFromRecords((Collection<DynamicObject>)runObjects, (Collection<DynamicObject>)recallObjects, (Map)dimAndCase.p1, Boolean.FALSE, () -> this.buildDim2ScopeMapAndDelMemberScope((Collection<DynamicObject>)runObjects, (Map)dimAndCase.p1));
        return this.buildResult(convertedRun, convertedRecall, pageDimIds);
    }

    private Map<Long, List<Long>> pickVersionOrgIds(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase) {
        HashMap<Long, List<DynamicObject>> periodGroup = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry entry : ((Map)dimAndCase.p1).entrySet()) {
            DynamicObject dimPageObject = (DynamicObject)entry.getValue();
            long srcPeriodId = InvCasePageDimService.getSrcPeriodId(dimPageObject);
            DynamicObject org = dimPageObject.getDynamicObject("org");
            this.putOrg2Group(periodGroup, srcPeriodId, org);
            long tarPeriodId = InvCasePageDimService.getTarPeriodId(dimPageObject);
            DynamicObject parentOrg = dimPageObject.getDynamicObject("tarparentorg");
            this.putOrg2Group(periodGroup, tarPeriodId, parentOrg);
        }
        HashMap<Long, List<Long>> versionOrgMap = new HashMap<Long, List<Long>>(periodGroup.size());
        periodGroup.forEach((periodId, list) -> {
            FilterOrgStructParam orgParam = new FilterOrgStructParam((long)((Long)this.ctx.getModel().getId()), (long)((Long)this.ctx.getScenario().getId()), (Long)this.ctx.getFy().getId(), (long)periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(orgParam, list);
            List versionOrgIds = list.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            versionOrgMap.put((Long)periodId, versionOrgIds);
        });
        return versionOrgMap;
    }

    private void putOrg2Group(Map<Long, List<DynamicObject>> periodGroup, long srcPeriodId, DynamicObject org) {
        if (Objects.nonNull(org)) {
            List list = periodGroup.computeIfAbsent(srcPeriodId, v -> new ArrayList());
            list.add(org);
        }
    }

    private DynamicObject reRunCheck(Set<String> dealInfo, DynamicObject dimPageObject, DynamicObject caseObject) {
        long dimPageId = dimPageObject.getLong("id");
        if (caseObject.getString("status").equals(CHKFormulaStatusEnum.disable.getIndex())) {
            String msg = String.format(ResManager.loadKDString((String)"\u65b9\u6848%1$s\u672a\u542f\u7528\uff0c\u4e0d\u53ef\u6267\u884c\u64cd\u4f5c\u3002", (String)"InvCasePageDimRunService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), caseObject.getString("number"));
            dealInfo.add(msg);
            return InvChangeHandleServiceHelper.buildLogDynamicObject(dimPageId, caseObject.getLong("id"), InvCaseHandleRunStatusEnum.FAIL, msg);
        }
        return null;
    }

    private void runFromRecords(Collection<DynamicObject> runObjects, Collection<DynamicObject> recallObjects, Map<Long, DynamicObject> pageDims, boolean isIncrement, Supplier<Map<Long, List<String>>> dimPage2ScopeRunSupplier) {
        long modelId = (Long)this.ctx.getModel().getId();
        AnalysisParam analysisParam = new AnalysisParam(modelId, !runObjects.isEmpty() ? runObjects : recallObjects);
        Map<Long, List<String>> dimPage2ScopeRecall = this.buildDim2ScopeMapAndDelMemberScope(recallObjects, pageDims);
        recallObjects.forEach(dy -> {
            long pageDimId = dy.getLong(PAGE_DIM_ID);
            this.recallOneRecord(analysisParam, (DynamicObject)dy, dimPage2ScopeRecall.getOrDefault(pageDimId, Collections.emptyList()));
        });
        Map<Long, List<String>> dimPage2ScopeRun = dimPage2ScopeRunSupplier.get();
        runObjects.forEach(dy -> {
            long pageDimId = dy.getLong(PAGE_DIM_ID);
            this.analysisOneRecord(analysisParam, (DynamicObject)dy, dimPage2ScopeRun.getOrDefault(pageDimId, Collections.emptyList()), (computeType, mdResultSet) -> mdResultSet.getRow().getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()).multiply(new BigDecimal(computeType.trim())));
        });
        CellSet cellSets = analysisParam.cellSets;
        SaveCommandInfo info = new SaveCommandInfo();
        String modelNumber = analysisParam.modelNumber;
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        info.setDimensions(analysisParam.dimKeys);
        info.setIncrement(isIncrement);
        OlapCommandUtil.addSourceMeasure((String)modelNumber, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.S5);
        OlapServiceHelper.saveData(info, cellSets, modelNumber);
    }

    private Map<Long, List<String>> buildDim2ScopeMapAndDelMemberScope(Collection<DynamicObject> recallObjects, Map<Long, DynamicObject> pageDims) {
        HashMap<Long, List<String>> dimPage2Scope = new HashMap<Long, List<String>>(16);
        for (DynamicObject recallObject : recallObjects) {
            long pageDimId = recallObject.getLong(PAGE_DIM_ID);
            DynamicObject pageDimDy = pageDims.get(pageDimId);
            DynamicObjectCollection dimMemNumberDys = pageDimDy.getDynamicObjectCollection("dimscope");
            dimMemNumberDys.forEach(dimMemNumbers -> {
                String dimMemZip = dimMemNumbers.getString("memnumbers");
                String dimMemUncompress = ObjectSerialUtil.uncompress4GZip((String)dimMemZip);
                ArrayList dimMemNumberList = com.google.common.collect.Lists.newArrayList((Object[])dimMemUncompress.split(";"));
                dimPage2Scope.putIfAbsent(pageDimId, dimMemNumberList);
            });
            dimMemNumberDys.clear();
        }
        return dimPage2Scope;
    }

    private Map<Long, List<String>> buildDim2ScopeMapAndMemberScope(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> allPageDimRun) {
        Set<Long> pageDimIdsRun = allPageDimRun.stream().map(dy -> dy.getLong(PAGE_DIM_ID)).collect(Collectors.toSet());
        return this.buildDim2ScopeMapAndMemberScope(dimAndCase, pageDimIdsRun, (Long)this.ctx.getModel().getId());
    }

    private Map<Long, List<String>> buildDim2ScopeMapAndMemberScope(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, Set<Long> pageDimIdsRun, long modelId) {
        HashMap<Long, List<String>> dimPage2Scope = new HashMap<Long, List<String>>(16);
        HashMap case2Scope = new HashMap(16);
        pageDimIdsRun.forEach(pageDimId -> {
            DynamicObject pageDimDy = (DynamicObject)((Map)dimAndCase.p1).get(pageDimId);
            DynamicObject caseDy = (DynamicObject)((Map)dimAndCase.p2).get(pageDimId);
            DynamicObjectCollection dimScopePages = pageDimDy.getDynamicObjectCollection("dimscope");
            dimScopePages.clear();
            long caseId = caseDy.getLong("id");
            DynamicObjectCollection dimScopeCase = caseDy.getDynamicObjectCollection("dimscope");
            if (!case2Scope.containsKey(caseId)) {
                ArrayList scopeNumbers = new ArrayList();
                dimScopeCase.stream().forEach(scope -> {
                    long memberId = scope.getLong("memberid");
                    int scopeValue = scope.getInt("scope");
                    this.fillScopeNumber(modelId, scopeNumbers, memberId, scopeValue);
                });
                case2Scope.put(caseId, scopeNumbers);
            }
            List memNumberList = (List)case2Scope.get(caseId);
            dimPage2Scope.put((Long)pageDimId, memNumberList);
            if (!memNumberList.isEmpty()) {
                Object dimension = dimScopeCase.stream().findFirst().map(scope -> scope.get("dimension")).get();
                DynamicObject newMember = dimScopePages.addNew();
                newMember.set("dimension", dimension);
                String memNumbers = String.join((CharSequence)";", memNumberList);
                newMember.set("memnumbers", (Object)ObjectSerialUtil.compress4GZip((String)memNumbers));
            }
        });
        return dimPage2Scope;
    }

    private void fillScopeNumber(long modelId, List<String> scopeNumbers, long memberId, int scopeValue) {
        String entityNum = DimEntityNumEnum.ACCOUNT.getEntityNum();
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)entityNum, (String)"id,number,longnumber");
        new MembRangeItem(entityNum, (Long)memberId, member.getString("number"), RangeEnum.getRangeByVal((int)scopeValue), false, (Object)modelId).matchItems(c -> scopeNumbers.add(c.number));
    }

    private void analysisOneRecord(AnalysisParam analysisParam, DynamicObject dynamicObject, List<String> scopeNumbers, BiFunction<String, MDResultSet, BigDecimal> getMoney) {
        String[] targetDimSplit;
        String[] sourceDimSplit;
        String computeType = dynamicObject.getString(COMPUTE_TYPE);
        String keyEntity = "Entity";
        String targetEntity = dynamicObject.getString(TARGET_ORG);
        String keyPeriodDimensionNum = "Period";
        String targetPeriod = dynamicObject.getString(TARGET_PERIOD);
        String sourceDim = dynamicObject.getString(SOURCE_DIM);
        String targetDim = dynamicObject.getString(TARGET_DIM);
        SQLBuilder sql = new SQLBuilder(analysisParam.modelNumber);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.setIncludeNull(false);
        sql.addSelectField(analysisParam.dimKeys);
        for (String string : sourceDimSplit = sourceDim.split(DIM_SPLIT)) {
            String[] keyAndNumber = string.split(FIELD_VALUE_SPLIT);
            sql.addFilter(keyAndNumber[0], keyAndNumber[1]);
        }
        sql.addFilter("Scenario", dynamicObject.getString(SCENARIO));
        sql.addFilter("Year", dynamicObject.getString(YEAR));
        if (!scopeNumbers.isEmpty()) {
            sql.addFilter("Account", scopeNumbers.toArray(new String[0]));
        }
        MDResultSet mdResultSet = OlapServiceHelper.queryData(sql);
        HashMap<String, String> targetDim2Member = new HashMap<String, String>(16);
        targetDim2Member.put(keyEntity, targetEntity);
        targetDim2Member.put(keyPeriodDimensionNum, targetPeriod);
        for (String oneDim : targetDimSplit = targetDim.split(DIM_SPLIT)) {
            String[] keyAndNumber = oneDim.split(FIELD_VALUE_SPLIT);
            targetDim2Member.put(keyAndNumber[0], keyAndNumber[1]);
        }
        while (mdResultSet.next()) {
            CellSet cellSet = analysisParam.cellSets;
            String[] dimKeys = analysisParam.dimKeys;
            Long modelId = analysisParam.modelId;
            Object[] memberValues = new String[dimKeys.length];
            String[] srcMemberValues = new String[dimKeys.length];
            for (int i = 0; i < dimKeys.length; ++i) {
                String srcMemberNumber;
                String memberConfig = (String)targetDim2Member.get(dimKeys[i]);
                srcMemberValues[i] = srcMemberNumber = mdResultSet.getString(dimKeys[i]);
                memberValues[i] = Objects.nonNull(memberConfig) ? memberConfig : srcMemberNumber;
            }
            Object originalValue = mdResultSet.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
            BigDecimal changeMoney = null;
            if (!this.isNotNumberDataType(dimKeys, modelId, srcMemberValues) && originalValue instanceof Number) {
                changeMoney = getMoney.apply(computeType, mdResultSet);
            }
            BigDecimal money = (BigDecimal)cellSet.get(memberValues);
            BigDecimal finalMoney = this.getFinalMoney(money, changeMoney);
            if (this.isNotNumberDataType(dimKeys, modelId, (String[])memberValues)) continue;
            cellSet.set((String[])memberValues, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)finalMoney);
        }
    }

    private void recallOneRecord(AnalysisParam analysisParam, DynamicObject dynamicObject, List<String> scopeNumbers) {
        String[] sourceDimSplit;
        SQLBuilder sql = new SQLBuilder(analysisParam.modelNumber);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.setIncludeNull(false);
        sql.addSelectField(analysisParam.dimKeys);
        sql.addFilter("Entity", dynamicObject.getString(TARGET_ORG));
        sql.addFilter("Scenario", dynamicObject.getString(SCENARIO));
        sql.addFilter("Year", dynamicObject.getString(YEAR));
        sql.addFilter("Period", dynamicObject.getString(TARGET_PERIOD));
        String targetDim = dynamicObject.getString(TARGET_DIM);
        for (String oneDim : sourceDimSplit = targetDim.split(DIM_SPLIT)) {
            String[] keyAndNumber = oneDim.split(FIELD_VALUE_SPLIT);
            sql.addFilter(keyAndNumber[0], keyAndNumber[1]);
        }
        if (!scopeNumbers.isEmpty()) {
            sql.addFilter("Account", scopeNumbers.toArray(new String[0]));
        }
        MDResultSet mdResultSet = OlapServiceHelper.queryData(sql);
        while (mdResultSet.next()) {
            CellSet cellSets = analysisParam.cellSets;
            String[] dimKeys = analysisParam.dimKeys;
            String[] memberValues = new String[dimKeys.length];
            for (int i = 0; i < dimKeys.length; ++i) {
                String memberNumber;
                memberValues[i] = memberNumber = mdResultSet.getString(dimKeys[i]);
            }
            cellSets.set(memberValues, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
        }
    }

    private boolean isNotNumberDataType(String[] dimKeys, Long modelId, String[] memberValues) {
        Map<String, DataTypeEnum> dataTypeCache = InvCasePageDimRunService.getDataTypeCache(modelId, Arrays.asList(dimKeys));
        for (int i = 0; i < dimKeys.length; ++i) {
            String key = dimKeys[i] + "_" + memberValues[i];
            DataTypeEnum dataTypeEnum = dataTypeCache.get(key);
            if (!Objects.nonNull(dataTypeEnum) || !dataTypeEnum.getOIndex().equals(DataTypeEnum.TXT.getOIndex()) && !dataTypeEnum.getOIndex().equals(DataTypeEnum.DATETP.getOIndex()) && !dataTypeEnum.getOIndex().equals(DataTypeEnum.PROPORTION.getOIndex()) && !dataTypeEnum.getOIndex().equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, DataTypeEnum> getDataTypeCache(Long modelId, List<String> dims) {
        HashMap<String, DataTypeEnum> dataTypeCache = new HashMap<String, DataTypeEnum>();
        for (String dim : dims) {
            if (!DataTypeEnum.getDataTypePerSetDims((Object)modelId).contains(dim) && !ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dim).equals("bcm_userdefinedmembertree")) continue;
            Map dataTypeMap = MemberReader.getMemberDataType((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dim), (String)dim);
            dataTypeCache.putAll(dataTypeMap);
        }
        return dataTypeCache;
    }

    private String selectAll() {
        StringJoiner selectProp = new StringJoiner(DIM_SPLIT);
        MetadataServiceHelper.getDataEntityType((String)ENTITY_NAME).getProperties().forEach(field -> selectProp.add(field.getName()));
        return selectProp.toString();
    }

    private BigDecimal getFinalMoney(BigDecimal money, BigDecimal changeMoney) {
        if (Objects.isNull(money) && Objects.nonNull(changeMoney)) {
            return changeMoney;
        }
        if (Objects.nonNull(money) && Objects.nonNull(changeMoney)) {
            return money.add(changeMoney);
        }
        return money;
    }

    private Map<Long, String> signalConverted(List<DynamicObject> pageDimRun) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : pageDimRun) {
            String[] dimMem2Num;
            String orgNum = null;
            String tarCurrency = null;
            String process = null;
            String period = null;
            long pk = this.pageDimFromRunLog(dynamicObject);
            String modelNum = dynamicObject.getString(MODEL_NUMBER);
            String scenarioNum = dynamicObject.getString(SCENARIO);
            String yearNum = dynamicObject.getString(YEAR);
            String sourceDim = dynamicObject.getString(SOURCE_DIM);
            for (String s : dimMem2Num = sourceDim.split(DIM_SPLIT)) {
                String[] split;
                if (s.startsWith("Entity")) {
                    split = s.split(FIELD_VALUE_SPLIT);
                    orgNum = split[1];
                }
                if (s.startsWith("Currency")) {
                    split = s.split(FIELD_VALUE_SPLIT);
                    tarCurrency = split[1];
                }
                if (s.startsWith("Process")) {
                    split = s.split(FIELD_VALUE_SPLIT);
                    process = split[1];
                }
                if (!s.startsWith("Period")) continue;
                split = s.split(FIELD_VALUE_SPLIT);
                period = split[1];
            }
            Set<String> rs = ConvertServiceHelper.convert4ProcessSpilt(MemberReader.findModelIdByNum((String)modelNum), scenarioNum, yearNum, period, orgNum, process, tarCurrency, false);
            if (rs.isEmpty()) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7+\u671f\u95f4+\u8fc7\u7a0b\uff08%1$s+%2$s+%3$s\uff09:%4$s", (String)"InvCasePageDimRunService_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgNum, period, process, String.join((CharSequence)"|", rs));
            resultMap.compute(pk, (k, v) -> {
                if (v == null) {
                    return msg;
                }
                return String.join((CharSequence)"\u3001", msg, v);
            });
        }
        return resultMap;
    }

    private long pageDimFromRunLog(DynamicObject dynamicObject) {
        Object dimPage = dynamicObject.get(PAGE_DIM);
        if (dimPage instanceof DynamicObject) {
            return ((DynamicObject)dimPage).getLong("id");
        }
        return (Long)dimPage;
    }

    private void logConvertedResult(Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dimAndCase, List<DynamicObject> logs, Map<Long, String> convertedResult) {
        Map<Long, DynamicObject> id2LogDy = logs.stream().collect(Collectors.toMap(dy -> dy.getLong("casepagedim"), dy -> dy, (v1, v2) -> v1));
        for (Map.Entry next : ((Map)dimAndCase.p1).entrySet()) {
            DynamicObject dimPageObject = (DynamicObject)next.getValue();
            long pk = dimPageObject.getLong("id");
            if (!convertedResult.containsKey(pk)) continue;
            DynamicObject caseObject = (DynamicObject)((Map)dimAndCase.p2).get(next.getKey());
            long caseId = caseObject.getLong("id");
            DynamicObject dynamicObject = id2LogDy.get(pk);
            if (dynamicObject == null) {
                logs.add(InvChangeHandleServiceHelper.buildLogDynamicObject(pk, caseId, InvCaseHandleRunStatusEnum.RUN_CONVERTED_FAIL, convertedResult.get(pk)));
                continue;
            }
            InvCaseHandleRunStatusEnum status = InvCaseHandleRunStatusEnum.SUCCESS.getIndex().equals(dynamicObject.getString("status")) ? InvCaseHandleRunStatusEnum.RUN_CONVERTED_FAIL : InvCaseHandleRunStatusEnum.RECALL_CONVERTED_FAIL;
            dynamicObject.set("status", (Object)status.getIndex());
            dynamicObject.set("reason", (Object)convertedResult.get(pk));
        }
    }

    private Map<Long, String> buildResult(Map<Long, String> convertedRunResult, Map<Long, String> convertedRecallResult, Collection<Long> pageDimIds) {
        if (convertedRunResult.isEmpty()) {
            return convertedRecallResult;
        }
        String msg = convertedRunResult.entrySet().stream().map(entry -> ((Long)entry.getKey()).toString() + ":" + (String)entry.getValue()).collect(Collectors.joining(";"));
        HashMap<Long, String> result = new HashMap<Long, String>(pageDimIds.size());
        for (Long pageDimId : pageDimIds) {
            String recallResult = convertedRecallResult.get(pageDimId);
            String finalMsg = recallResult == null ? msg : String.join((CharSequence)";", recallResult, msg);
            result.put(pageDimId, finalMsg);
        }
        return result;
    }

    private static class AnalysisParam {
        private String[] dimKeys;
        private CellSet cellSets;
        private String modelNumber;
        private Long modelId;

        public AnalysisParam(long modelId, Collection<DynamicObject> runObjects) {
            this.modelId = modelId;
            Map<String, String> dimensionNumMap = DimensionServiceHelper.getDimensionNumMapped(modelId);
            this.dimKeys = dimensionNumMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()).toArray(new String[0]);
            this.cellSets = new CellSet(this.dimKeys, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            this.cellSets.setFromQuery(false);
            runObjects.stream().findFirst().ifPresent(runObject -> {
                this.modelNumber = runObject.getString(InvCasePageDimRunService.MODEL_NUMBER);
            });
        }
    }
}

